library KillCopy;

(*
Description: Packer plug-in interface to KillCopy for Total Commander
Author: Kovcs Endre Jnos
E-Mail: kovacsendre@coder.hu

TODO: filter file list. KillCopy copies folders recursively
*)

uses
  Messages,
  Windows;

{$E wcx}

{$I wcx.inc}

const
  szKCKey = 'SOFTWARE\KILLSOFT\KillCopy';

var
  AppPath: String;
  PackerChangeVolProc:TChangeVolProc;
  PackerProcessDataProc:TProcessDataProc;

function StrEnd(const Str: PChar): PChar; assembler;
(* clipped from Borland's SysUtils.pas to reduce code size *)
asm
        MOV     EDX,EDI
        MOV     EDI,EAX
        MOV     ECX,0FFFFFFFFH
        XOR     AL,AL
        REPNE   SCASB
        LEA     EAX,[EDI-1]
        MOV     EDI,EDX
end;

function ExtractFilePath(const FileName: string): string;
var
  i: Integer;
begin
  i := Length(FileName);
  while i > 0 do begin
    if (FileName[i] = '\') or (FileName[i] = ':') then Break;
    dec(i)
  end;

  if i > 0 then
    Result := Copy(FileName, 1, i)
  else
    Result := '';
end;

function ExpandEnvStrings(const Str: string): string;
var
  Len: integer;
begin
  Result := '';
  Len := ExpandEnvironmentStrings(PChar(Str), nil, 0);
  if Len > 0 then
  begin
    SetLength(Result, Len - 1);
    ExpandEnvironmentStrings(PChar(Str), PChar(Result), Len);
  end;
end;

function GetRegString(const KeyName, ValueName: string; RootKey: DWord = HKEY_CLASSES_ROOT): String;
var
  Key: HKey;
  StrLen: Integer;
  Buffer: array[0..1023] of Char;
begin
  Result := '';
  if RegOpenKeyEx(RootKey,PChar(KeyName),0,KEY_READ,Key) = ERROR_SUCCESS then begin
    StrLen := SizeOf(Buffer);
    if RegQueryValueEx(Key, PAnsiChar(ValueName), nil, nil, @Buffer, @StrLen) = ERROR_SUCCESS then
      Result := Buffer;
    RegCloseKey(Key);
  end
end;

function GetSystemDir: String;
var
  Buf: array[0..MAX_PATH] of Char;
begin
  GetSystemDirectory(Buf, SizeOf(Buf));
  Result := Buf;
end;

function GetTempName: String;
var
  TempPath, TempName: array[0..MAX_PATH] of Char;
begin
  GetTempPath(SizeOf(TempPath),TempPath);
  GetTempFileName(TempPath,'kcp',0,TempName);
  Result := TempName;
end;

(*************************************************)

function OpenArchive(var ArchiveData:TOpenArchiveData):thandle; stdcall;
begin
  Result := 0;
  ArchiveData.OpenResult := E_UNKNOWN_FORMAT;
end;

function CloseArchive(hArcData:thandle):longint; stdcall;
begin
  Result:=0;
end;

function ReadHeader(hArcData:thandle;var HeaderData:THeaderData):longint; stdcall;
begin
  Result := E_BAD_ARCHIVE;
end;

function ProcessFile(hArcData:thandle;Operation:longint;DestPath,DestName:pchar):longint; stdcall;
begin
  Result := E_BAD_ARCHIVE;
end;

function GetPackerCaps:integer; stdcall;
begin
  Result := PK_CAPS_NEW or PK_CAPS_MODIFY or PK_CAPS_MULTIPLE or PK_CAPS_HIDE;
end;

function ExecKillCopy(const ListFileName, DestFolder: String; Flags: integer):Boolean;
var
  CommandLine: String;
  StartupInfo: TStartupInfo;
  ProcessInfo: TProcessInformation;
begin
  Result := False;

  FillChar(StartupInfo, SizeOf(StartupInfo), 0);
  StartupInfo.cb := SizeOf(StartupInfo);

  CommandLine := '"' + AppPath + 'KillCopy.exe" "|' + ListFileName + '|' + DestFolder + '|';

  if (Flags and PK_PACK_MOVE_FILES) <> 0 then
    CommandLine := CommandLine + ' -m"'
  else
    CommandLine := CommandLine + '"';

  if CreateProcess(nil, PChar(CommandLine), nil, nil, False, 0, nil, PChar(AppPath), StartupInfo, ProcessInfo) then begin
    CloseHandle(ProcessInfo.hThread); // Close thread handle
//    WaitForSingleObject(ProcessInfo.hProcess, INFINITE); // Wait until child process exits
    CloseHandle(ProcessInfo.hProcess); // Close process handle
    Result := True; //All OK
  end
end;

function PackFiles(PackedFile,SubPath,SrcPath,AddList:PChar;Flags:integer):integer; stdcall;
var
  FileName, ListFileName, List: String;
  ListFile: Cardinal;
  p: PChar;
  BytesWritten: LongWord;
begin
  Result := 0;
  p := AddList;

  // --- Build list file ---

  List := '';

  //source files
  while (p^ <> #0) do begin
    FileName := String(SrcPath) + String(p);
    List := List + FileName + #13#10;
    p := StrEnd(p)+1;
  end;

  if Length(List) > 0 then begin
    // --- Create list file ---
    ListFileName := GetTempName;
    ListFile := CreateFile(PChar(ListFileName),
        GENERIC_WRITE, FILE_SHARE_READ, nil,
        CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, 0);
    WriteFile(ListFile,List[1], Length(List), BytesWritten, nil);
    CloseHandle(ListFile);

    // --- Execute KillCopy ---
    if not ExecKillCopy(ListFileName, ExtractFilePath(PackedFile), Flags) then
      Result := E_EABORTED;
  end
  else //List is empty, nothing to do?! Unlikely... report an error
    Result := E_EABORTED;
end;

function SetChangeVolProc(hArcData:THandle;ChangeVolProc:TChangeVolProc):longint; stdcall;
begin
  PackerChangeVolProc:=ChangeVolProc;
end;

function SetProcessDataProc(hArcData:THandle;ProcessDataProc:TProcessDataProc):longint; stdcall;
begin
  PackerProcessDataProc:=ProcessDataProc;
end;

function DeleteFiles(PackedFile,DeleteList:pchar):integer; stdcall;
begin
  result:=E_NOT_SUPPORTED;
end;

exports
  OpenArchive,
  CloseArchive,
  ReadHeader,
  ProcessFile,
  GetPackerCaps,
  PackFiles,
  DeleteFiles,
  SetChangeVolProc,
  SetProcessDataProc;

begin
  //Get KillCopy's application path (Windows System folder)
  AppPath := GetSystemDir;
  if AppPath = '' then //App path is still unknown
  {TODO: Prompt user to enter the path to KillCopy}
  else
    AppPath := AppPath + '\';

//  InstPath := GetRegString(szKCKey, 'InstallPath', HKEY_LOCAL_MACHINE);
end.
