#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=C:\Software\Scripting\AutoIT\Scripte\SetFolderDate\SetFolderDate_1.5\SetFolderDate.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Comment=Discussion in Total Commander forum: <http://www.ghisler.ch/board/viewtopic.php?t=16012> and <http://www.ghisler.ch/board/viewtopic.php?t=2055>. Compiled with AutoIt3 v3.3.6.1
#AutoIt3Wrapper_Res_Description=Addon for filemanager Total Commander. Set date of selected directories and archives from newest/oldest file inside.
#AutoIt3Wrapper_Res_Fileversion=1.5.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright (c) 2006-2011 van Dusen
#AutoIt3Wrapper_Res_Field=OriginalFilename|SetFolderDate.exe
#AutoIt3Wrapper_Res_Field=ProductName|SetFolderDate
#AutoIt3Wrapper_Res_Field=ProductVersion|1.5
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;*** SetFolderDate.au3 by van Dusen
;*** V1.5    20.07.2011 Funktionalitt "Ignorelist" erweitert: Ignorelist darf DOS-Dateinamensmuster enthalten (z.B. "*.bak"); Settings und Fensterpos. von GUI aus speicherbar
;*** V1.4.1  18.07.2011 Funktionalitt "Datum aus Dateinamen bilden" erweitert: Dateinamensmuster ist RegExp + Spezial-Platzhalter fr Datumskomponenten
;*** V1.4.0  14.11.2008 Diverse Ergnzungen und nderungen; Anpassung an AutoIt3 3.2.13.10.beta
;*** V1.3.2  10.07.2007
;*** V1.3.1  09.07.2007
;*** V1.3    08.07.2007
;*** V1.2.2a,03.09.2006 Fixed: In compiled version dirs were scanned twice at startup
;*** V1.2.2, 03.09.2006 Initial settings customizable via INI-File
;*** V1.2.1, 21.08.2006 Progress is displayed (in %)
;*** V1.2    17.08.2006 Support for archives added (external 7z.exe is needed)
;*** V1.1,   14.08.2006 SetFolderDate.ini added (for localization)
;*** V1.0,   15.04.2006 Initial release

#include <Constants.au3>
#include <GUIConstants.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#include <UpDownConstants.au3>
#include <ComboConstants.au3>
#include <ButtonConstants.au3>
#include <StaticConstants.au3>
#include <Array.au3>
#include <File.au3>
#include <Date.au3>

AutoItSetOption("WinTitleMatchMode", 4)

Global $strSetFolderDateVersion = "V1.5 (2011-07-20)"
Global $strYMDhmsMin, $strYMDhmsMax, $strYMDhmsMinNoFileSpec, $strYMDhmsMaxNoFileSpec
Global $strYMDhmsMinFilename, $strYMDhmsMaxFilename, $strYMDhmsMinFilenameNoFileSpec, $strYMDhmsMaxFilenameNoFileSpec
Global $intDatetypeOldDate = 0
Global $intDatetypeNewDate = 0
Global $strErrMsg = ""
Global $strTCSrcPath = ""
Global $booSkipCurrentDir = False
Global $booStopScanning = False
Global $intNumDirs = 0
Global $intNumArcs = 0
Global $intNumNams = 0
Global $intNumPics = 0
Global $intNumDocs = 0
Global $intNumFils = 0
Global $strTSInNamPattern = ""
$strIniFile = @ScriptDir & "\SetFolderDate.ini"
$booTCPNListFlatIsBuild = False
Dim $arrExifToolList[1]

;*** $lstPreviewItem
Const $cLVIdx = 0
Const $cFPFul = 1
Const $cFPPar = 2
Const $cFPRel = 3
Const $cFNNam = 4
Const $cDtOld = 5
Const $cDtMax = 6
Const $cDtMin = 7
Const $cFNMax = 8
Const $cFNMin = 9
Const $cDtNew = 10
Const $cFNTyp = 11
Const $cFNExt = 12
Const $cTxErr = 13

Const $cstrSrch = "YYYY|YY  |Y+  |MM  |M+  |M   |DD  |D+  |D   |hh  |h+  |h   |nn  |n+  |n   |ss  |s+  |s   |"
Const $cstrRepl = "{4} |{2} |+   |{2} |+   |    |{2} |+   |    |{2} |+   |    |{2} |+   |    |{2} |+   |    |"
Const $cstrMask = "....|..  |.+  |..  |.+  |.   |..  |.+  |.   |..  |.+  |.   |..  |.+  |.   |..  |.+  |.   |"

#region Sprachuntersttzung

;*** Fehlwert: Englisch (intern)
Global $strLocalizedString[53][2]
For $i = 0 To 52
	$strLocalizedString[$i][0] = $i
Next
$strLocalizedString[0][1] =52
$strLocalizedString[1][1] ="SetFolderDate " & $strSetFolderDateVersion
$strLocalizedString[2][1] ="Modify date and time"
$strLocalizedString[3][1] ="to that of the newest file"
$strLocalizedString[4][1] ="to that of the oldest file"
$strLocalizedString[5][1] ="scan recursively"
$strLocalizedString[6][1] ="Certain file (filename or filepattern):"
$strLocalizedString[7][1] ="RegEx"
$strLocalizedString[8][1] ="to a fixed one:"
$strLocalizedString[9][1] ="Current"
$strLocalizedString[10][1]="Directory/Archive"
$strLocalizedString[11][1]="Old date"
$strLocalizedString[12][1]="New date"
$strLocalizedString[13][1]="Filename"
$strLocalizedString[14][1]="Cancel"
$strLocalizedString[15][1]="Execute"
$strLocalizedString[16][1]="Preview"
$strLocalizedString[17][1]="Set date and time of %d directories and %f file(s)"
$strLocalizedString[18][1]=""
$strLocalizedString[19][1]="Invalid date / time"
$strLocalizedString[20][1]="The given date / time is invalid"
$strLocalizedString[21][1]="*** Unchanged"
$strLocalizedString[22][1]="*** OK"
$strLocalizedString[23][1]="*** Error!"
$strLocalizedString[24][1]="Close"
$strLocalizedString[25][1]="Be patient, please..."
$strLocalizedString[26][1]="No files selected!"
$strLocalizedString[27][1]="No directories or archives selected!"
$strLocalizedString[28][1]=""
$strLocalizedString[29][1]="Examine only files, which are NOT specified in the ignore list"
$strLocalizedString[30][1]="Type of timestamp"
$strLocalizedString[31][1]="display and"
$strLocalizedString[32][1]="change according"
$strLocalizedString[33][1]="Modified"
$strLocalizedString[34][1]="Created"
$strLocalizedString[35][1]="Accessed"
$strLocalizedString[36][1]="*** Directory is empty / contains no files"
$strLocalizedString[37][1]="*** No match"
$strLocalizedString[38][1]="*** 7z.exe not found"
$strLocalizedString[39][1]="*** Skipped"
$strLocalizedString[40][1]="*** Canceled"
$strLocalizedString[41][1]="{Pause} = Skip directory / archive"
$strLocalizedString[42][1]="{Esc} = Abort scanning"
$strLocalizedString[43][1]="relative to 'Old date':"
$strLocalizedString[44][1]="recursively"
$strLocalizedString[45][1]="Building directory tree..."
$strLocalizedString[46][1]="to that from the file's name"
$strLocalizedString[47][1]="to that from the file's metadata (pictures/videos)"
$strLocalizedString[48][1]="to that from the file's metadata (office documents)"
$strLocalizedString[49][1]="*** ExifTool.exe not found"
$strLocalizedString[50][1]="if no match, then ignore name/pattern"
$strLocalizedString[51][1]="Settings"
$strLocalizedString[52][1]="Position"

;*** Sprache aus INI-Datei ermitteln
$strLanguage = IniRead($strIniFile, "Configuration", "Language", "AutoDetect")
If $strLanguage = "AutoDetect" And WinExists("classname=TTOTAL_CMD") Then
	$strTmp = IniRead(EnvGet("COMMANDER_INI"), "Configuration", "LanguageIni", "Wcmd_ENG.lng")
	$strTmp = StringSplit(StringMid($strTmp, StringInStr($strTmp, "_", 0, -1) + 1), "._-")
	$strLanguage = StringUpper($strTmp[1])
	$strTmp = ""
EndIf

;*** Prfen, ob die INI-Section zur konfigurierten bzw. automatisch ermittelten Sprache existiert
$strTmp = IniReadSection($strIniFile, $strLanguage)

;*** Wenn die Sprach-INI-Section nicht existiert, dann Fehlermeldung ausgeben (Fehlwert Englisch (intern) wird verwendet)
If @error = 1 Then
	$strErrMsg = "Can't apply localized strings for language [" & $strLanguage & "]," & @LF
	$strErrMsg &= "because section [" & $strLanguage & "] is not found in SetFolderDate.ini!" & @LF
	$strErrMsg &= "Default language [ENG (internal)] is used instead." & @LF & @LF
	MsgBox(64, "SetFolderDate " & $strSetFolderDateVersion, $strErrMsg)

;*** Wenn die Sprach-INI-Section existiert, dann lokalisierte Strings aus INI bernehmen
Else
	For $i = 1 To 52
		$strLocalizedString[$i][1] = IniRead($strIniFile, $strLanguage, $i, $strLocalizedString[$i][1])
	Next
EndIf
$strTmp = ""

;*** Datums- und Uhrzeitformat aus INI ermitteln (Fehlwerte gem ISO 8601:2004 / EN 28601 / DIN ISO 8601:2006-09 / DIN 5008)
$strDateFormat = IniRead($strIniFile, $strLanguage, "DateFormat", "YYYY-MM-DD")
$strTimeFormat = IniRead($strIniFile, $strLanguage, "TimeFormat", "hh:mm:ss")
$intGUICtrlAddWidth = IniRead($strIniFile, $strLanguage, "GUICtrlAddWidth", "0") * 1
#endregion


FileInstall("C:\Software\Scripting\AutoIT\Scripte\SetFolderDate\SetFolderDate_1.5\SetFolderDate.icl", @ScriptDir & "\SetFolderDate.icl")

$frmGUI = GUICreate("SetFolderDate " & $strSetFolderDateVersion, 640+3*$intGUICtrlAddWidth, 572, Default, Default, $WS_OVERLAPPEDWINDOW)
GUISetFont(IniRead($strIniFile, "Configuration", "FontSize", "8.5")*1, Default, Default, IniRead($strIniFile, "Configuration", "FontName", "Tahoma"))
$intSeparatorColor = IniRead($strIniFile, "Configuration", "SeparatorColorRGB", 0xD0D0BF)

#Region Optionen
$grpDateEvalOptions = GUICtrlCreateGroup($strLocalizedString[2][1], 10, 10, 490+2*$intGUICtrlAddWidth, 300)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$chkDirRecurse = GUICtrlCreateCheckbox($strLocalizedString[44][1], 20, 25, 475+2*$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateLabel("", 10, 50, 490+2*$intGUICtrlAddWidth-1, 1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetBkColor(-1, $intSeparatorColor)

$icoArcDir = GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 0, 15, 60, 16, 16) ;Icon: DIR
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblArcDir = GUICtrlCreateLabel("", 33, 60, 16, 16)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetColor(-1, 0x21A121)
GUICtrlSetFont(-1, 14, Default, Default, "Wingdings")

$icoArcArc = GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 2, 15, 78, 16, 16) ;Icon: ARC
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblArcArc = GUICtrlCreateLabel("", 33, 78, 16, 16)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetColor(-1, 0x21A121)
GUICtrlSetFont(-1, 14, Default, Default, "Wingdings")

$icoArcArcExclude = GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 3, 15, 96, 16, 16) ;Icon: ARCBLACKLIST
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblArcArcExclude = GUICtrlCreateLabel("", 33, 96, 16, 16)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetColor(-1, 0x21A121)
GUICtrlSetFont(-1, 14, Default, Default, "Wingdings")

$radioSetUserdefDate = GUICtrlCreateRadio($strLocalizedString[8][1], 60, 60, 150+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$txtUserdefDateDMY = GUICtrlCreateInput(_FmtDt(@YEAR & @MON & @MDAY), 225+$intGUICtrlAddWidth, 60, 70, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetTip($txtUserdefDateDMY, $strDateFormat)

$txtUserdefDateHMS = GUICtrlCreateInput(_FmtTm(@HOUR & @MIN & @SEC), 300+$intGUICtrlAddWidth, 60, 60, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetTip($txtUserdefDateHMS, $strTimeFormat)

$btnSetCurrentDate = GUICtrlCreateButton($strLocalizedString[9][1], 365+$intGUICtrlAddWidth, 60, 90+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$radioSetRelDate = GUICtrlCreateRadio($strLocalizedString[43][1], 60, 85, 150+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$txtRelDateVal = GUICtrlCreateInput("0", 225+$intGUICtrlAddWidth, 85, 70, 20, $ES_NUMBER+$ES_RIGHT)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$updRelDateVal = GUICtrlCreateUpdown($txtRelDateVal, $UDS_ARROWKEYS+$UDS_NOTHOUSANDS)

$cbxRelDateType = GUICtrlCreateCombo("YYYY", 300+$intGUICtrlAddWidth, 85, 60, 30, $CBS_DROPDOWNLIST)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetData($cbxRelDateType, "MM|DD|hh|mm|ss", "hh")

$radioSetNewestDate = GUICtrlCreateRadio($strLocalizedString[3][1], 60, 149, 140+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$radioSetOldestDate = GUICtrlCreateRadio($strLocalizedString[4][1], 60, 174, 140+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateGraphic(200+$intGUICtrlAddWidth, 112, 20, 115)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetGraphic(-1, $GUI_GR_PENSIZE, 2)
GUICtrlSetGraphic(-1, $GUI_GR_COLOR, $intSeparatorColor)
GUICtrlSetGraphic(-1, $GUI_GR_MOVE, 20, 1)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 15, 1)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 10, 6)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 10, 53)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 5, 58)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 10, 63)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 10, 110)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 15, 115)
GUICtrlSetGraphic(-1, $GUI_GR_LINE, 20, 115)

$chkFileGetTimeRecurse = GUICtrlCreateCheckbox($strLocalizedString[5][1], 225+$intGUICtrlAddWidth, 115, 270+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$chkFileSpec = GUICtrlCreateCheckbox($strLocalizedString[6][1], 225+$intGUICtrlAddWidth, 135, 270+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$chkFileSpecIgnoreIfNoMatch = GUICtrlCreateCheckbox($strLocalizedString[50][1], 241+$intGUICtrlAddWidth, 155, 254+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$txtFileSpec = GUICtrlCreateInput("", 225+$intGUICtrlAddWidth, 175, 200, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$chkFileSpecRegEx = GUICtrlCreateCheckbox($strLocalizedString[7][1], 435+$intGUICtrlAddWidth, 175, 60+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$chkEvalIgnorelist = GUICtrlCreateCheckbox("", 225+$intGUICtrlAddWidth, 180+20, 16, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblEvalIgnorelist = GUICtrlCreateLabel($strLocalizedString[29][1], 241+$intGUICtrlAddWidth, 183+20, 255+$intGUICtrlAddWidth, 40)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateLabel("", 10, 233, 490+2*$intGUICtrlAddWidth-1, 1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetBkColor(-1, $intSeparatorColor)

GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 0, 15, 237, 16, 16) ;Icon: DIR
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 4, 33, 237, 16, 16) ;Icon: NAM
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$radioSetTimestampFromNam = GUICtrlCreateRadio($strLocalizedString[46][1], 60, 237, 295+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$strGUIInitSetting = IniRead($strIniFile, "Configuration", "TimestampInFilenameFormat", ".+ \($YY$MM$DD_$hh$nn)\..+")
;~ $lblTSInNamFormat = GUICtrlCreateLabel($strGUIInitSetting, 360+$intGUICtrlAddWidth, 240, 135, 20)
$txtTSInNamFormat = GUICtrlCreateInput($strGUIInitSetting, 360+$intGUICtrlAddWidth, 236, 135, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateLabel("", 10, 258, 490+2*$intGUICtrlAddWidth-1, 1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetBkColor(-1, $intSeparatorColor)

GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 5, 15, 262, 16, 16) ;Icon: PIC
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$radioSetTimestampFromPic = GUICtrlCreateRadio($strLocalizedString[47][1], 60, 262, 295+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$strGUIInitSetting = IniRead($strIniFile, "Configuration", "EvaluateTagPic", "DateTimeOriginal")
GUICtrlCreateLabel("Tag:", 360+$intGUICtrlAddWidth, 265, 25, 18)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblExifToolTagPic = GUICtrlCreateLabel($strGUIInitSetting, 390+$intGUICtrlAddWidth, 265, 105, 18)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateLabel("", 10, 283, 490+2*$intGUICtrlAddWidth-1, 1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetBkColor(-1, $intSeparatorColor)

GUICtrlCreateIcon(@ScriptDir & "\" & "SetFolderDate.icl", 6, 15, 287, 16, 16) ;Icon: DOC
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$radioSetTimestampFromDoc = GUICtrlCreateRadio($strLocalizedString[48][1], 60, 287, 295+$intGUICtrlAddWidth, 20)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$strGUIInitSetting = IniRead($strIniFile, "Configuration", "EvaluateTagDoc", "ModifyDate")
GUICtrlCreateLabel("Tag:", 360+$intGUICtrlAddWidth, 290, 25, 18)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
$lblExifToolTagDoc = GUICtrlCreateLabel($strGUIInitSetting, 390+$intGUICtrlAddWidth, 290, 105, 18)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateGroup("", -99, -99, 1, 1)
#EndRegion Optionen

#Region Gruppe Optionen zum Datumstyp
$grpDateTypeOptions = GUICtrlCreateGroup($strLocalizedString[30][1], 510+2*$intGUICtrlAddWidth, 10, 120+$intGUICtrlAddWidth, 300)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

GUICtrlCreateLabel($strLocalizedString[11][1] & @LF & $strLocalizedString[10][1], 520+2*$intGUICtrlAddWidth, 25, 100+$intGUICtrlAddWidth, 30)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$cbxDatetypeOldDate = GUICtrlCreateCombo($strLocalizedString[33][1], 520+2*$intGUICtrlAddWidth, 55, 100+$intGUICtrlAddWidth, 20, $CBS_DROPDOWNLIST)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetData($cbxDatetypeOldDate, $strLocalizedString[34][1])
GUICtrlSetData($cbxDatetypeOldDate, $strLocalizedString[35][1])

GUICtrlCreateLabel($strLocalizedString[31][1] & @LF & $strLocalizedString[32][1] & @LF & $strLocalizedString[12][1], 520+2*$intGUICtrlAddWidth, 77, 100+$intGUICtrlAddWidth, 45)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$lblDatetypeNewDate = GUICtrlCreateLabel($strLocalizedString[13][1], 520+2*$intGUICtrlAddWidth, 117, 100+$intGUICtrlAddWidth, 15)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

$cbxDatetypeNewDate = GUICtrlCreateCombo($strLocalizedString[33][1], 520+2*$intGUICtrlAddWidth, 132, 100+$intGUICtrlAddWidth, 30, $CBS_DROPDOWNLIST)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetData($cbxDatetypeNewDate, $strLocalizedString[34][1])
GUICtrlSetData($cbxDatetypeNewDate, $strLocalizedString[35][1])

GUICtrlCreateGroup ("", -99, -99, 1, 1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
#EndRegion Gruppe Optionen zum Datumstyp

#Region Listview
$lblTCSrcPath = GUICtrlCreateLabel("", 18, 320, 612+3*$intGUICtrlAddWidth, 20, $SS_NOPREFIX)
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetColor($lblTCSrcPath, IniRead($strIniFile, "Configuration", "DirColorRGB", 0x0000C0))

$lvwPreview = GUICtrlCreateListView($strLocalizedString[10][1] & "|" & $strLocalizedString[11][1] & "|" & $strLocalizedString[12][1] & "|" & $strLocalizedString[13][1], 10, 340, 620+3*$intGUICtrlAddWidth, 168)
GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
#EndRegion Listview

#Region Buttons
$btnSaveSettings = GUICtrlCreateButton("<", 275-$intGUICtrlAddWidth, 517-6, 18, 18, $BS_FLAT)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 14, Default, Default, "Wingdings")
$lblSaveSettings = GUICtrlCreateLabel($strLocalizedString[51][1], 275-$intGUICtrlAddWidth+20, 517-5, 70+$intGUICtrlAddWidth, 18)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, IniRead($strIniFile, "Configuration", "FontSize", "8.5")*1 - 1)

$btnSavePos = GUICtrlCreateButton("<", 275-$intGUICtrlAddWidth, 517+12, 18, 18, $BS_FLAT)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 14, Default, Default, "Wingdings")
$lblSaveSettings = GUICtrlCreateLabel($strLocalizedString[52][1], 275-$intGUICtrlAddWidth+20, 517+13, 70+$intGUICtrlAddWidth, 18)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, IniRead($strIniFile, "Configuration", "FontSize", "8.5")*1 - 1)

$btnPreview = GUICtrlCreateButton($strLocalizedString[16][1], 370, 517, 80+$intGUICtrlAddWidth, 25, $BS_DEFPUSHBUTTON)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetState($btnPreview, $GUI_FOCUS)

$btnOK = GUICtrlCreateButton($strLocalizedString[15][1], 460+$intGUICtrlAddWidth, 517, 80+$intGUICtrlAddWidth, 25)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)

$btnCancel = GUICtrlCreateButton($strLocalizedString[14][1], 550+2*$intGUICtrlAddWidth, 517, 80+$intGUICtrlAddWidth, 25)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)

#EndRegion Buttons

#Region Statusleiste
$lblHintPause = GUICtrlCreateLabel("", 2, 517, 240, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR)
GUICtrlSetColor($lblHintPause, 0x800000)

$lblHintEsc = GUICtrlCreateLabel("", 2, 532, 240, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR)
GUICtrlSetColor($lblHintEsc, 0x800000)

$lblStatus = GUICtrlCreateLabel("", 2, 550, 180, 20, $SS_SUNKEN)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

$lblStatus2 = GUICtrlCreateLabel("", 184, 550, 454+3*$intGUICtrlAddWidth, 20, $SS_SUNKEN+$SS_LEFTNOWORDWRAP)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKLEFT+$GUI_DOCKRIGHT)
GUICtrlSetColor($lblStatus, 0xFF0000)
#EndRegion Statusleiste

$intGUIRefresh = 0

If WinExists("classname=TTOTAL_CMD") Then

;~ 	If $CmdLine[0] > 0 Then
		#cs
		$strTCSrcPath = ""
		$intTCSrcPath = 2
		$strTmp = FileRead($CmdLine[1])
		$strTCPNList = StringSplit($strTmp, @CRLF, 1)
		#ce

;~ 	Else
		;*** Clipboard-Inhalt sichern
		$strClipSave = ClipGet()
		;*** Clipboard leeren (um nach cm_CopyFullNamesToClip feststellen zu knnen, ob TC "Keine Dateien gewhlt!" meldet)
		ClipPut("")

		;*** cm_CopySrcPathToClip=2029;Quellverzeichnis in Zwischenablage kopieren
		DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2029, "int", 0)
		Sleep(200)
		$strTCSrcPath = ClipGet()
		$intTCSrcPath = StringLen($strTCSrcPath) + 2
		If StringRight($strTCSrcPath, 1) = "\" Then $intTCSrcPath -= 1

		;*** cm_CopyFullNamesToClip=2018;Copy names with full path
		DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2018, "int", 0)
		Sleep(200)

		;*** Wenn keine Dateien gewhlt wurden, dann Clipboard-Inhalt wiederherstellen und Script verlassen
		If ClipGet() = "" Then
			ClipPut($strClipSave)
			Exit
		EndIf

		;*** Eintrge der Dateiliste aus Clipboard in Feld $strTCPNList einlesen und Clipboard-Inhalt wiederherstellen
		$strTCPNList = StringSplit(ClipGet(), @CRLF, 1)
		ClipPut($strClipSave)

		#cs
		;*** Wenn $strTCPNList aus den Eintrgen der Zweigansicht (<Strg><b>) gespeist wurde, mssen Eintrge fr die Verzeichnisse ergnzt werden
		;*** Funktionalitt noch nicht aktiviert, da das Setzen der CheckBox $chkDirRecurse i.V.m. Zweigansicht noch nicht richtig verarbeitet wird
		;*** (ansatz: Wenn $arrTCPathList[0] = 0 bleibt, dann enthlt $strTCPNList[] keine Verzeichnisse => CheckBox kann DISABLED werden
		;*** Weiterhin msste die um die Verzeichniseintrge ergnzte Liste korrekt sortiert werden (Ansatz: Sort nach vollem Dateipfad)
		_ArraySort($strTCPNList, 0, 1)

		Dim $arrTCPathList[1] ;speichert die in $strTCPNList bereits vorhandenen Verzeichnisse
		$arrTCPathList[0] = 0
		For $i = 1 To $strTCPNList[0]
			If StringRight($strTCPNList[$i], 1) = "\" Then
				_ArrayAdd($arrTCPathList, $strTCPNList[$i])
				$arrTCPathList[0] += 1
			EndIf
		Next

		Dim $arrPathList[1] ;speichert fr jeden Dateipfad die Verzeichnishierarchie (jeden Pfad von der Root bis zum ParentDir)
		$arrPathList[0] = 0
		Dim $arrTCPNListTmp[1] ;speichert die inkl. der Pfade neu aufzubauende endgltige Dateiliste
		$arrTCPNListTmp[0] = 0
		For $i = 1 To $strTCPNList[0]
			$arrPath = StringSplit($strTCPNList[$i], "\")
			$strPath = ""
			For $j = 1 To $arrPath[0]-1
				$strPath &= $arrPath[$j] & "\"
				If _ArraySearch($arrPathList, $strPath, 1) < 0 And _ArraySearch($arrTCPathList, $strPath, 1) < 0 And StringInStr($strTCSrcPath & "\", $strPath) = 0 Then
					_ArrayAdd($arrPathList, $strPath)
					$arrPathList[0] += 1
					_ArrayAdd($arrTCPNListTmp, "0>" & $strPath)
					$arrTCPNListTmp[0] += 1
				EndIf
			Next
			If StringInStr($strTCSrcPath & "\", $strPath) = 0 Then
				_ArrayAdd($arrTCPNListTmp, "0>" & $strTCPNList[$i])
			Else
				_ArrayAdd($arrTCPNListTmp, "1>" & $strTCPNList[$i])
			EndIf
			$arrTCPNListTmp[0] += 1
		Next

		_ArraySort($arrTCPNListTmp, 0, 1)
		For $i = 1 To $arrTCPNListTmp[0]
			$arrTCPNListTmp[$i] = StringTrimLeft($arrTCPNListTmp[$i], 2)
		Next
		$strTCPNList = $arrTCPNListTmp
;~ 		_ArrayDisplay($strTCPNList) ;debug
		#ce

;~ 	EndIf

	;*** [0]=Index des ListViewItems; [1]=Verzeichnis-/Dateiname (kompletter Pfad[+Dateiname]); [2]=Elternverzeichnis von [1]; [3]=Verzeichnis-/Dateiname (Treeview-Darstellung); [4]=Verzeichnisname (nur letzte Pfadkomponente);
	;*** [5]=Bisheriges Datum; [6]=Neuestes Dateidatum; [7]=ltestes Dateidatum; [8]=Name der Datei mit neuestem Datum; [9]=Name der Datei mit ltestem Datum
	;*** [10] = Neues Datum; [11]=Dateityp Dir=Verzeichnis; Arc=Archiv; Nam=Verzeichnis/Datei mit Timestamp im Dateinamen; Pic=Bild/Video; Doc=Dokument; Fil=Datei; [12]=Dateinamenserweiterung; [13]=Fehlermeldungstext
	Dim $lstPreviewItem[$strTCPNList[0]+1][14]


	;*** Initialeinstellungen gem INI-Datei setzen

	$intShowIcons = IniRead($strIniFile, "Configuration", "ShowIcons", 1)

	$arrSupportedFormatsArc = StringSplit(IniRead($strIniFile, "Configuration", "SupportedFormatsArc", ""), ",;:|")
	$arrExcludedFormatsArc = StringSplit(IniRead($strIniFile, "Configuration", "OptionalExcludedFormatsArc", ""), ",;:|")
	$arrSupportedFormatsPic = StringSplit(IniRead($strIniFile, "Configuration", "SupportedFormatsPic", ""), ",;:|")
	$arrSupportedFormatsDoc = StringSplit(IniRead($strIniFile, "Configuration", "SupportedFormatsDoc", ""), ",;:|")

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "TypeOfTimestampSource", 1)
	GUICtrlSetData($cbxDatetypeNewDate, $strLocalizedString[32+$strGUIInitSetting][1])
	$intDatetypeNewDate = $strGUIInitSetting - 1

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "TypeOfTimestampTarget", 1)
	GUICtrlSetData($cbxDatetypeOldDate, $strLocalizedString[32+$strGUIInitSetting][1])
	$intDatetypeOldDate = $strGUIInitSetting - 1

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "ExcludeFilesInIgnorelist", 0)
	GUICtrlSetState($chkEvalIgnorelist, $GUI_UNCHECKED)
	If $strGUIInitSetting = 1 Then GUICtrlSetState($chkEvalIgnorelist, $GUI_CHECKED)

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "GetDateFromCertainFileIgnoreIfNoMatch", 0)
	GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_UNCHECKED)
	If $strGUIInitSetting = 1 Then GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_CHECKED)

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "GetDateFromCertainFileRegEx", 0)
	GUICtrlSetState($chkFileSpecRegEx, $GUI_UNCHECKED)
	If $strGUIInitSetting = 1 Then GUICtrlSetState($chkFileSpecRegEx, $GUI_CHECKED)

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "GetDateFromCertainFileName", "")
	GUICtrlSetState($chkFileSpec, $GUI_UNCHECKED)
	GUICtrlSetData($txtFileSpec, $strGUIInitSetting)
	If $strGUIInitSetting <> "" Then GUICtrlSetState($chkFileSpec, $GUI_CHECKED)

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "GetDateRecursively", 1)
	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_CHECKED)
	If $strGUIInitSetting = 0 Then GUICtrlSetState($chkFileGetTimeRecurse, $GUI_UNCHECKED)

	$strGUIInitSetting = IniRead($strIniFile, "Configuration", "SetDateTo", 2)
	Select
		Case $strGUIInitSetting = 1 ;certain date
			GUICtrlSetState($radioSetUserdefDate, $GUI_CHECKED)
			$strCurrentOption = $radioSetUserdefDate
			_radioSetUserdefDate()
		Case $strGUIInitSetting = 2 ;date of newest file
			GUICtrlSetState($radioSetNewestDate, $GUI_CHECKED)
			$strCurrentOption = $radioSetNewestDate
			_radioSetNewestOrOldestDate()
		Case $strGUIInitSetting = 3 ;date of oldest file
			GUICtrlSetState($radioSetOldestDate, $GUI_CHECKED)
			$strCurrentOption = $radioSetOldestDate
			_radioSetNewestOrOldestDate()
		Case $strGUIInitSetting = 4 ;relative date
			GUICtrlSetState($radioSetRelDate, $GUI_CHECKED)
			$strCurrentOption = $radioSetRelDate
			_radioSetRelDate()
		Case $strGUIInitSetting = 5 ;date from filename
			GUICtrlSetState($radioSetTimestampFromNam, $GUI_CHECKED)
			$strCurrentOption = $radioSetTimestampFromNam
		Case $strGUIInitSetting = 6 ;date from metadata (Fehlwert: DateTimeOriginal)
			GUICtrlSetState($radioSetTimestampFromPic, $GUI_CHECKED)
			$strCurrentOption = $radioSetTimestampFromPic
		Case $strGUIInitSetting = 7 ;date from metadata (Fehlwert: ModifyDate)
			GUICtrlSetState($radioSetTimestampFromDoc, $GUI_CHECKED)
			$strCurrentOption = $radioSetTimestampFromDoc
	EndSelect

;~ 	$strTSInNamFormat = IniRead($strIniFile, "Configuration", "TimestampInFilenameFormat", "")
	$strTSInNamFormat = GUICtrlRead($txtTSInNamFormat)
	$strTSInNamPattern = $strTSInNamFormat
	For $p1 = 0 To 17
		$strTSInNamPattern = StringReplace($strTSInNamPattern, "$" & StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2), "\d" & StringStripWS(StringMid($cstrRepl, $p1*5+1, 4), 2))
	Next

	If StringRight($strTCSrcPath, 1) = "\" Then
		GUICtrlSetData($lblTCSrcPath, $strTCSrcPath)
	Else
		GUICtrlSetData($lblTCSrcPath, $strTCSrcPath & "\")
	EndIf

	;*** Dialog anzeigen
	$intGUIW = IniRead($strIniFile, "Configuration", "GUIWidth", "678") * 1
	$intGUIH = IniRead($strIniFile, "Configuration", "GUIHeight", "606") * 1
	$intGUIX = IniRead($strIniFile, "Configuration", "GUIPosX", Int(@DesktopWidth/2 - $intGUIW/2)) * 1
	$intGUIY = IniRead($strIniFile, "Configuration", "GUIPosY", Int(@DesktopHeight/2 - $intGUIH/2) ) * 1
	WinMove($frmGUI, "", $intGUIX, $intGUIY, $intGUIW, $intGUIH)
	GUISetState(@SW_SHOW, $frmGUI)

	Global $intListViewColWidth[4][2]
	_ListViewSetAutoColWidth(-2) ;*** Optimale Spaltenbreite fr ListView-Header (-2) setzen
	For $i = 0 To 3
		$intListViewColWidth[$i][0] = _ListViewGetColumnWidth($i) ;*** Spaltenbreiten des ListView-Headers merken
		$intListViewColWidth[$i][1] = 0 ;*** Spaltenbreite des "breitetsten" ListView-Items initialisieren
	Next

	;*** Dateipfad zur 7z.exe auflsen (Umgebungsvariablen und relative Pfade, wie z.B. in "ProgPath7z=%CommonProgramFiles%\..\PortableApps\7-ZipPortable\App\7-Zip\7z.exe")
	AutoItSetOption("ExpandEnvStrings", 1)
	$strTmp = IniRead($strIniFile, "Configuration", "ProgPath7z", "")
	$str7zExeFull = $strTmp
	AutoItSetOption("ExpandEnvStrings", 0)
	$str7zExeFull = _PathFull($str7zExeFull)
	$int7zExeExists = FileExists($str7zExeFull)

	;*** Dateipfad zur ExifTool.exe auflsen (Umgebungsvariablen und relative Pfade)
	AutoItSetOption("ExpandEnvStrings", 1)
	$strTmp = IniRead($strIniFile, "Configuration", "ProgPathExifTool", "")
	$strExifToolExeFull = $strTmp
	AutoItSetOption("ExpandEnvStrings", 0)
	$strExifToolExeFull = _PathFull($strExifToolExeFull)
	$intExifToolExeExists = FileExists($strExifToolExeFull)

	_BtnDisable()

	If IniRead($strIniFile, "Configuration", "BuildFilelistRecursively", 0) = 1 Then

		GUICtrlSetState($chkDirRecurse, $GUI_CHECKED)

;~ 		For $i = 1 To $strTCPNList[0]
;~ 			GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
;~ 			$lstPreviewItem[$i][$cLVIdx] = ""
;~ 		Next

		;*** Zweigansicht: Vollstndigen Verzeichnisbaum (rekursiv) erstellen
		GUICtrlSetData($lblStatus, $strLocalizedString[25][1])
		Dim $strTCPNListFlat[1]
		$intDirLevel = 0
		$intDirLevelMin = 99

		For $i = 1 To $strTCPNList[0]

			If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
				_GUICtrlDisable()
				ExitLoop
			EndIf

			$strFullPath = StringReplace($strTCPNList[$i], "\", "\")
			$intDirLevel = @extended
			If StringRight($strTCPNList[$i], 1) = "\" Then ;Verzeichnis
				$intDirLevel -= 1
				_DirGetFileNames(StringTrimRight($strTCPNList[$i], 1))
			Else ;Datei
				_ArrayAdd($strTCPNListFlat, StringFormat("%02d", $intDirLevel) & @TAB & $strFullPath)
			EndIf
			If $intDirLevel < $intDirLevelMin Then $intDirLevelMin = $intDirLevel

		Next

		$strTCPNListFlat[0] = UBound($strTCPNListFlat) - 1
		$booTCPNListFlatIsBuild = True
		$strTCPNList = $strTCPNListFlat

		$strTCPNList[0] = UBound($strTCPNList) - 1
		For $i = 1 To $strTCPNList[0]
			$strTCPNList[$i] = StringTrimLeft($strTCPNList[$i], 3)
		Next

		$lstPreviewItem = ""
		Dim $lstPreviewItem[$strTCPNList[0]+1][14]
;~ 		_ListViewFill()
;~ 		_ListViewSetAutoColWidth(0)
;~ 		$booRescanDir = False
;~ 		$intGUIRefresh = 0

;~ 	Else
;~ 		_ListViewFill()
;~ 		_ListViewSetAutoColWidth(0)

	EndIf

	_ListViewFill()
	_ListViewSetAutoColWidth(0)
	_BtnEnable()

	#cs
	;*** No directories or archives selected
	If $intNumDirs + $intNumArcs + $intNumPics + $intNumNams = 0 Then
		MsgBox(0+16, "SetFolderDate", $strLocalizedString[27][1])
		GUIDelete($frmGUI)
		Exit
	EndIf
	#ce

	If IniRead($strIniFile, "Configuration", "ScanAtStartup", 1) = 1 Then ControlClick("SetFolderDate " & $strSetFolderDateVersion, "", $btnPreview)

	While 1

		$msg = GUIGetMsg()
		$booRescanDir = False

		Switch $msg
			Case $GUI_EVENT_CLOSE, $btnCancel
				GUIDelete($frmGUI)
				Exit

			Case $icoArcDir
				If GUICtrlRead($lblArcDir) = "" Then
					GUICtrlSetData($lblArcDir, "")
				Else
					GUICtrlSetData($lblArcDir, "")
					If GUICtrlRead($lblArcArc) = "" Then GUICtrlSetData($lblArcArc, "")
				EndIf

			Case $icoArcArc
				If GUICtrlRead($lblArcArc) = "" Then
					GUICtrlSetData($lblArcArc, "")
				Else
					GUICtrlSetData($lblArcArc, "")
					GUICtrlSetData($lblArcArcExclude, "")
					If GUICtrlRead($lblArcDir) = "" Then GUICtrlSetData($lblArcDir, "")
				EndIf

			Case $icoArcArcExclude
				If GUICtrlRead($lblArcArcExclude) = "" Then
					GUICtrlSetData($lblArcArcExclude, "")
					If GUICtrlRead($lblArcArc) = "" Then GUICtrlSetData($lblArcArc, "")
				Else
					GUICtrlSetData($lblArcArcExclude, "")
					If GUICtrlRead($lblArcDir) = "" And GUICtrlRead($lblArcArc) = "" Then GUICtrlSetData($lblArcDir, "")
				EndIf

			Case $btnSetCurrentDate
				GUICtrlSetState($radioSetRelDate, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetTimestampFromNam, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetNewestDate, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetOldestDate, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetUserdefDate, $GUI_CHECKED)
				GUICtrlSetData($txtUserdefDateDMY, _FmtDt(@YEAR & @MON & @MDAY))
				GUICtrlSetData($txtUserdefDateHMS, _FmtTm(@HOUR & @MIN & @SEC))
				GUICtrlSetState($btnPreview, $GUI_DEFBUTTON)
				GUICtrlSetState($radioSetTimestampFromNam, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetTimestampFromPic, $GUI_UNCHECKED)
				GUICtrlSetState($radioSetTimestampFromDoc, $GUI_UNCHECKED)

				If $strCurrentOption = $radioSetTimestampFromNam Or $strCurrentOption = $radioSetTimestampFromPic Or $strCurrentOption = $radioSetTimestampFromDoc Then
					_BtnDisable()
					For $i = 1 To $strTCPNList[0]
						GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
						$lstPreviewItem[$i][$cLVIdx] = ""
					Next
					_ListViewFill()
					_ListViewSetAutoColWidth(0)
					$booRescanDir = True
					$intGUIRefresh = 0
					_BtnEnable()
				EndIf
				$strCurrentOption = $msg

				_radioSetUserdefDate()
				$intGUIRefresh = 2

			Case $radioSetUserdefDate
				If $strCurrentOption = $radioSetTimestampFromNam Or $strCurrentOption = $radioSetTimestampFromPic Or $strCurrentOption = $radioSetTimestampFromDoc Then
					_BtnDisable()
					For $i = 1 To $strTCPNList[0]
						GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
						$lstPreviewItem[$i][$cLVIdx] = ""
					Next
					_ListViewFill()
					_ListViewSetAutoColWidth(0)
					$booRescanDir = True
					$intGUIRefresh = 0
					_BtnEnable()
				EndIf
				$strCurrentOption = $msg

				_radioSetUserdefDate()
				$intGUIRefresh = 2

			Case $radioSetRelDate, $cbxRelDateType
				If $strCurrentOption = $radioSetTimestampFromNam Or $strCurrentOption = $radioSetTimestampFromPic Or $strCurrentOption = $radioSetTimestampFromDoc Then
					_BtnDisable()
					For $i = 1 To $strTCPNList[0]
						GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
						$lstPreviewItem[$i][$cLVIdx] = ""
					Next
					_ListViewFill()
					_ListViewSetAutoColWidth(0)
					$booRescanDir = True
					$intGUIRefresh = 0
					_BtnEnable()
				EndIf
				$strCurrentOption = $msg

				_radioSetRelDate()
				$intGUIRefresh = 3

			Case $radioSetNewestDate, $radioSetOldestDate
				If $strCurrentOption = $radioSetTimestampFromNam Or $strCurrentOption = $radioSetTimestampFromPic Or $strCurrentOption = $radioSetTimestampFromDoc Then
					_BtnDisable()
					For $i = 1 To $strTCPNList[0]
						GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
						$lstPreviewItem[$i][$cLVIdx] = ""
					Next
					_ListViewFill()
					_ListViewSetAutoColWidth(0)
					$booRescanDir = True
					$intGUIRefresh = 0
					_BtnEnable()
				EndIf
				$strCurrentOption = $msg

				_radioSetNewestOrOldestDate()
				If $lstPreviewItem[0][$cDtMax] = "?" Then $booRescanDir = True
				$intGUIRefresh = 4

			Case $chkFileSpec
				If GUICtrlRead($chkFileSpec) = $GUI_CHECKED Then
					GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_ENABLE)
					GUICtrlSetState($chkFileSpecRegEx, $GUI_ENABLE)
					GUICtrlSetState($txtFileSpec, $GUI_ENABLE+$GUI_FOCUS)
					$booRescanDir = False
					$intGUIRefresh = 0
				Else
					GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_DISABLE)
					GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
					GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
					$booRescanDir = True
					$intGUIRefresh = 4
				EndIf

			Case $chkFileGetTimeRecurse, $chkFileSpecIgnoreIfNoMatch, $chkFileSpecRegEx, $chkEvalIgnorelist
				$booRescanDir = True
				$intGUIRefresh = 4

			Case $radioSetTimestampFromNam, $radioSetTimestampFromPic, $radioSetTimestampFromDoc
				;Test - Beginn
				If $msg = $radioSetTimestampFromNam Then
					_BtnDisable()
					$strTSInNamFormat = GUICtrlRead($txtTSInNamFormat)
					$strTSInNamPattern = $strTSInNamFormat
					For $p1 = 0 To 17
						$strTSInNamPattern = StringReplace($strTSInNamPattern, "$" & StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2), "\d" & StringStripWS(StringMid($cstrRepl, $p1*5+1, 4), 2))
					Next
					_radioSetTimestampFromNamOrPicOrDoc($msg)
					For $i = 1 To $strTCPNList[0]
						GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
						$lstPreviewItem[$i][$cLVIdx] = ""
					Next
					_ListViewFill()
					_ListViewSetAutoColWidth(0)
					$booRescanDir = True
					$intGUIRefresh = 0
					_BtnEnable()
					$strCurrentOption = $msg
				Else
				;Test - Ende

					If $msg <> $strCurrentOption Then
						_BtnDisable()
						_radioSetTimestampFromNamOrPicOrDoc($msg)
						For $i = 1 To $strTCPNList[0]
							GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
							$lstPreviewItem[$i][$cLVIdx] = ""
						Next
						_ListViewFill()
						_ListViewSetAutoColWidth(0)
						$booRescanDir = True
						$intGUIRefresh = 0
						_BtnEnable()
						$strCurrentOption = $msg
					EndIf

				EndIf

			Case $chkDirRecurse

				_BtnDisable()

				For $i = 1 To $strTCPNList[0]
					GUICtrlDelete($lstPreviewItem[$i][$cLVIdx])
					$lstPreviewItem[$i][$cLVIdx] = ""
				Next

				If GUICtrlRead($chkDirRecurse) = $GUI_CHECKED Then

					;*** Zweigansicht: Vollstndigen Verzeichnisbaum (rekursiv) erstellen
					If $booTCPNListFlatIsBuild = False Then
						GUICtrlSetData($lblStatus, $strLocalizedString[25][1])
						Dim $strTCPNListFlat[1]
						$intDirLevel = 0
						$intDirLevelMin = 99

						For $i = 1 To $strTCPNList[0]

							If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
								_GUICtrlDisable()
								ExitLoop
							EndIf

							$strFullPath = StringReplace($strTCPNList[$i], "\", "\")
							$intDirLevel = @extended
							If StringRight($strTCPNList[$i], 1) = "\" Then ;Verzeichnis
								$intDirLevel -= 1
								_DirGetFileNames(StringTrimRight($strTCPNList[$i], 1))
							Else ;Datei
								_ArrayAdd($strTCPNListFlat, StringFormat("%02d", $intDirLevel) & @TAB & $strFullPath)
							EndIf
							If $intDirLevel < $intDirLevelMin Then $intDirLevelMin = $intDirLevel

						Next

						$strTCPNListFlat[0] = UBound($strTCPNListFlat) - 1
;~ 						If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
;~ 							$booTCPNListFlatIsBuild = False
;~ 						Else
							$booTCPNListFlatIsBuild = True
;~ 						EndIf

					EndIf

					$strTCPNList = $strTCPNListFlat

				Else
					Dim $strTCPNList[1] ;*** Array leer neu anlegen
					For $i = 1 To $strTCPNListFlat[0]
						If StringLeft($strTCPNListFlat[$i], 2) * 1 = $intDirLevelMin Then _ArrayAdd($strTCPNList, $strTCPNListFlat[$i])
					Next

				EndIf

				$strTCPNList[0] = UBound($strTCPNList) - 1
				For $i = 1 To $strTCPNList[0]
					$strTCPNList[$i] = StringTrimLeft($strTCPNList[$i], 3)
				Next

				$lstPreviewItem = ""
				Dim $lstPreviewItem[$strTCPNList[0]+1][14]
				_ListViewFill()
				_ListViewSetAutoColWidth(0)
				$booRescanDir = False
				$intGUIRefresh = 0

				_BtnEnable()

			Case $cbxDatetypeOldDate
				Select
					Case GUICtrlRead($cbxDatetypeOldDate) = $strLocalizedString[33][1]
						$intDatetypeOldDate = 0
					Case GUICtrlRead($cbxDatetypeOldDate) = $strLocalizedString[34][1]
						$intDatetypeOldDate = 1
					Case GUICtrlRead($cbxDatetypeOldDate) = $strLocalizedString[35][1]
						$intDatetypeOldDate = 2
				EndSelect
				$booRescanDir = True
				$intGUIRefresh = 4
				If GUICtrlRead($radioSetUserdefDate) = $GUI_CHECKED Then $intGUIRefresh = 2
				If GUICtrlRead($radioSetRelDate) = $GUI_CHECKED Then $intGUIRefresh = 3

			Case $cbxDatetypeNewDate
				Select
					Case GUICtrlRead($cbxDatetypeNewDate) = $strLocalizedString[33][1]
						$intDatetypeNewDate = 0
					Case GUICtrlRead($cbxDatetypeNewDate) = $strLocalizedString[34][1]
						$intDatetypeNewDate = 1
					Case GUICtrlRead($cbxDatetypeNewDate) = $strLocalizedString[35][1]
						$intDatetypeNewDate = 2
				EndSelect
				$booRescanDir = True
				$intGUIRefresh = 4
				If GUICtrlRead($radioSetUserdefDate) = $GUI_CHECKED Then $intGUIRefresh = 2
				If GUICtrlRead($radioSetRelDate) = $GUI_CHECKED Then $intGUIRefresh = 3

			Case $btnSaveSettings
				;*** BuildFilelistRecursively
				$strGUIInitSetting = 0
				If GUICtrlRead($chkDirRecurse) = $GUI_CHECKED Then $strGUIInitSetting = 1
				IniWrite($strIniFile, "Configuration", "BuildFilelistRecursively", $strGUIInitSetting)
				;*** SetDateTo
				$strGUIInitSetting = 2
				If GUICtrlRead($radioSetUserdefDate)      = $GUI_CHECKED Then $strGUIInitSetting = 1 ;certain date
				If GUICtrlRead($radioSetNewestDate)       = $GUI_CHECKED Then $strGUIInitSetting = 2 ;date of newest file
				If GUICtrlRead($radioSetOldestDate)       = $GUI_CHECKED Then $strGUIInitSetting = 3 ;date of oldest file
				If GUICtrlRead($radioSetRelDate)          = $GUI_CHECKED Then $strGUIInitSetting = 4 ;relative date
				If GUICtrlRead($radioSetTimestampFromNam) = $GUI_CHECKED Then $strGUIInitSetting = 5 ;date from filename
				If GUICtrlRead($radioSetTimestampFromPic) = $GUI_CHECKED Then $strGUIInitSetting = 6 ;date from metadata (Fehlwert: DateTimeOriginal)
				If GUICtrlRead($radioSetTimestampFromDoc) = $GUI_CHECKED Then $strGUIInitSetting = 7 ;date from metadata (Fehlwert: ModifyDate)
				IniWrite($strIniFile, "Configuration", "SetDateTo", $strGUIInitSetting)
				;*** GetDateRecursively
				$strGUIInitSetting = 0
				If GUICtrlRead($chkFileGetTimeRecurse) = $GUI_CHECKED Then $strGUIInitSetting = 1
				IniWrite($strIniFile, "Configuration", "GetDateRecursively", $strGUIInitSetting)
				;*** GetDateFromCertainFileName (if empty, checkbox is set to unchecked)
				$strGUIInitSetting = ""
				If GUICtrlRead($chkFileSpec) = $GUI_CHECKED Then $strGUIInitSetting = GUICtrlRead($txtFileSpec)
				IniWrite($strIniFile, "Configuration", "GetDateFromCertainFileName", $strGUIInitSetting)
				;*** GetDateFromCertainFileIgnoreIfNoMatch
				$strGUIInitSetting = 0
				If GUICtrlRead($chkFileSpecIgnoreIfNoMatch) = $GUI_CHECKED Then $strGUIInitSetting = 1
				IniWrite($strIniFile, "Configuration", "GetDateFromCertainFileIgnoreIfNoMatch", $strGUIInitSetting)
				;*** GetDateFromCertainFileRegEx
				$strGUIInitSetting = 0
				If GUICtrlRead($chkFileSpecRegEx) = $GUI_CHECKED Then $strGUIInitSetting = 1
				IniWrite($strIniFile, "Configuration", "GetDateFromCertainFileRegEx", $strGUIInitSetting)
				;*** ExcludeFilesInIgnorelist
				$strGUIInitSetting = 0
				If GUICtrlRead($chkEvalIgnorelist) = $GUI_CHECKED Then $strGUIInitSetting = 1
				IniWrite($strIniFile, "Configuration", "ExcludeFilesInIgnorelist", $strGUIInitSetting)
				;*** TypeOfTimestampTarget
				$strGUIInitSetting = GUICtrlRead($cbxDatetypeOldDate)
				If $strGUIInitSetting = $strLocalizedString[33][1] Then $strGUIInitSetting = 1
				If $strGUIInitSetting = $strLocalizedString[34][1] Then $strGUIInitSetting = 2
				If $strGUIInitSetting = $strLocalizedString[35][1] Then $strGUIInitSetting = 3
				IniWrite($strIniFile, "Configuration", "TypeOfTimestampTarget", $strGUIInitSetting)
				;*** TypeOfTimestampSource
				$strGUIInitSetting = GUICtrlRead($cbxDatetypeNewDate)
				If $strGUIInitSetting = $strLocalizedString[33][1] Then $strGUIInitSetting = 1
				If $strGUIInitSetting = $strLocalizedString[34][1] Then $strGUIInitSetting = 2
				If $strGUIInitSetting = $strLocalizedString[35][1] Then $strGUIInitSetting = 3
				IniWrite($strIniFile, "Configuration", "TypeOfTimestampSource", $strGUIInitSetting)

			Case $btnSavePos
				$arrWinDimension = WinGetPos($frmGUI) ;[0] = X; [1] = Y; [2] = Breite; [3] = Hhe
				IniWrite($strIniFile, "Configuration", "GUIPosX", $arrWinDimension[0])
				IniWrite($strIniFile, "Configuration", "GUIPosY", $arrWinDimension[1])
				IniWrite($strIniFile, "Configuration", "GUIWidth", $arrWinDimension[2])
				IniWrite($strIniFile, "Configuration", "GUIHeight", $arrWinDimension[3])

			Case $btnPreview, $btnOK

				$intGUIRefresh = 0
				If GUICtrlRead($radioSetNewestDate) = $GUI_CHECKED Or GUICtrlRead($radioSetOldestDate) = $GUI_CHECKED Then

					;*** DOS-Dateinamensmuster "*" und "?" in RegEx umsetzen
					If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecRegEx) = $GUI_UNCHECKED Then

						$txtFileSpecVal = GUICtrlRead($txtFileSpec)
						$txtFileSpecVal = StringReplace($txtFileSpecVal, ".", "\.")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "+", "\+")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "(", "\(")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, ")", "\)")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "[", "\[")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "]", "\]")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "{", "\{")
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "}", "\}")

						$intNumDOSpatterns = 0
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "?", ".")
						$intNumDOSpatterns += @extended
						$txtFileSpecVal = StringReplace($txtFileSpecVal, "*", ".*")
						$intNumDOSpatterns += @extended

						$txtFileSpecVal = "(?i)" & $txtFileSpecVal

						If $intNumDOSpatterns > 0 Then
							GUICtrlSetData($txtFileSpec, $txtFileSpecVal)
							GUICtrlSetState($chkFileSpecRegEx, $GUI_CHECKED)
						EndIf

					EndIf

					$booRescanDir = True
					$intGUIRefresh = 4

				EndIf

				If GUICtrlRead($radioSetRelDate) = $GUI_CHECKED Then
					$intGUIRefresh = 3
				EndIf

				If GUICtrlRead($radioSetUserdefDate) = $GUI_CHECKED Then
					$intGUIRefresh = 2
					If _VerifyDt(GUICtrlRead($txtUserdefDateDMY)) = False Then
						$intGUIRefresh = 0
						MsgBox(48, $strLocalizedString[19][1], GUICtrlRead($txtUserdefDateDMY) & " ---> " & $strDateFormat & @LF & @LF & $strLocalizedString[20][1])
					EndIf
					If _VerifyTm(GUICtrlRead($txtUserdefDateHMS)) = False Then
						$intGUIRefresh = 0
						MsgBox(48, $strLocalizedString[19][1], GUICtrlRead($txtUserdefDateHMS) & " ---> " & $strTimeFormat & @LF & @LF & $strLocalizedString[20][1])
					EndIf
				EndIf

				If GUICtrlRead($radioSetTimestampFromNam) = $GUI_CHECKED Or GUICtrlRead($radioSetTimestampFromPic) = $GUI_CHECKED Or GUICtrlRead($radioSetTimestampFromDoc) = $GUI_CHECKED Then
					$booRescanDir = True
					$intGUIRefresh = 4
				EndIf

				If $msg = $btnOK And IniRead($strIniFile, "Configuration", "RescanOnExecute", "1") = "0" Then
					$intGUIRefresh = 0
				EndIf

		EndSwitch

		If $intGUIRefresh > 0 Then

			_BtnDisable()

			#cs
			For $i = 1 To $strTCPNList[0]
				$strPreviewItem = $lstPreviewItem[$i][$cFPRel] & "| | | "
				GUICtrlSetData($lstPreviewItem[$i][$cLVIdx], $strPreviewItem)
				GUICtrlSetColor($lstPreviewItem[$i][$cLVIdx], 0x000000)
			Next
			#ce

			$booExifToolListBuild = False
			$intNumCurr = 0
			For $i = 1 To $strTCPNList[0]

;~ 				If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then ExitLoop ;debug
				If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
;~ 					$strPreviewItem = $lstPreviewItem[$i][$cFPRel] & "| | |" & $strLocalizedString[40][1]
;~ 					GUICtrlSetData($lstPreviewItem[$i][$cLVIdx], $strPreviewItem)
;~ 					GUICtrlSetColor($lstPreviewItem[$i][$cLVIdx], 0xFF0000)
;~ 					ExitLoop
					If $lstPreviewItem[$i][$cLVIdx] <> "" Then
						$lstPreviewItem[$i][$cDtMax] = "00000000000000"
						$lstPreviewItem[$i][$cDtMin] = "99999999999999"
						$lstPreviewItem[$i][$cDtNew] = ""
;~ 						$strPreviewItem = $lstPreviewItem[$i][$cFPRel] & "| | |" & $strLocalizedString[40][1] ;*** Canceled
						$strPreviewItem = $lstPreviewItem[$i][$cFPRel] & "| | | "
						GUICtrlSetData($lstPreviewItem[$i][$cLVIdx], $strPreviewItem)
						GUICtrlSetColor($lstPreviewItem[$i][$cLVIdx], 0x000000)
						If $lstPreviewItem[$i][$cFNTyp] <> "Fil" Then
							GUICtrlSetData($lblStatus, $strLocalizedString[25][1] & " (" & Int($intNumCurr*100 / ($intNumDirs+$intNumArcs+$intNumNams+$intNumPics+$intNumDocs)) & "%  " & $intNumCurr & " / " & $intNumDirs+$intNumArcs+$intNumNams+$intNumPics+$intNumDocs & ")")
							$intNumCurr += 1
						EndIf
					EndIf
					ContinueLoop
				EndIf

				If $lstPreviewItem[$i][$cFNTyp] <> "Fil" Then

					GUICtrlSetState($lstPreviewItem[$i][$cLVIdx], $GUI_FOCUS)
					GUICtrlSetData($lblStatus, $strLocalizedString[25][1] & " (" & Int($intNumCurr*100 / ($intNumDirs+$intNumArcs+$intNumNams+$intNumPics+$intNumDocs)) & "%  " & $intNumCurr & " / " & $intNumDirs+$intNumArcs+$intNumNams+$intNumPics+$intNumDocs & ")")
					$intNumCurr += 1

					Switch $lstPreviewItem[$i][$cFNTyp]
						Case "Dir"
							$intPreviewItemColor = IniRead($strIniFile, "Configuration", "DirColorRGB", 0x0000C0)
						Case "Arc"
							$intPreviewItemColor = IniRead($strIniFile, "Configuration", "ArcColorRGB", 0x966200)
						Case "Nam"
							$intPreviewItemColor = IniRead($strIniFile, "Configuration", "NamColorRGB", 0x000000)
						Case "Pic"
							$intPreviewItemColor = IniRead($strIniFile, "Configuration", "PicColorRGB", 0x006000)
						Case "Doc"
							$intPreviewItemColor = IniRead($strIniFile, "Configuration", "DocColorRGB", 0x008080)
					EndSwitch
					$intPreviewItemColor = IniRead($strIniFile, "Configuration", "Ext" & $lstPreviewItem[$i][$cFNExt] & "ColorRGB", $intPreviewItemColor)

					If $booRescanDir = True Then $lstPreviewItem[$i][$cDtOld] = FileGetTime($lstPreviewItem[$i][$cFPFul], $intDatetypeOldDate, 1)
					$strPreviewItem = $lstPreviewItem[$i][$cFPRel]
					$strPreviewItem &= "|" & _FmtDtTm($lstPreviewItem[$i][$cDtOld]) & "|"

					Select
						#cs
						Case $intGUIRefresh = 1
							$lstPreviewItem[$i][$cDtNew] = @YEAR & @MON & @MDAY & @HOUR & @MIN & @SEC
							$strPreviewItem &= _FmtDtTm($lstPreviewItem[$i][$cDtNew]) & "|"
						#ce

						Case $intGUIRefresh = 2
							If GUICtrlRead($txtUserdefDateDMY) = "" Then ;*** Altes Datum unverndert bernehmen
								$lstPreviewItem[$i][$cDtNew] = StringLeft($lstPreviewItem[$i][$cDtOld], 8)
							Else
								$lstPreviewItem[$i][$cDtNew] = _UnfmtDt(GUICtrlRead($txtUserdefDateDMY))
							EndIf

							If GUICtrlRead($txtUserdefDateHMS) = "" Then ;*** Alte Uhrzeit unverndert bernehmen
								$lstPreviewItem[$i][$cDtNew] &= StringRight($lstPreviewItem[$i][$cDtOld], 6)
							Else
								$lstPreviewItem[$i][$cDtNew] &= _UnfmtTm(GUICtrlRead($txtUserdefDateHMS))
							EndIf
;~ 							$lstPreviewItem[$i][$cDtNew] = _UnfmtDt(GUICtrlRead($txtUserdefDateDMY)) & _UnfmtTm(GUICtrlRead($txtUserdefDateHMS))
							$strPreviewItem &= _FmtDtTm($lstPreviewItem[$i][$cDtNew]) & "|"

						Case $intGUIRefresh = 3
;~ 							GUICtrlSetData($lblStatus2, $lstPreviewItem[$i][$cFNNam])
							$strDtTmPart = StringSplit(StringRegExpReplace($lstPreviewItem[$i][$cDtOld], "(....)(..)(..)(..)(..)(..)", "\1-\2-\3-\4-\5-\6"), "-")
							Dim $intDtTmOffValPart[7] = [6, 0, 0, 0, 0, 0, 0]
							$intDtTmOffValPartIdx = StringInStr("YMDhms", StringLeft(GUICtrlRead($cbxRelDateType), 1), 1)
							$intDtTmOffValPart[$intDtTmOffValPartIdx] = GUICtrlRead($txtRelDateVal)*1

							While 1

								$booDone = True

								For $intDtTmOffValPartIdx = 1 To 6
									If $intDtTmOffValPart[$intDtTmOffValPartIdx] <> 0 Then
										$booDone = False
										$intDtTmOffVal = $intDtTmOffValPart[$intDtTmOffValPartIdx]
										$intDtTmOffSig = 1
										If $intDtTmOffVal < 0 Then
											$intDtTmOffSig = -1
										EndIf
										$intDtTmOffVal *= $intDtTmOffSig
										ExitLoop
									EndIf
								Next

								If $booDone Then ExitLoop

								Switch $intDtTmOffValPartIdx
									Case 1 ;"Y"
										$intDtTmValPartLBound = 0
										$intDtTmValPartUBound = 9999
									Case 2 ;"M"
										$intDtTmValPartLBound = 1
										$intDtTmValPartUBound = 12
									Case 3; "D"
										$intDtTmValPartLBound = 1
										$intDtTmValPartUBound = _LastDayOfMonth($strDtTmPart[1], $strDtTmPart[2])
									Case 4; "h"
										$intDtTmValPartLBound = 0
										$intDtTmValPartUBound = 23
									Case 5, 6 ;"n", "s"
										$intDtTmValPartLBound = 0
										$intDtTmValPartUBound = 59
								EndSwitch

								For $j = 1 To $intDtTmOffVal
									$strDtTmPart[$intDtTmOffValPartIdx] += $intDtTmOffSig
									$intDtTmOffValPart[$intDtTmOffValPartIdx] -= $intDtTmOffSig
									If $strDtTmPart[$intDtTmOffValPartIdx] = $intDtTmValPartUBound + 1 Then
										$intDtTmOffValPart[$intDtTmOffValPartIdx-1] += 1
										$strDtTmPart[$intDtTmOffValPartIdx] = $intDtTmValPartLBound
										ExitLoop
									EndIf
									If $strDtTmPart[$intDtTmOffValPartIdx] = $intDtTmValPartLBound - 1 Then
										$intDtTmOffValPart[$intDtTmOffValPartIdx-1] -= 1
										$strDtTmPart[$intDtTmOffValPartIdx] = $intDtTmValPartUBound
										ExitLoop
									EndIf
								Next

							WEnd

							;*** Korrektur des Monatsletzten
							If $strDtTmPart[3]*1 > _LastDayOfMonth($strDtTmPart[1], $strDtTmPart[2]) Then $strDtTmPart[3] = _LastDayOfMonth($strDtTmPart[1], $strDtTmPart[2])

							;*** Formatierung fr Ausgabe
							$strDtTmPart[1] = StringFormat("%04d", $strDtTmPart[1])
							For $intDtTmOffValPartIdx = 2 To 6
								$strDtTmPart[$intDtTmOffValPartIdx] = StringFormat("%02d", $strDtTmPart[$intDtTmOffValPartIdx])
							Next
							$lstPreviewItem[$i][$cDtNew] = $strDtTmPart[1] & $strDtTmPart[2] & $strDtTmPart[3] & $strDtTmPart[4] & $strDtTmPart[5] & $strDtTmPart[6]
							$strPreviewItem &= _FmtDtTm($lstPreviewItem[$i][$cDtNew]) & "|"

						Case $intGUIRefresh = 4
							If $booRescanDir = True Then
								$strYMDhmsMax = "00000000000000"
								$strYMDhmsMin = "99999999999999"
								$strYMDhmsMaxFilename = ""
								$strYMDhmsMinFilename = ""

								$strYMDhmsMaxNoFileSpec = "00000000000000"
								$strYMDhmsMinNoFileSpec = "99999999999999"
								$strYMDhmsMaxFilenameNoFileSpec = ""
								$strYMDhmsMinFilenameNoFileSpec = ""

								$lstPreviewItem[0][$cDtMax] = "."
								$strErrMsg = ""
								$lstPreviewItem[$i][$cTxErr] = ""
								$intNumFils = 0
								;************************************************************************************************************************
								$strFileTypeEval = "Std"
								If GUICtrlRead($radioSetTimestampFromNam) = $GUI_CHECKED Then $strFileTypeEval = "Nam"
								If GUICtrlRead($radioSetTimestampFromPic) = $GUI_CHECKED Then $strFileTypeEval = "Pic"
								If GUICtrlRead($radioSetTimestampFromDoc) = $GUI_CHECKED Then $strFileTypeEval = "Doc"
								Switch $strFileTypeEval & "|" & $lstPreviewItem[$i][$cFNTyp]
									Case "Std|Dir"
										If GUICtrlRead($lblArcDir) = "" Then
											$strErrMsg = $strLocalizedString[39][1] ;*** Skipped
										Else
											_DirGetMinMaxFileTS($lstPreviewItem[$i][$cFPFul])
											If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecIgnoreIfNoMatch) = $GUI_CHECKED And ($strYMDhmsMax = "00000000000000" Or $strYMDhmsMin = "99999999999999") Then
												$strYMDhmsMax = $strYMDhmsMaxNoFileSpec
												$strYMDhmsMin = $strYMDhmsMinNoFileSpec
												$strYMDhmsMaxFilename = "*** " & $strYMDhmsMaxFilenameNoFileSpec
												$strYMDhmsMinFilename = "*** " & $strYMDhmsMinFilenameNoFileSpec
											EndIf
										EndIf
									Case "Std|Arc"
										If $int7zExeExists = 1 Then
											If GUICtrlRead($lblArcArc) = "" Or (GUICtrlRead($lblArcArcExclude) = "" And _ArraySearch($arrExcludedFormatsArc, $lstPreviewItem[$i][$cFNExt], 1) > -1) Then
												$strErrMsg = $strLocalizedString[39][1] ;*** Skipped
											Else
												_ArcGetMinMaxFileTS($lstPreviewItem[$i][$cFPFul])
												If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecIgnoreIfNoMatch) = $GUI_CHECKED And ($strYMDhmsMax = "00000000000000" Or $strYMDhmsMin = "99999999999999") Then
													$strYMDhmsMax = $strYMDhmsMaxNoFileSpec
													$strYMDhmsMin = $strYMDhmsMinNoFileSpec
													$strYMDhmsMaxFilename = "*** " & $strYMDhmsMaxFilenameNoFileSpec
													$strYMDhmsMinFilename = "*** " & $strYMDhmsMinFilenameNoFileSpec
												EndIf
											EndIf
										Else
											$strErrMsg = $strLocalizedString[38][1] ;*** 7z.exe not found
										EndIf
									Case "Pic|Dir", "Doc|Dir"
										If GUICtrlRead($chkDirRecurse) = $GUI_CHECKED And $intExifToolExeExists = 1 Then
											$arrFilesInCurrDir = _ArrayFindAll($lstPreviewItem, $lstPreviewItem[$i][$cFPFul], 1, 0, 0, 0, 2)
											If Not @error Then
												For $intFilesInCurrDir = 0 To UBound($arrFilesInCurrDir) - 1
													If $lstPreviewItem[$arrFilesInCurrDir[$intFilesInCurrDir]][$cFNTyp] = $strFileTypeEval Then
														_PicOrDocGetDateTimeOriginal($lstPreviewItem[$i][$cFPFul], $strFileTypeEval)
														ExitLoop
													EndIf
												Next
											EndIf
										EndIf
										$strErrMsg = $strLocalizedString[39][1] ;*** Skipped
									Case "Pic|Pic", "Doc|Doc"
										$intPosLastPathDelim = StringInStr($lstPreviewItem[$i][$cFPFul], "\", 0, -1)
										If StringLeft($lstPreviewItem[$i][$cFPFul], $intPosLastPathDelim - 1) = $strTCSrcPath And $booExifToolListBuild = False Then
											_PicOrDocGetDateTimeOriginal($strTCSrcPath, $lstPreviewItem[$i][$cFNTyp])
											$booExifToolListBuild = True
										EndIf

										If $intExifToolExeExists = 1 Then
;~ 											_PicGetDateTimeOriginal($lstPreviewItem[$i][$cFPFul])
 											$intExifToolListIndex = _ArraySearch($arrExifToolList, $lstPreviewItem[$i][$cFPFul], 1, 0, 0, 1)
											If $intExifToolListIndex > -1 Then
												$strYMDhmsMax = $arrExifToolList[$intExifToolListIndex+1]
												$strYMDhmsMin = $strYMDhmsMax
												$strErrMsg = ""
												$strYMDhmsMaxFilename = $lstPreviewItem[$i][$cFNNam]
												$strYMDhmsMinFilename = $strYMDhmsMaxFilename
												If $strYMDhmsMax = "" Or StringLeft($strYMDhmsMax, 8) = "========" Then
													$strYMDhmsMax = "00000000000000"
													$strYMDhmsMin = "99999999999999"
													$strErrMsg = $strLocalizedString[37][1] ;*** No match
													$strYMDhmsMaxFilename = ""
													$strYMDhmsMinFilename = $strYMDhmsMaxFilename
												Else
													_ArrayDelete($arrExifToolList, $intExifToolListIndex+1)
												EndIf
												_ArrayDelete($arrExifToolList, $intExifToolListIndex)
											Else
												$strYMDhmsMax = "00000000000000"
												$strYMDhmsMin = "99999999999999"
												$strErrMsg = $strLocalizedString[37][1] ;*** No match
												$strYMDhmsMaxFilename = ""
												$strYMDhmsMinFilename = $strYMDhmsMaxFilename
											EndIf
										Else
											$strErrMsg = $strLocalizedString[49][1] ;*** ExifTool.exe not found
										EndIf
									Case "Nam|Dir", "Nam|Nam"
										_NamGetFileTS($lstPreviewItem[$i][$cFPFul])
								EndSwitch
								;************************************************************************************************************************
								If $strErrMsg = "" Then
									If $intNumFils = 0 Then
										$strErrMsg = $strLocalizedString[36][1] ;*** Directory is empty / contains no files
									Else
										If $strYMDhmsMax = "00000000000000" Or $strYMDhmsMin = "99999999999999" Then
											$strErrMsg = $strLocalizedString[37][1] ;*** No match
										EndIf
									EndIf
								EndIf

								$lstPreviewItem[$i][$cTxErr] = $strErrMsg
								$lstPreviewItem[$i][$cDtMax] = $strYMDhmsMax
								$lstPreviewItem[$i][$cDtMin] = $strYMDhmsMin
								$lstPreviewItem[$i][$cFNMax] = $strYMDhmsMaxFilename
								$lstPreviewItem[$i][$cFNMin] = $strYMDhmsMinFilename

							EndIf

							$strBound = "Max"
							If GUICtrlRead($radioSetOldestDate) = $GUI_CHECKED Then $strBound = "Min"

							$lstPreviewItem[$i][$cDtNew] = $lstPreviewItem[$i][Eval("cDt" & $strBound)]
							If $lstPreviewItem[$i][$cDtMax] = "00000000000000" Or $lstPreviewItem[$i][$cDtMin] = "99999999999999" Then
								$lstPreviewItem[$i][$cDtNew] = ""
								$strPreviewItem &= " |" & $lstPreviewItem[$i][$cTxErr]
								If $lstPreviewItem[$i][$cFNTyp] = "Dir" Then
									$intPreviewItemColor = IniRead($strIniFile, "Configuration", "NOPDirColorRGB", 0x60A0FF)
								Else
									$intPreviewItemColor = IniRead($strIniFile, "Configuration", "NOPColorRGB", 0xA0A0A0)
								EndIf

							Else
								;*** Auflsung der Zeitstempel unter FAT: Erstelldatum 10ms, nderungsdatum 2s, Zugriffsdatum 1 Tag
								$strDtOldDateDiffFmt = StringRegExpReplace($lstPreviewItem[$i][$cDtOld], "(....)(..)(..)(..)(..)(..)", "\1/\2/\3 \4:\5:\6")
								$strDtMaxDateDiffFmt = StringRegExpReplace($lstPreviewItem[$i][$cDtMax], "(....)(..)(..)(..)(..)(..)", "\1/\2/\3 \4:\5:\6")
								$strDtMinDateDiffFmt = StringRegExpReplace($lstPreviewItem[$i][$cDtMin], "(....)(..)(..)(..)(..)(..)", "\1/\2/\3 \4:\5:\6")

								$intDateDiff = _DateDiff("s", $strDtOldDateDiffFmt, Eval("strDt" & $strBound & "DateDiffFmt"))
								If @error > 0 Then
									$strErrMsg = "*** " & $strLocalizedString[19][1] & ": " & Eval("strDt" & $strBound & "DateDiffFmt")
									$lstPreviewItem[$i][$cDtNew] = ""
									$lstPreviewItem[$i][$cTxErr] = $strErrMsg
									$strPreviewItem &= "|" & $lstPreviewItem[$i][$cTxErr]
									$intPreviewItemColor = IniRead($strIniFile, "Configuration", "NOPColorRGB", 0xA0A0A0)

								Else
									$strDateDiffSign = ""
									If $intDateDiff < 0 Then $strDateDiffSign = "-"
									If $intDateDiff > 0 Then $strDateDiffSign = "+"

									$intDateDiff = Abs($intDateDiff)

									;*** Prfung auf Abweichungen +/-1h und +/-2s (separat, da in INI auch getrennt konfigurierbar)
									$intDateDiff2 = Abs(3600 - $intDateDiff)

									$strDateDiffSymbol = ""
									If $intDateDiff = 0 Then
										$strDateDiffSymbol = "=="
									Else
										$intIgnoreTimeDiffSetting = IniRead($strIniFile, "Configuration", "Ignore1hDiff", 0) * 2 + IniRead($strIniFile, "Configuration", "Ignore2sDiff", 0)
										Switch $intIgnoreTimeDiffSetting
											Case 1
												If $intDateDiff < 3 Then $strDateDiffSymbol = "~=     ["  & $strDateDiffSign & $intDateDiff & "s]"
											Case 2
												If $intDateDiff2 = 0 Then $strDateDiffSymbol = "~=     [" & $strDateDiffSign & "1h]"
											Case 3
												If $intDateDiff  < 3 Then $strDateDiffSymbol = "~=     ["  & $strDateDiffSign & $intDateDiff & "s]"
												If $intDateDiff2 < 3 Then $strDateDiffSymbol = "~=     ["  & $strDateDiffSign & "1h" & $intDateDiff2 & "s]"
												If $intDateDiff2 = 0 Then $strDateDiffSymbol = "~=     ["  & $strDateDiffSign & "1h]"
										EndSwitch
									EndIf

									If $strDateDiffSymbol = "" Then
										$strPreviewItem &= _FmtDtTm($lstPreviewItem[$i][Eval("cDt" & $strBound)])
									Else
										$strPreviewItem &= $strDateDiffSymbol
										$lstPreviewItem[$i][$cDtNew] = ""
									EndIf
									$strPreviewItem &= "|" & $lstPreviewItem[$i][Eval("cFN" & $strBound)]

								EndIf

							EndIf

					EndSelect

					GUICtrlSetData($lstPreviewItem[$i][$cLVIdx], $strPreviewItem)
					GUICtrlSetColor($lstPreviewItem[$i][$cLVIdx], $intPreviewItemColor)
					_ListViewSetAutoColWidth(-1)

				EndIf

			Next

			_ListViewSetAutoColWidth(0)
			_BtnEnable()
			$intGUIRefresh = 0

		EndIf

		If $msg = $btnOK Then
			For $i = 1 To $strTCPNList[0]
				If $lstPreviewItem[$i][$cFPFul] <> "" Then
					$strPreviewItem = $lstPreviewItem[$i][$cFPRel]
					$strPreviewItem &= "|" & _FmtDtTm($lstPreviewItem[$i][$cDtOld])
					If $lstPreviewItem[$i][$cDtNew] = "" Then
						$strPreviewItem &= "| "
						$strErrMsg = $strLocalizedString[21][1]
					Else
						$strPreviewItem &= "|" & _FmtDtTm($lstPreviewItem[$i][$cDtNew])
						If FileSetTime($lstPreviewItem[$i][$cFPFul], $lstPreviewItem[$i][$cDtNew], $intDatetypeOldDate, 0) Then
							$strErrMsg = $strLocalizedString[22][1]
						Else
							$strErrMsg = $strLocalizedString[23][1]
						EndIf
					EndIf
					$strPreviewItem &= "|" & $strErrMsg
					GUICtrlSetData($lstPreviewItem[$i][$cLVIdx], $strPreviewItem)
					_ListViewSetAutoColWidth(0)
				EndIf
			Next

			_GUICtrlDisable()

		EndIf

	WEnd

EndIf


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _DirGetFileNames($strDirname)

	Call("_HotkeySkipDisable")

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
;~ 		$strYMDhmsMax = "00000000000000"
;~ 		$strYMDhmsMin = "99999999999999"
;~ 		$strYMDhmsMaxFilename = ""
;~ 		$strYMDhmsMinFilename = ""
;~ 		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~;~ 		$intNumFils = -1
		Return
	EndIf

	Local $strFilename, $intDirLevel

	If FileChangeDir($strDirname) = 0 Then Return

	GUICtrlSetData($lblStatus, $strLocalizedString[45][1])
	GUICtrlSetData($lblStatus2, StringMid(@WorkingDir, $intTCSrcPath))

	$strFullPath = StringReplace(@WorkingDir & "\", "\", "\")
	$intDirLevel = @extended - 1
	_ArrayAdd($strTCPNListFlat, StringFormat("%02d", $intDirLevel) & @TAB & $strFullPath)

	Local $shndSearch = FileFindFirstFile("*.*") ;*** FileFindFirstFile: If the Folder is empty the @error is set to 1.
	If @error Then Return

	While 1
		$strFilename = FileFindNextFile($shndSearch)
		If @error Then ExitLoop

		If StringInStr(FileGetAttrib($strFilename), "D") Then
			_DirGetFileNames($strFilename)
			FileChangeDir("..")
		Else
			$strFullPath = StringReplace(@WorkingDir & "\" & $strFilename, "\", "\")
			$intDirLevel = @extended
			$strFileType = "Fil"
			$strFileExt = StringMid($strFullPath, StringInStr($strFullPath, ".", 0, -1) + 1)
			If _ArraySearch($arrSupportedFormatsArc, $strFileExt, 1) > -1 Then $strFileType = "Arc"
			If StringRegExp($lstPreviewItem[$i][$cFNNam], $strTSInNamPattern, 0) = 1 Then $strFileType = "Nam"
			If _ArraySearch($arrSupportedFormatsPic, $strFileExt, 1) > -1 Then $strFileType = "Pic"
			If _ArraySearch($arrSupportedFormatsDoc, $strFileExt, 1) > -1 Then $strFileType = "Doc"
			If $strFileType <> "Fil" Then _ArrayAdd($strTCPNListFlat, StringFormat("%02d", $intDirLevel) & @TAB & $strFullPath)
		EndIf
	WEnd

	FileClose($shndSearch)

	Return

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _NamGetFileTS($strFilname)

	Call("_HotkeySkipDisable")

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~ 		$intNumFils = -1
		Return
	EndIf

	GUICtrlSetData($lblStatus2, StringMid($strFilname, $intTCSrcPath))

	$strTSInNamFormat = GUICtrlRead($txtTSInNamFormat)
	$strTSInNamPattern = $strTSInNamFormat
	For $p1 = 0 To 17
		$strTSInNamPattern = StringReplace($strTSInNamPattern, "$" & StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2), "\d" & StringStripWS(StringMid($cstrRepl, $p1*5+1, 4), 2))
	Next

	$arrTSInNam = StringRegExp($lstPreviewItem[$i][$cFNNam], $strTSInNamPattern, 1)
	If @error = 0 Then

;~ 		$intNumNams += 1
		$arrTSInNamPartOldDate = FileGetTime($strFilname, $intDatetypeOldDate, 0)
		$arrTSInNamPartNewDate = $arrTSInNamPartOldDate
		$strFilname = StringTrimLeft($strFilname, StringInStr($strFilname, "\", 0, -1))

;~ 		$strTSInNamFormat = IniRead($strIniFile, "Configuration", "TimestampInFilenameFormat", "")
;~ 		$strTSInNamFormat = GUICtrlRead($txtTSInNamFormat)
		For $p1 = 0 To 17
			$strTSInNamPattern = StringReplace($strTSInNamFormat, "$" & StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2), "(\d" & StringStripWS(StringMid($cstrRepl, $p1*5+1, 4), 2) & ")")
			For $p2 = 0 To 17
				$strTSInNamPattern = StringReplace($strTSInNamPattern, "$" & StringStripWS(StringMid($cstrSrch, $p2*5+1, 4), 2), StringStripWS(StringMid($cstrMask, $p2*5+1, 4), 2))
			Next
			;*** Merkwrdigerweise liefert StringRegExp("test", "pattern",flag) im Falle "No Match" nicht @error = 1, sondern @error = 0 und den global match (?) zurck
			$arrTSInNamPart = StringRegExp($strFilname, $strTSInNamPattern, 1)
			If @error = 0 And StringLen($arrTSInNamPart[0]) <= StringLen(StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2)) Then
				$arrTSInNamPartNewDate[Int($p1 / 3)] = $arrTSInNamPart[0]
;~ 				ConsoleWrite("[" & $p1 & "]: " & "$" & StringStripWS(StringMid($cstrSrch, $p1*5+1, 4), 2) & "; $arrTSInNamPart[0]: " & $arrTSInNamPart[0] & @CRLF) ;debug
			EndIf
		Next

		If StringLen($arrTSInNamPartNewDate[0]) = 2 Then
			If $arrTSInNamPartNewDate[0] >= 30 Then
				$arrTSInNamPartNewDate[0] = StringRight("19" & $arrTSInNamPartNewDate[0], 4) ;Y
			Else
				$arrTSInNamPartNewDate[0] = StringRight("20" & $arrTSInNamPartNewDate[0], 4) ;Y
			EndIf
		EndIf
		$arrTSInNamPartNewDate[1] = StringRight("0" & $arrTSInNamPartNewDate[1], 2) ;M
		$arrTSInNamPartNewDate[2] = StringRight("0" & $arrTSInNamPartNewDate[2], 2) ;D
		$arrTSInNamPartNewDate[3] = StringRight("0" & $arrTSInNamPartNewDate[3], 2) ;h
		$arrTSInNamPartNewDate[4] = StringRight("0" & $arrTSInNamPartNewDate[4], 2) ;n
		$arrTSInNamPartNewDate[5] = StringRight("0" & $arrTSInNamPartNewDate[5], 2) ;s

		$strYMDhmsCur = ""
		For $j = 0 To 5 ;Y M D h n s
			$strYMDhmsCur &= $arrTSInNamPartNewDate[$j]
		Next
		$strYMDhmsMax = $strYMDhmsCur
		$strYMDhmsMaxFilename = $strFilname
		$strYMDhmsMin = $strYMDhmsCur
		$strYMDhmsMinFilename = $strFilname

	Else
		$strErrMsg = $strLocalizedString[37][1] ;*** No match

	EndIf

	Return

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _PicOrDocGetDateTimeOriginal($strDirname, $strFileType)

	Call("_HotkeySkipDisable")

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~ 		$intNumFils = -1
		Return
	EndIf

	GUICtrlSetData($lblStatus, $strLocalizedString[25][1])
	GUICtrlSetData($lblStatus2, StringMid($strDirname, $intTCSrcPath))

	$strExifToolTag = ""
	$strExifToolExt = ""
	If $strFileType = "Pic" Then
		$strExifToolTag = GUICtrlRead($lblExifToolTagPic)
		For $i = 1 To $arrSupportedFormatsPic[0]
			$strExifToolExt &= " -ext " & $arrSupportedFormatsPic[$i]
		Next
	EndIf
	If $strFileType = "Doc" Then
		$strExifToolTag = GUICtrlRead($lblExifToolTagDoc)
		For $i = 1 To $arrSupportedFormatsDoc[0]
			$strExifToolExt &= " -ext " & $arrSupportedFormatsDoc[$i]
		Next
	EndIf

	;*** Formatierungsoption '-d "%Y%m%d%H%M%S"' greift (u.a.?) nicht bei *.doc, *.xls, *.ppt, ExifTool-Ausgabe wird daher vom Script formatiert
	$strExifToolCmd = FileGetShortName($strExifToolExeFull) & ' -' & $strExifToolTag & ' -s -s -s' & $strExifToolExt & ' "' & $strDirname & '"'
	$strExifToolList = ""
	$pidExifTool = Run(@ComSpec & " /c " & $strExifToolCmd, "", @SW_HIDE, $STDOUT_CHILD)
	While 1
		$strStdoutRead = StdoutRead($pidExifTool)
		If @error Then ExitLoop
		$strExifToolList &= $strStdoutRead
	Wend
	ProcessWaitClose($pidExifTool)

	$arrExifToolListTmp = ""
	$arrExifToolListTmp = StringSplit($strExifToolList, @CRLF, 1)
	For $i = 1 To $arrExifToolListTmp[0]
		If StringLeft($arrExifToolListTmp[$i], 8) = "========" Then
			$arrExifToolListTmp[$i] = StringReplace($arrExifToolListTmp[$i], "/", "\")
		Else
			$arrExifToolListTmp[$i] = StringReplace($arrExifToolListTmp[$i], ":", "")
			$arrExifToolListTmp[$i] = StringReplace($arrExifToolListTmp[$i], " ", "")
			$arrExifToolListTmp[$i] = StringLeft($arrExifToolListTmp[$i], 14) ;ggf. vorhandenen UTC-Offset ("+n:nn") abschneiden
		EndIf
	Next
	;Zl n-2:    x directories scanned
    ;Zl n-1:    y image files read
	;Zl n  :
	;*** Letzten Eintrag (ist eine Leerzeile) briglassen (sonst: wenn bei letztem Eintrag "kein Treffer", dann Fehler bei Bestimmung '$strYMDhmsMax = $arrExifToolList[$intExifToolListIndex+1]')
	_ArrayDelete($arrExifToolListTmp, $arrExifToolListTmp[0]-1)
	_ArrayDelete($arrExifToolListTmp, $arrExifToolListTmp[0]-2)

	_ArrayConcatenate($arrExifToolList, $arrExifToolListTmp)

	Return

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#cs
Func _PicGetDateTimeOriginal($strPicname)

	Call("_HotkeySkipDisable")

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~ 		$intNumFils = -1
		Return
	EndIf

	;ExifTool fr alle Dateien im @WorkingDir aufrufen:
	;"ExifTool -q -q -f -p "$FileName ... $DateTimeOriginal" -ext jpg -ext tif ."
	GUICtrlSetData($lblStatus2, StringMid($strPicname, $intTCSrcPath))
;~ 	$strExifToolCmd = FileGetShortName($strExifToolExeFull) & " -DateTimeOriginal -fast -s -s -s " & '"' & FileGetShortName($strPicname) & '"'
	$strExifToolCmd = FileGetShortName($strExifToolExeFull) & " -d " & '"' & "%Y%m%d%H%M%S" & '"' & " -DateTimeOriginal -fast -s -s -s " & '"' & FileGetShortName($strPicname) & '"'

	;exiftool.exe -DateTimeOriginal -s -s -s -d "%Y%m%d%H%M%S" -ext jpg -ext tif -r .
	;======== ./20080603_202152.tif
	;20080603202152
	;======== ./Abstammungsurkunde Marie Charlotte.tif
	;======== ./Fotos/20080603_202152.jpg
	;20080603202152
	;[]
	;======== ./Fotos/Versandvorschlge 081023/20081012_185345.jpg
	;20081012185345
	;    5 directories scanned
    ;   19 image files read
	;

	$pidExifTool = Run(@ComSpec & " /c " & $strExifToolCmd, "", @SW_HIDE, $STDERR_MERGED) ;debug

	$strExifToolList = ""
	While 1
		$strStdoutRead = StdoutRead($pidExifTool)
		If @error Then ExitLoop
		$strExifToolList &= $strStdoutRead
	Wend
	ProcessWaitClose($pidExifTool)
	$strExifToolList = StringReplace($strExifToolList, @CRLF, "")

	;*** Falls die Ausgabe leer ist...
	If StringStripWS($strExifToolList, 8) = "" Then
		$strYMDhmsMaxFilename = $strPicname
		$strYMDhmsMinFilename = $strPicname
		$strErrMsg = $strLocalizedString[37][1] ;*** No match
		Return
	EndIf

	;*** Falls die Ausgabe eine Fehlermeldung enthlt...
	;*** "Error: Unknown file type - {Dateiname}"
	If StringLeft($strExifToolList, 6) = "Error:" Then
		$strYMDhmsMaxFilename = $strPicname
		$strYMDhmsMinFilename = $strPicname
		$strErrMsg = "*** " & $strExifToolList
		Return
	EndIf

	$intNumPics += 1
	$strPicname = StringTrimLeft($strPicname, StringInStr($strPicname, "\", 0, -1))

	;*** ExifTool Fehlwert-Ausgabeformat fr DateTimeOriginal: "%Y:%m:%d %H:%M:%S" (z.B. "2008:08:24 17:28:34")
	;*** Kann mit Option "-d" formatiert werden (s.o. bei $strExifToolCmd)
;~ 	$strYMDhmsCur = StringStripWS(StringReplace($strExifToolList, ":", ""), 8)
	$strYMDhmsCur = $strExifToolList
	$strYMDhmsMax = $strYMDhmsCur
	$strYMDhmsMaxFilename = $strPicname
	$strYMDhmsMin = $strYMDhmsCur
	$strYMDhmsMinFilename = $strPicname

	Return

EndFunc
#ce
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _ArcGetMinMaxFileTS($strArcname)

	Local $strFilename

	Call("_HotkeySkipDisable")

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~ 		$intNumFils = -1
		Return
	EndIf

	GUICtrlSetData($lblStatus2, StringMid($strArcname, $intTCSrcPath))
	$str7zCmd = FileGetShortName($str7zExeFull) & " l " & '"' & FileGetShortName($strArcname) & '"'
	$pid7z = Run(@ComSpec & " /c " & $str7zCmd, "", @SW_HIDE, $STDOUT_CHILD)

	$str7zList = ""
	While 1
		$strStdoutRead = StdoutRead($pid7z)
		If @error Then ExitLoop
		$str7zList &= $strStdoutRead
	Wend
	ProcessWaitClose($pid7z)
	$str7zList = StringSplit($str7zList, @CRLF, 1)

	;*** Falls das 7z-Listing eine Fehlermeldung enthlt...
	;*** "xyz is not supported archive"
	If StringLeft($str7zList[4], 6) = "Error:" Then
		$strYMDhmsMaxFilename = $str7zList[4]
		$strYMDhmsMinFilename = $str7zList[4]
		$strErrMsg = "*** " & $str7zList[4]
		Return
	EndIf
	;*** "cannot find archive" (tritt auf, wenn der Dateipfad nicht in Anfhrungszeichen eingeschlossen ist und '&' enthlt)
	If StringLeft($str7zList[5], 6) = "Error:" Then
		$strYMDhmsMaxFilename = $str7zList[6]
		$strYMDhmsMinFilename = $str7zList[6]
		$strErrMsg = "*** Error: " & $str7zList[6] & " " & FileGetShortName($strArcname)
		Return
	EndIf

	;*** Ersten und letzten Eintrag des 7z-Listings ermitteln und OEM-Zeichensatz in "ANSI"-Zeichensatz konvertieren
	$int7zListFirstEntry = 0
	$int7zListLastEntry = 0
	For $int7zList = 1 To $str7zList[0]
		$arrOemToChar = DllCall('user32.dll', 'Int', 'OemToChar', 'str', $str7zList[$int7zList], 'str', '')
		$str7zList[$int7zList] = $arrOemToChar[2]
		If $str7zList[$int7zList] = "------------------- ----- ------------ ------------  ------------------------" Then
			If $int7zListFirstEntry = 0 Then
				$int7zListFirstEntry = $int7zList + 1
			Else
				$int7zListLastEntry = $int7zList - 1
			EndIf
		EndIf
	Next

	For $int7zList = $int7zListFirstEntry To $int7zListLastEntry

		$strAttrCur = StringMid($str7zList[$int7zList], 21, 5)

		If StringLeft($strAttrCur, 1) <> "D" Then

			$intNumFils += 1
			$strYMDhmsCur = StringRegExpReplace(StringLeft($str7zList[$int7zList], 19), "[^0-9]", "")
			$strFilename = StringMid($str7zList[$int7zList], 54)
			$strFilename = StringTrimLeft($strFilename, StringInStr($strFilename, "\", 0, -1))

			$intEvalYMDhms = 0
			If GUICtrlRead($chkFileSpec) = $GUI_UNCHECKED Then $intEvalYMDhms = 1
			If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecRegEx) = $GUI_UNCHECKED And $strFilename = GUICtrlRead($txtFileSpec) Then $intEvalYMDhms = 1
			If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecRegEx) = $GUI_CHECKED And StringRegExp($strFilename, GUICtrlRead($txtFileSpec)) = 1 Then $intEvalYMDhms = 1
			If GUICtrlRead($chkEvalIgnorelist) = $GUI_CHECKED Then
				$txtFileSpecIgnore = IniReadSection($strIniFile, "IgnoreList")
				If @error = 1 Then
					$intEvalYMDhms = 0
				Else
					For $intFileSpecIgnore = 1 To $txtFileSpecIgnore[0][0]
;~~~~~
						;*** DOS-Dateinamensmuster "*" und "?" in RegEx umsetzen
						$txtFileSpecIgnoreRegExp = $txtFileSpecIgnore[$intFileSpecIgnore][1]
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, ".", "\.")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "+", "\+")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "(", "\(")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, ")", "\)")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "[", "\[")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "]", "\]")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "{", "\{")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "}", "\}")
						;$intNumDOSpatterns = 0
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "?", ".")
						;$intNumDOSpatterns += @extended
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "*", ".*")
						;$intNumDOSpatterns += @extended
						$txtFileSpecIgnoreRegExp = "(?i)" & $txtFileSpecIgnoreRegExp

						If StringRegExp($strFilename, $txtFileSpecIgnoreRegExp, 0) = 1 Then
;~~~~~
;~ 						If StringLower($strFilename) = StringLower($txtFileSpecIgnore[$intFileSpecIgnore][1]) Then
							$intEvalYMDhms = -1
							ExitLoop
						EndIf
					Next
				EndIf
			EndIf

			If $intEvalYMDhms > -1 Then ;$intEvalYMDhms = -1, wenn Datei in Ignorlist enthalten ist
				If $strYMDhmsCur > $strYMDhmsMaxNoFileSpec Then
					$strYMDhmsMaxNoFileSpec = $strYMDhmsCur
					$strYMDhmsMaxFilenameNoFileSpec = $strFilename
				EndIf
				If $strYMDhmsCur < $strYMDhmsMinNoFileSpec Then
					$strYMDhmsMinNoFileSpec = $strYMDhmsCur
					$strYMDhmsMinFilenameNoFileSpec = $strFilename
				EndIf
			EndIf

			If 	$intEvalYMDhms = 1 Then
				If $strYMDhmsCur > $strYMDhmsMax Then
					$strYMDhmsMax = $strYMDhmsCur
					$strYMDhmsMaxFilename = $strFilename
				EndIf
				If $strYMDhmsCur < $strYMDhmsMin Then
					$strYMDhmsMin = $strYMDhmsCur
					$strYMDhmsMinFilename = $strFilename
				EndIf
			EndIf

		EndIf

	Next

	Return

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _DirGetMinMaxFileTS($strDirname)

	Local $strFilename

	If @HotKeyPressed = "{Pause}" And $booSkipCurrentDir = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[39][1] ;*** Skipped
		$booSkipCurrentDir = False
;~ 		$intNumFils = -1
		Return
	EndIf

	If @HotKeyPressed = "{ESC}" And $booStopScanning = True Then
		$strYMDhmsMax = "00000000000000"
		$strYMDhmsMin = "99999999999999"
		$strYMDhmsMaxFilename = ""
		$strYMDhmsMinFilename = ""
		$strErrMsg = $strLocalizedString[40][1] ;*** Canceled
;~ 		$intNumFils = -1
		Return
	EndIf

;~ 	FileChangeDir($strDirname)
;~ 	If @error = 1 Then Return
	If FileChangeDir($strDirname) = 0 Then Return

	Local $shndSearch = FileFindFirstFile("*.*") ;*** FileFindFirstFile: If the Folder is empty the @error is set to 1.
	If @error Then Return
	GUICtrlSetData($lblStatus2, StringMid(@WorkingDir, $intTCSrcPath))

	While 1
		$strFilename = FileFindNextFile($shndSearch)
		If @error Then ExitLoop

		If StringInStr(FileGetAttrib($strFilename), "D") And GUICtrlRead($chkFileGetTimeRecurse) = $GUI_CHECKED Then
			_DirGetMinMaxFileTS($strFilename)
			FileChangeDir("..")
		EndIf

		If Not StringInStr(FileGetAttrib($strFilename), "D") Then
			$intNumFils += 1
			$strYMDhmsCur = FileGetTime($strFilename, $intDatetypeNewDate, 1)

			$intEvalYMDhms = 0
			If GUICtrlRead($chkFileSpec) = $GUI_UNCHECKED Then $intEvalYMDhms = 1
			If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecRegEx) = $GUI_UNCHECKED And $strFilename = GUICtrlRead($txtFileSpec) Then $intEvalYMDhms = 1
			If GUICtrlRead($chkFileSpec) = $GUI_CHECKED And GUICtrlRead($chkFileSpecRegEx) = $GUI_CHECKED And StringRegExp($strFilename, GUICtrlRead($txtFileSpec)) = 1 Then $intEvalYMDhms = 1
			If GUICtrlRead($chkEvalIgnorelist) = $GUI_CHECKED Then
				$txtFileSpecIgnore = IniReadSection($strIniFile, "IgnoreList")
				If @error = 1 Then
					$intEvalYMDhms = 0
				Else
					For $intFileSpecIgnore = 1 To $txtFileSpecIgnore[0][0]
						;*** DOS-Dateinamensmuster "*" und "?" in RegEx umsetzen
						$txtFileSpecIgnoreRegExp = $txtFileSpecIgnore[$intFileSpecIgnore][1]
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, ".", "\.")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "+", "\+")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "(", "\(")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, ")", "\)")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "[", "\[")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "]", "\]")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "{", "\{")
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "}", "\}")
						;$intNumDOSpatterns = 0
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "?", ".")
						;$intNumDOSpatterns += @extended
						$txtFileSpecIgnoreRegExp = StringReplace($txtFileSpecIgnoreRegExp, "*", ".*")
						;$intNumDOSpatterns += @extended
						$txtFileSpecIgnoreRegExp = "(?i)" & $txtFileSpecIgnoreRegExp

						If StringRegExp($strFilename, $txtFileSpecIgnoreRegExp, 0) = 1 Then
;~ 						If StringLower($strFilename) = StringLower($txtFileSpecIgnore[$intFileSpecIgnore][1]) Then
							$intEvalYMDhms = -1
							ExitLoop
						EndIf
					Next
				EndIf
			EndIf

			If $intEvalYMDhms > -1 Then ;$intEvalYMDhms = -1, wenn Datei in Ignorlist enthalten ist
				If $strYMDhmsCur > $strYMDhmsMaxNoFileSpec Then
					$strYMDhmsMaxNoFileSpec = $strYMDhmsCur
					$strYMDhmsMaxFilenameNoFileSpec = $strFilename
				EndIf
				If $strYMDhmsCur < $strYMDhmsMinNoFileSpec Then
					$strYMDhmsMinNoFileSpec = $strYMDhmsCur
					$strYMDhmsMinFilenameNoFileSpec = $strFilename
				EndIf
			EndIf

			If 	$intEvalYMDhms = 1 Then
				If $strYMDhmsCur > $strYMDhmsMax Then
					$strYMDhmsMax = $strYMDhmsCur
					$strYMDhmsMaxFilename = $strFilename
				EndIf
				If $strYMDhmsCur < $strYMDhmsMin Then
					$strYMDhmsMin = $strYMDhmsCur
					$strYMDhmsMinFilename = $strFilename
				EndIf
			EndIf

		EndIf
	WEnd
	FileClose($shndSearch)
	Return

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _FmtDtTm($strDateTime) ;Inputformat: YYYYMMDDhhmmss / Outputformat: Datum & " " & Uhrzeit entsprechnd INI-Key "DateFormat"
;~ 	Return StringRegExpReplace($strDateTime, "(....)(..)(..)(..)(..)(..)", "\3.\2.\1 \4:\5:\6")
	Local $strDateTimeFormatted = $strDateFormat & " " & $strTimeFormat
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "YYYY", StringMid($strDateTime, 1, 4), 0, 1)
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "MM", StringMid($strDateTime, 5, 2), 0, 1)
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "DD", StringMid($strDateTime, 7, 2), 0, 1)
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "hh", StringMid($strDateTime, 9, 2), 0, 1)
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "mm", StringMid($strDateTime, 11, 2), 0, 1)
	$strDateTimeFormatted = StringReplace($strDateTimeFormatted, "ss", StringMid($strDateTime, 13, 2), 0, 1)
	Return $strDateTimeFormatted
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _FmtDt($strDateTime) ;Inputformat: YYYYMMDD / Outputformat: Datum entsprechnd INI-Key "DateFormat"
	Local $strDateFormatted = $strDateFormat
	$strDateFormatted = StringReplace($strDateFormatted, "YYYY", StringMid($strDateTime, 1, 4), 0, 1)
	$strDateFormatted = StringReplace($strDateFormatted, "MM", StringMid($strDateTime, 5, 2), 0, 1)
	$strDateFormatted = StringReplace($strDateFormatted, "DD", StringMid($strDateTime, 7, 2), 0, 1)
	Return $strDateFormatted
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _FmtTm($strDateTime) ;Inputformat: hhmmss / Outputformat: Uhrzeit entsprechnd INI-Key "TimeFormat"
	Local $strTimeFormatted = $strTimeFormat
	$strTimeFormatted = StringReplace($strTimeFormatted, "hh", StringMid($strDateTime, 1, 2), 0, 1)
	$strTimeFormatted = StringReplace($strTimeFormatted, "mm", StringMid($strDateTime, 3, 2), 0, 1)
	$strTimeFormatted = StringReplace($strTimeFormatted, "ss", StringMid($strDateTime, 5, 2), 0, 1)
	Return $strTimeFormatted
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _UnfmtDt($strDateTime) ;Inputformat: Datum entsprechnd INI-Key "DateFormat" / Outputformat: YYYYMMDD
	Local $strDateUnformatted = ""
	$strDateUnformatted &= StringMid($strDateTime, StringInStr($strDateFormat, "YYYY", 1), 4)
	$strDateUnformatted &= StringMid($strDateTime, StringInStr($strDateFormat, "MM", 1), 2)
	$strDateUnformatted &= StringMid($strDateTime, StringInStr($strDateFormat, "DD", 1), 2)
	Return $strDateUnformatted
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _UnfmtTm($strDateTime) ;Inputformat: Uhrzeit entsprechnd INI-Key "TimeFormat" / Outputformat: hhmmss
	Local $strTimeUnformatted = ""
	$strTimeUnformatted &= StringMid($strDateTime, StringInStr($strTimeFormat, "hh", 1), 2)
	$strTimeUnformatted &= StringMid($strDateTime, StringInStr($strTimeFormat, "mm", 1), 2)
	$strTimeUnformatted &= StringMid($strDateTime, StringInStr($strTimeFormat, "ss", 1), 2)
	Return $strTimeUnformatted
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _VerifyDt($strDateTime) ;Input: GUICtrlRead($txtUserdefDateDMY)

	If $strDateTime = "" Then Return True ;*** Datum wurde leergelassen -> soll unverndert bernommen werden

	If StringLen($strDateTime) <> StringLen($strDateFormat) Then Return False ;*** Prfung des Datums: Lnge bergebenes Datum = Lnge Datumstemplate?

	;*** Prfung des Jahres
	$strDateY = StringMid($strDateTime, StringInStr($strDateFormat, "YYYY", 1), 4)
	If StringRegExp($strDateY, "\D") = 1 Then Return False ;*** Numerisch?

	;*** Prfung des Monats
	$strDateM = StringMid($strDateTime, StringInStr($strDateFormat, "MM", 1), 2)
	If StringRegExp($strDateM, "\D") = 1 Then Return False ;*** Numerisch?
	If $strDateM*1 < 1 Or $strDateM*1 > 12 Then Return False ;*** 01 <= MM <= 12?

	;*** Prfung des Tages
	$strDateD = StringMid($strDateTime, StringInStr($strDateFormat, "DD", 1), 2)
	If StringRegExp($strDateD, "\D") = 1 Then Return False ;*** Numerisch?
	;*** $strDateY ist Schaltjahr
	If (Mod($strDateY, 4) = 0 And Mod($strDateY, 100) <> 0) Or Mod($strDateY, 400) = 0 Then
		$strTmp = "31|29|31|30|31|30|31|31|30|31|30|31|"
	;*** $strDateY ist kein Schaltjahr
	Else
		$strTmp = "31|28|31|30|31|30|31|31|30|31|30|31|"
	EndIf
	If $strDateD*1 < 1 Or $strDateD*1 > StringMid($strTmp, ($strDateM*1-1)*3+1, 2)*1 Then Return False ;*** 01 <= DD <= LetzterTagDesMonats?

	Return True

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _VerifyTm($strDateTime) ;Input: GUICtrlRead($txtUserdefDateHMS)

	If $strDateTime = "" Then Return True ;*** Uhrzeit wurde leergelassen -> soll unverndert bernommen werden

	If StringLen($strDateTime) <> StringLen($strTimeFormat) Then Return False ;*** Prfung der Uhrzeit: Lnge bergebene Uhrzeit = Lnge Uhrzeittemplate?

	;*** Prfung der Stunde
	$strTimeH = StringMid($strDateTime, StringInStr($strTimeFormat, "hh", 1), 2)
	If StringRegExp($strTimeH, "\D") = 1 Then Return False ;*** Numerisch?
	If $strTimeH*1 > 23 Then Return False ;*** 00 <= hh <= 23?

	;*** Prfung der Minute
	$strTimeM = StringMid($strDateTime, StringInStr($strTimeFormat, "mm", 1), 2)
	If StringRegExp($strTimeM, "\D") = 1 Then Return False ;*** Numerisch?
	If $strTimeM*1 > 59 Then Return False ;*** 00 <= hh <= 59?

	;*** Prfung der Sekunde
	$strTimeS = StringMid($strDateTime, StringInStr($strTimeFormat, "ss", 1), 2)
	If StringRegExp($strTimeS, "\D") = 1 Then Return False ;*** Numerisch?
	If $strTimeS*1 > 59 Then Return False ;*** 00 <= hh <= 59?

	Return True

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _HotkeySkipEnable()
	HotKeySet("{Pause}", "_SkipCurrentDir")
	$booSkipCurrentDir = False
	GUICtrlSetData($lblHintPause, $strLocalizedString[41][1])
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _HotkeySkipDisable()
	HotKeySet("{Pause}")
	$booSkipCurrentDir = False
	GUICtrlSetData($lblHintPause, "")
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _GUICtrlDisable()
	GUICtrlSetState($chkDirRecurse, $GUI_DISABLE)
	GUICtrlSetState($icoArcDir, $GUI_DISABLE)
	GUICtrlSetState($icoArcArc, $GUI_DISABLE)
	GUICtrlSetState($icoArcArcExclude, $GUI_DISABLE)
	GUICtrlSetState($radioSetUserdefDate, $GUI_DISABLE)
	GUICtrlSetState($txtUserdefDateDMY, $GUI_DISABLE)
	GUICtrlSetState($txtUserdefDateHMS, $GUI_DISABLE)
	GUICtrlSetState($btnSetCurrentDate, $GUI_DISABLE)
	GUICtrlSetState($radioSetRelDate, $GUI_DISABLE)
	GUICtrlSetState($radioSetRelDate, $GUI_DISABLE)
	GUICtrlSetState($txtRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($updRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($cbxRelDateType, $GUI_DISABLE)
	GUICtrlSetState($radioSetTimestampFromNam, $GUI_DISABLE)
;~ 	GUICtrlSetState($lblTSInNamFormat, $GUI_DISABLE)
	GUICtrlSetState($txtTSInNamFormat, $GUI_DISABLE)
	GUICtrlSetState($radioSetTimestampFromPic, $GUI_DISABLE)
	GUICtrlSetState($radioSetNewestDate, $GUI_DISABLE)
	GUICtrlSetState($radioSetOldestDate, $GUI_DISABLE)
	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpec, $GUI_DISABLE)
	GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
	GUICtrlSetState($chkEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($radioSetTimestampFromNam, $GUI_DISABLE)
	GUICtrlSetState($radioSetTimestampFromPic, $GUI_DISABLE)
	GUICtrlSetState($lblExifToolTagPic, $GUI_DISABLE)
	GUICtrlSetState($radioSetTimestampFromDoc, $GUI_DISABLE)
	GUICtrlSetState($lblExifToolTagDoc, $GUI_DISABLE)
	GUICtrlSetState($cbxDatetypeOldDate, $GUI_DISABLE)
	GUICtrlSetState($cbxDatetypeNewDate, $GUI_DISABLE)
	GUICtrlSetState($btnOK, $GUI_DISABLE)
	GUICtrlSetState($btnOK, $GUI_HIDE)
	GUICtrlSetState($btnPreview, $GUI_DISABLE)
	GUICtrlSetState($btnPreview, $GUI_HIDE)
	GUICtrlSetData($btnCancel, $strLocalizedString[24][1])
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _BtnDisable()
	Call("_HotkeySkipEnable")
	HotKeySet("{Esc}", "_StopScanning")
	$booStopScanning = False
	GUICtrlSetData($lblHintEsc, $strLocalizedString[42][1])

	GUICtrlSetState($btnCancel, $GUI_DISABLE)
	GUICtrlSetState($btnOK, $GUI_DISABLE)
	GUICtrlSetState($btnPreview, $GUI_DISABLE)
	GUICtrlSetState($btnSaveSettings, $GUI_DISABLE)
	GUICtrlSetState($btnSavePos, $GUI_DISABLE)
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _BtnEnable()
	Call("_HotkeySkipDisable")
	HotKeySet("{Esc}")
	$booStopScanning = False
	GUICtrlSetData($lblHintEsc, "")

	GUICtrlSetState($btnCancel, $GUI_ENABLE)
	GUICtrlSetState($btnOK, $GUI_ENABLE)
	GUICtrlSetState($btnPreview, $GUI_ENABLE)
	GUICtrlSetState($btnSaveSettings, $GUI_ENABLE)
	GUICtrlSetState($btnSavePos, $GUI_ENABLE)
	GUICtrlSetData($lblStatus, "")
	GUICtrlSetData($lblStatus2, "")
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _radioSetUserdefDate()
	GUICtrlSetState($txtRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($updRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($cbxRelDateType, $GUI_DISABLE)

	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_DISABLE)
	GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
	GUICtrlSetState($chkEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblDatetypeNewDate, $GUI_DISABLE)
	GUICtrlSetState($cbxDatetypeNewDate, $GUI_DISABLE)

	GUICtrlSetState($txtTSInNamFormat, $GUI_DISABLE)

	GUICtrlSetState($txtUserdefDateDMY, $GUI_ENABLE)
	GUICtrlSetState($txtUserdefDateHMS, $GUI_ENABLE)
	GUICtrlSetState($txtUserdefDateDMY, $GUI_FOCUS)
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _radioSetRelDate()
	GUICtrlSetState($txtUserdefDateDMY, $GUI_DISABLE)
	GUICtrlSetState($txtUserdefDateHMS, $GUI_DISABLE)

	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_DISABLE)
	GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
	GUICtrlSetState($chkEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblDatetypeNewDate, $GUI_DISABLE)
	GUICtrlSetState($cbxDatetypeNewDate, $GUI_DISABLE)

	GUICtrlSetState($txtTSInNamFormat, $GUI_DISABLE)

	GUICtrlSetState($txtRelDateVal, $GUI_ENABLE)
	GUICtrlSetState($updRelDateVal, $GUI_ENABLE)
	GUICtrlSetState($cbxRelDateType, $GUI_ENABLE)
	GUICtrlSetState($txtRelDateVal, $GUI_FOCUS)
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _radioSetTimestampFromNamOrPicOrDoc($trigger)
	GUICtrlSetState($txtUserdefDateDMY, $GUI_DISABLE)
	GUICtrlSetState($txtUserdefDateHMS, $GUI_DISABLE)

	GUICtrlSetState($txtRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($updRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($cbxRelDateType, $GUI_DISABLE)

	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_DISABLE)
	GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
	GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
	GUICtrlSetState($chkEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblEvalIgnorelist, $GUI_DISABLE)
	GUICtrlSetState($lblDatetypeNewDate, $GUI_DISABLE)
	GUICtrlSetState($cbxDatetypeNewDate, $GUI_DISABLE)

	If $trigger = $radioSetTimestampFromNam Then
		GUICtrlSetState($txtTSInNamFormat, $GUI_ENABLE)
	Else
		GUICtrlSetState($txtTSInNamFormat, $GUI_DISABLE)
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _radioSetNewestOrOldestDate()
	GUICtrlSetState($txtUserdefDateDMY, $GUI_DISABLE)
	GUICtrlSetState($txtUserdefDateHMS, $GUI_DISABLE)

	GUICtrlSetState($txtRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($updRelDateVal, $GUI_DISABLE)
	GUICtrlSetState($cbxRelDateType, $GUI_DISABLE)

	GUICtrlSetState($chkFileGetTimeRecurse, $GUI_ENABLE)
	GUICtrlSetState($chkFileSpec, $GUI_ENABLE)
	If GUICtrlRead($chkFileSpec) = $GUI_CHECKED Then
		GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_ENABLE)
		GUICtrlSetState($txtFileSpec, $GUI_ENABLE)
		GUICtrlSetState($chkFileSpecRegEx, $GUI_ENABLE)
	Else
		GUICtrlSetState($chkFileSpecIgnoreIfNoMatch, $GUI_DISABLE)
		GUICtrlSetState($txtFileSpec, $GUI_DISABLE)
		GUICtrlSetState($chkFileSpecRegEx, $GUI_DISABLE)
	EndIf
	GUICtrlSetState($chkEvalIgnorelist, $GUI_ENABLE)
	GUICtrlSetState($lblEvalIgnorelist, $GUI_ENABLE)
	GUICtrlSetState($lblDatetypeNewDate, $GUI_ENABLE)
	GUICtrlSetState($cbxDatetypeNewDate, $GUI_ENABLE)

	GUICtrlSetState($txtTSInNamFormat, $GUI_DISABLE)
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _StopScanning()
	If WinActive($frmGUI) Then
		$booStopScanning = True
	Else
		HotKeySet("{Esc}")
		Send("{Esc}")
		HotKeySet("{Esc}", "_StopScanning")
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _SkipCurrentDir()
	If WinActive($frmGUI) Then
		$booSkipCurrentDir = True
	Else
		HotKeySet("{Pause}")
		Send("{Pause}")
		HotKeySet("{Pause}", "_SkipCurrentDir")
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _IsLeapYear($strYear)
	If (Mod($strYear, 4) = 0 And Mod($strYear, 100) <> 0) Or Mod($strYear, 400) = 0 Then
		Return True
	Else
		Return False
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _LastDayOfMonth($strYear, $strMonth)
	If _IsLeapYear($strYear) Then
		Return StringMid("31|29|31|30|31|30|31|31|30|31|30|31", ($strMonth-1)*3+1, 2) * 1
	Else
		Return StringMid("31|28|31|30|31|30|31|31|30|31|30|31", ($strMonth-1)*3+1, 2) * 1
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _ListViewSetAutoColWidth($intListViewColAutoWidthUseWhat)

	;*** $LVM_SETCOLUMNWIDTH = 0x101E; $LVSCW_AUTOSIZE = -1; $LVSCW_AUTOSIZE_USEHEADER = -2
	;*** $intListViewColAutoWidthUseWhat: -1 = AutoWidth column; -2 = AutoWidth header
	Local $intListViewColNum

	If $intListViewColAutoWidthUseWhat = 0 Then

		;*** Optimale Spaltenbreite fr alle Spalten setzen: Anpassen an breitestes ListView-Item
		For $intListViewColNum = 0 To 3
			If IsHWnd($lvwPreview) Then
				DllCall("user32.dll", "long", "SendMessage", "hwnd", $lvwPreview, "int", 0x101E, "int", $intListViewColNum, "int", -1)
			Else
				GUICtrlSendMsg($lvwPreview, 0x101E, $intListViewColNum, -1)
			EndIf
			$intListViewColWidth[$intListViewColNum][1] = _ListViewGetColumnWidth($intListViewColNum)

			;*** Wenn der Header breiter ist als das breiteste ListView-Item, dann Spalte an Headerbreite anpassen
			If $intListViewColWidth[$intListViewColNum][0] > $intListViewColWidth[$intListViewColNum][1] Then
				If IsHWnd($lvwPreview) Then
					DllCall("user32.dll", "long", "SendMessage", "hwnd", $lvwPreview, "int", 0x101E, "int", $intListViewColNum, "int", -2)
				Else
					GUICtrlSendMsg($lvwPreview, 0x101E, $intListViewColNum, -2)
				EndIf
			EndIf
		Next

	Else

		;*** Optimale Spaltenbreite fr alle Spalten setzen
		For $intListViewColNum = 0 To 3
			If IsHWnd($lvwPreview) Then
				DllCall("user32.dll", "long", "SendMessage", "hwnd", $lvwPreview, "int", 0x101E, "int", $intListViewColNum, "int", $intListViewColAutoWidthUseWhat)
			Else
				GUICtrlSendMsg($lvwPreview, 0x101E, $intListViewColNum, $intListViewColAutoWidthUseWhat)
			EndIf
		Next

	EndIf

EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _ListViewGetColumnWidth($intListViewColNum)

	;*** $LVM_FIRST = 0x1000; $LVM_GETCOLUMNWIDTH = ($LVM_FIRST + 29)
	If IsHWnd($lvwPreview) Then
		Return DllCall("user32.dll", "long", "SendMessage", "hwnd", $lvwPreview, "int", 0x1000+29, "int", $intListViewColNum, "int", 0)
	Else
		Return GUICtrlSendMsg($lvwPreview, 0x1000+29, $intListViewColNum, 0)
	EndIf
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _ListViewFill()

	;*** $lstPreviewItem[0][$cDtMax] wird auf "." gesetzt, sobald Min-/Max-Datum erstmals ermittelt wurde; Grund: Wenn Startoption = "bestimmtes/relatives Datum", dann muss beim Wechsel
	;*** auf "neuestes/ltestes Datum" die Min-/Max-Ermittlung erzwungen werden. "?" / "." dienen als Indikator, ob Initialermittlung Min/Max bereits erfolgte
	$lstPreviewItem[0][$cDtMax] = "?" ;*** "?" = Min-/Max-Datumsermittlung wurde noch nicht initial durchgefhrt
	$intNumDirs = 0
	$intNumArcs = 0
	$intNumNams = 0
	$intNumPics = 0
	$intNumDocs = 0

	$strFileTypeFilter = "Dir|Arc"
	If GUICtrlRead($radioSetTimestampFromPic) = $GUI_CHECKED Then
		$strFileTypeFilter = "Dir|Pic"
	EndIf
	If GUICtrlRead($radioSetTimestampFromNam) = $GUI_CHECKED Then
		$strFileTypeFilter = "Dir|Nam"
	EndIf
	If GUICtrlRead($radioSetTimestampFromDoc) = $GUI_CHECKED Then
		$strFileTypeFilter = "Dir|Doc"
	EndIf

	$intListviewIcon = 0
	$strListviewIconfile = @ScriptDir & "\" & "SetFolderDate.icl"

	For $i = 1 To $strTCPNList[0]

		If StringRight($strTCPNList[$i], 1) = "\" Then
			$intPosLastPathDelim = StringInStr($strTCPNList[$i], "\", 0, -2)
			$lstPreviewItem[$i][$cFNNam] = StringTrimRight(StringMid($strTCPNList[$i], $intPosLastPathDelim + 1), 1)
		Else
			$intPosLastPathDelim = StringInStr($strTCPNList[$i], "\", 0, -1)
			$lstPreviewItem[$i][$cFNNam] = StringMid($strTCPNList[$i], $intPosLastPathDelim + 1)
		EndIf

		;*** "Dateityp" bestimmen: Dir=Verzeichnis; Arc=Archiv; Nam=Files mit Timestamp im Dateinamen; Pic=Picture; Doc=Document; Fil=Sonstige (irrelevante) Datei
		$intPreviewItemColor = IniRead($strIniFile, "Configuration", "NOPColorRGB", 0xA0A0A0)
		If StringRight($strTCPNList[$i], 1) = "\" Then
			$strFileType = "Dir"
			$strFileExt = ""
			$intPreviewItemColor = IniRead($strIniFile, "Configuration", "DirColorRGB", 0x0000C0)
		Else
			$strFileType = "Fil"
			$strFileExt = StringMid($strTCPNList[$i], StringInStr($strTCPNList[$i], ".", 0, -1) + 1)
			Switch $strFileTypeFilter
				Case "Dir|Arc"
					If _ArraySearch($arrSupportedFormatsArc, $strFileExt, 1) > -1 Then $strFileType = "Arc"
				Case "Dir|Nam"
					If StringRegExp($lstPreviewItem[$i][$cFNNam], $strTSInNamPattern, 0) = 1 Then $strFileType = "Nam"
				Case "Dir|Pic"
					If _ArraySearch($arrSupportedFormatsPic, $strFileExt, 1) > -1 Then $strFileType = "Pic"
				Case "Dir|Doc"
					If _ArraySearch($arrSupportedFormatsDoc, $strFileExt, 1) > -1 Then $strFileType = "Doc"
			EndSwitch
		EndIf
		$lstPreviewItem[$i][$cFNTyp] = $strFileType
		$lstPreviewItem[$i][$cFNExt] = $strFileExt

		If $lstPreviewItem[$i][$cFNTyp] <> "Fil" Then
			$lstPreviewItem[$i][$cFPPar] = StringLeft($strTCPNList[$i], $intPosLastPathDelim - 1)
			$lstPreviewItem[$i][$cTxErr] = ""
			Switch $lstPreviewItem[$i][$cFNTyp]
				Case "Dir"
					$intNumDirs += 1
					$lstPreviewItem[$i][$cFPFul] = StringTrimRight($strTCPNList[$i], 1)
					$intListviewIcon = 0
					GUICtrlSetData($lblStatus2, StringMid($lstPreviewItem[$i][$cFPFul], $intTCSrcPath))
				Case "Arc"
					$intNumArcs += 1
					$lstPreviewItem[$i][$cFPFul] = $strTCPNList[$i]
					If $int7zExeExists = 0 Then $lstPreviewItem[$i][$cTxErr] = $strLocalizedString[38][1]
					$intListviewIcon = 2
				Case "Nam"
					$intNumNams += 1
					$lstPreviewItem[$i][$cFPFul] = $strTCPNList[$i]
					$intListviewIcon = 4
				Case "Pic"
					$intNumPics += 1
					$lstPreviewItem[$i][$cFPFul] = $strTCPNList[$i]
					$intListviewIcon = 5
				Case "Doc"
					$intNumDocs += 1
					$lstPreviewItem[$i][$cFPFul] = $strTCPNList[$i]
					$intListviewIcon = 6
			EndSwitch
			$lstPreviewItem[$i][$cFPRel] = StringTrimLeft($lstPreviewItem[$i][$cFPFul], StringLen($strTCSrcPath))
			If StringLeft($lstPreviewItem[$i][$cFPRel], 1) = "\" Then $lstPreviewItem[$i][$cFPRel] = StringTrimLeft($lstPreviewItem[$i][$cFPRel], 1)

			$lstPreviewItem[$i][$cFPRel] = StringReplace($lstPreviewItem[$i][$cFPRel], "\", "\")
			$intDirLevel = @extended
			$lstPreviewItem[$i][$cFPRel] = StringTrimLeft($lstPreviewItem[$i][$cFPRel], StringInStr($lstPreviewItem[$i][$cFPRel], "\", 0, -1))
;~ 			$lstPreviewItem[$i][$cFPRel] = StringFormat("%" & $intDirLevel*7 + StringLen($lstPreviewItem[$i][$cFPRel]) & "s", $lstPreviewItem[$i][$cFPRel])
			$strIndent = ""
			For $intIndent = 1 To $intDirLevel
				$strIndent &= " "
			Next
			$lstPreviewItem[$i][$cFPRel] = $strIndent & $lstPreviewItem[$i][$cFPRel]

			$lstPreviewItem[$i][$cDtOld] = FileGetTime($lstPreviewItem[$i][$cFPFul], $intDatetypeOldDate, 1)
			$lstPreviewItem[$i][$cDtMax] = ""
			$lstPreviewItem[$i][$cDtMin] = ""
			$lstPreviewItem[$i][$cFNMax] = ""
			$lstPreviewItem[$i][$cFNMin] = ""
			$lstPreviewItem[$i][$cDtNew] = ""
			$strPreviewItem = $lstPreviewItem[$i][$cFPRel]
			$strPreviewItem &= "|" & _FmtDtTm($lstPreviewItem[$i][$cDtOld]) & "|" & "?" & "| "

			$lstPreviewItem[$i][$cLVIdx] = GUICtrlCreateListViewItem($strPreviewItem, $lvwPreview)
			If $intShowIcons = 1 Then GUICtrlSetImage($lstPreviewItem[$i][$cLVIdx], $strListviewIconfile, $intListviewIcon, 0)

		EndIf

	Next

	$intNumFils = $intNumDirs + $intNumArcs + $intNumNams + $intNumPics + $intNumDocs

	$strTmp = $strLocalizedString[17][1]
	$strTmp = StringReplace($strTmp, "%e", $intNumFils)
	$strTmp = StringReplace($strTmp, "%d", $intNumDirs)
;~ 	$strTmp = StringReplace($strTmp, "%a", $intNumArcs)
	$strTmp = StringReplace($strTmp, "%f", $intNumFils - $intNumDirs)
	GUICtrlSetData($grpDateEvalOptions, $strTmp)

EndFunc
