unit packU;

interface

uses
	Windows,
	wcxhead;

function OpenArchive(var ArchiveData: TOpenArchiveData): THandle; stdcall; export;
function ReadHeader(hArcData: THandle; var HeaderData: THeaderData): integer; stdcall; export;
function ProcessFile(hArcData: THandle; Operation: integer; DestPath, DestName: PChar): integer; stdcall; export;
function CloseArchive (hArcData: THandle): integer; stdcall; export;
function PackFiles(PackedFile, SubPath, SrcPath, AddList: PChar; Flags: integer): integer; stdcall; export;
function DeleteFiles(PackedFile, DeleteList: PChar): integer; stdcall; export;
function GetPackerCaps: integer; stdcall; export;
//procedure PackSetDefaultParams(var dps: TPackDefaultParamStruct); stdcall; export;
//procedure ConfigurePacker(Parent: HWnd; DllInstance: HInst); stdcall; export;
procedure SetProcessDataProc(hArcData: THandle; ProcessDataProc: TProcessDataProc); stdcall; export;
function CanYouHandleThisFile(FileName: PChar): boolean; stdcall; export;
//procedure SetChangeVolProc(hArcData: THandle; var ChangeVolProc: TChangeVolProc); stdcall; export;

implementation

uses
	KOL, WebArcU, commonsU;

function OpenArchive(var ArchiveData: TOpenArchiveData): THandle; stdcall;
var
	AR: PArcReader;
begin
	OpInProgress := oRead;
	AR := NewArcReader(ArchiveData.ArcName);
	if AR.Valid then
		Result := integer(AR)
	else
		begin
			AR.Free;
			ArchiveData.OpenResult := E_UNKNOWN_FORMAT;
			Result := 0;
		end;
end;

function ReadHeader(hArcData: THandle; var HeaderData: THeaderData): integer; stdcall;
	function CnvToFileTime(UnixTime: integer): integer;
	var
		ST: TSystemTime;
	begin
		DateTime2SystemTime(UnixToDateTime(UnixTime), ST);
		Result := ((ST.wYear - 1980) shl 25) or (ST.wMonth shl 21) or (ST.wDay shl 16)
			or (ST.wHour shl 11) or (ST.wMinute shl 5) or (ST.wSecond div 2);
	end;
var
	AR: PArcReader;
	AFile: PAFile;
begin
	AR := PArcReader(hArcData);
	if AR.FilePointer = AR.Files.Count - 1 then
		Result := E_END_ARCHIVE
	else
		begin
			Result := 0;
			inc(AR.FilePointer);
			AFile := PAFile(AR.Files.Items[AR.FilePointer]);
			StrPCopy(HeaderData.FileName, AFile.WindowsName);
			if AFile.IsDirectory then
				HeaderData.FileAttr := 16
			else
				HeaderData.FileAttr := 0;
			HeaderData.PackSize := AFile.csize;
			HeaderData.UnpSize := AFile.uncsize;
			HeaderData.FileTime := CnvToFileTime(AFile.time);
		end;
end;

function ProcessFile(hArcData: THandle; Operation: integer; DestPath, DestName: PChar): integer; stdcall;
var
	AR: PArcReader;
	AFile: PAFile;
begin
	AR := PArcReader(hArcData);
	if AR.FilePointer = AR.Files.Count then
		Result := E_END_ARCHIVE
	else
		begin
			AFile := PAFile(AR.Files.Items[AR.FilePointer]);
			if (Operation = PK_SKIP) or (Operation = PK_TEST) then
				begin
					AR.SkipPastFile(AFile);
					Result := 0;
				end
			else
				Result := AR.DeCompressFile(AFile, DestPath, DestName);
		end;
end;

function CloseArchive (hArcData: THandle): integer; stdcall;
begin
	PArcReader(hArcData).Free;
	Result := 0;
end;

function UnpackList(List: PChar): PStrList;
var
	P: PChar;
begin
	Result := NewStrList;
	P := List;
	while StrLen(P) > 0 do
		begin
			Result.Add(P);
			P := PChar(DWORD(P) + StrLen(P) + 1);
		end;
end;

function SameDrive(p1, p2: string): boolean;
begin
	Result := (AnsiCompareStrNoCase(p1[1], p2[1]) = 0);
end;

function IsRemovable(pth: string): boolean;
begin
	Result := (GetDriveType(PChar(pth)) = DRIVE_REMOVABLE);
end;

function EnoughSpace(pth: string; needed: integer): boolean;
var
	big: I64;
begin
	big := MakeInt64(needed, 0);
	Result := (Cmp64(DiskFreeSpace(pth), big) = 1);	
end;

function PackFiles(PackedFile, SubPath, SrcPath, AddList: PChar; Flags: integer): integer; stdcall;
var
	AR: PArcReader;
	AW: PArcWriter;
	Lst: PStrList;
	DestFile: string;
	BytesToPack, i: integer;
	InS, OutS: PStream;
begin
	OpInProgress := oWrite;
	BytesToPack := 0;
	Lst := UnpackList(AddList);
	for i := 0 to Lst.Count - 1 do
		BytesToPack := BytesToPack + FileSize(SrcPath + Lst.Items[i]);
	if FileExists(PackedFile) then
		begin
			AR := NewArcReader(PackedFile);
			if not AR.Valid then
				begin
					Result := E_UNKNOWN_FORMAT;
					Lst.Free;
					AR.Free;
					exit;
				end;
		end
	else
		AR := nil;

	if not Assigned(AR) then
		begin
			DestFile := PackedFile;
			if not EnoughSpace(Copy(DestFile, 1, 3), BytesToPack) then
				begin
					Lst.Free;
					Result := E_ECREATE;
					exit;
				end;
		end
	else
		begin
			if SameDrive(GetTempDir, PackedFile) then
				DestFile := CreateTempFile(GetTempDir, 'wac')
			else if IsRemovable(Copy(PackedFile, 1, 3)) then
				DestFile := CreateTempFile(GetTempDir, 'wac')
			else if not EnoughSpace(Copy(PackedFile, 1, 3), BytesTopack) then
				DestFile := CreateTempFile(GetTempDir, 'wac')
			else
				DestFile := ChangeFileExt(PackedFile, '___');

			if not EnoughSpace(Copy(DestFile, 1, 3), BytesToPack) then
				begin
					Lst.Free;
					AR.Free;
					Result := E_ECREATE;
					exit;
				end;
		end;

	AW := NewArcWriter;
	Result := AW.PackFiles(DestFile, Lst, SubPath, SrcPath, Flags, AR);
	AW.Free;
	AR.Free;

	if Result = 0 then
		begin
			if (Flags and PK_PACK_MOVE_FILES) <> 0 then
				for i := 0 to Lst.Count - 1 do
					DeleteFile(PChar(SrcPath + Lst.Items[i]));
			if AnsiCompareStrNoCase(PackedFile, DestFile) <> 0 then
				if SameDrive(PackedFile, DestFile) then
					begin
						DeleteFile(PackedFile);
						MoveFile(PChar(DestFile), PackedFile);
					end
				else
					begin
						InS := NewReadFileStream(DestFile);
						OutS := NewWriteFileStream(PackedFile);
						Stream2Stream(OutS, InS, InS.Size);
						OutS.Free;
						InS.Free;
						DeleteFile(PChar(DestFile));
					end
		end
	else
		DeleteFile(PChar(DestFile));
	Lst.Free;
end;

function DeleteFiles(PackedFile, DeleteList: PChar): integer; stdcall;
var
	AR: PArcReader;
	AW: PArcWriter;
	Lst: PStrList;
	DestFile: string;
	InS, OutS: PStream;
begin
	OpInProgress := oWrite;
	if not FileExists(PackedFile) then
		begin
			Result := E_EOPEN;
			exit;
		end;

	AR := NewArcReader(PackedFile);
	if not AR.Valid then
		begin
			Result := E_UNKNOWN_FORMAT;
			exit;
		end;
	Lst := UnpackList(DeleteList);

	if SameDrive(GetTempDir, PackedFile) then
		DestFile := CreateTempFile(GetTempDir, 'wac')
	else if IsRemovable(Copy(PackedFile, 1, 3)) then
		DestFile := CreateTempFile(GetTempDir, 'wac')
	else if not EnoughSpace(Copy(PackedFile, 1, 3), FileSize(PackedFile)) then
		DestFile := CreateTempFile(GetTempDir, 'wac')
	else
		DestFile := ChangeFileExt(PackedFile, '___');

	if not EnoughSpace(Copy(DestFile, 1, 3), FileSize(PackedFile)) then
		begin
			Lst.Free;
			AR.Free;
			Result := E_ECREATE;
			exit;
		end;

	AW := NewArcWriter;
	Result := AW.DeleteFiles(DestFile, Lst, AR);
	AW.Free;
	AR.Free;

	if Result = 0 then
		begin
			if SameDrive(PackedFile, DestFile) then
				begin
					DeleteFile(PackedFile);
					MoveFile(PChar(DestFile), PackedFile);
				end
			else
				begin
					InS := NewReadFileStream(DestFile);
					OutS := NewWriteFileStream(PackedFile);
					Stream2Stream(OutS, InS, InS.Size);
					OutS.Free;
					InS.Free;
					DeleteFile(PChar(DestFile));
				end
		end
	else
		DeleteFile(PChar(DestFile));
	Lst.Free;
end;

function GetPackerCaps: integer; stdcall;
begin
	Result :=
		PK_CAPS_NEW or
		PK_CAPS_MODIFY or
		PK_CAPS_MULTIPLE or
		PK_CAPS_DELETE or
		PK_CAPS_BY_CONTENT;
end;

{procedure PackSetDefaultParams(var dps: TPackDefaultParamStruct); stdcall;
begin
end;}

{procedure ConfigurePacker(Parent: HWnd; DllInstance: HInst); stdcall;
begin
end;}

procedure SetProcessDataProc(hArcData: THandle; ProcessDataProc: TProcessDataProc); stdcall;
begin
	WebArcU.ProcessDataProc := ProcessDataProc;
end;

function CanYouHandleThisFile(FileName: PChar): boolean; stdcall;
var
	AR: PArcReader;
begin
	AR := NewArcReader(FileName);
	if AR.Valid then
		Result := True
	else
		Result := False;
	AR.Free;
end;

{procedure SetChangeVolProc(hArcData: THandle; var ChangeVolProc: TChangeVolProc); stdcall;
begin
end;}

end.
