<?php

define("WEBARCVER", 100);

function &fileContents($fn)
{
	$fd = fopen($fn, "rb");
	$len = filesize($fn);
	if ($len > 0)
		$content = fread($fd, $len);
	else
		$content = "";
	fclose($fd);
	return $content;
}

function myUnpack($fmt, &$data)
{
	$ret = unpack($fmt, $data);
	return $ret[1];
}

class WebArchivedFile
{
	var $filename;
	var $time;
	var $uncsize;
	var $csize;
	var $offs;
	
	function WebArchivedFile($afilename = "", $atime = 0, $auncsize = 0, $acsize = 0, $aoffs = 0)
	{
		$this->filename = $afilename;
		$this->time = $atime;
		$this->uncsize = $auncsize;
		$this->csize = $acsize;
		$this->offs = $aoffs;
	}

	function output()
	{
		$ret .= pack("v", strlen($this->filename)).$this->filename;
		$arr = array($this->time, $this->uncsize, $this->csize, $this->offs);
		for ($j=0; $j<count($arr); $j++)
			$ret .= pack("V", $arr[$j]);
		return $ret;
	}

	function loadFromFile($fileH)
	{
		$fnl = myUnpack("v", fread($fileH, 2));
		$this->filename = fread($fileH, $fnl);
				
		$this->time = myUnpack("V", fread($fileH, 4));
		$this->uncsize = myUnpack("V", fread($fileH, 4));
		$this->csize = myUnpack("V", fread($fileH, 4));
		$this->offs = myUnpack("V", fread($fileH, 4));
	}
}

class WebArchiveWriter
{
	var $files; // The files in the archive - with name, time, uncsize, csize
	var $out;  // The data from these files

	function addFile(&$data, $filename, $time = 0)
	{
		if ($time == 0) $time = time();
	
		$uncsize = strlen($data);
		$cdata =& gzcompress($data);
		if (strlen($cdata) >= strlen($data)) $cdata =& $data;
		$csize = strlen($cdata);
		$offs = strlen($this->out);
		
		$this->files[] = new WebArchivedFile($filename, $time, $uncsize, $csize, $offs);
		$this->out .= $cdata;
	}

	function header()
	{
		return "WEBARC".pack("V", WEBARCVER);
	}

	function &outFiles()
	{
		$ret = pack("V", count($this->files));
		for ($i=0; $i<count($this->files); $i++)
			$ret .= $this->files[$i]->output();
		return $ret;
	}

	function &output()
	{
		return $this->header().$this->outFiles().$this->out;
	}
	
	function printOut($filename, $ext = "wac")
	{
		$out =& $this->output();
		
    if (!empty($_SERVER['HTTP_USER_AGENT']))
			$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
    else if (!empty($HTTP_SERVER_VARS['HTTP_USER_AGENT']))
			$HTTP_USER_AGENT = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
    else if (!isset($HTTP_USER_AGENT))
      $HTTP_USER_AGENT = '';
    if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
			{
        define('WCB_USR_BROWSER_VER', $log_version[2]);
        define('WCB_USR_BROWSER_AGENT', 'OPERA');
			}
		else if (ereg('MSIE ([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
			{
        define('WCB_USR_BROWSER_VER', $log_version[1]);
        define('WCB_USR_BROWSER_AGENT', 'IE');
			}
		else if (ereg('OmniWeb/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
			{
        define('WCB_USR_BROWSER_VER', $log_version[1]);
        define('WCB_USR_BROWSER_AGENT', 'OMNIWEB');
			}
		else if (ereg('(Konqueror/)(.*)(;)', $HTTP_USER_AGENT, $log_version))
			{
        define('WCB_USR_BROWSER_VER', $log_version[2]);
        define('WCB_USR_BROWSER_AGENT', 'KONQUEROR');
			}
		else if (ereg('Mozilla/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version))
			{
        define('WCB_USR_BROWSER_VER', $log_version[1]);
        define('WCB_USR_BROWSER_AGENT', 'MOZILLA');
			}
		else
			{
        define('WCB_USR_BROWSER_VER', 0);
        define('WCB_USR_BROWSER_AGENT', 'OTHER');
			}

		if (WCB_USR_BROWSER_AGENT == "IE")
			{
				header('Content-Disposition: inline; filename="' . $filename . '.' . $ext . '"');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
			}
		else
			{
				header('Content-Disposition: attachment; filename="' . $filename . '.' . $ext . '"');
				header('Pragma: no-cache');
			}
		header('Content-Type: application/octet-stream\r\n');
		header("Content-Length: ".strlen($out)."\r\n");
		print $out;
	}
}

class WebArchiveReader
{
	var $fileH;
	var $files;
	var $dataOffset;
	var $writerVer;

	function WebArchiveReader($inFile)
	{
		$this->fileH = fopen($inFile, "rb");
	}
	
	function closeArchive()
	{
		fclose($this->fileH);
	}
	
	function isWebArchive()
	{
		$hdr = fread($this->fileH, 6);
		if ($hdr == "WEBARC")
			return true;
		else
			return false;
	}
	
	function readHeader()
	{
		$wv = fread($this->fileH, 4);
		$this->writerVer = myUnpack("V", $wv);
		$numFiles = myUnpack("V", fread($this->fileH, 4));
		for ($i=0; $i<$numFiles; $i++)
			{
				$aFile =& new WebArchivedFile();
				$aFile->loadFromFile($this->fileH);
				$this->files[] =& $aFile;
			}
		$this->dataOffset = ftell($this->fileH);
	}
	
	function findFile($fn)
	{
		for ($i=0; $i<count($this->files); $i++)
			if ($this->files[$i]->filename == $fn)
				return $i;
		return false;
	}
	
	function extractData($fn, $toFile = "")
	{
		$fileIx = $this->findFile($fn);
		if ($fileIx === false) return false;
		$theFile =& $this->files[$fileIx];
		fseek($this->fileH, $theFile->offs + $this->dataOffset);
		if ($theFile->csize > 0)
			$cdata = fread($this->fileH, $theFile->csize);
		else
			$cdata = "";
		if ($theFile->uncsize > $theFile->csize)
			{
				$data = gzuncompress($cdata);
				if ($data === false) return false;
			}
		else
			$data = $cdata;
		if ($toFile != "")
			{
				$outH = fopen($toFile, "wb");
				if ($outH !== false)
					{
						if (strlen($data) > 0) fwrite($outH, $data, strlen($data));
						fclose($outH);
						return true;
					}
				else
					return false;
			}
		else
			return $data;
	}
}
?>