{$I deb.inc}
{$R sfx.res}
unit cmain;
interface
uses wcxhead, sysutils, dialogs, zlibex, classes, crc, windows,
     messages, forms, configdialog, elaes, encformu, decformu,
     rng, md5, misc, testing, language, common;
  function  GetPackerCaps: integer; stdcall;
  function  OpenArchive(var ArchiveData: TOpenArchiveData): integer; stdcall;
  function  CloseArchive(hArcData: integer): integer; stdcall;
  function  ReadHeader(hArcData: integer; var HeaderData: THeaderData): integer; stdcall;
  function  ProcessFile(hArcData: integer; Operation: integer; DestPath: PChar; DestName: PChar): integer; stdcall;
  procedure SetProcessDataProc(hArcData: integer; ProcessDataProc: TProcessDataProc); stdcall;
  procedure SetChangeVolProc(hArcData: integer; ChangeVolProc: TChangeVolProc); stdcall;
  function  PackFiles(PackedFile_, SubPath_, SrcPath_, AddList_: PChar; Flags: integer): integer; stdcall;
  function  Configurepacker(Parent: HWND; DLLinstance: integer): integer;stdcall;
  procedure PackSetDefaultParams(params: pPackDefaultParamStruct); stdcall;
  function  CanYouHandleThisFile(fname: PChar): boolean; stdcall;
  function  DeleteFiles(PackedFile: PChar; DeleteList: PChar): integer; stdcall;
implementation
type
  TZPacker = class
      startpos: integer;
      endpos: integer;
      infilename: string;
      outfilename: string;
      unpackedsize: cardinal;
      packedsize: integer;
      InStream: TStream;
      OutStream: TStream;
      ZStream: TCustomZStream;
      buffer: array [0..32767] of byte;
      mode: TZCompressionLevel;
      function Expand: integer;
      procedure Shrink;
  end;

var
   Deleted: boolean;
   ShrinkResult: integer;
   SfxFileSize: integer;
   sfxres: TResourceStream;//kell
function EncryptFile(infile, outfile: string; PackWithPathNames: boolean): integer; forward;
function ChangePassword: integer; forward;

{=========================================================================}

function UnpackFile(inf, outf: string): integer;
var TZ: TZPacker;
begin
  TZ := TZPacker.Create;
  try
     TZ.infilename := inf;
     TZ.outfilename := outf;
     Result := TZ.Expand;
  finally
     TZ.Free;
  end;
end; //UnpackFile()

{=========================================================================}
//write sfx exe + additionals

procedure WriteSfxFile(PackedFile: string);
var
    outf, nr: integer;
    buf: array [0..32767] of byte;
    sfxcrc: longword;
    sfxver: byte;
    headsize: word;
    nw: word;
    hs_pos: longint;
    procedure WriteStr(str: string);
    var i: byte;
    begin
      i := Length(str);
      FileWrite(outf, i, sizeof(i));
      FileWrite(outf, str[1], i);
      inc(nw, sizeof(i)+i);
    end;
    procedure WriteByte(s: string);
    var b: byte;
    begin
       b := StrToInt(s);
       FileWrite(outf, b, 1);
       inc(nw);
    end;
    function Valid(s: string): boolean;
    var b: byte;
    begin
      try
        b := StrToInt(s);
      except
        Result := FALSE;
        Exit;
      end;
      Result := TRUE;
    end;
begin
    nw := 0;
    sfxres := TResourceStream.Create(hInstance, 'SFXEXE', RT_RCDATA);
    SfxFileSize := sfxres.Size;
    sfxres.SaveToFile(PackedFile);
    sfxres.Free;
 outf := FileOpen(PackedFile, fmOpenReadWrite);

   CRC32Init(sfxcrc);

   repeat
     nr := FileRead(outf, buf, sizeof(buf));
     CRC32Update(sfxcrc, @buf, nr);
   until nr = 0;
   sfxcrc := CRC32Final(sfxcrc);
   sfxver := SFXVERSION;
   FileWrite(outf, sfxcrc, sizeof(sfxcrc));
   FileWrite(outf, sfxmarker, sizeof(sfxmarker));
   hs_pos := GetFilePos(outf);
   FileWrite(outf, headsize, sizeof(headsize));
   FileWrite(outf, sfxver, sizeof(sfxver));
   inc(nw, sizeof(sfxver));

   WriteStr(SfxStrings.Password);
   WriteStr(SfxStrings.Keyfile);
   WriteStr(SfxStrings.DecryptTo);
   WriteStr(SfxStrings.Browse);
   WriteStr(SfxStrings.Exit);
   WriteStr(SfxStrings.ErrorOpeningKeyfile);
   WriteStr(SfxStrings.ReadError);
   WriteStr(SfxStrings.Error);
   WriteStr(SfxStrings.OverWriteConfirm);
   WriteStr(SfxStrings.CorruptedFile);
   WriteStr(SfxStrings.WrongPassword);
   WriteStr(SfxStrings.SelectDestPath);
   WriteStr(SfxStrings.DestPathIsWriteProtected);
   WriteStr(SfxStrings.EnterValidPath);
   WriteStr(SfxStrings.AbortConfirmText);
   WriteStr(SfxStrings.ConfirmCaption);

   WriteStr(SfxStrings.ErrorDuringDecompression);
   WriteStr(SfxStrings.CorruptedArchive);
   WriteStr(SfxStrings.NotEnoughSpace);
   WriteStr(SfxStrings.FailedToCreateDir);
   WriteStr(SfxStrings.IncompletedFile);
   WriteStr(SfxStrings.UnknownError);
   WriteStr(SfxStrings.KeyFileNotFound);
   WriteStr(SfxStrings.Warning);
   WriteStr(SfxStrings.AllFiles);
   WriteStr(SfxStrings.Yes);
   WriteStr(SfxStrings.No);
   WriteStr(SfxStrings.Cancel);
   WriteStr(SfxStrings.Skip);
   WriteStr(SfxStrings.SkipAll);
   WriteStr(SfxStrings.OverwriteAll);
   WriteStr(SfxStrings.Rename);
   WriteStr(SfxStrings.AutoRename);
   WriteStr(SfxStrings.EnterNewFilename);

   if Valid(SfxStrings.ButtonWidth) then WriteByte(SfxStrings.ButtonWidth)
      else WriteByte('80');

   if Valid(SfxStrings.ButtonHeight) then WriteByte(SfxStrings.ButtonHeight)
      else WriteByte('22');

   if Valid(SfxStrings.OvAllWW) then WriteByte(SfxStrings.OvAllWW)
      else WriteByte('0');
   if Valid(SfxStrings.SkipAllWW) then WriteByte(SfxStrings.SkipAllWW)
      else WriteByte('0');
   if Valid(SfxStrings.AutoRenWW) then WriteByte(SfxStrings.AutoRenWW)
      else WriteByte('0');
   if Valid(SfxStrings.OvAllLabelAlign) then WriteByte(SfxStrings.OvAllLabelAlign)
      else WriteByte('0');
   if Valid(SfxStrings.SkipAllLabelAlign) then WriteByte(SfxStrings.SkipAllLabelAlign)
      else WriteByte('0');
   if Valid(SfxStrings.AutoRenLabelAlign) then WriteByte(SfxStrings.AutoRenLabelAlign)
      else WriteByte('0');
   SetFilePos(outf, hs_pos);

   FileWrite(outf, nw, sizeof(nw));
   FileClose(outf);
end;

{=========================================================================}

function TZpacker.Expand: integer;
var Count: integer;
begin         {$IFDEF Deb}sm('Expand');{$ENDIF Deb}
  Result := 0;
  try //1
    try
      InStream := TFileStream.Create(infilename, fmOpenRead);
    except
      Result := E_EOPEN;
      Exit;
    end;
    try
      OutStream := TFileStream.Create(outfilename, fmCreate);
    except
      Result := E_ECREATE;
      Exit;
    end;

    try //2
        ZStream := TZDecompressionStream.Create(InStream);
        try  //3
          while True do begin //4
            Count := ZStream.Read(Buffer, 32768);
            if Count <> 0 then OutStream.WriteBuffer(Buffer, Count) else break;
            if AR.ProcessDataProc(PChar(Strings.ProgBar.DecompressingFile + ' ' + progfilename), 0) = 0 then begin
               Result := E_EABORTED;
               Exit;
            end;
          end; //4
        finally
          ZStream.Destroy;
        end; //3
    finally
        InStream.Free;
        OutStream.Free;
    end; //2
  finally
    if Settings.WipeTempFile then
       Result := WipeFile(Result, infilename)
    else
       SimpleErase(infilename);
  end; //1
end;//TZPacker.Expand

{=========================================================================}

procedure TZPacker.Shrink;
var rem: integer;
    text: string;
begin      {$IFDEF Deb}sm('Shrink');{$ENDIF Deb}
  ShrinkResult := 0;
  if mode = zcNone then text := Strings.ProgBar.CopyingFile + ' ' else text := Strings.ProgBar.CompressingFile + ' ';
    try
       InStream := TFileStream.Create(infilename, fmOpenRead + fmShareDenyWrite);
    except
       ShrinkResult := E_EREAD;
       Exit;
    end;
    try
        OutStream := TFileStream.Create(outfilename, fmOpenReadWrite);
    except
        ShrinkResult := E_EWRITE;
        Exit;
    end;
    OutStream.Position := OutStream.size;
    ZStream := TZCompressionStream.Create(OutStream, mode);
    try //1
           try //2
             rem := InStream.size - startpos;
             repeat
                  if rem > BUFSIZE then begin
                    ZStream.CopyFrom(InStream, BUFSIZE);
                    if AR.ProcessDataProc(PChar(text + infilename), 0) = 0 then begin
                        ShrinkResult := E_EABORTED;
                        Exit;
                    end;
                    dec(rem, BUFSIZE);
                  end else begin
                    ZStream.CopyFrom(InStream, rem);
                    if AR.ProcessDataProc(PChar(text + infilename), 0) = 0 then begin
                        ShrinkResult := E_EABORTED;
                        Exit;
                    end;
                    rem := 0;
                  end;
             until rem < BUFSIZE;
             if rem > 0 then begin
                ZStream.CopyFrom(InStream, rem);
                if AR.ProcessDataProc(PChar(text + infilename), 0) = 0 then begin
                    ShrinkResult := E_EABORTED;
                    Exit;
                end;
             end;
           except
               ShrinkResult := E_EWRITE;
               Exit;
           end; //2
    finally
        ZStream.Free;
        OutStream.Free;
        InStream.Free;
    end; //1
end;//TZPacker.Shrink

{=========================================================================}

function GetPackerCaps: integer; stdcall;
begin
   Result := PK_CAPS_NEW +
             PK_CAPS_OPTIONS +
             PK_CAPS_BY_CONTENT +
             PK_CAPS_MULTIPLE +
             PK_CAPS_DELETE;
end;

{=========================================================================}

function OpenArchive(var ArchiveData: TOpenArchiveData): integer; stdcall;
var filename: string;
    nr, res: integer;
    header: misc.Theader;
    tk: arr4;
    valid: boolean;
label TypePwd;
begin                                       {$IFDEF Deb}sm('OpenArchive');{$ENDIF}
   DecForm.Timer1.Enabled := FALSE;
   if Deleted then Deleted := FALSE;
   if FSize(Archivedata.ArcName) = 0 then begin
      ArchiveData.OpenResult := 0; //don't show error message
      Result := 0;
      Exit;
   end;
   if CanYouHandleThisFile(ArchiveData.Arcname) = FALSE then begin
      Result := 0;
      Archivedata.OpenResult := E_UNKNOWN_FORMAT;
      Exit;
   end;
   try //1
      filemode := 0;
      filename := String(ArchiveData.ArcName);
      IsThisSfx(filename);
      AR.Int := FileOpen(filename, fmOpenRead + fmShareDenyWrite);
      if AR.Int = -1 then begin
         Result := 0;
         ArchiveData.OpenResult := E_EOPEN;
         Exit;
      end else begin //2
         with AR do begin //3
              ArchiveName := filename;
              ArchiveDate := FileAge(filename);
              ProcessDataProc := nil;
              ChangeVolProc := nil;
              if AR.sfx then begin
                 FileSeek(AR.Int, AR.AESStartPos, soFromBeginning);
              end;
              nr := FileRead(AR.Int, header, sizeof(header));
              if (nr <> sizeof(header)) OR (CheckMagic(header.magic) = UNKNOWN_FORMAT) then begin
                  FileClose(AR.Int);
                  Result := 0;
                  ArchiveData.OpenResult := E_EREAD;
                  Exit;
              end;
              FileSeek(Ar.Int, -sizeof(header), soFromCurrent);
              Ar.filever := header.fileversion;
         end;//3
      end;//2
      if curarchive <> string(ArchiveData.ArcName) then begin
         CurArchive := String(ArchiveData.ArcName);
         ZeroMemory(pwd, sizeof(pwd^));
         KeyEntered := FALSE;
         EncForm.Button2.Visible := TRUE;
         EncForm.UseKeyFile1Click(EncForm);
      end;
         TypePwd:
         if not KeyEntered then begin //4
            DecForm.StatusBar1.SimpleText := String(AR.ArchiveName);
            DecForm.StatusBar1.Hint := String(AR.ArchiveName);
            DecForm.SkipCRC.Checked := FALSE;
            DecForm.Caption := 'AES plugin - ' + Strings.GeneralCaptions.OpenCaption;
            repeat
               DecForm.Position := poScreenCenter;
               if DecForm.ShowModal = idCancel then begin //5
                  FileClose(AR.Int);
                  Result := 0;
                  ArchiveData.OpenResult := E_BAD_ARCHIVE;
                  ZeroMemory(pwd, sizeof(pwd^));
                  KeyEntered := FALSE;
                  DecForm.Edit1.Clear;
                  Exit;
               end; //5
               //'change password' selected
               Settings.current_keyfile := DecForm.Edit2.Text;
               if DecForm.PwdChangeM.Checked then begin //6
                  //check password
                  KeyEntered := FALSE;
                  Result := MakeKeyHash(header.salt, tk);
                  if Result <> 0 then Exit;
                  if not CompareMem(@header.keyhash, @tk, sizeof(tk)) then begin
                     Result := 0;
                     Archivedata.OpenResult := E_BAD_ARCHIVE;
                     KeyEntered := FALSE;
                     FileClose(AR.Int);
                     Exit;
                  end;
                  res := ChangePassword;
                  KeyEntered := TRUE;
                  if res = 0 then begin //7
                     MessageBox(0, PChar(Strings.PwdChangeStrings.ReencryptedSuccessfully),
                                'AES plugin',
                                MB_OK + MB_ICONINFORMATION);
                     AR.Int := FileOpen(filename, fmOpenRead + fmShareDenyWrite);
                     if AR.sfx then begin
                        FileSeek(AR.Int, AR.AESStartPos, soFromBeginning);
                        ArchiveData.OpenResult := 0;
                        Break;
                     end else begin
                        DecForm.PwdChangeM.Checked := FALSE;
                        ArchiveData.OpenResult := res;
                        Result := 0;
                        Break;
                     end;
                  end;//7
               end; //6
               if UsingKeyFile then begin
                  valid := (FileExists(ExpandFileName(Settings.current_keyfile))) AND
                           (FSize(Settings.current_keyfile) > 2047);
               end else begin
                  valid := (Length(DecForm.Edit1.Text) <> 0);
                  StrPcopy(pwd^, DecForm.Edit1.Text);
               end;
            until valid;
            KeyEntered := TRUE;

            if Ar.sfx then
               FileSeek(AR.Int, Ar.AESStartPos, soFromBeginning)
            else
               FileSeek(AR.Int, 0, soFromBeginning);
            FileRead(AR.Int, header, sizeof(header));
            FileSeek(AR.Int, -sizeof(header), soFromCurrent);
            Result := MakeKeyHash(header.salt, tk);
            if Result <> 0 then Exit;
            if not CompareMem(@header.keyhash, @tk, sizeof(tk)) then begin //8
               //wrong key
               DecForm.Edit1.Clear;
               KeyEntered := FALSE;
               if MessageBox(0, PChar(Strings.GeneralMessages.WrongPwd),
                             'AES plugin',
                             MB_RETRYCANCEL + MB_ICONERROR) = idCancel then begin
                  FileClose(AR.Int);
                  Result := 0;
                  Archivedata.OpenResult := E_BAD_ARCHIVE;
                  Exit;
               end;
               goto TypePwd;
            end;//8
         end; //4

         if Ar.sfx then
            FileSeek(AR.Int, Ar.AESStartPos, soFromBeginning)
         else
            FileSeek(AR.Int, 0, soFromBeginning);

         Result := AR.Int;
  except
         Result := 0;
         ArchiveData.OpenResult := E_EOPEN;
  end;
end; //OpenArchive

{=========================================================================}

function CloseArchive(hArcData: integer): integer; stdcall;
begin  {$IFDEF Deb}sm('CloseArchive');{$ENDIF}
   Result := 0;
   Ar.filever := 0;
   try
     FileClose(AR.Int);
   except
     Result := E_ECLOSE;
   end;
   DecForm.Timer1.Enabled := TRUE;
end; //CloseArchive

{=========================================================================}

function  ReadHeader(hArcData: integer; var HeaderData: THeaderData): integer;
var header: misc.THeader;
    fname: string;
    pfname: array [0..MAX_PATH] of char;
    nr: byte;
    Source, Dest: TStream;
    ProcBytes: cardinal;
begin                                  {$IFDEF Deb}sm('ReadHeader()');{$ENDIF}
   Result := 0;
   try //1
      curpos := GetFilePos(AR.Int);
      nr := FileRead(AR.Int, header, sizeof(header));
      if (nr <> sizeof(header)) then begin
         Result := E_END_ARCHIVE;
         Exit;
      end;
      if (CheckMagic(header.magic) = UNKNOWN_FORMAT) then begin
         Result := E_UNKNOWN_FORMAT;
         Exit;
      end;

      if header.fileversion > ENCVERSION then begin
         Result := E_UNKNOWN_FORMAT;
         Exit;
      end;
      if header.fileversion = 1 then begin
         //old version, filename isn't encrypted
         FileRead(AR.Int, pfname, header.fnamelen);
         fname := String(pfname);
         SetLength(fname, header.fnamelen);
         StrPCopy(headerdata.filename, fname);
      end else begin //2
         //filename decryption
         Result := CreateAESKey(header.salt, header.fileversion, AESKey);

         if Result <> 0 then Exit;
         FileClose(AR.Int);
         Source := TFileStream.Create(AR.ArchiveName, fmOpenRead);
         Dest := TMemoryStream.Create;
         try
            Source.Position := curpos + sizeof(header);
            DecryptAESStreamCBC(Source, header.fnamelen + header.fname_lastblocksize, AESKey^, IV, Dest, ProcBytes);
            Dest.Position := 0;
            Dest.Read(pfname, header.fnamelen + header.fname_lastblocksize);
            fname := String(pfname);
            SetLength(fname, header.fnamelen);
            StrPCopy(headerdata.filename, fname);
         finally
            Source.Free;
            Dest.Free;
            DestroyAESKey;
         end;
         AR.Int := FileOpen(AR.ArchiveName, fmOpenRead);//reopen file
      end; //2
      if SetFilePos(AR.Int, curpos) <> curpos then begin //seek to header
         Result := E_EREAD;
         Exit;
      end;

      HeaderData.PackSize := header.packedsize;
      HeaderData.UnpSize := header.unpackedsize;
      HeaderData.FileTime := header.filetime;
      Headerdata.FileAttr := header.fileattr;

      case header.complevel of
           CLNONE:    Headerdata.method := 1;
           CLFASTEST: Headerdata.method := 2;
           CLDEF:     Headerdata.method := 3;
           CLMAX:     Headerdata.method := 4;
      end;

   except
      On E: Exception do begin
          Result := E_BAD_ARCHIVE;
        end;
   end;

   case header.fileversion of
       6 : begin
             if header.complevel = CLNONE then
                nextfilestart := curpos + sizeof(header) +
                                 header.fnamelen + header.fname_lastblocksize +
                                 header.packedsize + header.lastblocksize
             else
                nextfilestart := curpos + sizeof(header) +
                                 header.fnamelen + header.fname_lastblocksize +
                                 header.packedsize + header.lastblocksize + 2;
           end;
       3 :      nextfilestart := curpos + sizeof(header) +
                                 header.fnamelen + header.fname_lastblocksize +
                                 header.packedsize + header.lastblocksize + 2;
       1 : begin
                nextfilestart := curpos + sizeof(header) +
                                 header.fnamelen +
                                 header.packedsize + header.lastblocksize;
           end
           else
                nextfilestart := curpos + sizeof(header) +
                                 header.fnamelen + header.fname_lastblocksize +
                                 header.packedsize + header.lastblocksize;
   end;//case
end; //ReadHeader()

{=========================================================================}

function  ProcessFile(hArcData: integer; Operation: integer; DestPath: PChar; DestName: PChar): integer; stdcall;
var header: misc.THeader;
    tempname: string;
//    dest: string;
    handle: integer;
    curpos: integer;
begin                                {$IFDEF Deb}sm('ProcessFile()');{$ENDIF}
   LoadSettings;
   Result := 0;
   case Operation of
     PK_TEST: begin
                Result := TestArchive;
                Exit;
              end;
     PK_SKIP: begin
                SetFilePos(AR.Int, nextfilestart);
                Result := 0;
                Exit;
              end;
     PK_EXTRACT: begin //4
                   try //5
                     try //6
                       KeyEntered := FALSE;
                       curpos := GetFilePos(AR.Int);
                       FileRead(AR.Int, header, sizeof(header));
                       FileSeek(AR.Int, curpos, soFromBeginning);
                       if (header.complevel <> CLNONE) OR (header.fileversion < 6) then begin
                          EncryptInPlace := TRUE;
                       end else begin
                          EncryptInPlace := FALSE;
                       end;

                       if EncryptInPlace then begin
                          tempname := CreateTempName(string(destname), header.packedsize, header.unpackedsize);
                          if (tempname = WRITE_ERROR) OR (tempname = LOWSPACE) then begin
                             Result := E_EWRITE;
                             Exit;
                          end;
                       end;   
                       rate := header.unpackedsize / header.packedsize;
                       progfilename := String(Destname);
                       if (header.complevel = CLNONE) AND (header.fileversion >= 6) then begin
                          Result := DecryptFile(AR.Archivename, String(destname));
                        end else
                          //complevel<>clnone
                          Result := DecryptFile(AR.Archivename, tempname);
                       if Result <> 0 then Exit;
                       if EncryptInPlace then
                          Result := UnpackFile(tempname, Destname);

                        //wipe calling in Unpackfile/Expand
                        if Result = 0 then begin
                           handle := FileOpen(Destname, fmOpenWrite);
                           try
                             FileSetDate(handle, header.filetime);
                           finally
                             FileClose(handle);
                           end;
                           FileSetAttr(Destname, header.fileattr);
                         end;  
                      finally
                        KeyEntered := TRUE;
                        elapsed := 0;
                      end; //6
                    except
                      On E: Exception do begin
                         if Settings.skipcrccheck then
                            Result := 0
                         else begin
                            ErrorMsg('Extract()', E.message);
                            Result := E_EREAD;
                         end;
                      end;
                    end; //5
                  end;//4
   end;//case
end;//ProcessFile

{=========================================================================}

procedure SetProcessDataProc(hArcData: integer; ProcessDataProc: TProcessDataProc); stdcall;
begin
    AR.ProcessDataProc := ProcessDataProc;
end;

{=========================================================================}

procedure SetChangeVolProc(hArcData: integer; ChangeVolProc: TChangeVolProc); stdcall;
begin
    AR.ChangeVolProc := ChangeVolProc;
end;

{=========================================================================}

function UpdateHeader(outfile: string):integer;
var header: misc.THeader;
    pBuf: ^buf;
    nr: integer;
    size, size2: cardinal;
    h: integer;
begin                               {$IFDEF Deb}sm('updateheader');{$ENDIF}
   Result := 0;
   CRC32Init(mycrc);
   GetMem(pBuf, sizeof(buf));
   h := FileOpen(outfile, fmOpenReadWrite);
   try //1
        FileSeek(h, LastStartPos, soFrombeginning);
        FileRead(h, header, sizeof(header));
        FileSeek(h, LastStartPos, soFrombeginning);

        FileRead(h, header, sizeof(header));
        CRC32Update(mycrc, @header.reserved, sizeof(header) - sizeof(header.crc) - sizeof(header.magic));

        if EncryptInPlace AND (header.fileversion > 1) then
           size := header.packedsize + header.lastblocksize + 2
        else
           size := header.packedsize + header.lastblocksize;
        if header.fileversion = 1 then
           inc(size, header.fnamelen)
        else
           inc(size, header.fnamelen + header.fname_lastblocksize);   

        size2 := 0;
        repeat
           nr := FileRead(h, pBuf^, sizeof(buf));
           if nr = 0 then break;
           inc(size2, nr);
           if size2 > size then dec(nr, size2 - size);
           CRC32Update(mycrc, pBuf, nr);
           if size2 = size then nr := 0;
        until (nr = 0) OR (size2 > size);
        header.crc := CRC32Final(mycrc);
        FileSeek(h, LastStartPos + sizeof(header.magic), soFromBeginning);
        FileWrite(h, header.crc, sizeof(header.crc));
   finally
     FileClose(h);
     FreeMem(pBuf);
   end; //1
end;//UpdateHeader()

{=========================================================================}

function GetFileList(Packedfile: string; var filelist: TStrings): integer;
var header: misc.THeader;
    fname: string;
    pfname: array [0..MAX_PATH] of char;
    nr: integer;
    extfnamelen: byte;
    Source, Dest: TStream;
    tk: arr4;
    ProcBytes: cardinal;
begin         {$IFDEF Deb} sm('GetFileList'); {$ENDIF}
  Result := 0;
  try //1
     try //2
        AR.Int := FileOpen(PackedFile, fmOpenRead);
        if AR.Int = -1 then Exit;
        if not KeyEntered then begin //3
           DecForm.StatusBar1.SimpleText := Packedfile;
           DecForm.StatusBar1.Hint := Packedfile;
           repeat
              DecForm.Position := poScreenCenter;
              if DecForm.ShowModal = idCancel then begin
                 Result := E_EABORTED;
                 DecForm.Edit1.Clear;
                 Exit;
              end;
           until Length(DecForm.Edit1.text) <> 0;
           KeyEntered := TRUE;
           ZeroMemory(pwd, sizeof(pwd^));
           StrPcopy(pwd^, DecForm.Edit1.Text);
        end; //3

        if Ar.sfx then FileSeek(Ar.int, Ar.AESStartPos, soFromBeginning);

        while TRUE do begin //4
           curpos := GetFilePos(AR.Int);
           if curpos = FSize(PackedFile) then
              break;
           nr := FileRead(AR.Int, header, sizeof(header));
           if (nr <> sizeof(header)) then begin
              FileClose(AR.Int);
              Exit;
           end;
           if (CheckMagic(header.magic) = UNKNOWN_FORMAT) then begin
              FileClose(AR.Int);
              Exit;
           end;
           //check key
           Result := MakeKeyHash(header.salt, tk);
           if Result <> 0 then Exit;
           if not CompareMem(@header.keyhash, @tk, sizeof(tk)) then begin
              Result := E_BAD_ARCHIVE;
              KeyEntered := FALSE;
              FileClose(AR.Int);
              Exit;
           end;
           if header.fileversion = 1 then begin
              //old version, filename isn't encrypted
              FileRead(AR.Int, pfname, header.fnamelen);
              fname := String(pfname);
              SetLength(fname, header.fnamelen);
           end else begin //5
              //filename decryption
              CreateAESKey(header.salt, header.fileversion, AESKey);

              extfnamelen := header.fnamelen + header.fname_lastblocksize;
              FileRead(AR.Int, pfname, extfnamelen);
              FileClose(AR.Int); //closed until end of stream operation
              Source := TFileStream.Create(String(Packedfile), fmOpenRead);
              Dest := TMemoryStream.Create;
              try //6
                  Source.Position := curpos + sizeof(header);
                  DecryptAESStreamCBC(Source, extfnamelen, AESKey^, IV, Dest, ProcBytes);
                  Dest.Position := 0;
                  Dest.Read(pfname, extfnamelen);
                  fname := String(pfname);
                  SetLength(fname, header.fnamelen);
              finally
                  Source.Free;
                  Dest.Free;
                  DestroyAESKey;
              end;//6
              AR.Int := FileOpen(String(Packedfile), fmOpenRead);
              if SetFilePos(AR.Int, curpos) <> curpos then begin
                 Result := E_EREAD;
                 Exit;
              end;
           end; //5
           case header.fileversion of
                   1:      nextfilestart := FSize(Ar.ArchiveName);
                 2,3:      nextfilestart := curpos + sizeof(header) + header.fnamelen +
                                            header.fname_lastblocksize + header.packedsize +
                                            header.lastblocksize + 2;
                   6:  begin
                           nextfilestart := curpos + sizeof(header) + header.fnamelen +
                                            header.fname_lastblocksize + header.packedsize +
                                            header.lastblocksize;

                         if header.complevel <> CLNONE then inc(nextfilestart, 2);
                       end;
           end;
           filelist.add(fname);
           SetFilePos(AR.Int, nextfilestart);
        end;//4
     except
        Result := E_EREAD;
        Exit;
     end; //2 try
  finally
     FileClose(AR.Int);
  end; //1 try
end; //GetFileList()

{=========================================================================}

function AddFile(srcpath, Infile, FileNameInArchive, PackedFile: string; PackWithPathNames: boolean): integer;
var outf: integer;
    header: misc.THeader;
    str1: string;
    str2: array [1..16] of char;
    TZ: TZPacker;
    hiba: integer;
    errortext: string;
begin                                         {$IFDEF Deb}sm('AddFile()');{$ENDIF}
  Result := 0;
  try //1
    CRC32Init(mycrc);
    Move(MAGIC, header.magic, 4);
    CreateRandomSalt(header.salt);
    MakeKeyHash(header.salt, header.keyhash);
    with header do begin //2
         crc := 0;
         complevel := Settings.complevel;
         fileattr := FileGetAttr(srcpath + infile);
         filetime := FileAge(srcpath + infile);
         unpackedsize := FSize(srcpath + infile);
         GetArchiveVersion(PackedFile, fileversion);
         FillChar(reserved, 3, #0);
         fnamelen := Length(FileNameInArchive);
         str1 := FileNameInArchive;

         fname_lastblocksize := GetLBSize(fnamelen);

         Rnd.Seed('', -1);
         Rnd.Buffer(str2, fname_lastblocksize);
         str1 := str1 + String(str2);
         ZeroMemory(addr(str2[1]), 16);
         Move(MAGIC, header.magic, 4);
         header.keysize := 128;
         if not FileExists(PackedFile) then
            outf := FileCreate(PackedFile, fmOpenReadWrite)
         else
            outf := FileOpen(PackedFile, fmOpenReadWrite);
         try
            FileSeek(outf, 0, soFromEnd);
            LastStartPos := GetFilePos(outf);
            FileWrite(outf, header, sizeof(header));
            FileWrite(outf, str1[1], fnamelen + fname_lastblocksize);
         finally
            FileClose(outf);
         end;            
    end; //2 with
    errortext := '';
    hiba := 0;
    if (Settings.complevel <> CLNONE) OR (header.fileversion < 6) then begin
       try //3
          TZ := TZPacker.Create;
          try //4
             case Settings.complevel of
                 0: TZ.mode := zcMax;
                 1: TZ.mode := zcDefault;
                 2: TZ.mode := zcFastest;
                 3: TZ.mode := zcNone
             end;   
             TZ.infilename := srcpath + infile;
             TZ.outfilename := Packedfile;
             TZ.startpos := 0;
             TZ.endpos := LastStartPos + sizeof(header) + header.fnamelen + header.fname_lastblocksize;
             TZ.Shrink;
          finally
             hiba := ShrinkResult;
             TZ.Free;
          end; //4
       except
          On E: Exception do
             errortext := E.message + '  (1)';
       end; //3
       if hiba <> 0 then begin
          Result := hiba;
             outf := FileOpen(PackedFile, fmOpenReadWrite);
             try
                SetFilePos(outf, LastStartPos);
                SetEndOfFile(outf);
             finally
                FileClose(outf);
             end;
          Exit;
        end;
   end; //if
   except
      On E: Exception do begin
         if errortext = '' then errortext := E.message + '  (2)';
         ErrorMsg('Addfile()', errortext);
         outf := FileOpen(PackedFile, fmOpenReadWrite);
         try
            SetFilePos(outf, LastStartPos);
            SetEndOfFile(outf);
         finally
            FileClose(outf);
         end;
         Exit;
      end;
   end;//1

   progfilename := srcpath + infile;
   infile := srcpath + infile;
   if (Settings.complevel <> CLNONE) OR (header.fileversion < 6) then
      infile := PackedFile;
   if Result = 0 then Result := EncryptFile(infile, PackedFile, PackWithPathNames);
   if Result = 0 then Result := UpdateHeader(PackedFile);
end; //AddFile

{=========================================================================}

function PackFiles(PackedFile_, SubPath_, SrcPath_, AddList_: PChar; Flags: integer): integer; stdcall;
var subpath, srcpath, tempstr1, tempstr2, tempstr3, dirstr, namestr, PackedFile: string;
    addlist, filelist, DontCompressTheseFileTypes: TStrings;
    i: cardinal;
    origlevel: shortint;
    outf: integer;
    ext: string;
    size: integer;
    h_file: integer;
    PackWithPathNames: boolean;
    dir1, dir2, FileNameInArchive: string;
    ans : integer;
    header: misc.THeader;
    count: integer;
label recheck;
begin                                  {$IFDEF Deb}sm('PackFiles()');{$ENDIF}
  //set init values
  EncForm.KeyKiller.Enabled := FALSE;
  Result := 0;
  AR.sfx := FALSE;
  AR.sfxposition := 0;
  AR.sfxheadsize := 0;
  AR.AESStartPos := 0;

  PackedFile := ExpandFilename(StrPas(PackedFile_));
  LoadSettings;
  tempstr1 := '';
  PackWithPathNames := (Flags = 2) OR (Flags = 3);
  subpath := strpas(subpath_);
  srcpath := strpas(srcpath_);
  addlist := TStringList.Create;
  ExtractStrings([#0], [], addlist_, addlist);
  if addlist.count = 0 then begin
     Result := 0;
     Exit;
  end;

  tempstr1:='';
  //detect if packedfile is in the source list
  if not onlywiping then begin
    for i := 0 to addlist.Count - 1 do begin
       if srcpath + addlist[i] = PackedFile then begin
          Result := E_NOT_SUPPORTED;
          Exit;
       end;
    end;
  end;
  OnlyWiping := FALSE;
  //show enc dialog
  if not SameKeyForAll then begin
     KeyEntered := FALSE;
     CreatingSFXFile := FALSE; //default
     EncForm.Button2.Visible := TRUE;
     EncForm.UseKeyFile1Click(EncForm);
     Result := EncForm.ShowEncDlg(EncForm);
     if Result = E_EABORTED then Exit;
  end;//ne vondd ssze
  if SameKeyForAll then begin
     //e.g. packedfile = c:\anything.jpg.enc
     tempstr1 := ExtractFilePath(PackedFile); //c:\
     tempstr2 := ExtractFileName(PackedFile); //anything.jpg.enc
     tempstr2 := Copy(tempstr2, 1, Length(tempstr2) - Length(ExtractFileExt(tempstr2))); //anything.jpg
     tempstr3 := ExtractFileExt(PackedFile);  //.enc
     PackedFile := tempstr1 + ChangeFileExt(tempstr2, tempstr3); //c:\anything.enc
     if FileExists(PackedFile) then begin
        //if many files has the same name
        //we will make unique names for those
        count := 1;
        repeat
           tempstr3 := PackedFile;
           tempstr2 := ExtractFileName(tempstr3); //anything.aes
           tempstr2 := Copy(tempstr2, 1, Length(tempstr2) - Length(ExtractFileExt(tempstr2))); //anything
           tempstr3 := tempstr1 + tempstr2 + itos(count) + ExtractFileExt(tempstr3);
           inc(count);
        until (not FileExists(tempstr3));
        PackedFile := tempstr3;
     end;
  end;
  //if adding
  try
    if FileExists(PackedFile) then begin//adding
       GetArchiveVersion(PackedFile, Ar.filever);
       if Ar.filever < 3 then begin
          MessageBox(0, PChar(Strings.GeneralMessages.ThisArchiveVersionDoesntSupportMultipleFiles),
                     'AES plugin', MB_OK);
          Result := 0;
          Exit;
       end;
       CreatingNewArchive := FALSE;
       if IsThisSfx(Packedfile) then Ar.sfx := TRUE;
    end else begin
       CreatingNewArchive := TRUE;
       Ar.filever := ENCVERSION;
    end;
  except
     On E: Exception do ErrorMsg('PackFiles() (1)' + U, E.Message);
  end;
  //detect if the keyfile is in source list
  if UsingKeyFile then begin
     EncForm.Button2.Visible := FALSE;
     EncForm.UseKeyFile1Click(EncForm);
     for i := 0 to addlist.count - 1 do begin
        if (uppercase(srcpath + addlist[i])) = uppercase(ExpandFileName(pwd^)) then begin
           MessageBox(0, PChar(Strings.GeneralMessages.DontEncryptYourKeyFile),
                      'AES plugin',
                      MB_OK + MB_ICONWARNING);
           Result := 0;
           Exit;
        end;
     end;//for
     //try to open keyfile...

     size := FSize(Settings.current_keyfile);
     filemode := 0;
     h_file := FileOpen(ExpandFilename(settings.current_keyfile), fmOpenRead);
     if h_file = -1  then begin
        MessageBox(0, PChar(Strings.GeneralMessages.ErrorOpeningKeyFile),
                   'AES plugin',
                   MB_OK + MB_ICONERROR);
        Result := 0;
        Exit;
     end;
     FileClose(h_file);
     if size < 2048 then begin
        MessageBox(0, PChar(Strings.GeneralMessages.InvalidKeyFileSize),
                   'AES plugin',
                   MB_OK + MB_ICONERROR);
        Result := 0;
        Exit;
     end;
  end else begin
     EncForm.Button2.Visible := TRUE;
     EncForm.UseKeyFile1Click(EncForm);
     if not SameKeyForAll then
        StrPcopy(pwd^, EncForm.Edit1.Text);
  end;
  EncForm.Edit2.Clear;
  EncForm.Edit1.Clear;
  //keyfilename OR password is in pwd


  if OnlyWiping then begin
    try
      for i := 0 to addlist.Count - 1 do begin
          Result := WipeFile(0, srcpath + addlist[i]);
          if Result <> 0 then Exit;
      end;
      for i := 0 to addlist.Count - 1 do begin
          dir1 := ExtractFilePath(srcpath + addlist[i]);
          repeat
             dir2 := dir1;
             if Length(srcpath) >= (Length(dir2)) then break;
             RemoveDir(dir2);
             if (dir2[Length(dir2)] = '\') AND (Length(dir2) > 3) then SetLength(dir2, Length(dir2) - 1);
             dir1 := ExtractFilePath(dir2);
          until dir2 = dir1;
      end;
    finally
      Addlist.Free;
    end;
    Exit;
  end;
  KeyEntered := TRUE;  
  //creates packedfile if not exists
  outf := FileOpen(PackedFile, fmOpenWrite);
    try
      if outf = -1 then
         outf := FileCreate(PackedFile);
      finally
         FileClose(outf);
    end;

  //create packedfile if not exists
  if not CreatingNewArchive then begin
     outf := FileOpen(PackedFile, fmOpenRead);
     if Ar.sfx then begin
        FileSeek(outf, Ar.AESStartPos, soFromBeginning);
        FileRead(outf, header, sizeof(header));
        FileSeek(outf, AR.AESStartPos, soFromBeginning);
     end else begin
        FileSeek(outf, 0, soFromBeginning);
        FileRead(outf, header, sizeof(header));
        FileSeek(outf, 0, soFromBeginning);
     end;
     FileRead(outf, header, sizeof(header));
     FileClose(outf);
     MakeKeyHash(header.salt, header.keyhash);
     if WrongHash_ModMsg(header.keyhash, header.keyhash) then begin
        Result := E_BAD_ARCHIVE;
        Exit;
     end;
  end;
  //copy sfx file if selected
  if CreatingSFXFile then begin
     if (FileExists(ChangeFileExt(PackedFile, '.exe'))) AND (not IsThisSfx(ChangeFileExt(PackedFile, '.exe'))) then begin
        if MessageBox(0, PChar(ChangeFileExt(PackedFile, '.exe')+ U +
                               Strings.GeneralMessages.ConfirmOverwrite),
                      PChar(Strings.GeneralCaptions.Confirm),
                      MB_YESNO) = idNO then
        begin
           Exit;
        end;
        for i := 0 to addlist.count - 1 do
          if srcpath + addlist[i] = ChangeFileExt(PackedFile, '.exe') then
             addlist.Delete(i);

        if DeleteFile(PChar(ChangeFileExt(PackedFile, '.exe'))) = FALSE then begin
           MessageBox(0, PChar(Strings.GeneralMessages.CouldntDeleteFile),
                      PChar(Strings.GeneralCaptions.Error),
                      MB_OK + MB_ICONASTERISK);
           DeleteFile(PChar(Packedfile)); //.aes
           Result := 0;
           Exit;
        end;
     end;
     WriteSfxFile(PackedFile);
   end;

   filelist := TStringList.Create;
   DontCompressTheseFileTypes := TStringList.Create;
   try
      try //3
         ExtractStrings([':'], [' '], PChar(Settings.dontcompress_filetypes), DontCompressTheseFileTypes);
         if DontCompressTheseFileTypes.Count > 0 then
            for i := 0 to DontCompressTheseFileTypes.Count - 1 do
                DontCompressTheseFileTypes[i] := uppercase(DontCompressTheseFileTypes[i]);
         Result := GetFileList(PackedFile, filelist);
         if Result = E_BAD_ARCHIVE then begin
            MessageBox(0, PChar(Strings.GeneralMessages.WrongPwd + U +
                                Strings.GeneralMessages.YouCantModify),
                       'AES plugin',
                       MB_OK + MB_ICONERROR);
            Exit;
         end;
         if Ar.sfx And (filelist.Count > 0) then
           TruncateSfxSize(Packedfile);

         for i := 0 to Addlist.count - 1 do begin

            tempstr1 := addlist[i];
            if PackWithPathNames AND (subpath <> '') then tempstr1 := subpath + '\' + tempstr1;

            FileNameInArchive := tempstr1;
            dirstr := ExtractFilePath(tempstr1);
            tempstr2 := tempstr1;
            recheck:
              if filelist.IndexOf(tempstr2) <> -1 then begin
                 //delete from archive before pack
                 ans := MessageBox(0, PChar(Strings.GeneralMessages.OverwriteConfirmationInArchive),
                             PChar(Strings.GeneralCaptions.Confirm),
                             MB_YESNOCANCEL + MB_APPLMODAL);

                 case ans of
                    idNO: begin
                             namestr := ExtractFileName(tempstr1);
                             if InputQuery('AES plugin',
                                           Strings.GeneralCaptions.TypeNewFileName,
                                           namestr) then begin
                                FileNameInArchive := dirstr + namestr;
                                tempstr2 := FileNameInArchive;
                             end;
                             goto recheck;
                             Exit;
                          end;
                    idCANCEL:
                          begin
                             addlist.Delete(i);
                             continue;
                          end;
                 end;//case
                 if ans = idYES then
                    Result := DeleteFiles(PChar(PackedFile), PChar(tempstr2));
              end;//if
              if Result <> 0 then Exit;
              origlevel := -1;
              if DontCompressTheseFileTypes.Count > 0 then
                 ext := ExtractFileExt(addlist[i]);
              if Length(ext) > 0 then begin
                 ext[1] := ' ';
                 ext := trim(ext);
                 if DontCompressTheseFileTypes.IndexOf(uppercase(ext)) <> -1 then begin
                    //don't compress this file
                    origlevel := Settings.complevel;
                    Settings.complevel := 3; //none
                 end;
              end;
              Result := AddFile(srcpath, addlist[i], FileNameInArchive, PackedFile, PackWithPathNames);
              if origlevel <> -1 then //restore original compression level
                 Settings.complevel := origlevel;
              if Result <> 0 then Exit;
         end;//for

  //wipe original files only if all ok
         if Settings.wipeorigfile then begin
            for i := 0 to addlist.Count - 1 do begin
                Result := WipeFile(Result, srcpath + addlist[i]);
                if Result <> 0 then Exit;
            end;
            for i := 0 to addlist.Count - 1 do begin
                dir1 := ExtractFilePath(srcpath + addlist[i]);
                repeat
                    dir2 := dir1;
                    if Length(srcpath) >= (Length(dir2)) then break;
                    RemoveDir(dir2);
                    if (dir2[Length(dir2)] = '\') AND (Length(dir2) > 3) then
                       SetLength(dir2, Length(dir2) - 1);
                    dir1 := ExtractFilePath(dir2);
                until dir2 = dir1;
            end;
         end;

         //"Move to archive" is checked
         if ((Flags = 1) OR (Flags = 3)) then begin
             for i := 0 to addlist.Count - 1 do
                WipeFile(0, PChar(srcpath + addlist[i]));
//                DeleteFile(PChar(srcpath + addlist[i]));
             for i := 0 to addlist.Count - 1 do begin
                 dir1 := ExtractFilePath(srcpath + addlist[i]);
                 repeat
                    dir2 := dir1;
                    if Length(srcpath) >= (Length(dir2)) then break;
                    RemoveDir(dir2);
                    if (dir2[Length(dir2)] = '\') AND (Length(dir2) > 3) then
                       SetLength(dir2, Length(dir2) - 1);
                    dir1 := ExtractFilePath(dir2);
                 until dir2 = dir1;
             end;
         end;
         if CreatingSFXFile OR Ar.sfx then begin
            AppendSFXSizeAndSizeCRC(PackedFile, SfxFileSize);
            RenameFile(PackedFile, ChangeFileExt(PackedFile, '.exe'));
         end;

      finally
         addlist.Free;
         filelist.Free;
         DontCompressTheseFileTypes.Free;
         if SameKeyForAll then
            EncForm.Keykiller.Enabled := TRUE
         else begin
            ZeroMemory(pwd, sizeof(pwd^));
            KeyEntered := FALSE;
         end;
         EncForm.Button2.Visible := TRUE;
      end; //3
   except
      On E: Exception do ErrorMSG('PackFiles()', E.Message);
   end;
end;//PackFiles

{=========================================================================}

function Configurepacker(Parent: HWND; DLLinstance: integer): integer; stdcall;
var Config: TConfigDlg;
begin
  Config := TConfigDlg.Create(Application);
  Config.ShowModal;
  Config.Free;
  Result := 0;
end;//ConfigurePacker()

{=========================================================================}

procedure PackSetDefaultParams(params: pPackDefaultParamStruct); stdcall;
begin
  Settings.IniPath := Strpas(params^.DefaultIniName);
  LoadSettings;
  LoadLanguage(Settings.langfile);
end;

{=========================================================================}

function CanYouHandleThisFile(fname: PChar): boolean; stdcall;
var nr, h: integer;
    header: misc.THeader;
    version: byte;
begin                             {$IFDEF Deb}sm('CanYouHandleThisFile()');{$ENDIF}
  Result := FALSE;
  AR.sfx := FALSE;
  try
     if FSize(String(fname)) < sizeof(header) then
        Exit;
     h := FileOpen(String(fname), fmOpenRead);
     nr := FileRead(h, header, sizeof(header));
     FileClose(h);
     if (header.magic[1] = 'M') AND (header.magic[2] = 'Z') then begin
        Result := IsThisSfx(Expandfilename(string(fname)));
        if Result = FALSE then Exit;
        AR.sfx := Result;
        Exit;
     end;
     if ((CheckMagic(header.magic) = UNKNOWN_FORMAT)  OR (nr = -1)) then
         Exit;
     GetArchiveVersion(fname, version);
     if version = 99 then Exit;
  except
     Exit;
  end;
  Result := TRUE;
end;//CanYouHandleThisFile

{=========================================================================}

function  DeleteFiles(PackedFile: PChar; DeleteList: PChar): integer; stdcall;
var header: misc.THeader;
    fname: string;
    pfname: array [0..MAX_PATH] of char;
    nr1, nr2, nw, rbytes: integer;
    extfnamelen: byte;
    Source, Dest: TStream;
    dellist: TStrings;
    tempname: string;
    NewFile: integer;
    pBuf: ^buf;
    size, size2, ProcBytes: cardinal;
    h_file: integer;
    tempfile: string;
    tk: arr4;
    i: byte;
    DeleteOriginal, DeleteThisFile: boolean;
    fulldir: string;
    fulldirs2delete: TStringList;
    marker: array[0..10] of byte;
    endcopy: boolean;
    valid: boolean;
begin        {$IFDEF Deb} sm('DeleteFiles()');{$ENDIF}
  DeleteOriginal := FALSE; //ez kell
  Result := 0;  
  try //1
     try //2
        AR.Int := FileOpen(String(PackedFile), fmOpenReadWrite);
        if AR.Int = -1 then begin Result := E_EOPEN; Exit; end;
        FileClose(AR.Int);
        if not KeyEntered then begin //3
           DecForm.StatusBar1.SimpleText := String(AR.ArchiveName);
           DecForm.StatusBar1.Hint := String(AR.ArchiveName);
           DecForm.Caption := 'AES plugin - ' + Strings.DecFormStrings.DeleteCaption;
           repeat
              DecForm.Position := poScreenCenter;
              if DecForm.ShowModal = idCancel then begin
                 Result := 0;
                 DecForm.Edit1.Clear;
                 Exit;
              end;
              if UsingKeyFile then begin
                 Settings.current_keyfile := DecForm.Edit2.Text;
                 valid := (FileExists(ExpandFileName(Settings.current_keyfile))) AND
                          (FSize(Settings.current_keyfile) > 2047);
              end else begin
                 valid := (Length(DecForm.Edit1.Text) <> 0);
                 ZeroMemory(pwd, sizeof(pwd^));
                 StrPcopy(pwd^, DecForm.Edit1.Text);
                 DecForm.Edit1.Clear;
              end;
           until valid;
        end; //3
        GetArchiveVersion(String(PackedFile), Ar.filever);
        AR.Int := FileOpen(String(PackedFile), fmOpenReadWrite);
        if Ar.sfx then
           FileSeek(AR.Int, AR.AESStartPos, soFromBeginning);
        if AR.filever < 3 then begin   //arc. contains only 1 file to delete
           FileClose(Ar.Int);
           DeleteFile(PackedFile);
           Result := 0;
           Deleted := TRUE;
           Exit;
        end;
        FileRead(AR.Int, header, sizeof(header));
        FileSeek(AR.Int, 0, soFromBeginning);
        //verify key
        Result := MakeKeyHash(header.salt, tk);
        if Result <> 0 then begin
           FileClose(Ar.Int);
           Exit;
        end;
        if WrongHash_ModMsg(header.keyhash, tk) then Exit;

        tempfile := String(PackedFile) + '.tmp';
        NewFile := FileCreate(tempfile, fmOpenReadWrite);
        if Newfile = -1 then begin
           Result := E_EWRITE;
           Exit;
        end;
        dellist := TStringList.Create;
        FullDirs2Delete := TStringList.Create;
        FullDirs2Delete.Duplicates := dupIgnore;
        ExtractStrings([#0], [], DeleteList, dellist);
        for i := 0 to dellist.count - 1 do begin
            if Pos('*.*', dellist[i]) = 0 then
               Continue
            else begin
               fulldir := Copy(dellist[i], 1, Length(dellist[i]) - (Length(dellist[i]) - Pos('*.*', dellist[i]) + 1));
               FullDirs2Delete.Add(fulldir);
            end;
        end;

        if AR.sfx then begin //copy sfx exe file
           FileSeek(AR.Int, 0, 0);
           GetMem(pbuf, sizeof(buf));
           rbytes := 0;
           endcopy := FALSE;
           try
              repeat
                 nr1 := FileRead(AR.Int, pBuf^, sizeof(buf));
                 inc(rbytes, nr1);
                 if rbytes >= (AR.AESStartPos) then begin
                    dec(nr1, rbytes - AR.AESStartPos);
                    endcopy := TRUE;
                 end;
                 nw := FileWrite(NewFile, pBuf^, nr1);
              until ((nr1 = 0) OR (nr1 <> nw) OR (nw = -1)) OR (endcopy);
              FileSeek(AR.Int, AR.AESStartPos, soFromBeginning);
           finally
              FreeMem(pbuf);
           end;
        end;
        while TRUE do begin //4
           curpos := GetFilePos(AR.Int);
           if curpos = FSize(String(PackedFile)) then break;
           if FileRead(AR.Int, header, sizeof(header)) = -1 then begin
              Result := E_EREAD;
              Exit;
           end;
           if (CheckMagic(header.magic) = UNKNOWN_FORMAT)  then begin//5
              SetFilePos(AR.Int, curpos);
              GetMem(pbuf, sizeof(buf));
              try
                  repeat
                     nr1 := FileRead(AR.Int, pBuf^, sizeof(buf));
                     nw := FileWrite(NewFile, pBuf^, nr1);
                  until ((nr1 = 0) OR (nr1 <> nw) OR (nw = -1));
              finally
                  FreeMem(pbuf);
              end;
              FileClose(Ar.Int);
              FileClose(NewFile);
              if Settings.WipeTempFile then
                 Result := WipeFile(Result, PackedFile)
              else
                 SimpleErase(String(PackedFile));
              RenameFile(TempFile, PackedFile);
              Result := 0;
              break;
           end; //5
           if Ar.filever = 1 then begin
              //old version, filename isn't encrypted
              FileRead(AR.Int, pfname, header.fnamelen);
              fname := String(pfname);
              SetLength(fname, header.fnamelen);
           end else begin //6
              //filename decryption
              Result := CreateAESKey(header.salt, header.fileversion, AESKey);
              if Result <> 0 then Exit;
              extfnamelen := header.fnamelen + header.fname_lastblocksize;
              if FileRead(AR.Int, pfname, extfnamelen) <> extfnamelen then begin
                 Result := E_EREAD;
                 Exit;
              end;
              FileClose(AR.Int); //closed until end of stream operation
              Source := TFileStream.Create(String(Packedfile), fmOpenRead);
              Dest := TMemoryStream.Create;
              try
                 Source.Position := curpos + sizeof(header);
                 DecryptAESStreamCBC(Source, extfnamelen, AESKey^, IV, Dest, ProcBytes);
                 Dest.Position := 0;
                 Dest.Read(pfname, extfnamelen);
                 fname := String(pfname);
                 SetLength(fname, header.fnamelen);
              finally
                 Source.Free;
                 Dest.Free;
                 DestroyAESKey;
              end;
              AR.Int := FileOpen(String(Packedfile), fmOpenRead);
              if SetFilePos(AR.Int, curpos) <> curpos then begin
                 Result := E_EREAD;
                 Exit;
              end;
           end; //6 filename decryption
           case Ar.filever of
             1,2,3:        nextfilestart := curpos + sizeof(header) + header.fnamelen +
                                            header.fname_lastblocksize + header.packedsize +
                                            header.lastblocksize + 2;
                 6:  begin
                           nextfilestart := curpos + sizeof(header) + header.fnamelen +
                                            header.fname_lastblocksize + header.packedsize +
                                            header.lastblocksize;
                           if header.complevel <> CLNONE then
                              inc(nextfilestart, 2);
                     end;
           end;
           size := nextfilestart - curpos;
           size2 := 0;
           DeleteThisFile := FALSE;
           if FullDirs2Delete.Count > 0 then begin
              for i := 0 to FullDirs2Delete.Count - 1 do begin
                  if Pos(FullDirs2Delete[i], fname) = 1 then begin
                     DeleteThisFile := TRUE;
                     Break;
                  end;
              end;
           end;

           //skip file if it isn't in the list
           //and seek to nextfilestart
           if (dellist.IndexOf(fname) = -1) AND not DeleteThisFile then begin //7  copy file
               GetMem(pBuf, sizeof(buf));
               try
                  repeat
                     nr1 := FileRead(AR.Int, pBuf^, sizeof(buf));
                     if nr1 = 0 then break;
                     inc(size2, nr1);
                     if size2 > size then begin
                        dec(nr1, size2 - size);
                        size2 := size;
                     end;
                     nw := FileWrite(NewFile, pBuf^, nr1);
                     if (nw = -1) then begin
                        Result := E_EWRITE;
                        Exit;
                     end;
                     if size2 = size then nr1 := 0;
                     if AR.ProcessDataProc(PChar(Strings.ProgBar.SkippingFile + ' ' + fname + '...'), 0) = 0 then
                     begin
                        Result := E_EABORTED;
                        Exit;
                     end;
                  until (nr1 = 0) OR (nw = -1);
               finally
                  FreeMem(pBuf);
               end;
           end; //7
           SetFilePos(AR.Int, nextfilestart);
        end;//4
        DeleteOriginal := TRUE;
     finally
        FileClose(AR.Int);
        FileClose(NewFile);
        KeyEntered := TRUE;
        if Result <> 0 then begin
           if Settings.WipeTempFile then begin
              Result := WipeFile(Result, tempfile);
           end else begin
              DeleteFile(PChar(tempfile));
           end;
        end;
     end; //2 try
  except
     On E: Exception do begin
        ErrorMsg('DeleteFiles()', E.message);
        Result := E_EREAD;
        Exit;
     end;
   end; //1 try
   if not IsThisSfx(PackedFile) then begin
      if (Result = 0) AND DeleteOriginal then begin //no error, delete Original packed file
         if Settings.WipeTempFile then
            Result := WipeFile(Result, PackedFile)
         else
            DeleteFile(PChar(PackedFile));
      end;
      RenameFile(tempfile, PackedFile);
   end;
   size := FSize(PackedFile);
   if (size = AR.AESStartPos + 8) OR (size = sizeof(header)) then
      DeleteFile(PChar(PackedFile));

end; //DeleteFiles()

{=========================================================================}

function EncryptFile(infile, outfile: string; PackWithPathNames: boolean): integer;
var header: misc.THeader;
    h_outf: integer;
    Source, Dest: TStream;
    j: integer;
    lb: array [1..16] of byte;
    or_encinplace: boolean;
begin                    {$IFDEF Deb}sm('EncryptFile()');{$ENDIF}
  Result := 0;

    try //2
        //seek to header
        h_outf := FileOpen(outfile, fmOpenReadWrite);
        try
           FileSeek(h_outf, LastStartPos, soFromBeginning);
           FileRead(h_outf, header, sizeof(header));
           CreateRandomSalt(header.salt);
           Result := MakeKeyHash(header.salt, header.keyhash);
        finally
           FileClose(h_outf);
        end;
        if Result <> 0 then Exit;

        if (Settings.complevel <> CLNONE) OR (header.fileversion < 6) then begin
           EncryptInPlace := TRUE;
           j := FSize(infile) - LastStartPos - sizeof(header) - header.fnamelen -
                header.fname_lastblocksize - 2;
        end else begin
           EncryptInPlace := FALSE;
           j := header.unpackedsize;
        end;

        h_outf := FileOpen(outfile, fmOpenReadWrite);
        try
           header.lastblocksize := GetLBSize(j);
           //write random data to the end of file
           FileSeek(h_outf, 0, soFromEnd);
           Rnd.Seed('', -1);
           Rnd.Buffer(lb, sizeof(lb));
           FileSeek(h_outf, LastStartPos, soFromBeginning);
           header.packedsize := j;
           //write out updated header
           FileWrite(h_outf, header, sizeof(header));
        finally
           FileClose(h_outf);
        end;
        rate := header.unpackedsize / header.packedsize;
        //key setup
        Result := CreateAESKey(header.salt, header.fileversion, AESKey);
        if Result <> 0 then Exit;
        // encrypt the filename
        try //4
           if Ar.filever > 1 then begin //3 //encrypt filename from version 2
              try

                 Dest := TFileStream.Create(outfile, fmOpenReadWrite);
                 Dest.Position := LastStartPos + sizeof(header);
                 or_encinplace := EncryptInPlace;
                 EncryptInPlace := TRUE;
                 Result := EncryptAESStreamCBC(Dest, header.fnamelen + header.fname_lastblocksize, AESKey^, IV, Dest);
                 EncryptInPlace := or_encinplace;                 
              finally
                 Dest.Free;
                 if (Result = E_EABORTED) then
                    if Settings.WipeTempFile And ((header.complevel <> CLNONE) OR (header.fileversion < 6)) then begin
                    //if complevel=clnone and fileversion>=6 there is no temp file, directly encrypt to packedfile
                       WipeFile(Result, infile)
                    end else begin
                       h_outf := FileOpen(outfile, fmOpenReadWrite);
                       SetFilePos(h_outf, LastStartPos);
                       SetEndOfFile(h_outf);
                       FileClose(h_outf);
                    end;//if
              end;//try
           end; //3
           if Result = E_EABORTED then Exit;

           if EncryptInPlace then
              Source := TFileStream.Create(infile, fmOpenReadWrite)
           else begin
              Source := TFileStream.Create(infile, fmOpenRead);
              Dest := TFileStream.Create(outfile, fmOpenReadWrite);
           end;
           //and encrypt the file
              if EncryptInPlace then begin
                  Source.Position := LastStartPos+sizeof(header) + header.fnamelen + header.fname_lastblocksize + 2;
                  Result := EncryptAESStreamCBC(Source, Source.Size - Source.Position, AESKey^, IV, Source);
              end else begin
                  Dest.Position := LastStartPos + sizeof(header) + header.fnamelen + header.fname_lastblocksize;
                  Result := EncryptAESStreamCBC(Source, Source.Size, AESKey^, IV, Dest);
              end;
           finally
              Source.Free;
              if not EncryptInPlace then
                 Dest.Free;
              if Result = E_EABORTED then
              if Settings.WipeTempFile  And ((header.complevel <> CLNONE) OR (header.fileversion < 6)) then
                 WipeFile(Result, infile)
              else begin
                 //if aborted -> only truncate the last file instead of erase the whole .aes file
                 h_outf := FileOpen(outfile, fmOpenReadWrite);
                 SetFilePos(h_outf, LastStartPos);
                 SetEndOfFile(h_outf);
                 FileClose(h_outf);
              end;
        end; //4
     except
        On E: Exception do
         ErrorMSG('EncryptFile()', E.Message);
     end;//2
end;//EncryptFile()

{=========================================================================}

function ChangePassword: integer;
var nextfilestart, ProcBytes: cardinal;
    nr: cardinal;
    header: misc.THeader;
    sNewfilename, fname: string;
    pfname: array [0..MAX_PATH] of char;
    newAESKey: PAESKey128;
    AFS, Nfs, MemSt, MemSt2: TStream;
    iNewfile: integer;
    oldpos, newpos: cardinal; //header start from this pos. in old and new .aes file
    newsalt: arr11;
    buf: array [0..15] of byte;
    ts: ^pwdarr;
begin    {$IFDEF DEB} sm('ChangePassword()'); {$ENDIF}
 Result := 0;
 AR.ProcessDataProc := nil;
 try //1
    TestingForm.StatusBar1.SimpleText := ExtractFileName(AR.ArchiveName);
    TestingForm.Label1.Caption := Strings.PwdChangeStrings.CRCTest;
    TestingForm.Label1.Left := (TestingForm.Width - TestingForm.Label1.Width) div 2;
    TestingForm.Update;
    TestingForm.Show;
    Application.ProcessMessages;
    Result := TestArchive;
    if Result <> 0 then begin
       TestingForm.Hide;
       Exit;
    end;
    sNewfilename := AR.ArchiveName + '.tmp';
    iNewFile := FileCreate(sNewfilename, fmCreate);
    if iNewFile = -1 then begin
       TestingForm.Hide;
       Result := E_EWRITE;
       Exit;
    end;
    FileSeek(AR.Int, 0, soFromBeginning);
    TestingForm.Label1.Caption := Strings.PwdChangeStrings.Reencrypting;
    TestingForm.Label1.Left := (TestingForm.Width - TestingForm.Label1.Width) div 2;
    TestingForm.Update;
    EncryptInPlace := TRUE;
    try //2
       while TRUE do begin //3
          oldpos := GetFilePos(AR.Int);
          newpos := GetFilePos(iNewfile);
          //read header
          nr := FileRead(AR.Int, header, sizeof(header));
          if (nr <> sizeof(header)) then begin
             Result := 0;
             Break;
          end;
          if (CheckMagic(header.magic) = UNKNOWN_FORMAT) then begin
             Result := 0;
             Break;
          end;
          //setup AESKey from OLD pwd
          CreateAESKey(header.salt, header.fileversion, AESKey);
          CreateRandomSalt(newsalt);
          header.salt := newsalt;
          SetFilePos(iNewFile, newpos);
          //generate keyhash
          ts := VirtualAlloc(nil,
                             sizeof(ts^),
                             MEM_COMMIT,
                             PAGE_READWRITE);
          VirtualLock(ts, sizeof(ts^));
          StrCopy(ts^, pwd^);
          StrCopy(pwd^, newpwd^);
          Result := MakeKeyHash(newsalt, header.keyhash);
          if Result <> 0 then Exit;
          //write out updated header
          FileWrite(iNewFile, header, sizeof(header));
          newAESKey := VirtualAlloc(nil,
                                    sizeof(newAESKey^),
                                    MEM_COMMIT,
                                    PAGE_READWRITE);
          VirtualLock(newAESkey, sizeof(newAESKey^));
          //setup newAESKey from NEW pwd
          CreateAESKey(newsalt, header.fileversion, newAESKey);
          StrCopy(pwd^, ts^);
          VirtualFree(ts, 0, MEM_RELEASE);
          if header.fileversion = 1 then begin
             //old version, filename isn't encrypted, just copy it
             FileRead(AR.Int, pfname, header.fnamelen);
             FileWrite(iNewfile, pfname, header.fnamelen);
             TestingForm.StatusBar1.SimpleText := String(pfname);
             Application.ProcessMessages;
          end else begin //4
             //re-encrypt filename
             try
                FileClose(AR.Int); //closed until end of stream operation
                Afs := TFileStream.Create(AR.ArchiveName, fmOpenRead);
                MemSt := TMemoryStream.Create;
                MemSt2 := TMemoryStream.Create;
                try //5
                    Afs.Position := oldpos + sizeof(header);
                    if header.fileversion = 1 then
                       DecryptAESStreamCBC(Afs,  header.fnamelen, AESKey^, IV, MemSt, ProcBytes)
                    else
                       DecryptAESStreamCBC(Afs,  header.fnamelen + header.fname_lastblocksize, AESKey^, IV, MemSt, ProcBytes);
                    MemSt.Position := 0;
                    MemSt.Read(pfname, header.fnamelen);
                    SetString(fname, pfname, header.fnamelen);
                    TestingForm.StatusBar1.SimpleText := fname;
                    Application.ProcessMessages;
                    MemSt.Position := header.fnamelen;

                    //append new random byte array to fname
                    if header.fileversion > 1 then begin
                       Rnd.Seed('', -1);
                       Rnd.Buffer(buf, header.fname_lastblocksize);
                       MemSt.Write(buf, header.fname_lastblocksize);
                       MemSt.Position := 0;
                       EncryptAESStreamCBC(MemSt, header.fnamelen + header.fname_lastblocksize, newAESKey^, IV, MemSt);
                       MemSt.Position := 0;
                       MemSt.Read(pfname, header.fnamelen + header.fname_lastblocksize);
                       //write out the re-encrypted filename
                       FileWrite(iNewfile, pfname, header.fnamelen + header.fname_lastblocksize);
                    end else begin
                       EncryptAESStreamCBC(MemSt, header.fnamelen, newAESKey^, IV, MemSt);
                       MemSt.Position := 0;
                       MemSt.Read(pfname, header.fnamelen);
                       FileWrite(iNewfile, pfname, header.fnamelen);
                    end;
                finally
                    Afs.Free;
                    MemSt.Free;
                    MemSt2.Free;
                    AR.Int := FileOpen(AR.ArchiveName, fmOpenRead);
                end; //5
             except
                On E: Exception do
                  ErrorMsg('ChangePassword() (1)', E.Message);
             end;
          end; //4
          //decrypt the file
          FileSeek(AR.Int, oldpos, soFromBeginning);
          FileClose(iNewfile);
          Result := DecryptFile(PChar(AR.ArchiveName), sNewFilename);
          if Result <> 0 then begin
             if Settings.WipeTempFile then
                WipeFile(Result, sNewFileName)
             else
                SimpleErase(sNewFileName);
             Exit;
          end;

          //re-encrypt the compressed and decrypted file

          Nfs := TFileStream.Create(sNewfilename, fmOpenReadWrite);
          Nfs.Seek(0, soFromEnd);
          Rnd.Seed('', -1);
          Rnd.Buffer(buf, header.lastblocksize);
          Nfs.Write(buf, header.lastblocksize);
          try //6
             case header.fileversion of
                1: Nfs.Position := newPos + sizeof(header) + header.fnamelen;
              2,3: Nfs.Position := newPos + sizeof(header) + header.fnamelen + header.fname_lastblocksize + 2;
                6: begin
                     Nfs.Position := newPos + sizeof(header) + header.fnamelen + header.fname_lastblocksize;
                     if header.complevel <> CLNONE then
                        Nfs.Position := Nfs.Position + 2;
                   end;
             end;
             EncryptInPlace := TRUE;
             Result := EncryptAESStreamCBC(Nfs, Nfs.Size - Nfs.Position, newAESKey^, IV, Nfs);
          finally
             Nfs.Free;
             DestroyAESKey;
             VirtualFree(newAESkey, 0, MEM_RELEASE);
             if Result = E_EABORTED then begin
                if Settings.WipeTempFile then
                   WipeFile(Result, sNewFileName)
                else
                   SimpleErase(sNewFileName);
             end;
          end; //6
          if Result <> 0 then Exit;
          case header.fileversion of
                6:  begin
                       nextfilestart := oldpos + sizeof(header) + header.fnamelen +
                                           header.fname_lastblocksize + header.packedsize +
                                           header.lastblocksize;
                       if header.complevel <> CLNONE then
                          inc(nextfilestart, 2);
                    end;
                3:     nextfilestart := oldpos + sizeof(header) + header.fnamelen +
                                        header.fname_lastblocksize + header.packedsize +
                                        header.lastblocksize + 2;
                2:     nextfilestart := oldpos + sizeof(header) + header.fnamelen +
                                        header.fname_lastblocksize + header.packedsize +
                                        header.lastblocksize;
                1:     nextfilestart := oldpos + sizeof(header) + header.fnamelen +
                                        header.packedsize + header.lastblocksize
          end;
          SetFilePos(AR.Int, nextfilestart);
          LastStartPos := newpos;
          Result := UpdateHeader(sNewFileName);
          if Result <> 0 then Exit;
          iNewfile := FileOpen(sNewfilename, fmOpenReadWrite);
          SetFilePos(iNewFile, nextfilestart);
          Application.ProcessMessages;
       end; //3 //while
    finally
       TestingForm.Hide;
       FileClose(iNewfile);
       FileClose(AR.Int);
       StrCopy(PChar(pwd), PChar(newpwd));
       ZeroMemory(newpwd, sizeof(newpwd^));
       DecForm.PwdChangeM.Checked := FALSE;
       KeyEntered := FALSE;
    end; //2
    curpos := 0;
    DeleteFile(PChar(AR.ArchiveName));
    RenameFile(sNewFileName, AR.ArchiveName);
 except
    On E: Exception do
      ErrorMsg('ChangePassword() (2)', E.Message);
 end;
end;//ChangePassword()

{=========================================================================}

initialization
    if not PluginSelfCheck then begin
       MessageBox(0, PChar('Plugin self-check failed. ' + U + 'Exiting...'), 'AES plugin', MB_ICONERROR);
       Application.Terminate;  
    end;

    sfxres := TResourceStream.Create(hInstance, 'SFXEXE', RT_RCDATA);
    SfxFileSize := sfxres.Size;
    sfxres.Free;
    Ar.filever := 0;
    Deleted := FALSE;
finalization
  ZeroMemory(Addr(AR), sizeof(AR));


end.
