{$I deb.inc}
unit common;
interface

uses misc, windows, sysutils, wcxhead, crc, classes, forms, decformu,
     language;

    function TestArchive: integer;
    function DecryptFile(infile, outfilename: string): integer;
    
implementation

{=============================================================================}

function TestArchive: integer;
var nr: cardinal;
    header: misc.THeader;
    newcrc: longword;
    pfname: array [0..MAX_PATH] of char;
    size, size2: cardinal;
    pbuf: ^buf;
begin      {$IFDEF DEB} sm('TestArchive()'); {$ENDIF}
  Result := 0;
  try //1
      nr := FileRead(AR.Int, header, sizeof(header));
      if (nr <> sizeof(header)) OR (CheckMagic(header.magic) = UNKNOWN_FORMAT) then begin
         Result := E_UNKNOWN_FORMAT;
         Exit;
      end;

      CRC32Init(newcrc);
      CRC32Update(newcrc, @header.reserved, sizeof(header) - sizeof(header.crc) - sizeof(header.magic));
      rate := header.unpackedsize / header.packedsize;
      case header.fileversion of
           1: begin
                FileRead(AR.Int, pfname, header.fnamelen);
                CRC32Update(newcrc, @pfname, header.fnamelen);
                size := header.packedsize + header.lastblocksize;
              end;
           2: begin
                FileRead(AR.Int, pfname, header.fnamelen + header.fname_lastblocksize);
                CRC32Update(newcrc, @pfname, header.fnamelen + header.fname_lastblocksize);
                size := header.packedsize + header.lastblocksize;
              end;
           3: begin
                FileRead(AR.Int, pfname, header.fnamelen + header.fname_lastblocksize);
                CRC32Update(newcrc, @pfname, header.fnamelen + header.fname_lastblocksize);
                size := header.packedsize + header.lastblocksize + 2;
              end;
           6: begin
                FileRead(AR.Int, pfname, header.fnamelen + header.fname_lastblocksize);
                CRC32Update(newcrc, @pfname, header.fnamelen + header.fname_lastblocksize);
                size := header.packedsize + header.lastblocksize;
                if header.complevel <> CLNONE then
                   inc(size, 2);
              end else begin
                Result := E_BAD_ARCHIVE;
                Exit;
              end;
      end;//case
      GetMem(pBuf, sizeof(buf));
      try //2
          size2 := 0;
          repeat
             if sizeof(buf) > size then
                nr := FileRead(Ar.Int, pBuf^, size)
             else
                nr := FileRead(Ar.Int, pBuf^, sizeof(buf));
             if nr = 0 then break;
             inc(size2, nr);
             if size2 > size then begin
                nr := nr - (size2 - size);
                size2 := size;
             end;
             CRC32Update(newcrc, pBuf, nr);
             if size2 = size then nr := 0;
          until (nr = 0);
          newcrc := CRC32Final(newcrc);

          SetFilePos(Ar.Int, nextfilestart);
          if header.crc <> newcrc  then begin
             Result := E_BAD_ARCHIVE;
             Exit;
          end;
          Application.ProcessMessages;
      finally
          FreeMem(pBuf);
      end; //2
  except
    On E: Exception do begin
         ErrorMsg('TestArchive()', E.message);
         Result := E_BAD_ARCHIVE;
         Exit;
    end;
  end; //1

end; //TestArchive

{=============================================================================}

function DecryptFile(infile, outfilename: string): integer;
var header: misc.THeader;
    pfname: array [0..MAX_PATH] of char;
    Source: TStream;
    curpos, sizebefore, ProcBytes: cardinal;
    zh: smallint;
begin                    {$IFDEF Deb}sm('DecryptFile()');{$ENDIF}
  Result := 0;
  try    //1
      try   //2
          CRC32Init(mycrc);
          curpos := GetFilePos(AR.Int);
          FileRead(AR.Int, header, sizeof(header));
          CRC32Update(mycrc, @header.reserved, sizeof(header) - sizeof(header.crc) - sizeof(header.magic));
          case Ar.filever of
               1: begin
                    FileRead(AR.Int, pfname, header.fnamelen);
                    CRC32Update(mycrc, @pfname, header.fnamelen);
                  end;
               2: begin
                    FileRead(AR.Int, pfname, header.fnamelen + header.fname_lastblocksize);
                    CRC32Update(mycrc, @pfname, header.fnamelen + header.fname_lastblocksize);
                  end
                  else begin
                    FileRead(AR.Int, pfname, header.fnamelen + header.fname_lastblocksize);
                    CRC32Update(mycrc, @pfname, header.fnamelen + header.fname_lastblocksize);
                    if (header.complevel <> CLNONE) or (header.fileversion < 6) then begin
                       FileRead(AR.Int, zh, 2);
                       CRC32Update(mycrc, @zh, 2);
                    end;
                  end;
          end;
          FileClose(AR.Int);
          rate := header.unpackedsize / header.packedsize;
          Result := CreateAESKey(header.salt, header.fileversion, AESKey);
          if Result <> 0 then Exit;
          Source := TFileStream.Create(infile, fmOpenRead);
          try //4
               try //5
                   if DecForm.PwdChangeM.Checked then begin
                      //already exists the dest file and decrypt to its end
                      MyFStream := TFileStream.Create(outfilename, fmOpenReadWrite);
                      MyFStream.Seek(0, soFromEnd);
                      sizebefore := MyFStream.Size;
                   end else begin//only decrypt the file
                      FileSetAttr(outfilename, faArchive);
                      if FileExists(outfilename) then begin
                         if DeleteFile(PChar(outfilename)) = FALSE then begin
                            Result := E_EWRITE;
                            Exit;
                         end;
                      end;
                      MyFStream := TFileStream.Create(outfilename, fmCreate);
                      sizebefore := 0;
                   end;
                   case Ar.filever of
                        1: Source.Position := curpos + sizeof(header) + header.fnamelen;
                        2: Source.Position := curpos + sizeof(header) + header.fnamelen +
                                              header.fname_lastblocksize;
                        3: begin
                             Source.Position := curpos + sizeof(header) + header.fnamelen +
                                                header.fname_lastblocksize;
                             Source.Read(zh, 2);
                             MyFStream.Write(zh, 2);
                           end;
                        6: begin
                             Source.Position := curpos + sizeof(header) + header.fnamelen +
                                                header.fname_lastblocksize;
                             if (header.complevel <> CLNONE) then begin
                                Source.Read(zh, 2);
                                MyFStream.Write(zh, 2);
                             end;
                           end;
                   end; //case
                   DecryptAESStreamCBC(Source, header.packedsize + header.lastblocksize, AESKey^, IV, MyFStream, ProcBytes);
                   if Assigned(AR.ProcessDataProc) then
                      if AR.ProcessDataProc(PChar(Strings.ProgBar.DecryptingFile + progfilename), header.packedsize + header.lastblocksize - ProcBytes) = 0 then ;
                   if header.fileversion >= 6 then begin
                      if header.complevel <> CLNONE then
                         MyFStream.Size := sizebefore + header.packedsize
                      else
                         MyFStream.Size := sizebefore + header.unpackedsize;
                   end;
               finally
                   Source.Free;
                   MyFStream.Free;
               end; //5
          except
             On E: Exception do begin
                if not (DecryptError in [E_EREAD, E_EWRITE]) then
                   ErrorMSG('DecryptFile() (1)', E.message);
             end;
          end; //4
          Result := DecryptError;
          mycrc := CRC32Final(mycrc);
          if ((Result <> 0) OR (header.crc <> mycrc)) AND
             (not Settings.SkipCRCCheck) then begin
                if Settings.WipeTempFile then begin
                   if Assigned(AR.ProcessDataProc) then
                      AR.ProcessDataProc(nil, -(header.packedsize + header.lastblocksize));
                   WipeFile(E_BAD_ARCHIVE, outfilename)
                end else begin
                   SimpleErase(outfilename);
                end;
                Result := E_BAD_ARCHIVE;
          end;
      finally
          if Result = E_EABORTED then begin
             if Settings.WipeTempFile then
                WipeFile(Result, outfilename)
             else begin
                SimpleErase(outfilename);
             end;
             Result := E_EABORTED;
          end;
          if Result = 0 then begin
            AR.Int := FileOpen(AR.Archivename, fmOpenRead);
            SetFilePos(AR.Int, nextfilestart);
          end;

      end; //2
 except
   on E: Exception do begin
     if not (DecryptError in [E_EREAD, E_EWRITE]) then
        ErrorMsg('DecryptFile() (2)', E.Message);
        Exit;
     end;
   end; //1
end;//DecryptFile



end.
