unit encformu;

interface
uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, configdialog, dialogs, Menus, misc,
  wcxhead, language;
type
  TEncform = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    PopupMenu1: TPopupMenu;
    Hide1: TMenuItem;
    Wipeonly1: TMenuItem;
    StatusBar1: TStatusBar;
    N1: TMenuItem;
    Usekeyfile1: TMenuItem;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    Edit2: TEdit;
    cbCreateSfx: TMenuItem;
    cbSeparateArc: TMenuItem;
    Keykiller: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Hide1Click(Sender: TObject);
    procedure Wipeonly1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Usekeyfile1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    function  ShowEncDlg(Sender: TObject): integer;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormHide(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cbCreateSfxClick(Sender: TObject);
    procedure cbSeparateArcClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure KeykillerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var Encform: TEncform;

implementation

{$R *.DFM}

{=========================================================================}

procedure TEncform.Button1Click(Sender: TObject);
begin
   Popupmenu1.Popup(Button1.ClientOrigin.x, Button1.ClientOrigin.y + Button1.Height);
end;


{=========================================================================}

procedure TEncform.FormShow(Sender: TObject);
begin
   Caption := 'AES plugin - ' + Strings.EncFormStrings.EncryptCaption;

   BitBtn1.Caption := Strings.GeneralCaptions.Ok;
   Bitbtn2.Caption := Strings.GeneralCaptions.Cancel;
   Button1.Caption := Strings.GeneralCaptions.Options;
   Hide1.Caption := Strings.GeneralCaptions.OptionsHidePwd;
   WipeOnly1.Caption := Strings.EncFormStrings.OptionsWipeOnly;
   OpenDialog1.Title := Strings.EncFormStrings.OpenDialogTitle;
   Button2.Caption := Strings.GeneralCaptions.Open;
   cbCreateSfx.Caption := Strings.EncFormStrings.CreateSfxArchive;
   cbSeparateArc.Caption := Strings.EncFormStrings.ApplyTheSameKeyForAllFile;
   OpenDialog1.Filter := Strings.GeneralCaptions.AllFiles + '|*.*';
   if Settings.hotkey_encryptwith <> '' then
      UseKeyfile1.Shortcut := TextToShortcut(Settings.hotkey_encryptwith);
   cbCreateSfx.ShortCut := TextToShortcut(Settings.hotkey_createsfx);
   if UsingKeyfile then
      Edit2.SetFocus
   else
      Edit1.SetFocus;
   if Settings.always_create_sfx AND (not CreatingSfxFile) then
      cbCreateSfxClick(Sender);                                                 
end;

{=========================================================================}

procedure TEncform.Hide1Click(Sender: TObject);
begin
   if Edit1.PasswordChar = '*' then begin
      Edit1.PasswordChar := #0;
      Hide1.Checked := FALSE;
   end else begin
      Edit1.PasswordChar := '*';
      Hide1.Checked := TRUE;
   end;
   Edit1.SetFocus;
   Edit1.SelStart := Length(Edit1.Text);
end;

{=========================================================================}

procedure TEncform.Wipeonly1Click(Sender: TObject);
begin
  if MessageBox(0, PChar(WrapText(Strings.GeneralMessages.WipeWarning, 35)),
                'AES plugin',
                MB_YESNO + MB_DEFBUTTON2 + MB_ICONWARNING) = idYES then begin
     ModalResult := mrOK;
     OnlyWiping := TRUE;
  end;
  Edit1.PasswordChar := '*';
  Hide1.Checked := TRUE;
  Edit1.SetFocus;
  Edit1.SelStart := Length(Edit1.Text);
end;

{=========================================================================}

procedure TEncform.Edit1Change(Sender: TObject);
begin
 Edit1.SelStart := Edit1.SelStart;
 Edit1.SelLength := 0;
end;

{=========================================================================}

procedure TEncform.Usekeyfile1Click(Sender: TObject);
begin
  UsingKeyFile := not (Button2.Visible);
  if UsingKeyFile then begin
     UseKeyfile1.Caption := Strings.EncFormStrings.EncryptWithPassword;
     Label1.Caption := Strings.EncFormStrings.SelectKeyFile;
     Button2.Visible := TRUE;
     Edit1.Visible := FALSE;
     Edit2.Visible := TRUE;
     Edit2.Top := Edit1.Top;
     If (Edit2.Text = '') AND (Settings.default_keyfile <> '') then
         Edit2.Text := Settings.default_keyfile;
     Hide1.Enabled := FALSE;
  end else begin
     UseKeyfile1.Caption := Strings.EncFormStrings.EncryptWithKeyFile;
     Label1.Caption := Strings.EncFormStrings.TypePwd;
     Button2.Visible := FALSE;
     Edit1.Visible := TRUE;
     Edit2.Visible := FALSE;
     Hide1.Enabled := TRUE;     
  end;
end;

{=========================================================================}

function TestKey(const s: string): string;
var i: byte;
    wasnumber, wasspecial, wasalpha: boolean;
    s2: ^string;
    errortext: string;
begin
    s2 := VirtualAlloc(nil,
                       sizeof(s2^),
                       MEM_COMMIT,
                       PAGE_READWRITE);
    VirtualLock(s2, sizeof(s2^));

    s2^ := trim(s);
    try
       wasnumber := FALSE;
       wasspecial := FALSE;
       wasalpha := FALSE;
       for i := 1 to Length(s2^) do begin
           if IsDigit(s2^[i]) then wasnumber := TRUE else
           If IsCharAlpha(s2^[i]) then wasalpha := TRUE else
              wasspecial := TRUE;
    end;
    if Settings.reqnumber AND (wasnumber = FALSE)   then errortext := '- '+Strings.GeneralMessages.MissingNumber+U;
    if Settings.reqspecial AND (wasspecial = FALSE) then errortext := errortext + '- '+Strings.GeneralMessages.MissingSpecial+U;
    if Settings.reqalpha AND (wasalpha = FALSE)     then errortext := errortext + '- '+Strings.GeneralMessages.MissingAlpha+U;
    if Length(s2^) < Settings.minpwdlen             then errortext := errortext + '- '+Strings.GeneralMessages.TooShort;
  finally
    VirtualFree(s2, 0, MEM_RELEASE);
  end;
  Result := errortext;
end;

{=========================================================================}

function TEncform.ShowEncDlg(Sender: TObject): integer;
var errortext: string;
    oldstate: boolean;
    label retype, type1;
begin
  LoadSettings;
  LoadLanguage(Settings.langfile);
  Result := 0;
  oldstate := UsingKeyFile;
  case Settings.complevel of
    0: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelMax;
    1: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelNormal;
    2: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelFast;
    3: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelNone;
  end;
  if Settings.wipeorigfile then
     StatusBar1.Panels[1].Text := Strings.EncFormStrings.WipeOriginal;
  repeat
    type1:
    Label1.Caption := Strings.EncFormStrings.TypePwd;
    Edit1.Clear;
    if ShowModal = idCancel then begin
       Result := E_EABORTED;
       Exit;
    end;
    if UsingKeyFile <> OldState then begin
       Result := 0;
       Exit;
    end;
    if OnlyWiping then Exit;
    if Trim(Edit1.Text) = '' then goto type1;
    StrPcopy(pwd^, Edit1.Text);
    Edit1.PasswordChar := '*';
    retype:
    Label1.Caption := Strings.EncFormStrings.RetypePwd;
    Edit1.Clear;
    if ShowModal = idCancel then begin
       Result := E_EABORTED;
       Edit1.Clear;
       Exit;
    end;
    if UsingKeyFile <> OldState then begin
       Result := 0;
       Exit;
    end;

    if OnlyWiping then Exit;
    if Trim(Edit1.Text) = '' then goto retype;
    errortext := TestKey(Edit1.Text);
    if errortext <> '' then begin
       MessageBox(0, PChar(Strings.GeneralMessages.Suit + U + errortext),
                  'AES plugin',
                  MB_OK + MB_ICONWARNING);
       Edit1.Clear;
    end else begin
       if Edit1.Text <> pwd^ then begin
          MessageBox(0, PChar(Strings.GeneralMessages.VerificationFailed),
                    'AES plugin',
                     MB_OK + MB_ICONERROR);
          Edit1.Clear;
          Edit1.Text := '';
          pwd^ := '';
       end;
    end;
  until Length(Edit1.text) <> 0;
  cbSeparateArc.Checked := FALSE;
  cbCreateSfx.Checked := FALSE;
end;

{=========================================================================}

procedure TEncform.Button2Click(Sender: TObject);
begin
  if Settings.current_keyfile <> '' then
     OpenDialog1.FileName := Settings.current_keyfile
  else
     OpenDialog1.FileName := Settings.default_keyfile;
  if OpenDialog1.Execute then
     Edit2.Text := OpenDialog1.FileName;
end;

{=========================================================================}

procedure TEncform.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ShortCut(Key, Shift) = Usekeyfile1.ShortCut then begin
     UseKeyFile1Click(Sender);
     if Edit1.Visible then begin
        Edit1.SetFocus;
        Edit1.SelStart := Length(Edit1.Text);
     end else begin
        Edit2.SetFocus;
        Edit2.SelStart := Length(Edit2.Text);
     end;
  end;

  if ShortCut(Key, Shift) = cbCreateSfx.ShortCut then cbCreateSfxClick(Sender);
  if ShortCut(key, Shift) = TextToShortcut(Settings.hotkey_complevel) then begin
     inc(Settings.complevel);
     if Settings.complevel = 4 then Settings.complevel := 0;
     case Settings.complevel of
        0: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelMax;
        1: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelNormal;
        2: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelFast;
        3: StatusBar1.Panels[0].Text := Strings.EncFormStrings.Complevel + ' ' + Strings.GeneralCaptions.CompLevelNone;
     end;
  end;
  if UsingKeyFile AND (Shortcut(Key, Shift) = TextToShortcut(Settings.hotkey_openkeyfile)) then Button2Click(Sender);
end;

{=========================================================================}

procedure TEncform.FormHide(Sender: TObject);
begin
  Edit2.Clear;
end;

{=========================================================================}

procedure TEncform.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CreatingSfxFile := cbCreateSfx.Checked;
end;

{=========================================================================}

procedure TEncform.cbCreateSfxClick(Sender: TObject);
begin
   cbCreateSfx.Checked := not cbCreateSfx.Checked;
   CreatingSfxFile := cbCreateSfx.Checked;
   if UsingKeyFile then begin
      Edit2.SetFocus;
      Edit2.SelStart := Length(Edit2.Text);
   end else
     Edit1.SetFocus;
end;

{=========================================================================}

procedure TEncform.cbSeparateArcClick(Sender: TObject);
begin
   cbSeparateArc.Checked := not cbSeparateArc.Checked;
   SameKeyForAll := cbSeparateArc.Checked;
   if UsingKeyFile then begin
      Edit2.SetFocus;
      Edit2.SelStart := Length(Edit2.Text);
   end else
     Edit1.SetFocus;
end;

{=========================================================================}

{=========================================================================}

procedure TEncform.BitBtn1Click(Sender: TObject);
begin
   Settings.current_keyfile := Edit2.Text;
end;

{=========================================================================}

procedure TEncform.KeykillerTimer(Sender: TObject);
begin
  KeyEntered := FALSE;
  ZeroMemory(pwd, sizeof(pwd));
  SameKeyForAll := FALSE;
  cbSeparateArc.Checked := FALSE;
  KeyKiller.Enabled := FALSE;
end;

initialization
  EncForm := TEncform.Create(nil);

finalization
  EncForm.Free;

end.
