{$I deb.inc}
unit misc;

interface

uses sysutils, forms, windows, dialogs, wcxhead, classes, inifiles,
     shellapi, elaes, language, crc, md5, rng, menus;
const
  ENCVERSION = 6;
  SFXVERSION = 1;
  U = #10#13;        //new line
  CLNONE = 3;
  CLFASTEST = 2;
  CLDEF = 1;
  CLMAX = 0;
  LOWSPACE = 'LOWSPACE';
  WRITE_ERROR = 'WRITE_ERROR';
  VERSIONTEXT = '0.6.3';
  BUFSIZE = 131072;

  MAGIC = 'AES' + #0;
  UNKNOWN_FORMAT = 1;
type
  arr11 = array [0..10] of byte;
  arr10 = array [0..9] of byte;
  arr24 = array [0..19] of byte;
  arr4 = array [0..3] of byte;//int
  arr4ch = array [1..4] of char;
  TStrBuf = array [0..MAX_PATH] of char;
  buf = array [1..BUFSIZE] of byte;

type
  THeader = Record
       magic: arr4ch;
       crc: longword;
       reserved: array [1..3] of byte;
       fname_lastblocksize: byte;
       complevel: byte;
       fileattr: integer;
       filetime: integer;
       unpackedsize: cardinal;
       packedsize: cardinal;
       fileversion: byte;
       keysize: byte;
       salt: arr11;
       keyhash: arr4;
       lastblocksize: byte;
       fnamelen: word;
  end;
type
  ArchiveRec = record
     ArchiveName: AnsiString;
     Int: integer;
     ArchiveMode: integer;
     ArchiveDate: integer;
     CurrentProcessedFile: THeaderData;
     ProcessDataProc: TProcessDataProc;
     ChangeVolProc: TChangeVolProc;
     infilename: string;
     sfx: boolean;
     sfxposition: longint;
     sfxheadsize: word;
     AESStartPos: longint;
     filever: byte;
  end;
type TSettings = record
          complevel: byte;
          minpwdlen: integer;
          inipath: string;
          wipetempfile: boolean;
          wipeorigfile: boolean;
          skipcrccheck: boolean;
          showwarning: boolean;
          reqnumber: boolean;
          reqspecial: boolean;
          reqalpha: boolean;
          always_create_sfx: boolean;
          destkeytime: integer; //itemindex
          langfile,
          dontcompress_filetypes,
          default_keyfile,
          current_keyfile,
          hotkey_encryptwith,
          hotkey_createsfx,
          hotkey_complevel,
          hotkey_openkeyfile,
          userdefined_inipath
          : string;
     end;
type
 pwdarr = array [0..127] of char;
var
  MyFStream:TFileStream;
  IV: TAESbuffer=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15);
  sfxmarker: array[0..10] of byte=(0,1,2,3,4,5,4,3,2,1,0);
  AESKey: PAESKey128;
  KeyFilePath : string;
  pwd, newpwd: ^pwdarr;
  progfilename: string;
  UsingKeyFile, CreatingSFXFile, SameKeyForAll: boolean;
  EncryptInPlace: boolean; //=TRUE if complevel<>clnone or fver<6
                           //firstly compress infile to packedfile then encrypt packedfile in-place
  KeyChange: boolean;
  LastStartPos: cardinal;
  LangFileList: TStrings;
  dllpath: array [0..MAX_PATH] of char;
  mpl: string;
  rate: real;
  nextfilestart: cardinal;
  curpos: int64;             
  mycrc: longword;
  decrypterror: integer;
  AR: ArchiveRec;
  Settings: TSettings;
  KeyEntered: boolean;
  curarchive: string;
  OnlyWiping: boolean;
  CreatingNewArchive : boolean;
  chars: array [1..36] of char=('a','b','c','d','e','f','g','h','i','j','k',
                                'l','m','n','o','p','q','r','s','t','u','v',
                                'w','x','y','z','0','1','2','3','4','5','6',
                                '7','8','9');
  function  CheckMagic(magic_0: arr4ch): byte;
  procedure Copy_Str2Buf(var buf: TStrBuf; s: AnsiString);
  procedure sm(s: string); // = showmessage(s)
  function  FSize(fn: string): integer;
  procedure ErrorMSG(FunctName, Text: string);
  function  CreateTempName(destination: string; PackedSize, UnpackedSize: cardinal): string;
  function  itos(i: integer): string;// = inttostr(i)
  function  IsDigit(c: char): boolean;
  function  GetFilePos(h: integer): int64;
  function  SetFilePos(h: integer; newpos: longword): cardinal; //from beginning
  function  FindWindowsDir : string;
  procedure LoadSettings;
  procedure SaveSettings;

  function  DeleteFile2Kuka(sFileName : string): boolean;
  function  ExtractStrings(Separators, WhiteSpace: TSysCharSet; Content: PChar;
                           Strings: TStrings): Integer;
  procedure RemoveEmptyDir(startdir: string);
  procedure AppendSFXSizeAndSizeCRC(packedfile: string; size: integer);
  function  GetLBSize(size: longint): byte;
  function  IsThisSfx(filename: string): boolean;
  function  WrongHash_ModMsg(keyhash, tk: arr4): boolean;
  function  GetSfxSize(SfxFileName: string): longint;
  function  CreateAESKey(salt: arr11; ver: byte; var _AESKey: PAESkey128): integer;
  procedure DestroyAESKey;
  Procedure CreateRandomSalt(var salt: arr11);
  procedure DecryptAESStreamCBC(Source: TStream; Count: cardinal;
                                const Key: TAESKey128;
                                const InitVector: TAESBuffer;
                                Dest: TStream;
                                var ProcessedBytes: cardinal); overload;

  procedure DecryptAESStreamCBC(Source: TStream;
                                Count: cardinal;
                                const ExpandedKey: TAESExpandedKey128;
                                const InitVector: TAESBuffer;
                                Dest: TStream;
                                var ProcessedBytes: cardinal); overload;
  function  EncryptAESStreamCBC(Source: TStream;
                               Count: cardinal;
                               const ExpandedKey: TAESExpandedKey128;
                               const InitVector: TAESBuffer;
                               Dest: TStream): integer; overload;
  function  EncryptAESStreamCBC(Source: TStream; Count: cardinal;
                               const Key: TAESKey128;
                               const InitVector: TAESBuffer;
                               Dest: TStream): integer; overload;
  function  MakeKeyHash(const salt: arr11; var keyhash: arr4): integer;
  function  WipeFile(error: byte; filename: string): integer;
  procedure GetArchiveVersion(filename: string; var version: byte);
  procedure TruncateSfxSize(Packedfile: string);
  procedure SimpleErase(fn: string);
  function PluginSelfCheck: boolean; //TRUE = no error  
implementation

{=========================================================================}

function CheckMagic(magic_0: arr4ch): byte;

var magic_1: arr4ch;
begin
  Move(MAGIC, magic_1, sizeof(magic_1));
  if not CompareMem(@magic_0, @magic_1, 4) then
     Result := UNKNOWN_FORMAT
  else
     Result := 0;
end;

{=========================================================================}

procedure Copy_Str2Buf(var buf: TStrBuf; s: AnsiString);
var
  i_char: integer;
begin
  FillChar(buf, Sizeof(buf), 0);
  if Length(s) = 0 then Exit;
  if Length(s) > MAX_PATH then
    SetLength(s, MAX_PATH);
  s := s + #0;
  for i_char := 1 to Length(s) do
    buf[i_char - 1] := s[i_char - 1];
end;

{=========================================================================}

procedure sm(s: string);
begin
  ShowMessage(s);
end;

{=========================================================================}

function itos(i: integer):string;
begin
  Result := inttostr(i);
end;

{=========================================================================}

procedure ErrorMSG(FunctName, Text: string);
begin
   Application.MessageBox(PChar(Text + U + '(' + FunctName + ')' + U), 'AES plugin - error', MB_OK);
end;

{=========================================================================}

function DriveByte(c: char): byte;
var i: byte;
begin
  for i := 1 to 26 do begin
    if chars[i] = lowercase(c) then begin
       Result := i;
       Exit;
    end;
  end;
  Result := 2;
end;

{=========================================================================}

function CreateTempName(destination: string;PackedSize, UnpackedSize: cardinal): string;
//returns a random 8.1 filename in temporary dir
var TempDir : array [0..MAX_PATH] of Char;
    temp: string;
    i: word;
    fname: string;
    h_file: integer;
    error: boolean;
    TempFreeSpace, DestFreeSpace: int64;
begin
     Destination := ExpandFileName(Destination);
     GetTempPath(MAX_PATH, @TempDir);
     temp := String(TempDir);
     fname := temp;
     TempFreeSpace := DiskFree(DriveByte(Temp[1]));
     DestFreeSpace := DiskFree(DriveByte(Destination[1]));
     if not DirectoryExists(temp) then TempFreeSpace := 0;
     if DestFreeSpace < UnpackedSize then begin
        Result := LOWSPACE;
        Exit;
     end;
     if upcase(Destination[1]) = upcase(Temp[1]) then begin
        if (PackedSize + UnpackedSize) <= DestFreeSpace then
           fname := ExtractFilePath(Destination)
        else begin
           Result := LOWSPACE;
           Exit;
        end;
     end;
     if PackedSize <= TempFreeSpace then
        fname := ExtractFilePath(Temp)
     else begin
        if (PackedSize + UnpackedSize) <= DestFreeSpace then
           fname := ExtractFilePath(Destination)
        else begin
           Result := LOWSPACE;
           Exit;
        end;
     end;
     if fname[Length(fname)] <> '\' then fname := fname + '\';
     Randomize;
     error:=false;
     repeat
         for i := 1 to 8 do fname := fname + chars[Random(35) + 1];
         fname := fname + '.';
         i := Random(900);
         fname := fname + itos(i);
         h_file := FileOpen(fname, fmOpenReadWrite);
         if h_file = -1 then
            error := TRUE
         else
            FileClose(h_file);
     until error;
     Result := fname;
end; //CreateTempName

{=========================================================================}

function FSize(fn: string): integer;
//returns the size of fn file

var dirinfo: TSearchRec;
    h: integer;
begin
   fn := ExpandFileName(fn);
   Result := FindFirst(fn, faAnyFile - faDirectory, dirinfo);
   try
     if Result <> 0 then //error
        Result := -1
     else begin
        Result := Dirinfo.Size;
        try
          try
            h := FileOpen(fn, fmOpenRead);
          except
            Result := -1;
          end;
        finally
          FileClose(h);
        end;
     end;
   finally
     Sysutils.FindClose(dirinfo);
   end;
end;

{=========================================================================}

function IsDigit(c: char): boolean;
begin
  Result := (c in ['0'..'9']);
end;

{=========================================================================}

function GetFilePos(h: integer): int64;
begin
   Result := SetFilePointer(h, 0, nil, FILE_CURRENT);
end;

{=========================================================================}

function SetFilePos(h: integer;newpos: longword): longword; //from beginning
begin
  Result := SetFilePointer(h, newpos, nil, FILE_BEGIN);
end;

{=========================================================================}

function FindWindowsDir: string;
var pWindowsDir : array [0..MAX_PATH] of Char;
begin
    GetWindowsDirectory(pWindowsDir, MAX_PATH);
    Result := StrPas(pWindowsDir);
end;

{=========================================================================}

function PluginSelfCheck: boolean; //TRUE = no error
var h, nr, pluginsize: integer;
    buf: array [0..32767] of byte;
    filecrc, newcrc: cardinal;
begin
   FillChar(dllpath, sizeof(dllpath), #0);
   GetModuleFileName(hInstance, dllpath, sizeof(dllpath));

   pluginsize := FSize(dllpath);

   h := CreateFile(dllpath,
                   GENERIC_READ,
                   FILE_SHARE_READ,
                   NIL,
                   OPEN_EXISTING,
                   FILE_ATTRIBUTE_NORMAL,
                   0);
   if h = -1 then begin
      ErrorMsg('PluginSelfCheck()', 'Open error.');
      Result := FALSE;
      Exit;
   end;
   try
      FileSeek(h, -sizeof(filecrc), soFromEnd);
      FileRead(h, filecrc, sizeof(filecrc));
      FileSeek(h, 0, soFromBeginning);
      CRC32Init(newcrc);
      repeat
           nr := FileRead(h, buf, sizeof(buf));
           if nr = 0 then break;
           if (nr <> sizeof(buf)) then begin
              dec(nr, sizeof(filecrc));
              CRC32Update(newcrc, @buf, nr);
              break;
           end else
              if GetFilePos(h) = (Pluginsize - sizeof(filecrc)) then break;
           CRC32Update(newcrc, @buf, nr);
      until (nr = 0);
      CRC32Final(newcrc);
      Result := (filecrc = newcrc);
   finally
      CloseHandle(h);
   end;
end;

{=========================================================================}

function TestFileCreate(fullpath: string): boolean; //false if dest. read-only
var h: integer;
begin
   h := CreateFile(PChar(fullpath),
                   GENERIC_WRITE,
                   FILE_SHARE_READ,
                   NIL,
                   OPEN_ALWAYS,
                   FILE_ATTRIBUTE_NORMAL,
                   0);
   try
     Result := (h <> -1);
   finally
     CloseHandle(h);
     DeleteFile(PChar(fullpath));     
   end;

end;
procedure SaveSettings;
var Reg: TIniFile;
    i: byte;
    inipath, curpath: string;
begin

   FillChar(dllpath, sizeof(dllpath), #0);
   GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
   curpath := ExtractFilePath(dllpath) + 'aes.ini';

   if Settings.userdefined_inipath <> '' then
      inipath := Settings.userdefined_inipath
   else
      inipath := Settings.inipath;
   if (ExtractFilePath(dllpath) <> ExtractFilePath(inipath)) AND (inipath <> Settings.inipath) then begin
   //user defined inipath, not close to aes.wcx
      if not TestFileCreate(curpath) then Exit;
      Reg := TInifile.Create(curpath);
      try
        Reg.WriteString('AES', 'IniPath', ExpandFileName(inipath));
      finally
        Reg.Free;
      end;
      if not TestFileCreate(inipath) then Exit;
      Reg := TIniFile.Create(inipath);
   //and save settings to that
   end else begin
      if not TestFileCreate(curpath) then Exit;
      Reg := TInifile.Create(curpath);
      Reg.DeleteKey('AES', 'IniPath');
      Reg.Free;

      if curpath <> inipath then begin
         DeleteFile(Pchar(curpath));
      end;
      if Settings.userdefined_inipath <> '' then begin
         if not TestFileCreate(Settings.userdefined_inipath) then Exit;
         Reg := TInifile.Create(Settings.userdefined_inipath);
      end else begin
         if not TestFileCreate(Settings.inipath+'.tmp') then Exit;
         Reg := TInifile.Create(Settings.Inipath);
      end;
   end;
   Settings.minpwdlen := 0;
   i := Settings.Complevel;

   Reg.WriteInteger('AES', 'CompLevel', i);
   Reg.WriteBool('AES', 'WipeOrigFile', Settings.wipeorigfile);
   Reg.WriteBool('AES', 'WipeTempFile', Settings.wipetempfile);
   Reg.WriteBool('AES', 'ShowWarning', Settings.showwarning);
   try
     if (mpl <> '') then begin
        if Length(trim(mpl)) > 0 then begin
           if StrToInt(mpl) > 255 then begin
              MessageBox(0, PChar(Strings.GeneralMessages.MaxPwdLength),
                            'AES plugin',
                            MB_OK + MB_ICONWARNING);
              Settings.minpwdlen := 255;
           end else
              Settings.minpwdlen := StrToInt(mpl);
        end;
     end;
     if Settings.minpwdlen > 0 then
        Reg.WriteInteger('AES', 'MinPwdLen', Settings.minpwdlen)
     else
        Reg.WriteInteger('AES', 'MinPwdLen', 0);
   except
     MessageBox(0, PChar(Strings.GeneralMessages.InvalidNumber),
                   'AES plugin',
                   MB_OK + MB_ICONERROR);
   end;
   Reg.WriteBool('AES', 'ReqNumber', Settings.reqnumber);
   Reg.WriteBool('AES', 'ReqSpecial', Settings.reqspecial);
   Reg.WriteBool('AES', 'ReqAlpha', Settings.reqalpha);
   Reg.WriteInteger('AES', 'DestKeyTime', Settings.destkeytime);
   Reg.WriteString('AES', 'LangFile', Settings.langfile);
   Reg.WriteString('AES', 'DontCompressTheseFileTypes', Settings.dontcompress_filetypes);
   if FSize(Settings.default_keyfile) > 0 then
      Reg.WriteString('AES', 'DefaultKeyFile', Settings.default_keyfile)
   else
      Reg.WriteString('AES', 'DefaultKeyFile', '');
   Reg.WriteString('AES', 'Hotkey_EncryptWith', Settings.hotkey_encryptwith);
   Reg.WriteString('AES', 'Hotkey_CreateSfx', Settings.hotkey_createsfx);
   Reg.WriteString('AES', 'Hotkey_CompLevel', Settings.hotkey_complevel);
   Reg.WriteString('AES', 'Hotkey_OpenKeyfile', Settings.hotkey_openkeyfile);
   Reg.WriteBool('AES', 'AlwaysCreateSfx', Settings.always_create_sfx);
   Reg.Free;
end; //SaveSettings

{=========================================================================}

procedure LoadSettings2(inipath: string);
var Reg: TInifile;
    i: byte;
begin
   Reg := TIniFile.Create(inipath);
   if not Reg.SectionExists('AES') then begin
      //defaults
      Settings.complevel := 3;
      Settings.minpwdlen := 0;
      Settings.reqnumber := FALSE;
      Settings.reqspecial := FALSE;
      Settings.reqalpha := FALSE;
      Settings.destkeytime := 1;
      Settings.langfile := '';
      Settings.showwarning := TRUE;
      Settings.always_create_sfx := FALSE;
      Settings.hotkey_encryptwith := 'F2';
      Settings.hotkey_createsfx := 'F4';
      Settings.hotkey_complevel := 'F5';
      Settings.hotkey_openkeyfile := 'F3';
      Reg.Free;
      Exit;
   end;
   i := Reg.ReadInteger('AES', 'CompLevel', 2);
   Settings.Complevel := i;
   Settings.WipeOrigFile := Reg.ReadBool('AES', 'WipeOrigFile', FALSE);
   Settings.WipeTempFile := Reg.ReadBool('AES', 'WipeTempFile', FALSE);
   Settings.ShowWarning := Reg.ReadBool('AES', 'ShowWarning', TRUE);
   Settings.minpwdlen := Reg.ReadInteger('AES', 'MinPwdLen', 0);
   Settings.reqnumber := Reg.ReadBool('AES', 'ReqNumber', FALSE);
   Settings.reqspecial := Reg.ReadBool('AES', 'ReqSpecial', FALSE);
   Settings.reqalpha := Reg.ReadBool('AES', 'ReqAlpha', FALSE);
   Settings.DestKeyTime := Reg.ReadInteger('AES', 'DestKeyTime', 1);
   Settings.langfile := Reg.ReadString('AES', 'LangFile', '');
   Settings.dontcompress_filetypes := Reg.ReadString('AES', 'DontCompressTheseFileTypes', '');
   Settings.default_keyfile := Reg.ReadString('AES', 'DefaultKeyFile', '');
   Settings.hotkey_encryptwith := Reg.ReadString('AES', 'Hotkey_EncryptWith', 'F2');
   Settings.hotkey_createsfx := Reg.ReadString('AES', 'Hotkey_CreateSfx', 'F4');
   Settings.hotkey_complevel := Reg.ReadString('AES', 'Hotkey_CompLevel', 'F5');
   Settings.hotkey_openkeyfile := Reg.ReadString('AES', 'Hotkey_OpenKeyfile', 'F3');
   Settings.always_create_sfx := Reg.ReadBool('AES', 'AlwaysCreateSfx', FALSE);
   Reg.Free;
end;//Loadsettings2

{=========================================================================}

procedure LoadSettings;
var fn, fn2: string;
    Reg: TIniFile;
begin
  FillChar(dllpath, sizeof(dllpath), #0);
  GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
  fn := ExtractFilePath(dllpath) + 'aes.ini';
  if FileExists(fn) then begin
     Reg := TIniFile.Create(fn);
     try
        if Reg.ValueExists('AES', 'IniPath') then
           fn2 := Reg.ReadString('AES', 'IniPath', '')
        else
           fn2 := fn;

     finally
        Reg.Free;
     end;
     if FileExists(fn2) then
        fn := fn2
     else
        fn := Settings.inipath;
     LoadSettings2(fn);
  end else
     LoadSettings2(Settings.inipath);

end; //LoadSettings

{=========================================================================}

function DeleteFile2Kuka( sFileName : string ): boolean; //delete to recycle bin
var fos: TSHFileOpStruct;
begin
   FillChar(fos, sizeof(fos), 0);
   with fos do begin
     wFunc := FO_DELETE;
     pFrom := PChar(sFileName);
     fFlags := FOF_ALLOWUNDO OR FOF_NOCONFIRMATION OR FOF_SILENT;
   end;
   Result := (0 = ShFileOperation(fos));
end;

{=========================================================================}

function ExtractStrings(Separators, WhiteSpace: TSysCharSet; Content: PChar;
                        Strings: TStrings): Integer;
var
  Head, Tail, Tail2: PChar;
  EOS, InQuote: Boolean;
  QuoteChar: Char;
  Item: string;
begin
  Result := 0;
  if (Content = nil) or (Content^=#0) or (Strings = nil) then Exit;
  Tail := Content;
  InQuote := False;
  QuoteChar := #0;
  Strings.BeginUpdate;
  try
    repeat
      while Tail^ in WhiteSpace + [#13, #10] do Inc(Tail);
      Head := Tail;
      while True do
      begin
        while (InQuote and not (Tail^ in ['''', '"', #0])) or
          not (Tail^ in Separators + [#0, #13, #10, '''', '"']) do Inc(Tail);
        if Tail^ in ['''', '"'] then
        begin
          if (QuoteChar <> #0) and (QuoteChar = Tail^) then
            QuoteChar := #0
          else QuoteChar := Tail^;
          InQuote := QuoteChar <> #0;
          Inc(Tail);
        end else Break;
      end;
      Tail2 := Tail + 1;
      EOS := (Tail^ = #0) And (Tail2^ = #0);
      if (Head <> Tail) then
      begin
        if Strings <> nil then
        begin
          SetString(Item, Head, Tail - Head);
          if Item[Length(Item)] <> '\' then begin
             Strings.Add(Item);
             Inc(Result);
          end;
        end;
      end;
      Inc(Tail);
    until EOS;
  finally
    Strings.EndUpdate;
  end;
end; //ExtractStrings() (original code can be found in classes.pas)

{=========================================================================}

procedure RemoveEmptyDir(startdir: string);
var nemures: boolean;
    srec: TSearchRec;
begin
  if startdir[Length(startdir)] <> '\' then startdir := startdir + '\';
  if FindFirst(startdir + '*.*', faAnyFile, srec) = 0 then begin
       nemures := FALSE;
       repeat
         if (srec.name <> '.') AND (srec.name <> '..') AND
            ((srec.attr AND faDirectory) <> 0) then begin
             RemoveEmptyDir(srec.name);
         end else nemures := TRUE;
         if not nemures then begin
            RMDir(srec.name);
         end;
       until FindNext(srec) <> 0;
   SysUtils.FindClose(srec);
  end;
end; //RemoveEmptyDir()

{=========================================================================}

procedure AppendSFXSizeAndSizeCRC(packedfile: string; size: integer);
var ph: integer;
    sizecrc: cardinal;
begin
  CRC32Init(sizecrc);
  CRC32Update(sizecrc, @size, sizeof(size));
  sizecrc := CRC32Final(sizecrc);
  ph := FileOpen(PackedFile, fmOpenReadWrite);
  FileSeek(ph, 0, 2);
  FileWrite(ph, size, sizeof(size));
  FileWrite(ph, sizecrc, sizeof(sizecrc));
  FileClose(ph);
end;

{=========================================================================}

function GetLBSize(size: longint): byte;
var j: longint;
begin
  j := size;
  while (j mod 16) <> 0 do inc(j);
  Result := j - size;
end;

{=========================================================================}

function Min(value1, value2: integer): integer;
begin
  if value1 < value2 then
     Result := value1
  else
     Result := value2;
end;

{=========================================================================}

function ISThisSfx(filename: string): boolean;
var sizecrc, r_sizecrc: longword;
    size, pos: longint;
    marker: array[0..10] of byte;
    h: integer;
    header: THeader;
begin
  Result := FALSE;
  h := FileOpen(filename, fmOpenRead);
  try
     FileSeek(h, FSize(filename) - sizeof(sizecrc) - sizeof(size), 0);
     FileRead(h, size, sizeof(size));
     FileRead(h, r_sizecrc, sizeof(r_sizecrc));

     CRC32Init(sizecrc);
     CRC32Update(sizecrc, @size, sizeof(size));
     sizecrc := CRC32Final(sizecrc);

     if CompareMem(@sizecrc, @r_sizecrc, sizeof(sizecrc)) then begin
        FileSeek(h, size + 4, 0);
        FileRead(h, marker, sizeof(marker));
        FileRead(h, AR.sfxheadsize, sizeof(AR.sfxheadsize));

        AR.sfxposition := size;
        AR.sfx := TRUE;
        AR.AESStartPos := GetFilepos(h) + AR.sfxheadsize;
        FileSeek(h, AR.AESStartPos, soFromBeginning);
        FileRead(h, header, sizeof(header));
        if CheckMagic(header.magic) <>  UNKNOWN_FORMAT then begin
           Result := TRUE;
           Exit;
        end;
     end;
     for pos := 50000 to Min(200000, Fsize(filename)) do begin
         FileSeek(h, pos, 0);
         Fileread(h, marker, sizeof(marker));
         if CompareMem(@marker, @sfxmarker, sizeof(marker)) then begin
            AR.sfxposition := Pos;
            AR.sfx := TRUE;
            FileRead(h, AR.sfxheadsize, sizeof(AR.sfxheadsize));
            AR.AESStartPos := GetFilepos(h) + AR.sfxheadsize;
            FileSeek(h, AR.AESStartPos, soFromBeginning);
            FileRead(h, header, sizeof(header));
            if CheckMagic(header.magic) <> UNKNOWN_FORMAT then begin
               Result := TRUE;
               Exit;
            end;
         end;
     end;
  finally
     FileClose(h);
  end;
  AR.AESStartPos := 0;
end;

{=========================================================================}

function WrongHash_ModMsg(keyhash, tk: arr4): boolean;
begin
  if not CompareMem(@keyhash, @tk, sizeof(tk)) then begin
    //wrong key
    KeyEntered := FALSE;
    MessageBox(0, PChar(Strings.GeneralMessages.WrongPwd + U +
               Strings.GeneralMessages.YouCantModify),
               'AES plugin',
               MB_OK);
    Result := TRUE;
    Exit;
  end;
  Result := FALSE;
end;

{=========================================================================}

function CreateAESKeyO(salt: arr11; var _AESKey: PAESKey128): integer;
var cont: TMD5Context;
    dig: ^TMD5Digest;
    h_file: integer;
    nr: integer;
    buf: array[1..1024] of byte;
begin
   try
     dig := VirtualAlloc(nil,
                         sizeof(dig^),
                         MEM_COMMIT,
                         PAGE_READWRITE);
     VirtualLock(dig, sizeof(dig^));
     if UsingKeyFile then begin
        try
          h_file := FileOpen(ExpandFileName(Settings.current_keyfile), fmOpenRead);
          if h_file = -1 then begin
             MessageBox(0, PChar(Strings.GeneralMessages.ErrorOpeningKeyFile),
                        'AES plugin',
                        MB_OK + MB_ICONERROR);
             Result := E_EOPEN;
             Exit;
          end;
          Md5Init(cont);
          repeat
             nr := FileRead(h_file, buf, sizeof(buf));
             Md5UpdateBuffer(cont, Addr(buf), nr);
          until (nr = 0) OR (nr = -1);
          Md5UpdateBuffer(cont, Addr(salt), sizeof(salt));
          Md5Final(dig^, cont);
          Move(dig^, _AESKey^, sizeof(_AESKey^));
        finally
          FileClose(h_file);
          VirtualFree(dig, 0, MEM_RELEASE);
        end;
     end else begin
       try
         Md5Init(cont);
         Md5UpdateBuffer(cont, pwd, Length(trim(pwd^)));
         Md5UpdateBuffer(cont, Addr(salt), sizeof(salt));
         Md5Final(dig^, cont);
         Move(dig^, _AESKey^, sizeof(_AESKey^));
       finally
         VirtualFree(dig, 0, MEM_RELEASE);
         ZeroMemory(Addr(cont), sizeof(cont));
       end;
     end;
   except
     On E: Exception do begin
        ErrorMSG('CreateAESKey() (O)', E.message);
        Result := 1;
        Exit;
     end;
   end;
   Result := 0;
end; //CreateAESKey()

{=========================================================================}

function CreateAESKeyN(salt: arr11; var _AESKey: PAESKey128): integer;
var pwdlen, keylen: byte;
    saltsize: byte;
    iter: word;
    outblocklen: byte;
    cont1, cont2, cont3: TMD5Context;
    dig, dig_1, dig_2: ^TMd5Digest;
    block_szam, i, k, j: word;
    nr: integer;
    buf: array [1..1024] of byte;
    h_file: integer;
begin
    Result := 0;
    try //exc
      ZeroMemory(_AESKey, sizeof(_AESKey^));
      dig := VirtualAlloc(nil,
                          sizeof(dig^),
                          MEM_COMMIT,
                          PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig^));
      dig_1 := VirtualAlloc(nil,
                            sizeof(dig_1^),
                            MEM_COMMIT,
                            PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig_1^));

      dig_2 := VirtualAlloc(nil,
                            sizeof(dig_2^),
                            MEM_COMMIT,
                            PAGE_READWRITE);
      VirtualLock(dig, sizeof(dig_2^));

      outblocklen := sizeof(dig^);
      pwdlen := Length(pwd^);
      saltsize := sizeof(salt);
      iter := 1000;
      keylen := 128;
      Md5Init(cont1);

      if UsingKeyFile then begin
         h_file := FileOpen(ExpandFileName(Settings.current_keyfile), fmOpenRead);
         try
            if h_file = -1 then begin
               MessageBox(0, PChar(Strings.GeneralMessages.ErrorOpeningKeyFile + U + Settings.current_keyfile),
                          'AES plugin',
                          MB_OK + MB_ICONERROR);
               Result := E_EOPEN;
               Exit;
            end;
            repeat
               nr := FileRead(h_file, buf, sizeof(buf));
               Md5UpdateBuffer(cont1, Addr(buf), nr);
            until (nr = 0) OR (nr = -1);
         finally
            FileClose(h_file);
         end;
      end else begin  //hash pwd
         Md5UpdateBuffer(cont1, pwd, Length(pwd^));
         Md5UpdateBuffer(cont1, Addr(pwdlen), sizeof(pwdlen));
      end;

      try //fin
         Move(cont1, cont2, sizeof(cont1));
         Md5UpdateBuffer(cont2, Addr(salt), saltsize);
         block_szam := 1 + (pwdlen - 1) div outblocklen;
         for i := 0 to block_szam do begin
             FillChar(dig_2^, sizeof(dig_1^), #0);
             Move(cont2, cont3, sizeof(cont1));
             dig_1^[0] := char((i + 1) shr 24);
             dig_1^[1] := char((i + 1) shr 16);
             dig_1^[2] := char((i + 1) shr 8);
             dig_1^[3] := char(i + 1);
             for j := 0 to iter-1 do begin
                 Md5UpdateBuffer(cont3, Addr(dig_1^), 4);
                 Md5Final(dig_1^, cont3);
                 for k := 0 to outblocklen-1 do
                     byte(dig_2^[k]) := byte(dig_2^[k]) xor byte(dig_1^[k]);
                 Move(cont1, cont3, sizeof(cont1));
             end;
             j := 0;
             k := i * outblocklen;
             while (j < outblocklen) AND (k < keylen) do begin
                   _AESkey^[k] := byte(dig_2^[j]);
                   inc(j);
                   inc(k);
             end;
         end;
      finally
        VirtualFree(dig,   0, MEM_RELEASE);
        VirtualFree(dig_1, 0, MEM_RELEASE);
        VirtualFree(dig_2, 0, MEM_RELEASE);
      end;
    except
      on E: Exception do begin
         if Result = E_EOPEN then Exit;
         ErrorMSG('CreateAESKey() (N)', E.message);
         Result := 1;
         Exit;
      end;
    end;
end;

{=========================================================================}

function CreateAESKey(salt: arr11; ver: byte; var _AESKey: PAESkey128): integer;
begin
  if ver = 6 then
    Result := CreateAESKeyN(salt, _AESKey)
  else
    Result := CreateAESKeyO(salt, _AESKey);
end;

{=========================================================================}

procedure DestroyAESKey;
begin
   ZeroMemory(AESKey, sizeof(AESKey^));
end;

{=========================================================================}

Procedure CreateRandomSalt(var salt: arr11);
begin
   Rnd.Seed('', -1);
   Rnd.Buffer(salt, sizeof(salt));
end;

{=========================================================================}

function EncryptAESStreamCBC(Source: TStream; Count: cardinal;
  const ExpandedKey: TAESExpandedKey128;  const InitVector: TAESBuffer;
  Dest: TStream): integer; overload;
var
  TempIn, TempOut, Vector: TAESBuffer;
  Done: cardinal;
  progresscikl: integer;
begin
  Result := 0;
  progresscikl := 1;
  if Count = 0 then begin
    Source.Position := 0;
    Count := Source.Size;
  end else
    Count := Min(Count, Source.Size - Source.Position);
  if Count = 0 then Exit;
  Vector := InitVector;
  while Count >= sizeof(TAESBuffer) do
  begin
    Done := Source.Read(TempIn, sizeof(TempIn));
    if EncryptInPlace then
       Dest.Seek(-done, soFromCurrent);
    if Done < sizeof(TempIn) then
      raise EStreamError.Create(SReadError);
    PLongWord(@TempIn[0])^ := PLongWord(@TempIn[0])^ xor PLongWord(@Vector[0])^;
    PLongWord(@TempIn[4])^ := PLongWord(@TempIn[4])^ xor PLongWord(@Vector[4])^;
    PLongWord(@TempIn[8])^ := PLongWord(@TempIn[8])^ xor PLongWord(@Vector[8])^;
    PLongWord(@TempIn[12])^ := PLongWord(@TempIn[12])^ xor PLongWord(@Vector[12])^;
    EncryptAES(TempIn, ExpandedKey, TempOut);
    Done := Dest.Write(TempOut, sizeof(TempOut));
    if Done < sizeof(TempOut) then
      raise EStreamError.Create(SWriteError);
    Vector := TempOut;
    Dec(Count, sizeof(TAESBuffer));

    if progresscikl <> 20 then
       inc(progresscikl)
    else begin
       if Assigned(AR.ProcessDataProc) then
          if AR.ProcessDataProc(PChar(Strings.ProgBar.EncryptingFile + ' ' + progfilename), round(rate * 320)) = 0 then begin
             Result := E_EABORTED;
             Exit;
          end;
       progresscikl := 1;
    end;
    Application.ProcessMessages;
  end;
  if Count > 0 then
  begin
    Done := Source.Read(TempIn, Count);
    if EncryptInPlace then
       Dest.Seek(-Count, soFromCurrent);
    if Done < Count then
      raise EStreamError.Create(SReadError);
    FillChar(TempIn[Count], sizeof(TempIn) - Count, 0);
    PLongWord(@TempIn[0])^ := PLongWord(@TempIn[0])^ xor PLongWord(@Vector[0])^;
    PLongWord(@TempIn[4])^ := PLongWord(@TempIn[4])^ xor PLongWord(@Vector[4])^;
    PLongWord(@TempIn[8])^ := PLongWord(@TempIn[8])^ xor PLongWord(@Vector[8])^;
    PLongWord(@TempIn[12])^ := PLongWord(@TempIn[12])^ xor PLongWord(@Vector[12])^;
    EncryptAES(TempIn, ExpandedKey, TempOut);
    Done := Dest.Write(TempOut, sizeof(TempOut));
    if Done < sizeof(TempOut) then
      raise EStreamError.Create(SWriteError);
    if Assigned(AR.ProcessDataProc) then
       if AR.ProcessDataProc(PChar(Strings.ProgBar.EncryptingFile + ' ' + progfilename), round(rate * Count)) = 0
          then begin
            Result := E_EABORTED;
            Exit;
       end;
  end;
end;//EncryptAESStreamCBC()

{=========================================================================}

function EncryptAESStreamCBC(Source: TStream; Count: cardinal;
  const Key: TAESKey128; const InitVector: TAESBuffer; Dest: TStream):integer; overload;
var
  ExpandedKey: TAESExpandedKey128;
begin
  ExpandAESKeyForEncryption(Key, ExpandedKey);
  Result := EncryptAESStreamCBC(Source, Count, ExpandedKey, InitVector, Dest);
end;

{=========================================================================}
procedure DecryptAESStreamCBC(Source: TStream; Count: cardinal;
  const Key: TAESKey128; const InitVector: TAESBuffer; Dest: TStream; var ProcessedBytes: cardinal); overload;
var
  ExpandedKey: TAESExpandedKey128;
begin
  ExpandAESKeyForDecryption(Key, ExpandedKey);
  DecryptAESStreamCBC(Source, Count, ExpandedKey, InitVector, Dest, ProcessedBytes);
end;

{=========================================================================}

procedure DecryptAESStreamCBC(Source: TStream; Count: cardinal;
  const ExpandedKey: TAESExpandedKey128;  const InitVector: TAESBuffer;
  Dest: TStream; var ProcessedBytes: cardinal); overload;
var
  TempIn, TempOut: TAESBuffer;
  Vector1, Vector2: TAESBuffer;
  Done: cardinal;
  progresscikl: integer;
  lastp: byte;
begin
  lastp := 0;
  ProcessedBytes := 0;
  try
    progresscikl := 0;
    DecryptError := 0;
    if Count = 0 then begin
      Source.Position := 0;
      Count := Source.Size;
    end else
      Count := Min(Count, Source.Size - Source.Position);
    if Count = 0 then Exit;
    if (Count mod sizeof(TAESBuffer)) > 0 then
      raise EAESError.Create(SInvalidInBufSize);
    Vector1 := InitVector;
    while Count >= sizeof(TAESBuffer) do begin
      lastp := 0;
      Done := Source.Read(TempIn, sizeof(TempIn));
      if Done < sizeof(TempIn) then
        raise EStreamError(SReadError);
      CRC32Update(mycrc, @Tempin, sizeof(tempin));
      Vector2 := TempIn;
      DecryptAES(TempIn, ExpandedKey, TempOut);
      PLongWord(@TempOut[0])^ := PLongWord(@TempOut[0])^ xor PLongWord(@Vector1[0])^;
      PLongWord(@TempOut[4])^ := PLongWord(@TempOut[4])^ xor PLongWord(@Vector1[4])^;
      PLongWord(@TempOut[8])^ := PLongWord(@TempOut[8])^ xor PLongWord(@Vector1[8])^;
      PLongWord(@TempOut[12])^ := PLongWord(@TempOut[12])^ xor PLongWord(@Vector1[12])^;
      lastp := 1;
      Done := Dest.Write(TempOut, sizeof(TempOut));
      if Done < sizeof(TempOut) then
        raise EStreamError(SWriteError);
      Vector1 := Vector2;
      Dec(Count, sizeof(TAESBuffer));

      if progresscikl <> 20 then
        inc(progresscikl)
      else begin
        if Assigned(AR.ProcessDataProc) then begin
           inc(ProcessedBytes, round(320 * rate));
           if AR.ProcessDataProc(PChar(Strings.ProgBar.DecryptingFile + ' ' + progfilename), Round(320 * rate)) = 0
           then begin
              DecryptError := E_EABORTED;
              Exit;
           end;
        end;
        progresscikl := 0;
      end;
      lastp := 3;
      Application.ProcessMessages;
    end;

  except
    case lastp of
      0: DecryptError := E_EREAD;
      1: DecryptError := E_EWRITE;
    end;
  end;
end;//DecryptAESStreamCBC

{=========================================================================}

function GetSfxSize(SfxFileName: string): longint;
var h_file: integer;
    marker: array[0..10] of byte;
    pos: longint;
    size: longint;
    sizecrc, r_sizecrc, sfxcrc: longword;
    headsize: word;
begin
{$IFDEF DEB} sm('GetSfxSize()'); {$ENDIF}
  size := FSize(ExpandFileName(SfxFileName));
  h_file := FileOpen(ExpandFileName(SfxFileName), fmOpenRead);
  try
     FileSeek(h_file, size - sizeof(size) - sizeof(r_sizecrc), soFromBeginning);
     FileRead(h_file, size, sizeof(size));
     FileRead(h_file, r_sizecrc, sizeof(r_sizecrc));
     //check size parameter is correct
     CRC32Init(sizecrc);
     CRC32Update(sizecrc, @size, sizeof(size));
     sizecrc := CRC32Final(sizecrc);
     if CompareMem(@sizecrc, @r_sizecrc, sizeof(sizecrc)) then begin
        Result := size;
        FileSeek(h_file, size, soFromBeginning);
        FileRead(h_file, sfxcrc, sizeof(sfxcrc));
        FileRead(h_file, marker, sizeof(marker));
        FileRead(h_file, headsize, sizeof(headsize));
        Exit;
     end;
     for pos := 50000 to 200000 do begin
         FileSeek(h_file, pos, soFromBeginning);
         FileRead(h_file, marker, sizeof(marker));
         if CompareMem(@marker, @sfxmarker, sizeof(marker)) then begin
            Result := pos;
            FileSeek(h_file, size, soFromBeginning);
            FileRead(h_file, sfxcrc, sizeof(sfxcrc));
            FileRead(h_file, marker, sizeof(marker));
            FileRead(h_file, headsize, sizeof(headsize));
            Exit;
         end;
     end;
     Result := 0;
     MessageBox(0, PChar(SfxStrings.CorruptedArchive), '', MB_OK);
  finally
     FileClose(h_file);
  end;
end;//GetSfxSize()

{=========================================================================}

Function MakeKeyHash(const salt: arr11; var keyhash: arr4): integer;
var md5cont: TMd5Context;
    md5dig: TMD5Digest;
    dig: array [0..15] of byte;
    i: byte;
    h_file: integer;
    buf: array[1..1024] of byte;
    nr: integer;
begin
  Result := 0;
  //encrypt with keyfile
  if UsingKeyFile then begin
     try
         h_file := FileOpen(ExpandFileName(Settings.current_keyfile), fmOpenRead);
         if h_file = -1 then begin
            MessageBox(0, PChar(Strings.GeneralMessages.ErrorOpeningKeyFile),
                       'AES plugin',
                       MB_OK + MB_ICONERROR);
            Result := E_EOPEN;
            Exit;
         end;
         Md5Init(md5cont);
         repeat
            nr := FileRead(h_file, buf, sizeof(buf));
            Md5UpdateBuffer(md5cont, Addr(buf), nr);
         until (nr = 0) OR (nr = -1);
         Md5UpdateBuffer(md5cont, Addr(salt), sizeof(salt));
         Md5Final(md5dig, md5cont);
     finally
         FileClose(h_file);
     end;
  end else begin
  //encrypt with password
     Md5Init(md5cont);
     Md5UpdateBuffer(md5cont, pwd, Length(pwd^));
     Md5UpdateBuffer(md5cont, Addr(salt), sizeof(salt));
     Md5Final(md5dig, md5cont);
  end;
  //common
  for i := 0 to 15 do
      dig[i] := ord(md5dig[i]);
  keyhash[0] := dig[0] xor dig[4] xor dig[8] xor dig[12];
  keyhash[1] := dig[1] xor dig[5] xor dig[9] xor dig[13];
  keyhash[2] := dig[2] xor dig[6] xor dig[10] xor dig[14];
  keyhash[3] := dig[3] xor dig[7] xor dig[11] xor dig[15];
  ZeroMemory(Addr(md5dig), sizeof(md5dig));
  ZeroMemory(Addr(md5cont), sizeof(md5cont));
end; //MakeKeyHash()

{=========================================================================}

function WipeFile(error: byte; filename: string): integer;
{ wipes Files according to Department of Defense standard DOD 5220.22-M }
var
  DirInfo: TSearchRec;
  D, randomname, oldname: string;
  i,j: byte;
  f: file;
  function WipeFile2(error: byte; DataFs : string; OrigiName: string): integer;
  Const
    NullByte : Byte = 0;
    FFByte   : Byte = $FF;
    F6Byte   : Byte = $F6;
  type buffer=array [1..262144] of byte;
  var
    Pbuffer: ^buffer;
    nw: integer;
    Count: Byte;
    hDataf: integer;
    written: integer;
    size: integer;
    wipeBufsize: integer;
    text: string;
  begin //wipefile2
    text := '';
    case error of
        E_EABORTED   : text := Strings.ProgBar.Aborted    + ' ';
        E_BAD_ARCHIVE: text := Strings.ProgBar.CRCError   + ' ';
        E_EREAD      : text := Strings.ProgBar.ReadError  + ' ';
        E_EWRITE     : text := Strings.ProgBar.WriteError + ' ';
    end;
    try
        GetMem(pBuffer, sizeof(buffer));
    except
        Result := E_NO_MEMORY;
        Exit;
    end;
    size := FSize(datafs);
    Result := 0;
    try //1
        hDataf := CreateFile(PChar(Datafs), GENERIC_WRITE, FILE_SHARE_READ,
                             nil, OPEN_EXISTING, FILE_FLAG_WRITE_THROUGH, 0);

        if (hdataf = -1) then begin
           Result := E_EWRITE;
           Exit;
        end;
    except
        Result := E_EWRITE;
        Exit;
    end; //1
    try //2
       try //3
          for Count := 1 to 3 do begin  //4

//Pass 1,3,5
            case count of
               1: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(1/7)' + U + OrigiName), 0);
               2: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(3/7)' + U + OrigiName), 0);
               3: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(5/7)' + U + OrigiName), 0);
            end;
            wipebufsize := sizeof(buffer);
            FillChar(pBuffer^, wipebufsize, FFByte);
            nw := 0;
            repeat
               written := FileWrite(hDataf, pBuffer^, wipebufsize);
               if written = -1 then begin
                  Result := E_EWRITE;
                  Exit;
               end;
               inc(nw, written);
               if (size - nw) < wipeBufsize then wipebufsize := size-nw;
            until (nw >= size);

            FlushFileBuffers(hDataf);
//Pass 2,4,6
            case count of
                1: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(2/7)' + U + OrigiName), 0);
                2: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(4/7)' + U + OrigiName), 0);
                3: AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(6/7)' + U + OrigiName), 0);
            end;
            FileSeek(hDataf, 0, 0);

            wipebufsize := sizeof(buffer);
            FillChar(pBuffer^, wipebufsize, NULLByte);
            nw := 0;

            repeat
                written := FileWrite(hDataf, pBuffer^, wipebufsize);
                if written = -1 then begin
                   Result := E_EWRITE;
                   Exit;
                end;
                inc(nw, written);
                if (size - nw) < wipebufsize then wipebufsize := size-nw;
            until (nw >= size);
            FlushFileBuffers(hDataf);
            FileSeek(hDataf, 0, 0);
          end; //4
//Pass 7
          AR.ProcessDataProc(PChar(text + Strings.ProgBar.WipingFile + '(7/7)' + U + OrigiName), 0);
          wipebufsize := sizeof(buffer);
          FillChar(pBuffer^, wipebufsize, F6Byte);
          nw := 0;

          repeat
             written := FileWrite(hDataf, pBuffer^, wipebufsize);
             if written = -1 then begin
                Result := E_EWRITE;
                Exit;
             end;
             inc(nw, written);
             if (size - nw) < wipebufsize then wipebufsize := size-nw;
          until (nw >= size);
          FlushFileBuffers(hDataf);
       finally
          CloseHandle(hDataf);
          Freemem(pBuffer);
       end; //3
    except
       Result := E_EWRITE;
       Exit;
    end; //2

  end; //wipefile2

begin{$IFDEF Deb} sm('WipeFile()');{$ENDIF}
//WipeFile

  try
     Result := FindFirst(filename, faAnyFile - faDirectory, DirInfo);
     if Result <> 0 then Exit;
     D := ExtractFilePath(filename);
     FileSetAttr(D + dirinfo.Name, faArchive);
     oldname := D + dirinfo.name;
     Randomize;
     for i := 1 to 20 do begin
         randomname := '';
         for j := 1 to 128 do randomname := randomname + Chars[Random(35)+1];
         RenameFile(oldname, D + randomname);
         oldname := D + randomname;
     end;

     Result := WipeFile2(error, oldname, D + dirinfo.name);
     if Result <> 0 then Exit;
     AssignFile(f, oldname);
     Rewrite(f);
     Close(f);
     Erase(f);
  finally
     Sysutils.FindClose(Dirinfo);
  end;
end;//WipeFile()

{=========================================================================}

procedure GetArchiveVersion(filename: string; var version: byte);
var header: THeader;
    offs: integer;
begin
   if (FSize(filename) = 0) OR CreatingSfxFile then begin  //this is the first file to add
      version := ENCVERSION;
      Exit;
   end;
   Ar.sfx := IsThisSfx(filename);
   if Ar.sfx then
      offs := Ar.AESStartPos
   else
      offs := 0;
   Ar.int := FileOpen(filename, fmOpenRead);
   try
      try
          SetFilePos(Ar.Int, offs);
          FileRead(Ar.Int, header, sizeof(Header));
      except
          On E: Exception do
            MessageBox(0, PChar('GetArchiveVersion() exception' + E.message),
                       'AES plugin - error',
                       MB_OK + MB_ICONERROR);
      end;
   finally
     FileClose(Ar.Int);
   end;
   version := header.fileversion;
   if not (version in [1,2,3,6]) then
      version := 99; //=not supported
end;

{=========================================================================}

procedure TruncateSfxSize(Packedfile: string);
var h: integer;
begin
    h := FileOpen(PackedFile, fmOpenReadWrite);
    FileSeek(h, -8, soFromEnd);
    SetEndOfFile(h);
    FileClose(h);
end;

{=========================================================================}

procedure SimpleErase(fn: string);
var h_file: integer;
begin
   h_file := FileOpen(fn, fmOpenReadWrite);
   try
     SetEndOfFile(h_file);
   finally
     FileClose(h_file);
   end;
   DeleteFile(PChar(fn));
end;

{=========================================================================}

initialization
  begin
    //  default inipath:
    //  this will be overwritten if PackSetDefaultParams() is supported
    FillChar(dllpath, sizeof(dllpath), #0);
    GetModuleFileName(hInstance, dllpath, sizeof(dllpath));
    Settings.inipath := ExtractFilePath(dllpath) + 'aes.ini';
    KeyEntered := FALSE;
    Application.HintHidePause := 5000;
    Application.HintPause := 2000;
    LangFileList := TStringList.Create;

    AESKey := VirtualAlloc(nil,
                           sizeof(AESKey^),
                           MEM_COMMIT,
                           PAGE_READWRITE);
    VirtualLock(AESkey, sizeof(AESKey^));
    pwd := VirtualAlloc(nil,
                        sizeof(pwd^),
                        MEM_COMMIT,
                        PAGE_READWRITE);
    VirtualLock(pwd, sizeof(pwd^));
    newpwd := VirtualAlloc(nil,
                           sizeof(newpwd^),
                           MEM_COMMIT,
                           PAGE_READWRITE);
    VirtualLock(newpwd, sizeof(newpwd^));
  end;

finalization
  LangFileList.Free;
  VirtualFree(AESKey, 0, MEM_RELEASE);
  VirtualFree(pwd, 0, MEM_RELEASE);
  VirtualFree(newpwd, 0, MEM_RELEASE);
end.
