unit language;

interface
uses kol, err, windows, misc;
type TSfxStrings = record
    Password,
    KeyFile,
    DecryptTo,
    Browse,
    Exit,
    ErrorOpeningKeyfile,
    ReadError,
    Error,
    OverWriteConfirm,
    CorruptedFile,
    WrongPassword,
    SelectDestPath,
    DestPathIsWriteProtected,
    EnterValidPath,
    AbortConfirmText,
    ConfirmCaption,
    ErrorDuringDecompression,
    CorruptedArchive,
    NotEnoughSpace,
    FailedToCreateDir,
    IncompletedFile,
    UnknownError,
    KeyFileNotFound,
    Warning,
    AllFiles,
    Yes,
    No,
    Cancel,
    Skip,
    SkipAll,
    OverwriteAll,
    Rename,
    AutoRename,
    EnterNewFilename
    : string;
    end;
type
   TCofS = record
      ButtonWidth,
      ButtonHeight,
      OvAllWW,
      SkipAllWW,
      AutoRenWW,
      OvAllLabelAlign,
      SkipAllLabelAlign,
      AutoRenLabelAlign
      :byte
   end;
var SfxStrings: TSfxStrings;
    cofs: TCofs;
procedure LoadLanguage;

implementation

{==============================================================================}

procedure LoadLanguage;
var h: integer;
    crc: longword; //ez kell
    marker: array [0..10] of byte;
    sfxver: byte;
    numread: longint;
    headsize: word;
    function GetString: string;
    var i: byte;
    p: array [0..MAX_PATH] of char;
    begin
        FileRead(h, i, sizeof(i));
        FileRead(h, p, i);
        Result := String(p);
        SetLength(Result, i);
        inc(numread, i + 1);
    end;
    function GetByte: byte;
    begin
        FileRead(h, Result, 1);
        inc(numread);
    end;
begin
    try
        h := CreateFile(PChar(Paramstr(0)),
                        GENERIC_READ,
                        FILE_SHARE_READ,
                        NIL,
                        OPEN_EXISTING,
                        FILE_ATTRIBUTE_NORMAL,
                        0);
        try
            FileSeek(h, sfxsize + 4 , spbegin);
            FileRead(h, marker, sizeof(marker));
            FileRead(h, headsize, sizeof(headsize));
            FileRead(h, sfxver, sizeof(sfxver));
            SfxStrings.Password := GetString;
            SfxStrings.KeyFile := GetString;
            SfxStrings.DecryptTo := GetString;
            SfxStrings.Browse := GetString;
            SfxStrings.Exit := GetString;
            SfxStrings.ErrorOpeningKeyfile := GetString;
            SfxStrings.ReadError := GetString;
            SfxStrings.Error := GetString;
            SfxStrings.OverWriteConfirm := GetString;
            SfxStrings.CorruptedFile := GetString;
            SfxStrings.WrongPassword := GetString;
            SfxStrings.SelectDestPath := GetString;
            SfxStrings.DestPathIsWriteProtected := GetString;
            SfxStrings.EnterValidPath := GetString;
            SfxStrings.AbortConfirmText := GetString;
            SfxStrings.ConfirmCaption := GetString;
            SfxStrings.ErrorDuringDecompression := GetString;
            SfxStrings.CorruptedArchive := GetString;
            SfxStrings.NotEnoughSpace := GetString;
            SfxStrings.FailedToCreateDir := GetString;
            SfxStrings.IncompletedFile := GetString;
            SfxStrings.UnknownError := GetString;
            SfxStrings.KeyFileNotFound := GetString;
            SfxStrings.Warning := GetString;
            SfxStrings.AllFiles := GetString;

            SfxStrings.Yes := GetString;
            SfxStrings.No := GetString;
            SfxStrings.Cancel := GetString;
            SfxStrings.Skip := GetString;
            SfxStrings.SkipAll := GetString;
            SfxStrings.OverwriteAll := GetString;
            SfxStrings.Rename := GetString;
            SfxStrings.AutoRename := GetString;
            SfxStrings.EnterNewFilename := GetString;

            cofs.ButtonWidth := GetByte;
            cofs.ButtonHeight := Getbyte;
            cofs.OvAllWW := GetByte;
            cofs.SkipAllWW := GetByte;
            cofs.AutoRenWW := GetByte;
            cofs.OvAllLabelAlign := GetByte;
            cofs.SkipAllLabelAlign := GetByte;
            cofs.AutoRenLabelAlign := GetByte;

            AESBegin := sfxsize + sizeof(crc) + sizeof(marker) + sizeof(sfxver) + numread;
        finally
            CloseHandle(h);
        end;
     except
        On E: Exception do
           MessageBox(0, PChar('Error while loading language strings!' + U +
                      'LoadLanguage()' + U +
                      itos(E.Errorcode)),
                      'Error',
                      MB_OK + MB_ICONERROR);
        end;
end;


end.
