unit misc;
{$N+,P+,S-,G+}


{$C MOVEABLE PRELOAD PERMANENT}

interface

uses windows, kolaes, kol, shellapi, messages;
type
  arr11 = array [0..10] of byte;
  arr4 = array [0..3] of byte;//int
  arr4ch = array [1..4] of char;
  TStrBuf = array [0..MAX_PATH] of char;
  TSysCharSet= Set of char;
  LongRec = packed record
      Lo, Hi: Word;
  end;
const
  ENCVERSION = 6;
  U = #10#13;
  CLNONE = 3;
  CLFASTEST = 2;
  CLDEF = 1;
  CLMAX = 0;
  LOWSPACE = 'LOWSPACE';
  WRITE_ERROR = 'WRITE_ERROR';

  VERSIONTEXT = '0.1';
  MAGIC = 'AES' + #0;
  OV_NOTDEF  = 0;
  OV_YES     = 1;
  OV_OVALL   = 2;
  OV_SKIP    = 3;
  OV_CANCEL  = 4;
  OV_NO      = 5;
  OV_SKIPALL = 6;
  OV_REN     = 7;
  OV_AUTOREN = 8;
  E_WRITE    = 9;
  E_READ     = 10;
  E_NO_MEMORY = 11;

  STRM_ERROR = DWord (-1);
  UNKNOWN_FORMAT = 11;
type
   THeader = Record
       magic: arr4ch;
       crc: longword;
       reserved: array [1..3] of byte;
       fname_lastblocksize: byte;
       complevel: byte;
       fileattr: integer;
       filetime: integer;
       unpackedsize: cardinal;
       packedsize: cardinal;
       fileversion: byte;
       keysize: byte;
       salt: arr11;
       keyhash: arr4;
       lastblocksize: byte;
       fnamelen: word;
  end;
type
  pwdarr = array [0..127] of char;
var
  AESBegin: integer; //pos in sfx.exe, from this pos begin the encrypted files
  AESKey: ^TAESKey128;
  pwd: ^pwdarr;
  Working: boolean = FALSE;
  UsingKeyFile: boolean;
  OvAnswer: byte;
  SfxSize: longint;
  LeadBytes: set of Char = [];
  chars: array [1..36] of char=('a','b','c','d','e','f','g','h','i','j','k',
                                'l','m','n','o','p','q','r','s','t','u','v',
                                'w','x','y','z','0','1','2','3','4','5','6',
                                '7','8','9');
  function  CheckMagic(magic_0: arr4ch): byte;
  procedure sm(s: string); // = showmessage()
  function  CreateTempName(destination: string; const PackedSize, UnpackedSize: integer): string;
  function  itos(i: integer): string;// = inttostr()
  function  GetFilePos(h: integer): cardinal;
  function  SetFilePos(h: integer; newpos: integer): longword; //from beginning
  procedure SetDateAndAttr(filename: string; filetime, fileattr: integer);
  function  WrapText(const Line, BreakStr: string; BreakChars: TSysCharSet;
                     MaxCol: Integer): string;
  function WipeFile(filename: string): integer;
implementation

procedure sm(s: string);
begin
  ShowMessage(s);
end;

{=========================================================================}

function itos(i: integer):string;
begin
  Result := Int2str(i);
end;

{=========================================================================}

function CreateTempName(destination: string;
                        const PackedSize, UnpackedSize: integer): string;
//returns a random 8.1 filename in temporary dir
var TempDir : array [0..MAX_PATH] of Char;
    temp: string;
    i: word;
    fname: string;
    f: file;
    TempFreeSpace, DestFreeSpace: int64;
begin
    Destination := FileFullPath(Destination);
    GetTempPath(MAX_PATH, @TempDir);
    temp := String(TempDir);
    fname := temp;
    TempFreeSpace := DiskFreeSpace(temp[1] + ':\');
    DestFreeSpace := DiskFreeSpace(String(Destination[1] + ':\'));
    if not DirectoryExists(temp) then TempFreeSpace := Int2Int64(0);
    if Cmp64(DestFreeSpace, Int2Int64(UnpackedSize)) < 0 then begin
       Result := LOWSPACE;
       Exit;
    end;
    if upcase(Destination[1]) = upcase(Temp[1]) then begin
       if Cmp64(Add64(Int2Int64(Packedsize), Int2Int64(Unpackedsize)), DestFreeSpace) <= 0 then
          fname := ExtractFilePath(Destination)
       else begin
          Result := LOWSPACE;
          Exit;
       end;
    end;
    If Cmp64(Int2Int64(PackedSize), TempFreeSpace) <= 0 then begin
       fname := ExtractFilePath(Temp);
    end else begin
       if Cmp64(Add64(Int2Int64(PackedSize), Int2Int64(UnpackedSize)), DestFreeSpace) <= 0 then
          fname := ExtractFilePath(Destination)
       else begin
          Result := LOWSPACE;
          Exit;
       end;
    end;
    if fname[Length(fname)] <> '\' then
       fname := fname + '\';
    Randomize;
    {$I-}
    repeat
        for i := 1 to 8 do fname := fname + chars[Random(35) + 1];
        fname := fname + '.';
        i := Random(900);
        fname := fname + itos(i);
        AssignFile(f, fname);
        filemode := 2;
        Reset(f, 1);
        CloseFile(f);
    until (ioresult <> 0);
    Rewrite(f, 1);
    if ioresult <> 0 then begin
       Result := WRITE_ERROR;
       Exit;
    end;
    CloseFile(f);
    DeleteFile(PChar(fname));
    {$I+}
    Result := fname;
end; //CreateTempName

{=========================================================================}

function GetFilePos(h: integer): longword;
begin
   Result := SetFilePointer(h, 0, nil, FILE_CURRENT);
end;

{=========================================================================}

function SetFilePos(h: integer; newpos: integer): longword;//from beginning
begin
  Result := SetFilePointer(h, newpos, nil, FILE_BEGIN);
end;

{=========================================================================}

procedure SetDateAndAttr(filename: string; filetime, fileattr: integer);
var
  LocalFileTime, FileTime2: TFileTime;
  handle: integer;
begin
    SetFileAttributes(PChar(FileName), FILE_ATTRIBUTE_NORMAL);
    handle := CreateFile(PChar(filename), GENERIC_WRITE,
                         FILE_SHARE_READ,
                         NIL,
                         OPEN_EXISTING,
                         fileattr,
                         0);
    if handle = INVALID_HANDLE_VALUE then begin
       MessageBox(0, PChar(SysErrorMessage(GetLastError)),
                  'SetDateAndAttr()', MB_ICONERROR);
       Exit;
    end;
    DosDateTimeToFileTime(LongRec(filetime).Hi, LongRec(FileTime).Lo, LocalFileTime);
    LocalFileTimeToFileTime(LocalFileTime, FileTime2);
    SetFileTime(handle, nil, nil, @FileTime2);
    SetFileAttributes(PChar(FileName), fileattr);
end;

{=========================================================================}

function CheckMagic(magic_0: arr4ch): byte;
var magic_1: arr4ch;
begin
  Move(MAGIC, magic_1, sizeof(magic_1));
  if not CompareMem(@magic_0, @magic_1, 4) then begin
     Result := UNKNOWN_FORMAT;
     Exit;
  end;
  Result := 0;
end;

{=========================================================================}

function WrapText(const Line, BreakStr: string; BreakChars: TSysCharSet;
  MaxCol: Integer): string;
const
  QuoteChars = ['''', '"'];
var
  Col, Pos: Integer;
  LinePos, LineLen: Integer;
  BreakLen, BreakPos: Integer;
  QuoteChar, CurChar: Char;
  ExistingBreak: Boolean;
  function CompareText(const S1, S2: string): Integer; assembler;
  asm
          PUSH    ESI
          PUSH    EDI
          PUSH    EBX
          MOV     ESI,EAX
          MOV     EDI,EDX
          OR      EAX,EAX
          JE      @@0
          MOV     EAX,[EAX-4]
  @@0:    OR      EDX,EDX
          JE      @@1
          MOV     EDX,[EDX-4]
  @@1:    MOV     ECX,EAX
          CMP     ECX,EDX
          JBE     @@2
          MOV     ECX,EDX
  @@2:    CMP     ECX,ECX
  @@3:    REPE    CMPSB
          JE      @@6
          MOV     BL,BYTE PTR [ESI-1]
          CMP     BL,'a'
          JB      @@4
          CMP     BL,'z'
          JA      @@4
          SUB     BL,20H
  @@4:    MOV     BH,BYTE PTR [EDI-1]
          CMP     BH,'a'
          JB      @@5
          CMP     BH,'z'
          JA      @@5
          SUB     BH,20H
  @@5:    CMP     BL,BH
          JE      @@3
          MOVZX   EAX,BL
          MOVZX   EDX,BH
  @@6:    SUB     EAX,EDX
          POP     EBX
          POP     EDI
          POP     ESI
  end;


begin
  Col := 1;
  Pos := 1;
  LinePos := 1;
  BreakPos := 0;
  QuoteChar := ' ';
  ExistingBreak := False;
  LineLen := Length(Line);
  BreakLen := Length(BreakStr);
  Result := '';
  while Pos <= LineLen do
  begin
    CurChar := Line[Pos];
    if CurChar in LeadBytes then
    begin
      Inc(Pos);
      Inc(Col);
    end else
      if CurChar = BreakStr[1] then
      begin
        if QuoteChar = ' ' then
        begin
          ExistingBreak := CompareText(BreakStr, Copy(Line, Pos, BreakLen)) = 0;
          if ExistingBreak then
          begin
            Inc(Pos, BreakLen-1);
            BreakPos := Pos;
          end;
        end
      end
      else if CurChar in BreakChars then
      begin
        if QuoteChar = ' ' then BreakPos := Pos
      end
      else if CurChar in QuoteChars then
        if CurChar = QuoteChar then
          QuoteChar := ' '
        else if QuoteChar = ' ' then
          QuoteChar := CurChar;
    Inc(Pos);
    Inc(Col);
    if not (QuoteChar in QuoteChars) and (ExistingBreak or
      ((Col > MaxCol) and (BreakPos > LinePos))) then
    begin
      Col := Pos - BreakPos;
      Result := Result + Copy(Line, LinePos, BreakPos - LinePos + 1);
      if not (CurChar in QuoteChars) then
        while (Pos <= LineLen) and (Line[Pos] in BreakChars + [#13, #10]) do Inc(Pos);
      if not ExistingBreak and (Pos < LineLen) then
        Result := Result + BreakStr;
      Inc(BreakPos);
      LinePos := BreakPos;
      ExistingBreak := False;
    end;
  end;
  Result := Result + Copy(Line, LinePos, MaxInt);
end;

{=========================================================================}
function FSize(fn: string): integer;
//returns the size of fn file

var dirinfo: WIN32_FIND_DATA;
    h: integer;
    FindHandle: integer;
begin
   fn := FileFullPath(fn);
   Findhandle := FindFirstFile(PChar(fn), dirinfo);
   try
     if Findhandle = INVALID_HANDLE_VALUE then //error
        Result := -1
     else begin
        Result := Dirinfo.nFileSizeLow;
        try
          try
            h := CreateFile(PChar(fn),
                            GENERIC_READ,
                            FILE_SHARE_READ,
                            NIL,
                            OPEN_EXISTING,
                            FILE_ATTRIBUTE_NORMAL,
                            0);
          except
            Result := -1;
          end;
        finally
          CloseHandle(h);
        end;
     end;
   finally
     FindClose(FindHandle);
   end;
end;

{=========================================================================}

function WipeFile(filename: string): integer;
{ wipes Files according to Department of Defense standard DOD 5220.22-M }
type
 TFileName = type string;
 TSearchRec = record
    Time: Integer;
    Size: Integer;
    Attr: Integer;
    Name: TFileName;
    ExcludeAttr: Integer;
    FindHandle: THandle;
    FindData: TWin32FindData;
  end;

var DirInfo: WIN32_FIND_DATA;
  D: string;
  Findhandle: integer;
  function WipeFile2(error: byte; DataFs : string): integer;
  Const
    NullByte : Byte = 0;
    FFByte   : Byte = $FF;
    F6Byte   : Byte = $F6;
  type buffer=array [1..262144] of byte;
  var
    Pbuffer: ^buffer;
    nw: integer;
    Count: Byte;
    hDataf: integer;
    written: integer;
    size: integer;
    wipeBufsize: integer;
    text: string;
  begin //wipefile2
    text := '';
    try
        GetMem(pBuffer, sizeof(buffer));
    except
        Result := E_NO_MEMORY;
        Exit;
    end;
    size := FSize(datafs);
    Result := 0;
    try //1
        hDataf := CreateFile(PChar(Datafs), GENERIC_WRITE, FILE_SHARE_READ,
                             nil, OPEN_EXISTING, FILE_FLAG_WRITE_THROUGH, 0);

        if (hdataf = -1) then begin
           Result := E_WRITE;
           Exit;
        end;
    except
        Result := E_WRITE;
        Exit;
    end; //1
    try //2
       try //3
          for Count := 1 to 3 do begin  //4
//Pass 1,3,5
            wipebufsize := sizeof(buffer);
            FillChar(pBuffer^, wipebufsize, FFByte);
            nw := 0;
            repeat
               written := FileWrite(hDataf, pBuffer^, wipebufsize);
               if written = -1 then begin
                  Result := E_WRITE;
                  Exit;
               end;
               inc(nw, written);
               if (size - nw) < wipeBufsize then wipebufsize := size-nw;
            until (nw >= size);

            FlushFileBuffers(hDataf);
//Pass 2,4,6
            FileSeek(hDataf, 0, spBegin);

            wipebufsize := sizeof(buffer);
            FillChar(pBuffer^, wipebufsize, NULLByte);
            nw := 0;

            repeat
                written := FileWrite(hDataf, pBuffer^, wipebufsize);
                if written = -1 then begin
                   Result := E_WRITE;
                   Exit;
                end;
                inc(nw, written);
                if (size - nw) < wipebufsize then wipebufsize := size-nw;
            until (nw >= size);
            FlushFileBuffers(hDataf);
            FileSeek(hDataf, 0, spBegin);
          end; //4
//Pass 7
          wipebufsize := sizeof(buffer);
          FillChar(pBuffer^, wipebufsize, F6Byte);
          nw := 0;

          repeat
             written := FileWrite(hDataf, pBuffer^, wipebufsize);
             if written = -1 then begin
                Result := E_WRITE;
                Exit;
             end;
             inc(nw, written);
             if (size - nw) < wipebufsize then wipebufsize := size-nw;
          until (nw >= size);
          FlushFileBuffers(hDataf);
       finally
          CloseHandle(hDataf);
          Freemem(pBuffer);
       end; //3
    except
       Result := E_WRITE;
       Exit;
    end; //2

  end; //wipefile2

  Procedure ClearDirEntry(d:string);
  var datafile: file;
      newname: string;
  begin
    {$I-}
    AssignFile(datafile, d);
    Reset(DataFile);
    Truncate(DataFile);
    CloseFile(DataFile);
    newname := CreateTempName(' ', 0, 0);
    Rename(DataFile, newname);
    DeleteFile(PChar(newname));
    {$I+}
  end;
begin{$IFDEF Deb} sm('WipeFile()');{$ENDIF}
//WipeFile
  try
     FindHandle := FindFirstFile(PChar(filename), DirInfo);
     if FindHandle = INVALID_HANDLE_VALUE then begin Result := FindHandle; Exit; end;
     D := ExtractFilePath(filename);
     SetFileAttributes(PChar(D + dirinfo.cFileName), FILE_ATTRIBUTE_ARCHIVE);
     Result := WipeFile2(error, D + Dirinfo.cFileName);
     if Result <> 0 then Exit;
     try
       ClearDirEntry(D + Dirinfo.cFileName);
     except
     end;
     DeleteFile(PChar(D + Dirinfo.cFileName));
     while (FindNextFile(FindHandle, DirInfo)) do begin
        Result := WipeFile2(error, D + Dirinfo.cFileName);
        if Result <> 0 then Exit;
        ClearDirEntry(D + Dirinfo.cFileName);
        DeleteFile(PChar(D + Dirinfo.cFileName));
     end;
  finally
     FindClose(FindHandle);
  end;
end;//WipeFile()

end.
