unit decformu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, Menus, misc, configdialog,
  ExtCtrls, language;

type
  TDecForm = class(TForm)
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label2: TLabel;
    Label1: TLabel;
    Button1: TButton;
    PopupMenu1: TPopupMenu;
    Hidepwd: TMenuItem;
    SkipCRC: TMenuItem;
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    PwdChangeM: TMenuItem;
    Usekeyfile1: TMenuItem;
    Edit2: TEdit;
    Button2: TButton;
    OpenDialog1: TOpenDialog;

    procedure Button1Click(Sender: TObject);
    procedure SkipCRCClick(Sender: TObject);
    procedure HidepwdClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PwdChangeMClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Usekeyfile1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var elapsed: byte = 0;
    DecForm: TDecForm;

implementation

uses warningf, pwdchangeu;

{$R *.DFM}

{=========================================================================}

procedure TDecForm.Button1Click(Sender: TObject);
begin
   Popupmenu1.Popup(Button1.ClientOrigin.x, Button1.ClientOrigin.y + Button1.Height);
end;

{=========================================================================}

procedure TDecForm.SkipCRCClick(Sender: TObject);
var  WarningForm: TWarningForm;
begin
  if SkipCRC.Checked then begin
     SkipCRC.Checked := FALSE;
     Settings.SkipCRCCheck := FALSE;
  end else begin
     LoadSettings;
     if Settings.ShowWarning then begin
        WarningForm := TWarningForm.Create(nil);
        try
          WarningForm.ShowModal;
          if WarningForm.CheckBox1.Checked then begin
             Settings.ShowWarning := FALSE;
             SaveSettings;
          end;
        finally
          WarningForm.Free;
        end;
     end;
     SkipCRC.Checked := TRUE;
     Settings.SkipCRCCheck := TRUE;
  end;
end;

{=========================================================================}

procedure TDecForm.HidepwdClick(Sender: TObject);
begin
  if Edit1.PasswordChar = '*' then begin
     Edit1.PasswordChar := #0;
     PopupMenu1.Items[0].Checked := FALSE;
  end else begin
     Edit1.PasswordChar := '*';
     PopupMenu1.Items[0].Checked := TRUE;
  end;
  Edit1.SetFocus;
  Edit1.SelStart := Length(Edit1.Text);
end;

{=========================================================================}

procedure TDecForm.FormShow(Sender: TObject);
begin
  LoadSettings;
  Button2.Visible := TRUE;
  UseKeyFile1Click(Sender);
  Button2.Caption := Strings.GeneralCaptions.Open;
  OpenDialog1.Filter := Strings.GeneralCaptions.AllFiles + '|*.*';
  Edit1.Clear;
  Edit2.Clear;
  OpenDialog1.FileName := '';
  Edit1.SetFocus;
  if not HidePwd.Checked then HidePwd.Click;
  Settings.SkipCRCCheck := FALSE;
  Label2.Caption := Strings.DecFormStrings.EncryptedFile;
  Label1.Caption := Strings.DecFormStrings.TypePwd2Decrypt;
  BitBtn1.Caption := Strings.GeneralCaptions.OK;
  BitBtn2.Caption := Strings.GeneralCaptions.Cancel;
  Button1.Caption := Strings.GeneralCaptions.Options;
  HidePwd.Caption := Strings.GeneralCaptions.OptionsHidePwd;
  SkipCRC.Caption := Strings.DecFormStrings.OptionsSkipCRCCheck;
  PwdChangeM.Caption := Strings.DecFormStrings.OptionsPwdChange;
  PwdChangeM.Checked := FALSE;
  Update;
end;

{=========================================================================}

procedure TDecForm.Timer1Timer(Sender: TObject);
var t: integer; //in sec
begin
  case Settings.destkeytime of
     0: t := 0;
     1: t := 10;
     2: t := 30;
     3: t := 60;
     4: t := 120;
     5: t := 300;
     else t := 0;
  end;
  if KeyEntered then begin
     inc(elapsed);
     if elapsed >= t then begin
        ZeroMemory(pwd, sizeof(pwd^));
        Edit1.Clear;   //ZeroMemory() doesn't work here
        KeyEntered := FALSE;      //need to re-enter the password
        elapsed := 0;
        Timer1.Enabled := FALSE;
     end;
  end;
end;

{=========================================================================}

procedure TDecForm.PwdChangeMClick(Sender: TObject);
label showagain;
begin
  with PwdChange do begin
       showagain:
       if ShowModal = mrCancel then Exit;
       if NewPwdEdit.Text <> NewPwdEdit2.Text then begin
          NewPwdEdit.Clear;
          NewPwdEdit2.Clear;
          MessageBox(0, PChar(Strings.GeneralMessages.VerificationFailed),
                        'AES plugin',
                        MB_OK + MB_ICONERROR);
          goto showagain;
       end; //if
       PwdChangeM.Checked := TRUE; //kell, openarchive-ban vizsglod
       FillChar(pwd^, sizeof(pwd^), #0);
       StrPCopy(pwd^, OldPwdEdit.Text);
       OldPwdEdit.Clear;
       StrPCopy(newpwd^, NewPwdEdit.Text);
       NewPwdEdit.Clear;
       NewPwdEdit2.Clear;
    end; //with
  modalResult := mrOK;
end;

{=========================================================================}

procedure TDecForm.Button2Click(Sender: TObject);
begin
  OpenDialog1.Title := Strings.DecFormStrings.OpenDialogTitle;
  if OpenDialog1.Execute then begin
     Settings.current_keyfile := OpenDialog1.FileName;
     Edit2.Text := OpenDialog1.FileName;
  end;
end;

{=========================================================================}

procedure TDecForm.Usekeyfile1Click(Sender: TObject);
begin
  UsingKeyFile := not Button2.Visible;
  if UsingKeyFile then begin
     UseKeyfile1.Caption := Strings.DecFormStrings.DecryptWithPassword;
     Label1.Caption := Strings.EncFormStrings.SelectKeyFile;
     Button2.Visible := TRUE;
     Edit1.Visible := FALSE;
     Edit2.Visible := TRUE;
     Edit2.Top := Edit1.Top;
     if (Edit2.Text = '') AND (Settings.default_keyfile <> '') then
         Edit2.Text := Settings.default_keyfile;
  end else begin
     UseKeyfile1.Caption := Strings.DecFormStrings.DecryptWithKeyFile;
     Label1.Caption := Strings.EncFormStrings.TypePwd;
     Button2.Visible := FALSE;
     Edit1.Visible := TRUE;
     Edit2.Visible := FALSE;
  end;

end;

{=========================================================================}

procedure TDecForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ord(key) = vk_F2 then Usekeyfile1Click(Sender);
  if UsingKeyFile AND (ord(key) = vk_F3) then Button2Click(Sender);
end;

{=========================================================================}

initialization
  DecForm := TDecForm.Create(nil);
  PwdChange := TPwdChange.Create(nil);

finalization
  DecForm.Free;
  PwdChange.Free;
end.
