unit language;

interface
uses inifiles, sysutils;
type TProgBarStrings = record
      Aborted,
      CRCError,
      ReadError,
      WriteError,
      WipingFile,
      EncryptingFile,
      DecryptingFile,
      DecompressingFile,
      CopyingFile,
      CompressingFile,
      SkippingFile
      : string;
      end;
type TEncFormStrings = record
       EncryptCaption,
       TypePwd,
       RetypePwd,
       OptionsWipeOnly,
       CompLevel,
       WipeOriginal,
       EncryptWithPassword,
       EncryptWithKeyFile,
       CreateSfxArchive,
       ApplyTheSameKeyForAllFile,
       SelectKeyFile,
       OpenDialogTitle
       : string;
       end;
type TDecFormStrings = record
       EncryptedFile,
       TypePwd2Decrypt,
       OptionsSkipCRCCheck,
       OptionsPwdChange,
       DeleteCaption,
       DecryptWithPassword,
       DecryptWithKeyFile,
       OpenDialogTitle
       : string;
       end;
type TGeneralCaptions = record
       OpenCaption,
       Options,
       OptionsHidePwd,
       OK,
       Cancel,
       CompLevelMax,
       CompLevelNormal,
       CompLevelFast,
       CompLevelNone,
       SkipCRCWarning,
       DontShowAgain,
       Warning,
       Open,
       AllFiles,
       Confirm,
       Error,
       TypeNewFileName,
       DontCompressTheseFileTypes,
       TypeAnExtension,
       Browse
       : string;
     end;
type TConfig_Settings = record
        Settings,
        PwdPolicy,
        MinLength,
        PwdMustContain,
        Letters,
        Numbers,
        SpecialChars,
        CompressionLevel,
        WipeOriginalAfterEncrypt,
        WipeTempFiles
        : string;
     end;
type TConfig_Misc = record
        Misc,
        RandomPwdGenerator,
        Length,
        LowerCaseLetters,
        UpperCaseLetters,
        Numbers,
        AnyASCIIChars,
        Generate,
        DestroyKeyInfo,
        Instantly,
        Sec,
        Min,
        DefaultKeyFile
         : string;
     end;
type TConfig_Misc3 = record
       AlwaysCreateSfx,
       WhereToSaveSettings,
       DefIniFile,
       UserDefined,
       CloseToWcx,
       SelectDirWhereYouWantToSaveSettings,
       WriteError
       : string;
     end;
type TConfig_Uninstall = record
        UninstallGroupBoxCaption,
        Settings,
        LanguageFiles,
        Uninstall,
        UninstallConfirm,
        Finished,
        AesWcxDelete,
        TCRestart
        :string;
  end;
type TConfig_Lang = record
        LanguageCaption,
        SelectYourLanguage
        : string;
     end;
type TConfig_About = record
        AboutCaption: string;
     end;
type TGeneralMessages = record
        WipeWarning,
        VerificationFailed,
        KeyInfoDestroyed,
        TypePwdAgain,
        MissingSpecial,
        MissingNumber,
        MissingAlpha,
        TooShort,
        Suit,
        WrongPwd,
        YouCantModify,
        InvalidNumber,
        MaxPwdLength,
        InvalidCharInExtension,
        InvalidKeyFileSize,
        ErrorOpeningKeyFile,
        DontEncryptYourKeyFile,
        ConfirmOverwrite,
        CouldntDeleteFile,
        ThisArchiveVersionDoesntSupportMultipleFiles,
        OverwriteConfirmationInArchive
        : string;
     end;
type TPwdChangeStrings = record
        CRCTest,
        PwdChangeCaption,
        TypeOldPwd,
        TypeNewPwd,
        RetypeNewPwd,
        Reencrypting,
        ReencryptedSuccessfully
        : string;
     end;
type THotkeyStrings = record
        Hotkeys,
        EncryptWith,
        CreateSfx,
        CompLevelChange,
        OpenKeyfile
        : string;
     end;
type TTStrings = record
        EncFormStrings: TEncFormStrings;
        DecFormStrings: TDecFormStrings;
        ProgBar: TProgBarStrings;
        Config_Settings: TConfig_Settings;
        Config_Misc: TConfig_Misc;
        Config_Uninstall: TConfig_Uninstall;
        Config_About: TConfig_About;
        Config_Misc3: TConfig_Misc3;
        GeneralCaptions: TGeneralCaptions;
        GeneralMessages: TGeneralMessages;
        PwdChangeStrings: TPwdChangeStrings;
        Lang: TConfig_Lang;
        HotkeyStr: THotkeyStrings;
        end;
type TSfxStrings = record
        Password,
        Keyfile,
        DecryptTo,
        Browse,
        Exit,
        ErrorOpeningKeyfile,
        ReadError,
        Error,
        OverWriteConfirm,
        CorruptedFile,
        WrongPassword,
        SelectDestPath,
        DestPathIsWriteProtected,
        EnterValidPath,
        AbortConfirmText,
        ConfirmCaption,
        ErrorDuringDecompression,
        CorruptedArchive,
        NotEnoughSpace,
        FailedToCreateDir,
        IncompletedFile,
        UnknownError,
        KeyFileNotFound,
        Warning,
        AllFiles,
        Yes,
        No,
        Cancel,
        Skip,
        SkipAll,
        OverwriteAll,
        Rename,
        AutoRename,
        EnterNewFilename,

        ButtonWidth,
        ButtonHeight,
        OvAllWW,
        SkipAllWW,
        AutoRenWW,
        SkipAllLabelAlign,
        OvAllLabelAlign,
        AutoRenLabelAlign

        : string;
 end;
{=========================================================================}
procedure LoadLanguage(filename: string);

var Strings: TTStrings;
    SfxStrings: TSfxStrings;
implementation

{=========================================================================}
procedure LoadDefLanguage;
begin
    Strings.EncFormStrings.EncryptCaption := 'encrypt';
    Strings.EncFormStrings.TypePwd := 'Type encrypting password:';
    Strings.EncFormStrings.RetypePwd := 'Retype encrypting password:';
    Strings.EncFormStrings.OptionsWipeOnly := 'Wipe only';
    Strings.EncFormStrings.Complevel := 'comp. level:';
    Strings.EncFormStrings.WipeOriginal := 'WIPE original';
    Strings.EncFormStrings.EncryptWithPassword := 'Encrypt with password';
    Strings.EncFormStrings.EncryptWithKeyFile := 'Encrypt with keyfile';
    Strings.EncFormStrings.CreateSfxArchive := 'Create self-decrypting archive';
    Strings.EncFormStrings.ApplyTheSameKeyForAllFile := 'Apply the same key for all file';


    Strings.EncFormStrings.SelectKeyFile := 'Select keyfile';
    Strings.EncFormStrings.OpenDialogTitle := 'Select keyfile what you want to encrypt with';
  //decform
    Strings.DecFormStrings.EncryptedFile := 'File is encrypted.';
    Strings.DecFormStrings.TypePwd2Decrypt := 'Type password to decrypt:';
    Strings.DecFormStrings.OptionsSkipCRCCheck := 'Skip CRC check';
    Strings.DecFormStrings.OptionsPwdChange := 'Change password';
    Strings.DecFormStrings.DeleteCaption := 'delete';
    Strings.DecFormStrings.OpenDialogTitle := 'Select keyfile what you want to decrypt with';
    Strings.DecFormStrings.DecryptWithPassword := 'Decrypt with password';
    Strings.DecFormStrings.DecryptWithKeyFile := 'Decrypt with keyfile';
  //generalcaptions
    Strings.GeneralCaptions.OpenCaption := 'open';
    Strings.GeneralCaptions.Ok := 'OK';
    Strings.GeneralCaptions.Cancel := 'Cancel';
    Strings.GeneralCaptions.Options := '&Options';
    Strings.GeneralCaptions.OptionsHidePwd := 'Hide password';
    Strings.GeneralCaptions.CompLevelMax := 'max';
    Strings.GeneralCaptions.CompLevelNormal := 'normal';
    Strings.GeneralCaptions.CompLevelFast := 'fast';
    Strings.GeneralCaptions.CompLevelNone := 'none';
    Strings.GeneralCaptions.DontShowAgain := 'Don''t show again';
    Strings.GeneralCaptions.SkipCRCWarning := WrapText('With this option you can usually decrypt damaged files partially in some cases but maybe TC will freeze.', 50);
    Strings.GeneralCaptions.DontShowAgain := 'Don''t show again.';
    Strings.GeneralCaptions.Warning := 'Warning';
    Strings.GeneralCaptions.DontCompressTheseFileTypes := 'Don''t compress these file types';
    Strings.GeneralCaptions.TypeAnExtension := 'Type an extension (e.g.: ZIP)';
    Strings.GeneralCaptions.Open := 'Open...';
    Strings.GeneralCaptions.AllFiles := 'All files (*.*)';
    Strings.GeneralCaptions.Confirm := 'Confirm';
    Strings.GeneralCaptions.Error := 'Error';
    Strings.GeneralCaptions.TypeNewFileName := 'Type new filename';
    Strings.GeneralCaptions.Browse := 'Browse';
  //progressbar strings
    Strings.ProgBar.Aborted := 'Aborted,';
    Strings.ProgBar.CRCError := 'CRC error,';
    Strings.ProgBar.ReadError := 'Read error,';
    Strings.ProgBar.WriteError := 'Write error,';
    Strings.ProgBar.WipingFile := 'wiping file...';
    Strings.ProgBar.EncryptingFile := 'Encrypting:';
    Strings.ProgBar.DecryptingFile := 'Decrypting:';
    Strings.ProgBar.DecompressingFile := 'Decompressing:';
    Strings.ProgBar.CopyingFile := 'Copying:';
    Strings.ProgBar.CompressingFile := 'Compressing:';
    Strings.ProgBar.SkippingFile := 'Skipping:';
  //config panel / settings
    Strings.Config_Settings.Settings := 'Settings';
    Strings.Config_Settings.PwdPolicy := 'Password policy';
    Strings.Config_Settings.MinLength := '&min. length';
    Strings.Config_Settings.PwdMustContain := '&password must contain some ...';
    Strings.Config_Settings.Letters := '... &letters';
    Strings.Config_Settings.Numbers := '... &numbers';
    Strings.Config_Settings.SpecialChars := '... &special chars';
    Strings.Config_Settings.CompressionLevel := 'compression level';
    Strings.Config_Settings.WipeOriginalAfterEncrypt := 'wipe &original file(s) after encrypt';
    Strings.Config_Settings.WipeTempFiles := 'wipe &temp files';
  //config panel / misc
    Strings.Config_Misc.Misc := 'Misc';
    Strings.Config_Misc.RandomPwdGenerator := 'Random password generator';
    Strings.Config_Misc.Length := 'length';
    Strings.Config_Misc.LowerCaseLetters := '&lowercase letters';
    Strings.Config_Misc.UpperCaseLetters := '&uppercase letters';
    Strings.Config_Misc.Numbers := '&numbers';
    Strings.Config_Misc.AnyASCIIChars := '&any ASCII chars';
    Strings.Config_Misc.Generate := '&generate';
    Strings.Config_Misc.DestroyKeyInfo := 'destroy key info after this idle time';
    Strings.Config_Misc.Instantly := '[instantly]';
    Strings.Config_Misc.Sec := 'sec';
    Strings.Config_Misc.Min := 'min';
    Strings.Config_Misc.DefaultKeyFile := 'Default keyfile';
   //misc3
    Strings.Config_Misc3.AlwaysCreateSfx := 'Always create self-decrypting files';
    Strings.Config_Misc3.WhereToSaveSettings := 'Where do you want to save your settings?';
    Strings.Config_Misc3.DefIniFile := 'default .ini file';
    Strings.Config_Misc3.UserDefined := 'user defined .ini file';
    Strings.Config_Misc3.CloseToWcx := 'to directory where aes.wcx is';
    Strings.Config_Misc3.SelectDirWhereYouWantToSaveSettings := 'Select directory where you want to save settings:';
    Strings.Config_Misc3.WriteError := 'Write error!';
   //abouttab
    Strings.Config_About.AboutCaption := 'About';
   //config panel / uninstall
    Strings.Config_Uninstall.UninstallGroupBoxCaption := 'Uninstall';
    Strings.Config_Uninstall.Settings := '&settings';
    Strings.Config_Uninstall.LanguageFiles := '&language files';
    Strings.Config_Uninstall.Uninstall := '&uninstall';
    Strings.Config_Uninstall.UninstallConfirm := 'Uninstall?';
    Strings.Config_Uninstall.Finished := 'Successfully uninstalled.';
    Strings.Config_Uninstall.AesWcxDelete := 'aes.wcx file will be deleted after reboot.';
    Strings.Config_Uninstall.TCRestart := 'Recommended to restart TC.';
    Strings.Lang.LanguageCaption := 'Language';
    Strings.Lang.SelectYourLanguage := 'Select your language';
   //general messages
    Strings.GeneralMessages.WipeWarning := 'If a file has been wiped its original data will be lost forever and cannot be restored even with low-level disk editing utilities! Continue?';
    Strings.GeneralMessages.VerificationFailed := 'Verification failed.';
    Strings.GeneralMessages.KeyInfoDestroyed := 'Key info destroyed.';
    Strings.GeneralMessages.TypePwdAgain := 'Please retype password.';
    Strings.GeneralMessages.MissingSpecial := 'missing special chars';
    Strings.GeneralMessages.MissingNumber := 'missing numbers';
    Strings.GeneralMessages.MissingAlpha := 'missing alpha chars';
    Strings.GeneralMessages.TooShort := 'too short';
    Strings.GeneralMessages.Suit := 'Your password doesn''t suit these password rules:';
    Strings.GeneralMessages.WrongPwd := 'Wrong password or keyfile.';
    Strings.GeneralMessages.YouCantModify := 'You can''t modify an archive with wrong password.';
    Strings.GeneralMessages.InvalidNumber := 'Invalid number.';
    Strings.GeneralMessages.MaxPwdLength := 'Max. passwordlength is 255';
    Strings.GeneralMessages.InvalidCharInExtension := 'Invalid char in extension!';
    Strings.GeneralMessages.InvalidKeyFileSize := 'Min. keyfile size is 2 KB.';
    Strings.GeneralMessages.ErrorOpeningKeyFile := 'Error opening keyfile.';
    Strings.GeneralMessages.DontEncryptYourKeyFile := 'Don''t encrypt your keyfile with same keyfile.';
    Strings.GeneralMessages.ConfirmOverwrite := 'This file already exist. Overwrite it?';
    Strings.GeneralMessages.CouldntDeleteFile := 'Couldn''t delete file.';
    Strings.GeneralMessages.ThisArchiveVersionDoesntSupportMultipleFiles := 'Sorry, this archive version doesn''t support multiple files.';
    Strings.GeneralMessages.OverwriteConfirmationInArchive := 'This file already exists in archive. Do you want to overwrite it?';
   //pwd change strings
    Strings.PwdChangeStrings.CRCTest := 'CRC checking...';
    Strings.PwdChangeStrings.PwdChangeCaption := 'password change';
    Strings.PwdChangeStrings.TypeOldPwd := 'Type old password:';
    Strings.PwdChangeStrings.TypeNewPwd := 'Type new password:';
    Strings.PwdChangeStrings.RetypeNewPwd := 'Retype new password:';
    Strings.PwdChangeStrings.Reencrypting := 'Re-encrypting file...';
    Strings.PwdChangeStrings.ReencryptedSuccessfully := 'File has been successfully re-encrypted.';
   //hotkey
    Strings.HotkeyStr.Hotkeys := 'Hotkeys';
    Strings.HotkeyStr.EncryptWith := 'Encrypt with password/keyfile';
    Strings.HotkeyStr.CreateSfx := 'Create self-decrypting file';
    Strings.HotkeyStr.CompLevelChange := 'Change compression level';
    Strings.HotkeyStr.OpenKeyfile := 'Keyfile select dialog';

//----SFX strings
    SfxStrings.Password := 'Password';
    SfxStrings.Keyfile := 'Keyfile';
    SfxStrings.DecryptTo := 'Decrypt to';
    SfxStrings.Browse := 'Browse';
    SfxStrings.Exit := 'Exit';
    SfxStrings.ErrorOpeningKeyfile := 'Error opening keyfile.';
    SfxStrings.ReadError := 'Read error.';
    SfxStrings.Error := 'Error';
    SfxStrings.OverWriteConfirm := 'This file already exists. Overwrite it?';
    SfxStrings.CorruptedFile := 'Corrupted file.';
    SfxStrings.WrongPassword := 'Wrong password.';
    SfxStrings.SelectDestPath := 'Select destination path:';
    SfxStrings.DestPathIsWriteProtected := 'Destination path is write-protected!';
    SfxStrings.EnterValidPath := 'Please enter valid path.';
    SfxStrings.AbortConfirmText := 'Are you sure you want to abort?';
    SfxStrings.ConfirmCaption := 'Confirm';
    SfxStrings.ErrorDuringDecompression := 'Error occured during decompression.';
    SfxStrings.CorruptedArchive := 'Corrupted archive file.';
    SfxStrings.NotEnoughSpace := 'There is not enough space in destination folder. Continue?';
    SfxStrings.FailedToCreateDir := 'Failed to create dirctory:';
    SfxStrings.IncompletedFile := 'Incompleted file:';
    SfxStrings.UnknownError := 'Unknown error.';
    SfxStrings.KeyFileNotFound := 'Keyfile not found.';
    SfxStrings.Warning := 'Warning';
    SfxStrings.AllFiles := 'All files';
    SfxStrings.Yes := 'Yes';
    SfxStrings.No := 'No';
    SfxStrings.Cancel := 'Cancel';
    SfxStrings.Skip := 'Skip';
    SfxStrings.SkipAll := 'Skip All';
    SfxStrings.OverwriteAll := 'Overwrite all';
    SfxStrings.Rename := 'Rename';
    SfxStrings.AutoRename := 'Auto rename';
    SfxStrings.EnterNewFilename := 'Enter new filename';
    SfxStrings.ButtonWidth := '80';
    SfxStrings.ButtonHeight := '22';
    SfxStrings.OvAllWW := '0';
    SfxStrings.SkipAllWW := '0';
    SfxStrings.AutoRenWW := '0';
    SfxStrings.SkipAllLabelAlign := '0';
    SfxStrings.OvAllLabelAlign := '0';
    SfxStrings.AutoRenLabelAlign := '0';

end;
procedure LoadLanguage(filename: string);
var Reg: TIniFile;
begin
  if not FileExists(filename) then begin
     LoadDefLanguage;
     Exit;
  end;
  Reg := TIniFile.Create(filename);
  with Reg do begin //1
  //encform
    Strings.EncFormStrings.EncryptCaption := ReadString('EncryptForm', 'EncryptCaption', 'encrypt');
    Strings.EncFormStrings.TypePwd := ReadString('EncryptForm', 'TypePwd', 'Type encrypting password:');
    Strings.EncFormStrings.RetypePwd := ReadString('EncryptForm', 'ReTypePwd', 'Retype encrypting password:');
    Strings.EncFormStrings.OptionsWipeOnly := ReadString('EncryptForm', 'OptionsWipeOnly', 'Wipe only');
    Strings.EncFormStrings.Complevel := ReadString('EncryptForm', 'CompLevel', 'comp. level:');
    Strings.EncFormStrings.WipeOriginal := ReadString('EncryptForm', 'WipeOriginal', 'WIPE original');
    Strings.EncFormStrings.EncryptWithPassword := ReadString('EncryptForm', 'EncryptWithPassword', 'Encrypt with password');
    Strings.EncFormStrings.EncryptWithKeyFile := ReadString('EncryptForm', 'EncryptWithKeyFile', 'Encrypt with keyfile');
    Strings.EncFormStrings.CreateSfxArchive := ReadString('EncryptForm', 'CreateSfxArchive', 'Create self-decrypting archive');
    Strings.EncFormStrings.ApplyTheSameKeyForAllFile := ReadString('EncryptForm', 'ApplyTheSameKeyForAllFile', 'Apply the same key for all file');


    Strings.EncFormStrings.SelectKeyFile := ReadString('EncryptForm', 'SelectKeyFile', 'Select keyfile');
    Strings.EncFormStrings.OpenDialogTitle := ReadString('EncryptForm', 'OpenDialogTitle', 'Select keyfile what you want to encrypt with');
  //decform
    Strings.DecFormStrings.EncryptedFile := ReadString('DecryptForm', 'EncryptedFile', 'File is encrypted.');
    Strings.DecFormStrings.TypePwd2Decrypt := ReadString('DecryptForm', 'TypePwd2Decrypt', 'Type password to decrypt:');
    Strings.DecFormStrings.OptionsSkipCRCCheck := ReadString('DecryptForm', 'OptionsSkipCRCCheck', 'Skip CRC check');
    Strings.DecFormStrings.OptionsPwdChange := ReadString('DecryptForm', 'OptionsPwdChange', 'Change password');
    Strings.DecFormStrings.DeleteCaption := ReadString('DecryptForm', 'DeleteCaption', 'delete');
    Strings.DecFormStrings.OpenDialogTitle := ReadString('DecryptForm', 'OpenDialogTitle', 'Select keyfile what you want to decrypt with');
    Strings.DecFormStrings.DecryptWithPassword := ReadString('DecryptForm', 'DecryptWithPassword', 'Decrypt with password');
    Strings.DecFormStrings.DecryptWithKeyFile := ReadString('DecryptForm', 'DecryptWithKeyFile', 'Decrypt with keyfile');
  //generalcaptions
    Strings.GeneralCaptions.OpenCaption := ReadString('GeneralCaptions', 'OpenCaption', 'open');
    Strings.GeneralCaptions.Ok := ReadString('GeneralCaptions', 'OKButton', 'OK');
    Strings.GeneralCaptions.Cancel := ReadString('GeneralCaptions', 'CancelButton', 'Cancel');
    Strings.GeneralCaptions.Options := ReadString('GeneralCaptions', 'Options', '&Options');
    Strings.GeneralCaptions.OptionsHidePwd := ReadString('GeneralCaptions', 'OptionsHidePwd', 'Hide password');
    Strings.GeneralCaptions.CompLevelMax := ReadString('GeneralCaptions', 'CompLevelMax', 'max');
    Strings.GeneralCaptions.CompLevelNormal := ReadString('GeneralCaptions', 'CompLevelNormal', 'normal');
    Strings.GeneralCaptions.CompLevelFast := ReadString('GeneralCaptions', 'CompLevelFast', 'fast');
    Strings.GeneralCaptions.CompLevelNone := ReadString('GeneralCaptions', 'CompLevelNone', 'none');
    Strings.GeneralCaptions.DontShowAgain := ReadString('GeneralCaptions', 'DontShowAgain', 'Don''t show again');
    Strings.GeneralCaptions.SkipCRCWarning := WrapText(ReadString('GeneralCaptions', 'SkipCRCWarning', 'With this option you can usually decrypt damaged files partially in some cases but maybe TC will freeze.'), 50);
    Strings.GeneralCaptions.DontShowAgain := ReadString('GeneralCaptions', 'DontShowAgain', 'Don''t show again.');
    Strings.GeneralCaptions.Warning := ReadString('GeneralCaptions', 'Warning', 'Warning');
    Strings.GeneralCaptions.DontCompressTheseFileTypes := ReadString('GeneralCaptions', 'DontCompressTheseFileTypes', 'Don''t compress these file types');
    Strings.GeneralCaptions.TypeAnExtension := ReadString('GeneralCaptions', 'TypeAnExtension', 'Type an extension (e.g.: ZIP)');
    Strings.GeneralCaptions.Open := ReadString('GeneralCaptions', 'Open', 'Open...');
    Strings.GeneralCaptions.AllFiles := ReadString('GeneralCaptions', 'AllFiles', 'All files (*.*)');
    Strings.GeneralCaptions.Confirm := ReadString('GeneralCaptions', 'Confirm', 'Confirm');
    Strings.GeneralCaptions.Error := ReadString('GeneralCaptions', 'Error', 'Error');
    Strings.GeneralCaptions.TypeNewFileName := ReadString('GeneralCaptions', 'TypeNewFileName', 'Type new filename');
    Strings.GeneralCaptions.Browse := ReadString('GeneralCaptions', 'Browse', 'Browse');
  //progressbar strings
    Strings.ProgBar.Aborted := ReadString('ProgressBar', 'Aborted', 'Aborted,');
    Strings.ProgBar.CRCError := ReadString('ProgressBar', 'CRCError', 'CRC error,');
    Strings.ProgBar.ReadError := ReadString('ProgressBar', 'ReadError', 'Read error,');
    Strings.ProgBar.WriteError := ReadString('ProgressBar', 'WriteError', 'Write error,');
    Strings.ProgBar.WipingFile := ReadString('ProgressBar', 'WipingFile', 'wiping file...');
    Strings.ProgBar.EncryptingFile := ReadString('ProgressBar', 'EncryptingFile', 'Encrypting:');
    Strings.ProgBar.DecryptingFile := ReadString('ProgressBar', 'DecryptingFile', 'Decrypting:');
    Strings.ProgBar.DecompressingFile := ReadString('ProgressBar', 'DecompressingFile', 'Decompressing:');
    Strings.ProgBar.CopyingFile := ReadString('ProgressBar', 'CopyingFile', 'Copying:');
    Strings.ProgBar.CompressingFile := ReadString('ProgressBar', 'CompressingFile', 'Compressing:');
    Strings.ProgBar.SkippingFile := ReadString('ProgressBar', 'SkippingFile', 'Skipping:');
  //config panel / settings
    Strings.Config_Settings.Settings := ReadString('Config_Settings', 'Settings', 'Settings');
    Strings.Config_Settings.PwdPolicy := ReadString('Config_Settings', 'PwdPolicy', 'Password policy');
    Strings.Config_Settings.MinLength := ReadString('Config_Settings', 'MinLength', '&min. length');
    Strings.Config_Settings.PwdMustContain := ReadString('Config_Settings', 'PwdMustContain', '&password must contain some ...');
    Strings.Config_Settings.Letters := ReadString('Config_Settings', 'Letters', '... &letters');
    Strings.Config_Settings.Numbers := ReadString('Config_Settings', 'Numbers', '... &numbers');
    Strings.Config_Settings.SpecialChars := ReadString('Config_Settings', 'SpecialChars', '... &special chars');
    Strings.Config_Settings.CompressionLevel := ReadString('Config_Settings', 'CompressionLevel', 'compression level');
    Strings.Config_Settings.WipeOriginalAfterEncrypt := ReadString('Config_Settings', 'WipeOriginalAfterEncrypt', 'wipe &original file(s) after encrypt');
    Strings.Config_Settings.WipeTempFiles := ReadString('Config_Settings', 'WipeTempFiles', 'wipe &temp files');
  //config panel / misc
    Strings.Config_Misc.Misc := ReadString('Config_Misc', 'Misc', 'Misc');
    Strings.Config_Misc.RandomPwdGenerator := ReadString('Config_Misc', 'RandomPwdGenerator', 'Random password generator');
    Strings.Config_Misc.Length := ReadString('Config_Misc', 'Length', 'length');
    Strings.Config_Misc.LowerCaseLetters := ReadString('Config_Misc', 'LowerCaseLetters', '&lowercase letters');
    Strings.Config_Misc.UpperCaseLetters := ReadString('Config_Misc', 'UpperCaseLetters', '&uppercase letters');
    Strings.Config_Misc.Numbers := ReadString('Config_Misc', 'Numbers', '&numbers');
    Strings.Config_Misc.AnyASCIIChars := ReadString('Config_Misc', 'AnyASCIIChars', '&any ASCII chars');
    Strings.Config_Misc.Generate := ReadString('Config_Misc', 'Generate', '&generate');
    Strings.Config_Misc.DestroyKeyInfo := ReadString('Config_Misc', 'DestroyKeyInfo', 'destroy key info after this idle time');
    Strings.Config_Misc.Instantly := ReadString('Config_Misc', 'Instantly', '[instantly]');
    Strings.Config_Misc.Sec := ReadString('Config_Misc', 'Sec', 'sec');
    Strings.Config_Misc.Min := ReadString('Config_Misc', 'Min', 'min');
    Strings.Config_Misc.DefaultKeyFile := ReadString('Config_Misc', 'DefaultKeyFile', 'Default keyfile');
   //Misc3
    Strings.Config_Misc3.AlwaysCreateSfx := ReadString('Config_Misc3', 'AlwaysCreateSfx', 'Always create self-decrypting files');
    Strings.Config_Misc3.WhereToSaveSettings := ReadString('Config_Misc3', 'WhereSaveSettings', 'Where do you want to save your settings?');
    Strings.Config_Misc3.DefIniFile := ReadString('Config_Misc3', 'DefIniFile', 'default .ini file');
    Strings.Config_Misc3.UserDefined := ReadString('Config_Misc3', 'UserDefined', 'user defined .ini file');
    Strings.Config_Misc3.CloseToWcx := ReadString('Config_Misc3', 'SaveToWhereAesWcxIs', 'to directory where aes.wcx is');
    Strings.Config_Misc3.SelectDirWhereYouWantToSaveSettings := ReadString('Config_Misc3', 'SelectDirWhereYouWantToSaveSettings', 'Select directory where you want to save settings:');
    Strings.Config_Misc3.WriteError := ReadString('Config_Misc3', 'WriteError', 'Write error!');    
   //abouttab
    Strings.Config_About.AboutCaption := ReadString('Config_About', 'AboutCaption', 'About');
   //config panel / uninstall
    Strings.Config_Uninstall.UninstallGroupBoxCaption := ReadString('Config_Uninstall', 'UninstallGroupBoxCaption', 'Uninstall');
    Strings.Config_Uninstall.Settings := ReadString('Config_Uninstall', 'Settings', '&settings');
    Strings.Config_Uninstall.LanguageFiles := ReadString('Config_Uninstall', 'LanguageFiles', '&language files');
    Strings.Config_Uninstall.Uninstall := ReadString('Config_Uninstall', 'Uninstall', '&uninstall');
    Strings.Config_Uninstall.UninstallConfirm := ReadString('Config_Uninstall', 'UninstallConfirm', 'Uninstall?');
    Strings.Config_Uninstall.Finished := ReadString('Config_Uninstall', 'Finished', 'Successfully uninstalled.');
    Strings.Config_Uninstall.AesWcxDelete := ReadString('Config_Uninstall', 'AesWcxDelete', 'aes.wcx file will be deleted after reboot.');
    Strings.Config_Uninstall.TCRestart := ReadString('Config_Uninstall', 'TCRestart', 'Recommended to restart TC.');
    Strings.Lang.LanguageCaption := ReadString('Config_Language', 'LanguageCaption', 'Language');
    Strings.Lang.SelectYourLanguage := ReadString('Config_Language', 'SelectYourLanguage', 'Select your language');
   //general messages
    Strings.GeneralMessages.WipeWarning := ReadString('GeneralMessages', 'WipeWarning', 'If a file has been wiped its original data will be lost forever and cannot be restored even with low-level disk editing utilities! Continue?    ');
    Strings.GeneralMessages.VerificationFailed := ReadString('GeneralMessages', 'VerificationFailed', 'Verification failed.');
    Strings.GeneralMessages.KeyInfoDestroyed := ReadString('GeneralMessages', 'KeyInfoDestroyed', 'Key info destroyed.');
    Strings.GeneralMessages.TypePwdAgain := ReadString('GeneralMessages', 'TypePwdAgain', 'Please retype password.');
    Strings.GeneralMessages.MissingSpecial := ReadString('GeneralMessages', 'MissingSpecial', 'missing special chars');
    Strings.GeneralMessages.MissingNumber := ReadString('GeneralMessages', 'MissingNumber', 'missing numbers');
    Strings.GeneralMessages.MissingAlpha := ReadString('GeneralMessages', 'MissingAlpha', 'missing alpha chars');
    Strings.GeneralMessages.TooShort := ReadString('GeneralMessages', 'TooShort', 'too short');
    Strings.GeneralMessages.Suit := ReadString('GeneralMessages', 'Suit', 'Your password doesn''t suit these password rules:');
    Strings.GeneralMessages.WrongPwd := ReadString('GeneralMessages', 'WrongPwd', 'Wrong password or keyfile.');
    Strings.GeneralMessages.YouCantModify := ReadString('GeneralMessages', 'YouCantModify', 'You can''t modify an archive with wrong password.');
    Strings.GeneralMessages.InvalidNumber := ReadString('GeneralMessages', 'InvalidNumber', 'Invalid number.');
    Strings.GeneralMessages.MaxPwdLength := ReadString('GeneralMessages', 'MaxPwdLength', 'Max. passwordlength is 255');
    Strings.GeneralMessages.InvalidCharInExtension := ReadString('GeneralMessages', 'InvalidCharInExtension', 'Invalid char in extension!');
    Strings.GeneralMessages.InvalidKeyFileSize := ReadString('GeneralMessages', 'InvalidKeyFileSize', 'Min. keyfile size is 2 KB.');
    Strings.GeneralMessages.ErrorOpeningKeyFile := ReadString('GeneralMessages', 'ErrorOpeningKeyFile', 'Error opening keyfile.');
    Strings.GeneralMessages.DontEncryptYourKeyFile := ReadString('GeneralMessages', 'DontEncryptYourKeyFile', 'Don''t encrypt your keyfile with same keyfile.');
    Strings.GeneralMessages.ConfirmOverwrite := ReadString('GeneralMessages', 'ConfirmOverWrite', 'This file already exist. Overwrite it?');
    Strings.GeneralMessages.CouldntDeleteFile := ReadString('GeneralMessages', 'CouldntDeleteFile', 'Couldn''t delete file.');
    Strings.GeneralMessages.ThisArchiveVersionDoesntSupportMultipleFiles := ReadString('GeneralMessages', 'ThisArchiveVersionDoesntSupportMultipleFiles', 'Sorry, this archive version doesn''t support multiple files.');
    Strings.GeneralMessages.OverwriteConfirmationInArchive := ReadString('GeneralMessages', 'OverWriteConfirmationInArchive', 'This file already exists in archive. Do you want to overwrite it?');
   //hotkey
    Strings.HotkeyStr.Hotkeys := ReadString('Hotkey', 'Hotkeys', 'Hotkeys');
    Strings.HotkeyStr.EncryptWith := ReadString('Hotkey', 'EncryptWithPwdKeyfile', 'Encrypt with password/keyfile');
    Strings.HotkeyStr.CreateSfx := ReadString('Hotkey', 'CreateSelfDecryptingFile', 'Create self-decrypting file');
    Strings.HotkeyStr.CompLevelChange := ReadString('Hotkey', 'CompressionLevelChange', 'Change compression level');
    Strings.HotkeyStr.OpenKeyfile := ReadString('Hotkey', 'KeyFileSelectdialog', 'Keyfile select dialog');
   //pwd change strings
    Strings.PwdChangeStrings.CRCTest := ReadString('PwdChange', 'CRCTest', 'CRC checking...');
    Strings.PwdChangeStrings.PwdChangeCaption := ReadString('PwdChange', 'PwdChangeCaption', 'password change');
    Strings.PwdChangeStrings.TypeOldPwd := ReadString('PwdChange', 'TypeOldPwd', 'Type old password:');
    Strings.PwdChangeStrings.TypeNewPwd := ReadString('PwdChange', 'TypeNewPwd', 'Type new password:');
    Strings.PwdChangeStrings.RetypeNewPwd := ReadString('PwdChange', 'RetypeNewPwd', 'Retype new password:');
    Strings.PwdChangeStrings.Reencrypting := ReadString('PwdChange', 'Reencrypting', 'Re-encrypting file...');
    Strings.PwdChangeStrings.ReencryptedSuccessfully := ReadString('PwdChange', 'ReencryptedSuccessfully', 'File has been successfully re-encrypted.');
//----SFX strings
    SfxStrings.Password := ReadString('Sfx', 'Password', 'Password');
    SfxStrings.Keyfile := ReadString('Sfx', 'Keyfile', 'Keyfile');
    SfxStrings.DecryptTo := ReadString('Sfx', 'DecryptTo', 'Decrypt to');
    SfxStrings.Browse := ReadString('Sfx', 'Browse', 'Browse');
    SfxStrings.Exit := ReadString('Sfx', 'Exit', 'Exit');
    SfxStrings.ErrorOpeningKeyfile := ReadString('Sfx', 'ErrorOpeningKeyFile', 'Error opening keyfile.');
    SfxStrings.ReadError := ReadString('Sfx', 'ReadError', 'Read error.');
    SfxStrings.Error := ReadString('Sfx', 'Error', 'Error');
    SfxStrings.OverWriteConfirm := ReadString('Sfx', 'OverWriteConfirm', 'This file already exists. Overwrite it?');
    SfxStrings.CorruptedFile := ReadString('Sfx', 'CorruptedFile', 'Corrupted file.');
    SfxStrings.WrongPassword := ReadString('Sfx', 'WrongPassword', 'Wrong password.');
    SfxStrings.SelectDestPath := ReadString('Sfx', 'SelectDestPath', 'Select destination path:');
    SfxStrings.DestPathIsWriteProtected := ReadString('Sfx', 'DestPathIsWriteProtected', 'Destination path is write-protected!');
    SfxStrings.EnterValidPath := ReadString('Sfx', 'EnterValidPath', 'Please enter valid path.');
    SfxStrings.AbortConfirmText := ReadString('Sfx', 'AbortConfirmText', 'Are you sure you want to abort?');
    SfxStrings.ConfirmCaption := ReadString('Sfx', 'ConfirmCaption', 'Confirm');
    SfxStrings.ErrorDuringDecompression := ReadString('Sfx', 'ErrorDuringDecompression', 'Error occured during decompression.');
    SfxStrings.CorruptedArchive := ReadString('Sfx', 'CorruptedArchive', 'Corrupted archive file.');
    SfxStrings.NotEnoughSpace := ReadString('Sfx', 'NotEnoughSpace', 'There is not enough space in destination folder. Continue?');
    SfxStrings.FailedToCreateDir := ReadString('Sfx', 'FailedToCreateDir', 'Failed to create dirctory:');
    SfxStrings.IncompletedFile := ReadString('Sfx', 'IncompletedFile', 'Incompleted file:');
    SfxStrings.UnknownError := ReadString('Sfx', 'UnknownError', 'Unknown error.');
    SfxStrings.KeyFileNotFound := ReadString('Sfx', 'KeyFileNotFound', 'Keyfile not found.');
    SfxStrings.Warning := ReadString('Sfx', 'Warning', 'Warning');
    SfxStrings.AllFiles := ReadString('Sfx', 'AllFiles', 'All files');
    SfxStrings.Yes := ReadString('Sfx', 'Yes', 'Yes');
    SfxStrings.No := ReadString('Sfx', 'No', 'No');
    SfxStrings.Cancel := ReadString('Sfx', 'Cancel', 'Cancel');
    SfxStrings.Skip := ReadString('Sfx', 'Skip', 'Skip');
    SfxStrings.SkipAll := ReadString('Sfx', 'SkipAll', 'Skip All');
    SfxStrings.OverwriteAll := ReadString('Sfx', 'OverwriteAll', 'Overwrite all');
    SfxStrings.Rename := ReadString('Sfx', 'Rename', 'Rename');
    SfxStrings.AutoRename := ReadString('Sfx', 'AutoRename', 'Auto rename');
    SfxStrings.EnterNewFilename := ReadString('Sfx', 'EnterNewFilename', 'Enter new filename');
    SfxStrings.ButtonWidth := ReadString('Sfx', 'ButtonWidth', '80');
    SfxStrings.ButtonHeight := ReadString('Sfx', 'ButtonHeight', '22');
    SfxStrings.OvAllWW := ReadString('Sfx',   'OvAllLabelWordWrap', '0');
    SfxStrings.SkipAllWW := ReadString('Sfx', 'SkipAllLabelWordWrap', '0');
    SfxStrings.AutoRenWW := ReadString('Sfx', 'AutoRenLabelWordWrap', '0');
    SfxStrings.SkipAllLabelAlign := ReadString('Sfx', 'SkipAllLabelAlign', '0');
    SfxStrings.OvAllLabelAlign := ReadString('Sfx', 'OvAllLabelAlign', '0');
    SfxStrings.AutoRenLabelAlign := ReadString('Sfx', 'AutoRenLabelAlign', '0');

  end;//1
  Reg.Free;

end; //LoadLanguage


end.
