unit zipaes;

interface

{$L \zipaes\fileenc.obj}
{$L \zipaes\aescrypt.obj}
{$L \zipaes\aeskey.obj}
{$L \zipaes\pwd2key.obj}
{$L \zipaes\hmac.obj}
{$L \zipaes\sha1.obj}
{$L \zipaes\aestab.obj}
const BLOCK_SIZE = 16;
      IN_BLOCK_LENGTH = 64; //SHA1_BLOCK_SIZE

type
     sha1_32t = cardinal;
     aes_32t = cardinal;
     uint = cardinal;
     TAES_ctx = record
        k_sch: array [0..63] of aes_32t;
        n_rnd: aes_32t;
        n_blk: aes_32t;
     end;

     TSHA1_ctx = record
       count: array [0..1] of sha1_32t;
       hash: array [0..4] of sha1_32t;
       wbuf: array [0..15] of sha1_32t;
     end;
     THMAC_ctx = record
        key: array [0..IN_BLOCK_LENGTH-1] of byte;
        ctx: TSHA1_ctx;
        klen: uint;
     end;



     Tfcrypt_ctx = record
        nonce: array [0..BLOCK_SIZE-1] of byte;
        encr_bfr: array [0..BLOCK_SIZE-1] of byte;
        encr_ctx: TAES_ctx;
        auth_ctx: THMAC_ctx;
        encr_pos,
        pwd_len,
        mode: uint;
     end;

     type pwdver_array = array [0..1] of byte;
     function _fcrypt_init(mode: integer;
                           const pwd: PChar;
                           pwd_len: uint;
                           const salt: PByte;
                           pwd_ver: pwdver_array;
                           var context: Tfcrypt_ctx): integer; cdecl; external;
     procedure _fcrypt_decrypt(var data: Pbyte;
                               data_len: uint;
                               var context: Tfcrypt_ctx); cdecl; external;
     function _fcrypt_end(var MAC: PByte;
                          var context: Tfcrypt_ctx): integer; cdecl; external;

     procedure _memset(var buff; b: smallint; size: cardinal); cdecl;
     procedure _memcpy(var dest; const src; count: cardinal); cdecl;
{==========================================================================}
//exported functions
     function InitZipAES(mode: integer;
                         pwd: PChar;
                         pwd_len: uint;
                         salt: PByte;
                         pwd_ver: pwdver_array;
                         var context: Tfcrypt_ctx): integer; stdcall;
     procedure DecryptZipAES(var data: Pbyte;
                             data_len: uint;
                             var context: Tfcrypt_ctx); stdcall;
     function EndZipAES(var MAC: PByte;
                        var context: Tfcrypt_ctx): smallint; stdcall;

{==========================================================================}

implementation

{==========================================================================}

     procedure _memset(var buff; b: smallint; size: cardinal); cdecl;
     begin
       FillChar(buff, size, b);
     end;

{==========================================================================}

     procedure _memcpy(var dest; const src; count: cardinal); cdecl;
     begin
       Move(src, dest, count);
     end;

{==========================================================================}

     function InitZipAES(mode: integer;
                         pwd: PChar;
                         pwd_len: uint;
                         salt: PByte;
                         pwd_ver: pwdver_array;
                         var context: Tfcrypt_ctx): integer; stdcall;
     begin
      	Result := _fcrypt_init(mode,pwd,pwd_len,salt,pwd_ver,context);
     end;

{==========================================================================}

     procedure DecryptZipAES(var data: Pbyte;
                             data_len: uint;
                             var context: Tfcrypt_ctx); stdcall;
     begin
         _fcrypt_decrypt(data,data_len, context);
     end;

{==========================================================================}

     function EndZipAES(var MAC: PByte;
                        var context: Tfcrypt_ctx): smallint; stdcall;
     begin
        Result := _fcrypt_end(MAC, context);
     end;

{==========================================================================}


end.
