using System;
using System.Text;
using System.Runtime.InteropServices;
using MosTech.TotalCommander;
using CONNAPI;

namespace MosTech.Nokia
{

    public class NokiaInfo
    {
        public NokiaInfo(string name)
        {
            Name = name;
        }

        public string Name;
    }

    public class DeviceInfo : NokiaInfo
    {
        public DeviceInfo(string name, string serialNumber)
            : base(name)
        {
            SerialNumber = serialNumber;
        }
        public string SerialNumber;

        FileSystem _fs;
        object _lock = new object();

        public FileSystem FS
        {
            get
            {
                if (_fs == null)
                {
                    lock (_lock)
                    {
                        _fs = new FileSystem(this.SerialNumber);
                    }
                }
                return _fs;
            }
        }
    }

    public class DirInfo : NokiaInfo
    {
        public DirInfo(string name)
            : base(name)
        {
        }
    }

    public class FileInfo : NokiaInfo
    {
        public FileInfo(string name, long fileSize, uint attributes, FILETIME fileTime)
            : base(name)
        {
            FileSize = fileSize;
            Attributes = attributes;
            FileTime = fileTime;
        }

        public long FileSize;
        public uint Attributes;
        public FILETIME FileTime;
        public string MIMEType;
    }

   
}
