using System;
using System.Text;

using MosTech.TotalCommander;
using System.IO;
namespace LocalFilesystems
{
    public class LocalFileSystems : IPlugin
    {

        public string PluginName()
        {
            return "Demo Local FileSystem";
        }

        public void StatusInfo(string remoteDir, Status infoStatus, StatusOp infoOperation)
        {
        }

        public FindFileInfo FindFirst(int searchIndex, string path)
        {
            returnIndex = 0;
            driveFinding = isRoot(path);

            if (driveFinding)
            {
                //root
                drives = Directory.GetLogicalDrives();
                return GetDriveItem();
            }
            else
            {
                //in drive
                preparePath(ref path);
                dirs = Directory.GetDirectories(path);
                files = Directory.GetFiles(path);
                return GetDirs();
            }
        }



        public FindFileInfo FindNext(int searchIndex)
        {
            if (driveFinding)
                return GetDriveItem();
            else
                return GetDirs();
        }

        public int FindClose(int searchIndex)
        {
            return 0;
        }

        public bool CreateDirectory(string dir)
        {
         //   string s= "dfsdf";
         //   MosTech.TotalCommander.MtcManager.RequestProc(RequestType.URL,null,null, ref s, 86);
            if (isRoot(dir)) return false;

            preparePath(ref dir);

            if (Directory.Exists(dir)) throw new IOException("Directory exists");

            Directory.CreateDirectory(dir);

            return true;
        }

        public bool RemoveDirectory(string dirName)
        {
            if (isRoot(dirName)) return false;

            preparePath(ref dirName);
            Directory.Delete(dirName);
            return true;
        }

        public bool DeleteFile(string fileName)
        {
            fileName = fileName.Substring(1);
            File.Delete(fileName);
            return true;
        }

        public CopyOpResult RenameMoveFile(string oldName, string newName, bool Move, bool OverWrite)
        {
            // is file 
            if (File.Exists(oldName.Substring(1)))
            {
                oldName = oldName.Substring(1);
                newName = newName.Substring(1);
                File.Move(oldName, newName);
            }
            else //is dir
            {
                preparePath(ref oldName);
                preparePath(ref newName);
                Directory.Move(oldName, newName);
            }

            return CopyOpResult.Ok;
        }

        public CopyOpResult GetFile(string remoteName, string localName, CopyFlags copyFlags)
        {
            remoteName = remoteName.Substring(1);
            
            if ((CopyFlags.Move & copyFlags) == CopyFlags.Move)
            {
                File.Move(remoteName, localName);
                return CopyOpResult.Ok;
            }
            else
            {
                File.Copy(remoteName, localName);
                return CopyOpResult.Ok;
            }
        }

        public CopyOpResult PutFile(string localName, string remoteName, CopyFlags copyFlags)
        {
            remoteName = remoteName.Substring(1);

            if ((CopyFlags.Move & copyFlags) == CopyFlags.Move)
            {
                File.Move(localName,remoteName );
                return CopyOpResult.Ok;
            }
            else
            {
                File.Copy(localName,remoteName);
                return CopyOpResult.Ok;
            }
        }

        public ExecOpResult ExecuteFile(ref string remoteName, string verbs)
        {
            return ExecOpResult.Yourself;
        }

        public bool ConfigurePlugin()
        {
            
            System.Windows.Forms.MessageBox.Show("CreateFolder config dialog");
            return true;
        }

        public bool SetAttributes(string remoteName, FileAttributes attr)
        {
            remoteName = remoteName.Substring(1);
            System.IO.File.SetAttributes(remoteName, attr); 
            return true;
        }

        public bool SetTime(string remoteName, DateTime creationTime, DateTime lastAccessTime,
            DateTime lastWriteTime)
        {
            // no change
            if (lastWriteTime == DateTime.MinValue) return true;

            remoteName = remoteName.Substring(1);

            // directory or file
            if (System.IO.Directory.Exists(remoteName))
            {
                System.IO.Directory.SetLastWriteTime(remoteName, lastWriteTime);
            }
            else
            {
                System.IO.File.SetLastWriteTime(remoteName, lastWriteTime);
            }
            return true;
        }

        #region --- private ---

        private bool isRoot(string path)
        {
            return path == "\\";
        }

        string[] drives;
        string[] dirs;
        string[] files;

        bool driveFinding;
        int returnIndex;

        private FindFileInfo GetDriveItem()
        {
            // not next
            if (returnIndex == drives.Length) return null;

            string info = drives[returnIndex++];

            return new FindFileInfo(info, FileAttributes.Directory);
        }

        private FindFileInfo GetFilesItem()
        {
            // its all
            if (returnIndex == dirs.Length + files.Length) return null;

            FileInfo info = new FileInfo(files[returnIndex - dirs.Length]);
            returnIndex++;

            FindFileInfo fi = new FindFileInfo(info.Name, info.Attributes);
            fi.Size = info.Length;
            fi.CreationTime = info.CreationTime;
            fi.LastAccessTime = info.LastAccessTime;
            fi.LastWriteTime = info.LastWriteTime;
            return fi;
        }


        private FindFileInfo GetDirs()
        {
            // if all dirs > files
            if (returnIndex >= dirs.Length) return GetFilesItem();

            DirectoryInfo info = new DirectoryInfo(dirs[returnIndex++]);

            FindFileInfo fi = new FindFileInfo(info.Name, info.Attributes);
            fi.CreationTime = info.CreationTime;
            fi.LastAccessTime = info.LastAccessTime;
            fi.LastWriteTime = info.LastWriteTime;


            return fi;
        }

        /// <summary>
        /// remove first + append last "\"
        /// </summary>
        /// <param name="path"></param>

        private void preparePath(ref string path)
        {
            path = path.Substring(1) + "\\";
        }

        #endregion






        #region IPlugin Members


        public bool Disconnect(string disconnectRoot)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        #endregion
    }
}
