using System;
using System.Text;

namespace MosTech.Nokia
{
    [Serializable]
    public struct Error : IComparable
    {
        /// <summary>skuten hodnota obdob jako short</summary>
        uint _value;

        public Error(uint value)
        {
            _value = value;
        }
        public Error(ErrorCode value)
        {
            _value = (uint)value;
        }
 
        public override int GetHashCode()
        {
            return this._value.GetHashCode();
        }

        public static implicit operator Error(uint value)
        {
            return new Error(value);
        }

        public static implicit operator uint(Error error)
        {
            return error.Value;
        }

        public static implicit operator Error(ErrorCode value)
        {
            return new Error((uint)value);
        }

        public static implicit operator ErrorCode(Error error)
        {
            return (ErrorCode)error.Value;
        }

        public static bool operator ==(Error error1, Error error2)
        {
            return error1._value == error2._value;
        }

        /// <summary>
        /// Implicitn opertor - nerovnost
        /// </summary>
        public static bool operator !=(Error error1, Error error2)
        {
            return error1._value != error2._value;
        }

        public uint Value
        {
            get { return this._value; }
            set { this._value = value; }
        }

        #region IComparable Members

        public int CompareTo(object obj)
        {
            if (obj is Error)
                return this.Value.CompareTo(((Error)obj).Value);

            if (obj is ErrorCode)
                return this.Value.CompareTo((uint)obj);

            return this.Value.CompareTo(obj);
        }

        public override bool Equals(object obj)
        {
            return CompareTo(obj) == 0;
        }

        #endregion
    }
}
