using System;
using System.Text;
using System.Runtime.InteropServices;
using MosTech.TotalCommander;
using CONNAPI;

namespace MosTech.Nokia
{
    public class NokiaBrowser : IPlugin
    {
        public NokiaBrowser()
        {
            FileSystem.Notify += new FileSystemEventHandler(FileSystem_Notify);
        }

        private bool isPhoneConnect = false;
        // NokiaFileManager nokia;

        DeviceManagement DM;
        DeviceInfo[] devices;


        #region IPlugin Members

        public string PluginName()
        {
            return "NokiaBrowser";
        }

        public void StatusInfo(string remoteDir, Status infoStatus, StatusOp infoOperation)
        {
            if (!isPhoneConnect)
            {
                DM = new DeviceManagement();
                devices = DM.GetDevices();
                isPhoneConnect = true;
            }
        }

        NokiaFindInfo currentFind;

        public FindFileInfo FindFirst(int searchIndex, string path)
        {
            currentFind = new NokiaFindInfo(path, devices);
            //  currentFind.Serial = GetDeviceByInternalName(currentFind.InernalPhoneName).SerialNumber;
            //   if (currentFind.CurrendFindType != FindType.Devices) currentFind.Items = nokia.GetItems(currentFind.PhonePath, currentFind.Serial);
            return currentFind.GetFindFileInfo();

            //   System.Windows.Forms.MessageBox.Show(currentFind.ToString() + " " + path);
            //switch (currentFind.CurrendFindType)
            //{
            //    case FindType.Devices: return currentFind.GetFindFileInfo();// return ReturnDevice();
            //    case FindType.Medias: return ReturnMedia();
            //    case FindType.FilesOrDirs: return ReturnMedia();
            //}
            //return null;
        }

        //private unsafe FindFileInfo ReturnMedia()
        //{
        //    return currentFind.GetFindFileInfo();

        //}

        //private FindFileInfo ReturnDevice()
        //{
        //    if (devices.Length == currentFind.FindIndex) return null;

        //    return new FindFileInfo(devices[currentFind.FindIndex++].Name, System.IO.FileAttributes.Directory);
        //}



        public FindFileInfo FindNext(int searchIndex)
        {
            return currentFind.GetFindFileInfo();
            //switch (currentFind.CurrendFindType)
            //{
            //    case FindType.Devices: return currentFind.GetFindFileInfo();//();
            //    case FindType.Medias: return ReturnMedia();
            //    case FindType.FilesOrDirs: return ReturnMedia();
            //}
            //return null;
        }

        public int FindClose(int searchIndex)
        {
            return 0;
        }

        public bool CreateDirectory(string dir)
        {
            NokiaFindInfo nfi = new NokiaFindInfo(dir, devices);
            return nfi.Device.FS.CreateFolder(nfi.PhonePath);
        }

        public bool RemoveDirectory(string dirName)
        {
            NokiaFindInfo nfi = new NokiaFindInfo(dirName, devices);
            return nfi.Device.FS.DeleteFolder(nfi.PhonePath, false);
        }

        public bool DeleteFile(string fileName)
        {
            NokiaFindInfo nfi = new NokiaFindInfo(fileName, devices);
            return nfi.Device.FS.DeleteFile(nfi.PhonePath);
        }

        public CopyOpResult RenameMoveFile(string oldName, string newName, bool move, bool overWrite)
        {
            NokiaFindInfo nfiold = new NokiaFindInfo(oldName, devices);
            NokiaFindInfo nfinew = new NokiaFindInfo(newName, devices);
            bool res = nfiold.Device.FS.RenameFile(nfiold.PhonePath, nfinew.PhonePath);

            return res ? CopyOpResult.Ok : CopyOpResult.NotFound;
        }

        public CopyOpResult GetFile(string remoteName, string localName, CopyFlags copyFlags)
        {
            toShow = localName;
            fromShow = remoteName;

            bool overwrite = (copyFlags & CopyFlags.Overwrite) == CopyFlags.Overwrite;
            bool move = (copyFlags & CopyFlags.Move) == CopyFlags.Move;

            // exist, so ask me, in second call
            if ((!overwrite) && (System.IO.File.Exists(localName)))
            {
                return CopyOpResult.Exists;
            }

            // move or copy
            NokiaFindInfo nfi = new NokiaFindInfo(remoteName, devices);

            bool result;

            if (move)
            {
                result = nfi.Device.FS.MoveFile(
                     CopyDirection.PhoneToPc,
                     nfi.PhonePath,
                     localName,
                     overwrite);
            }
            else
            {
                result = nfi.Device.FS.CopyFile(
                     CopyDirection.PhoneToPc,
                     nfi.PhonePath,
                     localName,
                     overwrite,
                     false);
            }
            if (result) return CopyOpResult.Ok;

            if (MosTech.Nokia.ErrorHelper.LastErrorCode == MosTech.Nokia.ErrorCode.Cancelled)
                return CopyOpResult.UserAbort;

            return CopyOpResult.NotFound;
        }

        public CopyOpResult PutFile(string localName, string remoteName, CopyFlags copyFlags)
        {
            NokiaFindInfo nfi = new NokiaFindInfo(remoteName, devices);

            fromShow = localName;
            toShow = remoteName;

            bool overwrite = (copyFlags & CopyFlags.Overwrite) == CopyFlags.Overwrite;
            bool move = (copyFlags & CopyFlags.Move) == CopyFlags.Move;
            bool result;
            try
            {
                if (move)
                {
                    result = nfi.Device.FS.MoveFile(
                       CopyDirection.PcToPhone,
                       localName,
                       nfi.PhonePath,
                       overwrite);
                }
                else
                {
                    result = nfi.Device.FS.CopyFile(
                        CopyDirection.PcToPhone,
                        localName,
                        nfi.PhonePath,
                        overwrite,
                        false);
                }
            }
            catch (Exception exc)
            {
                if (nfi.Device.FS.LastError == CONAPI_ERRORS.ECONA_FILE_ALREADY_EXIST) return CopyOpResult.Exists;
                throw new Exception("cant copy file", exc);
            }

            if (result) return CopyOpResult.Ok;

            if (MosTech.Nokia.ErrorHelper.LastErrorCode == MosTech.Nokia.ErrorCode.Cancelled)
                return CopyOpResult.UserAbort;

            return CopyOpResult.NotFound;
        }

        private string fromShow;
        private string toShow;

        

        void FileSystem_Notify(object sender, FileSystemEventArgs e)
        {
            bool abort = false;

            switch (e.Operation)
            {
                case FileSystemOperation.CopyFile:
                case FileSystemOperation.MoveFile:
                    abort = MtcManager.ProgressProc(e.OperationInfo, e.OperationInfo, e.Progress);
                    break;
            }

            e.Cancel = abort;

        }

        public ExecOpResult ExecuteFile(ref string remoteName, string verbs)
        {
            return ExecOpResult.Yourself;
        }

        public bool SetAttributes(string remoteName, System.IO.FileAttributes attr)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public bool SetTime(string remoteName, DateTime creationTime, DateTime lastAccessTime, DateTime lastWriteTime)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        public bool ConfigurePlugin()
        {
            throw new Exception("The method or operation is not implemented.");
        }

        #endregion



        // ------------------------------------------------------------------------------------------------------





        internal DeviceInfo GetDeviceByInternalName(string internalName)
        {
            return devices[0];
        }


        // ------------------------------------------------------------------------------------------------------



        #region IPlugin Members


        public bool Disconnect(string disconnectRoot)
        {
            throw new Exception("The method or operation is not implemented.");
        }

        #endregion
    }

    internal enum FindType
    {
        Devices,
        Medias,
        FilesOrDirs
    }

    internal class NokiaFindInfo
    {
        public NokiaFindInfo(string path, DeviceInfo[] devices)
        {
            m_findType = GetFindType(path);
            switch (m_findType)
            {
                case FindType.Devices:
                    _items = devices;
                    break;
                case FindType.Medias:
                    m_phonePath = "\\\\";
                    m_InernalPhoneName = path.Substring(1);
                    break;
                case FindType.FilesOrDirs:
                    string s = path.Substring(1);
                    int sep = s.IndexOf('\\');
                    m_InernalPhoneName = s.Substring(0, sep);
                    m_phonePath = "\\\\" + s.Substring(sep + 1);
                    break;
            }

            if (m_findType != FindType.Devices)
                foreach (DeviceInfo dev in devices)
                    if (dev.Name == m_InernalPhoneName)
                        m_device = dev;
        }


        public FindType CurrendFindType
        {
            get { return m_findType; }
            //set { m_findType = value; }
        }


        public string Serial
        {
            get { return m_serial; }
            set { m_serial = value; }
        }


        public string InernalPhoneName
        {
            get { return m_InernalPhoneName; }

        }


        public string PhonePath
        {
            get { return m_phonePath; }
        }

        public int FindIndex
        {
            get { return m_findIndex; }
            //set { m_findIndex = value; }
        }

        public DeviceInfo Device
        {
            get
            {
                if (m_findType == FindType.Devices) throw new Exception("Not implement for Device");
                return m_device;
            }
        }

        public override string ToString()
        {
            return m_findType.ToString() + ", " + m_InernalPhoneName + ", " + m_phonePath;
        }

        internal static FindType GetFindType(string path)
        {
            if (path == "\\")
            {
                return FindType.Devices;
            }

            if (path.Split('\\').Length == 2)
            {
                return FindType.Medias;
            }

            return FindType.FilesOrDirs;
        }







        FindType m_findType;
        string m_serial;
        string m_InernalPhoneName = "";
        string m_phonePath = "";
        int m_findIndex = 0;

        NokiaInfo[] _items;

        DeviceInfo m_device;



        public NokiaInfo[] Items
        {
            get { return _items; }
            //set { _items = value; }
        }

        internal FindFileInfo GetFindFileInfo()
        {
            if (_items == null)
            {
                _items = this.Device.FS.GetItems(this.PhonePath);
            }

            if (_items.Length == m_findIndex) return null;

            object o = _items[m_findIndex++];

            if (o is DirInfo)
                return new FindFileInfo(((DirInfo)o).Name, System.IO.FileAttributes.Directory);

            if (o is FileInfo)
            {
                FileInfo fi = o as FileInfo;
                //  System.IO.FileAttributes = System.IO.FileAttributes.Normal;

                FindFileInfo find = new FindFileInfo(fi.Name, System.IO.FileAttributes.Normal);
                find.Size = fi.FileSize;
                find.LastWriteTime = lhTime(fi.FileTime.dwLowDateTime, fi.FileTime.dwHighDateTime);
                return find;
            }

            DeviceInfo devInfo = o as DeviceInfo;
            return new FindFileInfo(devInfo.Name, System.IO.FileAttributes.Directory);

        }

        private DateTime lhTime(int low, int high)
        {
            if ((high == 0) && (low == 0)) return DateTime.MinValue;

            long l = high;
            l = l << 32;
            l += low;
            return DateTime.FromFileTime(l);
        }


    }

}
