/*
 * decompile.cpp
 *
 *  Created on: Jan 23, 2011
 *      Author: iubi
 */

#include <windows.h>

#include "decompile.h"
#include "cunicode.h"

// a way to get the HMODULE/HINSTANCE of current dll
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
// another way - make visible global var gHinst defined in listplug.cpp
extern HINSTANCE gHinst;

// TODO move the args in config file
#define JAD_CMD             L"jad\" -lnc -o -s \""
#define MAX_CMD_LEN         1024
#define CLASS_EXT           L".class"
#define JAVA_EXT            L".java"
#define DELETE_TMP_FILES    true

WCHAR gTmpFileName[12];


BOOL ExecuteCommand(WCHAR* cmd, const WCHAR* workingDir) {

    BOOL ret = false;
    STARTUPINFOW si;
    PROCESS_INFORMATION pi;

    ZeroMemory( &si, sizeof(si) );
    si.cb = sizeof(si);
    ZeroMemory( &pi, sizeof(pi) );

    ret = CreateProcessW(NULL, // No module name (use command line)
            cmd,               // Command line
            NULL,              // Process handle not inheritable
            NULL,              // Thread handle not inheritable
            FALSE,             // Set handle inheritance to FALSE
            CREATE_NO_WINDOW,  // No creation flags
            NULL,              // Use parent's environment block
            workingDir,        // Use parent's starting directory
            &si,               // Pointer to STARTUPINFO structure
            &pi);              // Pointer to PROCESS_INFORMATION structure

    if (ret == true) {
        WaitForSingleObject(pi.hProcess, INFINITE);
        CloseHandle(pi.hProcess);
        CloseHandle(pi.hThread);
    }

    return ret;
}

/*
 * If jad.exe exists in the same location with this dll then prefix dll path to jad command
 * otherwise do nothing (jad found on system PATH will be used)
 */
BOOL addJadPath(WCHAR* cmd, const WCHAR* dllPath) {

    WCHAR jad_file[MAX_PATH];

    wcscpy(jad_file, dllPath);
    wcscat(jad_file, L"\\jad.exe");

    // Check if jad.exe is in the same place as dll
    HANDLE f = CreateFileT(jad_file, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
    if (f != INVALID_HANDLE_VALUE) {
        // jad.exe exists in the same folder as dll -> add jad location (same as dll)
        wcscat(cmd, dllPath);
        wcscat(cmd, L"\\");
    }
    CloseHandle(f);

    return true;
}

/*
 * Creates a file with the decompiled java code
 */
BOOL decompile(const WCHAR* classPath, const WCHAR* classFileName) {

    WCHAR cmd[MAX_CMD_LEN];

    wcscpy(cmd, L"\"");

    // Add Jad path
    addJadPath(cmd, classPath);

    // Add jad command
    wcscat(cmd, JAD_CMD);

    // Add decompiled file extension
    wcscat(cmd, gTmpFileName);
    wcscat(cmd, JAVA_EXT);
    wcscat(cmd, L"\" \"");

    wcscat(cmd, classFileName);
    wcscat(cmd, L"\"");

    // Pass the class file path as working dir and pass only file name to jad in case
    // there are unicode chars in the path as jad doesn't handle unicode filenames
    return ExecuteCommand(cmd, classPath);
}

/*
 * Read the file content in a byte buffer and validate for non 0 bytes
 */
char* readFile(WCHAR* FileToLoad) {

    DWORD w2;

    HANDLE f = CreateFileT(FileToLoad, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);
    if (f == INVALID_HANDLE_VALUE) {
        return NULL;
    }

    int l = GetFileSize(f, NULL);
    char *pdata = (char*) malloc(l + 1);
    if (pdata) {
        ReadFile(f, pdata, l, &w2, NULL);
        if (w2 < 0) {
            w2 = 0;
        } else if (w2 > (DWORD) l) {
            w2 = l;
        }
        pdata[w2] = 0;

        // Make sure the file doesn't contain any 0x00 char!
        if (strlen(pdata) != w2) {
            free(pdata);
            pdata = NULL;
        }
    }
    CloseHandle(f);

    return pdata;
}

/*
 * Find the tmp decompiled java file - jad only uses class name as output so search for anything matching the unique extension we chose
 */
BOOL findDecompiledFile(WCHAR* rTmpJavaFile) {

    // Get current dir
    WCHAR dll_dir[MAX_PATH];
    GetModuleFileNameW((HINSTANCE) &__ImageBase, dll_dir, MAX_PATH);
    *wcsrchr(dll_dir, L'\\') = 0;

    // Get the decompiled file name pattern
    WCHAR fileName[MAX_PATH];
    wcscpy(fileName, dll_dir);
    wcscat(fileName, L"\\*.");
    wcscat(fileName, gTmpFileName);
    wcscat(fileName, JAVA_EXT);

    WIN32_FIND_DATAW findFileData;
    HANDLE hFind;

    hFind = FindFirstFileT(fileName, &findFileData);
    if (hFind == INVALID_HANDLE_VALUE) {
        return false;
    }
    wcscpy(rTmpJavaFile, dll_dir);
    wcscat(rTmpJavaFile, L"\\");
    wcscat(rTmpJavaFile, findFileData.cFileName);
    FindClose(hFind);

    return true;
}

/*
 * TODO figure out how to use jd-core to decompile; it supports latest java version (jad only supports up to java 1.4)
 */
char* DecompileJavaClass(WCHAR* FileToLoad) {

    WCHAR dll_dir[MAX_PATH];
    WCHAR tmp_class_file[MAX_PATH];
    WCHAR tmp_java_file[MAX_PATH];

    // Get dll dir
    GetModuleFileNameW(gHinst, dll_dir, MAX_PATH);
    *wcsrchr(dll_dir, '\\') = 0; // remove dll name

    // Get file the unique part of the temporary file extension as current time
    _itow(GetCurrentTime(), gTmpFileName, 10);

    // Copy original class file under dllDir as <current time>.class as jad doesn't handle unicode file names
    wcscpy(tmp_class_file, dll_dir);
    wcscat(tmp_class_file, L"\\");
    wcscat(tmp_class_file, gTmpFileName);
    wcscat(tmp_class_file, CLASS_EXT);
    CopyFileT(FileToLoad, tmp_class_file, FALSE);

    // Finally decompile the tmp class file
    decompile(dll_dir, gTmpFileName);

    // Find the tmp decompiled java file - jad only uses class name as output so search for anything matching the unique extension we've chosen
    findDecompiledFile(tmp_java_file);
    char *pdata = readFile(tmp_java_file);

    // Clean up tmp files
    if (DELETE_TMP_FILES) {
        DeleteFileT(tmp_class_file);
        DeleteFileT(tmp_java_file);
    }

    return pdata;
}
