/*
 * highlight.h
 *
 *  Created on: Jan 23, 2011
 *      Author: iubi
 */

#include <windows.h>
#include <richedit.h>
#include <stdio.h>

#include "highlight.h"


#define DEFAULT_FONT "Courier New"

#define KEYWORD_COLOR RGB(127, 0, 85)
#define STRING_COLOR RGB(0, 0, 192)
#define COMMENT_COLOR RGB(63, 127, 95)

#define DEFAULT_STYLE default_style
#define KEYWORD_STYLE keyword_style
#define STRING_STYLE string_style
#define COMMENT_STYLE comment_style

CHARFORMAT2 default_style;
CHARFORMAT2 keyword_style;
CHARFORMAT2 string_style;
CHARFORMAT2 comment_style;

//#define IUBI_SIGNATURE "/* plugin by eSandrei\n * decompiled by Jad: %4d ms\n * highlighted:       %4d ms\n * total load time:   %4d ms\n */"
#define IUBI_SIGNATURE "/* TC Jad Plugin 1.1 by eSandrei */"
#define STATS_TEXT "// Jad: %dms | Highlighted: %dms"
#define MAX_SIGNATURE 256
#define SIGNATURE_COLOR RGB(255, 128, 128)
#define SIGNATURE_STYLE signature_style
CHARFORMAT2 signature_style;

// should be a hash table but I build with MinGW and using gnu STL library makes the plugin incompatible with Total Commander
const char* keywords[] = {"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const",
		"continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float",
		"for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native",
		"new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super",
		"switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
const int keywordsCount = sizeof(keywords) / sizeof(char*);

int binarySearch(const char** arrayToSearch, int arraySize, const char* stringToFind)
{
	if(arrayToSearch == NULL || stringToFind == NULL || arraySize < 1)
	{
		return -1;
	}

	int low = 0;
	int high = arraySize - 1;
	int mid = (high - low) / 2;
	int compare = 0;

	while(low <= high)
	{
		if(arrayToSearch[mid] == NULL)
		{
			return -1;
		}
		compare = strcmp(stringToFind, arrayToSearch[mid]);
		if(compare < 0)
		{
			high = mid - 1;
		}
		else if(compare > 0)
		{
			low = mid + 1;
		}
		else
		{
			return mid;
		}
		mid = (low + high) / 2;
	}

	return -1;
}

int isKeyword(const char* word)
{
	return binarySearch(keywords, keywordsCount, word);
}

void initDefaultStyle()
{
	ZeroMemory(&default_style, sizeof(CHARFORMAT2));
	default_style.cbSize = sizeof(default_style);
	default_style.dwMask = CFM_BOLD | CFM_FACE | CFM_CHARSET;
	default_style.dwEffects = default_style.dwEffects & (~CFE_BOLD); // turn off bold flag
	default_style.bCharSet = DEFAULT_CHARSET;
	strncpy(default_style.szFaceName, DEFAULT_FONT, 32);
}

void initKeywordStyle()
{
	ZeroMemory(&keyword_style, sizeof(CHARFORMAT2));
	keyword_style.cbSize = sizeof(keyword_style);
	keyword_style.dwMask = CFM_BOLD | CFM_COLOR;
	keyword_style.dwEffects = CFE_BOLD;
	keyword_style.crTextColor = KEYWORD_COLOR;
}

void initStringStyle()
{
	ZeroMemory(&string_style, sizeof(CHARFORMAT2));
	string_style.cbSize = sizeof(string_style);
	string_style.dwMask = CFM_BOLD | CFM_COLOR ;
	string_style.dwEffects = string_style.dwEffects & (~CFE_BOLD); // turn off bold flag
	string_style.crTextColor = STRING_COLOR;
}

void initCommentStyle()
{
	ZeroMemory(&comment_style, sizeof(CHARFORMAT2));
	comment_style.cbSize = sizeof(comment_style);
	comment_style.dwMask = CFM_COLOR | CFM_BOLD;
	comment_style.dwEffects = comment_style.dwEffects & (~CFE_BOLD); // turn off bold flag
	comment_style.crTextColor = COMMENT_COLOR;
}

void initSignatureStyle()
{
	ZeroMemory(&signature_style, sizeof(CHARFORMAT2));
	signature_style.cbSize = sizeof(signature_style);
	signature_style.dwMask = CFM_COLOR | CFM_BOLD;
	signature_style.dwEffects = CFE_BOLD;
	signature_style.crTextColor = SIGNATURE_COLOR;
}

void initStyles()
{
	initDefaultStyle();
	initKeywordStyle();
	initStringStyle();
	initCommentStyle();
	initSignatureStyle();
}

void InitHighlightGlobals()
{
	// Initialize predefined styles
	initStyles();
}

void InsertTextLine(HWND hwnd, const char *szTextIn, CHARFORMAT2 cf)
{
	// insert the text
   char *Text = (char *)malloc(lstrlen(szTextIn) + 5);
   strcpy(Text, szTextIn);
   strcat(Text, "\r\n");
   SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)0, (LPARAM)(int)0);
   SendMessage(hwnd, EM_REPLACESEL, (WPARAM)(BOOL)FALSE, (LPARAM)(LPCSTR)Text);
   free(Text);

   // format the inserted text
   SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)0, (LPARAM)(int)strlen(szTextIn));
   SendMessage(hwnd, EM_SETCHARFORMAT, (WPARAM)(UINT)SCF_SELECTION, (LPARAM)&cf);

   // move cursor at the beginning of the text
   SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)0, (LPARAM)(int)0);
}

void AddTextLine(HWND hwnd, const char *szTextIn, CHARFORMAT2 cf)
{
   char *Text = (char *)malloc(lstrlen(szTextIn) + 5);

   // get text length
   GETTEXTLENGTHEX gtl;
   gtl.flags = GTL_PRECISE | GTL_NUMCHARS;
   gtl.codepage = 1200; // Unicode
   int iTotalTextLength = SendMessage(hwnd, EM_GETTEXTLENGTHEX, (WPARAM)&gtl, 0);

   int iStartPos = iTotalTextLength;
   int iEndPos;

   strcpy(Text, szTextIn);
   strcat(Text, "\r\n");

   SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)iTotalTextLength, (LPARAM)(int)iTotalTextLength);
   SendMessage(hwnd, EM_REPLACESEL, (WPARAM)(BOOL)FALSE, (LPARAM)(LPCSTR)Text);

   free(Text);

   iEndPos = SendMessage(hwnd, EM_GETTEXTLENGTHEX, (WPARAM)&gtl, 0);

   // Strange but GetWindowTextLength(hwnd) = text length but the selection does not work
   // I suspect end line might be the cause - \r+\n in windows
   // 5505 real length compared to 5370 that you can select and there are 136 lines (5506 - 5370 = 136)
   SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)iStartPos, (LPARAM)(int)iEndPos);
   SendMessage(hwnd, EM_SETCHARFORMAT, (WPARAM)(UINT)SCF_SELECTION, (LPARAM)&cf);
   SendMessage(hwnd, EM_HIDESELECTION, (WPARAM)(BOOL)TRUE, (LPARAM)(BOOL)FALSE);

   SendMessage(hwnd, EM_LINESCROLL, (WPARAM)(int)0, (LPARAM)(int)1);
}

void AddSignature(HWND hwnd, int decompileTime, int highlightingTime, int totalLoadTime)
{
	char stats_text[MAX_SIGNATURE];
	sprintf(stats_text, STATS_TEXT, decompileTime, highlightingTime);//, totalLoadTime);
	InsertTextLine(hwnd, stats_text, COMMENT_STYLE);

	InsertTextLine(hwnd, IUBI_SIGNATURE, SIGNATURE_STYLE);
}

void SetTextRangeStyle(HWND hwnd, CHARFORMAT2 cf, unsigned short start, unsigned short end)
{
    CHARRANGE cr;
    cr.cpMin = start;
    cr.cpMax = end;
    SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);

    SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf);
}

long HighlightUntilTextFound(HWND hwnd, long start, char* endText, CHARFORMAT2 cf)
{
	int endTextLength = strlen(endText);
	CHARRANGE cr;
	cr.cpMin = start + endTextLength;
	cr.cpMax = -1;

	FINDTEXT ft;
	ft.chrg = cr;
	ft.lpstrText = endText;

	// find end index
	cr.cpMax = (DWORD)SendMessage(hwnd, EM_FINDTEXT, (WPARAM)FR_DOWN, (LPARAM)&ft);
	if(cr.cpMax < 0)
	{
		cr.cpMax = GetWindowTextLength(hwnd);
	}
	// Mark text with given style
	cr.cpMin -= endTextLength;
	cr.cpMax += endTextLength;
	SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cf);

	return cr.cpMax;
}

void HighlightText(HWND hwnd)
{
	char word[128];
	long wordStart = 0;
	long wordBreak = SendMessage(hwnd, EM_FINDWORDBREAK, WB_MOVEWORDNEXT, wordStart);
	long wordLength = 0;
	char* firstSpace = NULL;
	long commentStart = 0;

	TEXTRANGE tr;
	tr.chrg.cpMin = wordStart;
	tr.chrg.cpMax = wordBreak;
	tr.lpstrText = word;

	while(SendMessage(hwnd, EM_GETTEXTRANGE, 0, (LPARAM)&tr) > 0)
	{
		// trim everything after first space
		firstSpace = strchr(word, ' ');
		if(firstSpace != NULL)
		{
			*firstSpace = 0;
			wordBreak = wordStart + strlen(word);
		}

		// TODO cauta prima aparitie in cuvant si trimite ala ca start in HighlightUntilTextFound
		wordLength = strlen(word);
		commentStart = strcspn(word, "/\"'");
		if(commentStart < wordLength)
		{
			if((*(word + commentStart) == '/') && (word + commentStart + 1) != NULL && (*(word + commentStart + 1) == '/'))
			{
				// if word contains //, format the rest of the line as comment and move to end of line
				wordStart = HighlightUntilTextFound(hwnd, wordStart + commentStart, (char*)"\r", COMMENT_STYLE);
			}
			else if((*(word + commentStart) == '/') && (word + commentStart + 1) != NULL && (*(word + commentStart + 1) == '*'))
			{
				// if word contains /*, format as comment until end of comment(*/) is found and move to end of comment
				wordStart = HighlightUntilTextFound(hwnd, wordStart + commentStart, (char*)"*/", COMMENT_STYLE);
			}
			else if(*(word + commentStart) == '"')
			{
				// if word contains ", format as string until next " is found and move there
				wordStart = HighlightUntilTextFound(hwnd, wordStart + commentStart, (char*)"\"", STRING_STYLE);
			}
			else if(*(word + commentStart) == '\'')
			{
				// if word contains ', format as string until next ' is found and move there
				wordStart = HighlightUntilTextFound(hwnd, wordStart + commentStart, (char*)"'", STRING_STYLE);
			}
			else
			{
				// in case we have a lonely /, we need to move on otherwise we loop infinitely
				wordStart = SendMessage(hwnd, EM_FINDWORDBREAK, WB_MOVEWORDNEXT, wordStart);
			}
		}
		else if(isKeyword(word) >= 0)
		{
			// keyword found so mark it accordingly and move to end of word
			SetTextRangeStyle(hwnd, KEYWORD_STYLE, wordStart, wordBreak);
			wordStart = SendMessage(hwnd, EM_FINDWORDBREAK, WB_MOVEWORDNEXT, wordStart);
		}
		else
		{
			// nothing to do move to next word
			wordStart = SendMessage(hwnd, EM_FINDWORDBREAK, WB_MOVEWORDNEXT, wordStart);
		}
		// find next word end
		wordBreak = SendMessage(hwnd, EM_FINDWORDBREAK, WB_MOVEWORDNEXT, wordStart);

		tr.chrg.cpMin = wordStart;
		tr.chrg.cpMax = wordBreak;
	}
}

/*
 * Highlight the text using Richedit functions - complicated but I wanted to play with the control
 *
 * TODO simplify this method:
 * 		- get the window text in a char array and parse it for comments, strings and keywords
 * 		  the parsing should return a list of structures containing startIndex, endIndex and style (comment, string or keyword)
 * 		- for each structure call SetTextRangeStyle(hwnd, style, startIndex, endIndex)
 */
void HighlightWindowText(HWND hwnd)
{
	// Set default style to all text
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_ALL, (LPARAM)&DEFAULT_STYLE);

	// just to test
//	AddTextLine(hwnd, "\"zzz\"", DEFAULT_STYLE);
//	AddTextLine(hwnd, "\" zzz \"", DEFAULT_STYLE);
//	AddTextLine(hwnd, " \"zzz\"\"zzz\" ", DEFAULT_STYLE);
//	AddTextLine(hwnd, "/**/zzz ", DEFAULT_STYLE);
//	AddTextLine(hwnd, "'zzz'", DEFAULT_STYLE);
//	AddTextLine(hwnd, " org/eclipse/jdt/internal/core/BufferManager ", DEFAULT_STYLE);

	// now highlight the window's text
	HighlightText(hwnd);

	// set cursor at the beginning of text
	SendMessage(hwnd, EM_SETSEL, (WPARAM)(int)0, (LPARAM)(int)0);
}
