#Region ;**** Directies created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=TCMetadataViewer.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Can only be used with ExifTool by Phil Harvey. Discussion in Total Commander forum <http://www.ghisler.ch/board/index.php>.
#AutoIt3Wrapper_Res_Description=Addon for filemanager Total Commander for viewing metadata using external tools ExifTool and IrfanView/NConvert/ImageMagick
#AutoIt3Wrapper_Res_Fileversion=2.0.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright (c) 2013 van Dusen
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_Field=ProductName|TCMetadataViewer
#AutoIt3Wrapper_Res_Field=ProductVersion|2.0 (2013-12-08)
#AutoIt3Wrapper_Res_Field=OriginalFilename|TCMetadataViewer.exe
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include-once

#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <Constants.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <ListBoxConstants.au3>
#include <ComboConstants.au3>

#include <GuiListView.au3>
#include <GuiListBox.au3>
#include <Array.au3>
#include <File.au3>
#include <WinAPI.au3>
#include <_XMLDomWrapper.au3>

AutoItSetOption("WinTitleMatchMode", 4)
AutoItSetOption("CaretCoordMode", 1)
AutoItSetOption("GUIOnEventMode", 1)

Const $cstrTCMetadataViewerVersion = "TCMetadataViewer 2.0 (2013-12-08)" ;Bei nderungen ebenfalls anzupassen (Threadtitel im Benutzerforum): Func About()
Const $cstrTmpPath = @TempDir & "\"
Const $cstrTmpFile = @TempDir & "\TCMetadataViewer"
Const $cstrArgFile = @TempDir & "\TCMetadataViewer_ArgFile.txt"
Const $cstrIniFile = @ScriptDir & "\TCMetadataViewer.ini"
Const $cstrIcoDir = @ScriptDir & "\TCMetadataViewer_Icons"
Const $cstrNullString = "-" ;NullString suggestions: |_|-|||||#nv|
Const $cstrWriteLog1 = "~~~~~~~~~~~|ChangeDir|ConvertIPTCTagsToUTF8|DeleteMetadata|DeleteSelectedTags|ExecArgFile|FileCopy|FileMove|LosslessJPGOperation|PackJPG|ProgramExit|ProgramStart|RestartExifTool|RunExifTool|SaveMetadata|SaveSyncSelectedTags|SaveSyncSelectedFiles|SetXMPDaylightSavings|SetXMPLabel|SetXMPRating|ShiftDateTime|ShutdownExifTool|StartUpExifTool|UnPackJPG"

Global $strExifToolVersion = "", $strExifToolErr = "", $pidExifTool
Global $hndTCActivePanel, $intTCInactivePanelW, $intTCInactivePanelH, $intTCInactivePanelX, $intTCInactivePanelY, $intTCInactiveFooterH, $arrTCMainWinPosMem[4], $intTCRPanelWMem, $intTCRPanelHMem
Global $strClassnameTCActivePath
Global $strTCFilepathCurShort, $strTCPathInactive
Global $strTCPathCur, $strTCFileCur, $strTCExtCur, $strTCPathCurOri, $strTCFileCurOri
Global $strTCPathMem, $strTCFileMem, $strTCExtMem, $strTCPathMemOri, $strTCFileMemOri
Global $strSourceFile, $strTargetFile, $intLvwSyncSelectedFilesItemIdx
Global $booFileIsValid = True, $booFileIsModified = False, $booUnicodeFilename = False
$strTCFileTmp = ""
Global $intBtnTagGroupCompositeState, $intBtnTagGroupEXIFState, $intBtnTagGroupFileState, $intBtnTagGroupIPTCState, $intBtnTagGroupXMPState, $intBtnTagGroupMakerNotesState, $intBtnListRegionsState, $intBtnViewPreviewImageState, $intBtnViewThumbnailImageState
Global $intPicW, $intPicH, $intImgW, $intImgH, $intImgPreW, $intImgPreH, $intScaleImg
Global $arrTagList, $arrTagListCustom, $arrTagCustNamList, $arrCustomTags
Global $strCustomView = "CustomView_Default", $strCustomTagsDrilledDown = ""
Global $strTagFilter = "All", $strTagFilterMem = "All", $strTagSearchFor= "", $arrTagSearchFor, $strDateTimeOriginal = "", $booDaylightSavingsExists = False
Global $fltXMPRatingOld, $intXMPRatingOld, $intXMPRatingState = $GUI_HIDE, $intXMPLabelState = $GUI_HIDE, $intMoveCursorDirection = 1
Global $strXMPLabel, $strXMPLabelColor, $strDescriptIon, $strGPSPosition = "" ;, $strGPSDirection = ""
Global $strBGColor, $strBGColorActiveControls, $strBGColorInactiveControls
Global $booRefresh = False, $booRefreshGUI = False, $booRefreshQuickviewImage = False, $booRefreshMetadataOnly = False, $booFirstRefresh = True, $booMagnify = False
Global $intXMLTagDBOpen = 0, $intFileIsSavableTrue = 0
Dim $arrXMLTagDBAttrNam[1], $arrXMLTagDBAttrVal[1], $arrXMLTagDBNode
Global $arrCategoriesKeywordsPersons, $booEditTagQuickfilter = False, $strListBoxHeaderIndicator
Global $arrButtons[7][2]
Global $strTexteditorFileToOpen
Global $strArgFileEncoding = "UTF8", $fhArgfile
Global $strListviewItemClipboardIDList, $strListviewItemClipboardCheckmarks, $strListviewItemSyncSelectedFilesIDList
Global $lblRegionRectangle, $frmRectangle, $booEditTagStruct = False, $xcrop, $ycrop, $wcrop, $hcrop, $intImgWOri, $intImgHOri, $intImgOrient = 0

$fhArgfile = FileOpen($cstrArgFile, 2+256)      ;*** UTF8-codiertes *ARGFILE* leer anlegen
FileClose($fhArgfile)

If Not FileExists($cstrIniFile) Then
	$strErrMsg = "Configuration file" & @LF & $cstrIniFile & @LF & "not found!" & @LF & @LF
	$strErrMsg &= $cstrTCMetadataViewerVersion & " will work even so (provided that ExifTool.exe can be found)," & @LF
	$strErrMsg &= "but it is recocommended to make a complete configuration file available in order to benefit from all features." & @LF & @LF
	$strErrMsg &= "Continue anyhow?"
	If MsgBox(4+48+262144, $cstrTCMetadataViewerVersion, $strErrMsg) = 7 Then Exit
EndIf

AutoItSetOption("ExpandEnvStrings", 1)

$strTmp = "%COMMANDER_PATH%\TotalCmd.exe"
$strTotalCommanderPath = $strTmp
$strTmp = "%COMMANDER_INI%"
$strTCMainIni = $strTmp
$strTmp = IniRead($strTCMainIni, "Configuration", "RedirectSection", "")
If $strTmp = "" Then
	$strTCConfigurationIni = $strTCMainIni
Else
	$strTCConfigurationIni = $strTmp
EndIf

$arrIniSectionNames = IniReadSectionNames($cstrIniFile)

$strTmp = IniRead($cstrIniFile, "Configuration", "ExifToolPath", "ExifTool.exe")
$strExifToolPath = $strTmp
$strTmp = IniRead($cstrIniFile, "Configuration", "ImageConverterPath", "")
$strImageConverterPath = $strTmp
$strTmp = IniRead($cstrIniFile, "Configuration", "ImageConverterIniPath", "")
$strImageConverterIniPath = $strTmp
$strTmp = IniRead($cstrIniFile, "Configuration", "ImageViewerPath", "")
$strImageViewerPath = $strTmp
$strImageViewer = ""
$strTmp = IniRead($cstrIniFile, "Configuration", "PackJPGPath", "")
$strPackJPGPath = $strTmp
$strTmp = IniRead($cstrIniFile, "Configuration", "MPOToolBoxPath", "")
$strMPOToolBoxPath = $strTmp
$strTmp = IniRead($cstrIniFile, "Configuration", "TexteditorPath", "")
$strTexteditorPath = $strTmp

AutoItSetOption("ExpandEnvStrings", 0)

$strTotalCommanderPath = _PathFull($strTotalCommanderPath)
$strTCConfigurationIni = _PathFull($strTCConfigurationIni)
$strExifToolPath = _PathFull($strExifToolPath)
If $strImageConverterPath <> "" Then $strImageConverterPath = _PathFull($strImageConverterPath)
If $strImageViewerPath <> "" Then
	$strImageViewerPath = _PathFull($strImageViewerPath)
	$p = StringInStr($strImageViewerPath, "\", 0, -1)
	$strImageViewer = StringMid($strImageViewerPath, $p+1)
	$strImageViewerPath = $strImageViewerPath
Else
	$strImageViewer = "ShellExecute"
EndIf
If $strPackJPGPath <> "" Then $strPackJPGPath = _PathFull($strPackJPGPath)
$booViewPJG = False
If $strMPOToolBoxPath <> "" Then $strMPOToolBoxPath = _PathFull($strMPOToolBoxPath)
$booViewMPO = False
If $strTexteditorPath <> "" Then $strTexteditorPath = _PathFull($strTexteditorPath)

$strTCProductVersion = FileGetVersion($strTotalCommanderPath, "ProductVersion")

;*** GetTextMode=0 (Space-delimited) = Fehlwert bis TC8.0.beta23
If $strTCProductVersion < "8.0" Then
	$intTCGetTextMode = IniRead($strTCConfigurationIni, "Configuration", "GetTextMode", 0) * 1
;*** GetTextMode=1 (tab-delimited) = Fehlwert ab TC8.0.beta24
Else
	$intTCGetTextMode = IniRead($strTCConfigurationIni, "Configuration", "GetTextMode", 1) * 1
EndIf

;*** GetTextMode (Delimiter): 0: space;  1: tab;  2=<cr>;  3=<cr><lf>;  4=like 2;  5=like 3. 4&5 show fields with column headers (tab-separated), e.g. Name:<tab>Filename<cr>Size:<tab>10k (32/64)
Switch $intTCGetTextMode
	Case 0
		$strTCGetTextModeDelim = " "
	Case 1
		$strTCGetTextModeDelim = @TAB
	Case 2, 4
		$strTCGetTextModeDelim = @CR
	Case 3, 5
		$strTCGetTextModeDelim = @CRLF
EndSwitch

If $intTCGetTextMode = 0 Then
	;*** In Ansicht "Lang" werden Name, Erw., Grsse, Datum, Attr. jeweils durch ein Leerzeichen voneinander getrennt
	;*** Ist SizeStyle = 0 (Grenanzeige: Bytes), dann trennt das viertletzte Leerzeichen den Namen vom Rest
	;*** Ist SizeStyle > 0 (Grenanzeige: kBytes oder dynamisch), dann trennt das *fnftletzte* Leerzeichen den Namen vom Rest,
	;*** da die Gre mit Einheit (z.B. "k" oder "M") ausgegeben wird, wobei diese vom Gren-Wert durch ein (also zustzliches) " " getrennt wird
	;*** Diese Logik versagt, wenn
	;***  in der <WCMD_{lng}.LNG> die Keys 1450="b", 1451="k", 1452="M", 1453="G" manipuliert wurden und die Strings zustzliche " " enthalten
	;***  eine Lokalisierung aktiv ist, bei der die Datums-/Uhrzeitkomponenten mit " " statt z.B. ".|-|/|:" separiert werden und/oder " " als Tausender-Trennzeichen in der Grenangabe fungiert
	$intTCFNameDelimPosInFullView = IniRead($strTCConfigurationIni, "Configuration", "SizeStyle", 0) * 1
	If $intTCFNameDelimPosInFullView = 0 Then
		$intTCFNameDelimPosInFullView = -4
	Else
		$intTCFNameDelimPosInFullView = -5
	EndIf
EndIf


$strImageConverter = IniRead($cstrIniFile, "Configuration", "ImageConverter", "")
$strImageConvertMode = "NOP"
$strBGColor = IniRead($cstrIniFile, "Configuration", "BGColor", "0x404040")
$strBGColorActiveControls = IniRead($cstrIniFile, "Configuration", "BGColorActiveControls", "0xEBEADB")
$strBGColorInactiveControls = IniRead($cstrIniFile, "Configuration", "BGColorInactiveControls", "0x909090")
;~ $cstrNullString = IniRead($cstrIniFile, "Configuration", "NullString", "-")
$strTCQuickviewPanel = IniRead($cstrIniFile, "Configuration", "TCQuickviewPanel", "Right")
$intPanelDivider = IniRead($cstrIniFile, "Configuration", "PanelDivider", 50) * 1
Dim $intLvwTagsColWidthTag[4]
$intLvwTagsColWidthTag[0] = IniRead($cstrIniFile, "Configuration", "ColumnWidthTagGrp", -1) * 1
$intLvwTagsColWidthTag[1] = IniRead($cstrIniFile, "Configuration", "ColumnWidthTagID", -1) * 1
$intLvwTagsColWidthTag[2] = IniRead($cstrIniFile, "Configuration", "ColumnWidthTagNam", -1) * 1
$intLvwTagsColWidthTag[3] = IniRead($cstrIniFile, "Configuration", "ColumnWidthTagVal", -1) * 1
$intLvwTagsColAlignTagNam = IniRead($cstrIniFile, "Configuration", "ColumnAlignTagNam", 0) * 1
$intShowImageTitle = IniRead($cstrIniFile, "Configuration", "ShowImageTitle", 1) * 1
$intShowXMPDaylightSavings = IniRead($cstrIniFile, "Configuration", "ShowXMPDaylightSavings", 1) * 1
$intMoveCursorToNextFileAfterSetXMPTimezone = IniRead($cstrIniFile, "Configuration", "MoveCursorToNextFileAfterSetXMPTimezone", 0) * 1
$strLayoutXMPRating = IniRead($cstrIniFile, "Configuration", "LayoutXMPRating", "Boxes")
$intMoveCursorToNextFileAfterSetXMPRating = IniRead($cstrIniFile, "Configuration", "MoveCursorToNextFileAfterSetXMPRating", 0) * 1
$intShowXMPLabel = IniRead($cstrIniFile, "Configuration", "ShowXMPLabel", 1) * 1
$intMoveCursorToNextFileAfterSetXMPLabel = IniRead($cstrIniFile, "Configuration", "MoveCursorToNextFileAfterSetXMPLabel", 0) * 1
$intAllowMultLabel = IniRead($cstrIniFile, "Configuration", "AllowMultLabel", 0) * 1
$intListviewFontSize = IniRead($cstrIniFile, "Configuration", "ListviewFontSize", 8.5) * 1
$intListviewFontWeight = IniRead($cstrIniFile, "Configuration", "ListviewFontWeight", 400) * 1
$strListviewFontName = IniRead($cstrIniFile, "Configuration", "ListviewFontName", "Segoe UI")
$strListBoxHeaderIndicator = StringToUTF8(IniRead($cstrIniFile, "Configuration", "ListBoxHeaderIndicator", ""))
$intUpdateMetadataDate = IniRead($cstrIniFile, "Configuration", "UpdateMetadataDate", 0) * 1
$intWriteLog = IniRead($cstrIniFile, "Configuration", "WriteLog", 1) * 1
If $intWriteLog > 0 Then $fhLog = FileOpen(@ScriptDir & "\TCMetadataViewer.log", 1+128)
$intDelayOnExit = IniRead($cstrIniFile, "Configuration", "DelayOnExit", 0) * 1

WriteLog("~~~~~~~~~~~", "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
WriteLog("ProgramStart", $cstrTCMetadataViewerVersion) ;*** Vorher nicht mglich, da Voraussetzung ist, dass $intWriteLog ermittelt und $fhLog initialisiert ist

;bookmark
$intUseSidecarFile = IniRead($cstrIniFile, "Configuration", "UseSidecarFile", 0) * 1
$strSidecarFileType = IniRead($cstrIniFile, "Configuration", "SidecarFileType", "mie")

$strGeoService = IniRead($cstrIniFile, "Configuration", "GeoService", "GoogleMaps")

;*** Tag-Namen und -IDs knnen in den Metadaten *mehrfach* auftreten (z.B. Angabe "Zuletzt gespeichert am / von" in MS-Office-Dokumenten),
;*** - in den CustomViews wird aber nur das jeweils erste Auftreten des konfigurierten Tags ausgegeben. Welche "Instanz" des Tags dies ist, hngt davon ab,in welcher
;***   Reihenfolge ExifTool die Tags ausgibt. Diese Reihenfolge variiert je nach Option. So kann z.B. fr Tag "LastSavedBy" bei TagNam="Name" zuerst "Anton" und dann
;***   "Otto" ausgegeben werden, bei TagNam="Desc" aber umgekehrt. Wenn TagNam="Name", dann wird in einem CustView "Anton" angezeigt, da der Tag-Wert aus der sequentiell
;***   vom ersten zum letzten Element durchsuchten internen Tabelle $arrTagList ermittelt wird; beim "DrillDown" wird ExifTool mit Option --a (keine Duplikate) auf-
;***   gerufen. ExifTool gibt in diesem Fall "Otto" aus.
$strOptDup = "--a"
If IniRead($cstrIniFile, "Configuration", "AllowDuplicateTagNames", 0) * 1 = 1 Then $strOptDup = "-a"

;*** Versionsnummer von packJPG ermitteln
$strPackJPGVer = ""
If $strPackJPGPath <> "" Then
	WriteLog("GetPackJPGVer", $strPackJPGPath)
	$pidPackJPG = Run(@ComSpec & ' /S /c ""' & $strPackJPGPath & '""', "", @SW_HIDE, $STDOUT_CHILD)
	While 1
		$strPackJPGVer &= StdoutRead($pidPackJPG)
		If @error Then ExitLoop
	Wend
	ProcessWaitClose($pidPackJPG)
	$p = StringInStr($strPackJPGVer, " v")
	$strPackJPGVer = StringTrimLeft($strPackJPGVer, $p)
	$p = StringInStr($strPackJPGVer, " <--")
	$strPackJPGVer = StringLeft($strPackJPGVer, $p-1)
EndIf


#Region Sprachuntersttzung --------------------------------------------------------
$strExifToolCharEnc = IniRead($cstrIniFile, "Configuration", "ExifToolCharacterEncoding", "Latin")
$strExifToolLang = IniRead($cstrIniFile, "Configuration", "ExifToolLang", "en")

;*** Fehlwert: Englisch (intern)
Global $arrLocStr[144]
$arrLocStr[0]=UBound($arrLocStr)-1
$arrLocStr[1]='%n not found in configured path\n%p'
$arrLocStr[2]='Image viewer'
$arrLocStr[3]='Text editor'
$arrLocStr[4]='Creating/updating TCMetadataViewer_ExifTool_WritableExts.txt\nBe patient, please...'
$arrLocStr[5]='Creating/updating TCMetadataViewer_ExifTool_XMLTagDB.xml\nBe patient, please...'
$arrLocStr[6]='Show QuickView of image: %n (high quality, slower)'
$arrLocStr[7]='View image with %n'
$arrLocStr[8]='Play audio note on image'
$arrLocStr[9]='Lossless operation: Optimize JPG'
$arrLocStr[10]='Lossless operation: Rotate JPG by 90'
$arrLocStr[11]='Lossless operation: Rotate JPG by 180'
$arrLocStr[12]='Lossless operation: Rotate JPG by -90'
$arrLocStr[13]='Lossless operation: Auto-Rotate JPG according to EXIF info'
$arrLocStr[14]='Thumbnail-Image'
$arrLocStr[15]='Preview-Image'
$arrLocStr[16]=' view with %n'
$arrLocStr[17]=' save to file...'
$arrLocStr[18]=' delete from file'
$arrLocStr[19]='Show QuickView of image: Standard (low quality, faster)'
$arrLocStr[20]='OrigDate'
$arrLocStr[21]='Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec'
$arrLocStr[22]='Rating'
$arrLocStr[23]='Label'
$arrLocStr[24]='Desc'
$arrLocStr[25]='User'
$arrLocStr[26]='Search'
$arrLocStr[27]='All'
$arrLocStr[28]='Cust'
$arrLocStr[29]='Thumb'
$arrLocStr[30]='Preview'
$arrLocStr[31]='Group'
$arrLocStr[32]='' ;*** unbelegt
$arrLocStr[33]='' ;*** unbelegt
$arrLocStr[34]='' ;*** unbelegt
$arrLocStr[35]='' ;*** unbelegt
$arrLocStr[36]='Name'
$arrLocStr[37]='' ;*** unbelegt
$arrLocStr[38]='' ;*** unbelegt
$arrLocStr[39]='Value'
$arrLocStr[40]='Source'
$arrLocStr[41]='Target'
$arrLocStr[42]='Tag grouping: "Type"'
$arrLocStr[43]='Tag grouping: "Specific Location"'
$arrLocStr[44]='Tag grouping: "Category"'
$arrLocStr[45]='Tag names: Names'
$arrLocStr[46]='Tag names: Localized descriptions'
$arrLocStr[47]='Tag values: Literal'
$arrLocStr[48]='Tag values: Numeric'
$arrLocStr[49]='Reset display options'
$arrLocStr[50]='Export tags: Create textfile...'
$arrLocStr[51]='Export tags: Create XMP sidecar file...'
$arrLocStr[52]='Export tags: Create ExifTool XMP file...'
$arrLocStr[53]='Export tags: Create MIE file...'
$arrLocStr[54]='Compare tags with...'
$arrLocStr[55]='Remove all metadata from file'
$arrLocStr[56]='Write UTF-8-coded values only, if tag contains non-ANSI chars' ;*** gendert mit V1.3
$arrLocStr[57]='Always write UTF-8-coded values' ;*** gendert mit V1.3
$arrLocStr[58]='Allow duplicate tag names' ;*** gendert mit V1.2
$arrLocStr[59]='Add user-defined XML tag...'
$arrLocStr[60]='Backup file when writing'
$arrLocStr[61]='Edit configuration file'
$arrLocStr[62]='About...'
$arrLocStr[63]='Ready'
$arrLocStr[64]='ReadTags'
$arrLocStr[65]='SpecTags'
$arrLocStr[66]='HQPrev'
$arrLocStr[67]='ImgDim'
$arrLocStr[68]='Filter'
$arrLocStr[69]='Edit metadata'
$arrLocStr[70]='Remove tag from "Cust" view [%custview]'
$arrLocStr[71]='Add tag to "Cust" view [%custview]'
$arrLocStr[72]='View binary extracted tag value in hex mode'
$arrLocStr[73]='change'
$arrLocStr[74]='delete'
$arrLocStr[75]='Save'
$arrLocStr[76]='Cancel'
$arrLocStr[77]='Enter search term'
$arrLocStr[78]='Ignored (File does not exist)'
$arrLocStr[79]='Ignored (Directory)'
$arrLocStr[80]='Filetype not supported (File extension found in TCMetadataViewer.ini/[FileExtensionsUnsupported])'
$arrLocStr[81]='%n tags of %m tags imported to listview.\n\nAdd more tags?'
$arrLocStr[82]='Error on writing metadata'
$arrLocStr[83]='Lossless JPG operation:\nAt least one instance of %n is running.\nAll instances of %n would be closed automatically!\n\nPerform the lossless JPG operation anyway?'
$arrLocStr[84]='Remove metadata: %m\n\nReally remove these metadata from file\n%n?'
$arrLocStr[85]='Su|Mo|Tu|We|Th|Fr|Sa'
$arrLocStr[86]="Sorry, can't perform operation on file with Unicode filename"
$arrLocStr[87]='copy'
$arrLocStr[88]='move'
$arrLocStr[89]="append"
$arrLocStr[90]="only specified"
$arrLocStr[91]='All selected files'
$arrLocStr[92]="only if tag doesn't exists"
$arrLocStr[93]="only if tag content is equal"
$arrLocStr[94]='Save changes (tag %EditTagGrpNam %EditTagAction) to %FileIsSavableTrue valid files (out of %FileIsSavableTrue+%FileIsSavableFalse selected/focussed entries)?'
$arrLocStr[95]='WorkingDir:'
$arrLocStr[96]="%FileIsSavableFalse entries have been excluded (can't be edited):"
$arrLocStr[97]='Show GPS position in %GeoService'
$arrLocStr[98]='Executed successfully:'
$arrLocStr[99]='%ok files could be edited:'
$arrLocStr[100]='Execute ExifTool with arguments from an *.args file...'
$arrLocStr[101]='Delete tags: All IPTC tags'
$arrLocStr[102]='Delete tags: All XMP tags'
$arrLocStr[103]='' ;*** unbelegt
$arrLocStr[104]='Date/Time Shift'
$arrLocStr[105]='Shift Date/Time values of these tags by %hours hour(s)?'
;*** Kontextmen Image
$arrLocStr[106]='Show QuickView of image: None'
$arrLocStr[107]='Show QuickView of image: Thumbnail'
$arrLocStr[108]='Brighten quickview image'
;*** Kontextmen Listview
$arrLocStr[109]='Selected Tags: Copy => Clipboard'
$arrLocStr[110]='Selected Tags: Paste <= Clipboard...'
$arrLocStr[111]='Selected Tags: Copy from file...'
$arrLocStr[112]='Selected Tags: Delete...'
$arrLocStr[113]='Selected Tags: Synchronize...'
$arrLocStr[114]='Use "sidecar" file (*.%ext)'
;*** CompareTags-Hinweisdialog
$arrLocStr[115]='CompareTags'
$arrLocStr[116]='Left:'
$arrLocStr[117]='Right:'
;*** SyncSelectedFiles-Dialog
$arrLocStr[118]='Select all files'
$arrLocStr[119]='Unselect all files'
$arrLocStr[120]='Synchronize new tags'
$arrLocStr[121]='Synchronize unequal tags'
$arrLocStr[122]='Synchronize obsolete tags'
$arrLocStr[123]='Validating file %NumCur / %NumTot & ...'
$arrLocStr[124]='Comparing tags for file %NumCur / %NumTot & ...'
$arrLocStr[125]='Synchronizing tags for file %NumCur / %NumTot: %File...'
$arrLocStr[126]='*** Skipped>'
$arrLocStr[127]='*** Done>'
$arrLocStr[128]='*** Error>'
$arrLocStr[129]='Sync'
$arrLocStr[130]='Close'
;*** SyncSelectedTags-Dialog
$arrLocStr[131]='Nothing to paste - Clipboard is empty'
$arrLocStr[132]='Select all tags'
$arrLocStr[133]='Unselect all tags'
$arrLocStr[134]='Select all new tags'
$arrLocStr[135]='Select all unequal tags'
$arrLocStr[136]='Select all obsolete tags'
$arrLocStr[137]='Restore selection'
$arrLocStr[138]='Nothing to do - No tag is selected'
;*** RegionInfoMP
$arrLocStr[139]='[New region]'
$arrLocStr[140]='Name of the new region'
$arrLocStr[141]='Apply region information?'
$arrLocStr[142]='Delete region information?'
$arrLocStr[143]='Region is completely arranged outside the image!'

;*** Sprache aus INI-Datei ermitteln
$strLanguage = IniRead($cstrIniFile, "Configuration", "Language", "AutoDetect")
If $strLanguage = "AutoDetect" And WinExists("[CLASS:TTOTAL_CMD]") Then
	$strTmp = IniRead(EnvGet("COMMANDER_INI"), "Configuration", "LanguageIni", "Wcmd_ENG.lng")
	$strTmp = StringSplit(StringMid($strTmp, StringInStr($strTmp, "_", 0, -1) + 1), "._-")
	$strLanguage = StringUpper($strTmp[1])
	$strTmp = ""
EndIf

;*** Prfen, ob die INI-Section zur konfigurierten bzw. automatisch ermittelten Sprache existiert
$strTmp = IniReadSection($cstrIniFile, $strLanguage)

;*** Wenn die Sprach-INI-Section nicht existiert, dann Fehlermeldung ausgeben (Fehlwert Englisch (intern) wird verwendet)
If @error = 1 Then
	$strErrMsg = "Can't apply localized strings for language [" & $strLanguage & "]," & @LF
	$strErrMsg &= "because section [" & $strLanguage & "] is not found in TCMetadataViewer.ini!" & @LF
	$strErrMsg &= "Default language [ENG (internal)] is used instead." & @LF & @LF
	MsgBox(64+262144, $cstrTCMetadataViewerVersion, $strErrMsg)

;*** Wenn die Sprach-INI-Section existiert, dann lokalisierte Strings aus INI bernehmen
Else
	For $i = 1 To UBound($arrLocStr)-1
		$arrLocStr[$i] = IniRead($cstrIniFile, $strLanguage, $i, $arrLocStr[$i])
	Next
EndIf

For $i = 1 To UBound($arrLocStr)-1
	$arrLocStr[$i] = StringReplace($arrLocStr[$i], "\n", @LF)
	$arrLocStr[$i] = StringToUTF8($arrLocStr[$i])
Next
$strTmp = ""
#EndRegion -------------------------------------------------------------------------

$strErrMsg = ""

If Not FileExists($strExifToolPath) Then
	$strErrMsg = StringReplace($arrLocStr[1], "%p", $strExifToolPath)
	$strErrMsg = StringReplace($strErrMsg, "%n", "ExifTool")
	MsgBox(16+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
	Exit
EndIf

$strImageConverterVersion = ""
$intExifRotate = 0
$intImageConverterUnicodeSupport = 0
If $strImageConverterPath <> "" Then
	If Not FileExists($strImageConverterPath) _
	Or (($strImageConverter = "IrfanView" Or $strImageConverter = "ImageMagick") And Not FileGetVersion($strImageConverterPath, "ProductName") = $strImageConverter) Then
		$strErrMsg = StringReplace($arrLocStr[1], "%p", $strImageConverterPath & @LF & '(ProductName="' & FileGetVersion($strImageConverterPath, "ProductName") & '")')
		$strErrMsg = StringReplace($strErrMsg, "%n", $strImageConverter)
		$strImageConverterPath = ""

	Else
		Switch $strImageConverter

			Case "IrfanView"
;~ 				$p = StringInStr($strImageConverterPath, "\", 1, -1)
;~ 				$intExifRotate = IniRead(StringLeft($strImageConverterPath, $p) & "i_view32.ini", "JPEG", "ExifRotate", 0) * 1
;~ 				$intImageConverterUnicodeSupport = IniRead(StringLeft($strImageConverterPath, $p) & "i_view32.ini", "Others", "Unicode", 0) * 1
				$intExifRotate = IniRead($strImageConverterIniPath, "JPEG", "ExifRotate", 0) * 1
				$intImageConverterUnicodeSupport = IniRead($strImageConverterIniPath, "Others", "Unicode", 0) * 1

			Case "NConvert"
				;*** Parameter "-jpegtrans exif" fr Auto-Rotation nach EXIF-Orientation-Tag *nicht* bergeben, Ergebnis ist mangelhaft auch fr nicht gedrehte Vorschaubilder
;~ 				$intExifRotate = 1

				WriteLog("GetNConvertVer", $strImageConverterPath)
				$pidNConvert = Run(@ComSpec & ' /S /c ""' & $strImageConverterPath & '""', "", @SW_HIDE, $STDOUT_CHILD)
				While 1
					$strImageConverterVersion &= StdoutRead($pidNConvert)
					If @error Then ExitLoop
				Wend
				ProcessWaitClose($pidNConvert)
				$strTmp = StringRegExp($strImageConverterVersion, ".* v(\d*\.\d*) .*", 1)
				$strImageConverterVersion = $strTmp[0]
				$strTmp = ""

			Case "ImageMagick"
				$intExifRotate = 1

			Case Else
				;NOP

		EndSwitch
	EndIf
EndIf

If $strErrMsg <> "" Then MsgBox(48+262144, $cstrTCMetadataViewerVersion, $strErrMsg)


$whTC = WinGetHandle("classname=TTOTAL_CMD")
If @error = 1 Then Exit
WinActivate($whTC)

$strClassnameTCLPanel  = "TMyListBox"
$strClassnameTCRPanel  = "TMyListBox"
$strClassnameTCLHeader = "THeaderClick1"
$strClassnameTCRHeader = "THeaderClick2"
;~ $strClassnameTCQSearch = "TTabEdit1"
$strClassnameTCQSearch = "TTabEdit0"
If $strTCProductVersion < "7.50" Then
	$strClassnameTCLPath   = "TMyPanel5"
	$strClassnameTCRPath   = "TMyPanel9"
	$strClassnameTCLFooter = "TMyPanel4"
	$strClassnameTCRFooter = "TMyPanel8"
Else
	$strClassnameTCLPath   = "TPathPanel1"
	$strClassnameTCRPath   = "TPathPanel2"
	$strClassnameTCLFooter = "TMyPanel5"
	$strClassnameTCRFooter = "TMyPanel8"
EndIf

$strTCPathMem = ""
$strTCFileMem = ""
$strTCExtMem = ""
$strTCPathMemOri = "?" ;Test
$strTCFileMemOri = "?" ;Test
GetTCActivePanelProperties()
$intPicW = $intTCInactivePanelW - 59
$intPicH = Int($intTCInactivePanelH * ($intPanelDivider/100) - $intShowImageTitle*20) ;*** $intPicH initialisieren, damit Wait.jpg schon beim Start korrekt positioniert wird. Wenn ImageTitle angezeigt werden soll, dann soll $picPic 20px (=Hhe der ImageTitel-Zeile) niedriger werden


#Region Icons installieren ---------------------------------------------------------
If Not FileExists($cstrIcoDir) Then DirCreate($cstrIcoDir)
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Transparent.gif", $cstrIcoDir & "\Transparent.gif")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Blank.jpg", $cstrIcoDir & "\Blank.jpg")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Wait.jpg", $cstrIcoDir & "\Wait.jpg")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NoQuickviewAvailable.jpg", $cstrIcoDir & "\NoQuickviewAvailable.jpg")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Close.ico", $cstrIcoDir & "\Close.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\WinOnTop1.ico", $cstrIcoDir & "\WinOnTop1.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\WinOnTop0.ico", $cstrIcoDir & "\WinOnTop0.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Locked.ico", $cstrIcoDir & "\Locked.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotLocked.ico", $cstrIcoDir & "\NotLocked.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Ellipse.ico", $cstrIcoDir & "\Ellipse.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Dropdown.ico", $cstrIcoDir & "\Dropdown.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Filtered.ico", $cstrIcoDir & "\Filtered.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotFiltered.ico", $cstrIcoDir & "\NotFiltered.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Copy.ico", $cstrIcoDir & "\Copy.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Copy_Pend.ico", $cstrIcoDir & "\Copy_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Paste.ico", $cstrIcoDir & "\Paste.ico")
;FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\GPSInfo.ico", $cstrIcoDir & "\GPSInfo.ico")
;FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NoGPSInfo.ico", $cstrIcoDir & "\NoGPSInfo.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Stars1.ico", $cstrIcoDir & "\Stars1.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating1.ico", $cstrIcoDir & "\Rating1.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating2.ico", $cstrIcoDir & "\Rating2.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating3.ico", $cstrIcoDir & "\Rating3.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating4.ico", $cstrIcoDir & "\Rating4.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating5.ico", $cstrIcoDir & "\Rating5.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\RatingRej.ico", $cstrIcoDir & "\RatingRej.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\RatingPlus.ico", $cstrIcoDir & "\RatingPlus.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\RatingMinus.ico", $cstrIcoDir & "\RatingMinus.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating1_Pend.ico", $cstrIcoDir & "\Rating1_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating2_Pend.ico", $cstrIcoDir & "\Rating2_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating3_Pend.ico", $cstrIcoDir & "\Rating3_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating4_Pend.ico", $cstrIcoDir & "\Rating4_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Rating5_Pend.ico", $cstrIcoDir & "\Rating5_Pend.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Stars0.ico", $cstrIcoDir & "\Stars0.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating1.ico", $cstrIcoDir & "\NotRating1.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating3.ico", $cstrIcoDir & "\NotRating3.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating2.ico", $cstrIcoDir & "\NotRating2.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating4.ico", $cstrIcoDir & "\NotRating4.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating5.ico", $cstrIcoDir & "\NotRating5.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRatingRej.ico", $cstrIcoDir & "\NotRatingRej.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRatingMinus.ico", $cstrIcoDir & "\NotRatingMinus.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRatingPlus.ico", $cstrIcoDir & "\NotRatingPlus.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\NotRating_Pend.ico", $cstrIcoDir & "\NotRating_Pend.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Red.ico", $cstrIcoDir & "\Label_Red.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Yellow.ico", $cstrIcoDir & "\Label_Yellow.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Green.ico", $cstrIcoDir & "\Label_Green.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Blue.ico", $cstrIcoDir & "\Label_Blue.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Purple.ico", $cstrIcoDir & "\Label_Purple.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Dark.ico", $cstrIcoDir & "\Label_Dark.ico")

FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Red_Pend.ico", $cstrIcoDir & "\Label_Red_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Yellow_Pend.ico", $cstrIcoDir & "\Label_Yellow_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Green_Pend.ico", $cstrIcoDir & "\Label_Green_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Blue_Pend.ico", $cstrIcoDir & "\Label_Blue_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Purple_Pend.ico", $cstrIcoDir & "\Label_Purple_Pend.ico")
FileInstall("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Label_Dark_Pend.ico", $cstrIcoDir & "\Label_Dark_Pend.ico")
#EndRegion -------------------------------------------------------------------------


#Region SyncSelectedFiles-Dialog erstellen ------------------------------------------
$frmSyncSelectedFiles = GUICreate("SyncSelectedFiles", 800, 262+218, Default, Default, $WS_OVERLAPPEDWINDOW)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmSyncSelectedFiles)

$lvwSyncSelectedFiles = GUICtrlCreateListView("Msg|SourcePath|SourceFile||*|" & ChrW(0x2260) & "|=||TargetPath|TargetFile", 5, 5, 790, 195+218, Default, $LVS_EX_CHECKBOXES+$LVS_EX_FULLROWSELECT+$LVS_EX_DOUBLEBUFFER)
;~ $lvwSyncSelectedFiles = GUICtrlCreateListView("Msg|SourcePath|SourceFile||*|" & ChrW(0x2260) & "|=||TargetPath|TargetFile", 5, 5, 790, 195+218, Default, $LVS_EX_CHECKBOXES+$LVS_EX_FULLROWSELECT+$LVS_EX_DOUBLEBUFFER)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, $strBGColor)
GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)
$hlvwSyncSelectedFiles = GUICtrlGetHandle($lvwSyncSelectedFiles)
_GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 3, "", 30, 1)
_GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 4, "*", 30, 1)
_GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 5, ChrW(0x2260), 30, 1)
_GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 6, "=", 30, 1)
_GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 7, "", 30, 1)
;~ _GUICtrlListView_SetColumn($hlvwSyncSelectedFiles, 7, "", 30, 1)

;*** Button "Alle Checkboxen anwhlen"
$btnSyncSelectedFilesCheckAll = GUICtrlCreateButton("", 10, 210+218, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetTip(-1, $arrLocStr[118]) ;Select all files
GUICtrlSetOnEvent(-1, "SyncSelectedFilesToggleSelection")

;*** Button "Alle Checkboxen abwhlen"
$btnSyncSelectedFilesCheckNone = GUICtrlCreateButton("", 10+20+5, 210+218, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetTip(-1, $arrLocStr[119]) ;Unselect all files
GUICtrlSetOnEvent(-1, "SyncSelectedFilesToggleSelection")

;*** Checkbox "Nur, wenn Metadaten neuer sind"
$chkSyncSelectedFilesIfMetadataNewer = GUICtrlCreateCheckbox("Nur, wenn Metadaten neuer sind", 590-7*40-15, 210+218+3, 150, 24, $BS_RIGHTBUTTON+$BS_RIGHT+$BS_MULTILINE) ;Todo: Lokalisieren
GUICtrlSetState(-1, $GUI_CHECKED)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 7, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, "Nur, wenn Metadaten neuer sind") ;Todo: Lokalisieren

;*** Checkbox "Neue Tags (TagValClp vorhanden, TagValCur nicht vorhanden) synchronisieren"
$chkSyncSelectedFilesNew = GUICtrlCreateCheckbox("*", 590-3*40, 210+218+3, 30, 24)
GUICtrlSetState(-1, $GUI_CHECKED)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[120]) ;Synchronize new tags

;*** Checkbox "Ungleiche Tags (TagValClp und TagValCur vorhanden, unterschiedlicher Inhalt) synchronisieren"
$chkSyncSelectedFilesUnequal = GUICtrlCreateCheckbox(ChrW(0x2260), 590-2*40, 210+218+3, 30, 24)
GUICtrlSetState(-1, $GUI_CHECKED)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[121]) ;Synchronize unequal tags

;*** Checkbox "Obsolete Tags (TagValClp nicht vorhanden, TagValCur vorhanden) synchronisieren"
$chkSyncSelectedFilesDel = GUICtrlCreateCheckbox("", 590-1*40, 210+218+3, 30, 24)
;~ $chkSyncSelectedFilesDel = GUICtrlCreateCheckbox("", 590-1*35, 210+218+3, 25, 20)
GUICtrlSetState(-1, $GUI_CHECKED)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[122]) ;Synchronize obsolete tags

$btnSyncSelectedFilesSave = GUICtrlCreateButton($arrLocStr[129], 590, 210+218, 100, 33-8)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetOnEvent(-1, "SaveSyncSelectedFiles")

$btnSyncSelectedFilesCancel = GUICtrlCreateButton($arrLocStr[76], 695, 210+218, 100, 33-8)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetOnEvent(-1, "_Exit")

$lblSyncSelectedFiles = GUICtrlCreateLabel("", 1, 460, 796, 18, $SS_SUNKEN)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR)

GUISetState(@SW_HIDE, $frmSyncSelectedFiles)

#EndRegion -------------------------------------------------------------------------

#Region SyncSelectedTags-Dialog erstellen ------------------------------------------
$frmSyncSelectedTags = GUICreate("SyncSelectedTags", 800, 600, Default, Default, $WS_OVERLAPPEDWINDOW)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmSyncSelectedTags)

$lvwSyncSelectedTags = GUICtrlCreateListView($arrLocStr[31] & "|TagID|" & $arrLocStr[36] & "|" & $arrLocStr[39] & " (" & $arrLocStr[40] & ")||" & $arrLocStr[39] & " (" & $arrLocStr[41] & ")", 5, 5, 790, 195+360-60, Default, $LVS_EX_CHECKBOXES)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, $strBGColor)
GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)
$hlvwSyncSelectedTags = GUICtrlGetHandle($lvwSyncSelectedTags)

;*** Button "Alle Checkboxen anwhlen"
$btnSyncSelectedTagsCheckAll = GUICtrlCreateButton("", 10, 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetTip(-1, $arrLocStr[132]) ;Select all tags
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckAll, "SyncSelectedTagsToggleSelection")

;*** Button "Alle Checkboxen abwhlen"
$btnSyncSelectedTagsCheckNone = GUICtrlCreateButton("", 10+20+5, 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetTip(-1, $arrLocStr[133]) ;Unselect all tags
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckNone, "SyncSelectedTagsToggleSelection")

;*** Button "Checkbox-Markierungen wiederherstellen"
$btnSyncSelectedTagsCheckRestore = GUICtrlCreateButton("", 10+2*(20+5), 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetTip(-1, $arrLocStr[137]) ;Restore selection
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckRestore, "SyncSelectedTagsToggleSelection")

;*** Button "Alle Checkboxen zu neuen Tags (TagValClp vorhanden, TagValCur nicht vorhanden) anwhlen"
$lblSyncSelectedTagsCheckNew = GUICtrlCreateLabel("", 10+3*(20+5), 210+360-16, 20, 16, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetColor(-1, 0x808080)
$btnSyncSelectedTagsCheckNew = GUICtrlCreateButton("*", 10+3*(20+5), 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[134]) ;Select all new tags
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckNew, "SyncSelectedTagsToggleSelection")
GUICtrlCreateLabel("", 10+3*(20+5)+1, 210+20+360, 18, 3)
GUICtrlSetBkColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncNew", "0x99CC00"))
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

;*** Button "Alle Checkboxen zu ungleichen Tags (TagValClp und TagValCur vorhanden, unterschiedlicher Inhalt) anwhlen"
$lblSyncSelectedTagsCheckUnequal = GUICtrlCreateLabel("", 10+4*(20+5), 210+360-16, 20, 16, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetColor(-1, 0x808080)
$btnSyncSelectedTagsCheckUnequal = GUICtrlCreateButton(ChrW(0x2260), 10+4*(20+5), 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[135]) ;Select all unequal tags
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckUnequal, "SyncSelectedTagsToggleSelection")
GUICtrlCreateLabel("", 10+4*(20+5)+1, 210+20+360, 18, 3)
GUICtrlSetBkColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncNotEqual", "0xFFCC00"))
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

;*** Button "Alle Checkboxen zu obsoleten Tags (TagValClp nicht vorhanden, TagValCur vorhanden) anwhlen"
$lblSyncSelectedTagsCheckDel = GUICtrlCreateLabel("", 10+5*(20+5), 210+360-16, 20, 16, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetColor(-1, 0x808080)
$btnSyncSelectedTagsCheckDel = GUICtrlCreateButton("", 10+5*(20+5), 210+360, 20, 20)
;~ $btnSyncSelectedTagsCheckDel = GUICtrlCreateButton("", 10+5*(20+5), 210+360, 20, 20)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetFont(-1, 10, Default, Default, "Segoe UI")
GUICtrlSetTip(-1, $arrLocStr[136]) ;Select all obsolete tags
GUICtrlSetOnEvent($btnSyncSelectedTagsCheckDel, "SyncSelectedTagsToggleSelection")
GUICtrlCreateLabel("", 10+5*(20+5)+1, 210+20+360, 18, 3)
GUICtrlSetBkColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncObs", "0xFF6600"))
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

GUICtrlCreateLabel("", 180-1, 210+352-60-1, 96+2, 96+2, $SS_GRAYFRAME)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
$picSyncSelectedTagsSource = GUICtrlCreatePic("", 180, 210+352-60, 96, 96)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

GUICtrlCreateLabel("", 180-1 + 96+2 + 2, 210+352-60-1 + 39, 24, 20, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
GUICtrlSetColor(-1, 0x808080)
GUICtrlSetFont(-1, 16, Default, Default, "Wingdings")

GUICtrlCreateLabel("", 306-1, 210+352-60-1, 96+2, 96+2, $SS_GRAYFRAME)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)
$picSyncSelectedTagsTarget = GUICtrlCreatePic("", 306, 210+352-60, 96, 96)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKLEFT)

$btnSyncSelectedTagsSave = GUICtrlCreateButton($arrLocStr[129], 590, 210+360, 100, 33-8, $BS_DEFPUSHBUTTON)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetOnEvent(-1, "SaveSyncSelectedTags")

$btnSyncSelectedTagsCancel = GUICtrlCreateButton($arrLocStr[76], 695, 210+360, 100, 33-8)
GUICtrlSetResizing(-1, $GUI_DOCKSTATEBAR+$GUI_DOCKWIDTH+$GUI_DOCKRIGHT)
GUICtrlSetOnEvent(-1, "_Exit")

GUISetState(@SW_HIDE, $frmSyncSelectedTags)

#EndRegion SyncSelectedTags-Dialog erstellen -------------------------------------

#Region ShiftDateTime-Dialog erstellen ---------------------------------------------
$frmShiftDateTime = GUICreate($arrLocStr[104], 325, 180)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmShiftDateTime)

$chkShiftDateTimeDateTimeOriginal = GUICtrlCreateCheckbox("EXIF:DateTimeOriginal", 10, 10, 200,  18)
GUICtrlSetState(-1, $GUI_CHECKED)
$chkShiftDateTimeCreateDate       = GUICtrlCreateCheckbox("EXIF:CreateDate", 10, 30, 200,  18)
GUICtrlSetState(-1, $GUI_CHECKED)
$chkShiftDateTimeModifyDate       = GUICtrlCreateCheckbox("EXIF:ModifyDate", 10, 50, 200,  18)
GUICtrlSetState(-1, $GUI_CHECKED)
$chkShiftDateTimeFileModifyDate   = GUICtrlCreateCheckbox("File:FileModifyDate", 10, 70, 200,  18)
GUICtrlSetState(-1, $GUI_UNCHECKED)

GUICtrlCreateLabel("+/-", 7, 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
GUICtrlCreateLabel("YY", 35+0*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
GUICtrlCreateLabel("MM", 35+1*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
GUICtrlCreateLabel("DD", 35+2*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

GUICtrlCreateLabel("hh", 35+8+3*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
GUICtrlCreateLabel("mm", 35+8+4*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
GUICtrlCreateLabel("ss", 35+8+5*(20+3), 95, 20, 18, $ES_CENTER)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$btnShiftDateTimeIncDec = GUICtrlCreateButton("+", 7, 109, 20, 20, $BS_FLAT)
GUICtrlSetFont(-1, 11, 700)
GUICtrlSetOnEvent(-1, "ToggleShiftDateTimeIncDec")

$txtShiftDateTimeY = GUICtrlCreateEdit("", 35+0*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)
$txtShiftDateTimeM = GUICtrlCreateEdit("", 35+1*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)
$txtShiftDateTimeD = GUICtrlCreateEdit("", 35+2*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)

$txtShiftDateTimeH = GUICtrlCreateEdit("", 35+8+3*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)
$txtShiftDateTimeN = GUICtrlCreateEdit("", 35+8+4*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)
$txtShiftDateTimeS = GUICtrlCreateEdit("", 35+8+5*(20+3), 110, 20, 20, $ES_NUMBER+$ES_RIGHT)

GUICtrlCreateLabel("", 5, 144, 315, 2, $SS_SUNKEN)

$chkShiftDateTimeSaveAll = GUICtrlCreateCheckbox($arrLocStr[91], 325-3*105, 150, 100, 33-8, $BS_RIGHTBUTTON+$BS_RIGHT+$BS_MULTILINE)
GUICtrlSetFont(-1, 6)
$btnShiftDateTimeSave = GUICtrlCreateButton($arrLocStr[75], 325-2*105, 150, 100, 33-8, $BS_DEFPUSHBUTTON)
GUICtrlSetOnEvent(-1, "SaveShiftDateTime")
$btnShiftDateTimeCancel = GUICtrlCreateButton($arrLocStr[76], 325-1*105, 150, 100, 33-8)
GUICtrlSetOnEvent(-1, "_Exit")


GUISetState(@SW_HIDE, $frmShiftDateTime)
#EndRegion -------------------------------------------------------------------------

#Region Editdialog erstellen -------------------------------------------------------
$frmEdit = GUICreate($arrLocStr[69], 550, 244)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmEdit)

$btnEditAddTagToCustView = GUICtrlCreateButton("+", 5, 4, 16, 16)
;~ GUICtrlSetTip(-1, $arrLocStr[71])
GUICtrlSetOnEvent(-1, "AddTagToCustView")

$lblEditTagGrpNam = GUICtrlCreateLabel("", 25, 5, 515, 18)
GUICtrlSetFont(-1, Default, 700)

$txtEditTagVal = GUICtrlCreateEdit("", 5, 23, 2*185+3*5, 150, $ES_MULTILINE+$WS_TABSTOP+$ES_WANTRETURN+$WS_VSCROLL+$ES_AUTOVSCROLL)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)

;~ $lvwEditTagVal = GUICtrlCreateListView("RegionPersonDisplayName|Rectangle", 5, 23, 2*185+3*5, 150, $LVS_SHOWSELALWAYS+$LVS_SINGLESEL+$LVS_EDITLABELS)
$lvwEditTagVal = GUICtrlCreateListView("RegionPersonDisplayName|Rectangle", 5, 23, 185, 150, $LVS_SHOWSELALWAYS+$LVS_SINGLESEL+$LVS_EDITLABELS)
GUICtrlSetState(-1, $GUI_HIDE)
$hlvwEditTagVal = GUICtrlGetHandle($lvwEditTagVal)

$btnEditViewBinary = GUICtrlCreateButton("", 5, 23+151, 16, 8)
GUICtrlSetTip(-1, $arrLocStr[72])
GUICtrlSetOnEvent(-1, "ViewTagValBinary")

$lbxEditTagList = GUICtrlCreateList("", 200+5, 23, 185, 150-22, $WS_BORDER+$WS_VSCROLL+$LBS_NOINTEGRALHEIGHT)
GUICtrlSetBkColor(-1, 0xE0E0E0)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "EditTagValAdd")
$txtEditTagListQuickfilter = GUICtrlCreateInput("", 200+5, 175-22, 166, 20)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "EditTagQuickfilter")
$icoEditTagListQuickfilter = GUICtrlCreateIcon($cstrIcoDir & "\NotFiltered.ico", 0, 405-36+5, 175-19, 13, 13)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "ToggleEditTagQuickfilter")

GUIStartGroup($frmEdit)
$radioEditTagChg = GUICtrlCreateRadio($arrLocStr[73], 400, 24+0*18, 145, 18)
GUICtrlSetOnEvent(-1, "SetEditTagAction")
$radioEditTagDel = GUICtrlCreateRadio($arrLocStr[74], 400, 24+1*18, 145, 18)
GUICtrlSetOnEvent(-1, "SetEditTagAction")

GUICtrlCreateLabel("", 400, 24+2*18+3, 145, 2, $SS_SUNKEN)

$radioEditTagCpy = GUICtrlCreateRadio($arrLocStr[87], 400, 24+2*18+6, 145, 18) ;*** "kopieren"
GUICtrlSetOnEvent(-1, "SetEditTagAction")
$radioEditTagMov = GUICtrlCreateRadio($arrLocStr[88], 400, 24+3*18+6, 145, 18) ;*** "verschieben"
GUICtrlSetOnEvent(-1, "SetEditTagAction")

$arrTagMapping = IniReadSection($cstrIniFile, "TagMapping")
$strTagMapping = ""
For $i = 1 To $arrTagMapping[0][0]
;~ 	$strTagMapping &= StringToUTF8($arrTagMapping[$i][1]) & "|"
	$strTagMapping &= $arrTagMapping[$i][1] & "|"
Next
$strTagMapping = StringTrimRight($strTagMapping, 1)
$cbxEditTagGrpNamTarget = GUICtrlCreateCombo("", 400, 24+4*18+6, 145, 18)
GUICtrlSetState(-1, $GUI_DISABLE)

GUICtrlCreateLabel("", 400, 24+5*18+15, 145, 2, $SS_SUNKEN)

$chkEditTagActionOpt = GUICtrlCreateCheckbox("", 400, 24+6*18+3, 145, 18)
GUICtrlSetOnEvent(-1, "SetEditTagAction")

GUICtrlCreateLabel("", 5, 183, 540, 2, $SS_SUNKEN)

$btnEditCancel = GUICtrlCreateButton($arrLocStr[76], 445, 188+4, 100, 33-8)
GUICtrlSetOnEvent(-1, "_Exit")

$btnEditSaveCur = GUICtrlCreateButton($arrLocStr[75], 235+105, 188+4, 100, 33-8, $BS_DEFPUSHBUTTON)
GUICtrlSetOnEvent(-1, "SaveEditTag")
$chkEditSaveAll    = GUICtrlCreateCheckbox($arrLocStr[91], 10+105, 188, 220, 18, $BS_RIGHTBUTTON+$BS_RIGHT)
GUICtrlSetOnEvent(-1, "SetEditTagAction")
$chkEditSaveAllOpt = GUICtrlCreateCheckbox("", 10+105, 204, 220, 18, $BS_RIGHTBUTTON+$BS_RIGHT)
GUICtrlSetState(-1, $GUI_DISABLE)

$lblEditSaveCur = GUICtrlCreateLabel("$lblEditSaveCur", 1, 188+36, 548, 18, $SS_SUNKEN)

GUISetState(@SW_HIDE, $frmEdit)
;~ $x = $intTCInactivePanelX-550-4 -8
$x = $intTCInactivePanelX-550-4 -2
If $x < 1 Then $x = 1
;~ $y = $intTCInactivePanelY + Int($intTCInactivePanelH * ($intPanelDivider/100)) + 20
;~ If $y+244 > @DesktopHeight Then $y = @DesktopHeight - 244
;~ WinMove($frmEdit, "", $x, $y)
WinMove($frmEdit, "", $x, Default)

#EndRegion -------------------------------------------------------------------------

#Region Hauptdialog erstellen ------------------------------------------------------
$frmMain = GUICreate($cstrTCMetadataViewerVersion, $intTCInactivePanelW, $intTCInactivePanelH, $intTCInactivePanelX, $intTCInactivePanelY, $WS_POPUP)
GUISetBkColor($strBGColor, $frmMain)
WinSetOnTop($frmMain, "", 1)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmMain)

$strTagImageTitle = IniRead($cstrIniFile, "Configuration", "TagImageTitle", "File:Comment")
$txtImageTitle = GUICtrlCreateInput("", 0, 0, ($intTCInactivePanelW - 59) * $intShowImageTitle + 1, 20, $ES_CENTER, $WS_EX_TRANSPARENT)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 8, Default, Default, "Segoe Script")
GUICtrlSetBkColor(-1, $strBGColor)
GUICtrlSetColor(-1, IniRead($cstrIniFile, "Configuration", "ColorImageTitle", "0x6FA1D9"))
GUICtrlSetOnEvent(-1, "ImageTitleOnEvent")

$picPic = GUICtrlCreatePic("", 1, 1, 0, 0)
GUICtrlSetOnEvent(-1, "ViewImageOnEvent")

$lblRegionRectangle = GUICtrlCreateLabel("", 0, 0, 0, 0, $SS_ETCHEDFRAME)
GUICtrlSetState(-1, $GUI_HIDE)

#Region Kontextmen Image ----------------------------------------------------------
$contextPicPic = GUICtrlCreateContextMenu($picPic)

$contextPicPicQuickviewOff = GUICtrlCreateMenuItem($arrLocStr[106], $contextPicPic, 0, 1) ;Show QuickView of image: None
GUICtrlSetOnEvent(-1, "SetQuickviewMode")
GUICtrlSetState(-1, $GUI_UNCHECKED)

$contextPicPicQuickviewThumb = GUICtrlCreateMenuItem($arrLocStr[107], $contextPicPic, 1, 1) ;Show QuickView of image: Thumbnail
GUICtrlSetOnEvent(-1, "SetQuickviewMode")
GUICtrlSetState(-1, $GUI_UNCHECKED)
$booQuickviewThumb = False

$contextPicPicQuickviewStd = GUICtrlCreateMenuItem($arrLocStr[19], $contextPicPic, 2, 1)
GUICtrlSetOnEvent(-1, "SetQuickviewMode")
GUICtrlSetState(-1, $GUI_UNCHECKED)
$booQuickview = True

$contextPicPicQuickviewHQ = GUICtrlCreateMenuItem(StringReplace($arrLocStr[6], "%n", $strImageConverter), $contextPicPic, 3, 1)
GUICtrlSetOnEvent(-1, "SetQuickviewMode")
If FileExists($strImageConverterPath) Then
	GUICtrlSetState(-1, $GUI_CHECKED)
	$booQuickviewHQ = True
Else
	GUICtrlSetState(-1, $GUI_UNCHECKED)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$booQuickviewHQ = False
EndIf

$contextPicPicQuickviewGamma = GUICtrlCreateMenuItem($arrLocStr[108], $contextPicPic, 4, 0) ;Bildvorschau: Vorschaubild aufhellen
GUICtrlSetOnEvent(-1, "SetQuickviewMode")
$booQuickviewColor = False

$contextPicPicView = GUICtrlCreateMenuItem(StringReplace($arrLocStr[7], "%n", $strImageViewer), $contextPicPic, 5, 0) ;Bild mit %n ffnen
GUICtrlSetOnEvent(-1, "ViewImageOnEvent")
$contextPicPicPlaySound = GUICtrlCreateMenuItem($arrLocStr[8], $contextPicPic, 6, 0) ;Audionotiz zum Bild abspielen
GUICtrlSetOnEvent(-1, "PlaySound")
$contextPicPicShowGPSPos = GUICtrlCreateMenuItem(StringReplace($arrLocStr[97], "%GeoService", $strGeoService), $contextPicPic, 7, 0) ;GPS-Position in %GeoService zeigen
GUICtrlSetOnEvent(-1, "ShowGPSPos")

GUICtrlCreateMenuItem('', $contextPicPic, 8)
$contextPicPicOptimize = GUICtrlCreateMenuItem($arrLocStr[9], $contextPicPic, 9, 0)     ;Verlustfreie Operation: JPG optimieren
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter <> "IrfanView" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicRotate090 = GUICtrlCreateMenuItem($arrLocStr[10], $contextPicPic, 10, 0)   ;Verlustfreie Operation: JPG 90 drehen
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicRotate180 = GUICtrlCreateMenuItem($arrLocStr[11], $contextPicPic, 11, 0)  ;Verlustfreie Operation: JPG 180 drehen
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicRotate270 = GUICtrlCreateMenuItem($arrLocStr[12], $contextPicPic, 12, 0)  ;Verlustfreie Operation: JPG -90 drehen
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicRotateExif = GUICtrlCreateMenuItem($arrLocStr[13], $contextPicPic, 13, 0) ;Verlustfreie Operation: JPG Auto-Rotation gem EXIF-Info
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicMirrorHor = GUICtrlCreateMenuItem("Verlustfreie Operation: JPG horizontal spiegeln", $contextPicPic, 14, 0) ;Verlustfreie Operation: JPG horizontal spiegeln ;Todo: Lokalisieren
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)
$contextPicPicMirrorVer = GUICtrlCreateMenuItem("Verlustfreie Operation: JPG vertikal spiegeln", $contextPicPic, 15, 0) ;Verlustfreie Operation: JPG vertikal spiegeln ;Todo: Lokalisieren
GUICtrlSetOnEvent(-1, "LosslessJPGOperation")
If $strImageConverter = "ImageMagick" Then GUICtrlSetState(-1, $GUI_DISABLE)

GUICtrlCreateMenuItem('', $contextPicPic, 16, 0)
GUICtrlCreateMenuItem($arrLocStr[14], $contextPicPic, 17, 0)
$contextPicPicViewThumbnailImage = GUICtrlCreateMenuItem(StringReplace($arrLocStr[16], "%n", $strImageViewer), $contextPicPic, 18, 0)
GUICtrlSetOnEvent(-1, "ViewThumbnailImageOnEvent")
$contextPicPicSaveThumbnailImage = GUICtrlCreateMenuItem($arrLocStr[17], $contextPicPic, 19, 0)
GUICtrlSetOnEvent(-1, "SaveThumbnailImageOnEvent")
$contextPicPicDeleteThumbnailImage = GUICtrlCreateMenuItem($arrLocStr[18], $contextPicPic, 20, 0)
GUICtrlSetOnEvent(-1, "DeleteThumbnailImage")

GUICtrlCreateMenuItem('', $contextPicPic, 21, 0)
GUICtrlCreateMenuItem($arrLocStr[15], $contextPicPic, 22, 0)
$contextPicPicViewPreviewImage = GUICtrlCreateMenuItem(StringReplace($arrLocStr[16], "%n", $strImageViewer), $contextPicPic, 23, 0)
GUICtrlSetOnEvent(-1, "ViewPreviewImageOnEvent")
$contextPicPicSavePreviewImage = GUICtrlCreateMenuItem($arrLocStr[17], $contextPicPic, 24, 0)
GUICtrlSetOnEvent(-1, "SavePreviewImageOnEvent")
$contextPicPicDeletePreviewImage = GUICtrlCreateMenuItem($arrLocStr[18], $contextPicPic, 25, 0)
GUICtrlSetOnEvent(-1, "DeletePreviewImage")

GUICtrlCreateMenuItem('', $contextPicPic, 26, 0)
$contextPicPicExportRegions = GUICtrlCreateMenuItem("ExportRegions", $contextPicPic, 27, 0)
GUICtrlSetOnEvent(-1, "ExportRegions")
#EndRegion Kontextmen Image -------------------------------------------------------

$icoClose = GUICtrlCreateIcon($cstrIcoDir & "\Close.ico", 0, $intTCInactivePanelW - 16, 2, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT) ;Icon-Controls ignorieren die Resizing-Eigenschaft. Nach SetImage muss Position mit SetPos neu gesetzt werden
GUICtrlSetOnEvent($icoClose, "_Exit")

$icoWinOnTop = GUICtrlCreateIcon($cstrIcoDir & "\WinOnTop1.ico", 0, $intTCInactivePanelW - (16+4+13), 2, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT) ;Icon-Controls ignorieren die Resizing-Eigenschaft. Nach SetImage muss Position mit SetPos neu gesetzt werden
GUICtrlSetOnEvent(-1, "SetWinOnTopStateOnEvent")
$intWinOnTopState = 1
$intWinOnTopStateUser = 1

$icoLocked = GUICtrlCreateIcon($cstrIcoDir & "\NotLocked.ico", 0, $intTCInactivePanelW - (16+4+13+4+13), 2, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT) ;Icon-Controls ignorieren die Resizing-Eigenschaft. Nach SetImage muss Position mit SetPos neu gesetzt werden
GUICtrlSetOnEvent(-1, "SetLockState")
$booLocked = False

#Region DateTimeOriginal -----------------------------------------------------------
$lblDateTimeOriginal = GUICtrlCreateLabel($arrLocStr[20], $intTCInactivePanelW - 55, 20, 55, 14)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$lblDateTimeOriginalDate = GUICtrlCreateLabel("", $intTCInactivePanelW - 55, 20+14, 55, 30, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7.5)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetOnEvent(-1, "OpenShiftDateTimeDialog")

$lblDateTimeOriginalTime = GUICtrlCreateLabel("", $intTCInactivePanelW - 55, 20+44, 35, 14, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetOnEvent(-1, "OpenShiftDateTimeDialog")

$lblDateTimeOriginalDST = GUICtrlCreateLabel("", $intTCInactivePanelW - 20, 20+41, 18, 16, $SS_RIGHT)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 11, Default, Default, "Wingdings")
GUICtrlSetColor(-1, $strBGColorInactiveControls) ;Standardzeit 0x6FA1D9 / Sommerzeit 0xFFF477
If $intShowXMPDaylightSavings = 0 Then
	GUICtrlSetState($lblDateTimeOriginalDST, $GUI_HIDE)
	GUICtrlSetPos($lblDateTimeOriginalTime, $intTCInactivePanelW - 55, 20+44, 55, 14)
Else
	GUICtrlSetOnEvent($lblDateTimeOriginalDST, "SetDaylightSavings")
EndIf
#EndRegion DateTimeOriginal --------------------------------------------------------

#Region Rating ---------------------------------------------------------------------
$lblXMPRating = GUICtrlCreateLabel($arrLocStr[22], $intTCInactivePanelW - 55, 80, 55, 17)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

;*** Icon-Controls ignorieren die Resizing-Eigenschaft. Nach SetImage muss Position mit SetPos neu gesetzt werden


If $strLayoutXMPRating = "Stars" Then
	$icoXMPRating1 = GUICtrlCreateIcon($cstrIcoDir & "\Stars0.ico", 0, $intTCInactivePanelW - 55, 80+1*15, 9, 9)
	GUICtrlSetTip(-1, "-- (1)")
	GUICtrlSetOnEvent(-1, "SetXMPRating")
	$icoXMPRating2 = GUICtrlCreateIcon($cstrIcoDir & "\Stars0.ico", 0, $intTCInactivePanelW - 46, 80+1*15, 9, 9)
	GUICtrlSetTip(-1, "- (2)")
	GUICtrlSetOnEvent(-1, "SetXMPRating")
	$icoXMPRating3 = GUICtrlCreateIcon($cstrIcoDir & "\Stars0.ico", 0, $intTCInactivePanelW - 37, 80+1*15, 9, 9)
	GUICtrlSetTip(-1, "o (3)")
	GUICtrlSetOnEvent(-1, "SetXMPRating")
	$icoXMPRating4 = GUICtrlCreateIcon($cstrIcoDir & "\Stars0.ico", 0, $intTCInactivePanelW - 28, 80+1*15, 9, 9)
	GUICtrlSetTip(-1, "+ (4)")
	GUICtrlSetOnEvent(-1, "SetXMPRating")
	$icoXMPRating5 = GUICtrlCreateIcon($cstrIcoDir & "\Stars0.ico", 0, $intTCInactivePanelW - 19, 80+1*15, 9, 9)
	GUICtrlSetTip(-1, "++ (5)")
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$intXMPRatingRMPIcoOffsetY = 80+2*15

Else
	$lblXMPRating5 = GUICtrlCreateLabel("+", $intTCInactivePanelW - 38, 80+1*15-2, 15, 13, $SS_CENTER)
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetFont(-1, 7.5)
	GUICtrlSetColor(-1, $strBGColorInactiveControls)
	$icoXMPRating5 = GUICtrlCreateIcon($cstrIcoDir & "\NotRating5.ico", 0, $intTCInactivePanelW - 53, 80+1*15, 13, 13)
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$lblXMPRating4 = GUICtrlCreateLabel("+", $intTCInactivePanelW - 38, 80+2*15-2, 15, 13, $SS_CENTER)
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetFont(-1, 7.5)
	GUICtrlSetColor(-1, $strBGColorInactiveControls)
	$icoXMPRating4 = GUICtrlCreateIcon($cstrIcoDir & "\NotRating4.ico", 0, $intTCInactivePanelW - 53, 80+2*15, 13, 13)
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$lblXMPRating3 = GUICtrlCreateLabel("o", $intTCInactivePanelW - 38, 80+3*15-2, 15, 13, $SS_CENTER)
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetFont(-1, 7.5)
	GUICtrlSetColor(-1, $strBGColorInactiveControls)
	$icoXMPRating3 = GUICtrlCreateIcon($cstrIcoDir & "\NotRating3.ico", 0, $intTCInactivePanelW - 53, 80+3*15, 13, 13)
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$lblXMPRating2 = GUICtrlCreateLabel("-", $intTCInactivePanelW - 38, 80+4*15-2, 15, 13, $SS_CENTER)
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetFont(-1, 7.5)
	GUICtrlSetColor(-1, $strBGColorInactiveControls)
	$icoXMPRating2 = GUICtrlCreateIcon($cstrIcoDir & "\NotRating2.ico", 0, $intTCInactivePanelW - 53, 80+4*15, 13, 13)
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$lblXMPRating1 = GUICtrlCreateLabel("--", $intTCInactivePanelW - 38, 80+5*15-2, 15, 13, $SS_CENTER)
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetFont(-1, 7.5)
	GUICtrlSetColor(-1, $strBGColorInactiveControls)
	$icoXMPRating1 = GUICtrlCreateIcon($cstrIcoDir & "\NotRating1.ico", 0, $intTCInactivePanelW - 53, 80+5*15, 13, 13)
	GUICtrlSetOnEvent(-1, "SetXMPRating")

	$intXMPRatingRMPIcoOffsetY = 80+6*15

EndIf

$icoXMPRatingRej = GUICtrlCreateIcon($cstrIcoDir & "\NotRatingRej.ico", 0, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY, 13, 13)
GUICtrlSetOnEvent(-1, "SetXMPRating")
$icoXMPRatingMinus = GUICtrlCreateIcon($cstrIcoDir & "\NotRatingMinus.ico", 0, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY, 13, 13)
GUICtrlSetOnEvent(-1, "SetXMPRating")
$icoXMPRatingPlus = GUICtrlCreateIcon($cstrIcoDir & "\NotRatingPlus.ico", 0, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY, 13, 13)
GUICtrlSetOnEvent(-1, "SetXMPRating")

#EndRegion Rating ------------------------------------------------------------------

#Region Label ----------------------------------------------------------------------
$lblXMPLabel = GUICtrlCreateLabel($arrLocStr[23], $intTCInactivePanelW - 55, 179+15, 45, 17)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$icoXMPLabelRed = GUICtrlCreateIcon($cstrIcoDir & "\Label_Dark.ico",    0, $intTCInactivePanelW - 53, 179+15+1*14, 12, 12)
If $intShowXMPLabel = 1 Then
	$strTmp = IniRead($cstrIniFile, "LabelsMapDispColor2DispText", "Red", "Red")
	$strTmp = BinaryToString($strTmp, 4)
	$p = StringInStr($strTmp, "|")
	GUICtrlSetTip($icoXMPLabelRed, StringMid($strTmp, $p+1))
	GUICtrlSetOnEvent($icoXMPLabelRed, "SetXMPLabel")
EndIf
$lblXMPLabelRed = GUICtrlCreateLabel(StringLeft($strTmp, $p-1),    $intTCInactivePanelW - 39, 179+15+1*14, 38, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$icoXMPLabelYellow = GUICtrlCreateIcon($cstrIcoDir & "\Label_Dark.ico", 0, $intTCInactivePanelW - 53, 179+15+2*14, 12, 12)
If $intShowXMPLabel = 1 Then
	$strTmp = IniRead($cstrIniFile, "LabelsMapDispColor2DispText", "Yellow", "Yellow")
	$strTmp = BinaryToString($strTmp, 4)
	$p = StringInStr($strTmp, "|")
	GUICtrlSetTip($icoXMPLabelYellow, StringMid($strTmp, $p+1))
	GUICtrlSetOnEvent($icoXMPLabelYellow, "SetXMPLabel")
EndIf
$lblXMPLabelYellow = GUICtrlCreateLabel(StringLeft($strTmp, $p-1), $intTCInactivePanelW - 39, 179+15+2*14, 38, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$icoXMPLabelGreen = GUICtrlCreateIcon($cstrIcoDir & "\Label_Dark.ico",  0, $intTCInactivePanelW - 53, 179+15+3*14, 12, 12)
If $intShowXMPLabel = 1 Then
	$strTmp = IniRead($cstrIniFile, "LabelsMapDispColor2DispText", "Green", "Green")
	$strTmp = BinaryToString($strTmp, 4)
	$p = StringInStr($strTmp, "|")
	GUICtrlSetTip($icoXMPLabelGreen, StringMid($strTmp, $p+1))
	GUICtrlSetOnEvent($icoXMPLabelGreen, "SetXMPLabel")
EndIf
$lblXMPLabelGreen = GUICtrlCreateLabel(StringLeft($strTmp, $p-1),  $intTCInactivePanelW - 39, 179+15+3*14, 38, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$icoXMPLabelBlue = GUICtrlCreateIcon($cstrIcoDir & "\Label_Dark.ico",   0, $intTCInactivePanelW - 53, 179+15+4*14, 12, 12)
If $intShowXMPLabel = 1 Then
	$strTmp = IniRead($cstrIniFile, "LabelsMapDispColor2DispText", "Blue", "Blue")
	$strTmp = BinaryToString($strTmp, 4)
	$p = StringInStr($strTmp, "|")
	GUICtrlSetTip($icoXMPLabelBlue, StringMid($strTmp, $p+1))
	GUICtrlSetOnEvent(-$icoXMPLabelBlue, "SetXMPLabel")
EndIf
$lblXMPLabelBlue = GUICtrlCreateLabel(StringLeft($strTmp, $p-1),   $intTCInactivePanelW - 39, 179+15+4*14, 38, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)

$icoXMPLabelPurple = GUICtrlCreateIcon($cstrIcoDir & "\Label_Dark.ico", 0, $intTCInactivePanelW - 53, 179+15+5*14, 12, 12)
If $intShowXMPLabel = 1 Then
	$strTmp = IniRead($cstrIniFile, "LabelsMapDispColor2DispText", "Purple", "Purple")
	$strTmp = BinaryToString($strTmp, 4)
	$p = StringInStr($strTmp, "|")
	GUICtrlSetTip($icoXMPLabelPurple, StringMid($strTmp, $p+1))
	GUICtrlSetOnEvent($icoXMPLabelPurple, "SetXMPLabel")
EndIf
$lblXMPLabelPurple = GUICtrlCreateLabel(StringLeft($strTmp, $p-1), $intTCInactivePanelW - 39, 179+15+5*14, 38, 13)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorInactiveControls)
#EndRegion Label -------------------------------------------------------------------

#Region TechInfo -------------------------------------------------------------------

$lblTechInfoShutterSpeed = GUICtrlCreateLabel("", $intTCInactivePanelW - 55, 264+25+0*12, 37, 12, $SS_LEFT)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorActiveControls)
#cs - $lblTechInfoShutterSpeed
$lblTechInfoShutterSpeed = GUICtrlCreateLabel("", 5, 5, 50, 14, $SS_LEFT)
GUICtrlSetFont(-1, 8.5)
GUICtrlSetColor(-1, 0xFFFFFF)
#ce - $lblTechInfoShutterSpeed

$lblTechInfoAperture = GUICtrlCreateLabel("", $intTCInactivePanelW - 18, 264+25+0*12, 17, 12, $SS_LEFT)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorActiveControls)
#cs - $lblTechInfoAperture
$lblTechInfoAperture = GUICtrlCreateLabel("", 55, 5, 25, 14, $SS_LEFT)
GUICtrlSetFont(-1, 8.5)
GUICtrlSetColor(-1, 0xFFFFFF)
#ce - $lblTechInfoAperture

$lblTechInfoISO = GUICtrlCreateLabel("", $intTCInactivePanelW - 55, 264+25+1*12, 54, 12, $SS_LEFT)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorActiveControls)
#cs - $lblTechInfoISO
$lblTechInfoISO = GUICtrlCreateLabel("", 5, 20, 50, 14, $SS_LEFT)
GUICtrlSetFont(-1, 8.5)
GUICtrlSetColor(-1, 0xFFFFFF)
#ce - $lblTechInfoISO

$lblTechInfoFLen35 = GUICtrlCreateLabel("", $intTCInactivePanelW - 55, 264+25+2*12, 54, 12, $SS_LEFT, $WS_EX_TRANSPARENT)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetColor(-1, $strBGColorActiveControls)
#cs - $lblTechInfoFLen35
$lblTechInfoFLen35 = GUICtrlCreateLabel("", 5, 35, 75, 14, $SS_LEFT)
GUICtrlSetFont(-1, 8.5)
GUICtrlSetColor(-1, 0xFFFFFF)
#ce - $lblTechInfoFLen35

#cs
;~ $lblJPEGComment = GUICtrlCreateLabel("JPEG-Kommentar", 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) - 18, $intTCInactivePanelW - 55 - 2, 19, $SS_CENTER) ;Test
$lblJPEGComment = GUICtrlCreateLabel("JPEG-Kommentar", 2, 0, $intTCInactivePanelW - 55 - 2, 19, $SS_CENTER) ;Test
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7, Default, Default, "Segoe Script")
GUICtrlSetColor(-1, 0x00C0FF)
#ce


#EndRegion TechInfo ----------------------------------------------------------------

#Region Filterbuttons --------------------------------------------------------------
$btnTagGroupUser = GUICtrlCreateButton($arrLocStr[25], 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 60, 19, $BS_FLAT) ;*** Filterbutton "User"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")
$icoTagGroups = GUICtrlCreateIcon($cstrIcoDir & "\Dropdown.ico", 0, 62, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetOnEvent(-1, "GetTagGroups")

$btnFilterSearchResult = GUICtrlCreateButton($arrLocStr[26], 79, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 60, 19, $BS_FLAT) ;*** Filterbutton "SuchErg"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")
$icoEditSearchTerm = GUICtrlCreateIcon($cstrIcoDir & "\Ellipse.ico", 0, 139, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetOnEvent(-1, "EditSearchTerm")

$btnTagGroupAll = GUICtrlCreateButton($arrLocStr[27], 156, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Alle"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupCustom = GUICtrlCreateButton($arrLocStr[28], 198-1, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Cust"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupFile = GUICtrlCreateButton("File", 240-2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "File" / $arrButtons[1][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupComposite = GUICtrlCreateButton("Comp", 282-3, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Comp" / $arrButtons[2][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupEXIF = GUICtrlCreateButton("EXIF", 324-4, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "EXIF" / $arrButtons[3][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupIPTC = GUICtrlCreateButton("IPTC", 366-5, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "IPTC" / $arrButtons[4][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupXMP = GUICtrlCreateButton("XMP", 408-6, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "XMP" / $arrButtons[5][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnTagGroupMakerNotes = GUICtrlCreateButton("Maker", 450-7, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Maker" / $arrButtons[6][1]
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnListRegions = GUICtrlCreateButton("Region", 492-8, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Region" (XMP:RegionInfoMP)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnViewDescriptIon = GUICtrlCreateButton($arrLocStr[24], 534-9, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Desc" (descript.ion)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "FilterImageTagsOnEvent")

$btnViewThumbnailImage = GUICtrlCreateButton($arrLocStr[29], 576-10, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Thumb"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "ViewThumbnailImageOnEvent")

$btnViewPreviewImage = GUICtrlCreateButton($arrLocStr[30], 618-11, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3, 40, 19, $BS_FLAT) ;*** Filterbutton "Preview"
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetFont(-1, 7)
GUICtrlSetBkColor(-1, $strBGColorInactiveControls)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "ViewPreviewImageOnEvent")

$icoCopySelectedTagsToClipboard = GUICtrlCreateIcon($cstrIcoDir & "\Copy.ico", 0, $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2), Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetOnEvent(-1, "CopySelectedTagsToClipboard")

$icoOpenSyncSelectedTagsDialog = GUICtrlCreateIcon($cstrIcoDir & "\Paste.ico", 0, $intTCInactivePanelW - (18+2 + 5 + 13*1), Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5, 13, 13)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetOnEvent(-1, "OpenSyncSelectedTagsDialogOnEvent")

$cbxPanelDivider = GUICtrlCreateCombo("10", $intTCInactivePanelW - 22, Int($intTCInactivePanelH * ($intPanelDivider/100)) - 6, 20, 20, $CBS_DROPDOWN)
GUICtrlSetData(-1, "15|20|25|30|35|40|45|50|55|60|65|70|75|80|85|90", $intPanelDivider)
GUICtrlSetTip($cbxPanelDivider, $intPanelDivider & "%")
GUICtrlSetResizing(-1, $GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
GUICtrlSetOnEvent(-1, "SetPanelDivider")

#EndRegion Filterbuttons -----------------------------------------------------------

$strTmp = $arrLocStr[31] & "TagGrp|TagID|TagNam|TagVal"
$lvwTags = GUICtrlCreateListView($strTmp, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 22, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 22)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, $strBGColor)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)
$hlvwTags = GUICtrlGetHandle($lvwTags)

$txtDescriptIon = GUICtrlCreateEdit("$txtDescriptIon", 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 20, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 20, $ES_MULTILINE+$WS_TABSTOP+$ES_WANTRETURN+$WS_VSCROLL+$ES_AUTOVSCROLL+$ES_READONLY)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM)
GUICtrlSetColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, $strBGColor)
GUICtrlSetFont(-1, $intListviewFontSize, $intListviewFontWeight, Default, $strListviewFontName)
GUICtrlSetState(-1, $GUI_HIDE)

#Region Kontextmen Listview -------------------------------------------------------
$contextLvwTags = GUICtrlCreateContextMenu($lvwTags)
$contextLvwTagsTagGrpTyp = GUICtrlCreateMenuItem($arrLocStr[42], $contextLvwTags, 0, 1) ;42=Tag grouping: "Type"
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
$contextLvwTagsTagGrpLoc = GUICtrlCreateMenuItem($arrLocStr[43], $contextLvwTags, 1, 1) ;43=Tag grouping: "Specific Location"
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
$contextLvwTagsTagGrpCat = GUICtrlCreateMenuItem($arrLocStr[44], $contextLvwTags, 2, 1) ;44=Tag grouping: "Category"
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
Switch IniRead($cstrIniFile, "Configuration", "TagGrouping", "Typ")
	Case "Loc"
		GUICtrlSetState($contextLvwTagsTagGrpLoc, $GUI_CHECKED)
		$strOptTagGrp = "Loc"
	Case "Cat"
		GUICtrlSetState($contextLvwTagsTagGrpCat, $GUI_CHECKED)
		$strOptTagGrp = "Cat"
	Case Else
		GUICtrlSetState($contextLvwTagsTagGrpTyp, $GUI_CHECKED) ;Fehlwert!
		$strOptTagGrp = "Typ"
EndSwitch
$strOptTagGrpDef = $strOptTagGrp

GUICtrlCreateMenuItem('', $contextLvwTags, 3, 0)
$contextLvwTagsTagNamName = GUICtrlCreateMenuItem($arrLocStr[45], $contextLvwTags, 4, 1) ;45=Tag names: Names
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
$contextLvwTagsTagNamDesc = GUICtrlCreateMenuItem($arrLocStr[46], $contextLvwTags, 5, 1) ;46=Tag names: Localized descriptions
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
If IniRead($cstrIniFile, "Configuration", "TagNames", "Name") = "Desc" Then
	GUICtrlSetState($contextLvwTagsTagNamDesc, $GUI_CHECKED)
	$strOptTagNam = "Desc"
Else
	GUICtrlSetState($contextLvwTagsTagNamName, $GUI_CHECKED) ;Fehlwert!
	$strOptTagNam = "Name"
EndIf
$strOptTagNamDef = $strOptTagNam

GUICtrlCreateMenuItem('', $contextLvwTags, 6, 0)
$contextLvwTagsTagValLit = GUICtrlCreateMenuItem($arrLocStr[47], $contextLvwTags, 7, 1) ;47=Tag values: Literal
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
$contextLvwTagsTagValNum = GUICtrlCreateMenuItem($arrLocStr[48], $contextLvwTags, 8, 1); 48=Tag values: Numeric
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")
If IniRead($cstrIniFile, "Configuration", "TagValues", "Lit") = "Num" Then
	GUICtrlSetState($contextLvwTagsTagValNum, $GUI_CHECKED)
	$strOptTagVal = "Num"
Else
	GUICtrlSetState($contextLvwTagsTagValLit, $GUI_CHECKED) ;Fehlwert!
	$strOptTagVal = "Lit"
EndIf
$strOptTagValDef = $strOptTagVal

_GUICtrlListView_SetColumn($hlvwTags, 0, $arrLocStr[31] & " (" & $strOptTagGrp & ")", $intLvwTagsColWidthTag[0])
_GUICtrlListView_SetColumn($hlvwTags, 1, "ID (Hex)", $intLvwTagsColWidthTag[1])
_GUICtrlListView_SetColumn($hlvwTags, 2, $arrLocStr[36] & " (" & $strOptTagNam & ")", $intLvwTagsColWidthTag[2], $intLvwTagsColAlignTagNam)
_GUICtrlListView_SetColumn($hlvwTags, 3, $arrLocStr[39] & " (" & $strOptTagVal & ")", $intLvwTagsColWidthTag[3])

GUICtrlCreateMenuItem('', $contextLvwTags, 9, 0)
$strTmp = $arrLocStr[49] & ": " & $arrLocStr[31] & " (" & $strOptTagGrpDef & ") - ID (Hex) - " & $arrLocStr[36] & " (" & $strOptTagNamDef & ") - " & $arrLocStr[39] & " (" & $strOptTagValDef & ")"
$contextLvwTagsSetDefOpts = GUICtrlCreateMenuItem($strTmp, $contextLvwTags, 10, 0)
GUICtrlSetOnEvent(-1, "SetOptTagOnEvent")

GUICtrlCreateMenuItem('', $contextLvwTags, 11, 0)
GUICtrlCreateMenuItem($arrLocStr[50], $contextLvwTags, 12, 0)
GUICtrlSetOnEvent(-1, "ExportTagsToTXT")
GUICtrlCreateMenuItem($arrLocStr[51], $contextLvwTags, 13, 0)
GUICtrlSetOnEvent(-1, "ExportTagsToXMP")
GUICtrlCreateMenuItem($arrLocStr[52], $contextLvwTags, 14, 0)
GUICtrlSetOnEvent(-1, "ExportTagsToXML")
GUICtrlCreateMenuItem($arrLocStr[53], $contextLvwTags, 15, 0)
GUICtrlSetOnEvent(-1, "ExportTagsToMIEOnEvent")

GUICtrlCreateMenuItem('', $contextLvwTags, 16, 0)

GUICtrlCreateMenuItem($arrLocStr[54], $contextLvwTags, 17, 0)
GUICtrlSetOnEvent(-1, "CompareTags")
If $strTCProductVersion < "7.50" Then GUICtrlSetState(-1, $GUI_DISABLE)

GUICtrlCreateMenuItem($arrLocStr[109], $contextLvwTags, 18, 0) ;Selected Tags: Copy => Clipboard
GUICtrlSetOnEvent(-1, "CopySelectedTagsToClipboard")

GUICtrlCreateMenuItem($arrLocStr[110], $contextLvwTags, 19, 0) ;Selected Tags: Paste <= Clipboard...
GUICtrlSetOnEvent(-1, "OpenSyncSelectedTagsDialogOnEvent")

GUICtrlCreateMenuItem($arrLocStr[111], $contextLvwTags, 20, 0) ;Selected Tags: Copy from file...
GUICtrlSetOnEvent(-1, "CopySelectedTagsFromFile")

GUICtrlCreateMenuItem($arrLocStr[113], $contextLvwTags, 21, 0) ;Selected Tags: Synchronize...
GUICtrlSetOnEvent(-1, "OpenSyncSelectedFilesDialog")

$contextLvwTagsExecArgFile = GUICtrlCreateMenuItem($arrLocStr[100], $contextLvwTags, 22, 0) ;ExifTool mit Argumenten aus einer *.args-Datei ausfhren...
GUICtrlSetOnEvent(-1, "ExecArgFile")
#cs
$contextLvwTagsConvertUseArgs = GUICtrlCreateMenuItem("Tags konvertieren: *.args-Datei benutzen...", $contextLvwTags, 22, 0) ;Todo: Lokalisieren
GUICtrlSetOnEvent(-1, "ConvertTagGroups")
$contextLvwTagsConvertIPTC2XMP = GUICtrlCreateMenuItem("Tags konvertieren: IPTC -> XMP", $contextLvwTags, 23, 0) ;Todo: Lokalisieren
GUICtrlSetOnEvent(-1, "ConvertTagGroups")
$contextLvwTagsConvertXMP2IPTC = GUICtrlCreateMenuItem("Tags konvertieren: XMP -> IPTC", $contextLvwTags, 24, 0) ;Todo: Lokalisieren
GUICtrlSetOnEvent(-1, "ConvertTagGroups")
#ce

GUICtrlCreateMenuItem('', $contextLvwTags, 23, 0)

$contextLvwTagsDeleteAllTags = GUICtrlCreateMenuItem($arrLocStr[55], $contextLvwTags, 24, 0)
GUICtrlSetOnEvent(-1, "DeleteTagGroups")
$contextLvwTagsDeleteIPTCTags = GUICtrlCreateMenuItem($arrLocStr[101], $contextLvwTags, 25, 0) ;Tags lschen: Alle IPTC-Tags
GUICtrlSetOnEvent(-1, "DeleteTagGroups")
$contextLvwTagsDeleteXMPTags = GUICtrlCreateMenuItem($arrLocStr[102], $contextLvwTags, 26, 0) ;Tags lschen: Alle XMP-Tags
GUICtrlSetOnEvent(-1, "DeleteTagGroups")
$contextLvwTagsDeleteSelectedTags = GUICtrlCreateMenuItem($arrLocStr[112], $contextLvwTags, 27, 0) ;Selected Tags: Delete...
GUICtrlSetOnEvent(-1, "DeleteSelectedTags")


GUICtrlCreateMenuItem('', $contextLvwTags, 28, 0)
$contextLvwTagsConvertCP1252 = GUICtrlCreateMenuItem($arrLocStr[56], $contextLvwTags, 29, 1)
GUICtrlSetOnEvent(-1, "SetChrSetConversion")
$contextLvwTagsConvertUTF8   = GUICtrlCreateMenuItem($arrLocStr[57], $contextLvwTags, 30, 1)
GUICtrlSetOnEvent(-1, "SetChrSetConversion")
GUICtrlSetState($contextLvwTagsConvertUTF8, $GUI_CHECKED)
$booAlwaysWriteUTF8 = True

GUICtrlCreateMenuItem('', $contextLvwTags, 31, 0)

;bookmark
$contextLvwUseSidecarFile = GUICtrlCreateMenuItem(StringReplace($arrLocStr[114], "%ext", $strSidecarFileType), $contextLvwTags, 32, 0) ;Use "sidecar" file (*.%ext)
GUICtrlSetOnEvent(-1, "UseSidecarFile")
If $intUseSidecarFile = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)

$contextLvwAllowDuplicateTagNames = GUICtrlCreateMenuItem($arrLocStr[58], $contextLvwTags, 33, 0)
GUICtrlSetOnEvent(-1, "SetAllowDuplicateTagNames")
If $strOptDup = "-a" Then GUICtrlSetState($contextLvwAllowDuplicateTagNames, $GUI_CHECKED)

$contextLvwTagsSetBackupState = GUICtrlCreateMenuItem($arrLocStr[60], $contextLvwTags, 34, 0)
GUICtrlSetOnEvent(-1, "SetBackupState")
If IniRead($cstrIniFile, "Configuration", "Backup", 1) * 1 = 1 Then
	$booBackup = True
	GUICtrlSetState($contextLvwTagsSetBackupState, $GUI_CHECKED)
Else
	$booBackup = False
EndIf

GUICtrlCreateMenuItem('', $contextLvwTags, 35, 0)
GUICtrlCreateMenuItem($arrLocStr[61], $contextLvwTags, 36, 0)
GUICtrlSetOnEvent(-1, "EditIni")
GUICtrlCreateMenuItem($arrLocStr[62], $contextLvwTags, 37, 0)
GUICtrlSetOnEvent(-1, "About")
#EndRegion Kontextmen Listview ----------------------------------------------------

$lblFilename = GUICtrlCreateLabel("", 2, $intTCInactivePanelH - $intTCInactiveFooterH, $intTCInactivePanelW - 91-1-20, $intTCInactiveFooterH)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKRIGHT+$GUI_DOCKHEIGHT)
GUICtrlSetBkColor(-1, $strBGColorActiveControls)
GUICtrlSetFont(-1, 8.5, Default, Default, "Segoe UI")

$lblMoveCursorDirection = GUICtrlCreateLabel("", $intTCInactivePanelW - 52-1-35-1-20, $intTCInactivePanelH - $intTCInactiveFooterH, 20, $intTCInactiveFooterH, $SS_CENTER) ; = PfeilRechts, PfeilUnten (oder: )
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
;~ GUICtrlSetBkColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, 0xC2D8FC) ;hell=0xD8E4FD; mittel=0xC2D8FC; dunkel=0xB3D0FC
GUICtrlSetColor(-1, 0x4D6185)
GUICtrlSetFont(-1, 12, Default, Default, "Wingdings")
GUICtrlSetOnEvent(-1, "ToggleMoveCursorDirection")

$lblScale = GUICtrlCreateLabel("", $intTCInactivePanelW - 52-1-35, $intTCInactivePanelH - $intTCInactiveFooterH, 35, $intTCInactiveFooterH, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
;~ GUICtrlSetBkColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, 0xC2D8FC) ;hell=0xD8E4FD; mittel=0xC2D8FC; dunkel=0xB3D0FC
GUICtrlSetColor(-1, 0x4D6185)
GUICtrlSetFont(-1, 8.5, Default, Default, "Segoe UI")
GUICtrlSetOnEvent(-1, "Magnify")

$lblStatus = GUICtrlCreateLabel("", $intTCInactivePanelW - 52, $intTCInactivePanelH - $intTCInactiveFooterH, 50, $intTCInactiveFooterH, $SS_CENTER)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
;~ GUICtrlSetBkColor(-1, $strBGColorActiveControls)
GUICtrlSetBkColor(-1, 0xC2D8FC) ;hell=0xD8E4FD; mittel=0xC2D8FC; dunkel=0xB3D0FC
GUICtrlSetColor(-1, 0x4D6185)
GUICtrlSetFont(-1, 8.5, Default, Default, "Segoe UI")
GUICtrlSetOnEvent(-1, "Refresh")

$frmRectangle = GUICreate("", 64, 64, 0, 0, $WS_SIZEBOX, BitOR($WS_EX_LAYERED, $WS_EX_MDICHILD, $WS_EX_TOOLWINDOW), $frmMain)
;~ $picTransparent = GUICtrlCreatePic($cstrIcoDir & "\Transparent.gif", 0, 0, 64, 64)
GUISetBkColor(0xABCDEF, $frmRectangle)
_WinAPI_SetLayeredWindowAttributes($frmRectangle, 0xABCDEF)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit", $frmRectangle)
GUISetState(@SW_HIDE, $frmRectangle)

#EndRegion Hauptdialog erstellen ---------------------------------------------------


;*** ExifTool-Versionsnummer ermitteln
$strExifToolVersion = RunExifTool("GetExifToolVer", " -ver", 0) ;*** ExifTool() hier noch nicht verwendbar, da zunchst *_WritableExts.txt und *_XMLTagDB.xml ggf. aktualisiert werden mssen
$strExifToolVersion = StringStripWS($strExifToolVersion, 1+2)


;*** Prfen, ob beim ersten Aufruf von Func OpenEditTagDialog() TCMetadataViewer_ExifTool_WritableExts.txt und TCMetadataViewer_ExifTool_XMLTagDB.xml aktualisiert werden mssen
$booRefreshExifToolRefData = False
$strExifToolConfigVersion = ""
$p = StringInStr($strExifToolPath, "\", 0, -1)
$strExifToolConfigPath = StringLeft($strExifToolPath, $p) & ".ExifTool_config"
If FileExists($strExifToolConfigPath) Then $strExifToolConfigVersion = FileGetTime($strExifToolConfigPath, 0, 1) & @TAB & FileGetSize($strExifToolConfigPath)

$strFileName = @ScriptDir & "\TCMetadataViewer_ExifTool_WritableExts.txt"
If Not FileExists($strFileName) Then
	$booRefreshExifToolRefData = True

Else
	$strFileVersion = FileReadLine($strFileName, 1) ;Zeile 1: Version TCMetadataViewer
	If $strFileVersion <> $cstrTCMetadataViewerVersion Then $booRefreshExifToolRefData = True

	$strFileVersion = FileReadLine($strFileName, 2) ;Zeile 2: Version (nderungsdatum und Gre) .ExifTool_config
	If FileExists($strExifToolConfigPath) Then
		If $strFileVersion <> $strExifToolConfigVersion Then $booRefreshExifToolRefData = True
	Else
		If $strFileVersion <> "" Then $booRefreshExifToolRefData = True
	EndIf

	$strFileVersion = FileReadLine($strFileName, 3) ;Zeile 3: Version ExifTool
	If $strFileVersion <> $strExifToolVersion Then $booRefreshExifToolRefData = True

EndIf

If $booRefreshExifToolRefData = True Then

	$strFileName = @ScriptDir & "\TCMetadataViewer_ExifTool_WritableExts.txt"
	SplashTextOn($cstrTCMetadataViewerVersion, $arrLocStr[4], 300, 100, Default, Default, 4, "Segoe UI", 9, Default)
	FileDelete($strFileName) ;Falls TCMetadataViewer_ExifTool_WritableExts.txt bereits existiert
	FileWrite($strFileName, $cstrTCMetadataViewerVersion & @CRLF & $strExifToolConfigVersion & @CRLF)
	$strExifToolCmd = '"' & $strExifToolPath & '" -ver -listwf >>"' & $strFileName & '"'
	WriteLog("BuildWriExtsList", $strExifToolCmd)
	RunWait(@ComSpec & ' /S /c "' & $strExifToolCmd & '"', "", @SW_HIDE)
	SplashOff()

	$strFileName = @ScriptDir & "\TCMetadataViewer_ExifTool_XMLTagDB.xml"
	SplashTextOn($cstrTCMetadataViewerVersion, $arrLocStr[5], 300, 100, Default, Default, 4, "Segoe UI", 9, Default)
	$strExifToolCmd = '"' & $strExifToolPath & '" -listx -f >"' & $strFileName & '"'
	WriteLog("BuildXMLTagDB", $strExifToolCmd)
	RunWait(@ComSpec & ' /S /c "' & $strExifToolCmd & '"', "", @SW_HIDE)
	SplashOff()

;~ 	$booRefreshExifToolRefData = False

EndIf

;*** G1 und G2 fr XMP:DaylightSavings ermitteln
$strXMPDaylightSavingsG1 = ""
$strXMPDaylightSavingsG2 = ""
If $intShowXMPDaylightSavings > 0 And $intXMLTagDBOpen = 0 Then ;$intXMLTagDBOpen =  0: XMLTagDB wurde noch nicht versucht zu laden
	If _XMLFileOpen(@ScriptDir & "\TCMetadataViewer_ExifTool_XMLTagDB.xml") Then
		$intXMLTagDBOpen = 1  ;$intXMLTagDBOpen =  1: XMLTagDB wurde erfolgreich geladen
		$strXPath = "//table/tag[@g0='XMP' and @name='DaylightSavings']/parent::*"
		$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
		If $intXMLTagDBNodeCount < 1 Then
			$strXPath = "//table[@g0='XMP']/tag[@name='DaylightSavings']/parent::*"
			$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
		EndIf
		For $i = 0 To $intXMLTagDBNodeCount - 1
			$arrXMLTagDBNode = _XMLGetAllAttribIndex($strXPath, $arrXMLTagDBAttrNam, $arrXMLTagDBAttrVal, "", $i)
			For $j = 0 To UBound($arrXMLTagDBAttrNam) - 1
				If $arrXMLTagDBAttrNam[$j] = "g1" Then $strXMPDaylightSavingsG1 = $arrXMLTagDBAttrVal[$j] & ":DaylightSavings"
				If $arrXMLTagDBAttrNam[$j] = "g2" Then $strXMPDaylightSavingsG2 = $arrXMLTagDBAttrVal[$j] & ":DaylightSavings"
			Next
		Next
	Else
		$intXMLTagDBOpen = -1 ;$intXMLTagDBOpen = -1: Fehler beim Laden der XMLTagDB
	EndIf
EndIf

;*** Dialog anzeigen
GUISwitch($frmMain)
GUISetState(@SW_SHOW, $frmMain)
GUIRegisterMsg($WM_NOTIFY, "My_WM_NOTIFY")

WinActivate($whTC)

#Region Main -----------------------------------------------------------------------
While 1

	Sleep(300)
	If $booLocked = True Then ContinueLoop

	If WinActive("[CLASS:TQUICKSEARCH]") Then WinWaitNotActive("[CLASS:TQUICKSEARCH]") ;Dialog "Schnelle Suche: Buchstaben - mit Suchen-Dialog" hat Fokus -> Fokusklau verhindern

	;Todo: Mglichkeit schaffen, das automatische Minimieren von $frmMain bei Aktivierung einer Drittanwendung an-/auszuschalten
;~ 	#cs --- Temporr deaktiviert 21.12.2011
	If WinActive($whTC) = 0 And WinActive("[CLASS:TPathSelForm]") = 0 _
	And WinActive($frmMain) = 0 _
	And WinActive($frmRectangle) = 0 _
	And WinActive($frmEdit) = 0 _
	And WinActive($frmShiftDateTime) = 0 _
	And WinActive($frmSyncSelectedTags) = 0 _
	And WinActive($frmSyncSelectedFiles) = 0 Then
		WinSetState($frmMain, "", @SW_SHOWMINNOACTIVE)
		WinWaitActive($whTC)
		WinSetState($frmMain, "", @SW_SHOWNOACTIVATE) ;ToDo: Bug: TC verliert trotz "@SW_SHOWNOACTIVATE" den Fokus, kurioserweise erst beim zweiten Durchlauf
	EndIf
;~ 	#ce


	$strTCPathCurOri = ControlGetText($whTC, "", $strClassnameTCActivePath)
	$p = StringInStr($strTCPathCurOri, "\", 0, -1)
	If $p > 0 Then $strTCPathCurOri = StringLeft($strTCPathCurOri, $p) ;*** Abschneiden des Dateifilters ("*.*" o..)

;~ 	$strTCFileCurOri = _GUICtrlListBox_GetText($hndTCActivePanel, _GUICtrlListBox_GetCurSel($hndTCActivePanel))
	$strTCFileCurOri = ControlCommand($whTC, "", $hndTCActivePanel, "GetCurrentSelection", "")

	;*** Beim Wechsel der Ansicht Dateiliste <-> Miniaturansicht ndert sich das Handle des Filepanels (und die CtrlID) => _GUICtrlListBox_* liefern leeres Ergebnis
	If $strTCFileCurOri = "" Then
		GetTCActivePanelProperties()
		ToggleMoveCursorDirection()
;~ 		$strTCFileCurOri = _GUICtrlListBox_GetText($hndTCActivePanel, _GUICtrlListBox_GetCurSel($hndTCActivePanel)) ;Todo: Prfen, ob berflssig, da auch in GetTCActivePanelProperties() ermittelt?
	EndIf

	;*** In der Miniaturansicht sind markierte (selektierte) Eintrge durch einen fhrenden "*" gekennzeichnet
	If StringLeft($strTCFileCurOri, 1) = "*" Then $strTCFileCurOri = StringTrimLeft($strTCFileCurOri, 1)

	If $intTCGetTextMode = 0 Then
		;*** Das Auftreten von " >" kennzeichnet einen Eintrag einer benutzerdef. Spaltenansicht
		$p = StringInStr($strTCFileCurOri, " >")
		If $p = 0 Then
			;*** Prfen, ob die letzten 5 Zeichen des Eintrags der Struktur des Attr.-Strings in Ansicht "Lang" entsprechen
			;*** TC liefert "Lang"-Format (also "{Name} {Gre} {Datum} {Uhrzeit} {Attr}") sowohl in Ansicht "Lang" als auch in "Miniaturansicht" zurck
			;*** Ansicht: Lang / Miniatur
			If StringRegExp(StringRight($strTCFileCurOri, 5), " [-r][-a][-h][-s]") = 1 Then
				$p = StringInStr($strTCFileCurOri, " ", 0, $intTCFNameDelimPosInFullView)
				$strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
			;*** Ansicht: Kurz
			;Else
				;NOP
			EndIf
		;*** Ansicht: Benutzerdefiniert
		Else
			$strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
		EndIf
	Else
		$p = StringInStr($strTCFileCurOri, $strTCGetTextModeDelim)
		If $p > 0 Then $strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
		;*** Bei $intTCGetTextMode = 4 oder 5 wird dem Spaltenwert der Spaltenname vorangestellt (mit <Tab> vom Spaltenwert getrennt)
		If $intTCGetTextMode = 4 Or $intTCGetTextMode = 5 Then $strTCFileCurOri = StringMid($strTCFileCurOri, StringInStr($strTCFileCurOri, @TAB)+1)
	EndIf


	;*** In der Zweigansicht (Strg+b) enthlt $strTCFileCurOri einen (zum Pfad in der Pfadleiste) relativen Dateipfad (sofern ber _GUICtrlListBox_GetText() ermittelt)!
	$p = StringInStr($strTCFileCurOri, "\", 0, -1)
	If $p > 0 Then
		$strTCPathCurOri &= StringLeft($strTCFileCurOri, $p) ;*** $strTCPathCurOri um Pfadkomponenten ergnzen
		$strTCFileCurOri = StringMid($strTCFileCurOri, $p+1) ;*** $strTCFileCurOri auf reinen Dateinamen krzen
	EndIf

	$arrTCMainWinPos = WinGetPos($whTC) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe
	$intTMyListBoxInstanceOffset = GetTMyListBoxInstanceOffset()
	$arrTCRPanelPos = ControlGetPos($whTC, "", $strClassnameTCRPanel & 1+$intTMyListBoxInstanceOffset) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe ;Koordinaten relativ zur ClientArea
	;*** Fenster wurde grenverndert oder TCPanelDivider wurde verschoben
	If $arrTCRPanelPos[2] <> $intTCRPanelWMem Or $arrTCRPanelPos[3] <> $intTCRPanelHMem Then
;~ 		WriteLog("Debug:MainLoop", "Fenster wurde grenverndert oder TCPanelDivider wurde verschoben") ;debug
		$booRefreshGUI = True
	;*** Fenster wurde verschoben, aber nicht grenverndert
	ElseIf $arrTCMainWinPos[0] <> $arrTCMainWinPosMem[0] Or $arrTCMainWinPos[1] <> $arrTCMainWinPosMem[1] Then
		$intTCInactivePanelX = $intTCInactivePanelX + ($arrTCMainWinPos[0] - $arrTCMainWinPosMem[0])
		$intTCInactivePanelY = $intTCInactivePanelY + ($arrTCMainWinPos[1] - $arrTCMainWinPosMem[1])
		$arrTCMainWinPosMem[0] = $arrTCMainWinPos[0]
		$arrTCMainWinPosMem[1] = $arrTCMainWinPos[1]
		WinMove($frmMain, "", $intTCInactivePanelX, $intTCInactivePanelY)
		GUICtrlSetPos($lvwTags, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 22, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 22)
		GUICtrlSetPos($txtDescriptIon, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 22, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 22)

		#cs
		$x = $intTCInactivePanelX-550-4
		If $x < 1 Then $x = 1
;~ 	 	$y = $intTCInactivePanelY + Int($intTCInactivePanelH * ($intPanelDivider/100)) + 20
;~ 	 	If $y+244 > @DesktopHeight Then $y = @DesktopHeight - 244
;~ 	 	WinMove($frmEdit, "", $x, $y)
		WinMove($frmEdit, "", $x, Default)
		#ce

	;*** Fenster wurde weder grenverndert noch verschoben
	Else
		;NOP
	EndIf

	#cs
	;*** RegionRectangle exists+visible+enabled+active ;Todo: Derzeit keine Prfung, ob Fenster $frmRectangle grenverndert wurde (*nur dann* muss $picTransparent angepasst werden)
	If WinGetState($frmRectangle) = 1+2+4+8 Then
		$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
		GUICtrlSetPos($picTransparent, 0, 0, $arrRectangleClientPos[0], $arrRectangleClientPos[1])
	EndIf
	#ce

	If $strTCPathCurOri & $strTCFileCurOri <> $strTCPathMemOri & $strTCFileMemOri Then

		;*** Wenn "Metadaten editieren"-Dialog noch nicht verlassen wurde, diesen beim Verzeichnis-/Dateiwechsel verlassen
		If BitAND(WinGetState($frmEdit), 2) Then _Exit()

;~ 		WriteLog("{ Main - Loop Begin", $strTCPathCurOri & $strTCFileCurOri) ;debug

		$booMagnify = False
		GUICtrlSetColor($lblScale, 0x4D6185)

		;*** Minimal-Umgehungslsung fr Unicode-Dateipfade
		$strTCPathCur = "" ;Test (oder ".\" statt ""?)
		$strTCFileCur = $strTCFileCurOri
		$booUnicodeFilename = False

		$strTCFilepathCurShort = FileGetShortName($strTCPathCurOri & $strTCFileCurOri)
		$p = StringInStr($strTCFilepathCurShort, "\", 0, -1)
		$strTCPathCurShort = StringLeft($strTCFilepathCurShort, $p)
		$strTCFileCurShort = StringMid($strTCFilepathCurShort, $p+1)

		If $strTCPathCurOri <> $strTCPathMemOri Then
			If $strTCPathCurOri = BinaryToString($strTCPathCurOri) Then
				WriteLog("ChangeDir", $strTCPathCurOri)
				FileChangeDir($strTCPathCurOri)
			Else
				WriteLog("GetShortName", $strTCPathCurOri & "   =>   " & $strTCPathCurShort)
				WriteLog("ChangeDir", $strTCPathCurShort)
				FileChangeDir($strTCPathCurShort)
			EndIf
			RestartExifTool($strArgFileEncoding)
		EndIf

		If $strTCFileCurOri <> BinaryToString($strTCFileCurOri) Then
			WriteLog("GetShortName", $strTCFileCurOri & "   =>   " & $strTCFileCurShort)
			$strTCFileCur = $strTCFileCurShort
			$booUnicodeFilename = True
		EndIf

		$strTCExtCur = ""
		$p = StringInStr($strTCFileCur, ".", 0, -1)
		If $p > 0 Then $strTCExtCur = StringMid($strTCFileCur, $p+1)

		$strTagFilter = $strTagFilterMem ;*** Filter des zuletzt angeklickten Filterbutton setzen (benutzter Filter wurde u.U. automatisch auf "All" gendert)

		If $booViewPJG = True Then
			If $booFileIsModified = True Then
				;GUICtrlSetColor($lblStatus, 0xEABA4A)
				GUICtrlSetData($lblStatus, "PackJPG")
				;*** Option "-np" (no pause after processing files) neu mit packJPG 2.4. Fhrt mit v2.3 zu einem Fehler ("file "-np" doesn't exist")
				$strPackJPGCmd = '"' & $strPackJPGPath & '"'
				If StringLeft($strPackJPGVer, StringInStr($strPackJPGVer," ")-1) >= "v2.4" Then $strPackJPGCmd &= ' -np'
				$strPackJPGCmd &= ' -o "' & $cstrTmpPath & $strTCFileTmp & '"'
				$strStdOut = ""
				$strStdErr = ""
				WriteLog("PackJPG", $strPackJPGCmd)
				$pidPackJPG = Run(@ComSpec & ' /S /c "' & $strPackJPGCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
				While 1
					$strStdOut &= StdoutRead($pidPackJPG)
					If @error Then ExitLoop
				Wend
				While 1
					$strStdErr &= StderrRead($pidPackJPG)
					If @error Then ExitLoop
				Wend
				ProcessWaitClose($pidPackJPG)

				If $strStdErr <> "" Then ;*** PackJPG hat eine Fehlermeldung ausgegeben
					$strErrMsg = "PackJPG: " & StringStripWS($strStdErr, 1+2)
					WriteLog("PackJPG", StringReplace($strErrMsg, @CRLF, " | "))
					MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on PackJPG", $strErrMsg)
				Else
					FileSetTime($cstrTmpPath & StringTrimRight($strTCFileTmp, 3) & "pjg", FileGetTime($cstrTmpPath & $strTCFileTmp, 0, 1), 0) ;DateTimeModified des JPG aufs PJG bertragen
					WriteLog("FileMove", $cstrTmpPath & StringTrimRight($strTCFileTmp, 3) & "pjg   =>   " & $strTCPathMem)
					FileMove($cstrTmpPath & StringTrimRight($strTCFileTmp, 3) & "pjg", ".", 1) ;PJG ins Originalverzeichnis verschieben
				EndIf

				$booFileIsModified = False
			EndIf
			If FileExists($cstrTmpPath & $strTCFileTmp) Then FileDelete($cstrTmpPath & $strTCFileTmp) ;Entpacktes JPG aus @TempDir lschen
			$booViewPJG = False
		EndIf

		If $booViewMPO = True Then
			If FileExists($cstrTmpPath & $strTCFileTmp) Then FileDelete($cstrTmpPath & $strTCFileTmp) ;Generiertes Anaglyphen-JPG aus @TempDir lschen
			$booViewMPO = False
		EndIf

		GUICtrlSetData($lblFilename, $strTCFileCurOri & "  [" & $strTCPathCurOri & "]")
		GUICtrlSetTip($lblFilename, $strTCFileCurOri & "  [" & $strTCPathCurOri & "]")
		$strTCPathMem = $strTCPathCur
		$strTCFileMem = $strTCFileCur
		$strTCPathMemOri = $strTCPathCurOri
		$strTCFileMemOri = $strTCFileCurOri

		;*** Altes Vorschaubild maskieren
		GUICtrlSetPos($picPic, 1, 1, 1, 1)
		GUICtrlSetImage($picPic, $cstrIcoDir & "\Blank.jpg")
		GUICtrlSetPos($picPic, Int((($intTCInactivePanelW - 59) - 48) / 2), Int(($intPicH - 48) / 2) + 1 + $intShowImageTitle*20, 48, 48)

		GUICtrlSetImage($picPic, $cstrIcoDir & "\Wait.jpg")

		GUICtrlSetState($lblRegionRectangle, $GUI_HIDE)

		;*** Listview leeren, Group-Buttons ausblenden
		_GUICtrlListView_DeleteAllItems($hlvwTags)
		GUICtrlSetData($lblScale, "")
		$arrTagList = ""
		$intBtnTagGroupFileState = $GUI_HIDE
		$intBtnTagGroupCompositeState = $GUI_HIDE
		$intBtnTagGroupEXIFState = $GUI_HIDE
		$intBtnTagGroupIPTCState = $GUI_HIDE
		$intBtnTagGroupXMPState = $GUI_HIDE
		$intBtnTagGroupMakerNotesState = $GUI_HIDE
		$intBtnListRegionsState = $GUI_HIDE
		$intBtnViewDescriptIonState = $GUI_HIDE
		$intBtnViewThumbnailImageState = $GUI_HIDE
		$intBtnViewPreviewImageState = $GUI_HIDE

		GUICtrlSetState($btnTagGroupFile, $GUI_HIDE)
		GUICtrlSetState($btnTagGroupComposite, $GUI_HIDE)
		GUICtrlSetState($btnTagGroupEXIF, $GUI_HIDE)
		GUICtrlSetState($btnTagGroupIPTC, $GUI_HIDE)
		GUICtrlSetState($btnTagGroupXMP, $GUI_HIDE)
		GUICtrlSetState($btnTagGroupMakerNotes, $GUI_HIDE)
		GUICtrlSetState($btnListRegions, $GUI_HIDE)
		GUICtrlSetState($btnViewDescriptIon, $GUI_HIDE)
		GUICtrlSetState($btnViewThumbnailImage, $GUI_HIDE)
		GUICtrlSetState($btnViewPreviewImage, $GUI_HIDE)

		GUICtrlSetState($lblDateTimeOriginal, $GUI_HIDE)
		GUICtrlSetState($lblDateTimeOriginalDate, $GUI_HIDE)
		GUICtrlSetState($lblDateTimeOriginalTime, $GUI_HIDE)
		GUICtrlSetState($lblDateTimeOriginalDST, $GUI_HIDE)

		GUICtrlSetState($contextPicPicPlaySound, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicShowGPSPos, $GUI_DISABLE)
		If $strImageConverter = "IrfanView" Then GUICtrlSetState($contextPicPicOptimize, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicRotate090, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicRotate180, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicRotate270, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicRotateExif, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicViewThumbnailImage, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicSaveThumbnailImage, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicDeleteThumbnailImage, $GUI_DISABLE)
;~ 		GUICtrlSetState($btnViewPreviewImage, $GUI_HIDE)
		GUICtrlSetState($contextPicPicViewPreviewImage, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicSavePreviewImage, $GUI_DISABLE)
		GUICtrlSetState($contextPicPicDeletePreviewImage, $GUI_DISABLE)

		GUICtrlSetColor($lblFilename, 0x000000)

		$booFileIsValid = FileIsValid($strTCPathCur & $strTCFileCur)
		If $booFileIsValid Then

			If $strTCExtCur = "pjg" And $strPackJPGPath <> "" Then
				;GUICtrlSetColor($lblStatus, 0xEABA4A)
				GUICtrlSetData($lblStatus, "PackJPG")
				$strTCFileTmp = StringTrimRight($strTCFileCur, 3) & "jpg"
				WriteLog("FileCopy", $strTCPathCur & $strTCFileCur & "   =>   " & @TempDir)
				FileCopy($strTCPathCur & $strTCFileCur, @TempDir, 1) ;PJG nach @TempDir kopieren
				;*** Option "-np" (no pause after processing files) neu mit packJPG 2.4. Fhrt mit v2.3 zu einem Fehler ("file "-np" doesn't exist"), der aber ignoriert werden kann
				$strPackJPGCmd = '"' & $strPackJPGPath & '"'
				If StringLeft($strPackJPGVer, StringInStr($strPackJPGVer," ")-1) >= "v2.4" Then $strPackJPGCmd &= ' -np'
				$strPackJPGCmd &= ' -o "' & $cstrTmpPath & $strTCFileCur & '"'
				$strStdOut = ""
				$strStdErr = ""
				WriteLog("UnPackJPG", $strPackJPGCmd)
				$pidPackJPG = Run(@ComSpec & ' /S /c "' & $strPackJPGCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
				While 1
					$strStdOut &= StdoutRead($pidPackJPG)
					If @error Then ExitLoop
				Wend
				While 1
					$strStdErr &= StderrRead($pidPackJPG)
					If @error Then ExitLoop
				Wend
				ProcessWaitClose($pidPackJPG)

				If $strStdErr <> "" Then ;*** PackJPG hat eine Fehlermeldung ausgegeben
					$strErrMsg = "UnPackJPG: " & StringStripWS($strStdErr, 1+2)
					WriteLog("UnPackJPG", StringReplace($strErrMsg, @CRLF, " | "))
					MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on UnPackJPG", $strErrMsg)
				Else
					FileSetTime($cstrTmpPath & $strTCFileTmp, FileGetTime($cstrTmpPath & $strTCFileCur, 0, 1), 0) ;DateTimeModified des PJG aufs JPG bertragen
					If FileExists($cstrTmpPath & $strTCFileCur) Then FileDelete($cstrTmpPath & $strTCFileCur) ;Kopie des PJG aus @TempDir lschen
					$strTCPathCur = $cstrTmpPath
					$strTCFileCur = $strTCFileTmp
					$strTCExtCur = "jpg"
					GUICtrlSetData($lblFilename, $strTCFileCur & "  [" & $strTCPathCur & "]")
					GUICtrlSetTip($lblFilename, $strTCFileCur & "  [" & $strTCPathCur & "]")
					$booViewPJG = True
				EndIf

			EndIf

			If $strTCExtCur = "mpo" And $strMPOToolBoxPath <> "" Then
				;GUICtrlSetColor($lblStatus, 0xEABA4A)
				GUICtrlSetData($lblStatus, "GenAnaglyph") ;*** Generate a single red/cyan anaglyph image
				$strTCFileTmp = StringTrimRight($strTCFileCur, 4) & "_dub.jpg" ;*** Todo: Suffix "dub" gilt nur, wenn MPOToolBoxPath=MPO2DUBOIS.exe. Anpassen: Fr MPO2ANAGLYPH.exe gilt "_ana"!
				WriteLog("FileCopy", $strTCPathCur & $strTCFileCur & "   =>   " & @TempDir)
				FileCopy($strTCPathCur & $strTCFileCur, @TempDir, 1) ;MPO nach @TempDir kopieren
				$strMPOToolBoxCmd = '"' & $strMPOToolBoxPath & '" "' & $cstrTmpPath & $strTCFileCur & '"'
				$strStdOut = ""
				$strStdErr = ""
				WriteLog("GenAnaglyphImage", $strMPOToolBoxCmd)
				$pidMPOToolBox = Run(@ComSpec & ' /S /c "' & $strMPOToolBoxCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
				While 1
					$strStdOut &= StdoutRead($pidMPOToolBox)
					If @error Then ExitLoop
				Wend
				While 1
					$strStdErr &= StderrRead($pidMPOToolBox)
					If @error Then ExitLoop
				Wend
				ProcessWaitClose($pidMPOToolBox)

				If $strStdErr <> "" Then ;*** MPOToolBox hat eine Fehlermeldung ausgegeben
					$strErrMsg = "GenAnaglyphImage: " & StringStripWS($strStdErr, 1+2)
					WriteLog("GenAnaglyphImage", StringReplace($strErrMsg, @CRLF, " | "))
					MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on GenAnaglyphImage", $strErrMsg)
				Else
;~ 					FileSetTime($cstrTmpPath & $strTCFileTmp, FileGetTime($cstrTmpPath & $strTCFileCur, 0, 1), 0) ;DateTimeModified des MPO aufs JPG bertragen
					If FileExists($cstrTmpPath & $strTCFileCur) Then FileDelete($cstrTmpPath & $strTCFileCur) ;Kopie des MPO aus @TempDir lschen
					$strTCPathCur = $cstrTmpPath
					$strTCFileCur = $strTCFileTmp
					$strTCExtCur = "jpg"
					GUICtrlSetData($lblFilename, $strTCFileCur & "  [" & $strTCPathCur & "]")
					GUICtrlSetTip($lblFilename, $strTCFileCur & "  [" & $strTCPathCur & "]")
					$booViewMPO = True
				EndIf

			EndIf

			$booRefresh = True

		Else
			GUICtrlSetImage($picPic, $cstrIcoDir & "\NoQuickviewAvailable.jpg")
			$booRefresh = False
			$strTagFilter = "All"
			FilterImageTags()

		EndIf

		;*** "Schnellzugriffsleiste" fr XMP:Rating und XMP:Label nur fr Dateitypen einblenden, in die XMP-Infos eingebettet werden knnen
		$intXMPRatingState = $GUI_HIDE
		$intXMPLabelState = $GUI_HIDE
		If IniRead($cstrIniFile, "FileExtensionsXMPTags", $strTCExtCur, "0") = "1" Then
			$intXMPRatingState = $GUI_SHOW
			$intXMPLabelState = $GUI_SHOW
		EndIf
		If $intShowXMPLabel = 0 Then $intXMPLabelState = $GUI_HIDE

		$arrXMPLabel = StringSplit("Red|Yellow|Green|Blue|Purple", "|")
		GUICtrlSetState($lblXMPRating, $intXMPRatingState)
		GUICtrlSetState($lblXMPLabel, $intXMPLabelState)
		For $i = 1 To 5
			GUICtrlSetState(Eval("lblXMPRating" & $i), $intXMPRatingState)
			GUICtrlSetState(Eval("icoXMPRating" & $i), $intXMPRatingState)
			GUICtrlSetState(Eval("icoXMPLabel" & $arrXMPLabel[$i]), $intXMPLabelState)
			GUICtrlSetState(Eval("lblXMPLabel" & $arrXMPLabel[$i]), $intXMPLabelState)
		Next
		GUICtrlSetState($icoXMPRatingRej, $intXMPRatingState)
		GUICtrlSetState($icoXMPRatingMinus, $intXMPRatingState)
		GUICtrlSetState($icoXMPRatingPlus, $intXMPRatingState)

		$intUpdownPanelDividerPosY = Int($intTCInactivePanelH * ($intPanelDivider/100)) - 5

		If $intXMPRatingState = $GUI_SHOW Then
			If $intUpdownPanelDividerPosY <= 80 + 6*15 + 9 Then
				GUICtrlSetState($icoXMPRatingRej, $GUI_HIDE)
				GUICtrlSetState($icoXMPRatingMinus, $GUI_HIDE)
				GUICtrlSetState($icoXMPRatingPlus, $GUI_HIDE)
			Else
				GUICtrlSetState($icoXMPRatingRej, $GUI_SHOW)
				GUICtrlSetState($icoXMPRatingMinus, $GUI_SHOW)
				GUICtrlSetState($icoXMPRatingPlus, $GUI_SHOW)
			EndIf
			If $strLayoutXMPRating = "Boxes" Then
				For $intXMPRating = 1 To 5
					If $intUpdownPanelDividerPosY <= 80 + Abs($intXMPRating-6)*15 + 9 Then
						GUICtrlSetState(Eval("lblXMPRating" & $intXMPRating), $GUI_HIDE)
						GUICtrlSetState(Eval("icoXMPRating" & $intXMPRating), $GUI_HIDE)
					Else
						GUICtrlSetState(Eval("lblXMPRating" & $intXMPRating), $GUI_SHOW)
						GUICtrlSetState(Eval("icoXMPRating" & $intXMPRating), $GUI_SHOW)
					EndIf
				Next
				If $intUpdownPanelDividerPosY <= 80 + Abs(5-6)*15 + 9 Then
					GUICtrlSetState($lblXMPRating, $GUI_HIDE)
				Else
					GUICtrlSetState($lblXMPRating, $GUI_SHOW)
				EndIf
			EndIf
		EndIf

		If $intXMPLabelState = $GUI_SHOW Then
			$arrXMPLabel = StringSplit("Red|Yellow|Green|Blue|Purple", "|")
			For $intXMPLabel = 1 To $arrXMPLabel[0]
				If $intUpdownPanelDividerPosY <= 179+15 + $intXMPLabel * 14 + 12 Then
					GUICtrlSetState(Eval("icoXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_HIDE)
					GUICtrlSetState(Eval("lblXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_HIDE)
				Else
					GUICtrlSetState(Eval("icoXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_SHOW)
					GUICtrlSetState(Eval("lblXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_SHOW)
				EndIf
			Next
			If $intUpdownPanelDividerPosY <= 179+15 + 1*14 + 12 Then
				GUICtrlSetState($lblXMPLabel, $GUI_HIDE)
			Else
				GUICtrlSetState($lblXMPLabel, $GUI_SHOW)
			EndIf
		EndIf

		$strTCExtMem = $strTCExtCur

	Else

		If $booViewPJG = True Or $booViewMPO = True Then
			$strTCPathCur = $cstrTmpPath
			$strTCFileCur = $strTCFileTmp
			$strTCExtCur = "jpg"
		EndIf

	EndIf

	If $booRefreshGUI = True Then
;~ 		WriteLog("Debug:MainLoop", "If $booRefreshGUI = True Then") ;debug
		GetTCActivePanelProperties()

		WinMove($frmMain, "", $intTCInactivePanelX, $intTCInactivePanelY, $intTCInactivePanelW, $intTCInactivePanelH)
		$intUpdownPanelDividerPosY = Int($intTCInactivePanelH * ($intPanelDivider/100)) - 5

		If $strLayoutXMPRating = "Stars" Then
			For $intXMPRating = 1 To 5
				GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - (64-$intXMPRating*9), 80+1*15)
			Next
		EndIf

		If $intXMPRatingState = $GUI_SHOW Then
			If $intUpdownPanelDividerPosY <= $intXMPRatingRMPIcoOffsetY + 9 Then
				GUICtrlSetState($icoXMPRatingRej, $GUI_HIDE)
				GUICtrlSetState($icoXMPRatingMinus, $GUI_HIDE)
				GUICtrlSetState($icoXMPRatingPlus, $GUI_HIDE)
			Else
				GUICtrlSetPos($icoXMPRatingRej, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY)
				GUICtrlSetState($icoXMPRatingRej, $GUI_SHOW)
				GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
				GUICtrlSetState($icoXMPRatingMinus, $GUI_SHOW)
				GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)
				GUICtrlSetState($icoXMPRatingPlus, $GUI_SHOW)
			EndIf
			If $strLayoutXMPRating = "Boxes" Then
				For $intXMPRating = 1 To 5
					If $intUpdownPanelDividerPosY <= 80 + Abs($intXMPRating-6)*15 + 9 Then
						GUICtrlSetState(Eval("lblXMPRating" & $intXMPRating), $GUI_HIDE)
						GUICtrlSetState(Eval("icoXMPRating" & $intXMPRating), $GUI_HIDE)
					Else
						GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - 53, 80 + Abs($intXMPRating-6)*15)
						GUICtrlSetState(Eval("lblXMPRating" & $intXMPRating), $GUI_SHOW)
						GUICtrlSetState(Eval("icoXMPRating" & $intXMPRating), $GUI_SHOW)
					EndIf
				Next
				If $intUpdownPanelDividerPosY <= 80 + Abs(5-6)*15 + 9 Then
					GUICtrlSetState($lblXMPRating, $GUI_HIDE)
				Else
					GUICtrlSetState($lblXMPRating, $GUI_SHOW)
				EndIf
			EndIf
		EndIf

		If $intXMPLabelState = $GUI_SHOW Then
			$arrXMPLabel = StringSplit("Red|Yellow|Green|Blue|Purple", "|")
			For $intXMPLabel = 1 To $arrXMPLabel[0]
				If $intUpdownPanelDividerPosY <= 179+15 + $intXMPLabel * 14 + 12 Then
					;                            179+15 + 5            * 14
					GUICtrlSetState(Eval("icoXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_HIDE)
					GUICtrlSetState(Eval("lblXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_HIDE)
				Else
					GUICtrlSetPos(Eval("icoXMPLabel" & $arrXMPLabel[$intXMPLabel]), $intTCInactivePanelW - 53, 179+15 + $intXMPLabel * 14)
					GUICtrlSetState(Eval("icoXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_SHOW)
					GUICtrlSetState(Eval("lblXMPLabel" & $arrXMPLabel[$intXMPLabel]), $GUI_SHOW)
				EndIf
			Next
			If $intUpdownPanelDividerPosY <= 179+15 + 1*14 + 12 Then
				GUICtrlSetState($lblXMPLabel, $GUI_HIDE)
			Else
				GUICtrlSetState($lblXMPLabel, $GUI_SHOW)
			EndIf
		EndIf

		#cs
		If $intUpdownPanelDividerPosY <= 264+25+0*12 + 12 Then
			GUICtrlSetState($lblTechInfoShutterSpeed, $GUI_HIDE)
			GUICtrlSetState($lblTechInfoAperture, $GUI_HIDE)
		Else
			GUICtrlSetState($lblTechInfoShutterSpeed, $GUI_SHOW)
			GUICtrlSetState($lblTechInfoAperture, $GUI_SHOW)
		EndIf
		If $intUpdownPanelDividerPosY <= 264+25+1*12 + 12 Then
			GUICtrlSetState($lblTechInfoISO, $GUI_HIDE)
		Else
			GUICtrlSetState($lblTechInfoISO, $GUI_SHOW)
		EndIf
		If $intUpdownPanelDividerPosY <= 264+25+2*12 + 12 Then
			GUICtrlSetState($lblTechInfoFLen35, $GUI_HIDE)
		Else
			GUICtrlSetState($lblTechInfoFLen35, $GUI_SHOW)
		EndIf
		#ce
		If $intUpdownPanelDividerPosY <= 264+25+2*12 + 12 Then
			GUICtrlSetState($lblTechInfoShutterSpeed, $GUI_HIDE)
			GUICtrlSetState($lblTechInfoAperture, $GUI_HIDE)
			GUICtrlSetState($lblTechInfoISO, $GUI_HIDE)
			GUICtrlSetState($lblTechInfoFLen35, $GUI_HIDE)
		Else
			GUICtrlSetState($lblTechInfoShutterSpeed, $GUI_SHOW)
			GUICtrlSetState($lblTechInfoAperture, $GUI_SHOW)
			GUICtrlSetState($lblTechInfoISO, $GUI_SHOW)
			GUICtrlSetState($lblTechInfoFLen35, $GUI_SHOW)
		EndIf

		GUICtrlSetPos($btnTagGroupUser, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
		GUICtrlSetPos($icoTagGroups, 62, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5)
		GUICtrlSetPos($btnFilterSearchResult, 79, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
		GUICtrlSetPos($icoEditSearchTerm, 139, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5)
		GUICtrlSetPos($btnTagGroupAll, 156, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
		GUICtrlSetPos($btnTagGroupCustom, 198-1, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
		GUICtrlSetPos($icoCopySelectedTagsToClipboard, $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2), Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5)
		GUICtrlSetPos($icoOpenSyncSelectedTagsDialog, $intTCInactivePanelW - (18+2 + 5 + 13*1), Int($intTCInactivePanelH * ($intPanelDivider/100)) + 5)

		;If $intTCInactivePanelW - ({Breite UpDown} + {Breite Filterbutton}) < {Linker Rand "File"-Filterbutton}+({Breite Filterbutton}+1)*({Anz Filterbutton}-1) - (2+({Anz Filterbutton}-1)) Then

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 240-2 Then
			GUICtrlSetState($btnTagGroupFile, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupFile, 240-2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupFile, $intBtnTagGroupFileState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 282-3 Then
			GUICtrlSetState($btnTagGroupComposite, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupComposite, 282-3, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupComposite, $intBtnTagGroupCompositeState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 324-4 Then
			GUICtrlSetState($btnTagGroupEXIF, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupEXIF, 324-4, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupEXIF, $intBtnTagGroupEXIFState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 366-5 Then
			GUICtrlSetState($btnTagGroupIPTC, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupIPTC, 366-5, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupIPTC, $intBtnTagGroupIPTCState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 408-6 Then
			GUICtrlSetState($btnTagGroupXMP, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupXMP, 408-6, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupXMP, $intBtnTagGroupXMPState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 450-7 Then
			GUICtrlSetState($btnTagGroupMakerNotes, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnTagGroupMakerNotes, 450-7, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnTagGroupMakerNotes, $intBtnTagGroupMakerNotesState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 492-8 Then
			GUICtrlSetState($btnListRegions, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnListRegions, 492-8, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnListRegions, $intBtnListRegionsState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 534-9 Then
			GUICtrlSetState($btnViewDescriptIon, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnViewDescriptIon, 534-9, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnViewDescriptIon, $intBtnViewDescriptIonState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 576-10 Then
			GUICtrlSetState($btnViewThumbnailImage, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnViewThumbnailImage, 576-10, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnViewThumbnailImage, $intBtnViewThumbnailImageState)
		EndIf

		If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) < 618-11 Then
			GUICtrlSetState($btnViewPreviewImage, $GUI_HIDE)
		Else
			GUICtrlSetPos($btnViewPreviewImage, 618-11, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3)
			GUICtrlSetState($btnViewPreviewImage, $intBtnViewPreviewImageState)
		EndIf

		GUICtrlSetPos($cbxPanelDivider, $intTCInactivePanelW - 22, Int($intTCInactivePanelH * ($intPanelDivider/100)) - 6)

		GUICtrlSetPos($lvwTags, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 22, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 22)
		GUICtrlSetPos($txtDescriptIon, 2, Int($intTCInactivePanelH * ($intPanelDivider/100)) + 22, $intTCInactivePanelW - 4, Int($intTCInactivePanelH * (1-$intPanelDivider/100)) - $intTCInactiveFooterH - 22)

		#cs
		$x = $intTCInactivePanelX-550-4
		If $x < 1 Then $x = 1
;~ 	 	$y = $intTCInactivePanelY + Int($intTCInactivePanelH * ($intPanelDivider/100)) + 20
;~ 	 	If $y+244 > @DesktopHeight Then $y = @DesktopHeight - 244
;~ 	 	WinMove($frmEdit, "", $x, $y)
		WinMove($frmEdit, "", $x, Default)
		#ce

		$booRefreshGUI = False
		$booRefreshMetadataOnly = False
		$booRefresh = False
		If $booFileIsValid And ($strImageConvertMode <> "NOP" Or $booQuickviewThumb = True) Then
			$booRefreshQuickviewImage = True
		Else
			$booRefreshQuickviewImage = False
		EndIf
		;GUICtrlSetColor($lblStatus, 0x008000)
		GUICtrlSetData($lblStatus, $arrLocStr[63])

	EndIf

	If $booRefreshMetadataOnly = True Then
;~ 		WriteLog("MainLoop", "If $booRefreshMetadataOnly = True Then") ;debug
		$strCustomTagsDrilledDown = ""
		GetMetadataExifTool($strTCPathCur & $strTCFileCur)
		$booRefreshMetadataOnly = False
		$booRefresh = False
		$booRefreshQuickviewImage = False
		;GUICtrlSetColor($lblStatus, 0x008000)
		GUICtrlSetData($lblStatus, $arrLocStr[63])
	EndIf

	If $booRefresh = True Then
;~ 		WriteLog("MainLoop", "If $booRefresh = True Then") ;debug
		$strCustomTagsDrilledDown = ""
		$strImageConvertMode = "NOP"
		If StringInStr("|" & IniRead($cstrIniFile, "Configuration", "ImageConvertFileExtsSTD", "") & "|", $strTCExtCur) > 0 Or StringInStr("|bmp|gif|jpg|", $strTCExtCur) > 0 Then $strImageConvertMode = "STD"
		If StringInStr("|" & IniRead($cstrIniFile, "Configuration", "ImageConvertFileExtsRAW", "") & "|", $strTCExtCur) > 0 Then $strImageConvertMode = "RAW"
		If $booQuickview = False Then $strImageConvertMode = "NOP"
		#cs
		If $strImageConvertMode <> "NOP" Then
			$booRefreshQuickviewImage = True
;~ 			GUICtrlSetImage($picPic, "D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\TCMetadataViewer_Icons\Wait.jpg") ;Test
		EndIf
		#ce
		#cs
		If $strImageConvertMode = "NOP" Then
			GUICtrlSetImage($picPic, $cstrIcoDir & "\NoQuickviewAvailable.jpg")
		Else
			$booRefreshQuickviewImage = True
		EndIf
		#ce
		;*** Auch Dateien anderer Formate als die in ImageConvertFileExtsSTD/~RAW aufgefhrten knnen ein Thumbnail-Image enthalten (z.B. *.mie-Files)
		If $strImageConvertMode <> "NOP" Or $booQuickviewThumb = True Then
			$booRefreshQuickviewImage = True
		Else
			GUICtrlSetImage($picPic, $cstrIcoDir & "\NoQuickviewAvailable.jpg")
		EndIf

		GetMetadataExifTool($strTCPathCur & $strTCFileCur)

		$booRefresh = False
		;GUICtrlSetColor($lblStatus, 0x008000)
		GUICtrlSetData($lblStatus, $arrLocStr[63])

	EndIf

	If $booRefreshQuickviewImage = True Then
		GUICtrlSetImage($picPic, $cstrIcoDir & "\Blank.jpg") ;Test

		;*** ber den Zustand des Kontextmens prfen, ob die aktuell gezeigte Bilddatei ein Thumbnail enthlt
		If GUICtrlGetState($contextPicPicViewThumbnailImage) = $GUI_ENABLE And $booQuickviewThumb = True Then
			;*** Dateinamen, die mit "-" beginnen, werden von ExifTool als Option behandelt.    Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
			;*** Dateinamen, die mit "#" beginnen, werden von ExifTool als Kommentar behandelt. Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
			$strExifToolParam = " -b -ThumbnailImage -ID3:Picture -Vorbis:CoverArt -FLAC:Picture " & '"' & StringRegExpReplace($strTCPathCur & $strTCFileCur, "^(#|-)", ".\\\1") & '" >"' & $cstrTmpFile & "_ThumbnailImage.jpg"
;~ 			If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
;~ 				$strExifToolParam &= " -srcfile %d%f." & $strSidecarFileType
;~ 			EndIf
			$strExifToolOut = RunExifTool("ExtractThumbImg", $strExifToolParam, 1)

			GetImageDim($cstrTmpFile & "_ThumbnailImage.jpg")
			GUICtrlSetData($lblScale, Round($intScaleImg * 100, 0) & "%") ;Test
			GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), Int(($intPicH - $intImgPreH) / 2) + 1 + $intShowImageTitle*20, $intImgPreW, $intImgPreH)
			GUICtrlSetImage($picPic, $cstrTmpFile & "_ThumbnailImage.jpg")

		ElseIf GUICtrlGetState($contextPicPicViewThumbnailImage) = $GUI_DISABLE And $booQuickviewThumb = True Then
			GUICtrlSetImage($picPic, $cstrIcoDir & "\NoQuickviewAvailable.jpg")

		Else

			$intPicW = $intTCInactivePanelW - 59
			$intPicH = Int($intTCInactivePanelH * ($intPanelDivider/100) - $intShowImageTitle*20) ;*** Wenn ImageTitle angezeigt werden soll, dann soll $picPic 20px (=Hhe der ImageTitel-Zeile) niedriger werden
			$intScaleImg = $intPicW / $intImgW
			If $intPicH / $intImgH < $intScaleImg Then $intScaleImg = $intPicH / $intImgH
;~ 			If $intScaleImg > 1 Then $intScaleImg = 1
			If $intScaleImg > 1 And $booMagnify = False Then $intScaleImg = 1
			GUICtrlSetData($lblScale, Round($intScaleImg * 100, 0) & "%")
			$intImgPreW = Int($intImgW * $intScaleImg)
			$intImgPreH = Int($intImgH * $intScaleImg)

			;*** Neues Vorschaubild erstellen
			If $strImageConvertMode = "RAW" And $booMagnify = False Then
				ExtractPreviewImage("Extract")
				GetImageDim($cstrTmpFile & "_PreviewImage.jpg") ;*** Bildabmessungen eingebettetes PreviewImage
				GUICtrlSetData($lblScale, Round($intScaleImg * 100, 0) & "%")
				GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), Int(($intPicH - $intImgPreH) / 2) + 1 + $intShowImageTitle*20, $intImgPreW, $intImgPreH)
				GUICtrlSetImage($picPic, $cstrTmpFile & "_PreviewImage.jpg")
			Else
				GUICtrlSetData($lblScale, Round($intScaleImg * 100, 0) & "%")
				GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), Int(($intPicH - $intImgPreH) / 2) + 1 + $intShowImageTitle*20, $intImgPreW, $intImgPreH)
				GUICtrlSetImage($picPic, $strTCPathCur & $strTCFileCur)
			EndIf

			If $booQuickviewHQ = True Then

				;GUICtrlSetColor($lblStatus, 0x80A0FF)
				GUICtrlSetData($lblStatus, $arrLocStr[66])

				#Region TCMetadataViewer-Vorschaubild mit IrfanView erstellen ------------
;~ 				If $strImageConverter = "IrfanView" Then
;~ 				If $strImageConverter = "IrfanView" And $booUnicodeFilename = False Then
				If $strImageConverter = "IrfanView" And ($intImageConverterUnicodeSupport = 1 Or $booUnicodeFilename = False) Then

					If $booMagnify = True Then
						$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_Crop.bmp" & '"'
					ElseIf $strImageConvertMode = "RAW" Then
						$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
					Else
						$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strTCPathCur & $strTCFileCur & '"'
					EndIf

					If $booQuickviewColor = True Then
						$strIrfanViewCmd &= " /gamma=" & IniRead($cstrIniFile, "Configuration", "Gamma", 1) * 1
						$strIrfanViewCmd &= " /contrast=" & IniRead($cstrIniFile, "Configuration", "Contrast", 1) * 1
					EndIf
					$strIrfanViewCmd &= " /resize=(" & $intImgPreW & "," & $intImgPreH & ")"
					;*** Bei Zoom < 100% stets resamplen und schrfen
					If $intScaleImg < 1 Then
						$strIrfanViewCmd &= " /resample /sharpen=15"
					;*** Bei Zoom >= 100% (kann nur bei "Magnify", nicht im regulren Quickview vorkommen) nicht schrfen und nur resamplen, wenn so konfiguriert
					Else
						If $booMagnify = True And IniRead($cstrIniFile, "Configuration", "MagnifyResample", 1) * 1 = 1 Then $strIrfanViewCmd &= " /resample"
					EndIf

					$strIrfanViewCmd &= ' /bpp=24 /convert="' & $cstrTmpFile & '.bmp" /silent'
					WriteLog("CreateQViewImg", $strIrfanViewCmd)
					$strErrMsg = RunWait($strIrfanViewCmd, @WorkingDir)

					If $strErrMsg*1 > 0 Then ;*** IrfanView hat eine Fehlermeldung ausgegeben
						$strErrMsg = $strImageConverter & ": load/save error (exitcode = " & $strErrMsg & ")"
						WriteLog("CreateQViewImg", $strErrMsg)
						MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on CreateQViewImg", $strErrMsg)
						FileDelete($cstrTmpFile & ".bmp") ;*** ggf. vorhandenes Vorschaubild lschen
					EndIf
					GUICtrlSetImage($picPic, $cstrTmpFile & ".bmp")

				EndIf
				#EndRegion --------------------------------------------------------------------

				#Region TCMetadataViewer-Vorschaubild mit NConvert erstellen -------------
				If $strImageConverter = "NConvert" Then

					;*** Seit v5.60 berschreibt NConvert vorhandene Files *nicht* mehr:XnView v1.97.1 (LIBFORMAT v5.60) 22/02/2010: Added -overwrite
					;*** -overwrite mit lteren NConvert-Versionen fhrt zu "Bad argument"-Fehler.
;~ 					;*** Daher - statt Versionsabfrage und bedingter "overwrite"-Angabe - Vorschaubild einfach vorher lschen
;~ 					FileDelete($cstrTmpFile & ".bmp")
;~ 					WriteLog("DelTempFiles", $cstrTmpFile & ".bmp")

					$strNConvertCmd = '"' & $strImageConverterPath & '" -o "' & $cstrTmpFile & '.bmp"'
					If $strImageConverterVersion >= 5.60 Then $strNConvertCmd &= ' -overwrite'
					;*** Parameter "-truecolors" erforderlich, da 1-bpP-BMPs (z.B. aus TIF konvertierte Fax-Seiten) von AutoIt nicht angezeigt werden. Parameter "-32bits" wre "zu viel des Guten", da Transparenz in AutoIt micht angezeigt wird.
					$strNConvertCmd &= " -quiet -out bmp -truecolors"

					If $booQuickviewColor = True Then
						$strNConvertCmd &= " -gamma " & IniRead($cstrIniFile, "Configuration", "Gamma", 1) * 1
						$strNConvertCmd &= " -contrast " & IniRead($cstrIniFile, "Configuration", "Contrast", 1) * 1
					EndIf

					If $intScaleImg < 1 Then
						;*** Parameter "-ratio" *nicht* bergeben, da die interne Berechnung von $intImgPreW  $intImgPreH um 1-2 Pixel von NConverts Ausgabe abweicht
						;*** diese Abweichung fhrt zu unscharfer Darstellung des Vorschaubilds
						;*** ($picPic wird auf intern berechnete Mae dimensioniert, AutoIt skaliert das bergebene Vorschaubild dann auf die $picPic-Gre)
						$strNConvertCmd &= " -rtype lanczos -resize " & $intImgPreW & " " & $intImgPreH & " -sharpen 30"
					Else
						If $booMagnify = True And IniRead($cstrIniFile, "Configuration", "MagnifyResample", 1) * 1 = 1 Then
							$strNConvertCmd &= " -rtype lanczos"
						Else
							$strNConvertCmd &= " -rtype quick"
						EndIf
						$strNConvertCmd &= " -resize " & $intImgPreW & " " & $intImgPreH
					EndIf

					;*** Parameter "-jpegtrans exif" fr Auto-Rotation nach EXIF-Orientation-Tag *nicht* bergeben, Ergebnis ist mangelhaft auch fr nicht gedrehte Vorschaubilder
					;$strNConvertCmd &= " -jpegtrans exif"

					If $booMagnify = True Then
						$strNConvertCmd &= ' "' & $cstrTmpFile & "_Crop.bmp" & '"'
					ElseIf $strImageConvertMode = "RAW" Then
						$strNConvertCmd &= ' "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
					Else
						$strNConvertCmd &= ' "' & $strTCPathCur & $strTCFileCur & '"'
					EndIf

					$strStdOut = ""
					$strStdErr = ""
					WriteLog("CreateQViewImg", $strNConvertCmd)
					$pidNConvert = Run(@ComSpec & ' /S /c "' & $strNConvertCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
					While 1
						$strStdOut &= StdoutRead($pidNConvert)
						If @error Then ExitLoop
					Wend
					While 1
						$strStdErr &= StderrRead($pidNConvert)
						If @error Then ExitLoop
					Wend
					ProcessWaitClose($pidNConvert)

					If $strStdErr <> "" Then ;*** NConvert hat eine Fehlermeldung ausgegeben
						$strErrMsg = $strImageConverter & ": " & StringStripWS($strStdErr, 1+2)
						WriteLog("CreateQViewImg", $strErrMsg)
						MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on CreateQViewImg", $strErrMsg)
					EndIf
					GUICtrlSetImage($picPic, $cstrTmpFile & ".bmp")

				EndIf
				#EndRegion --------------------------------------------------------------------

				#Region TCMetadataViewer-Vorschaubild mit ImageMagick erstellen -------------
				If $strImageConverter = "ImageMagick" Then

					FileDelete($cstrTmpFile & ".bmp")
					WriteLog("DelTempFiles", $cstrTmpFile & ".bmp")

					If $booMagnify = True Then
						$strImageMagickCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_Crop.bmp" & '"'
					ElseIf $strImageConvertMode = "RAW" Then
						$strImageMagickCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
					Else
						;*** "[0]" bezeichnet den ersten Frame / die erste Page in Multi-Image-Dateien (z.B. gif, tif)
						$strImageMagickCmd = '"' & $strImageConverterPath & '" "' & $strTCPathCur & $strTCFileCur & '[0]"'
					EndIf
					;*** Zum Parameter "-auto-orient": ExifTool-Doku schreibt: "EXIF.Orientation: EXIF [...] type of information [...] may be found in JPG, TIFF, PNG, MIFF, HDP and PSP images, as well as many TIFF-based RAW images, and even some AVI and MOV videos."
					;*** Zum Parameter "-type TrueColor": Sicherstellen, dass Ausgabe mit 24bpP erfolgt ("-type TrueColorMatte" = 32bpP (mitTransparenz) wre "zu viel des Guten")
					$strImageMagickCmd &= " -auto-orient -type TrueColor"

					If $intScaleImg < 1 Then
						$strImageMagickCmd &= " -filter Lanczos -resize " & $intImgPreW & "x" & $intImgPreH & "! -sharpen 2"
					Else
						If $booMagnify = True And IniRead($cstrIniFile, "Configuration", "MagnifyResample", 1) * 1 = 1 Then
							$strImageMagickCmd &= " -filter Lanczos -resize " & $intImgPreW & "x" & $intImgPreH & "!"
						Else
							$strImageMagickCmd &= " -filter Point -resize " & $intImgPreW & "x" & $intImgPreH & "!"
						EndIf
					EndIf

					If $booQuickviewColor = True Then
						$strImageMagickCmd &= " -gamma " & IniRead($cstrIniFile, "Configuration", "Gamma", 1) * 1
						$strImageMagickCmd &= " -brightness-contrast 0x" & IniRead($cstrIniFile, "Configuration", "Contrast", 1) * 1 ;-brightness-contrast brightness{xcontrast}
					EndIf

					$strImageMagickCmd &= ' "' & $cstrTmpFile & '.bmp"'

					$strStdOut = ""
					$strStdErr = ""
					WriteLog("CreateQViewImg", $strImageMagickCmd)
					$pidImageMagick = Run(@ComSpec & ' /S /c "' & $strImageMagickCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
					While 1
						$strStdOut &= StdoutRead($pidImageMagick)
						If @error Then ExitLoop
					Wend
					While 1
						$strStdErr &= StderrRead($pidImageMagick)
						If @error Then ExitLoop
					Wend
					ProcessWaitClose($pidImageMagick)

					If $strStdErr <> "" Then ;*** ImageMagick hat eine Fehlermeldung ausgegeben
						$strErrMsg = $strImageConverter & ": " & StringStripWS($strStdErr, 1+2)
						WriteLog("CreateQViewImg", $strErrMsg)
						MsgBox(48+262144, $cstrTCMetadataViewerVersion & ": Error on CreateQViewImg", $strErrMsg)
					EndIf
					GUICtrlSetImage($picPic, $cstrTmpFile & ".bmp")

				EndIf
				#EndRegion --------------------------------------------------------------------

			EndIf

		EndIf

		;GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), 1, $intImgPreW, $intImgPreH) ;Test
		;GUICtrlCreateLabel("Region", Int(($intPicW - $intImgPreW) / 2) + 20, 1 + 20, $intImgPreW/4, $intImgPreH/4, $SS_WHITEFRAME) ;Test

		$booRefreshQuickviewImage = False
		;GUICtrlSetColor($lblStatus, 0x008000)
		GUICtrlSetData($lblStatus, $arrLocStr[63])

	EndIf

WEnd
#EndRegion Main --------------------------------------------------------------------

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func _Exit()
	Switch @GUI_WinHandle

		Case $frmMain
			;*** Shutdown ExifTool
			ShutdownExifTool()
			;*** Lschen: TCMetadataViewer & .jpg, _BinaryData.bin, _ExifTool_ArgList.txt, _PreviewImage.jpg, _ThumbnailImage.jpg
			FileDelete($cstrTmpFile & "*.*")
			If $intDelayOnExit > 0 Then MsgBox(64+262144, $cstrTCMetadataViewerVersion, "Temporary files" & @LF & $cstrTmpFile & "*.*" & @LF & "deleted", $intDelayOnExit)
			WriteLog("DelTempFiles", $cstrTmpFile & "*.*")
			WriteLog("ProgramExit", $cstrTCMetadataViewerVersion)
			If $intWriteLog = 1 Then FileClose($fhLog)
			Exit

		Case $frmEdit, $frmShiftDateTime
			GUISetState(@SW_HIDE, @GUI_WinHandle)
;~ 			If WinGetState($frmRectangle) = 1+2 Then GUISetState(@SW_HIDE, $frmRectangle)
			GUISetState(@SW_HIDE, $frmRectangle)
			GUISwitch($frmMain)
			GUISetState(@SW_ENABLE, $frmMain)
			SetWinOnTopState($intWinOnTopStateUser)
			WinActivate($frmMain)

		Case $frmSyncSelectedFiles
			If BitAND(WinGetState($frmSyncSelectedTags), 2) Then GUISetState(@SW_HIDE, $frmSyncSelectedTags)
			GUISetState(@SW_HIDE, @GUI_WinHandle)
			GUISwitch($frmMain)
			GUISetState(@SW_ENABLE, $frmMain)
			SetWinOnTopState($intWinOnTopStateUser)
			WinActivate($frmMain)

		Case $frmSyncSelectedTags
			GUISetState(@SW_HIDE, $frmSyncSelectedTags)
			If BitAND(WinGetState($frmSyncSelectedFiles), 2) Then
				GUISwitch($frmSyncSelectedFiles)
				GUISetState(@SW_ENABLE, $frmSyncSelectedFiles)
				WinActivate($frmSyncSelectedFiles)
			Else
				GUISwitch($frmMain)
				GUISetState(@SW_ENABLE, $frmMain)
				SetWinOnTopState($intWinOnTopStateUser)
				WinActivate($frmMain)
			EndIf

		Case $frmRectangle
			;*** $frmEdit exists+visible
			If Not (BitAnd(WinGetState($frmEdit), 1) And BitAnd(WinGetState($frmEdit), 2)) Then
;~ 				GUISetState(@SW_HIDE, @GUI_WinHandle)
				GUISetState(@SW_HIDE, $frmRectangle)
				GUISwitch($frmEdit)
				WinActivate($frmEdit)
				Return
			EndIf

			$i = _GUICtrlListView_GetSelectedIndices($hlvwEditTagVal, False)
			$arrRectangleWinPos = WinGetPos($frmRectangle) ;[0]=x, [1]=y, [2]=B, [3]=H
			$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
			$b = ($arrRectangleWinPos[2]-$arrRectangleClientPos[0])/2
			$x = $arrRectangleWinPos[0] - $intTCInactivePanelX - Int(($intPicW - $intImgPreW) / 2) + $b
			$y = $arrRectangleWinPos[1] - $intTCInactivePanelY - 1 + ($arrRectangleWinPos[3]-$arrRectangleClientPos[1]) - $b
			$y = $y - Int(($intPicH - $intImgPreH) / 2) ;*** vertikale Zentrierung = Verschiebung des Quickview-Images bercksichtigen
			$y = $y - $intShowImageTitle*20 ;*** Verschiebung um die Hhe des ImageTitles (20px) bercksichtigen
			$w = $arrRectangleClientPos[0]
			$h = $arrRectangleClientPos[1]

			If $x+$w < 1 Or $x > $intImgPreW Or $y+$h < 1 Or $y > $intImgPreH Then
				;*** "{Neuer Eintrag}" wurde angeklickt, $frmRectangle aber vollstndig auerhalb des Bildes plaziert
				If $i = 0 Then
					$intRetVal = 7 ;*** Klick auf "No"-Buttun simulieren
				Else
					$intRetVal = MsgBox(3+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[143] & @LF & $arrLocStr[142]) ;Region is completely arranged outside the image! Delete region information?
				EndIf
				If $intRetVal = 6 Then ;*** "Yes"
					_GUICtrlListView_SetItemText($hlvwEditTagVal, _GUICtrlListView_GetSelectedIndices($hlvwEditTagVal, False), "", 1)
;~ 	 	 	 		GUISetState(@SW_HIDE, @GUI_WinHandle)
					GUISetState(@SW_HIDE, $frmRectangle)
					GUISwitch($frmEdit)
					WinActivate($frmEdit)
				ElseIf $intRetVal = 7 Then ;*** "No"
;~ 	 	 	 		GUISetState(@SW_HIDE, @GUI_WinHandle)
					GUISetState(@SW_HIDE, $frmRectangle)
					GUISwitch($frmEdit)
					WinActivate($frmEdit)
				Else ;*** "Cancel" ($intRetVal = 2)
					;NOP
				EndIf

			Else

				$intRetVal = MsgBox(3+32+262144, $cstrTCMetadataViewerVersion, $arrLocStr[141]) ;Apply region information?
				If $intRetVal = 6 Then ;*** "Yes"
					If $x < 1 Then
						$w = $w + $x
						$x = 1
					EndIf
					If $y < 1 Then
						$h = $h + $y
						$y = 1
					EndIf
					If $x + $w > $intImgPreW Then $w = $intImgPreW - $x
					If $y + $h > $intImgPreH Then $h = $intImgPreH - $y

					If $booMagnify = True Then
						$x = $xcrop + $x/$intScaleImg
						$y = $ycrop + $y/$intScaleImg
						$w = $w/$intScaleImg
						$h = $h/$intScaleImg
						$x = Round($x / $intImgWOri, 6)
						$y = Round($y / $intImgHOri, 6)
						$w = Round($w / $intImgWOri, 6)
						$h = Round($h / $intImgHOri, 6)
					Else
						$x = Round($x / $intImgPreW, 6)
						$y = Round($y / $intImgPreH, 6)
						$w = Round($w / $intImgPreW, 6)
						$h = Round($h / $intImgPreH, 6)
					EndIf

	;~ 				If _GUICtrlListView_GetSelectedIndices($hlvwEditTagVal, False) = 0 Then
					If $i = 0 Then
						$i = _GUICtrlListView_GetItemCount($hlvwEditTagVal)
						$strTmp = InputBox($cstrTCMetadataViewerVersion, $arrLocStr[140], $arrLocStr[139] & "(" & $i & ")") ;Name of the new region [New region] (i)
						If @error = 0 And $strTmp <> "" Then
							_GUICtrlListView_AddItem($hlvwEditTagVal, $strTmp)
							_GUICtrlListView_AddSubItem($hlvwEditTagVal, $i, $x & ", " & $y & ", " & $w & ", " & $h, 1)
	;~ 						_GUICtrlListView_SetItemSelected($hlvwEditTagVal, $i, True, True)
						EndIf
					Else
	;~ 					_GUICtrlListView_SetItemText($hlvwEditTagVal, _GUICtrlListView_GetSelectedIndices($hlvwEditTagVal, False), $x & ", " & $y & ", " & $w & ", " & $h, 1)
						_GUICtrlListView_SetItemText($hlvwEditTagVal, $i, $x & ", " & $y & ", " & $w & ", " & $h, 1)
					EndIf

	;~ 	 	 		GUISetState(@SW_HIDE, @GUI_WinHandle)
					GUISetState(@SW_HIDE, $frmRectangle)
					GUISwitch($frmEdit)
					WinActivate($frmEdit)

				ElseIf $intRetVal = 7 Then ;*** "No"
;~ 	 	 	 		GUISetState(@SW_HIDE, @GUI_WinHandle)
					GUISetState(@SW_HIDE, $frmRectangle)
					GUISwitch($frmEdit)
					WinActivate($frmEdit)

				Else ;*** "Cancel" ($intRetVal = 2)
					;NOP

				EndIf

			EndIf

	EndSwitch
EndFunc ;Func _Exit()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func EditIni($strTexteditorFileToOpen=$cstrIniFile)
	If $strTexteditorFileToOpen = "" Then $strTexteditorFileToOpen = $cstrIniFile
	If $strTexteditorPath <> "" Then
		If Not FileExists($strTexteditorPath) Then
			$strErrMsg = StringReplace($arrLocStr[1], "%p", $strTexteditorPath)
			$strErrMsg = StringReplace($strErrMsg, "%n", $arrLocStr[3])
			$strTexteditorPath = ""
			WriteLog("EditIni", StringReplace($strErrMsg, @LF, " | "))
			MsgBox(64+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
		EndIf
	EndIf

	If $strTexteditorPath = "" Then
;~ 		WriteLog("EditIni", "ShellExecute(" & '"' & $cstrIniFile & '", "", "", "open")')
;~ 		ShellExecute($cstrIniFile, "", "", "open")
		WriteLog("EditIni", "ShellExecute(" & '"' & $strTexteditorFileToOpen & '", "", "", "open")')
		ShellExecute($strTexteditorFileToOpen, "", "", "open")
	Else
;~ 		WriteLog("EditIni", "ShellExecute(" & '"' & $strTexteditorPath & '", "' & $cstrIniFile & '")')
;~ 		ShellExecute($strTexteditorPath, $cstrIniFile)
		WriteLog("EditIni", "ShellExecute(" & '"' & $strTexteditorPath & '", "' & $strTexteditorFileToOpen & '")')
		ShellExecute($strTexteditorPath, $strTexteditorFileToOpen)
	EndIf
EndFunc ;Func EditIni($strTexteditorFileToOpen=$cstrIniFile)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func About()
	$strTmp  = $cstrTCMetadataViewerVersion & @LF & 'by "van Dusen" (van_dusen@email.de)'
	$strTmp &= @LF & @ScriptFullPath
	$strTmp &= @LF & @LF & "Addon for the filemanager Total Commander" & @LF & "for viewing metadata using external tools ExifTool and IrfanView/NConvert/ImageMagick."
	$strTmp &= @LF & @LF & 'Discussion on Total Commander plugins and addons forum:'
	$strTmp &= @LF       & 'thread "[AddOn] TCMetadataViewer 2.0" (http://www.ghisler.ch/board/viewtopic.php?t=25576)'

	$strTmp &= @LF & @LF & "=================================================="

	$strTmp &= @LF & @LF & "Total Commander  v" & FileGetVersion($strTotalCommanderPath, "ProductVersion") & "  " & FileGetVersion($strTotalCommanderPath, "LegalCopyright") & @LF & $strTotalCommanderPath

	$strTmp &= @LF & @LF & "ExifTool  v" & FileGetVersion($strExifToolPath, "ProductVersion") & "  " & FileGetVersion($strExifToolPath, "LegalCopyright") & @LF & $strExifToolPath

	$strTmp &= @LF & @LF & "ImageConverter:  "
	Switch $strImageConverter
		Case "IrfanView", "ImageMagick"
			$strTmp &= $strImageConverter
			If $strImageConverterPath = "" Then
				$strTmp &= @LF & "(not configured)"
			Else
				$strTmp &= "  v" & FileGetVersion($strImageConverterPath, "ProductVersion") & "  " & FileGetVersion($strImageConverterPath, "LegalCopyright") & @LF & $strImageConverterPath
			EndIf
		Case "NConvert"
			$strTmp &= $strImageConverter
			If $strImageConverterPath = "" Then
				$strTmp &= @LF & "(not configured)"
			Else
				$strErrMsg = ""
				WriteLog("GetNConvertVer", $strImageConverterPath)
				$pidNConvert = Run(@ComSpec & ' /S /c ""' & $strImageConverterPath & '""', "", @SW_HIDE, $STDOUT_CHILD)
				While 1
					$strErrMsg &= StdoutRead($pidNConvert)
					If @error Then ExitLoop
				Wend
				ProcessWaitClose($pidNConvert)
				$p = StringInStr($strErrMsg, " v")
				$strErrMsg = StringTrimLeft($strErrMsg, $p-1)
				$p = StringInStr($strErrMsg, "**")
				$strTmp &= StringLeft($strErrMsg, $p-2)
				$strTmp &= @LF & $strImageConverterPath
			EndIf
		Case Else
			$strTmp &= "(not configured)"
	EndSwitch

	$strTmp &= @LF & @LF & "ImageViewer:  " & $strImageViewer
	If $strImageViewerPath <> "" And FileExists($strImageViewerPath) Then
		$strTmp &= "  v" & FileGetVersion($strImageViewerPath, "ProductVersion") & "  " & FileGetVersion($strImageViewerPath, "LegalCopyright") & @LF & $strImageViewerPath
	EndIf

	$strTmp &= @LF & @LF & "PackJPG "
	If $strPackJPGPath <> "" And FileExists($strPackJPGPath) Then $strTmp &= $strPackJPGVer & @LF & $strPackJPGPath

	MsgBox(64+262144, $cstrTCMetadataViewerVersion & " - " & $arrLocStr[62], $strTmp)

EndFunc ;Func About()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func Refresh()
	$strTCPathMem = ""
	$strTCFileMem = ""
	$strTCPathMemOri = ""
	$strTCFileMemOri = ""
EndFunc ;Func Refresh()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetTMyListBoxInstanceOffset()
	;*** Keine separate Baumansicht
	If ControlCommand($whTC, "", "TMyListBox3", "IsVisible", "") = 0 Then
		Return 0
	;*** Ein oder zwei separate Baumansichten
	Else
		;*** Zwei separate Baumansichten
		If ControlCommand($whTC, "", "TMyListBox4", "IsVisible", "") = 1 Then
			Return 2
		;*** Eine separate Baumansicht
		Else
			Return 1
		EndIf
	EndIf
EndFunc ;Func GetTMyListBoxInstanceOffset()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetTCActivePanelProperties()
;~ 	WriteLog("Debug:GetTCActivePanelProperties()", "K.T.") ;debug
	;*** Bestimmen des aktiven TC-Dateipanels
	$arrTCMainWinPos = WinGetPos($whTC) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe
	$arrTCClientAreaPos = WinGetClientSize($whTC) ;[0]=Breite, [1]=Hhe
	$intTCMainWinBorderWidth = Int(($arrTCMainWinPos[2]-$arrTCClientAreaPos[0])/2)

	$arrTCMainWinPosMem[0] = $arrTCMainWinPos[0]
	$arrTCMainWinPosMem[1] = $arrTCMainWinPos[1]
	$arrTCMainWinPosMem[2] = $arrTCMainWinPos[2]
	$arrTCMainWinPosMem[3] = $arrTCMainWinPos[3]

	$intTMyListBoxInstanceOffset = GetTMyListBoxInstanceOffset()

	If $strTCQuickviewPanel = "Right" Then
		;*** Right Panel = Inactive Panel
		$strClassnameTCInactivePanel  = $strClassnameTCRPanel & 1+$intTMyListBoxInstanceOffset
		$strClassnameTCInactivePath   = $strClassnameTCRPath
		$strClassnameTCInactiveHeader = $strClassnameTCRHeader
		$strClassnameTCInactiveFooter = $strClassnameTCRFooter

		;*** Left Panel = Active Panel
		$strClassnameTCActivePanel    = $strClassnameTCLPanel & 2+$intTMyListBoxInstanceOffset
		$strClassnameTCActivePath     = $strClassnameTCLPath
		$strClassnameTCActiveHeader   = $strClassnameTCLHeader
		$strClassnameTCActiveFooter   = $strClassnameTCLFooter

	Else
		;*** Right Panel = Active Panel
		$strClassnameTCActivePanel    = $strClassnameTCRPanel & 1+$intTMyListBoxInstanceOffset
		$strClassnameTCActivePath     = $strClassnameTCRPath
		$strClassnameTCActiveHeader   = $strClassnameTCRHeader
		$strClassnameTCActiveFooter   = $strClassnameTCRFooter

		;*** Left Panel = Inactive Panel
		$strClassnameTCInactivePanel  = $strClassnameTCLPanel & 2+$intTMyListBoxInstanceOffset
		$strClassnameTCInactivePath   = $strClassnameTCLPath
		$strClassnameTCInactiveHeader = $strClassnameTCLHeader
		$strClassnameTCInactiveFooter = $strClassnameTCLFooter

	EndIf

	$hndTCActivePanel = ControlGetHandle($whTC, "", $strClassnameTCActivePanel)

	$strTCPathCurOri = ControlGetText($whTC, "", $strClassnameTCActivePath)
	$p = StringInStr($strTCPathCurOri, "\", 0, -1)
	If $p > 0 Then $strTCPathCurOri = StringLeft($strTCPathCurOri, $p)

	$strTCPathInactive = ControlGetText($whTC, "", $strClassnameTCInactivePath)
	$p = StringInStr($strTCPathInactive, "\", 0, -1)
	If $p > 0 Then $strTCPathInactive = StringLeft($strTCPathInactive, $p)

;~ 	$strTCFileCurOri = _GUICtrlListBox_GetText($hndTCActivePanel, _GUICtrlListBox_GetCurSel($hndTCActivePanel))
	$strTCFileCurOri = ControlCommand($whTC, "", $hndTCActivePanel, "GetCurrentSelection", "")

	;*** In der Miniaturansicht sind markierte (selektierte) Eintrge durch einen fhrenden "*" gekennzeichnet
	If StringLeft($strTCFileCurOri, 1) = "*" Then $strTCFileCurOri = StringTrimLeft($strTCFileCurOri, 1)

	If $intTCGetTextMode = 0 Then
		;*** Das Auftreten von " >" kennzeichnet einen Eintrag einer benutzerdef. Spaltenansicht
		$p = StringInStr($strTCFileCurOri, " >")
		If $p = 0 Then
			;*** Prfen, ob die letzten 5 Zeichen des Eintrags der Struktur des Attr.-Strings in Ansicht "Lang" entsprechen
			If StringRegExp(StringRight($strTCFileCurOri, 5), " [-r][-a][-h][-s]") = 1 Then
				$p = StringInStr($strTCFileCurOri, " ", 0, $intTCFNameDelimPosInFullView)
				$strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
			;*** Anderenfalls ist anzunehmen, dass Ansicht "Kurz" oder die Miniaturansicht aktiv ist
			;Else
				;NOP
			EndIf
		Else
			$strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
		EndIf
	Else
		$p = StringInStr($strTCFileCurOri, $strTCGetTextModeDelim)
		If $p > 0 Then $strTCFileCurOri = StringLeft($strTCFileCurOri, $p-1)
		;*** Bei $intTCGetTextMode = 4 oder 5 wird dem Spaltenwert der Spaltenname vorangestellt (mit <Tab> vom Spaltenwert getrennt)
		If $intTCGetTextMode = 4 Or $intTCGetTextMode = 5 Then $strTCFileCurOri = StringMid($strTCFileCurOri, StringInStr($strTCFileCurOri, @TAB)+1)
	EndIf

	;*** In der Zweigansicht (Strg+b) enthlt $strTCFileCurOri einen (zum Pfad in der Pfadleiste) relativen Dateipfad (sofern ber _GUICtrlListBox_GetText() ermittelt)!
	$p = StringInStr($strTCFileCurOri, "\", 0, -1)
	If $p > 0 Then
		$strTCPathCurOri &= StringLeft($strTCFileCurOri, $p) ;*** $strTCPathCurOri um Pfadkomponenten ergnzen
		$strTCFileCurOri = StringMid($strTCFileCurOri, $p+1) ;*** $strTCFileCurOri auf reinen Dateinamen krzen
	EndIf

	;*** Minimal-Umgehungslsung fr Unicode-Dateipfade
	$strTCPathCur = "" ;Test (oder ".\" statt ""?)
	$strTCFileCur = $strTCFileCurOri
	$booUnicodeFilename = False

	$strTCFilepathCurShort = FileGetShortName($strTCPathCurOri & $strTCFileCurOri)
	$p = StringInStr($strTCFilepathCurShort, "\", 0, -1)
	$strTCPathCurShort = StringLeft($strTCFilepathCurShort, $p)
	$strTCFileCurShort = StringMid($strTCFilepathCurShort, $p+1)

	If $strTCPathCurOri <> $strTCPathMemOri Then
		If $strTCPathCurOri = BinaryToString($strTCPathCurOri) Then
			WriteLog("ChangeDir", $strTCPathCurOri)
			FileChangeDir($strTCPathCurOri)
		Else
			WriteLog("ChangeDir", $strTCPathCurShort)
			FileChangeDir($strTCPathCurShort)
		EndIf
		If $strTCPathMemOri <> "?" Then RestartExifTool($strArgFileEncoding) ;Test
	EndIf

	If $strTCFileCurOri <> BinaryToString($strTCFileCurOri) Then
		$strTCFileCur = $strTCFileCurShort
		$booUnicodeFilename = True
	EndIf

	;*** Separate Ermittlung der Position des rechten Dateipanels fr die berwachung, ob das TCMetadataViewer-Fenster neu gezeichnet werden muss
	$arrTCRPanelPos = ControlGetPos($whTC, "", $strClassnameTCRPanel & 1+$intTMyListBoxInstanceOffset) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe ;Koordinaten relativ zur ClientArea
	$intTCRPanelWMem = $arrTCRPanelPos[2]
	$intTCRPanelHMem = $arrTCRPanelPos[3]

	$hndTCInactivePanel = ControlGetHandle($whTC, "", $strClassnameTCInactivePanel)
	$arrTCInactivePanelPos = ControlGetPos($whTC, "", $strClassnameTCInactivePanel) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe ;Koordinaten relativ zur ClientArea
	$arrTCInactiveHeaderPos = ControlGetPos($whTC, "", $strClassnameTCInactiveHeader) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe ;Koordinaten relativ zur ClientArea
	$arrTCInactiveFooterPos = ControlGetPos($whTC, "", $strClassnameTCInactiveFooter) ;[0]=x, [1]=y, [2]=Breite, [3]=Hhe ;Koordinaten relativ zur ClientArea

	$intTCInactivePanelW = $arrTCInactivePanelPos[2]
	$intTCInactivePanelH = $arrTCInactivePanelPos[3]
	$intTCInactivePanelX = $arrTCInactivePanelPos[0] + $arrTCMainWinPos[0] + $intTCMainWinBorderWidth
	$intTCInactivePanelY = $arrTCInactivePanelPos[1] + $arrTCMainWinPos[1] + ($arrTCMainWinPos[3] - $arrTCClientAreaPos[1] - $intTCMainWinBorderWidth)

	$intTCInactivePanelW -= 1
	$intTCInactivePanelH += $arrTCInactiveHeaderPos[3] + $arrTCInactiveFooterPos[3]
	$intTCInactivePanelY -= $arrTCInactiveHeaderPos[3] - 1

	$intTCInactiveFooterH = $arrTCInactiveFooterPos[3]
EndFunc ;Func GetTCActivePanelProperties()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func FileIsValid($strImageFilePath)

	If Not FileExists($strTCPathCur & $strTCFileCur) Then
		WriteLog("FileIsValid", '"' & $strTCPathCur & $strTCFileCur & '" ' & $arrLocStr[78])
		$strStdErr = "TCMetadataViewer" & @TAB & $cstrNullString & @TAB & $cstrNullString & @TAB & $arrLocStr[78] & @CRLF ;*** Ignoriert (Datei existiert nicht)
		$arrTagList = StringSplit($strStdErr, @CRLF, 1)
		Return False
	EndIf

	If StringInStr(FileGetAttrib($strTCPathCur & $strTCFileCur), "D") > 0 Then
		WriteLog("FileIsValid", '"' & $strTCPathCur & $strTCFileCur & '" ' & $arrLocStr[79])
		$strStdErr = "TCMetadataViewer" & @TAB & $cstrNullString & @TAB & $cstrNullString & @TAB & $arrLocStr[79] & @CRLF ;*** Ignoriert (Verzeichnis)
		$arrTagList = StringSplit($strStdErr, @CRLF, 1)
		Return False
	EndIf

	If IniRead($cstrIniFile, "FileExtensionsUnsupported", $strTCExtCur, "1") = "0" Then
		WriteLog("FileIsValid", '"' & $strTCPathCur & $strTCFileCur & '" ' & $arrLocStr[80])
		$strStdErr = "TCMetadataViewer" & @TAB & $cstrNullString & @TAB & $cstrNullString & @TAB & $arrLocStr[80] & @CRLF ;*** Dateityp nicht untersttzt (Dateinamenserweiterung enthalten in TCMetadataViewer.ini/[FileExtensionsUnsupported])
		$arrTagList = StringSplit($strStdErr, @CRLF, 1)
		Return False
	EndIf

	If $strTCExtCur = "pjg" And $strPackJPGPath <> "" Then
		If Not FileExists($strPackJPGPath) Then
			$strErrMsg = StringReplace($arrLocStr[1], "%p", $strPackJPGPath)
			$strErrMsg = StringReplace($strErrMsg, "%n", "PackJPG")
			$strPackJPGPath = ""
			WriteLog("FileIsValid", StringReplace($strErrMsg, @LF, " | "))
			MsgBox(48+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
		EndIf
	EndIf

	Return True

EndFunc ;Func FileIsValid($strImageFilePath)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetMetadataExifTool($strImageFilePath)
	;GUICtrlSetColor($lblStatus, 0xFF0000)
	GUICtrlSetData($lblStatus, $arrLocStr[64])

	;*** Taglist erstellen
	$strExifToolParam = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
	$strExifToolParam &= $strOptDup & @CRLF & "-t" & @CRLF & "-H" & @CRLF
	If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
	If $strOptTagNam = "Desc" Then
		$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
	Else
		$strExifToolParam &= "-s" & @CRLF
	EndIf

	;bookmark
	If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
		;$strExifToolParam &= "-srcfile" & @CRLF
		;$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
		GUICtrlSetColor($lblFilename, 0xC00000)
	Else
		GUICtrlSetColor($lblFilename, 0x000000)
	EndIf

	$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strImageFilePath, 1, "Def")
	If @error Then
		$arrTagList = StringSplit($strExifToolErr, @CRLF, 1)
		For $i = 1 To $arrTagList[0]
			$arrTagList[$i] = "ExifTool" & @TAB & $cstrNullString & @TAB & $cstrNullString & @TAB & StringReplace($arrTagList[$i], @TAB, "")
		Next
	Else
		$arrTagList = StringSplit($strExifToolOut, @CRLF, 1)
	EndIf
;~ 	MsgBox(262144, "$strExifToolOut", $arrTagList[0] & @LF & $strExifToolOut) ;debug
;~ 	FileWrite(@ScriptDir & "\GetMetadataExifTool_" & @HOUR & @MIN & @SEC & ".txt", $strExifToolOut) ;debug

	;*** Taglist anzeigen
	GUICtrlSetState($btnTagGroupFile, $GUI_HIDE)
	GUICtrlSetState($btnTagGroupComposite, $GUI_HIDE)
	GUICtrlSetState($btnTagGroupEXIF, $GUI_HIDE)
	GUICtrlSetState($btnTagGroupIPTC, $GUI_HIDE)
	GUICtrlSetState($btnTagGroupXMP, $GUI_HIDE)
	GUICtrlSetState($btnTagGroupMakerNotes, $GUI_HIDE)
	GUICtrlSetState($btnListRegions, $GUI_HIDE)
	GUICtrlSetState($btnViewDescriptIon, $GUI_HIDE)
	GUICtrlSetState($btnViewThumbnailImage, $GUI_HIDE)
	GUICtrlSetState($btnViewPreviewImage, $GUI_HIDE)
	GUICtrlSetState($contextPicPicPlaySound, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicShowGPSPos, $GUI_DISABLE)
	If $strImageConverter = "IrfanView" Then GUICtrlSetState($contextPicPicOptimize, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicRotate090, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicRotate180, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicRotate270, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicRotateExif, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicViewThumbnailImage, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicSaveThumbnailImage, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicDeleteThumbnailImage, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicViewPreviewImage, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicSavePreviewImage, $GUI_DISABLE)
	GUICtrlSetState($contextPicPicDeletePreviewImage, $GUI_DISABLE)

	GUICtrlSetData($txtImageTitle, "")

	GUICtrlSetData($lblDateTimeOriginalDate, "")
;~ 	GUICtrlSetState($lblDateTimeOriginalDate, $GUI_HIDE)
	GUICtrlSetData($lblDateTimeOriginalTime, "")
;~ 	GUICtrlSetState($lblDateTimeOriginalTime, $GUI_HIDE)
	GUICtrlSetData($lblDateTimeOriginalDST, "")
;~ 	GUICtrlSetState($lblDateTimeOriginalDST, $GUI_HIDE)

	If $strLayoutXMPRating = "Stars" Then
		For $intXMPRating = 1 To 5
			GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRating), $cstrIcoDir & "\Stars0.ico", 0)
			GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - (64-$intXMPRating*9), 80+1*15)
		Next
	Else
		For $intXMPRating = 1 To 5
			GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRating), $cstrIcoDir & "\NotRating" & $intXMPRating & ".ico", 0)
			GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - (48+5), 80 + Abs($intXMPRating-6)*15)
		Next
	EndIf
	GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\NotRatingRej.ico", 0)
	GUICtrlSetPos($icoXMPRatingRej, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY)
	GUICtrlSetImage($icoXMPRatingMinus, $cstrIcoDir & "\NotRatingMinus.ico", 0)
	GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
	GUICtrlSetImage($icoXMPRatingPlus, $cstrIcoDir & "\NotRatingPlus.ico", 0)
	GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)

	If $intShowXMPLabel = 1 Then
		GUICtrlSetImage($icoXMPLabelRed,    $cstrIcoDir & "\Label_Dark.ico", 0)
		GUICtrlSetImage($icoXMPLabelYellow, $cstrIcoDir & "\Label_Dark.ico", 0)
		GUICtrlSetImage($icoXMPLabelGreen,  $cstrIcoDir & "\Label_Dark.ico", 0)
		GUICtrlSetImage($icoXMPLabelBlue,   $cstrIcoDir & "\Label_Dark.ico", 0)
		GUICtrlSetImage($icoXMPLabelPurple, $cstrIcoDir & "\Label_Dark.ico", 0)
		GUICtrlSetPos($icoXMPLabelRed,    $intTCInactivePanelW - 53, 179+15 + 1*14)
		GUICtrlSetPos($icoXMPLabelYellow, $intTCInactivePanelW - 53, 179+15 + 2*14)
		GUICtrlSetPos($icoXMPLabelGreen,  $intTCInactivePanelW - 53, 179+15 + 3*14)
		GUICtrlSetPos($icoXMPLabelBlue,   $intTCInactivePanelW - 53, 179+15 + 4*14)
		GUICtrlSetPos($icoXMPLabelPurple, $intTCInactivePanelW - 53, 179+15 + 5*14)
	EndIf

	;Test - Begin
	GUICtrlSetData($lblTechInfoShutterSpeed, "")
	GUICtrlSetData($lblTechInfoAperture, "")
	GUICtrlSetData($lblTechInfoISO, "")
	GUICtrlSetData($lblTechInfoFLen35, "")
	;Test - Ende

	;*** Filterbuttons neu belegen
	For $i = 1 To 6
		$arrButtons[$i][0] = ""
		$arrButtons[$i][1] = ""
	Next

	$intFilterButtonsIdx = 0
	$arrFilterButtons = IniReadSection($cstrIniFile, "FilterButtons")
	If @error Then Dim $arrFilterButtons[7][2] = [[6, ""], ["FB1", "File:File"], ["FB2", "Composite:Comp"], ["FB3", "EXIF:EXIF"], ["FB4", "IPTC:IPTC"], ["FB5", "XMP:XMP"], ["FB6", "MakerNotes:Maker"]]
	For $i = 1 To $arrFilterButtons[0][0]
		$p = StringInStr($arrFilterButtons[$i][1], ":")
		$strButtonTagGrp = StringLeft($arrFilterButtons[$i][1], $p-1)
		$strButtonCaption = StringMid($arrFilterButtons[$i][1], $p+1)
		$intTagListIdx = _ArraySearch($arrTagList, $strButtonTagGrp & @TAB, 1, 0, 0, 1)
		While $intTagListIdx > -1
			If StringInStr($arrTagList[$intTagListIdx], $strButtonTagGrp & @TAB) = 1 Then
				$intFilterButtonsIdx += 1
				$arrButtons[$intFilterButtonsIdx][0] = $strButtonTagGrp
				$arrButtons[$intFilterButtonsIdx][1] = $strButtonCaption
				ExitLoop
			EndIf
			$intTagListIdx = _ArraySearch($arrTagList, $strButtonTagGrp & @TAB, $intTagListIdx+1, 0, 0, 1)
		WEnd
		If $intFilterButtonsIdx = 6 Then ExitLoop
	Next

	If $intFilterButtonsIdx >= 1 Then
		GUICtrlSetData($btnTagGroupFile, $arrButtons[1][1])
		$intBtnTagGroupFileState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 240-2 Then GUICtrlSetState($btnTagGroupFile, $GUI_SHOW)
	EndIf
	If $intFilterButtonsIdx >= 2 Then
		GUICtrlSetData($btnTagGroupComposite, $arrButtons[2][1])
		$intBtnTagGroupCompositeState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 282-3 Then GUICtrlSetState($btnTagGroupComposite, $GUI_SHOW)
	EndIf
	If $intFilterButtonsIdx >= 3 Then
		GUICtrlSetData($btnTagGroupEXIF, $arrButtons[3][1])
		$intBtnTagGroupEXIFState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 324-4 Then GUICtrlSetState($btnTagGroupEXIF, $GUI_SHOW)
	EndIf
	If $intFilterButtonsIdx >= 4 Then
		GUICtrlSetData($btnTagGroupIPTC, $arrButtons[4][1])
		$intBtnTagGroupIPTCState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 366-5 Then GUICtrlSetState($btnTagGroupIPTC, $GUI_SHOW)
	EndIf
	If $intFilterButtonsIdx >= 5 Then
		GUICtrlSetData($btnTagGroupXMP, $arrButtons[5][1])
		$intBtnTagGroupXMPState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 408-6 Then GUICtrlSetState($btnTagGroupXMP, $GUI_SHOW)
	EndIf
	If $intFilterButtonsIdx >= 6 Then
		GUICtrlSetData($btnTagGroupMakerNotes, $arrButtons[6][1])
		$intBtnTagGroupMakerNotesState = $GUI_SHOW
		If $intTCInactivePanelW - (20+41) >= 450-7 Then GUICtrlSetState($btnTagGroupMakerNotes, $GUI_SHOW)
	EndIf

	;GUICtrlSetColor($lblStatus, 0xFF8000)
	GUICtrlSetData($lblStatus, $arrLocStr[65])
	$intXMPRatingOld = 0

	If $strOptTagNam = "Name" And Not ($intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType)) Then
		$arrTagListSpecial = $arrTagList

	Else
		$strExifToolParam = "-G0" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF
		$strExifToolParam &= "-Composite:ImageSize" & @CRLF
;~ 		$strExifToolParam &= "-EXIF:Orientation" & @CRLF
		$strExifToolParam &= "-IFD0:Orientation" & @CRLF ;*** Wenn Bild bereits gedreht gespeichert ist und Orient. in IFD1 vorhanden, nicht aber in IFD0, dann verzerrter QuickView
		$strExifToolParam &= "-ID3:Picture" & @CRLF
		$strExifToolParam &= "-Vorbis:CoverArt" & @CRLF
		$strExifToolParam &= "-FLAC:Picture" & @CRLF
		$strExifToolParam &= "-Composite:ThumbnailImage" & @CRLF
		$strExifToolParam &= "-Composite:PreviewImage" & @CRLF
		$strExifToolParam &= "-File:Comment" & @CRLF
		$strExifToolParam &= "-EXIF:DateTimeOriginal" & @CRLF
		$strExifToolParam &= "-XMP:Rating" & @CRLF
		$strExifToolParam &= "-XMP:Label" & @CRLF
		$strExifToolParam &= "-XMP:DaylightSavings" & @CRLF
		$strExifToolParam &= "-XMP:RegionPersonDisplayName" & @CRLF

		;Test - Begin
		$strExifToolParam &= "-EXIF:Flash#" & @CRLF ;*** The print conversion may be disabled on a per-tag basis by suffixing the tag name with a "#" character
		$strExifToolParam &= "-Composite:ShutterSpeed" & @CRLF
		$strExifToolParam &= "-Composite:Aperture" & @CRLF
		$strExifToolParam &= "-EXIF:ISO" & @CRLF ;*** Oder: MakerNotes:ISO
		$strExifToolParam &= "-Composite:FocalLength35efl" & @CRLF ;*** 8.0mm (35 mm equivalent: 72.3 mm)" & @CRLF
		;Test - Ende

		$strExifToolParam &= "-Composite:GPSPosition#" & @CRLF ;*** The print conversion may be disabled on a per-tag basis by suffixing the tag name with a "#" character
		;$strExifToolParam &= "-EXIF:GPSImgDirection#" & @CRLF ;*** The print conversion may be disabled on a per-tag basis by suffixing the tag name with a "#" character

		$strExifToolOut = FeedExifTool("ReadSpecTags", $strExifToolParam, $strImageFilePath, 1, "Def")
		$arrTagListSpecial = StringSplit($strExifToolOut, @CRLF, 1)

		;bookmark
		;*** Sidecar-Files enthalten keine Infos zur Bildgeometrie (Breite, Hhe usw.), das Quickview-Bild wird daher fehlerhaft dargestellt, wenn UseSidecarFile=1
		;*** Bildgeometrie-Daten mssen also aus dem eigentlichen Image-File gelesen werden. Diese werden hier - zusammen mit weiteren, im 2. Schritt ggf. wieder zu berschreibenden Tags - zuerst ermittelt
		If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			$strExifToolParam = "-G0" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF
			;$strExifToolParam &= "-srcfile" & @CRLF
			;$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
			$strExifToolParam &= "-Composite:ImageSize" & @CRLF
;~ 			$strExifToolParam &= "-EXIF:Orientation" & @CRLF
			$strExifToolParam &= "-IFD0:Orientation" & @CRLF
			$strExifToolOut = FeedExifTool("ReadSpecTags", $strExifToolParam, $strImageFilePath, 0, "Def")
			$arrTagListSpecial2 = StringSplit($strExifToolOut, @CRLF, 1)
			For $i = 1 To 2
				$arrTagListSpecial[$i] = $arrTagListSpecial2[$i]
			Next
			$arrTagListSpecial2 = ""
		EndIf
	EndIf

	$strSoundFilePath = StringLeft($strImageFilePath, StringInStr($strImageFilePath, ".", 0, -1)) & "wav"
	If FileExists($strSoundFilePath) Then GUICtrlSetState($contextPicPicPlaySound, $GUI_ENABLE)

	If StringInStr("|JPG|JPEG|", $strTCExtCur, 0) > 0 Then
		If $strImageConverter = "IrfanView" Then GUICtrlSetState($contextPicPicOptimize, $GUI_ENABLE)
		If $strImageConverter <> "ImageMagick" Then
			GUICtrlSetState($contextPicPicRotate090, $GUI_ENABLE)
			GUICtrlSetState($contextPicPicRotate180, $GUI_ENABLE)
			GUICtrlSetState($contextPicPicRotate270, $GUI_ENABLE)
			GUICtrlSetState($contextPicPicRotateExif, $GUI_ENABLE)
		EndIf
	EndIf

	If FileExists($strTCPathCur & "descript.ion") Then
		WriteLog("ReadDescriptIon", $strTCPathCur & "descript.ion")
		$strDescriptIon = FileRead($strTCPathCur & "descript.ion")
		$arrDescriptIon = StringSplit($strDescriptIon, @CRLF, 1)
		$strDescriptIon = ""
		$intDescriptIonIdx = _ArraySearch($arrDescriptIon, $strImageFilePath, 1, 0, 0, 1)
		While $intDescriptIonIdx > -1
			$p = StringInStr($arrDescriptIon[$intDescriptIonIdx], '"' & $strImageFilePath & '" ')
			If $p <> 1 Then $p = 0
			If StringInStr($arrDescriptIon[$intDescriptIonIdx], $strImageFilePath & ' ') = 1 Or $p = 1 Then
				$strDescriptIon = $arrDescriptIon[$intDescriptIonIdx]
				$strDescriptIon = StringTrimLeft($strDescriptIon, StringLen($strImageFilePath)+$p*2+1)
				$intBtnViewDescriptIonState = $GUI_SHOW
				If $intTCInactivePanelW - (20+41) >= 534-9 Then GUICtrlSetState($btnViewDescriptIon, $GUI_SHOW)
				ExitLoop
			EndIf
			$intDescriptIonIdx = _ArraySearch($arrDescriptIon, $strImageFilePath, $intDescriptIonIdx+1, 0, 0, 1)
		WEnd
	Else
		$strDescriptIon = ""
	EndIf

	$booImgRotate = False
	$strDateTimeOriginal = ""
	$booDaylightSavingsExists = False
	$strXMPLabel = ""
	$strGPSPosition = ""
	;$strGPSDirection = ""
	For $i = 1 To $arrTagListSpecial[0]-1
		$arrTag = SplitTagListRec($arrTagListSpecial[$i])
		Switch $arrTag[1] & ":" & $arrTag[3] ;*** $arrTag[1] (TagGrp) ist fr nicht vorhandene Tags leer, $arrTag[1]:$arrTag[3] erfllt dann keine Case-Bedingung (=erwnscht!)
			Case "Composite:ThumbnailImage", "Image:ThumbnailImage", "MakerNotes:ThumbnailImage", "ID3:Picture", "ID3v2_2:Picture", "ID3v2_3:Picture", "ID3v2_4:Picture", "Image:Picture", "Camera:ThumbnailImage", "Vorbis:CoverArt", "FLAC:Picture" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				$intBtnViewThumbnailImageState = $GUI_SHOW
				If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) >= 576-10 Then GUICtrlSetState($btnViewThumbnailImage, $GUI_SHOW)
				GUICtrlSetState($contextPicPicViewThumbnailImage, $GUI_ENABLE)
				GUICtrlSetState($contextPicPicSaveThumbnailImage, $GUI_ENABLE)
				GUICtrlSetState($contextPicPicDeleteThumbnailImage, $GUI_ENABLE)
			Case "Composite:PreviewImage", "Image:PreviewImage", "MakerNotes:PreviewImage", "Camera:PreviewImage" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				$intBtnViewPreviewImageState = $GUI_SHOW
				If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) >= 618-11 Then GUICtrlSetState($btnViewPreviewImage, $GUI_SHOW)
				GUICtrlSetState($contextPicPicViewPreviewImage, $GUI_ENABLE)
				GUICtrlSetState($contextPicPicSavePreviewImage, $GUI_ENABLE)
				GUICtrlSetState($contextPicPicDeletePreviewImage, $GUI_ENABLE)
			Case "Composite:ImageSize", "Image:ImageSize" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ+Loc, Cat
				$p = StringInStr($arrTag[4], "x")
				$intImgW = StringLeft($arrTag[4], $p-1) * 1
				$intImgH = StringMid($arrTag[4], $p+1) * 1
				If $booMagnify = False Then
					$intImgWOri = $intImgW
					$intImgHOri = $intImgH
				EndIf
			Case "EXIF:Orientation", "IFD0:Orientation", "Image:Orientation" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				#cs
				1 = Horizontal (normal)
				2 = Mirror horizontal
				3 = Rotate 180
				4 = Mirror vertical
				5 = Mirror horizontal and rotate 270 CW
				6 = Rotate 90 CW
				7 = Mirror horizontal and rotate 90 CW
				8 = Rotate 270 CW
				#ce
				Switch $arrTag[4]
					Case "1", "Horizontal (normal)", "65537", "Unknown (65537)"
						$intImgOrient = 1
					Case "6", "Rotate 90 CW"
						$intImgOrient = 6
					Case "3", "Rotate 180"
						$intImgOrient = 3
					Case "8", "Rotate 270 CW"
						$intImgOrient = 8
					Case Else
						$intImgOrient = 9
				EndSwitch
;~ 				If $booQuickviewHQ = True And $intExifRotate = 1 And ($strOptTagVal = "Lit" Or  $strOptTagNam <> "Name") And StringInStr($arrTag[4], " CW") > 0 Then $booImgRotate = True
;~ 				If $booQuickviewHQ = True And $intExifRotate = 1 And  $strOptTagVal = "Num" And $strOptTagNam =  "Name"  And $arrTag[4]*1 > 4                   Then $booImgRotate = True
				If $booQuickviewHQ = True And $intExifRotate = 1 And $intImgOrient > 4 Then $booImgRotate = True
			Case "File:Comment"
				GUICtrlSetData($txtImageTitle, $arrTag[4])
			Case "EXIF:DateTimeOriginal", "ExifIFD:DateTimeOriginal", "Time:DateTimeOriginal" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				GUICtrlSetState($lblDateTimeOriginal, $GUI_SHOW)
				GUICtrlSetState($lblDateTimeOriginalDate, $GUI_SHOW)
				GUICtrlSetState($lblDateTimeOriginalTime, $GUI_SHOW)
				$strDateTimeOriginal = $arrTag[4]
				$arrDateTimeOriginal = StringSplit($strDateTimeOriginal, ": ", 0)
				;*** Erwartet werden 6 Datums-/Zeitkomponenten: YYYY:MM:DD hh:nn:ss. Time:DateTimeOriginal kann auch nur eine Jahreszahl (bei MP3s, z.B. "2001") enthalten
				If $arrDateTimeOriginal[0] = 6 Then
					$strWeekday = StringMid($arrLocStr[85], GetDayOfWeek($strDateTimeOriginal)*3+1, 2)
					GUICtrlSetData($lblDateTimeOriginalDate, $strWeekday & " " & $arrDateTimeOriginal[3] & @LF & StringMid($arrLocStr[21], ($arrDateTimeOriginal[2]-1)*4+1, 3) & " '" & StringRight($arrDateTimeOriginal[1], 2))
					GUICtrlSetData($lblDateTimeOriginalTime, $arrDateTimeOriginal[4] & ":" & $arrDateTimeOriginal[5])
					If $intShowXMPDaylightSavings > 0 Then
						GUICtrlSetState($lblDateTimeOriginalDST, $GUI_SHOW)
						If $intShowXMPDaylightSavings = 1 Then
							GUICtrlSetData($lblDateTimeOriginalDST, "") ;*** "" ("A" mit Cirkumflex)in Wingdings = Analoguhr 0:00 Uhr
						Else ;*** $intShowXMPDaylightSavings = 2
							If GetDaylightSavings($strDateTimeOriginal) = 0 Then
								GUICtrlSetData($lblDateTimeOriginalDST, "T") ;*** "T" in Wingdings = Schneekristall
							Else
								GUICtrlSetData($lblDateTimeOriginalDST, "R") ;*** "R" in Wingdings = Sonne
							EndIf
						EndIf
						GUICtrlSetColor($lblDateTimeOriginalDST, $strBGColorInactiveControls)
					EndIf
				EndIf
			Case "XMP:DaylightSavings", $strXMPDaylightSavingsG1, $strXMPDaylightSavingsG2
				$booDaylightSavingsExists = True
				If $arrTag[4] = 0 Then
					GUICtrlSetData($lblDateTimeOriginalDST, "T") ;*** "T" in Wingdings = Schneekristall
					GUICtrlSetColor($lblDateTimeOriginalDST, 0x6FA1D9) ;Standardzeit 0x00C0FF / 0x6FA1D9
				Else
					GUICtrlSetData($lblDateTimeOriginalDST, "R") ;*** "R" in Wingdings = Sonne
					GUICtrlSetColor($lblDateTimeOriginalDST, 0xFFF477) ;Sommerzeit 0xFFC000 / 0xFFF477
				EndIf
			Case "XMP:Rating", "XMP-xmp:Rating", "Image:Rating" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				$fltXMPRatingOld = $arrTag[4] * 1
				$intXMPRatingOld = Round($fltXMPRatingOld) ;*** Runden nichtganzzahliger Ratings
				If $intXMPRatingOld = -1 Then
					GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\RatingRej.ico", 0)
					GUICtrlSetPos($icoXMPRatingRej, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY)
				Else
					If $strLayoutXMPRating = "Stars" Then
						For $intXMPRating = 1 To $intXMPRatingOld
							GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRating), $cstrIcoDir & "\Stars1.ico", 0)
							GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - (64-$intXMPRating*9), 80+1*15)
						Next
						For $intXMPRating = $intXMPRatingOld + 1 To 5
							GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRating), $cstrIcoDir & "\Stars0.ico", 0)
							GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRating), $intTCInactivePanelW - (64-$intXMPRating*9), 80+1*15)
						Next
					Else
						GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRatingOld), $cstrIcoDir & "\Rating" & $intXMPRatingOld & ".ico", 0)
						GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRatingOld), $intTCInactivePanelW - (48+5), 80 + (6-$intXMPRatingOld)*15)
					EndIf
				EndIf
				If $fltXMPRatingOld < $intXMPRatingOld Then
					GUICtrlSetImage($icoXMPRatingMinus, $cstrIcoDir & "\RatingMinus.ico", 0)
					GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
				EndIf
				If $fltXMPRatingOld > $intXMPRatingOld Then
					GUICtrlSetImage($icoXMPRatingPlus, $cstrIcoDir & "\RatingPlus.ico", 0)
					GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)
				EndIf
			Case "XMP:Label", "XMP-xmp:Label", "Image:Label" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				If $intShowXMPLabel = 1 Then
					$strXMPLabel = $arrTag[4]
					If $intAllowMultLabel = 1 Then
						$arrXMPLabel = StringSplit($strXMPLabel, "|")
						For $intXMPLabel = 1 To $arrXMPLabel[0]
							$strXMPLabelColor = IniRead($cstrIniFile, "LabelsMapTag2DispColor", $arrXMPLabel[$intXMPLabel], "")
							If $strXMPLabelColor <> "" Then
								GUICtrlSetImage(Eval("icoXMPLabel" & $strXMPLabelColor), $cstrIcoDir & "\Label_" & $strXMPLabelColor & ".ico", 0)
							EndIf
						Next
					Else
						$strXMPLabelColor = IniRead($cstrIniFile, "LabelsMapTag2DispColor", $strXMPLabel, "")
						If $strXMPLabelColor <> "" Then
							GUICtrlSetImage(Eval("icoXMPLabel" & $strXMPLabelColor), $cstrIcoDir & "\Label_" & $strXMPLabelColor & ".ico", 0)
						EndIf
					EndIf
					GUICtrlSetPos($icoXMPLabelRed,    $intTCInactivePanelW - 53, 179+15 + 1*14)
					GUICtrlSetPos($icoXMPLabelYellow, $intTCInactivePanelW - 53, 179+15 + 2*14)
					GUICtrlSetPos($icoXMPLabelGreen,  $intTCInactivePanelW - 53, 179+15 + 3*14)
					GUICtrlSetPos($icoXMPLabelBlue,   $intTCInactivePanelW - 53, 179+15 + 4*14)
					GUICtrlSetPos($icoXMPLabelPurple, $intTCInactivePanelW - 53, 179+15 + 5*14)
				EndIf
;~ 			Case "XMP:RegionPersonDisplayName", "XMP-MP:RegionPersonDisplayName", "Image:RegionPersonDisplayName" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
			;*** MakerNotes:AFAreas, Olympus:AFAreas, Camera:AFAreas
			;*** MakerNotes:AFPointSelected, Olympus:AFPointSelected, Camera:AFPointSelected
			Case "XMP:RegionPersonDisplayName", "XMP-MP:RegionPersonDisplayName", "Image:RegionPersonDisplayName", "MakerNotes:AFAreas", "Olympus:AFAreas", "Camera:AFAreas", "MakerNotes:AFPointSelected", "Olympus:AFPointSelected", "Camera:AFPointSelected" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ, Loc, Cat
				$intBtnListRegionsState = $GUI_SHOW
				If $intTCInactivePanelW - (18+2 + 5 + 13*2 + 2 + 41) >= 492-8 Then GUICtrlSetState($btnListRegions, $GUI_SHOW)


;~ 			#cs
			;Test - Begin
			Case "EXIF:Flash"
				;Test - Begin
				$intFlash = 0
;~ 				If $strOptTagNam = "Name" And Not ($intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType)) Then
				If $strOptTagVal = "Lit" Then
					$intFlash = FeedExifTool("ReadSpecTags", "-EXIF:Flash#" & @CRLF & "-s3" & @CRLF, $strImageFilePath, 1, "Def")
				Else
					$intFlash = $arrTag[4]
				EndIf
				;Test - Ende

				If Mod($intFlash, 2) = 1 Then
					GUICtrlSetColor($lblTechInfoShutterSpeed, 0x6FA1D9) ;hblau: 0x6FA1D9, orange: 0xFF8000
				Else
					GUICtrlSetColor($lblTechInfoShutterSpeed, $strBGColorActiveControls) ;0x00C0FF / 0x6FA1D9
				EndIf
			Case "Composite:ShutterSpeed"
				GUICtrlSetData($lblTechInfoShutterSpeed, $arrTag[4])
			Case "Composite:Aperture"
				GUICtrlSetData($lblTechInfoAperture, $arrTag[4])
			Case "EXIF:ISO" ;*** Oder: MakerNotes:ISO
				GUICtrlSetData($lblTechInfoISO, "ISO " & $arrTag[4])
			Case "Composite:FocalLength35efl" ;*** 8.0mm (35 mm equivalent: 72.3 mm)" & @CRLF
				GUICtrlSetData($lblTechInfoFLen35, StringMid(StringTrimRight($arrTag[4], 1), StringInStr($arrTag[4], ":")+2))
			;Test - End
;~ 			#ce

			Case "Composite:GPSPosition", "Location:GPSPosition" ;*** TagGrp:TagNam bei $strOptTagGrp = Typ/Loc, Cat
				GUICtrlSetState($contextPicPicShowGPSPos, $GUI_ENABLE)
				$strGPSPosition = $arrTag[4]
			;Case "EXIF:GPSImgDirection"
			;	$strGPSDirection = $arrTag[4]
		EndSwitch

	Next

	;*** Todo: Prfen, ob bei Rotation um 180 fehlerhaft (bei 180-Drehung brauchen W und H nicht getauscht zu werden)
	If $booImgRotate = True Then
		$intImgT = $intImgH
		$intImgH = $intImgW
		$intImgW = $intImgT
		If $booMagnify = False Then
			$intImgWOri = $intImgW
			$intImgHOri = $intImgH
		EndIf
	EndIf

	FilterImageTags()

EndFunc ;Func GetMetadataExifTool($strImageFilePath)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetTagGroups()

	If $strTagFilter = "Desc" Then
		GUICtrlSetState($txtDescriptIon, $GUI_HIDE)
		GUICtrlSetState($lvwTags, $GUI_SHOW)
	EndIf

	_GUICtrlListView_RemoveAllGroups($hlvwTags)
	_GUICtrlListView_DeleteAllItems($hlvwTags)
	GUICtrlSetBkColor($btnTagGroupUser, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupAll, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupCustom, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupFile, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupComposite, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupEXIF, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupIPTC, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupXMP, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupMakerNotes, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnListRegions, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnViewDescriptIon, $strBGColorInactiveControls)

	$strCustomTagGrpMem = ""
	$intTagGroupNumTags = 0
	$intLvwItemIdx = -1

	_GUICtrlListView_BeginUpdate($hlvwTags)

	For $i = 1 To $arrTagList[0]-1
		$arrTag = SplitTagListRec($arrTagList[$i])
		$strCustomTagGrp = $arrTag[1]
		If $i = 1 Then $strCustomTagGrpMem = $strCustomTagGrp
		If $strCustomTagGrp = $strCustomTagGrpMem Then
			$intTagGroupNumTags += 1
		Else
			$intLvwItemIdx += 1
			_GUICtrlListView_AddItem($hlvwTags, $strCustomTagGrpMem)
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $cstrNullString, 1)
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $cstrNullString, 2)
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $intTagGroupNumTags, 3)
			$strCustomTagGrpMem = $arrTag[1]
			$intTagGroupNumTags = 1
		EndIf
	Next

	_GUICtrlListView_AddItem($hlvwTags, $strCustomTagGrpMem)
	_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1, $cstrNullString, 1)
	_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1, $cstrNullString, 2)
	_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1, $intTagGroupNumTags, 3)

	#cs
	$strExifToolParam = ' -X -struct -XMP-MP:All "' & $strTCPathCur & $strTCFileCur & '" >"' & $cstrTmpFile & '_XMP-MP.xml"'
	$strExifToolOut = RunExifTool("GetXMPMP", $strExifToolParam, -1)

	_XMLFileOpen($cstrTmpFile & "_XMP-MP.xml", "xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:XMP-MP='http://ns.exiftool.ca/XMP/XMP-MP/1.0/'")

	$strXPath = "//XMP-MP:Regions/rdf:Bag/rdf:li"
	$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)

	For $i = 1 To $intXMLTagDBNodeCount

		$strPersonName = ""
		$arrXMLGetValue = _XMLGetValue($strXPath & "[" & $i & "]/XMP-MP:PersonDisplayName")
		If Not @error Then $strPersonName = $arrXMLGetValue[1]

		$strRectangle = ""
		$arrXMLGetValue = _XMLGetValue($strXPath & "[" & $i & "]/XMP-MP:Rectangle")
		If Not @error Then $strRectangle = $arrXMLGetValue[1]

		_GUICtrlListView_AddItem($hlvwTags, "Region")
		_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1+$i, $cstrNullString, 1)
		_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1+$i, $strPersonName, 2)
		_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+1+$i, $strRectangle, 3)

	Next
	$intXMLTagDBOpen = 0
	#ce

	#cs
	;*** Ausgabebeispiel:
	;*** Region Info MP                  : {Regions=[{PersonDisplayName=John Doe,Rectangle=0.278639|, 0.255615|, 0.087938|, 0.117251},{PersonDisplayName=,Rectangle=},]}
	$strExifToolParam = "-struct" & @CRLF & "-XMP:RegionInfoMP" & @CRLF
	$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
	If Not @error Then
		$arrRegExpResult = StringRegExp($strExifToolOut, '\{PersonDisplayName=(.+?)(,Rectangle=(.+?)){0,1}(\})', 3) ;[1]=PersonDisplayName; [3]=Rectangle
		For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
			_GUICtrlListView_AddItem($hlvwTags, "Region")
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+2+$intRegExpResultIdx, $cstrNullString, 1)
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+2+$intRegExpResultIdx, BinaryToString($arrRegExpResult[$intRegExpResultIdx*4+0], 4), 2)
			_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx+2+$intRegExpResultIdx, StringReplace($arrRegExpResult[$intRegExpResultIdx*4+2], "|", ""), 3)
		Next
	EndIf
	#ce

	_GUICtrlListView_EndUpdate($hlvwTags)

	For $i = 0 To 3
		_GUICtrlListView_SetColumnWidth($hlvwTags, $i, $LVSCW_AUTOSIZE)
	Next

	$strTagFilter = "User:User"
	GUICtrlSetData($btnTagGroupUser, $arrLocStr[25])
	GUICtrlSetBkColor($btnTagGroupUser, $strBGColorActiveControls)

EndFunc ;Func GetTagGroups()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func EditSearchTerm()

	$strTagSearchForMem = $strTagSearchFor
	SetWinOnTopState(0)
	$strTagSearchFor = InputBox($cstrTCMetadataViewerVersion, $arrLocStr[77], $strTagSearchForMem, "", Default, 160)
	If @error > 0 Then
		$strTagSearchFor = $strTagSearchForMem
		$arrTagSearchFor = StringSplit($strTagSearchFor, "|")
	Else
		If $strTagSearchFor = "" Then
			$strTagFilter = "All"
		Else
			$strTagFilter = "SuchErg"
		EndIf
		$arrTagSearchFor = StringSplit($strTagSearchFor, "|")
		FilterImageTags()
	EndIf

	SetWinOnTopState($intWinOnTopStateUser)
	WinActivate($whTC)

EndFunc ;Func EditSearchTerm()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetImageDim($strImageFilePath, $localintPicW=0, $localintPicH=0)

	;GUICtrlSetColor($lblStatus, 0x80A0FF)
	GUICtrlSetData($lblStatus, $arrLocStr[67])

	$intPicW = $localintPicW
	$intPicH = $localintPicH
	If $localintPicW = 0 Then $intPicW = $intTCInactivePanelW - 59
	If $localintPicH = 0 Then $intPicH = Int($intTCInactivePanelH * ($intPanelDivider/100) - $intShowImageTitle*20) ;*** Wenn ImageTitle angezeigt werden soll, dann soll $picPic 20px (=Hhe der ImageTitel-Zeile) niedriger werden

	$strExifToolParam = "-G0" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF
;~ 	$strExifToolParam &= "-EXIF:Orientation" & @CRLF
	$strExifToolParam &= "-IFD0:Orientation" & @CRLF
	$strExifToolParam &= "-Composite:ImageSize" & @CRLF
	$strExifToolOut = FeedExifTool("GetImageDim", $strExifToolParam, $strImageFilePath, 0, "Def")
	If @error Then Return

	$intImgPreW = 0
	$intImgPreH = 0
	$booImgRotate = False
	$arrImageDim = StringSplit($strExifToolOut, @CRLF, 1)
	For $i = 1 To $arrImageDim[0]-1

		$arrTag = SplitTagListRec($arrImageDim[$i])
		$p = StringInStr($arrTag[4], "x")
		If $arrTag[3] = "ImageSize" And $p > 0 Then
			$intImgW = StringLeft($arrTag[4], $p-1) * 1 ;ToDo: Swap $intImgW <-> $intImgH, wenn Rotation gem EXIF +/-90 UND imgConverter = IrfanView
			$intImgH = StringMid($arrTag[4], $p+1) * 1

			If $booImgRotate = True Then
				$intImgT = $intImgH
				$intImgH = $intImgW
				$intImgW = $intImgT
			EndIf

			If $booMagnify = False Then
				$intImgWOri = $intImgW
				$intImgHOri = $intImgH
			EndIf

			$intScaleImg = $intPicW / $intImgW
			If $intPicH / $intImgH < $intScaleImg Then $intScaleImg = $intPicH / $intImgH
			If $intScaleImg > 1 And $booMagnify = False Then $intScaleImg = 1

			$intImgPreW = Int($intImgW * $intScaleImg)
			$intImgPreH = Int($intImgH * $intScaleImg)

		ElseIf $arrTag[3] = "Orientation" Then
			If $booQuickviewHQ = True And $intExifRotate = 1 And ($strOptTagVal = "Lit" Or  $strOptTagNam <> "Name") And StringInStr($arrTag[4], " CW") > 0 Then $booImgRotate = True
			If $booQuickviewHQ = True And $intExifRotate = 1 And  $strOptTagVal = "Num" And $strOptTagNam =  "Name"  And $arrTag[4]*1 > 4                   Then $booImgRotate = True

		EndIf

	Next

EndFunc ;Func GetImageDim($strImageFilePath, $intPicW=0, $intPicH=0)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func FilterImageTagsOnEvent()

	If FileIsValid($strTCPathCur & $strTCFileCur) Then
		Switch @GUI_CTRLID
			Case $btnTagGroupAll
				$strTagFilter = "All"
			Case $btnTagGroupCustom
				$strTagFilter = "Custom"
				$strCustomTagsDrilledDown = ""
			Case $btnTagGroupFile
				$strTagFilter = $arrButtons[1][0]
			Case $btnTagGroupComposite
				$strTagFilter = $arrButtons[2][0]
			Case $btnTagGroupEXIF
				$strTagFilter = $arrButtons[3][0]
			Case $btnTagGroupIPTC
				$strTagFilter = $arrButtons[4][0]
			Case $btnTagGroupXMP
				$strTagFilter = $arrButtons[5][0]
			Case $btnTagGroupMakerNotes
				$strTagFilter = $arrButtons[6][0]
			Case $btnListRegions
				$strTagFilter = "Region"
			Case $btnViewDescriptIon
				$strTagFilter = "Desc"
			Case $btnFilterSearchResult
				If $strTagSearchFor = "" Then
					EditSearchTerm()
				Else
					$strTagFilter = "SuchErg"
				EndIf
			Case $btnTagGroupUser
				$strTagFilter = "User:" & GUICtrlRead($btnTagGroupUser)
		EndSwitch
		$strTagFilterMem = $strTagFilter
	EndIf

	FilterImageTags()

EndFunc ;Func FilterImageTagsOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func FilterImageTags()
	;GUICtrlSetColor($lblStatus, 0xFFFF00)
	GUICtrlSetData($lblStatus, $arrLocStr[68])

	_GUICtrlListView_DeleteAllItems($hlvwTags)

	GUICtrlSetBkColor($btnTagGroupAll, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupCustom, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupFile, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupComposite, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupEXIF, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupIPTC, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupXMP, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupMakerNotes, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnListRegions, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnViewDescriptIon, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnFilterSearchResult, $strBGColorInactiveControls)
	GUICtrlSetBkColor($btnTagGroupUser, $strBGColorInactiveControls)

	_GUICtrlListView_EnableGroupView($hlvwTags, True)
	Switch $strTagFilter
		Case "All"
			GUICtrlSetBkColor($btnTagGroupAll, $strBGColorActiveControls)
		Case "Custom"
			$strCustomView = "CustomView_Default"
			$arrCustomViews = IniReadSection($cstrIniFile, "CustomViews")
			If @error = 0 Then
				For $i = 1 To $arrCustomViews[0][0]
					If StringInStr($arrCustomViews[$i][1], $strTCExtCur, 0) > 0 Then
						$strCustomView = $arrCustomViews[$i][0]
						ExitLoop
					EndIf
				Next
				If _ArraySearch($arrIniSectionNames, $strCustomView) = -1 Then $strCustomView = "CustomView_Default"
			EndIf
			If _ArraySearch($arrIniSectionNames, $strCustomView) = -1 Then
				$strTagFilter = "All"
				GUICtrlSetBkColor($btnTagGroupAll, $strBGColorActiveControls)
			Else
				$arrCustomTags = IniReadSection($cstrIniFile, $strCustomView)
				GUICtrlSetBkColor($btnTagGroupCustom, $strBGColorActiveControls)
			EndIf
		Case $arrButtons[1][0]
			GUICtrlSetBkColor($btnTagGroupFile, $strBGColorActiveControls)
		Case $arrButtons[2][0]
			GUICtrlSetBkColor($btnTagGroupComposite, $strBGColorActiveControls)
		Case $arrButtons[3][0]
			GUICtrlSetBkColor($btnTagGroupEXIF, $strBGColorActiveControls)
		Case $arrButtons[4][0]
			GUICtrlSetBkColor($btnTagGroupIPTC, $strBGColorActiveControls)
		Case $arrButtons[5][0]
			GUICtrlSetBkColor($btnTagGroupXMP, $strBGColorActiveControls)
		Case $arrButtons[6][0]
			GUICtrlSetBkColor($btnTagGroupMakerNotes, $strBGColorActiveControls)
		Case "Desc"
			If $strDescriptIon = "" Then
				$strTagFilter = "All"
				GUICtrlSetBkColor($btnTagGroupAll, $strBGColorActiveControls)
			Else
				GUICtrlSetBkColor($btnViewDescriptIon, $strBGColorActiveControls)
			EndIf
		Case "Region"
			;Todo: Weitere Aktionen erforderlich?
			If $intBtnListRegionsState = $GUI_SHOW Then
				GUICtrlSetBkColor($btnListRegions, $strBGColorActiveControls)
			Else
				$strTagFilter = "All"
				GUICtrlSetBkColor($btnTagGroupAll, $strBGColorActiveControls)
			EndIf
		Case "SuchErg"
			GUICtrlSetBkColor($btnFilterSearchResult, $strBGColorActiveControls)
		Case Else
			If StringLeft($strTagFilter, 5) = "User:" Then
				$strTagFilter = StringMid($strTagFilter, 6)
				GUICtrlSetBkColor($btnTagGroupUser, $strBGColorActiveControls)
			Else
				$strTagFilter = "All"
				GUICtrlSetBkColor($btnTagGroupAll, $strBGColorActiveControls)
			EndIf
			_GUICtrlListView_EnableGroupView($hlvwTags, False)
	EndSwitch

	If $strTagFilter <> "Desc" Then
		GUICtrlSetState($txtDescriptIon, $GUI_HIDE)
		GUICtrlSetState($lvwTags, $GUI_SHOW)
	EndIf

	;*** Auskommentiert; Grund: Wenn doppelte Tagnamen *nicht* zugelassen sind, dann unterdrckt ExifTool die Tag-Ausgabe selbst dann, wenn das gleichnamige Tag zu einer anderen TagGrp gehrt
	;*** Bsp.: IPTC.SupplementalCategories und XMP.SupplementalCategories => Nur XMP.SupplementalCategories werden ausgegeben
	;*** Fr Filter, die Tags genau einer TagGrp anzeigen (z.B. Filterbutton "EXIF"), ist die Unterdrckung erwnscht (wenn die Option eingeschaltet ist),
	;*** fr Filter, die Tags aus mehreren verschiedenen TagGrp anzeigen ("Cust") jedoch nicht bzw. nur bedingt.
	#cs
	If $strTagFilter = "Custom" And $strOptTagGrp = "Typ" And $strOptTagNam = "Name" Then
		;[...]
	ElseIf $strTagFilter = "Custom" And ($strOptTagGrp <> "Typ" Or $strOptTagNam <> "Name") Then
		;[...]
	#ce

;~ 	If $strTagFilter = "Custom" Then
	Switch $strTagFilter

		Case "Custom"
			;GUICtrlSetColor($lblStatus, 0xFF0000)
			GUICtrlSetData($lblStatus, $arrLocStr[64])

			;*** Erstellen einer Liste der Werte der im CustomView definierten Tags ($arrTagListCustom)
			;*** Erstellen einer "zeilensynchronen" Liste der TagGrp:TagNam der im CustomView definierten Tags ($arrTagCustNamList)
			;*** Erluterungen: In CustView sind Tags entsprechend TagGrp="Typ":TagNam="Name" definiert.
			;*** $arrTagList dagegen enthlt TagGrp entsprechend $strOptTagGrp und TagNam entsprechend $strOptTagNam
			;*** Wenn TagGrp<>"Typ" oder TagNam<>"Name", schlgt die Suche eines Tags aus dem CustView in der Tabelle $arrTagList fehl.
			;*** Die zwei Listen ermglichen eine Zuordnung (mit der Zeilennummer als Verknpfungsschlssel)
			$strTagCustNamList = ""
			$strExifToolParam  = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
			$strExifToolParam &= "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
			If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
			If $strOptTagNam = "Desc" Then
				$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
			Else
				$strExifToolParam &= "-s" & @CRLF
			EndIf
			;If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			;	$strExifToolParam &= "-srcfile" & @CRLF
			;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
			;EndIf

			For $i = 1 To $arrCustomTags[0][0]
				If $arrCustomTags[$i][1] <> "" Then
					;*** CustomView-Definitionen auswerten                  Vor     Pre         Grp    Nam  SubA       Unit        SubB       Suf           Nach
					;                                                       0       1           2      3    4          5           6          7             8
					;                                                       9       10          11     12   13         14          15         16            17
					$arrRegExpResult = StringRegExp($arrCustomTags[$i][1], '(.*?)\[=(".*?"){0,1}(.+?)\.(.+?)(:.+?){0,1}(\..+?){0,1}(:.+?){0,1}(".*?"){0,1}\](.*?)', 3)

					For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 9 - 1
						$strExifToolParam &= "-" & $arrRegExpResult[$intRegExpResultIdx*9+2] & ":" & $arrRegExpResult[$intRegExpResultIdx*9+3] & @CRLF
						$strTagCustNamList &= $arrRegExpResult[$intRegExpResultIdx*9+2] & ":" & $arrRegExpResult[$intRegExpResultIdx*9+3] & @CRLF
					Next
				EndIf
				$strExifToolParam &= "-TCMetadataViewer:NewLine" & @CRLF
				$strTagCustNamList &= ":" & @CRLF
			Next

			$strExifToolOut = FeedExifTool("BuildCustTagList", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
			$arrTagListCustom = StringSplit($strExifToolOut, @CRLF, 1)
			$arrTagCustNamList = StringSplit($strTagCustNamList, @CRLF, 1)

			$strCustomTagGrpMem = ""
			$strCustomTagGrpOt = ""
			$strCustomTagNamOt = ""
			$strCustomTagValOt = ""
			$intLvwItemIdx = -1

			_GUICtrlListView_BeginUpdate($hlvwTags)

			$intLvwGroupIdx = 0
			$strTagGroup = "Default"
			For $i = 1 To $arrCustomTags[0][0]

				$strCustomTagGrp = ""
				$strCustomTagNam = ""
				$strCustomTagVal = ""

	;~ 			$strCustomTagGrpMem = ""
	;~ 			$strCustomTagGrpOt = ""
				$strCustomTagNamOt = ""
				$strCustomTagValOt = ""

				If $arrCustomTags[$i][0] = "$Group" Then
					$intLvwGroupIdx += 1
					$strTagGroup = StringToUTF8($arrCustomTags[$i][1]) ;ToDo: Problem: In Gruppenberschriften knnen anscheinend keine Unicode-Zeichen angezeigt werden (Konvertierung StringToUTF8() oder StringToBinary() fhrt nicht zum Ziel)
					_GUICtrlListView_InsertGroup($hlvwTags, -1, $intLvwGroupIdx, $strTagGroup)
					_GUICtrlListView_SetGroupInfo($hlvwTags, $intLvwGroupIdx, $strTagGroup)

				Else
					If $arrCustomTags[$i][1] <> "" Then

						$arrCustomTags[$i][0] = StringToUTF8($arrCustomTags[$i][0]) ;In UTF-8 konvertieren
						$strCustomTagNamOt = $arrCustomTags[$i][0]

						;*** CustomFieldsContents-Definition auswerten          Vor     Pre         Grp    Nam  SubA       Unit        SubB       Suf           Nach
						;                                                       0       1           2      3    4          5           6          7             8
						;                                                       9       10          11     12   13         14          15         16            17
						$arrRegExpResult = StringRegExp($arrCustomTags[$i][1], '(.*?)\[=(".*?"){0,1}(.+?)\.(.+?)(:.+?){0,1}(\..+?){0,1}(:.+?){0,1}(".*?"){0,1}\](.*?)', 3)

						For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 9 - 1

							$arrRegExpResult[$intRegExpResultIdx*9+0] = StringToUTF8($arrRegExpResult[$intRegExpResultIdx*9+0]) ;In UTF-8 konvertieren
							$strCustomTagValOt &= $arrRegExpResult[$intRegExpResultIdx*9+0] ;Prfix (unbedingt)

							$strCustomTagGrp = $arrRegExpResult[$intRegExpResultIdx*9+2] ;TagGrp
							$strCustomTagNam = $arrRegExpResult[$intRegExpResultIdx*9+3] ;TagNam

							;*** In der "zeilensynchronen" Liste der Namen der im CustomView definierten Tags ($arrTagCustNamList) nach TagGrp:TagNam suchen...
							$intTagListIdx = _ArraySearch($arrTagCustNamList, $strCustomTagGrp & ":" & $strCustomTagNam, 1, 0, 0, 0)
							;*** ...um den Index als Verweis auf die Liste der TagVal ($arrTagListCustom) zu erhalten
							$arrTag = SplitTagListRec($arrTagListCustom[$intTagListIdx])
							$strCustomTagVal = $arrTag[4]
							If $strCustomTagVal <> "-" Then
								$arrRegExpResult[$intRegExpResultIdx*9+1] = StringToUTF8($arrRegExpResult[$intRegExpResultIdx*9+1]) ;In UTF-8 konvertieren
								$strCustomTagValOt &= StringTrimLeft(StringTrimRight($arrRegExpResult[$intRegExpResultIdx*9+1], 1), 1) ;Prfix (bedingt)

								;*** Feld-Wert formatieren (SubString-Anweisung anwenden)
								$strCustomTagSubStr = StringTrimLeft($arrRegExpResult[$intRegExpResultIdx*9+4] & $arrRegExpResult[$intRegExpResultIdx*9+6], 1)
								If $strCustomTagSubStr <> "" Then
									$p = StringInStr($strCustomTagSubStr, ",")

									;*** Startzeichen,AnzahlZeichen
									If $p > 0 Then
										$intCustomTagSubStrL = StringLeft($strCustomTagSubStr, $p-1) * 1
										$intCustomTagSubStrR = Abs(StringMid($strCustomTagSubStr, $p+1) * 1)
										If $intCustomTagSubStrR = 0 Then $intCustomTagSubStrR = StringLen($strCustomTagVal)
										If $intCustomTagSubStrL < 0 Then $intCustomTagSubStrL = StringLen($strCustomTagVal) + $intCustomTagSubStrL + 1
										$strCustomTagVal = StringMid($strCustomTagVal, $intCustomTagSubStrL, $intCustomTagSubStrR)

									;*** Startzeichen-Endezeichen
									Else
										$p = StringInStr($strCustomTagSubStr, "-", 0, 1)
										Switch $p
											Case 0 ;"Feldwert:n"
												$intCustomTagSubStrL = $strCustomTagSubStr * 1
												$intCustomTagSubStrR = $intCustomTagSubStrL
											Case 1 ;"Feldwert:-n" | "Feldwert:-n-m" | "Feldwert:-n-"
												$p = StringInStr($strCustomTagSubStr, "-", 0, 2)
												If $p = 0 Then ;"Feldwert:-n"
													$intCustomTagSubStrL = $strCustomTagSubStr * 1
													$intCustomTagSubStrR = $intCustomTagSubStrL
												Else ;"Feldwert:-n-m" | "Feldwert:-n-"
													$intCustomTagSubStrL = StringLeft($strCustomTagSubStr, $p-1) * 1
													$intCustomTagSubStrR = StringMid($strCustomTagSubStr, $p+1) * -1
													If $intCustomTagSubStrR = 0 Then ;"Feldwert:-n-"
														$intCustomTagSubStrR = StringLen($strCustomTagVal)
													EndIf
												EndIf
											Case Else ;"Feldwert:n-m" | "Feldwert:n--m" | "Feldwert:n-"
												$intCustomTagSubStrL = StringLeft($strCustomTagSubStr, $p-1) * 1
												$intCustomTagSubStrR = StringMid($strCustomTagSubStr, $p+1) * 1
												If $intCustomTagSubStrR = 0 Then ;"Feldwert:n-"
													$intCustomTagSubStrR = StringLen($strCustomTagVal)
												EndIf
										EndSwitch

										If $intCustomTagSubStrL < 0 Then $intCustomTagSubStrL = StringLen($strCustomTagVal) + $intCustomTagSubStrL + 1
										If $intCustomTagSubStrR < 0 Then $intCustomTagSubStrR = StringLen($strCustomTagVal) + $intCustomTagSubStrR + 1
										$strCustomTagVal = StringMid($strCustomTagVal, $intCustomTagSubStrL, $intCustomTagSubStrR-$intCustomTagSubStrL+1)

									EndIf

								EndIf

								$strCustomTagValOt &= $strCustomTagVal ;Tagwert (formatiert entsprechend SubStr-Anweisung)
								$arrRegExpResult[$intRegExpResultIdx*9+7] = StringToUTF8($arrRegExpResult[$intRegExpResultIdx*9+7]) ;In UTF-8 konvertieren
								$strCustomTagValOt &= StringTrimLeft(StringTrimRight($arrRegExpResult[$intRegExpResultIdx*9+7], 1), 1) ;Suffix (bedingt)

							EndIf
						Next

						$arrRegExpResult = StringRegExp($arrCustomTags[$i][1], '(.*\]){0,}(.*)', 1)
						$arrRegExpResult[1] = StringToUTF8($arrRegExpResult[1]) ;In UTF-8 konvertieren
						$strCustomTagValOt &= $arrRegExpResult[1] ;Suffix (unbedingt)

					EndIf

					If StringLen($strCustomTagValOt) > 259 Then $strCustomTagValOt = StringLeft($strCustomTagValOt, 259-4) & " []"
;~ 					$intLvwItemIdx = _GUICtrlListView_AddItem($hlvwTags, "CustomView")
					$intLvwItemIdx = _GUICtrlListView_AddItem($hlvwTags, $strCustomView & "_" & $strTagGroup)
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $cstrNullString, 1)
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $strCustomTagNamOt, 2)
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $strCustomTagValOt, 3)
					_GUICtrlListView_SetItemGroupID($hlvwTags, $intLvwItemIdx, $intLvwGroupIdx)

				EndIf

			Next

			If $intLvwGroupIdx = 0 Then _GUICtrlListView_EnableGroupView($hlvwTags, False)
			_GUICtrlListView_EndUpdate($hlvwTags)

		Case "Desc"
			GUICtrlSetState($lvwTags, $GUI_HIDE)
			GUICtrlSetState($txtDescriptIon, $GUI_SHOW)
			If StringRight($strDescriptIon, 2) = Chr(0x04) & Chr(0xC2) Then
				$strDescriptIon = StringTrimRight($strDescriptIon, 2)
				$strDescriptIon = StringReplace($strDescriptIon, "\\", Chr(0x04))
				$strDescriptIon = StringReplace($strDescriptIon, "\n", @CRLF)
				$strDescriptIon = StringReplace($strDescriptIon, Chr(0x04), "\")
			EndIf
			GUICtrlSetData($txtDescriptIon, $strDescriptIon)

		Case "Region"
			_GUICtrlListView_RemoveAllGroups($hlvwTags)
			_GUICtrlListView_DeleteAllItems($hlvwTags)

			;*** Dummyaufruf FilterImageTags() mit (im Endeffekt) leerem Filterkriterium zum "Initialisieren" des Listviews (Workaround gegen Nicht-Funktionieren des Drilldowns unter Win7 (Fehlerursache noch unbekannt))
			$strTagFilter = "User:"
			FilterImageTags()
			$strTagFilter = "Region"
			GUICtrlSetBkColor($btnTagGroupUser, $strBGColorInactiveControls)
			GUICtrlSetBkColor($btnListRegions, $strBGColorActiveControls)

			_GUICtrlListView_BeginUpdate($hlvwTags)

			$intRegExpResultIdxOffset = 0
			;*** Ausgabebeispiel:
			;*** Region Info MP                  : {Regions=[{PersonDisplayName=John Doe,Rectangle=0.278639|, 0.255615|, 0.087938|, 0.117251},{PersonDisplayName=,Rectangle=},]}
			$strExifToolParam = "-struct" & @CRLF & "-XMP:RegionInfoMP" & @CRLF
			$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
			If Not @error Then
				$arrRegExpResult = StringRegExp($strExifToolOut, '\{PersonDisplayName=(.+?)(,Rectangle=(.+?)){0,1}(\})', 3) ;[1]=PersonDisplayName; [3]=Rectangle
				For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
					_GUICtrlListView_AddItem($hlvwTags, "Region" & $intRegExpResultIdx)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx, $cstrNullString, 1)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx, BinaryToString($arrRegExpResult[$intRegExpResultIdx*4+0], 4), 2)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx, StringReplace($arrRegExpResult[$intRegExpResultIdx*4+2], "|", ""), 3)
				Next
				$intRegExpResultIdxOffset += $intRegExpResultIdx
			EndIf

;~ 			#cs
			;*** AFAreas
			;*** Todo: Orientation bercksichtigen (wie bei AFPointSelected)
			$strExifToolParam = "-s3" & @CRLF & "-Olympus:AFAreas" & @CRLF
			$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
			$arrRegExpResult = StringRegExp($strExifToolOut, '\((.+?),(.+?)\)-\((.+?),(.+?)\)', 3)
			If Not @error Then
				For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
					$x = Round($arrRegExpResult[$intRegExpResultIdx*4+0] / 256, 6)
					$y = Round($arrRegExpResult[$intRegExpResultIdx*4+1] / 256, 6)
					$w = Round($arrRegExpResult[$intRegExpResultIdx*4+2] / 256, 6)
					$h = Round($arrRegExpResult[$intRegExpResultIdx*4+3] / 256, 6)
					Switch $intImgOrient

						Case 6 ;*** Rotate 90 CW
							$t = $x
							$x = 1 - $y
							$y = $t

							$t = $w
							$w = 1 - $h
							$h = $t

							$t = $x
							$x = $w
							$w = $t

						Case 3 ;*** Rotate 180
;~ 							$x = 1 - $x
;~ 							$y = 1 - $y
;~ 							$w = 1 - $w
;~ 							$h = 1 - $h
							$t = $x
							$x = 1 - $w
							$w = 1 - $t

							$t = $y
							$y = 1 - $h
							$h = 1 - $t

						Case 8 ;*** Rotate 270 CW
							$t = $x
							$x = $y
							$y = 1 - $t

							$t = $w
							$w = $h
							$h = 1 - $t

							$t = $y
							$y = $h
							$h = $t

						Case Else
							;NOP

					EndSwitch
					$w -= $x
					$h -= $y
					_GUICtrlListView_AddItem($hlvwTags, "AFArea")
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, $cstrNullString, 1)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, "AFArea_" & $intRegExpResultIdx+1, 2)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, $x & ", " & $y & ", " & $w & ", " & $h, 3)
				Next
				$intRegExpResultIdxOffset += $intRegExpResultIdx
			EndIf
;~ 			#ce

;~ 			#cs
			;*** AFPointSelected
			$strExifToolParam = "-n" & @CRLF & "-s3" & @CRLF & "-Olympus:AFPointSelected" & @CRLF
			$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
			$arrRegExpResult = StringRegExp($strExifToolOut, '(.+?) (.+?) (.+?) (.+?)', 3)
			If Not @error Then
				For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
					$x = $arrRegExpResult[$intRegExpResultIdx*4+0]
					$y = $arrRegExpResult[$intRegExpResultIdx*4+1]
					;$w = $arrRegExpResult[$intRegExpResultIdx*4+2]
					;$h = $arrRegExpResult[$intRegExpResultIdx*4+3]
					$w = 0.04
					$h = 0.04
					Switch $intImgOrient
						Case 6 ;*** Rotate 90 CW
							$t = $x
							$x = 1 - $y
							$y = $t
						Case 3 ;*** Rotate 180
							$x = 1 - $x
							$y = 1 - $y
						Case 8 ;*** Rotate 270 CW
							$t = $x
							$x = $y
							$y = 1 - $t
						Case Else
							;NOP
					EndSwitch
					$x -= 0.02
					$y -= 0.02
					_GUICtrlListView_AddItem($hlvwTags, "AFPointSelected")
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, $cstrNullString, 1)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, "AFPointSelected_" & $intRegExpResultIdx+1, 2)
					_GUICtrlListView_AddSubItem($hlvwTags, $intRegExpResultIdx + $intRegExpResultIdxOffset, $x & ", " & $y & ", " & $w & ", " & $h, 3)
				Next
				$intRegExpResultIdxOffset += $intRegExpResultIdx
;~ 				If $booImgRotate = True Then MsgBox(0+262144, "AFPointSelected", "$booImgRotate = True") ;debug
			EndIf
;~ 			#ce

			_GUICtrlListView_EndUpdate($hlvwTags)

		Case Else
			_GUICtrlListView_BeginUpdate($hlvwTags)
			$intLvwItemCount = 0
			$intLvwItemIdx = -1
			For $i = 1 To $arrTagList[0]-1
				$arrTag = SplitTagListRec($arrTagList[$i])
				$strCustomTagVal = $arrTag[4]
				If StringLen($strCustomTagVal) > 259 Then $strCustomTagVal = StringLeft($strCustomTagVal, 259-4) & " []"
				$booTagSearchForFound = False
				If $strTagFilter = "SuchErg" Then
					For $intTagSearchFor = 1 To $arrTagSearchFor[0]
						If StringInStr($arrTagList[$i], $arrTagSearchFor[$intTagSearchFor], 0, 1, StringInStr($arrTagList[$i], @TAB)) > 0 Then $booTagSearchForFound = True
					Next
				EndIf
				If $strTagFilter = $arrTag[1] Or $strTagFilter = "All" Or $booTagSearchForFound = True Then
					$intLvwItemCount += 1
					$intLvwItemIdx += 1
					_GUICtrlListView_AddItem($hlvwTags, $arrTag[1])
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[2], 1)
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[3], 2)
					_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $strCustomTagVal, 3)
					If Mod($intLvwItemCount, 512) = 0 Then
						$strTmp = StringReplace($arrLocStr[81], "%n", $intLvwItemCount)
						$strTmp = StringReplace($strTmp, "%m", $arrTagList[0]-1)
						If MsgBox(4+32+262144, $cstrTCMetadataViewerVersion, $strTmp) = 7 Then ExitLoop
					EndIf
				EndIf
			Next

			$intLvwGroupIdx = 0
			$strTagGroup = ""
			$strTagGroupMem = ""
			For $intLvwItemIdx = 0 To _GUICtrlListView_GetItemCount($hlvwTags)-1
				$strTagGroup = _GUICtrlListView_GetItemText($hlvwTags, $intLvwItemIdx, 0)
;~ 				ConsoleWrite("FilterImageTags(): GetItemText " & $intLvwItemIdx & @CRLF) ;debug
				If $strTagGroup <> $strTagGroupMem Then
;~ 					ConsoleWrite("FilterImageTags(): InsertGroup " & $strTagGroup & @CRLF) ;debug
					$intLvwGroupIdx += 1
					_GUICtrlListView_InsertGroup($hlvwTags, -1, $intLvwGroupIdx, $strTagGroup)
					_GUICtrlListView_SetGroupInfo($hlvwTags, $intLvwGroupIdx, $strTagGroup)
					$strTagGroupMem = $strTagGroup
				EndIf
				_GUICtrlListView_SetItemGroupID($hlvwTags, $intLvwItemIdx, $intLvwGroupIdx)
			Next
;~ 			ConsoleWrite("--------------------------------------------------" & @CRLF) ;debug

			_GUICtrlListView_EndUpdate($hlvwTags)

	EndSwitch

	For $i = 0 To 3
		_GUICtrlListView_SetColumnWidth($hlvwTags, $i, $intLvwTagsColWidthTag[$i])
	Next

;~ 	MsgBox(0, "", "Pause2") ;debug

	If $intWinOnTopState = 1 Then WinActivate($whTC)

	;GUICtrlSetColor($lblStatus, 0x008000)
	GUICtrlSetData($lblStatus, $arrLocStr[63])

EndFunc ;Func FilterImageTags()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetQuickviewMode()
	Switch @GUI_CtrlId
		Case $contextPicPicQuickviewOff
			$booQuickview = False
			$booQuickviewThumb = False
			$booQuickviewHQ = False
			WriteLog("SetQuickviewMode", "QuickviewOff") ;debug
		Case $contextPicPicQuickviewThumb
			If $booQuickviewThumb = True Then
				$booQuickviewThumb = False
			Else
				$booQuickview = True
				$booQuickviewThumb = True
				$booQuickviewHQ = False
			EndIf
			WriteLog("SetQuickviewMode", "QuickviewThumb") ;debug
		Case $contextPicPicQuickviewStd
			$booQuickview = True
			$booQuickviewThumb = False
			$booQuickviewHQ = False
			WriteLog("SetQuickviewMode", "QuickviewStd") ;debug
			GetImageDim($strTCPathCur & $strTCFileCur)
		Case $contextPicPicQuickviewHQ
			If $booQuickviewHQ = True Then
				$booQuickviewHQ = False
			Else
				$booQuickview = True
				$booQuickviewThumb = False
				$booQuickviewHQ = True
			EndIf
			WriteLog("SetQuickviewMode", "QuickviewHQ") ;debug
			GetImageDim($strTCPathCur & $strTCFileCur)
		Case $contextPicPicQuickviewGamma
			If $booQuickviewColor = True Then
				$booQuickviewColor = False
				GUICtrlSetState($contextPicPicQuickviewGamma, $GUI_UNCHECKED)
			Else
				$booQuickviewColor = True
				GUICtrlSetState($contextPicPicQuickviewGamma, $GUI_CHECKED)
			EndIf
	EndSwitch
	$booRefreshQuickviewImage = True ;Test
EndFunc ;Func SetQuickviewMode()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetOptTagOnEvent()
	Switch @GUI_CtrlId
		Case $contextLvwTagsTagGrpTyp
			$strOptTagGrp = "Typ"
		Case $contextLvwTagsTagGrpLoc
			$strOptTagGrp = "Loc"
		Case $contextLvwTagsTagGrpCat
			$strOptTagGrp = "Cat"
		Case $contextLvwTagsTagNamName
			$strOptTagNam = "Name"
		Case $contextLvwTagsTagNamDesc
			$strOptTagNam = "Desc"
		Case $contextLvwTagsTagValLit
			$strOptTagVal = "Lit"
		Case $contextLvwTagsTagValNum
			$strOptTagVal = "Num"
		Case $contextLvwTagsSetDefOpts
			$strOptTagGrp = $strOptTagGrpDef
			$strOptTagNam = $strOptTagNamDef
			$strOptTagVal = $strOptTagValDef
			GUICtrlSetState($contextLvwTagsTagGrpTyp, $GUI_CHECKED)
			GUICtrlSetState($contextLvwTagsTagGrpLoc, $GUI_UNCHECKED)
			GUICtrlSetState($contextLvwTagsTagGrpCat, $GUI_UNCHECKED)
			GUICtrlSetState($contextLvwTagsTagNamName, $GUI_CHECKED)
			GUICtrlSetState($contextLvwTagsTagNamDesc, $GUI_UNCHECKED)
			GUICtrlSetState($contextLvwTagsTagValLit, $GUI_CHECKED)
			GUICtrlSetState($contextLvwTagsTagValNum, $GUI_UNCHECKED)
	EndSwitch
;~ 	WriteLog("SetOptTagOnEvent", $arrLocStr[31] & " (" & $strOptTagGrp & ") - ID (Hex) - " & $arrLocStr[36] & " (" & $strOptTagNam & ") - " & $arrLocStr[39] & " (" & $strOptTagVal & ")") ;debug
	_GUICtrlListView_SetColumn($hlvwTags, 0, $arrLocStr[31] & " (" & $strOptTagGrp & ")", $intLvwTagsColWidthTag[0])
	_GUICtrlListView_SetColumn($hlvwTags, 1, "ID (Hex)", $intLvwTagsColWidthTag[1])
	_GUICtrlListView_SetColumn($hlvwTags, 2, $arrLocStr[36] & " (" & $strOptTagNam & ")", $intLvwTagsColWidthTag[2], $intLvwTagsColAlignTagNam)
	_GUICtrlListView_SetColumn($hlvwTags, 3, $arrLocStr[39] & " (" & $strOptTagVal & ")", $intLvwTagsColWidthTag[3])

	If FileIsValid($strTCPathCur & $strTCFileCur) Then
		$booRefresh = True
		$booRefreshMetadataOnly = True
	Else
		$booRefresh = False
		$booRefreshMetadataOnly = False
	EndIf
	If $intWinOnTopState = 1 Then WinActivate($whTC)

EndFunc ;Func SetOptTagOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetChrSetConversion()
	If $booAlwaysWriteUTF8 = False Then
		$booAlwaysWriteUTF8 = True
		GUICtrlSetState($contextLvwTagsConvertUTF8, $GUI_CHECKED)
	Else
		$booAlwaysWriteUTF8 = False
		GUICtrlSetState($contextLvwTagsConvertCP1252, $GUI_CHECKED)
	EndIf
	WriteLog("SetChrSetConversion", "AlwaysWriteUTF8 = " & $booAlwaysWriteUTF8) ;debug
	If $intWinOnTopState = 1 Then WinActivate($whTC)
EndFunc ;Func SetChrSetConversion()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;bookmark
Func UseSidecarFile()
	If $intUseSidecarFile = 1 Then
		$intUseSidecarFile = 0
		GUICtrlSetState($contextLvwUseSidecarFile, $GUI_UNCHECKED)
		WriteLog("UseSidecarFile", "False") ;debug
	Else
		$intUseSidecarFile = 1
		GUICtrlSetState($contextLvwUseSidecarFile, $GUI_CHECKED)
		WriteLog("UseSidecarFile", "True (*." & $strSidecarFileType & ")") ;debug
	EndIf

	If FileIsValid($strTCPathCur & $strTCFileCur) Then
		$booRefresh = True
		$booRefreshMetadataOnly = True
	Else
		$booRefresh = False
		$booRefreshMetadataOnly = False
	EndIf
	If $intWinOnTopState = 1 Then WinActivate($whTC)
EndFunc ;Func UseSidecarFile()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetAllowDuplicateTagNames()
	If $strOptDup = "-a" Then
		$strOptDup = "--a"
		GUICtrlSetState($contextLvwAllowDuplicateTagNames, $GUI_UNCHECKED)
		WriteLog("SetAllowDuplicateTagNames", "False") ;debug
	Else
		$strOptDup = "-a"
		GUICtrlSetState($contextLvwAllowDuplicateTagNames, $GUI_CHECKED)
		WriteLog("SetAllowDuplicateTagNames", "True") ;debug
	EndIf

	If FileIsValid($strTCPathCur & $strTCFileCur) Then
		$booRefresh = True
		$booRefreshMetadataOnly = True
	Else
		$booRefresh = False
		$booRefreshMetadataOnly = False
	EndIf
	If $intWinOnTopState = 1 Then WinActivate($whTC)
EndFunc ;Func SetAllowDuplicateTagNames()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetBackupState()
	If $booBackup = True Then
		$booBackup = False
		GUICtrlSetState($contextLvwTagsSetBackupState, $GUI_UNCHECKED)
	Else
		$booBackup = True
		GUICtrlSetState($contextLvwTagsSetBackupState, $GUI_CHECKED)
	EndIf
	WriteLog("SetBackupState", $booBackup) ;debug
	If $intWinOnTopState = 1 Then WinActivate($whTC)
EndFunc ;Func SetBackupState()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetLockState()
	If $booLocked = True Then
		$booLocked = False
		GUICtrlSetImage($icoLocked, $cstrIcoDir & "\NotLocked.ico", 0)
	Else
		$booLocked = True
		GUICtrlSetImage($icoLocked, $cstrIcoDir & "\Locked.ico", 0)
	EndIf
	GUICtrlSetPos($icoLocked, $intTCInactivePanelW - (16+4+13+4+13), 2, 13, 13)
	If $intWinOnTopState = 1 Then WinActivate($whTC)
EndFunc ;Func SetLockState()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func DeleteThumbnailImage()
	DeleteMetadata("ThumbnailImage")
EndFunc ;Func DeleteThumbnailImage()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SaveThumbnailImageOnEvent()
	ExtractThumbnailImage("Save")
EndFunc ;Func SaveThumbnailImageOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ViewThumbnailImageOnEvent()
	ExtractThumbnailImage("View")
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExtractThumbnailImage($strMode="View")
	;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
	;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
	;*** Dateinamen, die mit "-" beginnen, werden von ExifTool als Option behandelt.    Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
	;*** Dateinamen, die mit "#" beginnen, werden von ExifTool als Kommentar behandelt. Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
;~ 	$strExifToolParam = " -b -ThumbnailImage " & '"' & StringRegExpReplace($strTCPathCur & $strTCFileCur, "^(#|-)", ".\\\1") & '" >"' & $cstrTmpFile & "_ThumbnailImage.jpg"
	$strExifToolParam = " -b -ThumbnailImage -ID3:Picture -Vorbis:CoverArt -FLAC:Picture " & '"' & StringRegExpReplace($strTCPathCur & $strTCFileCur, "^(#|-)", ".\\\1") & '" >"' & $cstrTmpFile & "_ThumbnailImage.jpg"
	$strExifToolOut = RunExifTool("ExtractThumbImg", $strExifToolParam, 1)
	If $strMode = "Save" Then
		If $strTCPathCur = "" Then
			$strTmp = @WorkingDir
		Else
			$strTmp = $strTCPathCur
		EndIf
		$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - Save ThumbnailImage", $strTmp, "JPEG (*.jpg)", 2, StringTrimRight($strTCFileCurOri, StringLen($strTCExtCur)+1) & "_ThumbnailImage.jpg")
		If @error = 0 Then FileMove($cstrTmpFile & "_ThumbnailImage.jpg", $strFileNameTarget, 1)
	EndIf
	If $strMode = "View" Then ViewImage($cstrTmpFile & "_ThumbnailImage.jpg")
EndFunc ;Func ViewThumbnailImageOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func DeletePreviewImage()
	DeleteMetadata("PreviewImage")
EndFunc ;Func DeletePreviewImage()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SavePreviewImageOnEvent()
	ExtractPreviewImage("Save")
EndFunc ;Func SavePreviewImageOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ViewPreviewImageOnEvent()
	ExtractPreviewImage("View")
EndFunc ;Func ViewPreviewImageOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExtractPreviewImage($strMode="View")

	;GUICtrlSetColor($lblStatus, 0x80A0FF)
	GUICtrlSetData($lblStatus, "XPrev")

	;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
	;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
	$strExifToolParam = " -b -PreviewImage " & '"' & $strTCPathCur & $strTCFileCur & '" >"' & $cstrTmpFile & "_PreviewImage.jpg"
	$strExifToolOut = RunExifTool("ExtractPrevImg", $strExifToolParam, 1)
	If @error Then
		FileCopy($cstrIcoDir & "\Blank.jpg", $cstrTmpFile & "_PreviewImage.jpg", 1) ;ToDo: Bessere Alternative?
	Else
		If $strMode = "Save" Then
			If $strTCPathCur = "" Then
				$strTmp = @WorkingDir
			Else
				$strTmp = $strTCPathCur
			EndIf
			$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - PreviewImage", $strTmp, "JPEG (*.jpg)", 2, StringTrimRight($strTCFileCurOri, StringLen($strTCExtCur)+1) & "_PreviewImage.jpg")
			If @error = 0 Then FileMove($cstrTmpFile & "_PreviewImage.jpg", $strFileNameTarget, 1)
		EndIf

		If $strMode = "View" Then
			If $strExifToolErr = "" Then
				ViewImage($cstrTmpFile & "_PreviewImage.jpg")
			Else
				MsgBox(48+262144, $cstrTCMetadataViewerVersion, $strExifToolErr)
			EndIf
		EndIf
	EndIf

EndFunc ;Func ExtractPreviewImage($strMode="View")

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ImageTitleOnEvent()
	GUICtrlSetData($lblEditTagGrpNam, $strTagImageTitle)
	GUICtrlSetData($txtEditTagVal, GUICtrlRead($txtImageTitle))
	GUICtrlSetState($radioEditTagChg, $GUI_CHECKED)
	GUICtrlSetState($chkEditSaveAll, $GUI_UNCHECKED)
	SaveEditTag()
EndFunc ;Func ImageTitleOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ViewImageOnEvent()
	ViewImage()
EndFunc ;Func ViewImageOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ViewImage($strImageFilePath="")

	;*** Wenn kein Vorschaubild (bzw. <NoQuickviewAvailable.jpg>) angezeigt wird *oder* RegionRectangle exists+visible, dann Aufruf des externen Bildbetrachters verhindern
	;*** Ausnahme: Button/Kontextmen "View Thumbnail-Image" oder "View Preview-Image" wurde gedrckt
;~ 	If Not (@GUI_CtrlId = $btnViewThumbnailImage Or @GUI_CtrlId = $btnViewPreviewImage Or @GUI_CtrlId = $contextPicPicViewThumbnailImage Or @GUI_CtrlId = $contextPicPicViewPreviewImage) Then
	If @GUI_CtrlId = $picPic Or @GUI_CtrlId = $contextPicPicView Then
;~ 		If GUICtrlRead($lblScale) = "" Or (BitAnd(WinGetState($frmRectangle), 1) And BitAnd(WinGetState($frmRectangle), 2)) Then Return
		If $strImageConvertMode = "NOP" Or (BitAnd(WinGetState($frmRectangle), 1) And BitAnd(WinGetState($frmRectangle), 2)) Then Return
	EndIf

	If $strImageViewerPath <> "" Then
		If Not FileExists($strImageViewerPath) Then
			$strErrMsg = StringReplace($arrLocStr[1], "%p", $strImageViewerPath)
			$strErrMsg = StringReplace($strErrMsg, "%n", $arrLocStr[2])
			$strImageViewerPath = ""
			WriteLog("ViewImage", StringReplace($strErrMsg, @LF, " | "))
			MsgBox(64+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
		EndIf
	EndIf

	If $strImageFilePath = "" Then $strImageFilePath = $strTCPathCur & $strTCFileCur
	SetWinOnTopState(0)
	$strWinTitle = ""
	If $strImageFilePath = $cstrTmpFile & "_ThumbnailImage.jpg" Then $strWinTitle = "ThumbnailImage"
	If $strImageViewerPath = "" Then
		WriteLog("ViewImage", "ShellExecuteWait(" & '"' & $strImageFilePath & '", "", "", "open")')
		ShellExecuteWait('"' & $strImageFilePath & '"', "", "", "open")
	Else
		WriteLog("ViewImage", 'ShellExecute(' & $strImageViewerPath & ', "' & $strImageFilePath & '"' & ', Default, "open", @SW_MAXIMIZE)')
		ShellExecute($strImageViewerPath, '"' & $strImageFilePath & '"', Default, "open", @SW_MAXIMIZE)
	EndIf
	SetWinOnTopState($intWinOnTopStateUser)
	WinActivate($whTC)
EndFunc ;Func ViewImage($strImageFilePath="")

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func Magnify()

	;*** Wenn kein Vorschaubild (bzw. <NoQuickviewAvailable.jpg>) angezeigt wird, keine Ausschnittsvergrerung mglich
	If GUICtrlRead($lblScale) = "" Then Return

	If $booMagnify = True Then
		$booMagnify = False
		GUICtrlSetColor($lblScale, 0x4D6185)
		If $strImageConvertMode = "RAW" Then
			GetImageDim($cstrTmpFile & "_PreviewImage.jpg")
		Else
			GetImageDim($strTCPathCur & $strTCFileCur)
		EndIf

		$booRefreshQuickviewImage = True
		Return
	EndIf

	;*** $frmRectangle exists+visible
	If BitAnd(WinGetState($frmRectangle), 1) And BitAnd(WinGetState($frmRectangle), 2) Then
		$arrRectangleWinPos = WinGetPos($frmRectangle) ;[0]=x, [1]=y, [2]=B, [3]=H
		$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
		$b = ($arrRectangleWinPos[2]-$arrRectangleClientPos[0])/2
		$x = $arrRectangleWinPos[0] - $intTCInactivePanelX - Int(($intPicW - $intImgPreW) / 2) + $b
		$y = $arrRectangleWinPos[1] - $intTCInactivePanelY - 1 + ($arrRectangleWinPos[3]-$arrRectangleClientPos[1]) - $b
		$y = $y - Int(($intPicH - $intImgPreH) / 2) ;*** vertikale Zentrierung = Verschiebung des Quickview-Images bercksichtigen
		$y = $y - $intShowImageTitle*20 ;*** Verschiebung um die Hhe des ImageTitles (20px) bercksichtigen
		$w = $arrRectangleClientPos[0]
		$h = $arrRectangleClientPos[1]

	;*** $lblRegionRectangle visible
	ElseIf BitAnd(GUICtrlGetState($lblRegionRectangle), $GUI_SHOW) Then
		$arrRectangleWinPos = ControlGetPos($frmMain, "", $lblRegionRectangle) ;[0]=x, [1]=y, [2]=B, [3]=H
		$b = 2
		$x = $arrRectangleWinPos[0] - Int(($intPicW - $intImgPreW) / 2) + $b
		$y = $arrRectangleWinPos[1] + $b/2
		$y = $y - Int(($intPicH - $intImgPreH) / 2) ;*** vertikale Zentrierung = Verschiebung des Quickview-Images bercksichtigen
		$y = $y - $intShowImageTitle*20 ;*** Verschiebung um die Hhe des ImageTitles (20px) bercksichtigen
		$w = $arrRectangleWinPos[2] - 2*$b
		$h = $arrRectangleWinPos[3] - 2*$b
		GUICtrlSetState($lblRegionRectangle, $GUI_HIDE)

	Else
		$arrRegionRectangle = StringSplit("0.400000, 0.400000, 0.200000, " & Round((0.200000 * $intImgPreW) / $intImgPreH, 6), ", ", 1)
		WinSetTitle($frmRectangle, "", "Magnify")

;~ 		$x = Round($intImgPreW*$arrRegionRectangle[1])
;~ 		$y = Round($intImgPreH*$arrRegionRectangle[2])
;~ 		$w = Round($intImgPreW*$arrRegionRectangle[3])
;~ 		$h = Round($intImgPreH*$arrRegionRectangle[4])

		$x = $intTCInactivePanelX + Int(($intPicW - $intImgPreW) / 2) + Round($intImgPreW*$arrRegionRectangle[1])
		$y = $intTCInactivePanelY + 1 + Round($intImgPreH*$arrRegionRectangle[2])
		$w = Round($intImgPreW*$arrRegionRectangle[3])
		$h = Round($intImgPreH*$arrRegionRectangle[4])
		WinMove($frmRectangle, "", $x, $y, $w, $h)

		$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
		$b = ($w-$arrRectangleClientPos[0])/2
		$x = $x-$b
		$y = $y-($h-$arrRectangleClientPos[1])+$b
		$w = $w+2*$b
		$h = $h+($h-$arrRectangleClientPos[1])
		WinMove($frmRectangle, "", $x, $y, $w, $h)

		#cs
		$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
		GUICtrlSetPos($picTransparent, 0, 0, $arrRectangleClientPos[0], $arrRectangleClientPos[1])
		#ce

		GUICtrlSetState($lblRegionRectangle, $GUI_HIDE)
		GUISetState(@SW_SHOW, $frmRectangle)
;~ 		GUICtrlSetColor($lblScale, 0xFFFFFF) ;Test ;0x99CC00 = gelbgrn
		Return

	EndIf

	If $x+$w < 1 Or $x > $intImgPreW Or $y+$h < 1 Or $y > $intImgPreH Then
		MsgBox(0+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[143]) ;Region is completely arranged outside the image!
		Return
	EndIf

	If $x < 1 Then
		$w = $w + $x
		$x = 1
	EndIf
	If $y < 1 Then
		$h = $h + $y
		$y = 1
	EndIf
	If $x + $w > $intImgPreW Then $w = $intImgPreW - $x
	If $y + $h > $intImgPreH Then $h = $intImgPreH - $y

	$x = Round($x * $intImgW / $intImgPreW)
	$y = Round($y * $intImgH / $intImgPreH)
	$w = Round($w * $intImgW / $intImgPreW)
	$h = Round($h * $intImgH / $intImgPreH)

	$xcrop = $x
	$ycrop = $y
	$wcrop = $w
	$hcrop = $h

	If WinGetTitle($frmRectangle) = "Magnify" Then GUISetState(@SW_HIDE, $frmRectangle)

	If $strImageConverter = "IrfanView" Then
		If $strImageConvertMode = "RAW" Then
			$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
		Else
			$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strTCPathCur & $strTCFileCur & '"'
		EndIf
		$strIrfanViewCmd &= ' /crop=(' & $x & ',' & $y & ',' & $w & ',' & $h & ') /bpp=24'
		$strIrfanViewCmd &= ' /convert="' & $cstrTmpFile & '_Crop.bmp" /silent'
		WriteLog("Crop", $strIrfanViewCmd)
		$strErrMsg = RunWait($strIrfanViewCmd, @WorkingDir)

		If $strErrMsg*1 > 0 Then ;*** IrfanView hat eine Fehlermeldung ausgegeben
			$strErrMsg = $strImageConverter & ": load/save error (exitcode = " & $strErrMsg & ")"
			WriteLog("Crop", $strErrMsg)
		EndIf
	EndIf

	If $strImageConverter = "NConvert" Then
;~ 		;*** -overwrite mit lteren NConvert-Versionen fhrt zu "Bad argument"-Fehler. Daher Vorschaubild einfach vorher lschen
;~ 		If FileExists($cstrTmpFile & "_Crop.bmp") Then
;~ 			FileDelete($cstrTmpFile & "_Crop.bmp")
;~ 			WriteLog("DelTempFiles", $cstrTmpFile & "_Crop.bmp")
;~ 		EndIf

		$strNConvertCmd = '"' & $strImageConverterPath & '" -o "' & $cstrTmpFile & '_Crop.bmp"'
		If $strImageConverterVersion >= 5.60 Then $strNConvertCmd &= ' -overwrite'
		$strNConvertCmd &= " -quiet -out bmp -truecolors"
		$strNConvertCmd &= ' -crop ' & $x & ' ' & $y & ' ' & $w & ' ' & $h
		$strNConvertCmd &= ' "' & $strTCPathCur & $strTCFileCur & '"'
		If $strImageConvertMode = "RAW" Then
			$strNConvertCmd &= ' "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
		Else
			$strNConvertCmd &= ' "' & $strTCPathCur & $strTCFileCur & '"'
		EndIf

		WriteLog("Crop", $strNConvertCmd)
		$strStdOut = ""
		$strStdErr = ""
		$pidNConvert = Run(@ComSpec & ' /S /c "' & $strNConvertCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
		While 1
			$strStdOut &= StdoutRead($pidNConvert)
			If @error Then ExitLoop
		Wend
		While 1
			$strStdErr &= StderrRead($pidNConvert)
			If @error Then ExitLoop
		Wend
		ProcessWaitClose($pidNConvert)

		If $strStdErr <> "" Then ;*** NConvert hat eine Fehlermeldung ausgegeben
			$strErrMsg = $strImageConverter & ": " & StringStripWS($strStdErr, 1+2)
			WriteLog("Crop", $strErrMsg)
		EndIf
	EndIf

	If $strImageConverter = "ImageMagick" Then
		If FileExists($cstrTmpFile & "_Crop.bmp") Then
			FileDelete($cstrTmpFile & "_Crop.bmp")
			WriteLog("DelTempFiles", $cstrTmpFile & "_Crop.bmp")
		EndIf

		If $strImageConvertMode = "RAW" Then
			$strImageMagickCmd = '"' & $strImageConverterPath & '" "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
		Else
			;*** "[0]" bezeichnet den ersten Frame / die erste Page in Multi-Image-Dateien (z.B. gif, tif)
			$strImageMagickCmd = '"' & $strImageConverterPath & '" "' & $strTCPathCur & $strTCFileCur & '[0]"'
		EndIf
		$strImageMagickCmd &= " -auto-orient -type TrueColor"
;~ 		$strImageMagickCmd &= " -filter Lanczos -crop " & $w & "x" & $h & "!+" & $x & "+" & $y & "! -sharpen 2" ;-sharpen 2 fhrt zur berschrfung
		$strImageMagickCmd &= " -filter Lanczos -crop " & $w & "x" & $h & "!+" & $x & "+" & $y & "!"
		$strImageMagickCmd &= ' "' & $cstrTmpFile & '_crop.bmp"'

		$strStdOut = ""
		$strStdErr = ""
		WriteLog("Crop", $strImageMagickCmd)
		$pidImageMagick = Run(@ComSpec & ' /S /c "' & $strImageMagickCmd & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
		While 1
			$strStdOut &= StdoutRead($pidImageMagick)
			If @error Then ExitLoop
		Wend
		While 1
			$strStdErr &= StderrRead($pidImageMagick)
			If @error Then ExitLoop
		Wend
		ProcessWaitClose($pidImageMagick)

		If $strStdErr <> "" Then ;*** ImageMagick hat eine Fehlermeldung ausgegeben
			$strErrMsg = $strImageConverter & ": " & StringStripWS($strStdErr, 1+2)
			WriteLog("Crop", $strErrMsg)
		EndIf

	EndIf

	$booMagnify = True
	GetImageDim($cstrTmpFile & "_Crop.bmp")
	GUICtrlSetColor($lblScale, 0xE13131)
	$booRefreshQuickviewImage = True

EndFunc ;Func Magnify()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func PlaySound()
	;GUICtrlSetColor($lblStatus, 0x80A0FF)
	GUICtrlSetData($lblStatus, "Audio")

	$strSoundFilePath = StringLeft($strTCPathCur & $strTCFileCur, StringInStr($strTCPathCur & $strTCFileCur, ".", 0, -1)) & "wav"
	SoundPlay($strSoundFilePath, 1)

	;GUICtrlSetColor($lblStatus, 0x008000)
	GUICtrlSetData($lblStatus, $arrLocStr[63])
EndFunc ;Func PlaySound()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ShowGPSPos()
	;*** GPSPosition wird numerisch bentigt (zumindest fr Aufruf Bing Maps)
	If $strOptTagNam = "Name" And $strOptTagVal = "Lit" And Not ($intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType)) Then

		$strExifToolParam = "-Composite:GPSPosition#" & @CRLF & "-s3" & @CRLF
		$strGPSPosition = FeedExifTool("GetGPSPos", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
		If @error Then Return
		$strGPSPosition = StringStripWS($strGPSPosition, 1+2+4)

		;$strExifToolParam = "-EXIF:GPSImgDirection#" & @CRLF & "-s3" & @CRLF
		;$strGPSDirection = FeedExifTool("GetGPSDir", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
		;If @error Then Return
		;$strGPSDirection = StringStripWS($strGPSDirection, 1+2+4)

	EndIf

	;*** Google Maps
	If $strGeoService = "GoogleMaps" Then
;~ 		ShellExecute("http://maps.google.de/maps?&q=" & $strGPSPosition & "+(" & $strGPSPosition & ")&z=18&t=h")
		ShellExecute("http://maps.google.de/maps?q=" & StringReplace($strGPSPosition, " ", ",") & "&z=18&t=h")
	EndIf

	;*** Bing Maps
	If $strGeoService = "BingMaps" Then
		;*** style: a: aerial view of the map / r: road view of the map / h: aerial view of the map with labels / o: Use this value to display a bird's eye (oblique) view of the map / b: Display a bird's eye (oblique) with labels view of the map / u: Automatic
		;*** lvl: Defines the zoom level of the map view in 2D mode. Valid values are 1-19; for oblique, 1-2. This parameter is ignored if you don't include the cp parameter
		;*** sp: Defines a specific entity, address, or pin to add to the collections editor: sp=point.latitude_longitude_title_notes_linkURL_photoURL (each separated by an underscore (_))
		;If $strGPSDirection = "" Then
			ShellExecute("http://bing.com/maps/default.aspx?v=2&cp=" & StringReplace($strGPSPosition, " ", "~") & "&style=a&lvl=17&sp=point." & StringReplace($strGPSPosition, " ", "_") & "____")
		;Else
		;	ShellExecute("http://bing.com/maps/default.aspx?v=2&cp=" & StringReplace($strGPSPosition, " ", "~") & "&style=a&lvl=17&dir=" & $strGPSDirection & "&sp=point." & StringReplace($strGPSPosition, " ", "_") & "____")
		;EndIf
	EndIf

EndFunc ;Func ShowGPSPos()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportRegions()

	;*** Todo: Verarbeitung von Unicode-Dateinamen ermglichen (z.Z. gibt's 'ne Fehlermeldung im Log: "GetImageDim FeedExifTool: Err: No file specified")
	;*** Todo: Verarbeitung von Sidecar-Files ermglichen

	$strClipSave = ClipGet() ;*** Clipboard-Inhalt sichern
	ClipPut("") ;*** Clipboard leeren (um nach cm_CopyFullNamesToClip feststellen zu knnen, ob TC "Keine Dateien gewhlt!" meldet)
	DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2018, "int", 0) ;*** cm_CopyFullNamesToClip=2018;Copy names with full path
	Sleep(200)
	$strClipCur = ClipGet()
	Sleep(200)
	ClipPut($strClipSave) ;*** Clipboard-Inhalt wiederherstellen

	;*** Wenn die *fokussierte* Datei *nicht markiert* ist, diese ebenfalls in die Dateiliste mit aufnehmen
	If $strTCPathCur = "" Then
		$strTCFilepathCur = @WorkingDir & "\" & $strTCFileCur
	Else
		$strTCFilepathCur = $strTCPathCur & $strTCFileCur
	EndIf
	;*** $strClipCur enthlt die originalen Unicode-Dateinamen, daher muss in $strClipCur auch mit dem Originalnamen der fokussierten Datei gesucht werden
	If StringInStr($strClipCur, $strTCPathCurOri & $strTCFileCurOri) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur

	;*** Eintrge der Dateiliste aus Clipboard in Feld $arrTCFileSel einlesen
	$arrTCFileSel = StringSplit($strClipCur, @CRLF, 1)

	$intNumRegionsExportedOK = 0
	For $i = 1 To $arrTCFileSel[0]
		$booFileIsSavable = True
		$p = StringInStr($arrTCFileSel[$i], "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
		$strTCPathSel = StringLeft($arrTCFileSel[$i], $p-1)
		$strTCFileSel = StringMid($arrTCFileSel[$i], $p+1)
		$p = StringInStr($strTCFileSel, ".", 0, -1)
		If $p > 0 Then
			$strTCStemSel = StringLeft($strTCFileSel, $p-1)
			$strTCExtSel = StringMid($strTCFileSel, $p+1)
		Else
			$strTCStemSel = $strTCFileSel
			$strTCExtSel = ""
		EndIf
		$strErrMsg = ""

		WriteLog("{ ExportRegions - Begin", $strTCFileSel) ;debug

		;*** Prfen, ob die markierte Datei existiert
		;    => Irrelevant, falls Navigation innerhalb eines Archivs, da durch FileIsValid() gar keine Tags angezeigt werden (sondern "Ignoriert")

		;*** Prfen, ob der markierte Eintrag Unicode-Zeichen enthlt und ein Backup angelegt werden soll
		;    => Prfung in dieser Function irrelevant

		;*** Prfen, ob die Dateinamenserweiterung der *markierten* Datei der der *fokussierten* Datei entspricht
		;    => Prfung irrelevant, da nicht alle Dateinamen gleichzeitig bergeben werden, sondern eine Datei nach der anderen verarbeitet wird

		;*** Prfen, ob es sich um ein Image im RAW-Format handelt.
		;*** Um RAWs zu verarbeiten, msste jeweils zunchst das PrevieImage extrahiert und dieses dann "geCROPt" werden. Dies ist hier aber nicht implementiert.
		If StringInStr("|" & IniRead($cstrIniFile, "Configuration", "ImageConvertFileExtsRAW", "") & "|", $strTCExtSel) > 0 Then
			$booFileIsSavable = False
;~ 			$strErrMsg = "Raw>" & @TAB
		EndIf

		;*** Prfen, ob es sich um ein PJG-File handelt.
		;*** Um PJGs zu verarbeiten, msste jeweils zunchst das PJG entpackt und aus dem entpackten JPG dann "geCROPt" werden. Dies ist hier aber nicht implementiert.
		;If $strTCExtSel = "pjg" Then $booFileIsSavable = False

		;*** Prfen, ob der markierte Eintrag ein Verzeichnis ist
		If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "D") > 0 Then
			$booFileIsSavable = False
;~ 			$strErrMsg = "Dir>" & @TAB
		EndIf

		;*** Prfen, ob der markierte Eintrag schreibgeschtzt ("R"), versteckt ("H") oder eines Systemdatei ("S") ist
		;    => Prfung in dieser Function irrelevant

		;*** ExportRegions nur fr Dateitypen durchfhren, in die XMP-Infos eingebettet werden knnen
		If IniRead($cstrIniFile, "FileExtensionsXMPTags", $strTCExtSel, "0") = "0" Then
			$booFileIsSavable = False
;~ 			$strErrMsg = "FiletypeDoesNotSupportXMP>" & @TAB
		EndIf


		If $booFileIsSavable = True Then

			If $strTCPathSel = @WorkingDir Then
				If $strTCFileSel <> BinaryToString($strTCFileSel) Then
					$strExifToolFiles = FileGetShortName($strTCFileSel)
				Else
					$strExifToolFiles = $strTCFileSel
				EndIf
			Else
				If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) Then
					$strExifToolFiles = FileGetShortName($arrTCFileSel[$i])
				Else
					$strExifToolFiles = $arrTCFileSel[$i]
				EndIf
			EndIf

			GetImageDim($strExifToolFiles)

			;*** Region Info MP                  : {Regions=[{PersonDisplayName=John Doe,Rectangle=0.278639|, 0.255615|, 0.087938|, 0.117251},{PersonDisplayName=,Rectangle=},]}
			$strExifToolParam = "-struct" & @CRLF & "-XMP:RegionInfoMP" & @CRLF
			$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strExifToolFiles, 1, "Def")
			If @error Then ContinueLoop

			$arrRegExpResult = StringRegExp($strExifToolOut, '\{PersonDisplayName=(.+?)(,Rectangle=(.+?)){0,1}(\})', 3) ;[1]=PersonDisplayName; [3]=Rectangle
			For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
				$strPersonName = BinaryToString($arrRegExpResult[$intRegExpResultIdx*4+0], 4)
				$arrRegionRectangle = StringSplit($arrRegExpResult[$intRegExpResultIdx*4+2], "|, ", 1)
				If $arrRegionRectangle[0] <> 4 Then ContinueLoop

				$x = Round($intImgW*$arrRegionRectangle[1])
				$y = Round($intImgH*$arrRegionRectangle[2])
				$w = Round($intImgW*$arrRegionRectangle[3])
				$h = Round($intImgH*$arrRegionRectangle[4])

				$strPersonName = StringRegExpReplace($strPersonName, '[/\\:*?"<>|]', '_')
				$strFilenameCrop = $strTCPathSel & "\" & $strTCStemSel & " [" & $strPersonName & "].jpg"
				If $strImageConverter = "IrfanView" Then
					$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strExifToolFiles & '"'
					$strIrfanViewCmd &= ' /crop=(' & $x & ',' & $y & ',' & $w & ',' & $h & ') /bpp=24'
					$strIrfanViewCmd &= ' /convert="' & $cstrTmpFile & '_Crop.jpg' & '" /silent'

					WriteLog("Crop", $strIrfanViewCmd)
					$strErrMsg = RunWait($strIrfanViewCmd, @WorkingDir)

					If $strErrMsg*1 > 0 Then ;*** IrfanView hat eine Fehlermeldung ausgegeben
						$strErrMsg = $strImageConverter & ": load/save error (exitcode = " & $strErrMsg & ")"
						WriteLog("Crop", $strErrMsg)
					Else
						$intNumRegionsExportedOK += 1
					EndIf
				EndIf

				;*** Metadaten - auer ThumbnailImage - aus dem Region-Extrakt lschen
				$strExifToolParam = "-P" & @CRLF
				$strExifToolParam &= "-overwrite_original_in_place" & @CRLF
				$strExifToolParam &= "-all=" & @CRLF
				$strExifToolParam &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-ThumbnailImage" & @CRLF
				$strExifToolOut = FeedExifTool("DeleteMetadata", $strExifToolParam, $cstrTmpFile & "_Crop.jpg", 1, "Def")

				;*** Temporres Crop-Image verschieben+umbenennen
				FileMove($cstrTmpFile & '_Crop.jpg', $strFilenameCrop, 0)

			Next
			WriteLog("ExportRegions", $strTCFileSel & ": " & UBound($arrRegExpResult) / 4 & " regions read")

		EndIf
		WriteLog("} ExportRegions - End", $strTCFileSel) ;debug

	Next

	MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & "ExportRegions" & @LF & "fr " & $intNumRegionsExportedOK & " Regions" & @LF & "in " & $arrTCFileSel[0] & " Dateien") ;Todo: Meldung anpassen, falls IrfanView eine Fehlermeldung ausgegeben hat. Todo: Lokalisieren

EndFunc ;Func ExportRegions()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func LosslessJPGOperation()

;~ 	If $booUnicodeFilename = True Then
	If $strImageConverter = "IrfanView" And $intImageConverterUnicodeSupport = 0 And $booUnicodeFilename = True Then
		MsgBox(64+262144, $cstrTCMetadataViewerVersion, "LosslessJPGOperation" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
		Return
	EndIf

	If $strImageConverter = "NConvert" Then

		Switch @GUI_CTRLID
			Case $contextPicPicRotate090
				$strOptions = "rot90"
				$booRefresh = True
			Case $contextPicPicRotate180
				$strOptions = "rot180"
				$booRefresh = True
			Case $contextPicPicRotate270
				$strOptions = "rot270"
				$booRefresh = True
			Case $contextPicPicRotateExif
				$strOptions = "exif"
				$booRefresh = True
			Case $contextPicPicMirrorHor
				$strOptions = "hflip"
				$booRefresh = True
			Case $contextPicPicMirrorVer
				$strOptions = "vflip"
				$booRefresh = True
			Case Else
				;NOP
		EndSwitch

		If $booBackup = True Then FileCopy($strTCPathCur & $strTCFileCur, $strTCPathCur & $strTCFileCur & "_original", 0)

		$strNConvertCmd = '"' & $strImageConverterPath & '"'
		;*** Seit v5.60 berschreibt NConvert vorhandene Files *nicht* mehr:XnView v1.97.1 (LIBFORMAT v5.60) 22/02/2010: Added -overwrite
		;*** -overwrite mit lteren NConvert-Versionen fhrt allerdings zu "Bad argument"-Fehler.
		If $strImageConverterVersion >= 5.60 Then $strNConvertCmd &= ' -overwrite'
		$strNConvertCmd &= ' -keepfiledate -jpegtrans ' & $strOptions
		If $strImageConvertMode = "RAW" Then
			$strNConvertCmd &= ' "' & $cstrTmpFile & "_PreviewImage.jpg" & '"'
		Else
			$strNConvertCmd &= ' "' & $strTCPathCur & $strTCFileCur & '"'
		EndIf
		$strErrMsg = ""
		WriteLog("LosslessJPGOperation", $strNConvertCmd)
		$pidNConvert = Run(@ComSpec & ' /S /c "' & $strNConvertCmd & '"', "", @SW_HIDE, $STDOUT_CHILD)
		While 1
			$strErrMsg &= StdoutRead($pidNConvert)
			If @error Then ExitLoop
		Wend
		ProcessWaitClose($pidNConvert)

		$booFileIsModified = True

	EndIf

	If $strImageConverter = "IrfanView" Then

		;*** Aufruf IrfanView mit "/jpg_rotate" ffnet die IrfanView-GUI und schliet diese nach Abschluss der Operation *nicht* automatisch
		;*** RunWait() wartet daher solange, bis IrfanView manuell beendet wird.
		;*** Run() statt RunWait() wrde die Kontrolle ber die IrfanView-Instanz geben (knnte scriptgesteuert geschlossen werden),
		;*** allerdings wei man nicht, wann die Operation abgschlossen ist und IrfanView geschlossen werden kann
		;*** Daher wird IrfanView mit RunWait() aufgerufen und zustzlich Parameter "/killmesoftly" bergeben, was aber *smtliche* IrfanView-Instanzen schliet.
		;*** Es muss also zunchst geprft werden, ob IrfanView bereits luft
		If WinExists("[CLASS:IrfanView]") Or WinExists("[CLASS:IrfanViewThumbnails]") Then
			$strErrMsg = StringReplace($arrLocStr[83], "%n", $strImageConverter)
			If MsgBox(4+32+256+262144, $cstrTCMetadataViewerVersion, $strErrMsg) = 7 Then Return
		EndIf

		Switch @GUI_CTRLID
			Case $contextPicPicOptimize
				$strOptions = "0,1,0,1,0,0,0,0"
				$booRefreshMetadataOnly = True
			Case $contextPicPicRotate090
				$strOptions = "3,0,0,1,0,0,0,0"
				$booRefresh = True
			Case $contextPicPicRotate180
				$strOptions = "4,0,0,1,0,0,0,0"
				$booRefresh = True
			Case $contextPicPicRotate270
				$strOptions = "5,0,0,1,0,0,0,0"
				$booRefresh = True
			Case $contextPicPicRotateExif
				$strOptions = "6,0,0,1,0,0,0,0"
				$booRefresh = True
			Case $contextPicPicMirrorHor
				$strOptions = "2,0,0,1,0,0,0,0"
				$booRefresh = True
			Case $contextPicPicMirrorVer
				$strOptions = "1,0,0,1,0,0,0,0"
				$booRefresh = True
			Case Else
				;NOP
		EndSwitch

		If $booBackup = True Then FileCopy($strTCPathCur & $strTCFileCur, $strTCPathCur & $strTCFileCur & "_original", 0)

		#cs
		Example for /jpg_rotate=(options):

		options = all 8 options from the JPG lossless dialog: transformation, optimize, EXIF date, current date, set DPI, DPI value, marker option, custom markers
		Note: this option will overwrite the original file(s)!

		Values:
		Transformation    : 0 = Keine
							1 = Vertikal spiegeln
							2 = Horizontal spiegeln
							3 = Rotation im Uhrzeigersinn 90
							4 = Rotation im Uhrzeigersinn 180
							5 = Rotation im Uhrzeigersinn 270
							6 = Auto Rotation nach EXIF-Info (wenn vorhanden)
		Optimize          : 0 or 1
		Set EXIF date     : 0 or 1
		Keep current date : 0 or 1
		Set DPI           : 0 or 1
		DPI value         : number
		Marker option     : 0 = Keep all
							1 = Clean all
							2 = Custom
		Custom markers values (can be combined (add values)):
							1 = Keep Comment
							2 = Keep EXIF
							4 = Keep IPTC
							8 = Keep others

		i_view32.exe c:\test.jpg /jpg_rotate=(6,1,1,0,1,300,0,0)
		=> Auto rotate, optimize, set EXIF date as file date, set DPI to 300, keep all markers

		i_view32.exe c:\test.jpg /jpg_rotate=(6,1,1,0,0,0,2,6)
		=> Auto rotate, optimize, set EXIF date as file date, keep EXIF and IPTC markers

		i_view32.exe c:\test.jpg /jpg_rotate=(3,1,0,1,0,0,1,0)
		=> Rotate 90, optimize, use current file date, clean all markers

		i_view32.exe c:\images\*.jpg /jpg_rotate=(6,1,1,0,0,0,0,0)
		=> For all JPGs: Auto rotate, optimize, set EXIF date as file date, keep all markers
		#ce
		$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strTCPathCur & $strTCFileCur & '"'
		$strIrfanViewCmd &= " /jpg_rotate=(" & $strOptions & ")"
		$strIrfanViewCmd &= " /silent /killmesoftly"
		WriteLog("LosslessJPGOperation", $strIrfanViewCmd)
		RunWait($strIrfanViewCmd, @WorkingDir, @SW_HIDE)
		$booFileIsModified = True

	EndIf

EndFunc ;Func LosslessJPGOperation()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetWinOnTopStateOnEvent()
	$intWinOnTopStateUser = BitXOR($intWinOnTopStateUser, 1)
	$intWinOnTopState = $intWinOnTopStateUser
	SetWinOnTopState($intWinOnTopState)
EndFunc ;Func SetWinOnTopStateOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetWinOnTopState($intWinSetOnTop)
	$intWinOnTopState = $intWinSetOnTop
	WinSetOnTop($frmMain, "", $intWinOnTopState)
	GUICtrlSetImage($icoWinOnTop, $cstrIcoDir & "\WinOnTop" & $intWinOnTopState & ".ico", 0)
	GUICtrlSetPos($icoWinOnTop, $intTCInactivePanelW - (16+4+13), 2, 13, 13)
EndFunc ;Func SetWinOnTopState($intWinSetOnTop)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ToggleMoveCursorDirection()
	$intMoveCursorDirection = BitXOR($intMoveCursorDirection, 1)
	If $intMoveCursorDirection = 1 Then
		GUICtrlSetData($lblMoveCursorDirection, "")
	Else
		GUICtrlSetData($lblMoveCursorDirection, "")
	EndIf
EndFunc ;Func ToggleMoveCursorDirection()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenShiftDateTimeDialog()
	SetWinOnTopState(0)
	GUISetState(@SW_SHOW, $frmShiftDateTime)
	GUISwitch($frmShiftDateTime)
	ControlFocus($frmShiftDateTime, "", $txtShiftDateTimeH)
EndFunc ;Func OpenShiftDateTimeDialog()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SaveShiftDateTime()

	$strExifToolFiles = ""
	$strExifToolParam = "-progress" & @CRLF ;debug
	$strExifToolParam &= "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	;bookmark
	;If $intUseSidecarFile = 1 Then
	;	$strExifToolParam &= "-srcfile" & @CRLF
	;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	;EndIf
	$strExifToolParam2 = $strExifToolParam
	If $intUpdateMetadataDate = 1 Then $strExifToolParam &= "-XMP:MetadataDate=" & @YEAR & ":" & @MON & ":" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF

	$strShiftDateTimeAmount  = GUICtrlRead($txtShiftDateTimeY)*1 & ":" &GUICtrlRead($txtShiftDateTimeM)*1 & ":" &GUICtrlRead($txtShiftDateTimeD)*1 & " "
	$strShiftDateTimeAmount &= GUICtrlRead($txtShiftDateTimeH)*1 & ":" &GUICtrlRead($txtShiftDateTimeN)*1 & ":" &GUICtrlRead($txtShiftDateTimeS)*1
	If GUICtrlRead($chkShiftDateTimeCreateDate) = $GUI_CHECKED And GUICtrlRead($chkShiftDateTimeDateTimeOriginal) = $GUI_CHECKED And GUICtrlRead($chkShiftDateTimeModifyDate) = $GUI_CHECKED Then
		$strExifToolParam &= "-AllDates" & GUICtrlRead($btnShiftDateTimeIncDec) & "=" & '"' & $strShiftDateTimeAmount & '"' & @CRLF
	Else
		If GUICtrlRead($chkShiftDateTimeCreateDate) = $GUI_CHECKED Then $strExifToolParam &= "-EXIF:CreateDate" & GUICtrlRead($btnShiftDateTimeIncDec) & "=" & '"' & $strShiftDateTimeAmount & '"' & @CRLF
		If GUICtrlRead($chkShiftDateTimeDateTimeOriginal) = $GUI_CHECKED Then $strExifToolParam &= "-EXIF:DateTimeOriginal" & GUICtrlRead($btnShiftDateTimeIncDec) & "=" & '"' & $strShiftDateTimeAmount & '"' & @CRLF
		If GUICtrlRead($chkShiftDateTimeModifyDate) = $GUI_CHECKED Then $strExifToolParam &= "-EXIF:ModifyDate" & GUICtrlRead($btnShiftDateTimeIncDec) & "=" & '"' & $strShiftDateTimeAmount & '"' & @CRLF
	EndIf
	;*** Abfrage, ob Checkbox gesetzt ist, erfolgt beim FeedExifTool()-Aufruf
	$strExifToolParam2 &= "-File:FileModifyDate" & GUICtrlRead($btnShiftDateTimeIncDec) & "=" & '"' & $strShiftDateTimeAmount & '"' & @CRLF

	$intFileIsSavableTrue = 0
	$intFileIsSavableFalse = 0
	If GUICtrlRead($chkShiftDateTimeSaveAll) = $GUI_CHECKED Then
		$strClipSave = ClipGet() ;*** Clipboard-Inhalt sichern
		ClipPut("") ;*** Clipboard leeren (um nach cm_CopyFullNamesToClip feststellen zu knnen, ob TC "Keine Dateien gewhlt!" meldet)
		DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2018, "int", 0) ;*** cm_CopyFullNamesToClip=2018;Copy names with full path
		Sleep(200)
		$strClipCur = ClipGet()
		Sleep(200)
		ClipPut($strClipSave) ;*** Clipboard-Inhalt wiederherstellen

		$strFileIsSavableTrue = ""
		$strFileIsSavableFalse = ""
;~ 		$intFileIsSavableTrue = 0
;~ 		$intFileIsSavableFalse = 0

;~ 		#cs
		;*** Wenn die *fokussierte* Datei *nicht markiert* ist, diese ebenfalls in die Dateiliste mit aufnehmen
		If $strTCPathCur = "" Then
			$strTCFilepathCur = @WorkingDir & "\" & $strTCFileCur
		Else
			$strTCFilepathCur = $strTCPathCur & $strTCFileCur
		EndIf
		;*** $strClipCur enthlt die originalen Unicode-Dateinamen, daher muss in $strClipCur auch mit dem Originalnamen der fokussierten Datei gesucht werden
;~ 		If StringInStr($strClipCur, $strTCFilepathCur) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
		If StringInStr($strClipCur, $strTCPathCurOri & $strTCFileCurOri) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
;~ 		#ce

		;*** Eintrge der Dateiliste aus Clipboard in Feld $arrTCFileSel einlesen
		$arrTCFileSel = StringSplit($strClipCur, @CRLF, 1)

		For $i = 1 To $arrTCFileSel[0]
			GUICtrlSetData($lblEditSaveCur, "Checking file " & $i & "/" & $arrTCFileSel[0] & "...")

			$booFileIsSavable = True
			$p = StringInStr($arrTCFileSel[$i], "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
			$strTCPathSel = StringLeft($arrTCFileSel[$i], $p-1)
			$strTCFileSel = StringMid($arrTCFileSel[$i], $p+1)
			$strErrMsg = ""

			;*** Prfen, ob die markierte Datei existiert => Irrelevant, falls Navigation innerhalb eines Archivs, da durch FileIsValid() gar keine Tags angezeigt werden (sondern "Ignoriert")
			;If Not FileExists($arrTCFileSel[$i]) Then [...]

			;*** Prfen, ob der markierte Eintrag Unicode-Zeichen enthlt und ein Backup angelegt werden soll
			If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) And $booBackup = True Then
				$booFileIsSavable = False
				$strErrMsg = "Uni>" & @TAB
			EndIf

			;*** Prfen, ob die Dateinamenserweiterung der *markierten* Datei der der *fokussierten* Datei entspricht
			$p = StringInStr($arrTCFileSel[$i], ".", 0, -1)
			If $p > 0 Then
				$strTCExtSel = StringMid($arrTCFileSel[$i], $p+1)
				If $strTCExtSel <> $strTCExtCur Then
					$booFileIsSavable = False
					$strErrMsg = "Ext>" & @TAB
				EndIf
			EndIf

			;*** Prfen, ob der markierte Eintrag ein Verzeichnis ist
			If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "D") > 0 Then
				$booFileIsSavable = False
				$strErrMsg = "Dir>" & @TAB
			EndIf

			;*** Prfen, ob der markierte Eintrag schreibgeschtzt ("R"), versteckt ("H") oder eines Systemdatei ("S") ist
			If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "R") > 0 Or StringInStr(FileGetAttrib($arrTCFileSel[$i]), "S") > 0 Or StringInStr(FileGetAttrib($arrTCFileSel[$i]), "H") > 0 Then
				$booFileIsSavable = False
				$strErrMsg = "RHS>" & @TAB
			EndIf

			;*** Speichern in PJG-Files ist nur fr *fokussierte* Datei mglich => Irrelevant, da im Falle PJG das temporre JPG bearbeitet  wird
			;If $strTCExtSel = "pjg" Then $booFileIsSavable = False

			If $booFileIsSavable = True Then
				$intFileIsSavableTrue += 1
				If $strTCPathSel = @WorkingDir Then
					If $strTCFileSel <> BinaryToString($strTCFileSel) Then
						$strExifToolFiles &= FileGetShortName($strTCFileSel) & @CRLF
					Else
						$strExifToolFiles &= $strTCFileSel & @CRLF
					EndIf
					If $intFileIsSavableTrue < 6 Then $strFileIsSavableTrue &= "     " & $strTCFileSel & @LF
				Else
					If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) Then
						$strExifToolFiles &= FileGetShortName($arrTCFileSel[$i]) & @CRLF
					Else
						$strExifToolFiles &= $arrTCFileSel[$i] & @CRLF
					EndIf
					If $intFileIsSavableTrue < 6 Then $strFileIsSavableTrue &= "     " & $arrTCFileSel[$i] & @LF
				EndIf
				If $intFileIsSavableTrue = 6 Then $strFileIsSavableTrue &= "     " & "..." & @LF
			Else
				$intFileIsSavableFalse += 1
				If $intFileIsSavableFalse < 11 Then $strFileIsSavableFalse &= "     " & $strErrMsg & $arrTCFileSel[$i] & @LF
				If $intFileIsSavableFalse = 11 Then $strFileIsSavableFalse &= "     " & "..." & @LF
				$arrTCFileSel[$i] = "" ;*** Nicht speicherbare Files aus Liste entfernen, damit weiter unten im Falle $intUseSidecarFile = 1 nur fr gltige Files SidecarFiles angelegt werden
			EndIf

		Next

		$strErrMsg = "Date/Time Shift"
		$strErrMsg &= @LF & $arrLocStr[95] & " " & @WorkingDir & @LF & @LF
		If $intFileIsSavableTrue > 0 Then
			$strErrMsg &= $arrLocStr[99]
			$strErrMsg  = StringReplace($strErrMsg, "%ok", $intFileIsSavableTrue) & @LF & @LF
			$strErrMsg &= $strFileIsSavableTrue & @LF
		EndIf
		If $intFileIsSavableFalse > 0 Then
			$strErrMsg &= $arrLocStr[96]
			$strErrMsg  = StringReplace($strErrMsg, "%nok", $intFileIsSavableFalse) & @LF & @LF
			$strErrMsg &= $strFileIsSavableFalse & @LF
		EndIf
		If $intFileIsSavableTrue > 0 Then
			$strErrMsg &= $arrLocStr[94]
			$strErrMsg  = StringReplace($strErrMsg, "%ok" , $intFileIsSavableTrue)
			$strErrMsg  = StringReplace($strErrMsg, "%sel", $intFileIsSavableTrue+$intFileIsSavableFalse)
			If MsgBox(4+32+262144, $cstrTCMetadataViewerVersion, $strErrMsg) = 7 Then Return
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
			Return
		EndIf

		;bookmark
		For $i = 1 To $arrTCFileSel[0]
			If $arrTCFileSel[$i] <> "" And $intUseSidecarFile = 1 And Not FileExists(StringLeft($arrTCFileSel[$i], StringInStr($arrTCFileSel[$i], ".", 0, -1)) & $strSidecarFileType) Then
				$p = StringInStr($arrTCFileSel[$i], "\", 0, -1)
				ExportTagsToMIE(StringLeft($arrTCFileSel[$i], $p), StringMid($arrTCFileSel[$i], $p+1), $strSidecarFileType, "EXIF:*Date*", False)
			EndIf
		Next

	Else
		If $booUnicodeFilename = True And $booBackup = True Then
			MsgBox(64+262144, $cstrTCMetadataViewerVersion, "ShiftDateTime" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
			SetWinOnTopState($intWinOnTopStateUser)
			_Exit()
			Return
		EndIf

		$strExifToolFiles = $strTCPathCur & $strTCFileCur & @CRLF
		If $intUseSidecarFile = 1 And Not FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			ExportTagsToMIE($strTCPathCurOri, $strTCFileCurOri, $strSidecarFileType, "EXIF:*Date*", False)
		EndIf

	EndIf

	;*** nderung fr EXIF:CreateDate, EXIF:DateTimeOriginal und EXIF:ModifyDate durchfhren
	If GUICtrlRead($chkShiftDateTimeCreateDate) = $GUI_CHECKED Or GUICtrlRead($chkShiftDateTimeDateTimeOriginal) = $GUI_CHECKED Or GUICtrlRead($chkShiftDateTimeModifyDate) = $GUI_CHECKED Then
		$strExifToolOut = FeedExifTool("ShiftDateTime", $strExifToolParam, $strExifToolFiles, 1, "Def")
	EndIf
	;*** nderung fr File:FileModifyDate durchfhren
	If GUICtrlRead($chkShiftDateTimeFileModifyDate) = $GUI_CHECKED Then
		$strExifToolOut = FeedExifTool("ShiftDateTime", $strExifToolParam2, $strExifToolFiles, 1, "Def")
	EndIf

	$booFileIsModified = True
	$booRefresh = True
	$booRefreshMetadataOnly = True
	SetWinOnTopState($intWinOnTopStateUser)
	_Exit()

EndFunc ;Func SaveShiftDateTime()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetDayOfWeek($strDateTime) ;*** Format $strDateTime: CCYY:MM:DD hh:mm:ss
	Local $t, $m, $cj, $c, $j, $tz, $mz, $jz, $cz, $sz
	Local $arrDateTime = StringSplit($strDateTime, ": ")
	$cj = $arrDateTime[1]
	$c = StringLeft($cj, 2) * 1
	$j = stringright($cj, 2) * 1
	$m = $arrDateTime[2]
	$t = $arrDateTime[3]

	$tz = Mod($t, 7)
	$mz = StringMid("033614625035", $m, 1) * 1
	$jz = Mod(($j + Int($j/4)), 7)
	$cz = (3 - Mod($c, 4)) * 2
	$sz = 0
	If $m < 3 And Mod($cj, 4) = 0 Then $sz = -1

	Return Mod($tz + $mz + $jz + $cz + $sz, 7) ;0=So, 1=Mo, ..., 6=Sa
EndFunc ;Func GetDayOfWeek($strDateTime)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func GetDaylightSavings($strDateTime) ;*** Format $strDateTime: CCYY:MM:DD hh:mm:ss
	Local $t, $m, $cj, $c, $j, $tz, $mz, $jz, $cz, $sz, $dst
	Local $arrDateTime = StringSplit($strDateTime, ": ")

	$cj = $arrDateTime[1]
	$c = StringLeft($cj, 2) * 1
	$j = stringright($cj, 2) * 1
	$m = $arrDateTime[2]
	$t = $arrDateTime[3]
	$tz = Mod($t, 7)
	$mz = StringMid("033614625035", $m, 1) * 1
	$jz = Mod(($j + Int($j/4)), 7)
	$cz = (3 - Mod($c, 4)) * 2
	$sz = 0
	If $m < 3 And Mod($cj, 4) = 0 Then $sz = -1

	Switch $m
		Case 1, 2, 11, 12
			$dst = 0 ;"Standardzeit"
		Case 4, 5, 6, 7, 8, 9
			$dst = 1 ;"Sommerzeit"
		Case 3
			$tz = 3
			$mz = 3
			$jz = Mod(($j + Int($j/4)), 7)
			$cz = (3 - Mod($c, 4)) * 2
			$sz = 0
			$wtltm = Mod($tz + $mz + $jz + $cz + $sz, 7)
			$tdstbeg = 31 - $wtltm
			$dst = 0; "Standardzeit"
			If $t >= $tdstbeg Then $dst = 1; "Sommerzeit"; ToDo: Sommerzeit beginnt hiermit um 00:00; richtig wre 02:00
		Case 10
			$tz = 3
			$mz = 0
			$jz = Mod(($j + Int($j/4)), 7)
			$cz = (3 - Mod($c, 4)) * 2
			$sz = 0
			$wtltm = Mod($tz + $mz + $jz + $cz + $sz, 7)
			$tdstend = 31 - $wtltm
			$dst = 1 ;"Sommerzeit"
			If $t >= $tdstend Then $dst = 0; "Standardzeit"; ToDo: Standardzeit beginnt hiermit um 00:00; richtig wre 03:00
		EndSwitch

		Return $dst
EndFunc ;Func GetDaylightSavings($strDateTime)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetDaylightSavings()
	#cs
	Zu bercksichtigende Parameter:
	Aus INI-Datei:
	- $intShowXMPDaylightSavings
	- $arrDefaultXMPTimezone
	Ermittelte Werte:
	- $booDaylightSavingsExists
	- GUICtrlRead($lblDateTimeOriginalDST)
	- GetDaylightSavings($strDateTimeOriginal)
	#ce
	If $booUnicodeFilename = True Then
		MsgBox(64+262144, $cstrTCMetadataViewerVersion, "SetDaylightSavings" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
		Return
	EndIf

	Local $strDaylightSavingsDef = "R"
	If GetDaylightSavings($strDateTimeOriginal) = 0 Then $strDaylightSavingsDef = "T"
	Local $strLblDateTimeOriginalDSTSymCur = GUICtrlRead($lblDateTimeOriginalDST)
	Local $strLblDateTimeOriginalDSTSymNew, $intLblDateTimeOriginalDSTColNew
	Local $intXMPDaylightSavingsNew, $strXMPTimezoneNameNew, $intEXIFTimeZoneOffsetNew
	Local $strEXIFTimeZoneOffsetEditMode, $strXMPTimezoneNameEditMode
	$strTmp = IniRead($cstrIniFile, "Configuration", "DefaultXMPTimezone", "|||") ;Z.B. "+1|MEZ|+2|MESZ"
	Local $arrDefaultXMPTimezone = StringSplit($strTmp, "|")


	;*** Sun = R; Snowflake = T
	Select

		;--- $intShowXMPDaylightSavings = 1 ---------------------------------------------------------------------------

		Case $booDaylightSavingsExists = False And $intShowXMPDaylightSavings = 1
			$strLblDateTimeOriginalDSTSymNew = "R"
			$intLblDateTimeOriginalDSTColNew = 0xFFF477
			$intXMPDaylightSavingsNew = 1
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[3]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[4]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"
;~ 			$booDaylightSavingsExists = True

		;..............................................................................................................

		Case $booDaylightSavingsExists = True And $intShowXMPDaylightSavings = 1 And $strLblDateTimeOriginalDSTSymCur = "R"
			$strLblDateTimeOriginalDSTSymNew = "T"
			$intLblDateTimeOriginalDSTColNew = 0x6FA1D9
			$intXMPDaylightSavingsNew = 0
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[1]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[2]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"

		Case $booDaylightSavingsExists = True And $intShowXMPDaylightSavings = 1 And $strLblDateTimeOriginalDSTSymCur = "T"
			$strLblDateTimeOriginalDSTSymNew = ""
			$intLblDateTimeOriginalDSTColNew = $strBGColorInactiveControls
			$intXMPDaylightSavingsNew = -1
			$strEXIFTimeZoneOffsetEditMode = "del"
			$strXMPTimezoneNameEditMode = "del"
;~ 			$booDaylightSavingsExists = False

		;--- $intShowXMPDaylightSavings = 2 ---------------------------------------------------------------------------

		Case $booDaylightSavingsExists = False And $intShowXMPDaylightSavings = 2 And $strLblDateTimeOriginalDSTSymCur = "R"
			$strLblDateTimeOriginalDSTSymNew = "R"
			$intLblDateTimeOriginalDSTColNew = 0xFFF477
			$intXMPDaylightSavingsNew = 1
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[3]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[4]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"
;~ 			$booDaylightSavingsExists = True

		Case $booDaylightSavingsExists = False And $intShowXMPDaylightSavings = 2 And $strLblDateTimeOriginalDSTSymCur = "T"
			$strLblDateTimeOriginalDSTSymNew = "T"
			$intLblDateTimeOriginalDSTColNew = 0x6FA1D9
			$intXMPDaylightSavingsNew = 0
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[1]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[2]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"
;~ 			$booDaylightSavingsExists = True

		;..............................................................................................................

		Case $booDaylightSavingsExists = True And $intShowXMPDaylightSavings = 2 And $strLblDateTimeOriginalDSTSymCur = "R" And $strDaylightSavingsDef = "R"
			$strLblDateTimeOriginalDSTSymNew = "T"
			$intLblDateTimeOriginalDSTColNew = 0x6FA1D9
			$intXMPDaylightSavingsNew = 0
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[1]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[2]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"

		Case $booDaylightSavingsExists = True And $intShowXMPDaylightSavings = 2 And $strLblDateTimeOriginalDSTSymCur = "T" And $strDaylightSavingsDef = "T"
			$strLblDateTimeOriginalDSTSymNew = "R"
			$intLblDateTimeOriginalDSTColNew = 0xFFF477
			$intXMPDaylightSavingsNew = 1
			$intEXIFTimeZoneOffsetNew = $arrDefaultXMPTimezone[3]*1
			$strXMPTimezoneNameNew = $arrDefaultXMPTimezone[4]
			$strEXIFTimeZoneOffsetEditMode = "chg"
			$strXMPTimezoneNameEditMode = "chg"

		Case $booDaylightSavingsExists = True And $intShowXMPDaylightSavings = 2 And $strLblDateTimeOriginalDSTSymCur <> $strDaylightSavingsDef
			$strLblDateTimeOriginalDSTSymNew = $strDaylightSavingsDef
			$intLblDateTimeOriginalDSTColNew = $strBGColorInactiveControls
			$intXMPDaylightSavingsNew = -1
			$strEXIFTimeZoneOffsetEditMode = "del"
			$strXMPTimezoneNameEditMode = "del"
;~ 			$booDaylightSavingsExists = False

	EndSelect

;~ 	GUICtrlSetData($lblDateTimeOriginalDST, $strLblDateTimeOriginalDSTSymNew)
;~ 	GUICtrlSetColor($lblDateTimeOriginalDST, $intLblDateTimeOriginalDSTColNew)

	If $arrDefaultXMPTimezone[1] = "" Or $arrDefaultXMPTimezone[3] = "" Then $strEXIFTimeZoneOffsetEditMode = "keep"
	If $arrDefaultXMPTimezone[2] = "" Or $arrDefaultXMPTimezone[4] = "" Then $strXMPTimezoneNameEditMode = "keep"

	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	;If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
	;	$strExifToolParam &= "-srcfile" & @CRLF
	;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	;EndIf
	If $intUpdateMetadataDate = 1 Then $strExifToolParam &= "-XMP:MetadataDate=" & @YEAR & ":" & @MON & ":" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF

	If $intXMPDaylightSavingsNew = -1 Then
		$strExifToolParam &= "-XMP:DaylightSavings=" & @CRLF
	Else
		$strExifToolParam &= "-XMP:DaylightSavings=" & $intXMPDaylightSavingsNew & @CRLF
	EndIf

	$intDateTimeIncrease = 0
;~ 	If $intXMPDaylightSavingsNew = 0 Then $intDateTimeIncrease = $arrDefaultXMPTimezone[1]*1 - $arrDefaultXMPTimezone[3]*1
;~ 	If $intXMPDaylightSavingsNew = 1 Then $intDateTimeIncrease = $arrDefaultXMPTimezone[3]*1 - $arrDefaultXMPTimezone[1]*1
	If $strLblDateTimeOriginalDSTSymNew = "T" Then $intDateTimeIncrease = $arrDefaultXMPTimezone[1]*1 - $arrDefaultXMPTimezone[3]*1
	If $strLblDateTimeOriginalDSTSymNew = "R" Then $intDateTimeIncrease = $arrDefaultXMPTimezone[3]*1 - $arrDefaultXMPTimezone[1]*1
	If $strEXIFTimeZoneOffsetEditMode = "chg" Then
		$strExifToolParam &= "-EXIF:TimeZoneOffset=" & $intEXIFTimeZoneOffsetNew & @CRLF
	ElseIf $strEXIFTimeZoneOffsetEditMode = "del" Then
		$strExifToolParam &= "-EXIF:TimeZoneOffset=" & @CRLF
	Else
		;NOP
	EndIf

	If $strXMPTimezoneNameEditMode = "chg" Then
		$strExifToolParam &= "-XMP:TimezoneName=" & $strXMPTimezoneNameNew & @CRLF
	ElseIf $strXMPTimezoneNameEditMode = "del" Then
		$strExifToolParam &= "-XMP:TimezoneName=" & @CRLF
	Else
		;NOP
	EndIf

	;~~~
	If $intDateTimeIncrease <> 0 And $strLblDateTimeOriginalDSTSymCur <> $strLblDateTimeOriginalDSTSymNew Then
		$strTmp = StringUpper($arrLocStr[73]) & ":" & @LF
		If $intXMPDaylightSavingsNew = -1 Then
			$strTmp &= " XMP:DaylightSavings: del => " & $intXMPDaylightSavingsNew & @LF
		Else
			$strTmp &= " XMP:DaylightSavings: chg => " & $intXMPDaylightSavingsNew & @LF
		EndIf
		$strTmp &= " XMP:TimezoneName: " & $strXMPTimezoneNameEditMode & " => " & $strXMPTimezoneNameNew & @LF
		$strTmp &= " EXIF:TimeZoneOffset: " & $strEXIFTimeZoneOffsetEditMode & " => " & $intEXIFTimeZoneOffsetNew & @LF
;~ 		If $intXMPDaylightSavingsNew = 0 Then $strTmp &= $arrDefaultXMPTimezone[4] & " (UTC" & $arrDefaultXMPTimezone[3] & "h) => " & $arrDefaultXMPTimezone[2] & " (UTC" & $arrDefaultXMPTimezone[1] & "h)      " & @LF
;~ 		If $intXMPDaylightSavingsNew = 1 Then $strTmp &= $arrDefaultXMPTimezone[2] & " (UTC" & $arrDefaultXMPTimezone[1] & "h) => " & $arrDefaultXMPTimezone[4] & " (UTC" & $arrDefaultXMPTimezone[3] & "h) (DST)" & @LF

		$strTmp &= @LF & StringUpper($arrLocStr[73]) & "?" & @LF
		$strTmp &= ' EXIF:DateTimeOriginal' & @LF & ' EXIF:CreateDate ("DateTimeDigitized")' & @LF & ' EXIF:ModifyDate ("DateTime")' & @LF
		$strTmp &= @LF & StringReplace($arrLocStr[105], "%hours", $intDateTimeIncrease)
		$intRetVal = IniRead($cstrIniFile, "Configuration", "ShiftAllDatesOnChangeXMPDaylightSavings", "2")*1
		If $intRetVal = 2 Then ;*** "Ask"
			$intRetVal = MsgBox(3+32+512+262144, $arrLocStr[104], $strTmp)
		ElseIf $intRetVal = 1 Then ;*** "Yes"
			$intRetVal = 6 ;*** Entspricht Button "Yes" in MsgBox
		Else ;*** "No*
			$intRetVal = 7 ;*** Entspricht Button "No" in MsgBox
		EndIf
		If $intRetVal = 2 Then Return ;*** 2 = Cancel
		If $intRetVal = 6 Then ;*** 6 = Yes
			If $intDateTimeIncrease < 0 Then
				$strExifToolParam &= "-AllDates-=" & Abs($intDateTimeIncrease) & @CRLF
			Else
				$strExifToolParam &= "-AllDates+=" & Abs($intDateTimeIncrease) & @CRLF
			EndIf
		EndIf
	EndIf
	;~~~

	GUICtrlSetData($lblDateTimeOriginalDST, $strLblDateTimeOriginalDSTSymNew)
	GUICtrlSetColor($lblDateTimeOriginalDST, $intLblDateTimeOriginalDSTColNew)
	$strExifToolOut = FeedExifTool("SetXMPDaylightSavings", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")

	WinActivate($whTC)
	If $intMoveCursorToNextFileAfterSetXMPTimezone = 1 Then
		If $intMoveCursorDirection = 1 Then
			Send("{Down}")
		Else
			Send("{Right}")
		EndIf
	Else
		$booFileIsModified = True
		$booRefresh = True
		$booRefreshMetadataOnly = True
	EndIf

EndFunc ;Func SetDaylightSavings()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenEditTagDialog($intLvwItemIdx)
;~ 	$arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwTags)
	$arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwTags, $intLvwItemIdx)
	;*** "|" ist Spaltentrenner frs Listview: Spalten, die "|" enthalten (z.B. multiple XMP-Labels) werden dadurch nicht korrekt eingelesen
	For $i = 5 To $arrLvwRow[0]
		$arrLvwRow[4] &= "|" & $arrLvwRow[$i]
	Next

;~ 	;debug - begin ##################################################
;~ 	$erg  = @LF
;~ 	$erg &= "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" & @LF
;~ 	$erg &= $arrLvwRow[1] & ":" & $arrLvwRow[3] & " (" & $arrLvwRow[2] & ") = " & $arrLvwRow[4] & @LF
;~ 	$erg &= @LF
;~ 	FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 	;debug - end   ##################################################

	;*** Eine Leerzeile wurde angeklickt
;~ 	If $arrLvwRow[1] & $arrLvwRow[2] & $arrLvwRow[3] & $arrLvwRow[4] = "" Then
	If $arrLvwRow[3] & $arrLvwRow[4] = "" Then
		#cs - Test Bei Klick auf Group Header Listview zur nchsten Group scrollen - Beginn
		$strListviewItemGroupNameMem = ""
		For $i = 0 To _GUICtrlListView_GetItemCount($hlvwTags)
			If _GUICtrlListView_GetItemPositionY($hlvwTags, $i)-22 > 0 Then
				$arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwTags, $i)
				$strListviewItemGroupNameMem = $arrLvwRow[1]
				For $j = $i To _GUICtrlListView_GetItemCount($hlvwTags)
					$arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwTags, $j)
					If $arrLvwRow[1] <> $strListviewItemGroupNameMem Then
						_GUICtrlListView_Scroll($hlvwTags, 0, _GUICtrlListView_GetItemPositionY($hlvwTags, $j)-22-28)
						ExitLoop
					EndIf
				Next
				If $j >= _GUICtrlListView_GetItemCount($hlvwTags) Then _GUICtrlListView_Scroll($hlvwTags, 0, _GUICtrlListView_GetItemPositionY($hlvwTags, 0)-22-28)
				ExitLoop
			EndIf
		Next
		#ce - Test Bei Klick auf Group Header Listview zur nchsten Group scrollen - Ende
		Return
	EndIf

	;*** Button "Region" ist aktiv, Eintrag aus der Liste der XMP:RegionInfoMP wurde angeklickt
	If $strTagFilter = "Region" Then
		If $booMagnify = True Then
			$booMagnify = False
			GUICtrlSetColor($lblScale, 0x4D6185)
			If $strImageConvertMode = "RAW" Then
				GetImageDim($cstrTmpFile & "_PreviewImage.jpg")
			Else
				GetImageDim($strTCPathCur & $strTCFileCur)
			EndIf
			$booRefreshQuickviewImage = True
		EndIf

		If $arrLvwRow[4] = "" Then Return
		$arrRegionRectangle = StringSplit($arrLvwRow[4], ", ", 1)
		GUICtrlSetState($lblRegionRectangle, $GUI_SHOW)
 		;*** GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), 1, $intImgPreW, $intImgPreH)
 		;*** GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), Int(($intPicH - $intImgPreH) / 2) + 1, $intImgPreW, $intImgPreH)
;~ 		GUICtrlSetPos($lblRegionRectangle, Int(($intPicW - $intImgPreW) / 2) + Round($intImgPreW*$arrRegionRectangle[1]) - 2, 1 + Round($intImgPreH*$arrRegionRectangle[2]) - 2, Round($intImgPreW*$arrRegionRectangle[3]) + 4, Round($intImgPreH*$arrRegionRectangle[4]) + 4)
		GUICtrlSetPos($lblRegionRectangle, Int(($intPicW - $intImgPreW) / 2) + Round($intImgPreW*$arrRegionRectangle[1]) - 2, Int(($intPicH - $intImgPreH) / 2) + 1 + Round($intImgPreH*$arrRegionRectangle[2]) - 2 + $intShowImageTitle*20, Round($intImgPreW*$arrRegionRectangle[3]) + 4, Round($intImgPreH*$arrRegionRectangle[4]) + 4)
		Return
	EndIf

	;*** Button "User" ist aktiv, Eintrag aus der Liste der TagGroups wurde angeklickt
	If $strTagFilter = "User:User" Then
		$strTagFilter = "User:" & $arrLvwRow[1]
		ControlFocus($frmMain, "", $btnTagGroupUser)
		GUICtrlSetData($btnTagGroupUser, $arrLvwRow[1])
		FilterImageTags()
		Return
	EndIf

	;GUICtrlSetColor($lblStatus, 0xFF8000)
	GUICtrlSetData($lblStatus, $arrLocStr[65])

	$booEditTagList = False
	$booEditTagStruct = False

	If $strTagFilter <> "Custom" Then $strCustomTagsDrilledDown = ""

	;*** Button "Custom" ist aktiv, eine Zeile im CustView (Tags sind noch nicht vereinzelt) wurde angeklickt:
	If $strTagFilter = "Custom" Then
;~ 	If $strTagFilter = "Custom" And $strCustomTagsDrilledDown = "" Then

		;*** "DrillDown" durchfhren, also Listview leeren und jedes Tag der CustView-Zeile auf einer separaten Zeile im Listview anzeigen
		If $strCustomTagsDrilledDown = "" Then

			$intLvwGroupIdx = 0
			For $intCustomTagsIdx = 1 To $arrCustomTags[0][0]
				If $arrCustomTags[$intCustomTagsIdx][0] = "$Group" Then $intLvwGroupIdx += 1
				If $intCustomTagsIdx - 1 - $intLvwGroupIdx = $intLvwItemIdx Then ExitLoop
			Next
			$intCustomTagsIdx = $intLvwItemIdx + $intLvwGroupIdx + 1
			If $intCustomTagsIdx = 0 Then $intCustomTagsIdx = 1

			$strCustomTagsDrilledDown = $arrCustomTags[$intCustomTagsIdx][1] ;*** Speichern der zur angeklickten Listview-Zeile gehrigen CustomFieldsContents-Definition (aus INI-File)
			;*** CustomFieldsContents-Definition auswerten              Vor     Pre         Grp    Nam  SubA       Unit        SubB       Suf           Nach
			;                                                           0       1           2      3    4          5           6          7             8
			;                                                           9       10          11     12   13         14          15         16            17
			$arrRegExpResult = StringRegExp($strCustomTagsDrilledDown, '(.*?)\[=(".*?"){0,1}(.+?)\.(.+?)(:.+?){0,1}(\..+?){0,1}(:.+?){0,1}(".*?"){0,1}\](.*?)', 3)

			#cs Obsolet ab V1.3
			$intCustomTagsNumMembers = UBound($arrRegExpResult) / 9

			;*** Wenn die CustomView-Zeile genau ein Tag enthlt, dann *kein* "DrillDown" durchfhren (ab und bis V1.2)
			;*** und TagGrp und TagNam aus CustomFieldsContents-Definition in $arrLvwRow bernehmen
			;*** (Problem: Tag-Wert ($arrLvwRow[4]) wird wie im Listview angezeigt in den Edit-Dialog bernommen, also entsprechend CustomFieldsContents-Definition formatiert)
			If $intCustomTagsNumMembers = 1 Then [...]

			;*** Wenn die CustomView-Zeile mehr als ein Tag enthlt, dann "DrillDown" durchfhren (ab V1.2)
			If $intCustomTagsNumMembers > 1 Then [...]
			#ce Obsolet ab V1.3

			;*** "DrillDown" durchfhren (egal, wieviel Tags die CustomView-Zeile enthlt) (ab V1.3)

				_GUICtrlListView_RemoveAllGroups($hlvwTags)
				_GUICtrlListView_DeleteAllItems($hlvwTags)

				;*** Dummyaufruf FilterImageTags() mit (im Endeffekt) leerem Filterkriterium zum "Initialisieren" des Listviews (Workaround gegen Nicht-Funktionieren des Drilldowns unter Win7 (Fehlerursache noch unbekannt))
				$strTagFilter = "User:"
				FilterImageTags()
				$strTagFilter = "Custom"
				GUICtrlSetBkColor($btnTagGroupUser, $strBGColorInactiveControls)
				GUICtrlSetBkColor($btnTagGroupCustom, $strBGColorActiveControls)

				_GUICtrlListView_BeginUpdate($hlvwTags)
				;Test: Prfen, ob TagGrp *nebenwirkungsfrei* entsprechend der gesetzten Option ausgegeben werden kann
				$strExifToolParam = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
				$strExifToolParam &= "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
				If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
				If $strOptTagNam = "Desc" Then
					$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
				Else
					$strExifToolParam &= "-s" & @CRLF
				EndIf
				;If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
				;	$strExifToolParam &= "-srcfile" & @CRLF
				;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
				;EndIf

				For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 9 - 1
					$strExifToolParam &= "-" & $arrRegExpResult[$intRegExpResultIdx*9+2] & ":" & $arrRegExpResult[$intRegExpResultIdx*9+3] & @CRLF
				Next
				$strExifToolOut = FeedExifTool("ReadSpecTags_DrillDown", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
;~ 				FileWrite("D:\Software\Scripting\AutoIT3\Scripte\TCMetadataViewer\out.txt", $strExifToolOut) ;debug
;~ 				MsgBox(262144, "ReadSpecTags_DrillDown: $strExifToolOut", $strExifToolOut) ;debug
				$arrTagListSpecial = StringSplit($strExifToolOut, @CRLF, 1)

;~ 				$test = "" ;debug
				$intLvwItemIdx = -1
				For $i = 1 To $arrTagListSpecial[0]-1
					$arrTag = SplitTagListRec($arrTagListSpecial[$i])
					$intLvwItemIdx += 1
					;*** Wenn TagGrp leer ist, dann ist das Tag in den Metadaten nicht vorhanden
					;*** In diesem Fall TagGrp und TagNam mit den Werten aus der CustView-Definition belegen
;~ 					If $arrTag[1] = "" Then
					If $arrTag[1] = "" Then
						_GUICtrlListView_AddItem($hlvwTags, $arrRegExpResult[($i-1)*9+2])
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, "", 1)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrRegExpResult[($i-1)*9+3], 2)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, "", 3) ;
;~ 						$test &= $intLvwItemIdx & ": " & $arrRegExpResult[($i-1)*9+2] & "  " & "" & "  " & $arrRegExpResult[($i-1)*9+3] & "  " & "" & @LF ;debug
					;*** Test MWG
					ElseIf $arrRegExpResult[($i-1)*9+2] =  "MWG" Then
						_GUICtrlListView_AddItem($hlvwTags, $arrRegExpResult[($i-1)*9+2])
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[2], 1)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[3], 2)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[4], 3)
;~ 						$test &= $intLvwItemIdx & ": " & $arrRegExpResult[($i-1)*9+2] & "  " & $arrTag[2] & "  " & $arrTag[3] & "  " & $arrTag[4] & @LF ;debug
					Else
						_GUICtrlListView_AddItem($hlvwTags, $arrTag[1])
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[2], 1)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[3], 2)
						_GUICtrlListView_AddSubItem($hlvwTags, $intLvwItemIdx, $arrTag[4], 3)
;~ 						$test &= $intLvwItemIdx & ": " & $arrTag[1] & "  " & $arrTag[2] & "  " & $arrTag[3] & "  " & $arrTag[4] & @LF ;debug
					EndIf
				Next
;~ 				MsgBox(262144, "", $test) ;debug

;~ 				For $i = $intLvwItemIdx+1 To _GUICtrlListView_GetItemCount($hlvwTags)
;~ 					_GUICtrlListView_DeleteItem($hlvwTags, $i)
;~ 				Next

				_GUICtrlListView_EndUpdate($hlvwTags)

				For $i = 0 To 3
					_GUICtrlListView_SetColumnWidth($hlvwTags, $i, $LVSCW_AUTOSIZE)
				Next

				;GUICtrlSetColor($lblStatus, 0x008000)
				GUICtrlSetData($lblStatus, $arrLocStr[63])
				;*** Wenn in der CustView-Zeile genau ein Tag definiert ist, nach dem DrillDown also nur eine Listview-Zeile gefllt ist,
				;*** dann EditTag-Dialog direkt fr dieses eine Tag aufrufen (Listview-Zeile msste sonst vom Benutzer selber angeklickt werden)
				If $intLvwItemIdx = 0 Then OpenEditTagDialog(0)
				Return

;~ 			EndIf ;*** If $intCustomTagsNumMembers > 1 Then [...]. Obsolet ab  V1.3

		EndIf

	EndIf


	;*** Wenn ein Filter <> "Cust" aktiv ist (z.B. "All") und der CustView noch nicht besucht wurde, ist noch nicht bekannt, ob der momentan in $strCustomView gesetzte
	;*** CustView berhaupt gltig ist, also in der INI-Datei existiert. Dies wird hier daher explizit geprft (Ablauf bernommen aus "Func FilterImageTags()")
	$strCustomView = "CustomView_Default"
	$arrCustomViews = IniReadSection($cstrIniFile, "CustomViews")
	If @error = 0 Then
		For $i = 1 To $arrCustomViews[0][0]
			If StringInStr($arrCustomViews[$i][1], $strTCExtCur, 0) > 0 Then
				$strCustomView = $arrCustomViews[$i][0]
				ExitLoop
			EndIf
		Next
		If _ArraySearch($arrIniSectionNames, $strCustomView) = -1 Then $strCustomView = "CustomView_Default"
	EndIf

	GUICtrlSetState($lvwEditTagVal, $GUI_HIDE)
	GUICtrlSetState($lbxEditTagList, $GUI_HIDE)
	GUICtrlSetState($txtEditTagListQuickfilter, $GUI_HIDE)
	GUICtrlSetState($icoEditTagListQuickfilter, $GUI_HIDE)
	GUICtrlSetState($chkEditTagActionOpt, $GUI_HIDE)
	GUICtrlSetPos($txtEditTagVal, 5, 23, 2*185+3*5, 150)

	$intEditControlsState = $GUI_ENABLE
	$strEditControlsStateReason = ""

	;*** Pfad+Name der aktuellen Datei enthlt Unicode-Zeichen, die nicht im Zeichensatz der aktiven Codepage enthalten sind
;~ 	If $booUnicodeFilename = True Then
	If $booUnicodeFilename = True And $booBackup = True Then
		$intEditControlsState = $GUI_DISABLE
		$strEditControlsStateReason = "Unicode-Filename: " & $strTCFileCurOri ;Test
	EndIf

	$strWritableExts = FileRead(@ScriptDir & "\TCMetadataViewer_ExifTool_WritableExts.txt")
	If StringInStr($strWritableExts, " " & $strTCExtCur) = 0 Then
		$intEditControlsState = $GUI_DISABLE
		$strEditControlsStateReason = "Ext not writable"
	EndIf
	$strWritableExts = ""

	;*** Ermitteln 1.) des Standard-Namens des zu editierenden Tags und 2.) der Speicherbarkeit ("writable"-Attribut) des Tags
	If $intEditControlsState = $GUI_ENABLE Then

		If $intXMLTagDBOpen = 0 Then ;$intXMLTagDBOpen =  0: XMLTagDB wurde noch nicht versucht zu laden oder eine andere XMLTagDB (z.B. fr XMP-MP-Tags) wurde zwischenzeitlich geffnet
			If _XMLFileOpen(@ScriptDir & "\TCMetadataViewer_ExifTool_XMLTagDB.xml") Then
				$intXMLTagDBOpen = 1  ;$intXMLTagDBOpen =  1: XMLTagDB wurde erfolgreich geladen
			Else
				$intXMLTagDBOpen = -1 ;$intXMLTagDBOpen = -1: Fehler beim Laden der XMLTagDB
			EndIf
		EndIf

		;*** Wenn das Tag in den Metadaten nicht vorhanden ist (gekennzeichnet durch leere TagID), dann lediglich writable- und flags-Attribute ermitteln
;~ 		If $intXMLTagDBOpen = 1 And $arrLvwRow[2] = "" Then
		If $intXMLTagDBOpen = 1 And $arrLvwRow[2] = "" And $arrLvwRow[1] <> "MWG" Then ;Test MWG
			$strXPath = "//table/tag[@g0='" & $arrLvwRow[1] & "' and @name='" & $arrLvwRow[3] & "']"
			$strXPath &= "|" & $strXPath & "/parent::*"
			$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
			If $intXMLTagDBNodeCount < 1 Then
				$strXPath = "//table[@g0='" & $arrLvwRow[1] & "']/tag[@name='" & $arrLvwRow[3] & "']"
				$strXPath &= "|" & $strXPath & "/parent::*"
				$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
			EndIf
			WriteLog("ReadXMLTagDB (TagAdd)", $strXPath)

;~ 			;debug - begin ##################################################
;~ 			$erg  = "----------------------------------------" & @LF
;~ 			$erg &= "[A] $arrXMLTagDBAttrNam, $arrXMLTagDBAttrVal" & @LF
;~ 			$erg &= "----------------------------------------" & @LF
;~ 			$erg &= $strXPath & @LF
;~ 			$erg &= @LF
;~ 			;debug - end   ##################################################

			$strTagGrpTagNam = ""
			For $i = 0 To $intXMLTagDBNodeCount - 1
;~ 				;debug - begin ##################################################
;~ 				$erg &= @LF & "Node [" & $i & "]  " & @LF
;~ 				;debug - end   ##################################################
				$arrXMLTagDBNode = _XMLGetAllAttribIndex($strXPath, $arrXMLTagDBAttrNam, $arrXMLTagDBAttrVal, "", $i)
				For $j = 0 To UBound($arrXMLTagDBAttrNam) - 1
;~ 					;debug - begin ##################################################
;~ 					$erg &= "Attr [" & $j & "]  " & $arrXMLTagDBAttrNam[$j] & "=" & $arrXMLTagDBAttrVal[$j] & "    "
;~ 					;debug - end   ##################################################
					If $arrXMLTagDBAttrNam[$j] = "writable" And $arrXMLTagDBAttrVal[$j] = "false" Then
						$intEditControlsState = $GUI_DISABLE
						$strEditControlsStateReason = '"writable"-attribute of tag = false'
					EndIf
					If $arrXMLTagDBAttrNam[$j] = "flags" And StringInStr($arrXMLTagDBAttrVal[$j], "List") > 0 Then $booEditTagList = True

					If $arrXMLTagDBAttrNam[$j] = "g1" Then $strTagGrpTagNam = $arrXMLTagDBAttrVal[$j]
					If $arrXMLTagDBAttrNam[$j] = "name" Then $strTagGrpTagNam &= ":" & $arrXMLTagDBAttrVal[$j]
					If $strTagGrpTagNam = "XMP-MP:RegionPersonDisplayName" Or $strTagGrpTagNam = "XMP-MP:Rectangle" Then $booEditTagStruct = True
				Next
			Next

;~ 			;debug - begin ##################################################
;~ 			FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 			;debug - end   ##################################################

		EndIf

;~ 		If $intXMLTagDBOpen = 1 And $arrLvwRow[2] <> "" Then
		If $intXMLTagDBOpen = 1 And $arrLvwRow[2] <> "" And $arrLvwRow[1] <> "MWG" Then ;Test MWG

			;*** In der XMLTagDB werden die Attribute zu zwei Nodes gesucht:  Attribute des (der) <tag>-Nodes | Attribute des <table>-Nodes
			;*** Die beiden XPath-Pfade werden dem XMLDOMWrapper gleichzeitig (mit "|" konkateniert) bergeben
			;*** Die Ergebnisse werden "von hinten nach vorne" ausgegeben, also erst die Ergebnisse zum <table>-Node, dann die zum (zu den) <tag>-Node(s)
			;*** Zu einem <table>-Node knnen 1..n <tag>-Nodes ausgegeben werden!
			$strXMLTagDBTagID = ""
			;*** Falls eine numerische Tag-ID vorhanden ist (aus Listview), dann diese als Suchkriterium mit bergeben
			If $arrLvwRow[2]*1 > 0 Then $strXMLTagDBTagID = "@id='" & $arrLvwRow[2]*1 & "' and "
			If $strOptTagNam = "Desc" Then
				$strXPath = "//table/tag[" & $strXMLTagDBTagID & "desc[@lang='" & $strExifToolLang & "']='" & $arrLvwRow[3] & "']"
				$strXPath &= "|" & $strXPath & "/parent::*"
				$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
				;*** Falls zu einem Tag kein lokalisierter Name in der gewhlten $strExifToolLang existiert, gibt ExifTool fehlwertmig die Tag-Beschreibung fr lang='en' aus
				If $intXMLTagDBNodeCount < 1 And $strExifToolLang <> "en" Then
					$strXPath = "//table/tag[" & $strXMLTagDBTagID & "desc[@lang='en']='" & $arrLvwRow[3] & "']"
					$strXPath &= "|" & $strXPath & "/parent::*"
					$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
				EndIf
			EndIf
			;*** Falls "reale" Tag-Namen angezeigt werden
			;*** *oder* lokalisierte Tag-Namen angezeigt werden, aber die XMLTagDB weder fr @lang=$strExifToolLang noch fr @lang='en' eine Lokalisierung enthlt,
			;*** dann Tags ber ihren "realen" Namen suchen
			If $strOptTagNam <> "Desc" Or $intXMLTagDBNodeCount < 1 Then
				$strXPath = "//table/tag[" & $strXMLTagDBTagID & "@name='" & $arrLvwRow[3] & "']"
				$strXPath &= "|" & $strXPath & "/parent::*"
				$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)
			EndIf
			WriteLog("ReadXMLTagDB (TagChg)", $strXPath)

			$strXMLTagDBTabG0 = ""
			$strXMLTagDBTabG1 = ""
			$strXMLTagDBTabG2 = ""

			$strXMLTagDBTagNam = ""
			$strXMLTagDBTagG0 = ""
			$strXMLTagDBTagG1 = ""
			$strXMLTagDBTagG2 = ""
			$strXMLTagDBTagWR = ""

			$strXMLTagDBNodeNam = ""
			$strXMLTagDBTagList = ""

			;*** Alle zum $strXPath passenden Nodes verarbeiten. Es handelt sich um eine Mischung aus <table>- und <tag>-Nodes
;~ 			;debug - begin ##################################################
;~ 			$erg  = "----------------------------------------" & @LF
;~ 			$erg &= "[B] $arrXMLTagDBAttrNam, $arrXMLTagDBAttrVal" & @LF
;~ 			$erg &= "----------------------------------------" & @LF
;~ 			$erg &= $strXPath & @LF
;~ 			$erg &= @LF
;~ 			;debug - end   ##################################################

			For $i = 0 To $intXMLTagDBNodeCount - 1
;~ 				;debug - begin ##################################################
;~ 				$erg &= "Node [" & $i & "]  "
;~ 				;debug - end   ##################################################

				$arrXMLTagDBNode = _XMLGetAllAttribIndex($strXPath, $arrXMLTagDBAttrNam, $arrXMLTagDBAttrVal, "", $i)

				$strXMLTagDBAttrNam = ""
				$strXMLTagDBAttrG0 = ""
				$strXMLTagDBAttrG1 = ""
				$strXMLTagDBAttrG2 = ""
				$strXMLTagDBAttrWR = ""
				$strXMLTagDBAttrFL = ""
				$strXMLTagDBNodeNam = "table"
				For $j = 0 To UBound($arrXMLTagDBAttrNam) - 1
;~ 					;debug - begin ##################################################
;~ 					$erg &= "Attr " & $arrXMLTagDBAttrNam[$j] & "=" & $arrXMLTagDBAttrVal[$j] & "    "
;~ 					;debug - end   ##################################################
					Switch $arrXMLTagDBAttrNam[$j]
						Case "name"
							$strXMLTagDBAttrNam = $arrXMLTagDBAttrVal[$j]
						Case "g0"
							$strXMLTagDBAttrG0 = $arrXMLTagDBAttrVal[$j]
						Case "g1"
							$strXMLTagDBAttrG1 = $arrXMLTagDBAttrVal[$j]
						Case "g2"
							$strXMLTagDBAttrG2 = $arrXMLTagDBAttrVal[$j]
						Case "writable"
							$strXMLTagDBAttrWR = $arrXMLTagDBAttrVal[$j]
							$strXMLTagDBNodeNam = "tag" ;*** Nur in <tag>-Nodes gibt es das Attribut "writable" (und zwar in *allen* <Tag>-Nodes)
						Case "flags"
							$strXMLTagDBAttrFL = $arrXMLTagDBAttrVal[$j] ;*** Nur in <tag>-Nodes gibt es das Attribut "flags" (aber *nicht* in allen <Tag>-Nodes)
							#cs
							Mit ExifTool 8.37 auftretende Flags/Flag-Kombinationen:
							flags='Avoid'                         flags='List'
							flags='Avoid,Bag,List'                flags='List,Seq'
							flags='Avoid,List'                    flags='Mandatory'
							flags='Bag,List'                      flags='Mandatory,Unsafe'
							flags='Binary'                        flags='Permanent'
							flags='Binary,List'                   flags='Permanent,Protected'
							flags='Binary,Permanent'              flags='Permanent,Unknown'
							flags='Binary,Permanent,Unknown'      flags='Permanent,Unsafe'
							flags='Binary,Permanent,Unsafe'       flags='Protected'
							flags='Binary,Unknown'                flags='Unknown'
							flags='Binary,Unsafe'                 flags='Unsafe'
							#ce
					EndSwitch
				Next

;~ 				;debug - begin ##################################################
;~ 				$erg &= @LF
;~ 				If $strXMLTagDBNodeNam = "tag" Then $erg &= @LF
;~ 				;debug - end   ##################################################

				If $strXMLTagDBNodeNam = "table" Then
					$strXMLTagDBTagNam = ""
					$strXMLTagDBTagG0 = ""
					$strXMLTagDBTagG1 = ""
					$strXMLTagDBTagG2 = ""
					$strXMLTagDBTagWR = ""
					$strXMLTagDBTagFL = ""
					$strXMLTagDBTabG0 = $strXMLTagDBAttrG0
					$strXMLTagDBTabG1 = $strXMLTagDBAttrG1
					$strXMLTagDBTabG2 = $strXMLTagDBAttrG2
				EndIf

				If $strXMLTagDBNodeNam = "tag" Then
					$strXMLTagDBTagNam = $strXMLTagDBAttrNam
					$strXMLTagDBTagG0 = $strXMLTagDBAttrG0
					$strXMLTagDBTagG1 = $strXMLTagDBAttrG1
					$strXMLTagDBTagG2 = $strXMLTagDBAttrG2
					$strXMLTagDBTagWR = $strXMLTagDBAttrWR
					$strXMLTagDBTagFL = $strXMLTagDBAttrFL

					If $strXMLTagDBTagG0 = "" Then $strXMLTagDBTagG0 = $strXMLTagDBTabG0
					If $strXMLTagDBTagG1 = "" Then $strXMLTagDBTagG1 = $strXMLTagDBTabG1
					If $strXMLTagDBTagG2 = "" Then $strXMLTagDBTagG2 = $strXMLTagDBTabG2

					$strXMLTagDBTagList &= $strXMLTagDBTagNam & @TAB & $strXMLTagDBTagG0 & @TAB & $strXMLTagDBTagG1 & @TAB & $strXMLTagDBTagG2 & @TAB & $strXMLTagDBTagWR & @TAB & $strXMLTagDBTagFL & @LF
				EndIf

			Next

;~ 			;debug - begin ##################################################
;~ 			FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 			$erg  = "----------------------------------------" & @LF
;~ 			$erg &= "[C] $strXMLTagDBTagList" & @LF
;~ 			$erg &= "----------------------------------------" & @LF
;~ 			$erg &= $strXMLTagDBTagList & @LF
;~ 			$erg &= @LF
;~ 			FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 			;debug - end   ##################################################

			$strXMLTagDBTagList = StringReplace($strXMLTagDBTagList, @LF, @LF)
			$intXMLTagDBTagList = @extended

			If $intXMLTagDBTagList = 0 Then
				;NOP
				;*** The EXIF meta information is organized into different Image File Directories (IFD's) within an image. The names of these IFD's correspond
				;*** to the ExifTool family 1 group names. When writing EXIF information, the default Group listed below is used unless another group is specified.
				;*** ==> Das bedeutet in der Praxis z.B., dass ein Tag de facto in IFD1 gespeichert sein kann, der Fehlwert aber IFD0 wre
				;***     In diesem Fall wre die Ergebnismenge in $strXMLTagDBTagList leer, wenn $strOptTagGrp="Loc" ist

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[D] Kein Tag ist qualifiziert" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				$erg &= @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################

			;*** Wenn sich genau ein Tag qualifiziert hat, knnen die Werte fr TagGrp und TagNam direkt bernommen werden:
			ElseIf $intXMLTagDBTagList = 1 Then
				$strXMLTagDBTagList = StringTrimRight($strXMLTagDBTagList, 1)
				$arrXMLTagDBTagListRow = StringSplit($strXMLTagDBTagList, @TAB) ;*** [1]=TagNam [2]=TagG0 [3]=TagG1 [4]=TagG2 [5]=TagWR [6]=TagFL
				$arrLvwRow[1] = $arrXMLTagDBTagListRow[2] ;*** TagG0
				$arrLvwRow[3] = $arrXMLTagDBTagListRow[1] ;*** TagNam
				If $arrXMLTagDBTagListRow[5] = "false" Then
					$intEditControlsState = $GUI_DISABLE
					$strEditControlsStateReason = '"writable"-attribute of tag = false'
				EndIf
				If StringInStr($arrXMLTagDBTagListRow[6], "List") > 0 Then $booEditTagList = True
				If $arrXMLTagDBTagListRow[3] & ":" & $arrXMLTagDBTagListRow[1] = "XMP-MP:RegionPersonDisplayName" _
				Or $arrXMLTagDBTagListRow[3] & ":" & $arrXMLTagDBTagListRow[1] = "XMP-MP:Rectangle" Then $booEditTagStruct = True ;Todo: In INI-Section [LineBreaks] suchen

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[E1] $booEditTagList" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				$erg &= $booEditTagList & @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[E2] $arrXMLTagDBTagListRow" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				For $i = 1 To $arrXMLTagDBTagListRow[0]
;~ 					$erg &= "[" & $i & "]: " & $arrXMLTagDBTagListRow[$i] & @LF
;~ 				Next
;~ 				$erg &= @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[F] Genau ein Tag ist qualifiziert" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				$erg &= $arrLvwRow[1] & ":" & $arrLvwRow[3] & @LF
;~ 				$erg &= @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################

			;*** Wenn sich mehrere Tags qualifiziert haben, das zutreffende Tag auswhlen:
			;*** Werte fr alle Tags ermitteln (ExifTool-Aufruf) und mit Wert aus Listview vergleichen
			Else ;$intXMLTagDBTagList > 0
;~ 				$strXMLTagDBTagList &= $arrLvwRow[3] & @TAB & $arrLvwRow[1] & @TAB & $arrLvwRow[1] & @TAB & "{TagG2}" & @TAB & "True" & @TAB & "{TagFL}" ;Test: Zustzlich TagGrp:TagNam aus Listview bergeben (fr duplicate tags IFD0+IFD1, z.B. EXIF:XResolution)
				$strXMLTagDBTagList = StringTrimRight($strXMLTagDBTagList, 1)

;~ 				$strExifToolParam = "-G1" & @CRLF & "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
				$strExifToolParam = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF & "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
				If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
				If $strOptTagNam = "Desc" Then
					$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
				Else
					$strExifToolParam &= "-s" & @CRLF
				EndIf
;~ 				If $booConvert = True Then $strExifToolParam &= "-L" & @CRLF

				$arrXMLTagDBTagList = StringSplit($strXMLTagDBTagList, @LF)
				For $i = 1 To $arrXMLTagDBTagList[0]
					$arrXMLTagDBTagListRow = StringSplit($arrXMLTagDBTagList[$i], @TAB) ;*** [1]=TagNam [2]=TagG0 [3]=TagG1 [4]=TagG2 [5]=TagWR [6]=TagFL
					$strExifToolParam &= "-" & $arrXMLTagDBTagListRow[3] & ":" & $arrXMLTagDBTagListRow[1] & @CRLF ;Test: G1 statt G0
				Next
;~ 				$strExifToolParam &= "-" & $arrLvwRow[1] & ":" & $arrLvwRow[3] & @CRLF ;Test: Zustzlich TagGrp:TagNam aus Listview bergeben (fr duplicate tags IFD0+IFD1, z.B. EXIF:XResolution)

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[G] $strExifToolParam" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				$erg &= $strExifToolParam & @LF
;~ 				$erg &= $strTCPathCur & $strTCFileCur & @LF
;~ 				$erg &= @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################

				$strExifToolOut = FeedExifTool("GetValForTagsInXMLTagDBTagList", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")

;~ 				;debug - begin ##################################################
;~ 				$erg  = "----------------------------------------" & @LF
;~ 				$erg &= "[H] $strExifToolOut" & @LF
;~ 				$erg &= "----------------------------------------" & @LF
;~ 				$erg &= $strExifToolOut & @LF
;~ 				$erg &= @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)

;~ 				$erg = "Suche im ExifTool-Output nach" & @LF & "* $arrLvwRow[4]: " & $arrLvwRow[4] & @LF & "* $arrLvwRow[2]: " & $arrLvwRow[2] & @LF
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)

;~ 				$erg = ""
;~ 				$arrExifToolOut = StringSplit($strExifToolOut, @CRLF, 1)
;~ 				For $i = 1 To $arrExifToolOut[0] - 1
;~ 					$erg &= "[" & $i & "]: "
;~ 					$arrExifToolOutRow = StringSplit($arrExifToolOut[$i], @TAB)
;~ 					For $j = 1 To $arrExifToolOutRow[0]
;~ 						$erg &= "[" & $j & "] " & $arrExifToolOutRow[$j] & "  "
;~ 					Next
;~ 					$erg &= @LF
;~ 				Next
;~ 				FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 				;debug - end   ##################################################


				$intEditControlsState = $GUI_DISABLE ;*** Steuerelemente prophylaktisch disablen, falls im ExifTool-Output kein passender DS gefunden wird
				$strEditControlsStateReason = "No match for Tag-value & Tag-ID in ExifTool output"
				$arrExifToolOut = StringSplit($strExifToolOut, @CRLF, 1)
				For $i = 1 To $arrExifToolOut[0] - 1
					$arrExifToolOutRow = StringSplit($arrExifToolOut[$i], @TAB)
					$arrExifToolOutRow[4] = StringToUTF8($arrExifToolOutRow[4]) ;In UTF-8 konvertieren
					;*** Auf Gleichheit werden berprft: Wert (Inhalt) ([4]) und ID ([2]) des Tags
					;*** Grund: Der gleiche Wert kann in verschiedenen Tags gespeichert sein (Bsp.: Belichtungsdauer in "Composite" und in "EXIF")

;~ 					;debug - begin ##################################################
;~ 					$erg = "[" & $i & "]: <" & StringLeft($arrExifToolOutRow[4], 259-4) & "> =? <" & StringLeft($arrLvwRow[4], 259-4) & "> *AND* <" & $arrExifToolOutRow[2] & "> =? <" & $arrLvwRow[2] & "> *AND* <" & $arrExifToolOutRow[1] & "> =? <" & $arrLvwRow[1] & ">" & @LF
;~ 					FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", $erg)
;~ 					;debug - end   ##################################################

					If StringLeft($arrExifToolOutRow[4], 259-4) = StringLeft($arrLvwRow[4], 259-4) And $arrExifToolOutRow[2] = $arrLvwRow[2] And $arrExifToolOutRow[1] = $arrLvwRow[1] Then
;~ 						;debug - begin ##################################################
;~ 						FileWrite(@ScriptDir & "\OpenEditTag_XPath.log", "Treffer!" & @LF)
;~ 						;debug - end   ##################################################
						$arrXMLTagDBTagListRow = StringSplit($arrXMLTagDBTagList[$i], @TAB) ;*** [1]=TagNam [2]=TagG0 [3]=TagG1 [4]=TagG2 [5]=TagWR [6]=TagFL
;~ 						$arrLvwRow[1] = $arrXMLTagDBTagListRow[3] ;$arrXMLTagDBTagListRow[3] enthlt TagGrp1 ;Test: G1 statt G0 => Geht nicht, da TagGrp:TagNam dann nicht mehr in Ini-[LineBreaks] gefunden wird
						$arrLvwRow[1] = $arrXMLTagDBTagListRow[2] ;$arrXMLTagDBTagListRow[2] enthlt TagGrp0
						$arrLvwRow[3] = $arrXMLTagDBTagListRow[1] ;$arrXMLTagDBTagListRow[1] enthlt TagNam
						If $arrXMLTagDBTagListRow[5] = "true" Then
							$intEditControlsState = $GUI_ENABLE
							$strEditControlsStateReason = ""
						Else
							$strEditControlsStateReason = '"writable"-attribute of tag = false'
						EndIf
						If StringInStr($arrXMLTagDBTagListRow[6], "List") > 0 Then $booEditTagList = True
;~ 						If $arrXMLTagDBTagListRow[3] & ":" & $arrXMLTagDBTagListRow[1] = "XMP-MP:RegionPersonDisplayName" _
;~ 						Or $arrXMLTagDBTagListRow[3] & ":" & $arrXMLTagDBTagListRow[1] = "XMP-MP:Rectangle" Then $booEditTagStruct = True ;Todo: In INI-Section [LineBreaks] suchen
						If $arrXMLTagDBTagListRow[1] = "RegionPersonDisplayName" Or $arrXMLTagDBTagListRow[1] = "Rectangle" Then $booEditTagStruct = True ;Todo: In INI-Section [LineBreaks] suchen
						ExitLoop
					EndIf
				Next

			EndIf

		EndIf

	EndIf

	GUICtrlSetData($lblEditTagGrpNam, $arrLvwRow[1] & ":" & $arrLvwRow[3])
	$arrTagMapping = IniReadSection($cstrIniFile, "TagMapping")
	$intTagMappingIdx = _ArraySearch($arrTagMapping, $arrLvwRow[1] & ":" & $arrLvwRow[3], 0, 0, 0, 1, 1, 1)
	If $intTagMappingIdx = -1 Then
		GUICtrlSetData($cbxEditTagGrpNamTarget, "")
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_DISABLE)
	Else
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_ENABLE)
		GUICtrlSetData($cbxEditTagGrpNamTarget, "")
		GUICtrlSetData($cbxEditTagGrpNamTarget, $arrTagMapping[$intTagMappingIdx][1], $arrLvwRow[1] & ":" & $arrLvwRow[3])
	EndIf
	GUICtrlSetData($cbxEditTagGrpNamTarget, $arrLvwRow[1] & ":" & $arrLvwRow[3])
	GUICtrlSetState($radioEditTagChg, $intEditControlsState+$GUI_CHECKED)
	GUICtrlSetState($radioEditTagDel, $intEditControlsState+$GUI_UNCHECKED)
	GUICtrlSetState($radioEditTagCpy, $intEditControlsState+$GUI_UNCHECKED)
	GUICtrlSetState($radioEditTagMov, $intEditControlsState+$GUI_UNCHECKED)
	GUICtrlSetState($btnEditSaveCur, $intEditControlsState)
	GUICtrlSetState($chkEditSaveAll, $intEditControlsState)
	GUICtrlSetState($chkEditSaveAllOpt, $intEditControlsState)
	GUICtrlSetData($lblEditSaveCur, $strEditControlsStateReason)
	$strWritableTags = ""

	$arrLineBreaks = IniReadSection($cstrIniFile, "LineBreaks")
	$intLineBreaksIdx = _ArraySearch($arrLineBreaks, $arrLvwRow[1] & ":" & $arrLvwRow[3], 1, 0, 0, 0, 1, 0)
	If $arrLvwRow[1] & ":" & $arrLvwRow[3] = "MWG:Description" Then $intLineBreaksIdx = 1 ;Test MWG
	If $arrLvwRow[1] & ":" & $arrLvwRow[3] = "MWG:Keywords" Or $arrLvwRow[1] & ":" & $arrLvwRow[3] = "MWG:Creator" Then $booEditTagList = True ;Test MWG
	$strEditTagVal = $arrLvwRow[4]
;~ 	ConsoleWrite($arrLvwRow[1] & ":" & $arrLvwRow[3] & " = " & $intLineBreaksIdx & @CR)  ;debug

	If $booEditTagStruct = True Then
		GUICtrlSetState($txtEditTagVal, $GUI_HIDE)
		GUICtrlSetState($lvwEditTagVal, $GUI_SHOW)

		GUICtrlSetState($lbxEditTagList, $GUI_SHOW)
		GUICtrlSetState($txtEditTagListQuickfilter, $GUI_SHOW)
		GUICtrlSetState($icoEditTagListQuickfilter, $GUI_SHOW)
		;GUICtrlSetState($chkEditTagActionOpt, $GUI_SHOW)
		GUICtrlSetData($lbxEditTagList, "")
		$arrCategoriesKeywordsPersons = IniReadSection($cstrIniFile, "Persons")
		For $i = 1 To $arrCategoriesKeywordsPersons[0][0]
			$arrCategoriesKeywordsPersons[$i][1] = StringToUTF8($arrCategoriesKeywordsPersons[$i][1])
			GUICtrlSetData($lbxEditTagList, $arrCategoriesKeywordsPersons[$i][1] & "|")
		Next

		#cs
		$strExifToolParam = ' -X -struct -XMP-MP:All "' & $strTCPathCur & $strTCFileCur & '" >"' & $cstrTmpFile & '_XMP-MP.xml"'
		$strExifToolOut = RunExifTool("GetXMPMP", $strExifToolParam, -1)

		_XMLFileOpen($cstrTmpFile & "_XMP-MP.xml", "xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:XMP-MP='http://ns.exiftool.ca/XMP/XMP-MP/1.0/'")

		$strXPath = "//XMP-MP:Regions/rdf:Bag/rdf:li"
		$intXMLTagDBNodeCount = _XMLGetNodeCount($strXPath)

		_GUICtrlListView_DeleteAllItems($hlvwEditTagVal)
		_GUICtrlListView_AddItem($hlvwEditTagVal, $arrLocStr[139]) ;[New region]
		;If $intImgPreW > $intImgPreH Then
			_GUICtrlListView_AddSubItem($hlvwEditTagVal, 0, "0.400000, 0.400000, 0.200000, " & Round((0.200000 * $intImgPreW) / $intImgPreH, 6), 1)
		;Else
		;	_GUICtrlListView_AddSubItem($hlvwEditTagVal, 0, "0.400000, 0.400000, " & Round((0.200000 * $intImgPreH) / $intImgPreW, 6) & ", 0.200000", 1)
		;EndIf
		For $i = 1 To $intXMLTagDBNodeCount

			$strPersonName = ""
			$arrXMLGetValue = _XMLGetValue($strXPath & "[" & $i & "]/XMP-MP:PersonDisplayName")
			If Not @error Then $strPersonName = $arrXMLGetValue[1]

			$strRectangle = ""
			$arrXMLGetValue = _XMLGetValue($strXPath & "[" & $i & "]/XMP-MP:Rectangle")
			If Not @error Then $strRectangle = $arrXMLGetValue[1]

			_GUICtrlListView_AddItem($hlvwEditTagVal, $strPersonName)
			_GUICtrlListView_AddSubItem($hlvwEditTagVal, $i-1+1, $strRectangle, 1)

		Next
		$intXMLTagDBOpen = 0
		#ce

		;*** Ausgabebeispiel:
		;*** Region Info MP                  : {Regions=[{PersonDisplayName=John Doe,Rectangle=0.278639|, 0.255615|, 0.087938|, 0.117251},{PersonDisplayName=,Rectangle=},]}
		$strExifToolParam = "-struct" & @CRLF & "-XMP:RegionInfoMP" & @CRLF
		;If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
		;	$strExifToolParam &= "-srcfile" & @CRLF
		;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
		;EndIf
		$strExifToolOut = FeedExifTool("ReadMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
		If Not @error Then
			_GUICtrlListView_DeleteAllItems($hlvwEditTagVal)
			_GUICtrlListView_AddItem($hlvwEditTagVal, $arrLocStr[139]) ;[New region]
			;If $intImgPreW > $intImgPreH Then
				_GUICtrlListView_AddSubItem($hlvwEditTagVal, 0, "0.400000, 0.400000, 0.200000, " & Round((0.200000 * $intImgPreW) / $intImgPreH, 6), 1)
			;Else
			;	_GUICtrlListView_AddSubItem($hlvwEditTagVal, 0, "0.400000, 0.400000, " & Round((0.200000 * $intImgPreH) / $intImgPreW, 6) & ", 0.200000", 1)
			;EndIf
			$arrRegExpResult = StringRegExp($strExifToolOut, '\{PersonDisplayName=(.+?)(,Rectangle=(.+?)){0,1}(\})', 3) ;[1]=PersonDisplayName; [3]=Rectangle
			For $intRegExpResultIdx = 0 To UBound($arrRegExpResult) / 4 - 1
;~ 				_GUICtrlListView_AddItem($hlvwEditTagVal, BinaryToString($arrRegExpResult[$intRegExpResultIdx*4+0], 4))
				;*** "[" (eckige Klammer) in Werten (hier: PersonDisplayName) werden von Exiftool mit "|" (Pipe) maskiert; diese Werte werden in der Listbox
				;***  korrekt angezeigt (z.B. "|[NameDerPerson]"), beim Klick auf einen solchen Wert gibt es dann aber in Func My_WM_NOTIFY()
				;***  beim Zugriff auf die Rectangle-Daten (Split durch $arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwEditTagVal)) einen Fehlerabbruch.
				;*** Daher vor Befllen der Listbox Entfernen aller "|" aus den Werten
				_GUICtrlListView_AddItem($hlvwEditTagVal, BinaryToString(StringReplace($arrRegExpResult[$intRegExpResultIdx*4+0], "|", ""), 4))
				_GUICtrlListView_AddSubItem($hlvwEditTagVal, $intRegExpResultIdx+1, StringReplace($arrRegExpResult[$intRegExpResultIdx*4+2], "|", ""), 1)
			Next
		EndIf

	ElseIf $intLineBreaksIdx > -1 Or $booEditTagList = True Then
		If $intEditControlsState = $GUI_ENABLE Then
			GUICtrlSetStyle($txtEditTagVal, $ES_MULTILINE+$WS_TABSTOP+$ES_WANTRETURN+$WS_VSCROLL+$ES_AUTOVSCROLL)
		Else
			GUICtrlSetStyle($txtEditTagVal, $ES_MULTILINE+$WS_TABSTOP+$ES_WANTRETURN+$WS_VSCROLL+$ES_AUTOVSCROLL+$ES_READONLY)
		EndIf
		$strExifToolParam = " -b"
		$strExifToolParam &= " -" & $arrLvwRow[1] & ":" & $arrLvwRow[3]
		;If $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
		;	$strExifToolParam &= " -srcfile %d%f." & $strSidecarFileType
		;EndIf
		$strExifToolParam &= ' "' & $strTCPathCur & $strTCFileCur & '"'
		$strExifToolParam &= ' >"' & $cstrTmpFile & "_BinaryData.bin" & '"'
		;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
		;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
		$strExifToolOut = RunExifTool("ExtractBinData", $strExifToolParam, 1)

		;*** Todo: Ermitteln: Welche Konstellationen fhren dazu, dass *.bin-File physisch leer angelegt wird?
		#cs
		If FileGetSize($cstrTmpFile & "_BinaryData.bin") = 0 Then
			$strExifToolParam = " -b"
;~ 			If $booConvert = True Then $strExifToolParam &= " -L"
;~ 			$strExifToolParam &= " -" & $arrLineBreaks[$intLineBreaksIdx][0]
			$strExifToolParam &= " -" & $arrLvwRow[1] & ":" & $arrLvwRow[3]
			$strExifToolParam &= ' "' & $strTCPathCur & $strTCFileCur & '"'
			$strExifToolParam &= ' >"' & $cstrTmpFile & "_BinaryData.bin" & '"'
			;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
			;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
			$strExifToolOut = RunExifTool("ExtractBinData", $strExifToolParam, -1)
		EndIf
		#ce

		$strEditTagVal = FileRead($cstrTmpFile & "_BinaryData.bin")
		$strEditTagVal = StringReplace($strEditTagVal, @LF, @CRLF)

		If $booEditTagList = True And $intEditControlsState = $GUI_ENABLE Then
			GUICtrlSetPos($txtEditTagVal, 5, 23, 185, 150)
			GUICtrlSetState($lbxEditTagList, $GUI_SHOW)
			GUICtrlSetState($txtEditTagListQuickfilter, $GUI_SHOW)
			GUICtrlSetState($icoEditTagListQuickfilter, $GUI_SHOW)
			GUICtrlSetState($chkEditTagActionOpt, $GUI_SHOW)

			GUICtrlSetData($lbxEditTagList, "")
			Select
				Case $arrLvwRow[3] = "SupplementalCategories"
					$strIniSection = "Categories"
				Case $arrLvwRow[3] = "PersonInImage"
					$strIniSection = "Persons"
;~ 				Case $arrLvwRow[1] & ":" & $arrLvwRow[3] = "IPTC:Keywords" Or $arrLvwRow[1] & ":" & $arrLvwRow[3] = "XMP:Subject"
				Case $arrLvwRow[1] & ":" & $arrLvwRow[3] = "IPTC:Keywords" Or $arrLvwRow[1] & ":" & $arrLvwRow[3] = "XMP:Subject" Or $arrLvwRow[1] & ":" & $arrLvwRow[3] = "MWG:Keywords" ;Test MWG
					$strIniSection = "Keywords"
				Case Else
					$strIniSection = ""
			EndSelect

			If $strIniSection <> "" Then
				$arrCategoriesKeywordsPersons = IniReadSection($cstrIniFile, $strIniSection)
				For $i = 1 To $arrCategoriesKeywordsPersons[0][0]
					$arrCategoriesKeywordsPersons[$i][1] = StringToUTF8($arrCategoriesKeywordsPersons[$i][1])
					GUICtrlSetData($lbxEditTagList, $arrCategoriesKeywordsPersons[$i][1] & "|")
				Next
			EndIf

		EndIf
	Else
		If $intEditControlsState = $GUI_ENABLE Then
			GUICtrlSetStyle($txtEditTagVal, $WS_TABSTOP)
		Else
			GUICtrlSetStyle($txtEditTagVal, $WS_TABSTOP+$ES_READONLY)
		EndIf

	EndIf

	GUICtrlSetData($txtEditTagVal, $strEditTagVal)

	;*** Prfen, ob Tag bereits im aktuellen CustView verwendet wird. Falls ja, [+]-Button im Edit-Dialog disablen
	GUICtrlSetData($btnEditAddTagToCustView, "+")
	GUICtrlSetTip($btnEditAddTagToCustView, StringReplace($arrLocStr[71], "%custview", $strCustomView))
	GUICtrlSetState($btnEditAddTagToCustView, $GUI_ENABLE)
	If _ArraySearch($arrIniSectionNames, $strCustomView) = -1 Then
		GUICtrlSetState($btnEditAddTagToCustView, $GUI_DISABLE)

	Else
		$arrCustomTags = IniReadSection($cstrIniFile, $strCustomView)
		For $i = 1 To $arrCustomTags[0][0]
			If StringInStr($arrCustomTags[$i][1], $arrLvwRow[1] & "." & $arrLvwRow[3]) > 0 Then
				GUICtrlSetData($btnEditAddTagToCustView, "-")
				GUICtrlSetTip($btnEditAddTagToCustView, StringReplace($arrLocStr[70], "%custview", $strCustomView))
				If IniRead($cstrIniFile, $strCustomView, GUICtrlRead($lblEditTagGrpNam), "") <> "[=" & StringReplace(GUICtrlRead($lblEditTagGrpNam), ":", ".") & "]" Then
					GUICtrlSetState($btnEditAddTagToCustView, $GUI_DISABLE)
				EndIf
				ExitLoop
			EndIf
		Next

;~ 		If IniRead($cstrIniFile, $strCustomView, GUICtrlRead($lblEditTagGrpNam), "") = "[=" & StringReplace(GUICtrlRead($lblEditTagGrpNam), ":", ".") & "]" Then
;~ 			GUICtrlSetData($btnEditAddTagToCustView, "-")
;~ 			GUICtrlSetState($btnEditAddTagToCustView, $GUI_ENABLE)
;~ 		EndIf

	EndIf

	SetEditTagAction()

	SetWinOnTopState(0)

	;GUICtrlSetColor($lblStatus, 0x008000)
	GUICtrlSetData($lblStatus, $arrLocStr[63])

	#cs
	$x = $intTCInactivePanelX-550
	If $x < 1 Then $x = 1
;~ 	$y = $intTCInactivePanelY + Int($intTCInactivePanelH * ($intPanelDivider/100)) + 20
;~ 	If $y+244 > @DesktopHeight Then $y = @DesktopHeight - 244
;~ 	WinMove($frmEdit, "", $x, $y)
	WinMove($frmEdit, "", $x, Default)
	#ce
	GUISetState(@SW_SHOW, $frmEdit)
	GUISwitch($frmEdit)
	ControlFocus($frmEdit, "", $txtEditTagVal)

EndFunc ;Func OpenEditTagDialog($intLvwItemIdx)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func EditTagValAdd()
	$strEditTagValAdd = GUICtrlRead($lbxEditTagList)
	;*** Scrollen zur nchsten Abschnittsberschrift
	If StringInStr($strEditTagValAdd, $strListBoxHeaderIndicator) > 0 Then
;~ 	If StringLeft($strEditTagValAdd, 3) = $strListBoxHeaderIndicator Then
		$intLbxIdx = _GUICtrlListBox_GetCurSel($lbxEditTagList)
		$intLbxIdx = _GUICtrlListBox_FindInText($lbxEditTagList, $strListBoxHeaderIndicator, $intLbxIdx, True)
		_GUICtrlListBox_SetTopIndex($lbxEditTagList, $intLbxIdx)
		Return
	EndIf

	If $booEditTagStruct = True Then
		If _GUICtrlListView_FindText($hlvwEditTagVal, $strEditTagValAdd, -1, False) > -1 Then Return
		_GUICtrlListView_AddItem($hlvwEditTagVal, $strEditTagValAdd)

	Else
		$strEditTagVal = GUICtrlRead($txtEditTagVal)
		If StringInStr($strEditTagVal, $strEditTagValAdd) = 0 Then
			If $strEditTagVal = "" Then
				GUICtrlSetData($txtEditTagVal, $strEditTagValAdd)
			Else
				GUICtrlSetData($txtEditTagVal, $strEditTagVal & @CRLF & $strEditTagValAdd)
			EndIf
		EndIf

	EndIf

EndFunc ;Func EditTagValAdd()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func AddTagToCustView()
	If GUICtrlRead($btnEditAddTagToCustView) = "+" Then
		If IniWrite($cstrIniFile, $strCustomView, GUICtrlRead($lblEditTagGrpNam), "[=" & StringReplace(GUICtrlRead($lblEditTagGrpNam), ":", ".") & "]") = 1 Then
			GUICtrlSetData($btnEditAddTagToCustView, "-")
			GUICtrlSetTip($btnEditAddTagToCustView, StringReplace($arrLocStr[70], "%custview", $strCustomView))
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & GUICtrlRead($lblEditTagGrpNam) & @LF & StringReplace($arrLocStr[71], "%custview", $strCustomView))
		EndIf
	Else
		If IniDelete($cstrIniFile, $strCustomView, GUICtrlRead($lblEditTagGrpNam)) = 1 Then
			GUICtrlSetData($btnEditAddTagToCustView, "")
			GUICtrlSetState($btnEditAddTagToCustView, $GUI_DISABLE)
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & GUICtrlRead($lblEditTagGrpNam) & @LF & StringReplace($arrLocStr[70], "%custview", $strCustomView))
		EndIf
	EndIf
EndFunc ;Func AddTagToCustView()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ViewTagValBinary()
	;*** Extraktion mit Option "-b" verhindert nicht, dass ExifTool eine Zeichensatzkonvertierung vornimmt!!!
	#cs
	$strExifToolParam = "-b -" & GUICtrlRead($lblEditTagGrpNam)
	$strExifToolParam &= ' "' & $strTCPathCur & $strTCFileCur & '"'
	$strExifToolParam &= ' >"' & $cstrTmpFile & "_BinaryData.bin" & '"'
	$strExifToolOut = RunExifTool("ViewBinData", $strExifToolParam, -1)
	ShellExecute(EnvGet("COMMANDER_PATH") & "\TotalCmd.exe", "/S=L:AT3 " & '"' & $cstrTmpFile & "_BinaryData.bin" & '"')
	#ce

	$strExifToolParam = "-v5 -" & GUICtrlRead($lblEditTagGrpNam)
	$strExifToolParam &= ' "' & $strTCPathCur & $strTCFileCur & '"'
	$strExifToolParam &= ' >"' & $cstrTmpFile & "_BinaryData.bin" & '"'
	$strExifToolOut = RunExifTool("ViewBinData", $strExifToolParam, 1)
	ShellExecute(EnvGet("COMMANDER_PATH") & "\TotalCmd.exe", "/S=L:AT1 " & '"' & $cstrTmpFile & "_BinaryData.bin" & '"')

	;Test - Beginn
	WinWait("Lister - [" & $cstrTmpFile & "_BinaryData.bin" & "]", "", 5)
	WinActivate("Lister - [" & $cstrTmpFile & "_BinaryData.bin" & "]")
	Send("^f")
	Sleep(200)
	Send(StringMid(GUICtrlRead($lblEditTagGrpNam), StringInStr(GUICtrlRead($lblEditTagGrpNam), ":") + 1) & " = ")
	Sleep(200)
	Send("{ENTER}")
	;Test - Ende

	#cs
	$strExifToolParam = "-v5" & @CRLF & "-" & GUICtrlRead($lblEditTagGrpNam) & @CRLF
	$strExifToolOut = FeedExifTool("ViewBinData", $strExifToolParam, $strTCPathCur & $strTCFileCur, -1, "Def")
	$arrExifToolOut = StringSplit($strExifToolOut, @CRLF, 1)
	$strEditTagNam = StringMid(GUICtrlRead($lblEditTagGrpNam), StringInStr(GUICtrlRead($lblEditTagGrpNam), ":") + 1)
;~ 	FileDelete($cstrTmpFile & "_BinaryData.bin")
	$strTmp = "" ;debug
	$booTmp = False

	For $i = 1 To $arrExifToolOut[0]

		If $booTmp = False Then
			$arrRegExpResult = StringRegExp($arrExifToolOut[$i], '^(.+)(' & $strEditTagNam & ' = .+)', 3)
			If Not @error Then
				$strTmp &= $arrRegExpResult[1] & @LF
				$strTmp &= StringTrimLeft($arrExifToolOut[$i+1], StringLen($arrRegExpResult[0])+2) & @LF
				$booTmp = True
				$i += 2
			EndIf
		EndIf

		If $booTmp = True Then
;~ 			$arrRegExpResult = StringRegExp($arrExifToolOut[$i], '^(.+)(....: )(.. ){16}(\[.+\])', 3)
			$arrRegExpResult = StringRegExp($arrExifToolOut[$i], '^(.+)(....: )(.. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. )(\[.+\])', 3)
			If Not @error Then
				$strTmp &= $arrRegExpResult[1] & $arrRegExpResult[2] & "["
				For $j = 0 To 15
					$c = StringMid($arrRegExpResult[2], $j*3+1, 2)
					If $c <> "  " Then $strTmp &= Chr("0x" & $c)
				Next
				$strTmp &= "]" & @LF
			Else
				$booTmp = False
			EndIf
		EndIf

	Next

	MsgBox(0, "", $strTmp) ;debug
	#ce

EndFunc ;Func ViewTagValBinary()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetEditTagAction()
	;*** ndern
	If GUICtrlRead($radioEditTagChg) = $GUI_CHECKED Then
		GUICtrlSetData($chkEditTagActionOpt, $arrLocStr[89])
		GUICtrlSetData($chkEditSaveAllOpt, $arrLocStr[92])
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_DISABLE)
	EndIf
	;*** Lschen
	If GUICtrlRead($radioEditTagDel) = $GUI_CHECKED Then
		GUICtrlSetData($chkEditTagActionOpt, $arrLocStr[90])
		GUICtrlSetData($chkEditSaveAllOpt, $arrLocStr[93])
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_DISABLE)
	EndIf
	;*** Kopieren
	If GUICtrlRead($radioEditTagCpy) = $GUI_CHECKED Then
		GUICtrlSetData($chkEditTagActionOpt, $arrLocStr[89] & "; " & $arrLocStr[90])
		GUICtrlSetData($chkEditSaveAllOpt, $arrLocStr[92])
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_ENABLE)
	EndIf
	;*** Verschieben
	If GUICtrlRead($radioEditTagMov) = $GUI_CHECKED Then
		GUICtrlSetData($chkEditTagActionOpt, $arrLocStr[89] & "; " & $arrLocStr[90])
		GUICtrlSetData($chkEditSaveAllOpt, $arrLocStr[92])
		GUICtrlSetState($cbxEditTagGrpNamTarget, $GUI_ENABLE)
	EndIf

	If GUICtrlRead($chkEditSaveAll) = $GUI_CHECKED Then
		GUICtrlSetState($chkEditSaveAllOpt, $GUI_ENABLE)
	Else
		GUICtrlSetState($chkEditSaveAllOpt, $GUI_UNCHECKED)
		GUICtrlSetState($chkEditSaveAllOpt, $GUI_DISABLE)
	EndIf
EndFunc ;Func SetEditTagAction()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetXMPLabel()

	If $booUnicodeFilename = True Then
		MsgBox(64+262144, $cstrTCMetadataViewerVersion, "SetXMPLabel" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
		Return
	EndIf

	$strXMPLabelNew = ""
	Switch @GUI_CTRLID
		Case $icoXMPLabelRed
			$strXMPLabelColor = "Red"
		Case $icoXMPLabelYellow
			$strXMPLabelColor = "Yellow"
		Case $icoXMPLabelGreen
			$strXMPLabelColor = "Green"
		Case $icoXMPLabelBlue
			$strXMPLabelColor = "Blue"
		Case $icoXMPLabelPurple
			$strXMPLabelColor = "Purple"
	EndSwitch

	$arrXMPLabel = StringSplit($strXMPLabel, "|")
	$booXMPLabelIsNew = True
	;*** Wenn noch gar kein Label gesetzt ist, dann wrde die For..Next-Schleife unerwnschtermaen trotzdem 1 durchlaufen werden (mit $arrXMPLabel[1] = "")
	;*** Verhindern, indem Schleifenzhler-Obergrenze < Schleifenzhler-Untergrenze gesetzt wird
	If $arrXMPLabel[1] = "" Then $arrXMPLabel[0] = 0

	For $i = 1 To $arrXMPLabel[0]
		$strXMPLabelColorCur = IniRead($cstrIniFile, "LabelsMapTag2DispColor", $arrXMPLabel[$i], $arrXMPLabel[$i])
		;*** Ein bereits gesetztes Label wurde angeklickt => Lschen
		If $strXMPLabelColor = $strXMPLabelColorCur Then
			$booXMPLabelIsNew = False
			GUICtrlSetImage(Eval("icoXMPLabel" & $strXMPLabelColor), $cstrIcoDir & "\Label_Dark_Pend.ico", 0)
			;*** Icon wird bei grenverndertem TC-Panel (z.B.: Window wurde resized, Panel-Divider wurde verschoben) falsch plaziert (Icon "wandert"); Versuch, den Moment der Fehlplazierung so kurz wie mglich zu halten
			$p = StringInStr("RYGBP", StringLeft($strXMPLabelColor, 1))
			GUICtrlSetPos(Eval("icoXMPLabel" & $strXMPLabelColor), $intTCInactivePanelW - 53, 179+15 + $p*14)
		Else
			$strXMPLabelNew &= IniRead($cstrIniFile, "LabelsMapDispColor2Tag", $strXMPLabelColorCur, $arrXMPLabel[$i]) & "|"
		EndIf
	Next

	If $booXMPLabelIsNew = True Then
		If $intAllowMultLabel = 1 Then
			$strXMPLabelNew &= IniRead($cstrIniFile, "LabelsMapDispColor2Tag", $strXMPLabelColor, $strXMPLabelColor) & "|"
		Else
			$strXMPLabelNew = IniRead($cstrIniFile, "LabelsMapDispColor2Tag", $strXMPLabelColor, $strXMPLabelColor) & "|"
		EndIf
		GUICtrlSetImage(Eval("icoXMPLabel" & $strXMPLabelColor), $cstrIcoDir & "\Label_" & $strXMPLabelColor & "_Pend.ico", 0)
		;*** Icon wird bei grenverndertem TC-Panel (z.B.: Window wurde resized, Panel-Divider wurde verschoben) falsch plaziert (Icon "wandert"); Versuch, den Moment der Fehlplazierung so kurz wie mglich zu halten
		$p = StringInStr("RYGBP", StringLeft($strXMPLabelColor, 1))
		GUICtrlSetPos(Eval("icoXMPLabel" & $strXMPLabelColor), $intTCInactivePanelW - 53, 179+15 + $p*14)
	EndIf
	$strXMPLabelNew = StringTrimRight($strXMPLabelNew, 1)

	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF

	;bookmark
	If $intUseSidecarFile = 1 Then
		If Not FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			ExportTagsToMIE($strTCPathCurOri, $strTCFileCurOri, $strSidecarFileType, "XMP:Label", False)
		EndIf
		;$strExifToolParam &= "-srcfile" & @CRLF
		;$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	EndIf

	If $intUpdateMetadataDate = 1 Then $strExifToolParam &= "-XMP:MetadataDate=" & @YEAR & ":" & @MON & ":" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF
	$strExifToolParam &= "-XMP:Label=" & $strXMPLabelNew & @CRLF
	$strExifToolOut = FeedExifTool("SetXMPLabel", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
	$booFileIsModified = True

	WinActivate($whTC)
	If $intMoveCursorToNextFileAfterSetXMPLabel = 1 Then
		If $intMoveCursorDirection = 1 Then
			Send("{Down}")
		Else
			Send("{Right}")
		EndIf
	Else
		$booFileIsModified = True ;Test
		$booRefresh = True
		$booRefreshMetadataOnly = True
	EndIf

EndFunc ;Func SetXMPLabel()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetXMPRating()

	If $booUnicodeFilename = True Then
		MsgBox(64+262144, $cstrTCMetadataViewerVersion, "SetXMPRating" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
		Return
	EndIf

	Local $i

	$strXMPRatingNew = ""
	Switch @GUI_CTRLID

		Case $icoXMPRating5
			$strXMPRatingNew = "5"

		Case $icoXMPRating4
			$strXMPRatingNew = "4"

		Case $icoXMPRating3
			$strXMPRatingNew = "3"

		Case $icoXMPRating2
			$strXMPRatingNew = "2"

		Case $icoXMPRating1
			$strXMPRatingNew = "1"

		Case $icoXMPRatingRej
			$strXMPRatingNew = "-1"
			If $strLayoutXMPRating = "Stars" Then
				If $intXMPRatingOld = -1 Then
					$strXMPRatingNew = ""
					GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\NotRatingRej.ico", 0)
				Else
					For $i = 1 To 5
						GUICtrlSetImage(Eval("icoXMPRating" & $i), $cstrIcoDir & "\Stars0.ico", 0)
					Next
					GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\RatingRej.ico", 0)
				EndIf
				GUICtrlSetPos($icoXMPRatingRej, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY)
			Else
				If $intXMPRatingOld = -1 Then
					$strXMPRatingNew = ""
					GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\NotRatingRej.ico", 0)
				Else
					GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRatingOld), $cstrIcoDir & "\NotRating_pend.ico", 0)
					GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRatingOld), $intTCInactivePanelW - 53, 80 + Abs($intXMPRatingOld-6)*15)
					GUICtrlSetImage($icoXMPRatingRej, $cstrIcoDir & "\RatingRej.ico", 0)
				EndIf
				GUICtrlSetPos($icoXMPRatingRej, $intTCInactivePanelW - 53, $intXMPRatingRMPIcoOffsetY)
			EndIf

		Case $icoXMPRatingMinus
			;*** Rating ist gar nicht gesetzt
			If $intXMPRatingOld = 0 Then Return
			;*** RatingMinus war gesetzt und soll nun aufgehoben werden
			If $fltXMPRatingOld < $intXMPRatingOld Then
				$strXMPRatingNew = $intXMPRatingOld
				GUICtrlSetImage($icoXMPRatingMinus, $cstrIcoDir & "\NotRatingMinus.ico", 0)
				GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
			;*** RatingMinus war *nicht* gesetzt und soll nun gesetzt werden; wenn RatingPlus gesetzt war, muss es aufgehoben werden
			Else
				$strXMPRatingNew = $intXMPRatingOld - 0.3
				GUICtrlSetImage($icoXMPRatingMinus, $cstrIcoDir & "\RatingMinus.ico", 0)
				GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
				GUICtrlSetImage($icoXMPRatingPlus, $cstrIcoDir & "\NotRatingPlus.ico", 0)
				GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)
			EndIf

		Case $icoXMPRatingPlus
			;*** Rating ist gar nicht gesetzt
			If $intXMPRatingOld = 0 Then Return
			;*** RatingPlus war gesetzt und soll nun aufgehoben werden
			If $fltXMPRatingOld > $intXMPRatingOld Then
				$strXMPRatingNew = $intXMPRatingOld
				GUICtrlSetImage($icoXMPRatingPlus, $cstrIcoDir & "\NotRatingPlus.ico", 0)
				GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)
			;*** RatingPlus war *nicht* gesetzt und soll nun gesetzt werden; wenn RatingMinus gesetzt war, muss es aufgehoben werden
			Else
				$strXMPRatingNew = $intXMPRatingOld + 0.3
				GUICtrlSetImage($icoXMPRatingMinus, $cstrIcoDir & "\NotRatingMinus.ico", 0)
				GUICtrlSetPos($icoXMPRatingMinus, $intTCInactivePanelW - 53+15, $intXMPRatingRMPIcoOffsetY)
				GUICtrlSetImage($icoXMPRatingPlus, $cstrIcoDir & "\RatingPlus.ico", 0)
				GUICtrlSetPos($icoXMPRatingPlus, $intTCInactivePanelW - 53+30, $intXMPRatingRMPIcoOffsetY)
			EndIf

	EndSwitch

	If @GUI_CtrlId <> $icoXMPRatingRej And @GUI_CtrlId <> $icoXMPRatingMinus And @GUI_CtrlId <> $icoXMPRatingPlus Then

		If $strLayoutXMPRating = "Stars" Then
			If $intXMPRatingOld = $strXMPRatingNew Then
				For $i = 1 To $strXMPRatingNew*1
					GUICtrlSetImage(Eval("icoXMPRating" & $i), $cstrIcoDir & "\Stars0.ico", 0)
				Next
				$strXMPRatingNew = ""
			Else
				For $i = 1 To $strXMPRatingNew*1
					GUICtrlSetImage(Eval("icoXMPRating" & $i), $cstrIcoDir & "\Stars1.ico", 0)
				Next
				For $i = $strXMPRatingNew*1 + 1 To 5
					GUICtrlSetImage(Eval("icoXMPRating" & $i), $cstrIcoDir & "\Stars0.ico", 0)
				Next
			EndIf
		Else
			GUICtrlSetPos(Eval("icoXMPRating" & $intXMPRatingOld), $intTCInactivePanelW - 53, 80 + Abs($intXMPRatingOld-6)*15)
			If $intXMPRatingOld = $strXMPRatingNew Then
				$strXMPRatingNew = ""
				GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRatingOld), $cstrIcoDir & "\NotRating_pend.ico", 0)
			Else
				GUICtrlSetImage(Eval("icoXMPRating" & $intXMPRatingOld), $cstrIcoDir & "\NotRating" & $intXMPRatingOld & ".ico", 0)
				GUICtrlSetImage(Eval("icoXMPRating" & $strXMPRatingNew), $cstrIcoDir & "\Rating" & $strXMPRatingNew & "_Pend.ico", 0)
				GUICtrlSetPos(Eval("icoXMPRating" & $strXMPRatingNew), $intTCInactivePanelW - 53, 80 + Abs($strXMPRatingNew*1-6)*15)
			EndIf
		EndIf

	EndIf

	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF

	;bookmark
	If $intUseSidecarFile = 1 Then
		If Not FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			ExportTagsToMIE($strTCPathCurOri, $strTCFileCurOri, $strSidecarFileType, "XMP:Rating", False)
		EndIf
		;$strExifToolParam &= "-srcfile" & @CRLF
		;$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	EndIf

	If $intUpdateMetadataDate = 1 Then $strExifToolParam &= "-XMP:MetadataDate=" & @YEAR & ":" & @MON & ":" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF
	$strExifToolParam &= "-XMP:Rating=" & $strXMPRatingNew & @CRLF
	$strExifToolOut = FeedExifTool("SetXMPRating", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
	$booFileIsModified = True

	WinActivate($whTC)
	If $intMoveCursorToNextFileAfterSetXMPRating = 1 Then
		If $intMoveCursorDirection = 1 Then
			Send("{Down}")
		Else
			Send("{Right}")
		EndIf
	Else
		$booFileIsModified = True ;Test
		$booRefresh = True
		$booRefreshMetadataOnly = True
	EndIf

EndFunc ;Func SetXMPRating()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;~ Func AddUserDefinedTag()
;~ #cs
;~ All XMP information is stored as character strings. The Writable column specifies the information format:
;~ string  : is an unformatted string
;~ integer : is a string of digits (possibly beginning with a '+' or '-')
;~ real    : is a floating point number
;~ rational: is entered as a floating point number but stored as two integer strings separated by a '/' character
;~ date    : is a date/time string entered in the format "YYYY:MM:DD HH:MM:SS[.SS][+/-HH:MM]"
;~ boolean : is either "True" or "False"
;~ lang-alt: is a list of string alternatives in different languages.
;~ #ce
;~ #cs
;~ TagName => {
;~   AutoSplit => 1,
;~   Description => '...',
;~   Groups => { },
;~   List => '...',
;~   Name => '...',
;~   PrintConv => ..., ODER '...', ODER { },
;~   PrintConvInv => '...',
;~   SeparateTable => '...',
;~   Writable => '...',
;~ #ce
;~ EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SaveEditTag()

	$strEditSaveTS = @YEAR & @MON & @MDAY & "_" & @HOUR & @MIN & @SEC

	$strEditTagValRaw = GUICtrlRead($txtEditTagVal)
	$strEditTagVal = $strEditTagValRaw
	#cs
	$strEditTagVal = StringReplace($strEditTagVal, '&', "&amp;")
	$strEditTagVal = StringReplace($strEditTagVal, "'", "&#39;")
	$strEditTagVal = StringReplace($strEditTagVal, '"', "&quot;")
	$strEditTagVal = StringReplace($strEditTagVal, '>', "&gt;")
	$strEditTagVal = StringReplace($strEditTagVal, '<', "&lt;")
	#ce

	;*** Wenn der Input aus dem Edit-Dialog stammt, kann StringEncoding() *nicht* zur Bestimmung des Encodings benutzt werden!
	$booWriteUTF8 = False
	If $strEditTagVal <> BinaryToString($strEditTagVal, 1) Then $booWriteUTF8 = True
	If $booAlwaysWriteUTF8 = True Then $booWriteUTF8 = True
;~ 	$strTmp = "|EXIF:UserComment|EXIF:GPSProcessingMethod|EXIF:GPSAreaInformation|"
;~ 	If StringInStr($strTmp, "|" & GUICtrlRead($lblEditTagGrpNam) & "|") > 0 Then $booWriteUTF8 = True
	If StringInStr("|EXIF:XPTitle|EXIF:XPComment|EXIF:XPAuthor|EXIF:XPKeywords|EXIF:XPSubject|", "|" & GUICtrlRead($lblEditTagGrpNam) & "|") > 0 Then $booWriteUTF8 = True


	#cs
	If StringInStr(GUICtrlRead($lblEditTagGrpNam), "IPTC:") = 1 Then
		;*** Ermitteln, ob und welche Zeichencodierung fr IPTC-Tags festgelegt ist
		;ToDo: Wenn "Alle markierten Dateien" gesetzt ist, msste *jede* Datei auf ihre Zeichencodierung geprft werden (und nicht nur die fokussierte)
		$strExifToolParam = "-G0" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF
		$strExifToolParam &= "-IPTC:CodedCharacterSet" & @CRLF
;~ 		$strExifToolParam &= $strTCPathCur & $strTCFileCur & @CRLF
;~ 		$strExifToolOut = FeedExifTool("ReadSpecTags", $strExifToolParam)
		$strExifToolOut = FeedExifTool("ReadSpecTags", $strExifToolParam, $strTCPathCur & $strTCFileCur, -1, "Def")
		$arrTagListSpecial = StringSplit($strExifToolOut, @CRLF, 1)
		$arrTag = SplitTagListRec($arrTagListSpecial[1])
		If StringLower($arrTag[4]) = "utf8" Then
			$booWriteUTF8 = True
		Else
			;*** Konvertieren aller IPTC-Tags nach UTF-8
			;ToDo: Wenn "Alle markierten Dateien" gesetzt ist, muss *jede* Datei nach UTF-8 konvertiert werden (und nicht nur die fokussierte)
			If $booWriteUTF8 = True Then
				#cs
				The following command changes the internal IPTC encoding to UTF-8:
					exiftool -TagsFromFile @ -iptc:all -codedcharacterset=utf8 {File.jpg}
				and this command changes it back from UTF-8 to Windows Latin1 (cp1252):
					exiftool -TagsFromFile @ -iptc:all -codedcharacterset=  {File.jpg}
				or this command changes it back from UTF-8 to Windows Latin2 (cp1250):
					exiftool -TagsFromFile @ -iptc:all -codedcharacterset= -charset iptc=latin2  {File.jpg}
				#ce
				$strExifToolParam = "-P" & @CRLF
				If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
				$strExifToolParam = "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=utf8" & @CRLF
;~ 				$strExifToolParam &= $strTCPathCur & $strTCFileCur & @CRLF
;~ 				$strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParam)
				$strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParam, $strTCPathCur & $strTCFileCur, -1, "Def")
			EndIf
		EndIf
	EndIf
	#ce


	If StringInStr(GUICtrlRead($lblEditTagGrpNam), "XMP:") = 1 Then $booWriteUTF8 = True

	$strExifToolParam = "-progress" & @CRLF ;debug
	$strExifToolParam &= "-P" & @CRLF ;debug
;~ 	$strExifToolParam = "-P" & @CRLF
	$strExifToolFiles = ""
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF

	$strExifToolParamCvIPTC = "" ;Encoding IPTC-Tags
	$strExifToolFilesCvIPTC = "" ;Encoding IPTC-Tags
	If $booWriteUTF8 = True Then
		If $strArgFileEncoding = "ANSI" Then RestartExifTool("UTF8")
;~ 		GUICtrlSetData($lblEditSaveCur, "Encoding on Save: UTF-8")
		GUICtrlSetData($lblEditSaveCur, "Will try to save UTF-8 encoded values")
		$strExifToolParamCvIPTC = "-P" & @CRLF ;Encoding IPTC-Tags
		If $booBackup = False Then $strExifToolParamCvIPTC &= "-overwrite_original_in_place" & @CRLF ;Encoding IPTC-Tags
		$strExifToolParamCvIPTC &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=utf8" & @CRLF ;Encoding IPTC-Tags
	Else
		If $strArgFileEncoding = "UTF8" Then RestartExifTool("ANSI")
;~ 		GUICtrlSetData($lblEditSaveCur, "Encoding on Save: ANSI (" & $strExifToolCharEnc & ")")
		GUICtrlSetData($lblEditSaveCur, "Will try to save ANSI (" & $strExifToolCharEnc & ") encoded values")
		$strExifToolParam &= "-charset" & @CRLF & $strExifToolCharEnc & @CRLF
	EndIf

	;bookmark
	;If $intUseSidecarFile = 1 Then
	;	$strExifToolParam &= "-srcfile" & @CRLF
	;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	;	$strExifToolParamCvIPTC &= "-srcfile" & @CRLF
	;	$strExifToolParamCvIPTC &= "%d%f." & $strSidecarFileType & @CRLF
	;EndIf

	;*** Um das Datei-nderungsdatum mit ExifTool ndern zu knnen, darf die Datei nicht gleichzeitig inhaltlich verndert werden (hier: XMP:MetadataDate)
	;*** Die Option "-P" verhindert nderungen des FileModifyDate *nicht*.
	If $intUpdateMetadataDate = 1 And GUICtrlRead($lblEditTagGrpNam) <> "File:FileModifyDate" Then $strExifToolParam &= "-XMP:MetadataDate=" & @YEAR & ":" & @MON & ":" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @CRLF

	If GUICtrlRead($radioEditTagDel) = $GUI_CHECKED Then

		;*** Tags einer Struktur: Die komplette Struktur wird gelscht. Z.Z. *nur* fr XMP-MP:RegionInfoMP implementiert
;~ 		If BitAND(GUICtrlGetState($lvwEditTagVal), $GUI_SHOW) = $GUI_SHOW Then
		If $booEditTagStruct = True Then ;*** $booEditTagStruct ist True, wenn $strTagGrpTagNam = "XMP-MP:RegionPersonDisplayName" oder "XMP-MP:Rectangle"
			$strExifToolParam &= "-XMP-MP:RegionInfoMP=" & @CRLF

		;*** Prfen, ob im Edit-Dialog die Tag-Liste sichtbar ist, ob also ein Listen-Tag wie Keywords, SupplementalCategories, PersonInImage o.. editiert wird;
		ElseIf BitAND(GUICtrlGetState($lbxEditTagList), $GUI_SHOW) = $GUI_SHOW Then
			;*** Nur angegebene Begriffe (aus einer Liste existierender Begriffe) lschen
			If GUICtrlRead($chkEditTagActionOpt) = $GUI_CHECKED Then
				$arrEditTagVal = StringSplit($strEditTagVal, @CRLF, 1)
				For $i = 1 To $arrEditTagVal[0]
					;*** Duplikate (in ListBox) und leere Eintrge (in ListBox) berspringen
					If ($i = 1 Or _ArraySearch($arrEditTagVal, $arrEditTagVal[$i], 1, $i-1) = -1) And StringStripWS($arrEditTagVal[$i], 1+2) <> "" Then
						$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "-=" & $arrEditTagVal[$i] & @CRLF
					EndIf
				Next
			;*** Tag komplett lschen
			Else
				$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "=" & @CRLF
			EndIf

		;*** Nicht-Listen-Tags knnen nur komplett gelscht werden
		Else
			If GUICtrlRead($lblEditTagGrpNam) = "IPTC:CodedCharacterSet" Then
				$strExifToolParam &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=" & @CRLF ;Encoding IPTC-Tags
			Else
				$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "=" & @CRLF
			EndIf
		EndIf

	EndIf

	If GUICtrlRead($radioEditTagChg) = $GUI_CHECKED Then

		;*** Action "ndern": Wenn Option "Nur, wenn Tag noch nicht vorhanden" gesetzt ist, "-if"-Bedingung hinzufgen
		If GUICtrlRead($chkEditSaveAllOpt) = $GUI_CHECKED Then $strExifToolParam &= "-if" & @CRLF & "not $" & GUICtrlRead($lblEditTagGrpNam) & @CRLF

		;*** Prfen, ob im Edit-Dialog das Tag-Listview sichtbar ist, ob also Tags einer Struktur wie XMP-MP:RegionInfoMP o.. editiert werden
;~ 		If BitAND(GUICtrlGetState($lvwEditTagVal), $GUI_SHOW) = $GUI_SHOW Then
		If ControlCommand($frmEdit, "", $lvwEditTagVal, "IsVisible", "") = 1 Then

			$strExifToolParam &= "-XMP:RegionInfoMP={Regions=["
			For $i = 1 To _GUICtrlListView_GetItemCount($hlvwEditTagVal) - 1 ;*** Ersten Eintrag $i=0 = "{Neuer Eintrag}" = Dummy-Eintrag berspringen
				$strEditTagVal = _GUICtrlListView_GetItemText($hlvwEditTagVal, $i, 0)
				If $strEditTagVal = "" Then ContinueLoop ;*** Wenn PersonDisplayName leer ist, dann Eintrag berspringen = Eintrag lschen
				$strExifToolParam &= "{PersonDisplayName=" & $strEditTagVal
				$strEditTagVal = _GUICtrlListView_GetItemText($hlvwEditTagVal, $i, 1)
				If $strEditTagVal <> "" Then $strExifToolParam &= ",Rectangle=" & StringReplace($strEditTagVal, ",", "|,")
				$strExifToolParam &= "},"
			Next
			If StringRight($strExifToolParam, 2) = "}," Then $strExifToolParam = StringTrimRight($strExifToolParam, 1)
			$strExifToolParam &= "]}" & @CRLF

		;*** Prfen, ob im Edit-Dialog die Tag-Liste sichtbar ist, ob also ein Listen-Tag wie Keywords, SupplementalCategories, PersonInImage o.. editiert wird;
;~ 		ElseIf BitAND(GUICtrlGetState($lbxEditTagList), $GUI_SHOW) = $GUI_SHOW Then
		ElseIf ControlCommand($frmEdit, "", $lbxEditTagList, "IsVisible", "") = 1 Then

			;*** Fr die automatische Ergnzung des INI-Abschnitts "Categories" um neue Kategorien bereits definierte Kategorien laden
			If StringInStr(GUICtrlRead($lblEditTagGrpNam), ":SupplementalCategories") > 0 Then $arrCategoriesKeywordsPersons = IniReadSection($cstrIniFile, "Categories")

			$arrEditTagValRaw = StringSplit($strEditTagValRaw, @CRLF, 1)
			$arrEditTagVal = StringSplit($strEditTagVal, @CRLF, 1)
			For $i = 1 To $arrEditTagVal[0]
				;*** Duplikate (in ListBox) und leere Eintrge (in ListBox) berspringen
				If ($i = 1 Or _ArraySearch($arrEditTagVal, $arrEditTagVal[$i], 1, $i-1) = -1) And StringStripWS($arrEditTagVal[$i], 1+2) <> "" Then
					$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam)
					If GUICtrlRead($chkEditTagActionOpt) = $GUI_CHECKED Then
						;*** Um Duplikate (existierender Listeneintrag + Eintrag aus ListBox) zu verhindern, ggf. existierenden Listeneintrag erst lschen und dann hinzufgen
						$strExifToolParam &= "-=" & $arrEditTagVal[$i] & @CRLF
						$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "+=" & $arrEditTagVal[$i] & @CRLF
					Else
						$strExifToolParam &= "=" & $arrEditTagVal[$i] & @CRLF
					EndIf
					;***  INI-Abschnitt "Categories" automatisch um neue Kategorien ergnzen
					If StringInStr(GUICtrlRead($lblEditTagGrpNam), ":SupplementalCategories") > 0 Then
						$arrEditTagValRaw[$i] = BinaryToString(StringToBinary($arrEditTagValRaw[$i], 4), 1)
						If _ArraySearch($arrCategoriesKeywordsPersons, $arrEditTagValRaw[$i], 1, 0, 0, 0, 1, 1) = -1 Then
							IniWrite($cstrIniFile, "Categories", "Category_" & $strEditSaveTS & "_" & $i, $arrEditTagValRaw[$i])
						EndIf
					EndIf
				EndIf
			Next

		Else
			$arrLineBreaks = IniReadSection($cstrIniFile, "LineBreaks")
			$intLineBreaksIdx = _ArraySearch($arrLineBreaks, GUICtrlRead($lblEditTagGrpNam), 1, 0, 0, 0, 1, 0)
			If GUICtrlRead($lblEditTagGrpNam) = "MWG:Description" Then $intLineBreaksIdx = 1 ;Test MWG

			;*** TagGrp:TagNam ist in [LineBreaks] im INI-File eingetragen: Flietext (ImageDescription, Caption-Abstract u..)
			If $intLineBreaksIdx > -1 Then
				$strEditTagValDatFile = $cstrTmpFile & "_BinaryData.bin"
				If FileExists($strEditTagValDatFile) Then FileDelete($strEditTagValDatFile)
				If $booWriteUTF8 = True Then
					$fhBinaryData = FileOpen($strEditTagValDatFile, 2+256)
					FileWrite($fhBinaryData, $strEditTagValRaw)
					FileClose($fhBinaryData)
				Else
					FileWrite($strEditTagValDatFile, $strEditTagValRaw)
				EndIf
				$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam)
				$strEditTagValDatFile = FileGetShortName($strEditTagValDatFile)
				$strExifToolParam &= "<=" & $strEditTagValDatFile & @CRLF ;*** Ersetzung von "<>&' durch HTML-Codes funktioniert selbst hier korrekt

			;*** TagGrp:TagNam ist *nicht* in [LineBreaks] im INI-File eingetragen
			Else
				$strEditTagVal = StringReplace($strEditTagVal, @CRLF, Chr(0xA0))
				$strEditTagVal = StringReplace($strEditTagVal, @CR,   Chr(0xA0))
				$strEditTagVal = StringReplace($strEditTagVal, @LF,   Chr(0xA0))
				$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "=" & $strEditTagVal & @CRLF

			EndIf

		EndIf

	EndIf

	If GUICtrlRead($radioEditTagCpy) = $GUI_CHECKED Or GUICtrlRead($radioEditTagMov) = $GUI_CHECKED Then

		If GUICtrlRead($chkEditTagActionOpt) = $GUI_CHECKED Then
			$arrEditTagValRaw = StringSplit($strEditTagValRaw, @CRLF, 1)
			$arrEditTagVal = StringSplit($strEditTagVal, @CRLF, 1)
			For $i = 1 To $arrEditTagVal[0]
				;*** Duplikate (in ListBox) und leere Eintrge (in ListBox) berspringen
				If ($i = 1 Or _ArraySearch($arrEditTagVal, $arrEditTagVal[$i], 1, $i-1) = -1) And StringStripWS($arrEditTagVal[$i], 1+2) <> "" Then

					;*** Wenn Option "Alle markierten Dateien" gesetzt ist, dann je Listeneintrag (Keyword, Person o.dgl.) die Bedingung hinzufgen,
					;*** dass der Listeneintrag im Quell-Tag vorhanden sein muss. Grund: Jeder Listeneintrag wrde dem Ziel-Tag hinzugefgt werden (mit "+="),
					;*** selbst, wenn ein Listeneintrag nur im fokussierten (aktuell angezeigten) File vorkommt oder der Eintrag der Liste manuell hinzugefgt wurde
					;*** Todo: Problem: Suche funktioniert nur fr reine ASCII7-Suchbegriffe, nicht aber fr ANSI (Zeichencode > 127)oder gar Unicode
					If GUICtrlRead($chkEditSaveAll) = $GUI_CHECKED Then
						;*** Zeichen mit besonderer Bedeutung fr einen regulren Ausdruck in Perl mssen mit "\" maskiert werden
						$strSearchFor = $arrEditTagVal[$i]
						For $p = 1 To StringLen(".?*+^$|\()[{/")
							$strSearchFor = StringReplace($strSearchFor, StringMid(".?*+^$|\()[{/", $p, 1), "\" & StringMid(".?*+^$|\()[{/", $p, 1))
						Next
						$strExifToolParam &= "-if" & @CRLF & "$" & GUICtrlRead($lblEditTagGrpNam) & "=~/\b" & $strSearchFor & "\b/i" & @CRLF
					EndIf

					;*** Um Duplikate (existierender Listeneintrag + Eintrag aus ListBox) zu verhindern, ggf. existierenden Listeneintrag erst lschen und dann hinzufgen
					$strExifToolParam &= "-" & GUICtrlRead($cbxEditTagGrpNamTarget) & "-=" & $arrEditTagVal[$i] & @CRLF
					$strExifToolParam &= "-" & GUICtrlRead($cbxEditTagGrpNamTarget) & "+=" & $arrEditTagVal[$i] & @CRLF
					If GUICtrlRead($radioEditTagMov) = $GUI_CHECKED Then
						$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & "-=" & $arrEditTagVal[$i] & @CRLF
					EndIf
				EndIf
			Next
		Else
			If $booEditTagStruct = True Then $strExifToolParam &= "--struct" & @CRLF
			$strExifToolParam &= "-" & GUICtrlRead($lblEditTagGrpNam) & ">" & GUICtrlRead($cbxEditTagGrpNamTarget) & @CRLF
			If GUICtrlRead($radioEditTagMov) = $GUI_CHECKED Then
				If $booEditTagStruct = True Then ;*** $booEditTagStruct ist True, wenn $strTagGrpTagNam = "XMP-MP:RegionPersonDisplayName" oder "XMP-MP:Rectangle"
					$strExifToolParam &= "-XMP-MP:RegionInfoMP=" & @CRLF
				Else
					$strExifToolParam &= '-' & GUICtrlRead($lblEditTagGrpNam) & '=' & @CRLF
				EndIf
			EndIf
		EndIf

		;*** Action "Kopieren"/"Verschieben": Wenn Option "Nur, wenn Tag noch nicht vorhanden" (hier: *Ziel*-Tag) gesetzt ist, "-if"-Bedingung hinzufgen
		If GUICtrlRead($chkEditSaveAllOpt) = $GUI_CHECKED Then $strExifToolParam &= "-if" & @CRLF & "not $" & GUICtrlRead($cbxEditTagGrpNamTarget) & @CRLF

	EndIf

	If GUICtrlRead($chkEditSaveAll) = $GUI_UNCHECKED Then
		$strExifToolFilesCvIPTC &= $strTCPathCur & $strTCFileCur & @CRLF ;Encoding IPTC-Tags
		$strExifToolFiles &= $strTCPathCur & $strTCFileCur & @CRLF

		;bookmark
		If $intUseSidecarFile = 1 And Not FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
			ExportTagsToMIE($strTCPathCurOri, $strTCFileCurOri, $strSidecarFileType, GUICtrlRead($lblEditTagGrpNam), $booAlwaysWriteUTF8)
		EndIf

	EndIf

	$intFileIsSavableTrue = 0
	$intFileIsSavableFalse = 0
	If GUICtrlRead($chkEditSaveAll) = $GUI_CHECKED Then
;~ 		$strExifToolParam = "-progress" & @CRLF & $strExifToolParam ;debug
		$strClipSave = ClipGet() ;*** Clipboard-Inhalt sichern
		ClipPut("") ;*** Clipboard leeren (um nach cm_CopyFullNamesToClip feststellen zu knnen, ob TC "Keine Dateien gewhlt!" meldet)
		DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2018, "int", 0) ;*** cm_CopyFullNamesToClip=2018;Copy names with full path
		Sleep(200)
		$strClipCur = ClipGet()
		Sleep(200)
		ClipPut($strClipSave) ;*** Clipboard-Inhalt wiederherstellen

		$strFileIsSavableTrue = ""
		$strFileIsSavableFalse = ""
;~ 		$intFileIsSavableTrue = 0
;~ 		$intFileIsSavableFalse = 0

;~ 		#cs
		;*** Wenn die *fokussierte* Datei *nicht markiert* ist, diese ebenfalls in die Dateiliste mit aufnehmen
		If $strTCPathCur = "" Then
			$strTCFilepathCur = @WorkingDir & "\" & $strTCFileCur
		Else
			$strTCFilepathCur = $strTCPathCur & $strTCFileCur
		EndIf
		;*** $strClipCur enthlt die originalen Unicode-Dateinamen, daher muss in $strClipCur auch mit dem Originalnamen der fokussierten Datei gesucht werden
;~ 		If StringInStr($strClipCur, $strTCFilepathCur) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
		If StringInStr($strClipCur, $strTCPathCurOri & $strTCFileCurOri) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
;~ 		#ce

		;*** Bei bedingtem Lschen ("lschen", "wenn Inhalt gleich") TagVal des fokussierten Files binr exportieren (als Vergleichs-Referenz)
		If GUICtrlRead($radioEditTagDel) = $GUI_CHECKED And GUICtrlRead($chkEditSaveAllOpt) = $GUI_CHECKED Then
			;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
			;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
			$strExifToolParam2 = "-b -" & GUICtrlRead($lblEditTagGrpNam) & ' "' & $strTCPathCur & $strTCFileCur & '" >"' & $cstrTmpFile & "TCMetadataViewer_BinaryDataRef.bin" & '"'
			RunExifTool("ReadMetadataOnCondDel", $strExifToolParam2, 1)
		EndIf

		;*** Eintrge der Dateiliste aus Clipboard in Feld $arrTCFileSel einlesen
		$arrTCFileSel = StringSplit($strClipCur, @CRLF, 1)

		For $i = 1 To $arrTCFileSel[0]
			GUICtrlSetData($lblEditSaveCur, "Checking file " & $i & "/" & $arrTCFileSel[0] & "...")

			$booFileIsSavable = True
;~ 			$strTCPathSel = ""
;~ 			$strTCFileSel = $arrTCFileSel[$i]
			$p = StringInStr($arrTCFileSel[$i], "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
			$strTCPathSel = StringLeft($arrTCFileSel[$i], $p-1)
			$strTCFileSel = StringMid($arrTCFileSel[$i], $p+1)
			$strTCPathSelOri = $strTCPathSel
			$strTCFileSelOri = $strTCFileSel
			$strErrMsg = ""

			;*** Prfen, ob die markierte Datei existiert => Irrelevant, falls Navigation innerhalb eines Archivs, da durch FileIsValid() gar keine Tags angezeigt werden (sondern "Ignoriert")
			;If Not FileExists($arrTCFileSel[$i]) Then [...]

			;*** Prfen, ob der markierte Eintrag Unicode-Zeichen enthlt
			If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) Then
				$strTCFileSel = FileGetShortName($arrTCFileSel[$i])
				$p = StringInStr($strTCFileSel, "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
				$strTCPathSel = StringLeft($strTCFileSel, $p-1)
				$strTCFileSel = StringMid($strTCFileSel, $p+1)
				If $booBackup = True Or $intUseSidecarFile = 1 Then
					$booFileIsSavable = False
					$strErrMsg = "Uni>" & @TAB
				EndIf
			EndIf

			;*** Prfen, ob die Dateinamenserweiterung der *markierten* Datei der der *fokussierten* Datei entspricht
			$p = StringInStr($arrTCFileSel[$i], ".", 0, -1)
			If $p > 0 Then
				$strTCExtSel = StringMid($arrTCFileSel[$i], $p+1)
				If $strTCExtSel <> $strTCExtCur Then
					$booFileIsSavable = False
					$strErrMsg = "Ext>" & @TAB
				EndIf
			EndIf

			;*** Prfen, ob der markierte Eintrag ein Verzeichnis ist
			If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "D") > 0 Then
				$booFileIsSavable = False
				$strErrMsg = "Dir>" & @TAB
			EndIf

			;*** Prfen, ob der markierte Eintrag schreibgeschtzt ("R"), versteckt ("H") oder eines Systemdatei ("S") ist
			If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "R") > 0 Or StringInStr(FileGetAttrib($arrTCFileSel[$i]), "S") > 0 Or StringInStr(FileGetAttrib($arrTCFileSel[$i]), "H") > 0 Then
				$booFileIsSavable = False
				$strErrMsg = "RHS>" & @TAB
			EndIf

			;*** Speichern in PJG-Files ist nur fr *fokussierte* Datei mglich => Irrelevant, da im Falle PJG das temporre JPG bearbeitet  wird
			;If $strTCExtSel = "pjg" Then $booFileIsSavable = False

			;*** Bei bedingtem Lschen ("lschen", "wenn Inhalt gleich") TagVal jedes markierten Files binr exportieren
			;*** und mit binren TagVal des fokussierten Files vergleichen
			If $booFileIsSavable = True And GUICtrlRead($radioEditTagDel) = $GUI_CHECKED And GUICtrlRead($chkEditSaveAllOpt) = $GUI_CHECKED Then
				;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
				;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
;~ 				$strExifToolParam2 = "-b -" & GUICtrlRead($lblEditTagGrpNam) & ' "' & $arrTCFileSel[$i] & '" >"' & $cstrTmpFile & "TCMetadataViewer_BinaryData.bin" & '"'
				$strExifToolParam2 = "-b -" & GUICtrlRead($lblEditTagGrpNam) & ' "' & $strTCPathSel & "\" & $strTCFileSel & '" >"' & $cstrTmpFile & "TCMetadataViewer_BinaryData.bin" & '"'
				RunExifTool("ReadMetadataOnCondDel", $strExifToolParam2, 1)
				If FileRead($cstrTmpFile & "TCMetadataViewer_BinaryDataRef.bin") <> FileRead($cstrTmpFile & "TCMetadataViewer_BinaryData.bin") Then
					$booFileIsSavable = False
					$strErrMsg = "A#B>" & @TAB
				EndIf
			EndIf

			If $booFileIsSavable = True Then
				$intFileIsSavableTrue += 1
				If $strTCPathSelOri = @WorkingDir Then
					$strExifToolFilesCvIPTC &= $strTCFileSel & @CRLF ;Encoding IPTC-Tags
					$strExifToolFiles &= $strTCFileSel & @CRLF
					If $intFileIsSavableTrue < 6 Then $strFileIsSavableTrue &= "     " & $strTCFileSelOri & @LF
				Else
;~ 					$strExifToolFilesCvIPTC &= $arrTCFileSel[$i] & @CRLF ;Encoding IPTC-Tags
;~ 					$strExifToolFiles &= $arrTCFileSel[$i] & @CRLF
					$strExifToolFilesCvIPTC &= $strTCPathSel & "\" & $strTCFileSel & @CRLF ;Encoding IPTC-Tags
					$strExifToolFiles &= $strTCPathSel & "\" & $strTCFileSel & @CRLF
					If $intFileIsSavableTrue < 6 Then $strFileIsSavableTrue &= "     " & $arrTCFileSel[$i] & @LF
				EndIf
				If $intFileIsSavableTrue = 6 Then $strFileIsSavableTrue &= "     " & "..." & @LF

			Else
				$intFileIsSavableFalse += 1
				If $intFileIsSavableFalse < 11 Then $strFileIsSavableFalse &= "     " & $strErrMsg & $arrTCFileSel[$i] & @LF
				If $intFileIsSavableFalse = 11 Then $strFileIsSavableFalse &= "     " & "..." & @LF
				$arrTCFileSel[$i] = "" ;*** Nicht speicherbare Files aus Liste entfernen, damit weiter unten im Falle $intUseSidecarFile = 1 nur fr gltige Files SidecarFiles angelegt werden

			EndIf

		Next

		If $booWriteUTF8 = True Then
;~ 			GUICtrlSetData($lblEditSaveCur, "Encoding on Save: UTF-8")
			GUICtrlSetData($lblEditSaveCur, "Will try to save UTF-8 encoded values")
		Else
;~ 			GUICtrlSetData($lblEditSaveCur, "Encoding on Save: ANSI")
			GUICtrlSetData($lblEditSaveCur, "Will try to save ANSI encoded values")
		EndIf

		#cs
		;*** Wenn die *fokussierte* Datei *nicht markiert* ist, diese ebenfalls in die Dateiliste mit aufnehmen
		;*** Prfen: Schlgt der StrinInStr()-Abgleich fehl,
		;*** wenn fokussierte Datei markiert ist (also bereits in obiger For..Next-Schleife bercksichtigt wurde) UND $strTCFileCur im @WorkingDir liegt?
		;###
		;*** ToDo: Wenn im TC die Miniaturansicht aktiv ist, dann ist $strTCFileCur = *{Dateiname}
		;*** Prfen, wieso das Sternchen noch enthalten ist und ob es noch an anderer Stelle Probleme bereitet
		If StringInStr($strExifToolParam, ' "' & $strTCPathCur & $strTCFileCur & '"') = 0 Then
			$intFileIsSavableTrue += 1
			$strFileIsSavableTrue = "     " & $strTCPathCur & $strTCFileCur & @LF & $strFileIsSavableTrue
			$strExifToolParam &= $strTCPathCur & $strTCFileCur & @CRLF
		EndIf
		#ce

		$strErrMsg = GUICtrlRead($lblEditTagGrpNam) & " "
		If GUICtrlRead($radioEditTagChg) = $GUI_CHECKED Then $strErrMsg &= $arrLocStr[73]
		If GUICtrlRead($radioEditTagDel) = $GUI_CHECKED Then $strErrMsg &= $arrLocStr[74]
		$strErrMsg &= @LF & $arrLocStr[95] & " " & @WorkingDir & @LF & @LF
		If $intFileIsSavableTrue > 0 Then
			$strErrMsg &= $arrLocStr[99]
			$strErrMsg  = StringReplace($strErrMsg, "%ok", $intFileIsSavableTrue) & @LF & @LF
			$strErrMsg &= $strFileIsSavableTrue & @LF
		EndIf
		If $intFileIsSavableFalse > 0 Then
			$strErrMsg &= $arrLocStr[96]
			$strErrMsg  = StringReplace($strErrMsg, "%nok", $intFileIsSavableFalse) & @LF & @LF
			$strErrMsg &= $strFileIsSavableFalse & @LF
		EndIf
		If $intFileIsSavableTrue > 0 Then
			$strErrMsg &= $arrLocStr[94]
			$strErrMsg  = StringReplace($strErrMsg, "%ok" , $intFileIsSavableTrue)
			$strErrMsg  = StringReplace($strErrMsg, "%sel", $intFileIsSavableTrue+$intFileIsSavableFalse)
			If MsgBox(4+32+262144, $cstrTCMetadataViewerVersion, $strErrMsg) = 7 Then Return
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $strErrMsg)
			Return
		EndIf

		;bookmark
		For $i = 1 To $arrTCFileSel[0]
			If $arrTCFileSel[$i] <> "" And $intUseSidecarFile = 1 And Not FileExists(StringLeft($arrTCFileSel[$i], StringInStr($arrTCFileSel[$i], ".", 0, -1)) & $strSidecarFileType) Then
				$p = StringInStr($arrTCFileSel[$i], "\", 0, -1)
				ExportTagsToMIE(StringLeft($arrTCFileSel[$i], $p), StringMid($arrTCFileSel[$i], $p+1), $strSidecarFileType, GUICtrlRead($lblEditTagGrpNam), $booAlwaysWriteUTF8)
			EndIf
		Next

	EndIf

	$booConvertIPTCTagsToUTF8 = False ;Encoding IPTC-Tags
	;*** IPTC-Tags (als Quelle) nach UTF-8 konvertieren (hier: bei ndern) ;ToDo: Prfen, ob auch Lschen bercksichtigt werden muss (nmlich fr den Fall, dass einzelne Elemente einer Liste (also "nur angegebene") gelscht werden)
	If $booWriteUTF8 = True And StringInStr(GUICtrlRead($lblEditTagGrpNam), "IPTC:") = 1 And GUICtrlRead($radioEditTagChg) = $GUI_CHECKED Then $booConvertIPTCTagsToUTF8 = True ;Encoding IPTC-Tags
	;*** IPTC-Tags (als Ziel)   nach UTF-8 konvertieren (hier: bei Kopieren/Verschieben)
	If $booWriteUTF8 = True And StringInStr(GUICtrlRead($cbxEditTagGrpNamTarget), "IPTC:") = 1 And (GUICtrlRead($radioEditTagCpy) = $GUI_CHECKED Or GUICtrlRead($radioEditTagMov) = $GUI_CHECKED) Then $booConvertIPTCTagsToUTF8 = True ;Encoding IPTC-Tags
	If $booConvertIPTCTagsToUTF8 = True Then $strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParamCvIPTC, $strExifToolFilesCvIPTC, 1, "Def") ;Encoding IPTC-Tags

	$strExifToolOut = FeedExifTool("SaveMetadata", $strExifToolParam, $strExifToolFiles, 1, "Def")
	If @error Then
		MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & GUICtrlRead($lblEditTagGrpNam) & " = " & GUICtrlRead($txtEditTagVal) & @LF & @LF & $strExifToolErr)
		$booRefreshMetadataOnly = True
	Else
;~ 		$booRefresh = True
		;*** Wenn Tag File:FileName beteiligt ist (relevant nur als Ziel-Tag, hier aber nicht unterschieden), eine Datei also mit ExifTool umbenannt wird,
		;*** dann 1.) existiert die Datei unter dem alten Namen nicht mehr und 2.) ist im TC-FilePanel eine andere Datei fokussiert.
		;*** Es muss (im MainLoop) also dafr gesorgt werden, dass der fokussierte Eintrag neu ermittelt wird, die Metadaten eingelesen werden usw.
		;*** Dies wird erreicht, wenn smtliche "If $booRefresh* = TRUE"-Abschnitte des Mainloops bersprungen werden
		If StringInStr($strExifToolParam, "File:FileName") = 0 Then $booRefreshMetadataOnly = True ;Test
	EndIf
	$booFileIsModified = True

	SetWinOnTopState($intWinOnTopStateUser)
	If @GUI_WinHandle <> $frmMain Then _Exit() ;*** Falls SaveEditTag() von ImageTitleOnEvent() aufgerufen wurde (also Speichern File:Comment nach Editieren des Eingabefelds oberhalb des Quickview-Bilds)

EndFunc ;Func SaveEditTag()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func My_WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam
;~ 	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndLvwTags, $tInfo
	Local $hWndFrom, $iCode, $tNMHDR, $hWndLvwTags, $hWndLvwSync, $hWndLvwEdit, $tInfo, $tBuffer, $sNewText
;~ 	Local $hWndFrom, $iCode, $tNMHDR, $hWndLvwTags, $tInfo
	$hWndLvwTags = $hlvwTags
	If Not IsHWnd($hlvwTags) Then $hWndLvwTags = GUICtrlGetHandle($hlvwTags)
	$hWndLvwSync = $hlvwSyncSelectedFiles
	If Not IsHWnd($hlvwSyncSelectedFiles) Then $hWndLvwSync = GUICtrlGetHandle($hlvwSyncSelectedFiles)
	$hWndLvwEdit = $hlvwEditTagVal
	If Not IsHWnd($hlvwEditTagVal) Then $hWndLvwEdit = GUICtrlGetHandle($hlvwEditTagVal)

	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
;~ 	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")

	Switch $iCode

		Case $NM_CLICK

			Switch $hWndFrom

				Case $hWndLvwTags
					$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
					OpenEditTagDialog(DllStructGetData($tInfo, "Index"))

				Case $hWndLvwSync
					$tInfo = DllStructCreate($tagNMLISTVIEW, $ilParam)
					;*** Wenn erste Spalte angeklickt wurde, nichts tun (damit beim Anklicken der Checkbox eines Listview-Items nicht in den Unterdialog verzweigt wird)
					If DllStructGetData($tInfo, "SubItem") = 0 Then Return
					$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
					OpenSyncSelectedTagsDialogOnLvwSyncClick(DllStructGetData($tInfo, "Index"))

				Case $hWndLvwEdit
					$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)

					If $booMagnify = True Then
						$booMagnify = False
						GUICtrlSetColor($lblScale, 0xE13131)
						If $strImageConvertMode = "RAW" Then
							GetImageDim($cstrTmpFile & "_PreviewImage.jpg")
						Else
							GetImageDim($strTCPathCur & $strTCFileCur)
						EndIf
						$booRefreshQuickviewImage = True
					EndIf

					$arrLvwRow = _GUICtrlListView_GetItemTextArray($hlvwEditTagVal)

					;*** XMP-MP:PersonDisplayName *ohne* XMP-MP:Rectangle
					If $arrLvwRow[2] = "" Then
						$arrRegionRectangle = StringSplit("0.400000, 0.400000, 0.200000, " & Round((0.200000 * $intImgPreW) / $intImgPreH, 6), ", ", 1)
					;*** XMP-MP:PersonDisplayName *mit* XMP-MP:Rectangle
					Else
						$arrRegionRectangle = StringSplit($arrLvwRow[2], ", ", 1)
					EndIf
					WinSetTitle($frmRectangle, "", $arrLvwRow[1])

;~ 					$x = Round($intImgPreW*$arrRegionRectangle[1])
;~ 					$y = Round($intImgPreH*$arrRegionRectangle[2])
;~ 					$w = Round($intImgPreW*$arrRegionRectangle[3])
;~ 					$h = Round($intImgPreH*$arrRegionRectangle[4])
;~ 					ConsoleWrite("0: My_WM_NOTIFY OldRectangle: x=" & $x & ", y=" & $y & ", w=" & $w & ", h=" & $h & @CRLF) ;debug

					$x = $intTCInactivePanelX + Int(($intPicW - $intImgPreW) / 2) + Round($intImgPreW*$arrRegionRectangle[1])
					$y = $intTCInactivePanelY + 1 + Round($intImgPreH*$arrRegionRectangle[2])
					$w = Round($intImgPreW*$arrRegionRectangle[3])
					$h = Round($intImgPreH*$arrRegionRectangle[4])
					WinMove($frmRectangle, "", $x, $y, $w, $h)
;~ 			 		ConsoleWrite("1: My_WM_NOTIFY(WinMove $frmRectangle): x=" & $x & ", y=" & $y & ", w=" & $w & ", h=" & $h & @CRLF) ;debug

					$arrRectangleWinPos = WinGetPos($frmRectangle) ;[0]=x, [1]=y, [2]=B, [3]=H
;~ 			 		ConsoleWrite("2a: My_WM_NOTIFY(WinSize $frmRectangle): x=" & $arrRectangleWinPos[0] & ", y=" & $arrRectangleWinPos[1] & ", w=" & $arrRectangleWinPos[2] & ", h=" & $arrRectangleWinPos[3] & @CRLF) ;debug
					$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
;~ 			 		ConsoleWrite("2b: My_WM_NOTIFY(ClientSize $frmRectangle): B=" & $arrRectangleClientPos[0] & ", H=" & $arrRectangleClientPos[1] & @CRLF) ;debug
					$b = ($arrRectangleWinPos[2]-$arrRectangleClientPos[0])/2
					$x = $x-$b
					$y = $y-($arrRectangleWinPos[3]-$arrRectangleClientPos[1])+$b
					;*** GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), 1, $intImgPreW, $intImgPreH)
					;*** GUICtrlSetPos($picPic, Int(($intPicW - $intImgPreW) / 2), Int(($intPicH - $intImgPreH) / 2) + 1, $intImgPreW, $intImgPreH)
					$y = $y + Int(($intPicH - $intImgPreH) / 2) ;*** vertikale Zentrierung = Verschiebung des Quickview-Images bercksichtigen
					$y = $y + $intShowImageTitle*20 ;*** Verschiebung um die Hhe des ImageTitles (20px) bercksichtigen
					$w = $w+2*$b
					$h = $h+($arrRectangleWinPos[3]-$arrRectangleClientPos[1])
					WinMove($frmRectangle, "", $x, $y, $w, $h)
;~ 					ConsoleWrite("3: My_WM_NOTIFY(WinMove $frmRectangle): b=" & $b & ", x=" & $x & ", y=" & $y & ", w=" & $w & ", h=" & $h & @CRLF) ;debug

					#cs
					$arrRectangleClientPos = WinGetClientSize($frmRectangle) ;*** [0]=B; [1]=H
;~ 					ConsoleWrite("4: My_WM_NOTIFY(ClientSize $frmRectangle): B=" & $arrRectangleClientPos[0] & ", H=" & $arrRectangleClientPos[1] & @CRLF) ;debug
					GUICtrlSetPos($picTransparent, 0, 0, $arrRectangleClientPos[0], $arrRectangleClientPos[1])
					#ce

					GUICtrlSetState($lblRegionRectangle, $GUI_HIDE)
					GUISetState(@SW_SHOW, $frmRectangle)
;~ 					GUICtrlSetColor($lblScale, 0xFFFFFF) ;Test ;0x99CC00 = gelbgrn

			EndSwitch

		Case $NM_DBLCLK
			If $hWndFrom = $hWndLvwEdit Then
				$iSelected = _GUICtrlListView_GetSelectedIndices($hWndLvwEdit)
				If $iSelected <> "" Then _GUICtrlListView_EditLabel($hWndLvwEdit, $iSelected)
			EndIf

		Case $LVN_BEGINLABELEDITW
			$tInfo = DllStructCreate($tagNMLVDISPINFO, $ilParam)
			Return False

		Case $LVN_ENDLABELEDITW
			$tInfo = DllStructCreate($tagNMLVDISPINFO, $ilParam)
			$tBuffer = DllStructCreate("char Text[" & DllStructGetData($tInfo, "TextMax") & "]", _
			DllStructGetData($tInfo, "Text"))
			$sNewText = DllStructGetData($tBuffer, "Text")
;~ 			If StringLen($sNewText) Then Return True ;*** Leeres $sNewText wird *nicht* akzeptiert, ursprnglicher Wert wird wiederhergestellt
			Return True ;*** Leeres $sNewText wird akzeptiert

	EndSwitch

	#cs
	If $hWndFrom = $hWndLvwTags Then
		Switch $iCode

			Case $LVN_COLUMNCLICK ; A column was clicked
				$tInfo = DllStructCreate($tagNMLISTVIEW, $ilParam)
				MsgBox(0, "$LVN_COLUMNCLICK", DllStructGetData($tInfo, "SubItem")) ;debug
				;No return value

			Case $NM_CLICK ; Sent by a list-view control when the user clicks an item with the left mouse button
				$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
				;MsgBox(0, "$NM_CLICK", DllStructGetData($tInfo, "Index")) ;debug
				OpenEditTagDialog(DllStructGetData($tInfo, "Index"))
				;No return value

			Case $NM_DBLCLK ; Sent by a list-view control when the user double-clicks an item with the left mouse button
				$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
				;MsgBox(0, "$NM_DBLCLK", DllStructGetData($tInfo, "Index")) ;debug
				OpenEditTagDialog(DllStructGetData($tInfo, "Index"))
				;No return value

			Case $NM_RCLICK ; Sent by a list-view control when the user clicks an item with the right mouse button
				$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
				MsgBox(0, "$NM_RCLICK", DllStructGetData($tInfo, "Index")) ;debug
				;Return 1 ; not to allow the default processing
				Return 0 ; allow the default processing

			Case $NM_RDBLCLK ; Sent by a list-view control when the user double-clicks an item with the right mouse button
				$tInfo = DllStructCreate($tagNMITEMACTIVATE, $ilParam)
				MsgBox(0, "$NM_RDBLCLK", DllStructGetData($tInfo, "Index")) ;debug
				;No return value

		EndSwitch

	EndIf
	#ce

	Return $GUI_RUNDEFMSG
;~ 	Return

EndFunc ;Func My_WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SetPanelDivider()
	#cs
	 20+44   + 14 => Unterkante Zeit-Info von DateTimeOriginal
	 80+1*15 +  9 => Unterkante Rating-Star-Icons (LayoutXMPRating = "Stars")
	 80+5*15 + 13 => Unterkante Rating-1-Icon     (LayoutXMPRating = "Boxes")
	179+15+5*14 + 12 => Unterkante Label-Purple-Icon
	Int($intTCInactivePanelH * ($intPanelDivider/100)) + 3 => Oberkante PanelDivider-UpDown
	#ce

	If Int($intTCInactivePanelH * (GUICtrlRead($cbxPanelDivider)/100)) - 5 < 80+1*15+9 Then
		GUICtrlSetData($cbxPanelDivider, GUICtrlRead($cbxPanelDivider)+5)
		Return
	EndIf

	$intPanelDivider = GUICtrlRead($cbxPanelDivider)
	GUICtrlSetTip($cbxPanelDivider, $intPanelDivider & "%")
;~ 	WriteLog("Debug:SetPanelDivider()", $intPanelDivider & "%") ;debug

	$booRefreshGUI = True

	If $intWinOnTopState = 1 Then WinActivate($whTC)

EndFunc ;Func SetPanelDivider()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func FeedExifTool($strOperation, $strExifToolParam, $strExifToolFiles, $intExifToolAddOptSidecarFile, $strExifToolParamEncoding)
;ToDo: Fehlererkennung und -behandlung
	$strStdOut = ""
	$strStdErr = ""

	If $intExifToolAddOptSidecarFile = 1 And $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
		;*** "-TagsFromFile @" / "-TagsFromFile %d%f.%e" benutzen stets den Original-Dateinamen und nicht den durch den Parameter "-srcfile" gebildeten Dateinamen
		;*** Das fhrt dazu, dass mit -TagsFromFile i.V.m. -srcfile die Tags trotzdem vom Originalfile statt wie erwnscht vom Sidecar-File bernommen werden.
		;*** Todo: Sidecar-File-Benutzung fr den Fall "-TagsFromFile {Filename}" umsetzen
		$strExifToolParam = StringReplace($strExifToolParam, "-TagsFromFile" & @CRLF & "@" & @CRLF, "-TagsFromFile" & @CRLF & "%d%f." & $strSidecarFileType & @CRLF)
		$strExifToolParam &= "-srcfile" & @CRLF & "%d%f." & $strSidecarFileType & @CRLF
	EndIf

	;*** Dateinamen, die mit "-" beginnen, werden von ExifTool als Option behandelt.    Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
	;*** Dateinamen, die mit "#" beginnen, werden von ExifTool als Kommentar behandelt. Solchen Dateinamen zwecks "Maskierung" ein ".\" voranstellen
	$strExifToolFiles = StringRegExpReplace($strExifToolFiles, "^(#|-)", ".\\\1")
	$strExifToolFiles = StringRegExpReplace($strExifToolFiles, "\r\n(#|-)", @CRLF & ".\\\1")

	WriteLog($strOperation, "FeedExifTool: " & StringReplace($strExifToolParam, @CRLF, "|") & StringReplace($strExifToolFiles, @CRLF, "|"))
	FileWriteLine($fhArgfile, "#~~~~~ " & @YEAR & @MON & @MDAY & "_" & @HOUR & @MIN & @SEC & " " & $strOperation & @CRLF)

;~ 	If StringInStr("SaveMetadata", $strOperation) = 1 Then $strExifToolParam = "-v0" & @CRLF & $strExifToolParam ;debug

	If $strArgFileEncoding = "UTF8" And StringIsASCII($strExifToolParam) = 0 And $strExifToolParamEncoding = "Bin" Then
;~ 		WriteLog($strOperation, "FeedExifTool: ExifToolParam will be written ANSI-encoded") ;debug
		FileClose($fhArgfile)
		$fhArgfile = FileOpen($cstrArgFile, 1+16)
		FileWriteLine($fhArgfile, $strExifToolParam)
		FileClose($fhArgfile)
		$fhArgfile = FileOpen($cstrArgFile, 1+256)
	Else
		FileWriteLine($fhArgfile, $strExifToolParam)
	EndIf

	If $strArgFileEncoding = "UTF8" And StringIsASCII($strExifToolFiles) = 0 Then
;~ 		WriteLog($strOperation, "FeedExifTool: ExifToolFiles will be written ANSI-encoded") ;debug
		FileClose($fhArgfile)
		$fhArgfile = FileOpen($cstrArgFile, 1+16)
		FileWriteLine($fhArgfile, $strExifToolFiles)
		FileClose($fhArgfile)
		$fhArgfile = FileOpen($cstrArgFile, 1+256)
	Else
		FileWriteLine($fhArgfile, $strExifToolFiles)
	EndIf
	FileWriteLine($fhArgfile, @CRLF & "-execute")

;~ 	If $strOperation = "NewArgFile" Then Return ;*** Wechsel des *ARGFILE* wird von ExifTool nicht mit "{ready}" quittiert; Seit ExifTool V8.?? doch!

	If BitAND(WinGetState($frmEdit), 2) Or BitAND(WinGetState($frmShiftDateTime), 2) Then ProgressOn("FeedExifTool", $strOperation)
	While 1
		$strStdOutBuf = StdoutRead($pidExifTool)
		$strStdErrBuf = StderrRead($pidExifTool) ;debug
		$strStdOut &= $strStdOutBuf
		$strStdErr &= $strStdErrBuf ;debug
		If (BitAND(WinGetState($frmEdit), 2) Or BitAND(WinGetState($frmShiftDateTime), 2)) And $strStdOutBuf <> "" Then
			$arrProgress = StringRegExp($strStdOutBuf, ".*======== (.+) \[(\d+)/(\d+)\]", 1)
			If UBound($arrProgress) = 3 Then ProgressSet(Int($arrProgress[1]*100 / $arrProgress[2]), "[" & $arrProgress[1] & "/" & $arrProgress[2] & "]: " & $arrProgress[0])
		EndIf
		$p = StringInStr($strStdOut, "{ready}")
		If $p > 0 Then
			$strStdOut = StringLeft($strStdOut, $p-1)
			ExitLoop
		EndIf
	Wend
	If BitAND(WinGetState($frmEdit), 2) Or BitAND(WinGetState($frmShiftDateTime), 2) Then ProgressOff()

	If StringInStr("ConvertIPTCTagsToUTF8|DeleteMetadata|DeleteSelectedTags|SaveMetadata|SaveSyncSelectedFiles|SaveSyncSelectedTags|SetXMPDaylightSavings|SetXMPLabel|SetXMPRating|ShiftDateTime", $strOperation) > 0 Then
		WriteLog($strOperation, "FeedExifTool: Out: " & StringReplace($strStdOut, @CRLF, " | "))
		;*** Bei reinen "Single-File-Aktionen" ($strOperation = SetXMP*) *keine* MsgBox anzeigen
;~ 		If StringInStr("SetXMPDaylightSavings|SetXMPLabel|SetXMPRating", $strOperation) > 0 Then
;~ 			$intFileIsSavableTrue = 0
;~ 			$intFileIsSavableFalse = 0
;~ 		EndIf
;~ 		If $intFileIsSavableTrue > 0 Then MsgBox(64+262144, $strOperation, $strStdOut)
		;*** Bei reinen "Single-File-Aktionen" ($strOperation = SetXMP*) sowie Multi-File-Aktionen, bei denen FeedExifTool fr jedes File einzeln aufgerufen wird, *keine* MsgBox anzeigen
		If $intFileIsSavableTrue > 0 And StringInStr("SetXMPDaylightSavings|SetXMPLabel|SetXMPRating|SaveSyncSelectedFiles", $strOperation) = 0 Then
			$p = StringInStr($strStdOut, "]", 0, -1)
			MsgBox(64+262144, $strOperation, StringStripWS(StringMid($strStdOut, $p+1), 1+2))
		EndIf
	EndIf

	$strExifToolErr = $strStdErr
	If $strStdErr <> "" Then
		WriteLog($strOperation, "FeedExifTool: Err: " & StringReplace($strStdErr, @CRLF, " | "))
		SetError(1)
	EndIf

	;*** Workaround, falls *ARGFILE* mit "-b(inary)"-Option "gefttert" wurde
	;*** Siehe Bugreport im ExifTool-Forum, Thread "stay_open, stdout line delim LF instead of CRLF after -b option"
	;*** Phil Harvey: "I set binmode on stdout when the -b option is used (for obvious reasons). Your problem is that stdout stays in binmode
	;*** for subsequent -execute commands.  My problem is I don't know how to reset binmode on stdout once it has been applied."
;~ 	If StringInStr($strExifToolParam, "-b" & @CRLF, 1) > 0 Then RestartExifTool($strArgFileEncoding)

	Return $strStdOut

EndFunc ;Func FeedExifTool($strOperation, $strExifToolParam, $strExifToolFiles)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func StartUpExifTool()
	If $strArgFileEncoding = "UTF8" Then
		$fhArgfile = FileOpen($cstrArgFile, 2+256) ;*** UTF8-codiertes *ARGFILE* anlegen
	Else
		$fhArgfile = FileOpen($cstrArgFile, 2)     ;*** ANSI-codiertes *ARGFILE* anlegen
	EndIf
	$strExifToolParam = ' -v0 -stay_open True -@ "' & $cstrArgFile & '"' ;*** -v0 causes the console output buffer to be flushed after each line
;~ 	$strExifToolParam = ' -v0 -sep "" -stay_open True -@ "' & $cstrArgFile & '"' ;*** -v0 causes the console output buffer to be flushed after each line
	$pidExifTool = Run(@ComSpec & ' /S /c ""' & $strExifToolPath & '" ' & $strExifToolParam & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
	WriteLog("StartUpExifTool [PID=" & $pidExifTool & "]", '"' & $strExifToolPath & '" ' & $strExifToolParam)
EndFunc ;Func StartUpExifTool()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ShutdownExifTool()
	If Not ProcessExists($pidExifTool) Then Return
	$strExifToolParam = "-stay_open" & @CRLF & "False" & @CRLF
	FileWriteLine($fhArgfile, $strExifToolParam)
	ProcessWaitClose($pidExifTool)
	FileClose($fhArgfile)
	WriteLog("ShutdownExifTool [PID=" & $pidExifTool & "]", "FeedExifTool: " & StringReplace($strExifToolParam, @CRLF, "|"))
EndFunc ;Func ShutdownExifTool()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func RestartExifTool($strArgFileEncodingNew)
	WriteLog("RestartExifTool", "ExifTool *ARGFILE* will be created in mode " & $strArgFileEncodingNew & " (old *ARGFILE* was " & $strArgFileEncoding & "-encoded)")
	$strArgFileEncoding = $strArgFileEncodingNew
	ShutdownExifTool() ;*** Shutdown ExifTool
	StartUpExifTool()  ;*** StartUp  ExifTool
EndFunc ;Func RestartExifTool($strArgFileEncodingNew)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func RunExifTool($strOperation, $strExifToolParam, $intExifToolAddOptSidecarFile)

	$strStdOut = ""
	$strStdErr = ""

	If $intExifToolAddOptSidecarFile = 1 And $intUseSidecarFile = 1 And FileExists($strTCPathCurOri & StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & $strSidecarFileType) Then
		;*** "-TagsFromFile @" / "-TagsFromFile %d%f.%e" benutzen stets den Original-Dateinamen und nicht den durch den Parameter "-srcfile" gebildeten Dateinamen
		;*** Das fhrt dazu, dass mit -TagsFromFile i.V.m. -srcfile die Tags trotzdem vom Originalfile statt wie erwnscht vom Sidecar-File bernommen werden.
		$strExifToolParam = StringReplace($strExifToolParam, "-TagsFromFile @ ", "-TagsFromFile %d%f." & $strSidecarFileType)
		$strExifToolParam = "-srcfile %d%f." & $strSidecarFileType & " " & $strExifToolParam
	EndIf

	WriteLog($strOperation, '"' & $strExifToolPath & '" ' & $strExifToolParam)
	$pidExifToolOnce = Run(@ComSpec & ' /S /c ""' & $strExifToolPath & '" ' & $strExifToolParam & '"', "", @SW_HIDE, $STDOUT_CHILD+$STDERR_CHILD)
	While 1
		$strStdOut &= StdoutRead($pidExifToolOnce)
		If @error Then ExitLoop
	Wend
	While 1
		$strStdErr &= StderrRead($pidExifToolOnce)
		If @error Then ExitLoop
	Wend
	ProcessWaitClose($pidExifToolOnce)

	$strExifToolErr = $strStdErr
	If $strStdErr <> "" Then
		WriteLog("RunExifTool", "Err: " & StringReplace($strStdErr, @CRLF, " | "))
		SetError(1)
	EndIf

	Return $strStdOut

EndFunc ;Func RunExifTool($strOperation, $strExifToolParam)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func WriteLog($strTCMetadataViewerLogOperation, $strTCMetadataViewerLogDetails)
	;*** Liste der Operationen, die in TCMetadataViewer geloggt werden
	;*** F: FeedExifTool(); R: RunExifTool(); W: WriteLog(); (x): Aufruf ist im Code auskommentiert
	;*** O: ExifTool-Out wird geloggt (z.Z. nur fr FeedExifTool() implementiert); -: ExifTool-Out wird nicht geloggt; (-): ExifTool-Out wird implizit nicht geloggt
	;*** 1: Operationen, die selbst bei $intWriteLog = 1 geloggt werden
	#cs
	F       -      BuildCustTagList                      R      (-)     ExtractBinData                        W      (-) 1   RestartExifTool
	W      (-)     BuildWriExtsList                      R      (-)     ExtractPrevImg                        W      (-) 1   RunExifTool
	W      (-)     BuildXMLTagDB                         R      (-)     ExtractThumbImg                       F       O  1   SaveMetadata
	W      (-) 1   ChangeDir                             W      (-) 1   FileCopy                              F       O  1   SaveSyncSelectedFiles
	W      (-)     CompareTags                           W      (-)     FileIsValid                           F       O  1   SaveSyncSelectedTags
	F       O  1   ConvertIPTCTagsToUTF8                 W      (-) 1   FileMove                              W      (-)     SetAllowDuplicateTagNames
	(F)(R) (-)     ConvertTagGroups                      R      (-)     GetExifToolVer                        W      (-)     SetBackupState
	W      (-)     CreateQViewImg                        F       -      GetGPSPos                             W      (-)     SetChrSetConversion
	W      (-)     CreateThumbSource                     F       -      GetImageDim                           W      (-)     SetOptTagOnEvent
	W      (-)     CreateThumbTarget                     W      (-)     GetNConvertVer                        W      (-)     SetQuickviewMode
	W      (-)     Crop                                  W      (-)     GetPackJPGVer                         F       O  1   SetXMPDaylightSavings
	F       O  1   DeleteMetadata                        W      (-)     GetShortName                          F       O  1   SetXMPLabel
	F       O  1   DeleteSelectedTags                    F       -      GetValForTagsInXMLTagDBTagList        F       O  1   SetXMPRating
	W      (-)     DelTempFiles                          R      (-)     GetXMPMP                              F       O  1   ShiftDateTime
	W      (-)     EditIni                               W      (-) 1   LosslessJPGOperation                  W      (-) 1   ShutdownExifTool [PID=nnn]
	R      (-) 1   ExecArgFile                           F       -      OpenSyncSelectedTagsDialog            W      (-) 1   StartUpExifTool [PID=nnn]
	FW      -      ExportTagsToMIE                       W      (-) 1   PackJPG                               F       -      SyncSelectedFiles[ReadSourceFile]
	F       -      ExportTagsToMIE [IPTCCheckEnc]        W      (-) 1   ProgramExit                           F       -      SyncSelectedFiles[ReadTargetFile]
	F       -      ExportTagsToMIE [IPTCSetEnc]          W      (-) 1   ProgramStart                          W      (-) 1   UnPackJPG
	W      (-)     ExportTagsToTXT                       W      (-)     ReadDescriptIon                       W      (-)     UseSidecarFile
	RW     (-)     ExportTagsToXML                       FR      -      ReadMetadata                          (F)R   (-)     ViewBinData
	F(R)W   -      ExportTagsToXMP                       R      (-)     ReadMetadataOnCondDel                 W      (-)     ViewImage
	FW      -      ExportTagsToXXX                       F       -      ReadSpecTags
	F       -      ExportTagsToXXX [IPTCCheckEnc]        W      (-)     ReadXMLTagDB (TagAdd)
	F       -      ExportTagsToXXX [IPTCSetEnc]          W      (-)     ReadXMLTagDB (TagChg)
	#ce
	If $intWriteLog = 0 Then Return
	If $intWriteLog = 2 Or StringInStr($cstrWriteLog1, $strTCMetadataViewerLogOperation) > 0 Then
		FileWriteLine($fhLog, @YEAR & "-" & @MON & "-" & @MDAY & " " & @HOUR & ":" & @MIN & ":" & @SEC & @TAB & $strTCMetadataViewerLogOperation & @TAB & $strTCMetadataViewerLogDetails)
	EndIf
EndFunc ;Func WriteLog($strTCMetadataViewerLogOperation, $strTCMetadataViewerLogDetails)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SplitTagListRec($strTagListRec)
	$strTagListRec = StringReplace($strTagListRec, @TAB, @TAB)
	If @extended <> 3 Then $strTagListRec = "ExifTool" & @TAB & $cstrNullString & @TAB & $cstrNullString & @TAB & StringReplace($strTagListRec, @TAB, "")
	$arrTagListRec = StringSplit($strTagListRec, @TAB)
	For $i = 1 To 4
		$arrTagListRec[$i] = StringToUTF8($arrTagListRec[$i])
	Next
	Return $arrTagListRec
EndFunc ;Func SplitTagListRec($strTagListRec)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExecArgFile()
	$strTCPathCurMem = @WorkingDir
	$strArgFile = @WorkingDir
	$p = StringInStr($strExifToolPath, "\", 1, -1)
	If $p > 0 Then $strArgFile = StringLeft($strExifToolPath, $p-1)

	$strArgFile = FileOpenDialog($cstrTCMetadataViewerVersion & " - ExecArgFile", $strArgFile, "Args (*.args)|All (*.*)", 1+2)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		$strExifToolParam = "-P"
		If $booBackup = False Then $strExifToolParam &= " -overwrite_original_in_place"
		;*** exiftool -tagsFromFile SRCFILE -@ iptc2xmp.args DSTFILE
		$strExifToolParam &= ' -@ "' & $strArgFile & '" "' & $strTCPathCur & $strTCFileCur & '"'
		$strExifToolOut = RunExifTool("ExecArgFile", $strExifToolParam, 1)
		If @error Then MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
		$booRefreshMetadataOnly = True ;Test: Metadaten-Anzeige auch im Falle @error aktualisieren
		$booFileIsModified = True
	EndIf

	FileChangeDir($strTCPathCurMem)
EndFunc

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#cs
Func ConvertTagGroups()

	If @GUI_CtrlId = $contextLvwTagsConvertUseArgs Then
		$strTCPathCurMem = @WorkingDir
		$strArgFile = @WorkingDir
		$p = StringInStr($strExifToolPath, "\", 1, -1)
		If $p > 0 Then $strArgFile = StringLeft($strExifToolPath, $p-1)
		$strArgFile = FileOpenDialog($cstrTCMetadataViewerVersion & " - ConvertTagGroups", $strArgFile, "Args (*.args)|All (*.*)", 1+2)

		If @error = 0 Then
			$strExifToolParam = "-P"
			If $booBackup = False Then $strExifToolParam &= " -overwrite_original_in_place"
			;*** exiftool -tagsFromFile SRCFILE -@ iptc2xmp.args DSTFILE
			$strExifToolParam &= ' -@ "' & $strArgFile & '" "' & $strTCPathCur & $strTCFileCur & '"'
			$strExifToolOut = RunExifTool("ConvertTagGroups", $strExifToolParam, -1)
			If @error Then MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
			$booRefreshMetadataOnly = True ;Test: Metadaten-Anzeige auch im Falle @error aktualisieren
			$booFileIsModified = True
		EndIf

		FileChangeDir($strTCPathCurMem)
		Return

	EndIf

	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF

	If @GUI_CtrlId = $contextLvwTagsConvertIPTC2XMP Then
		$strExifToolParam &= "-XMP-dc:Creator < IPTC:By-line" & @CRLF
		$strExifToolParam &= "-XMP-dc:Description < IPTC:Caption-Abstract" & @CRLF
		$strExifToolParam &= "-XMP-dc:Rights < IPTC:CopyrightNotice" & @CRLF
		$strExifToolParam &= "-XMP-dc:Subject < IPTC:Keywords" & @CRLF
		$strExifToolParam &= "-XMP-dc:Title < IPTC:ObjectName" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:AuthorsPosition < IPTC:By-lineTitle" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:CaptionWriter < IPTC:Writer-Editor" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Category < IPTC:Category" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:City < IPTC:City" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Country < IPTC:Country-PrimaryLocationName" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Credit < IPTC:Credit" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:DateCreated < IPTC:DateCreated" & @CRLF
		$strExifToolParam &= "# overwrite XMP DateCreated to include date and time if available" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:DateCreated < Composite:DateTimeCreated" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Headline < IPTC:Headline" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Instructions < IPTC:SpecialInstructions" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Source < IPTC:Source" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:State < IPTC:Province-State" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:SupplementalCategories < IPTC:SupplementalCategories" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:TransmissionReference < IPTC:OriginalTransmissionReference" & @CRLF
		$strExifToolParam &= "-XMP-photoshop:Urgency < IPTC:Urgency" & @CRLF
		$strExifToolParam &= "-XMP-iptcCore:CountryCode < IPTC:Country-PrimaryLocationCode" & @CRLF
		$strExifToolParam &= "-XMP-iptcCore:Location < IPTC:Sub-location" & @CRLF
		$strExifToolParam &= "-XMP-xmp:CreateDate < IPTC:DigitalCreationDate" & @CRLF
		$strExifToolParam &= "-XMP-xmp:CreateDate < Composite:DigitalCreationDateTime" & @CRLF
		$strExifToolParam &= "# these tags are not free-form text, and may need special handling:" & @CRLF
		$strExifToolParam &= "#-XMP-iptcCore:IntellectualGenre < IPTC:ObjectAttributeReference" & @CRLF
		$strExifToolParam &= "#-XMP-iptcCore:SubjectCode < IPTC:SubjectReference" & @CRLF
		$strExifToolParam &= "-Photoshop:IPTCDigest=new" & @CRLF
	EndIf

	If @GUI_CtrlId = $contextLvwTagsConvertXMP2IPTC Then

		;*** IPTC-Tags zunchst (und nichtbedingt) nach UTF8 konvertieren
		$strExifToolParamCvIPTC = "-P" & @CRLF
		If $booBackup = False Then $strExifToolParamCvIPTC &= "-overwrite_original_in_place" & @CRLF
		$strExifToolParamCvIPTC &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=utf8" & @CRLF
		$strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParamCvIPTC, $strTCPathCur & $strTCFileCur, -1, "Def")

		$strExifToolParam &= "-IPTC:By-line < XMP-dc:Creator" & @CRLF
		$strExifToolParam &= "-IPTC:Caption-Abstract < XMP-dc:Description" & @CRLF
		$strExifToolParam &= "-IPTC:CopyrightNotice < XMP-dc:Rights" & @CRLF
		$strExifToolParam &= "-IPTC:Keywords < XMP-dc:Subject" & @CRLF
		$strExifToolParam &= "-IPTC:ObjectName < XMP-dc:Title" & @CRLF
		$strExifToolParam &= "-IPTC:By-lineTitle < XMP-photoshop:AuthorsPosition" & @CRLF
		$strExifToolParam &= "-IPTC:Writer-Editor < XMP-photoshop:CaptionWriter" & @CRLF
		$strExifToolParam &= "-IPTC:Category < XMP-photoshop:Category" & @CRLF
		$strExifToolParam &= "-IPTC:City < XMP-photoshop:City" & @CRLF
		$strExifToolParam &= "-IPTC:Country-PrimaryLocationName < XMP-photoshop:Country" & @CRLF
		$strExifToolParam &= "-IPTC:Credit < XMP-photoshop:Credit" & @CRLF
		$strExifToolParam &= "-IPTC:DateCreated < XMP-photoshop:DateCreated" & @CRLF
		$strExifToolParam &= "# magically extracts time from a date/time value" & @CRLF
		$strExifToolParam &= "-IPTC:TimeCreated < XMP-photoshop:DateCreated" & @CRLF
		$strExifToolParam &= "-IPTC:Headline < XMP-photoshop:Headline" & @CRLF
		$strExifToolParam &= "-IPTC:SpecialInstructions < XMP-photoshop:Instructions" & @CRLF
		$strExifToolParam &= "-IPTC:Source < XMP-photoshop:Source" & @CRLF
		$strExifToolParam &= "-IPTC:Province-State < XMP-photoshop:State" & @CRLF
		$strExifToolParam &= "-IPTC:SupplementalCategories < XMP-photoshop:SupplementalCategories" & @CRLF
		$strExifToolParam &= "-IPTC:OriginalTransmissionReference < XMP-photoshop:TransmissionReference" & @CRLF
		$strExifToolParam &= "-IPTC:Urgency < XMP-photoshop:Urgency" & @CRLF
		$strExifToolParam &= "-IPTC:Country-PrimaryLocationCode < XMP-iptcCore:CountryCode" & @CRLF
		$strExifToolParam &= "-IPTC:Sub-location < XMP-iptcCore:Location" & @CRLF
		$strExifToolParam &= "-IPTC:DigitalCreationDate < XMP-xmp:CreateDate" & @CRLF
		$strExifToolParam &= "-IPTC:DigitalCreationTime < XMP-xmp:CreateDate" & @CRLF
		$strExifToolParam &= "# these tags are not free-form text, and may need special handling:" & @CRLF
		$strExifToolParam &= "#-IPTC:ObjectAttributeReference < XMP-iptcCore:IntellectualGenre" & @CRLF
		$strExifToolParam &= "#-IPTC:SubjectReference < XMP-iptcCore:SubjectCode" & @CRLF
		$strExifToolParam &= "-Photoshop:IPTCDigest=new" & @CRLF
	EndIf

	$strExifToolOut = FeedExifTool("ConvertTagGroups", $strExifToolParam, $strTCPathCur & $strTCFileCur, -1, "Def")
	#cs
	If @error Then
		MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
	Else
		$booRefreshMetadataOnly = True
	EndIf
	#ce
	If @error Then MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
	$booRefreshMetadataOnly = True ;Test: Metadaten-Anzeige auch im Falle @error aktualisieren
	$booFileIsModified = True

EndFunc ;Func ConvertTagGroups()
#ce

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func DeleteTagGroups()
	Switch @GUI_CtrlId
		Case $contextLvwTagsDeleteAllTags
			DeleteMetadata("all")
		Case $contextLvwTagsDeleteXMPTags
			DeleteMetadata("XMP:all")
		Case $contextLvwTagsDeleteIPTCTags
			DeleteMetadata("IPTC:all")
	EndSwitch
EndFunc ;Func DeleteTagGroups()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func DeleteMetadata($strMode)
	$strExifToolParam = "-P" & @CRLF

	If $booUnicodeFilename = True And $booBackup = True Then
		MsgBox(64+262144, $cstrTCMetadataViewerVersion, "DeleteMetadata (" & $strMode & ")" & @LF & $strTCFileCurOri & @LF & $arrLocStr[86])
		Return
	EndIf

	If $booBackup = False Then
		$strErrMsg = StringReplace($arrLocStr[84], "%m", $strMode)
		$strErrMsg = StringReplace($strErrMsg, "%n", $strTCPathCurOri & $strTCFileCurOri)
		If MsgBox(4+32+256+262144, $cstrTCMetadataViewerVersion, $strErrMsg) = 7 Then Return
		$strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	EndIf

	;*** Fr Abfrage, ob Sidecar-File existiert, $strTCPathCur statt $strTCPathCurOri und $strTCFileCur statt $strTCFileCurOri verwenden,
	;*** da %d%f auch aus $strTCPathCur und $strTCFileCur gebildet werden. Wenn der Shortname-Stamm des Sidecar-Files vom Shortname-Stamm des Image-Files abweicht,
	;*** dann schlgt die Sidecar-File-Prozessierung fehl
	;If $intUseSidecarFile = 1 And FileExists($strTCPathCur & StringLeft($strTCFileCur, StringInStr($strTCFileCur, ".", 0, -1)) & $strSidecarFileType) Then
	;	$strExifToolParam &= "-srcfile" & @CRLF
	;	$strExifToolParam &= "%d%f." & $strSidecarFileType & @CRLF
	;EndIf

	$strExifToolParam &= "-" & $strMode & "=" & @CRLF

	$strExifToolOut = FeedExifTool("DeleteMetadata", $strExifToolParam, $strTCPathCur & $strTCFileCur, 1, "Def")
	If @error Then
		MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
	Else
		$booRefreshMetadataOnly = True
	EndIf
	$booFileIsModified = True
EndFunc ;Func DeleteMetadata($strMode)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func DeleteSelectedTags()
	#cs
	$arrSelectedTags = IniReadSection($cstrIniFile, "SelectedTags")
	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then
		$strErrMsg = "Laut INI-Sektion [SelectedTags]:" & @LF ;Todo: Lokalisieren
		For $i = 1 To $arrSelectedTags[0][0]
			If $arrSelectedTags[$i][0] = "Header" Then
				$strErrMsg &= @LF & StringToUTF8($arrSelectedTags[$i][1]) & "  " & @TAB
			Else
				$strErrMsg &= $arrSelectedTags[$i][1] & "  "
			EndIf
		Next
		$strErrMsg = StringTrimRight($strErrMsg, 3)
		$strErrMsg = StringReplace($arrLocStr[84], "%m", $strErrMsg)
		$strErrMsg = StringReplace($strErrMsg, "%n", $strTCPathCur & $strTCFileCur)
		If MsgBox(4+32+256+262144, $cstrTCMetadataViewerVersion & " - " & "Tags lschen: Ausgewhlte Tags lschen", $strErrMsg) = 7 Then Return ;Todo: Lokalisieren
		$strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	EndIf

	For $i = 1 To $arrSelectedTags[0][0]
		If $arrSelectedTags[$i][0] <> "Header" Then $strExifToolParam &= "-" & $arrSelectedTags[$i][1] & "=" & @CRLF
	Next

	$strExifToolOut = FeedExifTool("DeleteSelectedTags", $strExifToolParam, $strTCPathCur & $strTCFileCur, -1, "Def")
	If @error Then
		MsgBox(48+262144, $arrLocStr[82], $strTCFileCur & @LF & @LF & $strExifToolErr)
	Else
		$booRefreshMetadataOnly = True
	EndIf
	$booFileIsModified = True
	#ce

	$strSourceFile = ""
	$strTargetFile = FileGetShortName($strTCFileCur)
	OpenSyncSelectedTagsDialog()

EndFunc ;Func DeleteSelectedTags()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenSyncSelectedFilesDialog()

	SetWinOnTopState(0)
	GUICtrlSetState($btnSyncSelectedFilesSave, $GUI_SHOW)
	GUICtrlSetData($btnSyncSelectedFilesCancel, $arrLocStr[76])
	GUISetState(@SW_SHOW, $frmSyncSelectedFiles)
	GUISwitch($frmSyncSelectedFiles)

	GetTCActivePanelProperties() ;$strTCPathInactive (Pfad im inaktiven Panel) aktualisieren

	$strClipSave = ClipGet() ;*** Clipboard-Inhalt sichern
	ClipPut("") ;*** Clipboard leeren (um nach cm_CopyFullNamesToClip feststellen zu knnen, ob TC "Keine Dateien gewhlt!" meldet)
	DllCall("user32.dll", "int", "PostMessage", "hwnd", WinGetHandle("classname=TTOTAL_CMD"), "int", 1075, "int", 2018, "int", 0) ;*** cm_CopyFullNamesToClip=2018;Copy names with full path
	Sleep(200)
	$strClipCur = ClipGet()
	Sleep(200)
	ClipPut($strClipSave) ;*** Clipboard-Inhalt wiederherstellen

	#cs
	;*** Wenn die *fokussierte* Datei *nicht markiert* ist, diese ebenfalls in die Dateiliste mit aufnehmen
	If $strTCPathCur = "" Then
		$strTCFilepathCur = @WorkingDir & "\" & $strTCFileCur
	Else
		$strTCFilepathCur = $strTCPathCur & $strTCFileCur
	EndIf
	;*** $strClipCur enthlt die originalen Unicode-Dateinamen, daher muss in $strClipCur auch mit dem Originalnamen der fokussierten Datei gesucht werden
;~ 	If StringInStr($strClipCur, $strTCFilepathCur) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
	If StringInStr($strClipCur, $strTCPathCurOri & $strTCFileCurOri) = 0 Then $strClipCur &= @CRLF & $strTCFilepathCur
	#ce

	;*** Eintrge der Dateiliste aus Clipboard in Feld $arrTCFileSel einlesen
	$arrTCFileSel = StringSplit($strClipCur, @CRLF, 1)

	_GUICtrlListView_DeleteAllItems($hlvwSyncSelectedFiles)
	$strListviewItemSyncSelectedFilesIDList = ""
	_GUICtrlListView_BeginUpdate($hlvwSyncSelectedFiles)

	For $i = 1 To $arrTCFileSel[0]
		$strTmp = StringReplace($arrLocStr[123], "%NumCur", $i)
		$strTmp = StringReplace($strTmp, "%NumTot", $arrTCFileSel[0])
		GUICtrlSetData($lblSyncSelectedFiles, $strTmp) ;Validating file %NumCur / %NumTot & ...

		$p = StringInStr($arrTCFileSel[$i], "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
		$strTCPathSel = StringLeft($arrTCFileSel[$i], $p-1)
		$strTCFileSel = StringMid($arrTCFileSel[$i], $p+1)
		$strErrMsg = ""

		;*** Prfen, ob die markierte Quell-Datei existiert (z.B. falls Navigation innerhalb eines Archivs)
		If Not FileExists($arrTCFileSel[$i]) Then $strErrMsg = "Source n/a>"

		;*** Prfen, ob die Ziel-Datei zur markierten Quell-Datei existiert
		If Not FileExists($strTCPathInactive & "\" & $strTCFileSel) Then
			$strErrMsg = "Target n/a>"
			$strTCFileTarget = ""
		Else
			$strTCFileTarget = $strTCFileSel
		EndIf

		;*** Prfen, ob der markierte Eintrag Unicode-Zeichen enthlt und ein Backup angelegt werden soll
		If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) And $booBackup = True Then $strErrMsg = "Uni>"

		$p = StringInStr($arrTCFileSel[$i], ".", 0, -1)
		If $p > 0 Then
			$strTCExtSel = StringMid($arrTCFileSel[$i], $p+1)
			#cs
			;*** Tag-Sync von PJG-Files ist nicht mglich
			If $strTCExtSel = "pjg" Then $strErrMsg = "PJG>"
			;*** Prfen, ob es sich um eine Bilddatei handelt
			If StringInStr("|mie|xml|xmp|" & IniRead($cstrIniFile, "Configuration", "ImageConvertFileExtsSTD", "") & "|", "|" & $strTCExtSel & "|") = 0 Then $strErrMsg = "NotAnImg>"
			;*** Prfen, ob der Dateityp (Dateinamenserweiterung) von ExifTool untersttzt wird
			If IniRead($cstrIniFile, "FileExtensionsUnsupported", $strTCExtSel, "1") = "0" Then $strErrMsg = "Ext>"
			#ce
			$strWritableExts = FileRead(@ScriptDir & "\TCMetadataViewer_ExifTool_WritableExts.txt")
			If StringInStr($strWritableExts, " " & $strTCExtSel) = 0 Then $strErrMsg = "ExtNotWritable>"
		EndIf

		;*** Prfen, ob der markierte Eintrag ein Verzeichnis ist
		If StringInStr(FileGetAttrib($arrTCFileSel[$i]), "D") > 0 Then
			$strErrMsg = "Dir>"
			$p = StringInStr($strTCPathSel, "\", 0, -1)
			$strTCFileSel = StringMid($strTCPathSel, $p+1)
			$strTCPathSel = StringLeft($strTCPathSel, $p-1)
		EndIf

		;*** Prfen, ob der markierte Eintrag (Target-File) schreibgeschtzt ("R"), versteckt ("H") oder eines Systemdatei ("S") ist
		;Todo: Msste aber fr die Zieldateien geprft werden
		If StringInStr(FileGetAttrib($strTCPathInactive & $strTCFileTarget), "R") > 0 Or StringInStr(FileGetAttrib($strTCPathInactive & $strTCFileTarget), "S") > 0 Or StringInStr(FileGetAttrib($strTCPathInactive & $strTCFileTarget), "H") > 0 Then
			$booFileIsSavable = False
			$strErrMsg = "RHS>"
		EndIf

		If $strErrMsg = "" Then
			;***                                                                Msg           |SourcePath            |SourceFile           ||*|#|=||TargetPath                |TargetFile"
			;***                                                                Msg           |SourcePath            |SourceFile           ||*|#|=||TargetPath                |TargetFile"
			$strListviewItemSyncSelectedFilesIDList &= GUICtrlCreateListViewItem($strErrMsg & "|" & $strTCPathSel & "\|" & $strTCFileSel & "|?|?|?|?|?|" & $strTCPathInactive & "|" & $strTCFileTarget, $lvwSyncSelectedFiles) & @LF
			GUICtrlSetColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncDefault", "0x5D7080"))
		Else
			$strListviewItemSyncSelectedFilesIDList &= GUICtrlCreateListViewItem($strErrMsg & "|" & $strTCPathSel & "\|" & $strTCFileSel & "|-|-|-|-|-|" & $strTCPathInactive & "|" & $strTCFileTarget, $lvwSyncSelectedFiles) & @LF
			GUICtrlSetColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncSkip", "0x808080"))
		EndIf

	Next

	_GUICtrlListView_EndUpdate($hlvwSyncSelectedFiles)

	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 0, $LVSCW_AUTOSIZE)           ;Msg
	;_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 1, $LVSCW_AUTOSIZE_USEHEADER) ;SourcePath
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 2, $LVSCW_AUTOSIZE)           ;SourceFile
	;_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 8, $LVSCW_AUTOSIZE_USEHEADER) ;TargetPath
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 9, $LVSCW_AUTOSIZE)           ;TargetFile


	;*** Tags aller Dateien ohne Fehler ($strErrMsg = "") vergleichen
	$strExifToolParam  = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
	$strExifToolParam &= "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
	If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
	If $strOptTagNam = "Desc" Then
		$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
	Else
		$strExifToolParam &= "-s" & @CRLF
	EndIf

	$arrSelectedTags = IniReadSection($cstrIniFile, "SelectedTags")
	For $i = 1 To $arrSelectedTags[0][0]
		If $arrSelectedTags[$i][0] = "Header" Then
			$strExifToolParam &= "-TCMetadataViewer:TCMV_" & StringStripWS($arrSelectedTags[$i][1], 8) & @CRLF
		Else
			$strExifToolParam &= "-" & $arrSelectedTags[$i][1] & @CRLF
		EndIf
	Next

	$arrListviewItemSyncSelectedFilesIDList = StringSplit($strListviewItemSyncSelectedFilesIDList, @LF)
	For $i = 1 To $arrListviewItemSyncSelectedFilesIDList[0]-1

		$strTmp = StringReplace($arrLocStr[124], "%NumCur", $i)
		$strTmp = StringReplace($strTmp, "%NumTot", $arrListviewItemSyncSelectedFilesIDList[0]-1)
		GUICtrlSetData($lblSyncSelectedFiles, $strTmp) ;Comparing tags for file %NumCur / %NumTot & ...

		$arrListviewItemSyncSelectedFiles = StringSplit(GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i]), "|")
		;*** ListViewItem enthlt in der ersten Spalte einen Fehlercode. Ist dieser belegt ("Uni>", "NoImg>" o..), dann wird die entsprechende Datei
		;*** nicht weiter analysiert, d.h., es werden fr Source- und Target-File keine Tags extrahiert und verglichen
		If $arrListviewItemSyncSelectedFiles[1] <> "" Then ContinueLoop

		;*** Prfen, ob der markierte Eintrag (Source) Unicode-Zeichen enthlt
		If $arrTCFileSel[$i] <> BinaryToString($arrTCFileSel[$i]) Then
			$strSourceFile = FileGetShortName($arrTCFileSel[$i])
		Else
			$strSourceFile = $arrTCFileSel[$i]
		EndIf

		$strExifToolOut = FeedExifTool("SyncSelectedFiles[ReadSourceFile]", $strExifToolParam, $strSourceFile, 1, "Def")
		$arrTagListTCFileSource = StringSplit($strExifToolOut, @CRLF, 1)

		$p = StringInStr($arrTCFileSel[$i], "\", 0, -1) ;*** Todo: Prfen: Gibt es Flle, in denen der volle Dateipfad kein "\" enthlt?
		$strTCFileSel = StringMid($arrTCFileSel[$i], $p+1)
		$strTCFileTarget = $strTCPathInactive & $strTCFileSel

		;*** Prfen, ob der markierte Eintrag (Target) Unicode-Zeichen enthlt
		If $strTCFileTarget <> BinaryToString($strTCFileTarget) Then
			$strTargetFile = FileGetShortName($strTCFileTarget)
		Else
			$strTargetFile = $strTCFileTarget
		EndIf

		;*** Todo: Wenn $intUseSidecarFile=1, dann wird versucht, ein Sidecar-File auch vom Target-File zu lesen. Wenn Sidecar zum Target nicht existiert, dieses jeweils anlegen.
		;*** Todo: Wenn der markierte Eintrag (Target) Unicode-Zeichen enthlt...
;~ 		If $intUseSidecarFile = 1 And Not FileExists($strTCPathInactive & StringLeft($strTCFileSel, StringInStr($strTCFileSel, ".", 0, -1)) & $strSidecarFileType) Then
;~ 			WriteLog("Debug:CheckSidecarfileTarget", $strTCPathInactive & StringLeft($strTCFileSel, StringInStr($strTCFileSel, ".", 0, -1)) & $strSidecarFileType) ;debug
;~ 			ExportTagsToMIE($strTCPathInactive, $strTCFileSel, $strSidecarFileType, "", False)
;~ 			WriteLog("Debug:ExportTagsToMIE", $strTCPathInactive & StringLeft($strTCFileSel, StringInStr($strTCFileSel, ".", 0, -1)) & $strSidecarFileType) ;debug
;~ 		EndIf

		$strExifToolOut = FeedExifTool("SyncSelectedFiles[ReadTargetFile]", $strExifToolParam, $strTargetFile, 1, "Def")
		$arrTagListTCFileTarget = StringSplit($strExifToolOut, @CRLF, 1)

		$intSyncTagNA  = 0
		$intSyncTagNew = 0
		$intSyncTagNEq = 0
		$intSyncTagEq  = 0
		$intSyncTagObs = 0

		For $j = 1 To $arrTagListTCFileSource[0]-1
			;*** Potentielle Fehlerquelle: Von TagVal werden nur die ersten 259 Zeichen bercksichtigt, auch beim Vergleich von TagValSource <-> TagValTarget!!!
			$arrTagTCFileSource = SplitTagListRec($arrTagListTCFileSource[$j])
			$arrTagTCFileSource[4] = StringReplace($arrTagTCFileSource[4], "|", "") ;*** Pipe trennt Listview-Elemente und muss in TagVal daher "maskiert" werden
			If StringLen($arrTagTCFileSource[4]) > 259 Then $arrTagTCFileSource[4] = StringLeft($arrTagTCFileSource[4], 259-4) & " []"

			$arrTagTCFileTarget = SplitTagListRec($arrTagListTCFileTarget[$j])
			$arrTagTCFileTarget[4] = StringReplace($arrTagTCFileTarget[4], "|", "") ;*** Pipe trennt Listview-Elemente und muss in TagVal daher "maskiert" werden
			If StringLen($arrTagTCFileTarget[4]) > 259 Then $arrTagTCFileTarget[4] = StringLeft($arrTagTCFileTarget[4], 259-4) & " []"

			If StringLeft($arrTagTCFileSource[3], 5) = "TCMV_" Then ContinueLoop

			;*** Vereinfachte Form, ein potentielles List-Tag zu identifizieren: Prsenz des Separators ", "
			;*** Nachteil: Nicht-List-Tags, die ", " enthalten (z.B. beschreibende Texte) werden ebenfalls ausgwertet
			If StringInStr($arrTagTCFileSource[4], ", ") > 0 And StringInStr($arrTagTCFileTarget[4], ", ") > 0 Then
				;*** Fr $arrTagTCFileSource...
				$arrTagVal = StringSplit($arrTagTCFileSource[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 1, 1)
				$arrTagTCFileSource[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagTCFileSource[4] &= $arrTagVal[$k] & ", "
				Next

				;*** Fr $arrTagTCFileTarget...
				$arrTagVal = StringSplit($arrTagTCFileTarget[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 1, 1)
				$arrTagTCFileTarget[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagTCFileTarget[4] &= $arrTagVal[$k] & ", "
				Next
			EndIf

			Select
				;*** Tag auf beiden Seiten nicht vorhanden (TagValSource nicht vorhanden, TagValTarget nicht vorhanden)
				Case $arrTagTCFileSource[4] = $cstrNullString And $arrTagTCFileTarget[4] = $cstrNullString
					$intSyncTagNA += 1
				;*** Tag obsolet/entfallend (TagValSource nicht vorhanden, TagValTarget vorhanden)
				Case $arrTagTCFileSource[4] = $cstrNullString ;Tag obsolet
					$intSyncTagObs += 1
				;*** Tag identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagTCFileSource[4] == $arrTagTCFileTarget[4]
					$intSyncTagEq += 1
				;*** Tag neu
				Case $arrTagTCFileSource[4] <> $cstrNullString And $arrTagTCFileTarget[4] = $cstrNullString
					$intSyncTagNew += 1
				;*** Tag ungleich oder Tag gleich, aber nicht identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagTCFileSource[4] <> $arrTagTCFileTarget[4] Or $arrTagTCFileSource[4] = $arrTagTCFileTarget[4]
					$intSyncTagNEq += 1
				Case Else
					;NOP
			EndSelect

		Next

		;*** 1  |2         |3         |4|5|6|7|8|9         |10
		;*** Msg|SourcePath|SourceFile||*|#|=||TargetPath|TargetFile
		GUICtrlSetData($arrListviewItemSyncSelectedFilesIDList[$i], $arrListviewItemSyncSelectedFiles[1] & "|" & $arrListviewItemSyncSelectedFiles[2] & "|" & $arrListviewItemSyncSelectedFiles[3] & "|" & $intSyncTagNA & "|" & $intSyncTagNew & "|" & $intSyncTagNEq & "|" & $intSyncTagEq & "|" & $intSyncTagObs & "|" & $arrListviewItemSyncSelectedFiles[9] & "|" & $arrListviewItemSyncSelectedFiles[10])
		$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncMixed", "0x5080FF") ;*** Mischung aus neuen, ungleichen und entfallenden Tags
		If $intSyncTagEq + $intSyncTagNew + $intSyncTagNEq + $intSyncTagObs = 0 Then $intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNoMatch", "0x808080") ;*** Nur nichtvorhandene Tags
		If $intSyncTagEq  > 0 And $intSyncTagNew + $intSyncTagNEq + $intSyncTagObs = 0 Then $intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncEqual", "0xD0D0D0") ;*** Nur gleiche Tags ; 0x000000, 0xC0C0C0
		If $intSyncTagNew > 0 And $intSyncTagNEq = 0 And $intSyncTagObs = 0 Then $intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNew", "0x99CC00") ;*** Nur neue Tags
		If $intSyncTagNew = 0 And $intSyncTagNEq > 0 And $intSyncTagObs = 0 Then $intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNotEqual", "0xFFCC00") ;*** Nur ungleiche Tags
		If $intSyncTagNew = 0 And $intSyncTagNEq = 0 And $intSyncTagObs > 0 Then $intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncObs", "0xFF6600") ;*** Nur obsolete/entfallende Tags; 0xC00000
		GUICtrlSetColor($arrListviewItemSyncSelectedFilesIDList[$i], $intColor)

	Next

	GUICtrlSetData($lblSyncSelectedFiles, "")

EndFunc ;Func OpenSyncSelectedFilesDialog()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SaveSyncSelectedFiles()
	$strExifToolParam  = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
	$strExifToolParam &= "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
	If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
	If $strOptTagNam = "Desc" Then
		$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
	Else
		$strExifToolParam &= "-s" & @CRLF
	EndIf

	$arrSelectedTags = IniReadSection($cstrIniFile, "SelectedTags")
	For $i = 1 To $arrSelectedTags[0][0]
		If $arrSelectedTags[$i][0] <> "Header" Then $strExifToolParam &= "-" & $arrSelectedTags[$i][1] & @CRLF
	Next

	$arrListviewItemSyncSelectedFilesIDList = StringSplit($strListviewItemSyncSelectedFilesIDList, @LF)

	$booSaveSyncSelectedFiles = False
	For $i = 1 To $arrListviewItemSyncSelectedFilesIDList[0]-1
		$arrListviewItemSyncSelectedFiles = StringSplit(GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i]), "|")
		;*** ListViewItem enthlt in der ersten Spalte einen Fehlercode. Ist dieser belegt ("Uni>", "NoImg>" o..),
		;*** dann wird die entsprechende Datei nicht weiter verarbeitet, d.h., es werden keine Tags synchronisiert
		If $arrListviewItemSyncSelectedFiles[1] = "" And GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i], 1) = $GUI_CHECKED Then
			$booSaveSyncSelectedFiles = True
			ExitLoop
		EndIf
	Next
	If $booSaveSyncSelectedFiles = False Then
		MsgBox(0+48+262144, "SyncSelectedFiles - " & $arrLocStr[75], $arrLocStr[138]) ;Nothing to do - No tag is selected
		Return
	EndIf

	For $i = 1 To $arrListviewItemSyncSelectedFilesIDList[0]-1

		$arrListviewItemSyncSelectedFiles = StringSplit(GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i]), "|")
		;*** ListViewItem enthlt in der ersten Spalte einen Fehlercode. Ist dieser belegt ("Uni>", "NoImg>" o..),
		;*** dann wird die entsprechende Datei nicht weiter verarbeitet, d.h., es werden keine Tags synchronisiert
		If $arrListviewItemSyncSelectedFiles[1] <> "" Or GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i], 1) = $GUI_UNCHECKED Then
			_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $i-1, $arrLocStr[126], 0) ;*** Skipped>
			_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 0, $LVSCW_AUTOSIZE)    ;Spalte "Msg"
			ContinueLoop
		EndIf

		;Todo: Anzeige Source-Filename im Label: Tatschlich wird ja das Target-File ($arrListviewItemSyncSelectedFiles[10]) verndert; zur Zeit werden eh nur Source und Target mit identischem Namen verarbeitet
		$strTmp = StringReplace($arrLocStr[125], "%NumCur", $i)
		$strTmp = StringReplace($strTmp, "%NumTot", $arrListviewItemSyncSelectedFilesIDList[0]-1)
		$strTmp = StringReplace($strTmp, "%File", $arrListviewItemSyncSelectedFiles[3])
		GUICtrlSetData($lblSyncSelectedFiles, $strTmp) ;Synchronizing tags for file %NumCur / %NumTot: %File...

		;Todo: Source darf Unicode-Namen haben (wird ja nur gelesen); Target darf Unicode-Namen haben, wenn kein Backup angelegt werden soll. Bedenke: zur Zeit werden eh nur Source und Target mit identischem Namen verarbeitet
		$strSourceFile = $arrListviewItemSyncSelectedFiles[2] & $arrListviewItemSyncSelectedFiles[3]
		;*** Prfen, ob der Eintrag (Source) Unicode-Zeichen enthlt
		If $strSourceFile <> BinaryToString($strSourceFile) Then $strSourceFile = FileGetShortName($strSourceFile)

		$strExifToolOut = FeedExifTool("SyncSelectedFiles[ReadSourceFile]", $strExifToolParam, $strSourceFile, 1, "Def")
		$arrTagListTCFileSource = StringSplit($strExifToolOut, @CRLF, 1)

		;Todo: Source darf Unicode-Namen haben (wird ja nur gelesen); Target darf Unicode-Namen haben, wenn kein Backup angelegt werden soll. Bedenke: zur Zeit werden eh nur Source und Target mit identischem Namen verarbeitet
		$strTargetFile = $arrListviewItemSyncSelectedFiles[9] & $arrListviewItemSyncSelectedFiles[10]
		;*** Prfen, ob der Eintrag (Target) Unicode-Zeichen enthlt
		If $strTargetFile <> BinaryToString($strTargetFile) Then $strTargetFile = FileGetShortName($strTargetFile)
		$strExifToolOut = FeedExifTool("SyncSelectedFiles[ReadTargetFile]", $strExifToolParam, $strTargetFile, 1, "Def")
		$arrTagListTCFileTarget = StringSplit($strExifToolOut, @CRLF, 1)

		;Todo: "Sidecar-Datei verwenden" implementieren; UTF8-Konvertierung IPTC-Tags (prfen, was hier getan werden msste)
		$booSaveSyncSelectedFiles = False
		$strExifToolParam2 = "-P" & @CRLF
		If $booBackup = False Then $strExifToolParam2 &= "-overwrite_original_in_place" & @CRLF
		$strExifToolParam2 &= "-TagsFromFile" & @CRLF & StringRegExpReplace($strSourceFile, "^(#|-)", ".\\\1") & @CRLF

		;*** Encoding IPTC-Tags
		$booConvertIPTCTagsToUTF8 = False
		$strExifToolParamCvIPTC = ""

		;*** Metadata-Datum prfen
		If GUICtrlRead($chkSyncSelectedFilesIfMetadataNewer) = $GUI_CHECKED Then
			For $j = 1 To $arrTagListTCFileSource[0]-1
				$arrTagTCFileSource = SplitTagListRec($arrTagListTCFileSource[$j])
				$arrTagTCFileTarget = SplitTagListRec($arrTagListTCFileTarget[$j])
;~ 				ConsoleWrite("1: " & $arrTagTCFileSource[1] & "  2: " & $arrTagTCFileSource[2] & "  3: " & $arrTagTCFileSource[3] & "  4: " & $arrTagTCFileSource[4] & @CRLF) ;debug
;~ 				#cs
				If $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] = "XMP:MetadataDate" And $arrTagTCFileSource[4] <= $arrTagTCFileTarget[4] Then
;~ 					_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $i-1, $arrLocStr[126], 0) ;*** Skipped>
					_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $i-1, "*** Out-dated", 0) ;Todo: Lokalisieren
					_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 0, $LVSCW_AUTOSIZE)    ;Spalte "Msg"
					ContinueLoop 2
				EndIf
;~ 				#ce
			Next
		EndIf

		For $j = 1 To $arrTagListTCFileSource[0]-1
			$arrTagTCFileSource = SplitTagListRec($arrTagListTCFileSource[$j])
			$arrTagTCFileTarget = SplitTagListRec($arrTagListTCFileTarget[$j])

			;*** Vereinfachte Form, ein potentielles List-Tag zu identifizieren: Prsenz des Separators ", "
			If StringInStr($arrTagTCFileSource[4], ", ") > 0 And StringInStr($arrTagTCFileTarget[4], ", ") > 0 Then
				;*** Fr $arrTagTCFileSource...
				$arrTagVal = StringSplit($arrTagTCFileSource[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 1, 1)
				$arrTagTCFileSource[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagTCFileSource[4] &= $arrTagVal[$k] & ", "
				Next

				;*** Fr $arrTagTCFileTarget...
				$arrTagVal = StringSplit($arrTagTCFileTarget[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 1, 1)
				$arrTagTCFileTarget[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagTCFileTarget[4] &= $arrTagVal[$k] & ", "
				Next
			EndIf

			Select
				Case $arrTagTCFileSource[4] = $cstrNullString And $arrTagTCFileTarget[4] = $cstrNullString
					;NOP

;~ 				;*** Tag obsolet/entfallend (TagValSource nicht vorhanden, TagValTarget vorhanden)
				Case $arrTagTCFileSource[4] = $cstrNullString
					;NOP

;~ 				;*** Tag identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagTCFileSource[4] == $arrTagTCFileTarget[4]
					;NOP

				;*** Tag neu
				Case $arrTagTCFileSource[4] <> $cstrNullString And $arrTagTCFileTarget[4] = $cstrNullString
					If GUICtrlRead($chkSyncSelectedFilesNew) = $GUI_CHECKED Then
						If $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] = "XMP:RegionPersonDisplayName" Or $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] = "XMP:Rectangle" Then
							$strExifToolParam2 &= "-XMP-MP:RegionInfoMP" & @CRLF
						Else
							$strExifToolParam2 &= "-" & $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] & @CRLF
						EndIf
						$booSaveSyncSelectedFiles = True

						;*** Encoding IPTC-Tags
						If $arrTagTCFileSource[1] = "IPTC" And ($booAlwaysWriteUTF8 = True Or $arrTagTCFileSource[4] <> BinaryToString($arrTagTCFileSource[4], 1)) Then $booConvertIPTCTagsToUTF8 = True

					EndIf

				;*** Tag ungleich oder Tag gleich, aber nicht identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagTCFileSource[4] <> $arrTagTCFileTarget[4] Or $arrTagTCFileSource[4] = $arrTagTCFileTarget[4]
					If GUICtrlRead($chkSyncSelectedFilesUnequal) = $GUI_CHECKED Then
						If $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] = "XMP:RegionPersonDisplayName" Or $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] = "XMP:Rectangle" Then
							$strExifToolParam2 &= "-XMP-MP:RegionInfoMP" & @CRLF
						Else
							$strExifToolParam2 &= "-" & $arrTagTCFileSource[1] & ":" & $arrTagTCFileSource[3] & @CRLF
						EndIf
						$booSaveSyncSelectedFiles = True

						;*** Encoding IPTC-Tags
						If $arrTagTCFileSource[1] = "IPTC" And ($booAlwaysWriteUTF8 = True Or $arrTagTCFileSource[4] <> BinaryToString($arrTagTCFileSource[4], 1)) Then $booConvertIPTCTagsToUTF8 = True

					EndIf

				Case Else
					;NOP
			EndSelect

		Next

		$strErrMsg = $arrLocStr[127] ;*** Done>
		;*** Nur ausfhren, wenn mindestens eine Checkbox gesetzt ist, also mindestens ein Tag von ExifTool kopiert werden soll
		If $booSaveSyncSelectedFiles = True Then
			;*** Encoding IPTC-Tags
			If $booConvertIPTCTagsToUTF8 = True Then
				;*** Wenn IPTC-Gruppe leer ist, zunchst IPTC:CodedCharacterSet=utf8 schreiben, um Exiftool-Warning "No writable tags set from {Dateiname}" zu vermeiden
				;Todo: Konstrukt "-if not $GROUP:all" funktioniert erst ab Exiftool v8.66
				$strExifToolParamCvIPTC = "-if" & @CRLF & "not $IPTC:all" & @CRLF
				$strExifToolParamCvIPTC &= "-P" & @CRLF
				If $booBackup = False Then $strExifToolParamCvIPTC &= "-overwrite_original_in_place" & @CRLF
				$strExifToolParamCvIPTC &= "-IPTC:CodedCharacterSet=utf8" & @CRLF
				$strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParamCvIPTC, $strTargetFile, 1, "Def")

				;*** Anschlieend bzw. wenn IPTC-Gruppe *nicht* leer ist, IPTC-Tags nach UTF8 konvertieren
				$strExifToolParamCvIPTC = "-if" & @CRLF & "$IPTC:all" & @CRLF
				$strExifToolParamCvIPTC &= "-P" & @CRLF
				If $booBackup = False Then $strExifToolParamCvIPTC &= "-overwrite_original_in_place" & @CRLF
				$strExifToolParamCvIPTC &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=utf8" & @CRLF
				$strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParamCvIPTC, $strTargetFile, 1, "Def")
			EndIf
			$strExifToolOut = FeedExifTool("SaveSyncSelectedFiles", $strExifToolParam2, $strTargetFile, 1, "Bin")
			If @error Then $strErrMsg = $arrLocStr[128] ;*** Error>
		EndIf

		;*** Synchronisieren obsoleter/entfallender Tags (TagValClp nicht vorhanden, TagValCur vorhanden)
		$booSaveSyncSelectedFiles = False
		$strExifToolParam2 = "-P" & @CRLF
		If $booBackup = False Then $strExifToolParam2 &= "-overwrite_original_in_place" & @CRLF
		For $j = 1 To $arrTagListTCFileSource[0]-1
			$arrTagTCFileSource = SplitTagListRec($arrTagListTCFileSource[$j])
			$arrTagTCFileTarget = SplitTagListRec($arrTagListTCFileTarget[$j])
			;*** Tag obsolet/entfallend (TagValSource nicht vorhanden, TagValTarget vorhanden)
			If GUICtrlRead($chkSyncSelectedFilesDel) = $GUI_CHECKED And $arrTagTCFileSource[4] = $cstrNullString And $arrTagTCFileTarget[4] <> $cstrNullString Then
				;*** Fr Tags, die nicht in den Metadaten enthalten sind, gibt ExifTool keine TagGrp aus. Daher fr obsolete Tags TagGrp:TagNam vom Targetfile benutzen
				If $arrTagTCFileTarget[1] & ":" & $arrTagTCFileTarget[3] = "XMP:RegionPersonDisplayName" Or $arrTagTCFileTarget[1] & ":" & $arrTagTCFileTarget[3] = "XMP:Rectangle" Then
					$strExifToolParam2 &= "-XMP-MP:RegionInfoMP=" & @CRLF
				Else
					$strExifToolParam2 &= "-" & $arrTagTCFileTarget[1] & ":" & $arrTagTCFileTarget[3] & "=" & @CRLF
				EndIf
				$booSaveSyncSelectedFiles = True
			EndIf
		Next

		;*** Nur ausfhren, wenn mindestens eine Checkbox gesetzt ist, also mindestens ein Tag von ExifTool gelscht werden soll
		If $booSaveSyncSelectedFiles = True Then
			$strExifToolOut = FeedExifTool("SaveSyncSelectedFiles", $strExifToolParam2, $strTargetFile, 1, "Def")
			If @error Then $strErrMsg = $arrLocStr[128] ;*** Error>
		EndIf

;~ 		_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $i-1, $arrLocStr[127], 0) ;*** Done>
		_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $i-1, $strErrMsg, 0) ;*** Done> oder *** Error>
		_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedFiles, 0, $LVSCW_AUTOSIZE)    ;Spalte "Msg" ;Test

	Next

	GUICtrlSetData($lblSyncSelectedFiles, "")
	GUICtrlSetState($btnSyncSelectedFilesSave, $GUI_HIDE)
	GUICtrlSetData($btnSyncSelectedFilesCancel, $arrLocStr[130]) ;Close

EndFunc ;Func SaveSyncSelectedFiles()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func CopySelectedTagsFromFile()
	GetTCActivePanelProperties() ;$strTCPathInactive (Pfad im inaktiven Panel) vor FileOpenDialog() aktualisieren

	$strTCPathCurMem = @WorkingDir
	$strTargetFile = $strTCPathCur & $strTCFileCur
	$strSourceFile = FileOpenDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[111], $strTCPathInactive, "All (*.*)|Meta Information files (*.mie;*.xml;*.xmp)|JPEGs (*.jpg;*.jpeg)", 1+2, $strTCFileCur) ;Selected Tags: Copy from file...

	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		OpenSyncSelectedTagsDialog()
	EndIf

	FileChangeDir($strTCPathCurMem)
EndFunc ;Func CopySelectedTagsFromFile()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func CopySelectedTagsToClipboard()
	GUICtrlSetImage($icoCopySelectedTagsToClipboard, $cstrIcoDir & "\Copy_Pend.ico", 0)
	;GUICtrlSetColor($lblStatus, 0xFF8000)
	GUICtrlSetData($lblStatus, "Exp2Clip")

	FileDelete($cstrTmpFile & "_Clipboard.mie")

	$strExifToolParam = "-IPTC:CodedCharacterSet=utf8" & @CRLF
	$strExifToolOut = FeedExifTool("ExportTagsToMIE [IPTCSetEnc]", $strExifToolParam, $cstrTmpFile & "_Clipboard.mie", 1, "Def")

	$strExifToolParam = "-TagsFromFile" & @CRLF & StringRegExpReplace(FileGetShortName($strTCFileCur), "^(#|-)", ".\\\1") & @CRLF & "-All:All" & @CRLF
	$strExifToolOut = FeedExifTool("ExportTagsToMIE", $strExifToolParam, $cstrTmpFile & "_Clipboard.mie", 1, "Def")

	GUICtrlSetBkColor($lvwTags, 0x008000)
	Sleep(200)
	GUICtrlSetBkColor($lvwTags, $strBGColor)

	;GUICtrlSetColor($lblStatus, 0x008000)
	GUICtrlSetData($lblStatus, $arrLocStr[63])
	GUICtrlSetImage($icoCopySelectedTagsToClipboard, $cstrIcoDir & "\Copy.ico", 0)

	If $intWinOnTopState = 1 Then WinActivate($whTC)

EndFunc ;Func CopySelectedTagsToClipboard()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenSyncSelectedTagsDialogOnEvent()
	$strSourceFile = $cstrTmpFile & "_Clipboard.mie"
	If $booUnicodeFilename = True Then
		$strTargetFile = $strTCFileCurShort
	Else
		$strTargetFile = $strTCFileCur
	EndIf
	OpenSyncSelectedTagsDialog()
EndFunc ;Func OpenSyncSelectedTagsDialogOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenSyncSelectedTagsDialogOnLvwSyncClick($intLvwItemIdx)
	$intLvwSyncSelectedFilesItemIdx = $intLvwItemIdx
	;*** Bei Klick auf eine leere Listview-Zeile oder Klick auf eine Listview-Zeile mit Fehlermeldung Dialog SyncSelectedTags *nicht* aufrufen
	If _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 0) <> "" Or _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 2) = "" Then Return

	$strSourceFile = _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 1) & _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 2)
	$strTargetFile = _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 8) & _GUICtrlListView_GetItemText($hlvwSyncSelectedFiles, $intLvwItemIdx, 9)
	;*** Prfen, ob der markierte Eintrag Unicode-Zeichen enthlt
	If $strSourceFile <> BinaryToString($strSourceFile) Then $strSourceFile = FileGetShortName($strSourceFile)
	If $strTargetFile <> BinaryToString($strTargetFile) Then $strTargetFile = FileGetShortName($strTargetFile)

	OpenSyncSelectedTagsDialog()
EndFunc ;Func OpenSyncSelectedTagsDialogOnLvwSyncClick($intLvwItemIdx)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func OpenSyncSelectedTagsDialog()
	If $strSourceFile = $cstrTmpFile & "_Clipboard.mie" And Not FileExists($strSourceFile) Then
		MsgBox(0+262144, $cstrTCMetadataViewerVersion, $arrLocStr[131]) ;Nothing to paste - Clipboard is empty
		Return
	EndIf

	$arrSyncSelectedTagsPos = WinGetClientSize($frmSyncSelectedTags) ;[0]=Breite; [1]=Hhe

	;StringMid(FileGetLongName($strSourceFile, 1), StringInStr(FileGetLongName($strSourceFile, 1), "\", -1))
	;StringMid(FileGetLongName($strTargetFile, 1), StringInStr(FileGetLongName($strTargetFile, 1), "\", -1))
	GUICtrlSetData($lvwSyncSelectedTags, "|||" & $arrLocStr[39] & " " & $arrLocStr[40] & " (" & FileGetLongName($strSourceFile, 1) & ")||" & $arrLocStr[39] & " " & $arrLocStr[41] & " (" & FileGetLongName($strTargetFile, 1) & ")") ;Todo: Prfen, wie lang ein Listview-Spaltenheader sein darf

	FileDelete($cstrTmpFile & "_ThumbSource.bmp")
	If @GUI_CtrlId = $contextLvwTagsDeleteSelectedTags Then
		$intImgPreW = 0
		$intImgPreH = 0
	Else
		GetImageDim($strSourceFile, 96, 96)
	EndIf
	If $intImgPreW > 0 Then

		GUICtrlSetPos($picSyncSelectedTagsSource, 180 + (96-$intImgPreW)/2, $arrSyncSelectedTagsPos[1]-98 + (96-$intImgPreH)/2, $intImgPreW, $intImgPreH)

		If $strImageConverter = "IrfanView" Then
			$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strSourceFile & '"'
			#cs
			If $booQuickviewColor = True Then
				$strIrfanViewCmd &= " /gamma=" & IniRead($cstrIniFile, "Configuration", "Gamma", 1) * 1
				$strIrfanViewCmd &= " /contrast=" & IniRead($cstrIniFile, "Configuration", "Contrast", 1) * 1
			EndIf
			#ce
			$strIrfanViewCmd &= ' /resize=(' & $intImgPreW & ',' & $intImgPreH & ') /resample /sharpen=15 /bpp=24'
			$strIrfanViewCmd &= ' /convert="' & $cstrTmpFile & '_ThumbSource.bmp" /silent'
			WriteLog("CreateThumbSource", $strIrfanViewCmd)
			$strErrMsg = RunWait($strIrfanViewCmd, @WorkingDir)

			If $strErrMsg*1 = 0 Then
				GUICtrlSetImage($picSyncSelectedTagsSource, $cstrTmpFile & "_ThumbSource.bmp")
			Else ;*** IrfanView hat eine Fehlermeldung ausgegeben
				$strErrMsg = $strImageConverter & ": load/save error (exitcode = " & $strErrMsg & ")"
				WriteLog("CreateThumbSource", $strErrMsg)
				GUICtrlSetImage($picSyncSelectedTagsSource, $strSourceFile)
			EndIf

		Else
			GUICtrlSetImage($picSyncSelectedTagsSource, $strSourceFile)

		EndIf

	Else
		GUICtrlSetPos($picSyncSelectedTagsSource, 180 + (96-48)/2, $arrSyncSelectedTagsPos[1]-98 + (96-48)/2, 48, 48)
		GUICtrlSetImage($picSyncSelectedTagsSource, $cstrIcoDir & "\NoQuickviewAvailable.jpg")

	EndIf

	FileDelete($cstrTmpFile & "_ThumbTarget.bmp")
	GetImageDim($strTargetFile, 96, 96)
	If $intImgPreW > 0 Then

		GUICtrlSetPos($picSyncSelectedTagsTarget, 306 + (96-$intImgPreW)/2, $arrSyncSelectedTagsPos[1]-98 + (96-$intImgPreH)/2, $intImgPreW, $intImgPreH)

		If $strImageConverter = "IrfanView" Then
			$strIrfanViewCmd = '"' & $strImageConverterPath & '" "' & $strTargetFile & '"'
			#cs
			If $booQuickviewColor = True Then
				$strIrfanViewCmd &= " /gamma=" & IniRead($cstrIniFile, "Configuration", "Gamma", 1) * 1
				$strIrfanViewCmd &= " /contrast=" & IniRead($cstrIniFile, "Configuration", "Contrast", 1) * 1
			EndIf
			#ce
			$strIrfanViewCmd &= ' /resize=(' & $intImgPreW & ',' & $intImgPreH & ') /resample /sharpen=15 /bpp=24'
			$strIrfanViewCmd &= ' /convert="' & $cstrTmpFile & '_ThumbTarget.bmp" /silent'
			WriteLog("CreateThumbTarget", $strIrfanViewCmd)
			$strErrMsg = RunWait($strIrfanViewCmd, @WorkingDir)

			If $strErrMsg*1 = 0 Then
				GUICtrlSetImage($picSyncSelectedTagsTarget, $cstrTmpFile & "_ThumbTarget.bmp")
			Else ;*** IrfanView hat eine Fehlermeldung ausgegeben
				$strErrMsg = $strImageConverter & ": load/save error (exitcode = " & $strErrMsg & ")"
				WriteLog("CreateThumbTarget", $strErrMsg)
				GUICtrlSetImage($picSyncSelectedTagsTarget, $strTargetFile)
			EndIf

		Else
			GUICtrlSetImage($picSyncSelectedTagsTarget, $strTargetFile)

		EndIf

	Else
		GUICtrlSetPos($picSyncSelectedTagsTarget, 306 + (96-48)/2, $arrSyncSelectedTagsPos[1]-98 + (96-48)/2, 48, 48)
		GUICtrlSetImage($picSyncSelectedTagsTarget, $cstrIcoDir & "\NoQuickviewAvailable.jpg")

	EndIf

	;*** Wenn $booBackup = False, dann knnen nderungen auch bei Unicode-Dateinamen erfolgreich unter dem ShortName der Datei gespeichert werden
	GUICtrlSetState($btnSyncSelectedTagsSave, $GUI_ENABLE)
	If $booUnicodeFilename = True And $booBackup = True Then GUICtrlSetState($btnSyncSelectedTagsSave, $GUI_DISABLE)

	SetWinOnTopState(0)

	GUISetState(@SW_SHOW, $frmSyncSelectedTags)
	GUISwitch($frmSyncSelectedTags)
	_GUICtrlListView_DeleteAllItems($hlvwSyncSelectedTags)

	$strExifToolParam  = StringMid("-G0-G1-G2", StringInStr("TypLocCat", $strOptTagGrp), 3) & @CRLF
	$strExifToolParam &= "--a" & @CRLF & "-f" & @CRLF & "-t" & @CRLF & "-H" & @CRLF
	If $strOptTagVal = "Num" Then $strExifToolParam &= "-n" & @CRLF
	If $strOptTagNam = "Desc" Then
		$strExifToolParam &= "-lang" & @CRLF & $strExifToolLang & @CRLF
	Else
		$strExifToolParam &= "-s" & @CRLF
	EndIf

	$strDeleteSelectedTags = ""
	$arrSelectedTags = IniReadSection($cstrIniFile, "SelectedTags")
	For $i = 1 To $arrSelectedTags[0][0]
		If $arrSelectedTags[$i][0] = "Header" Then
			$strExifToolParam &= "-TCMetadataViewer:TCMV_" & StringStripWS($arrSelectedTags[$i][1], 8) & @CRLF
			$strDeleteSelectedTags &= @TAB & "-" & @TAB & "TCMV_" & StringStripWS($arrSelectedTags[$i][1], 8) & @TAB & "-" & @CRLF
		Else
			$strExifToolParam &= "-" & $arrSelectedTags[$i][1] & @CRLF
			$strDeleteSelectedTags &= @TAB & "-" & @TAB & StringMid($arrSelectedTags[$i][1], StringInStr($arrSelectedTags[$i][1], ":") + 1) & @TAB & "-" & @CRLF
		EndIf
	Next

	If @GUI_CtrlId = $contextLvwTagsDeleteSelectedTags Then
		$arrTagListClipboard = StringSplit($strDeleteSelectedTags, @CRLF, 1)
	Else
		$strExifToolOut = FeedExifTool("OpenSyncSelectedTagsDialog", $strExifToolParam, $strSourceFile, 1, "Def")
		$arrTagListClipboard = StringSplit($strExifToolOut, @CRLF, 1)
	EndIf

	$strExifToolOut = FeedExifTool("OpenSyncSelectedTagsDialog", $strExifToolParam, $strTargetFile, 1, "Def")
	$arrTagListTCFileCur = StringSplit($strExifToolOut, @CRLF, 1)

	$intSyncTagNew = 0
	$intSyncTagNEq = 0
	$intSyncTagObs = 0
	GUICtrlSetData($lblSyncSelectedTagsCheckNew, "")
	GUICtrlSetData($lblSyncSelectedTagsCheckUnequal, "")
	GUICtrlSetData($lblSyncSelectedTagsCheckDel, "")

	$strListviewItemClipboardIDList = ""
	_GUICtrlListView_BeginUpdate($hlvwSyncSelectedTags)

	$intLvwItemIdx = -1
	For $i = 1 To $arrTagListClipboard[0]-1
		;*** Potentielle Fehlerquelle: Von TagVal werden nur die ersten 259 Zeichen bercksichtigt, auch beim Vergleich von TagValClp <-> TagValCur!!!
		$arrTagClipboard = SplitTagListRec($arrTagListClipboard[$i])
		$arrTagClipboard[4] = StringReplace($arrTagClipboard[4], "|", "") ;*** Pipe trennt Listview-Elemente und muss in TagVal daher "maskiert" werden
		If StringLen($arrTagClipboard[4]) > 259 Then $arrTagClipboard[4] = StringLeft($arrTagClipboard[4], 259-4) & " []"

		$arrTagTCFileCur = SplitTagListRec($arrTagListTCFileCur[$i])
		$arrTagTCFileCur[4] = StringReplace($arrTagTCFileCur[4], "|", "") ;*** Pipe trennt Listview-Elemente und muss in TagVal daher "maskiert" werden
		If StringLen($arrTagTCFileCur[4]) > 259 Then $arrTagTCFileCur[4] = StringLeft($arrTagTCFileCur[4], 259-4) & " []"

		If StringLeft($arrTagClipboard[3], 5) = "TCMV_" Then
			GUICtrlCreateListViewItem("||" & StringToUTF8(StringMid($arrTagClipboard[3], 6)) & "|||", $lvwSyncSelectedTags)
			GUICtrlSetColor(-1, IniRead($cstrIniFile, "Configuration", "ColorSyncHeader", "0x5080FF"))

		Else

			;*** Original-Tag-Werte fr Ausgabe ins Listview merken (Statusprfung findet hingegen mit u.U. sortierten Tag-Werten statt)
			$strTagValSourceOri = $arrTagClipboard[4]
			$strTagValTargetOri = $arrTagTCFileCur[4]
			;*** Vereinfachte Form, ein potentielles List-Tag zu identifizieren: Prsenz des Separators ", "
			If StringInStr($arrTagClipboard[4], ", ") > 0 And StringInStr($arrTagTCFileCur[4], ", ") > 0 Then
				;*** Fr $arrTagClipboard...
				$arrTagVal = StringSplit($arrTagClipboard[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 0, 1)
				$arrTagClipboard[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagClipboard[4] &= $arrTagVal[$k] & ", "
				Next

				;*** Fr $arrTagTCFileCur...
				$arrTagVal = StringSplit($arrTagTCFileCur[4], ", ", 1) ;Todo: Ggf. anpassen wg. Zeichensatzkonvertierung durch FileRead()
				_ArraySort($arrTagVal, 0, 1)
				$arrTagTCFileCur[4] = ""
				For $k = 1 To UBound($arrTagVal)-1
					$arrTagTCFileCur[4] &= $arrTagVal[$k] & ", "
				Next
			EndIf

			$strStatus = "?"
			$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncDefault", "0x5D7080")
			Select
				;*** Tag auf beiden Seiten nicht vorhanden (TagValSource nicht vorhanden, TagValTarget nicht vorhanden)
				Case $arrTagClipboard[4] = $cstrNullString And $arrTagTCFileCur[4] = $cstrNullString
					$strStatus = ""
					$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNoMatch", "0x808080")
				;*** Tag obsolet/entfallend (TagValClp nicht vorhanden, TagValCur vorhanden)
				Case $arrTagClipboard[4] = $cstrNullString
					$strStatus = ""
;~ 					$strStatus = ""
					$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncObs", "0xFF6600")
					$intSyncTagObs += 1
				;*** Tag identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagClipboard[4] == $arrTagTCFileCur[4]
					$strStatus = "="
					$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncEqual", "0xD0D0D0")
				;*** Tag neu
				Case $arrTagClipboard[4] <> $cstrNullString And $arrTagTCFileCur[4] = $cstrNullString
					$strStatus = "*"
					$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNew", "0x99CC00")
					$intSyncTagNew += 1
				;*** Tag ungleich oder Tag gleich, aber nicht identisch ("" = "ss", aber "" !== "ss")
				Case $arrTagClipboard[4] <> $arrTagTCFileCur[4] Or $arrTagClipboard[4] = $arrTagTCFileCur[4]
					$strStatus = ChrW(0x2260)
					$intColor = IniRead($cstrIniFile, "Configuration", "ColorSyncNotEqual", "0xFFCC00")
					$intSyncTagNEq += 1
				Case Else
					;NOP
			EndSelect

			;*** Wenn ein Tag nicht vorhanden ist, gibt ExifTool nur den TagNam, nicht jedoch die TagGrp aus. Da im Listview auch auf beiden Seiten
			;*** nicht-vorhandene Tags ausgewiesen werden sollen (TagGrp also auch nicht dem ExifTool-Output des Target-Files entnommen werden kann),
			;*** werden TagGrp:TagNam der INI-Section [SelectedTags] entnommen, welche weiter oben bereits nach $arrSelectedTags eingelesen wurde.
			;*** Damit zu einem Eintrag des ExifTool-Outputs der Wert des richtigen (zugehrigen) INI-Keys angezeigt wird, mssen ExifTool-Output und INI-Section
			;*** "synchron" sein, d,h, dieselbe Anzahl Zeilen aufweisen und je Zeile auf dasselbe Tag verweisen.
			;*** Also: Falls im Listview nur gefilterte Eintrge angezeigt werden sollen (z.B. unterdrcken der auf beiden Seiten nicht vorhandenen Tags),
			;*** funktioniert die Synchronisation ber die Variable $i nicht mehr und es wird eine Programmnderung erforderlich.
			;*** Synchronisation ber die Variable $i funktioniert auch nur, wenn Duplicate Tags unterdrckt werden (ExifTool-Parameter "--a")
			If $arrTagClipboard[1] = "" Then
				$strListviewItemClipboardIDList &= GUICtrlCreateListViewItem(StringReplace($arrSelectedTags[$i][1], ":", "|") & "|" & $arrTagTCFileCur[3] & "|" & $strTagValSourceOri & "|" & $strStatus & "|" & $strTagValTargetOri, $lvwSyncSelectedTags) & @LF
				;If StringInStr($strListviewItemClipboardCheckmarks, $arrTagTCFileCur[1] & ":" & $arrTagTCFileCur[3] & @CRLF) > 0 Then GUICtrlSetState(-1, $GUI_CHECKED)
			Else
				$strListviewItemClipboardIDList &= GUICtrlCreateListViewItem($arrTagClipboard[1] & "|" & $arrTagClipboard[2] & "|" & $arrTagClipboard[3] & "|" & $strTagValSourceOri & "|" & $strStatus & "|" & $strTagValTargetOri, $lvwSyncSelectedTags) & @LF
				;If StringInStr($strListviewItemClipboardCheckmarks, $arrTagClipboard[1] & ":" & $arrTagClipboard[3] & @CRLF) > 0 Then GUICtrlSetState(-1, $GUI_CHECKED)
			EndIf

			GUICtrlSetColor(-1, $intColor)

		EndIf

	Next

	_GUICtrlListView_EndUpdate($hlvwSyncSelectedTags)
	$arrTagListClipboard = ""

	GUICtrlSetData($lblSyncSelectedTagsCheckNew, $intSyncTagNew)
	GUICtrlSetData($lblSyncSelectedTagsCheckUnequal, $intSyncTagNEq)
	GUICtrlSetData($lblSyncSelectedTagsCheckDel, $intSyncTagObs)

	For $i = 0 To 2
		_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, $i, $LVSCW_AUTOSIZE_USEHEADER)
		_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, $i, $LVSCW_AUTOSIZE)
	Next
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, 1, 0)
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, 3, 280)
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, 4, $LVSCW_AUTOSIZE)
	_GUICtrlListView_SetColumnWidth($hlvwSyncSelectedTags, 5, 280)

EndFunc ;Func OpenSyncSelectedTagsDialog()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SaveSyncSelectedTags()
	;Todo: "Sidecar-Datei verwenden" implementieren; UTF8-Konvertierung IPTC-Tags (prfen, was hier getan werden msste)

	$booSaveSyncSelectedTags = False

	$strExifToolParam = "-P" & @CRLF
	$strExifToolParamCvIPTC = ""
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	$strExifToolParam &= "-TagsFromFile" & @CRLF & StringRegExpReplace($strSourceFile, "^(#|-)", ".\\\1") & @CRLF
	$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
	$strListviewItemClipboardCheckmarks = ""
	For $i = 1 To $arrListviewItemClipboardIDList[0]
		If GUICtrlRead($arrListviewItemClipboardIDList[$i], 1) = $GUI_CHECKED Then
			$arrTagClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i], 0), "|")
;~ 			If $arrTagClipboard[4] <> $cstrNullString Then
			If $arrTagClipboard[5] = "*" Or $arrTagClipboard[5] = ChrW(0x2260) Or $arrTagClipboard[5] = "=" Then
				$booSaveSyncSelectedTags = True

				If $arrTagClipboard[1] = "IPTC" And ($arrTagClipboard[4] <> BinaryToString($arrTagClipboard[4], 4) Or $booAlwaysWriteUTF8 = True) Then
					$strExifToolParamCvIPTC = "-P" & @CRLF ;Encoding IPTC-Tags
					If $booBackup = False Then $strExifToolParamCvIPTC &= "-overwrite_original_in_place" & @CRLF ;Encoding IPTC-Tags
					$strExifToolParamCvIPTC &= "-TagsFromFile" & @CRLF & "@" & @CRLF & "-IPTC:all" & @CRLF & "-CodedCharacterSet=utf8" & @CRLF ;Encoding IPTC-Tags
				EndIf

				If $arrTagClipboard[1] & ":" & $arrTagClipboard[3] = "XMP:RegionPersonDisplayName" Or $arrTagClipboard[1] & ":" & $arrTagClipboard[3] = "XMP:Rectangle" Then
					$strExifToolParam &= "-XMP-MP:RegionInfoMP" & @CRLF
				Else
					$strExifToolParam &= "-" & $arrTagClipboard[1] & ":" & $arrTagClipboard[3] & @CRLF
				EndIf
				$strListviewItemClipboardCheckmarks &= $arrTagClipboard[1] & ":" & $arrTagClipboard[3] & @CRLF
			EndIf
		EndIf
	Next

	;*** Nur ausfhren, wenn mindestens eine Checkbox gesetzt ist, also mindestens ein Tag von ExifTool kopiert werden soll
	If $booSaveSyncSelectedTags = True Then
		If $strExifToolParamCvIPTC <> "" Then $strExifToolOut = FeedExifTool("ConvertIPTCTagsToUTF8", $strExifToolParamCvIPTC, $strTargetFile, 1, "Def")
		;*** FeedExifTool mit "Bin" statt "Def" aufrufen, damit $strSourceFile (in $strExifToolParam enthalten) korrekt codiert (z.B. bei Dateinamen mit Umlauten) nach TCMetadataViewer_ArgFile.txt geschrieben wird
		;*** TagValues werden dadurch nicht unbeabsichtigt recodiert, da in Func SaveSyncSelectedTags statt konkreter TagValues die Option "-TagsFromFile" verwendet wird
		;*** Korrekte Codierung von $strTargetFile wird in Func FeedExifTool unabhngig vom Parameter $strExifToolParamEncoding ("Bin"/"Def") sichergestellt
		$strExifToolOut = FeedExifTool("SaveSyncSelectedTags", $strExifToolParam, $strTargetFile, 1, "Bin")
		$booFileIsModified = True
		$booRefresh = True
		$booRefreshMetadataOnly = True
	EndIf


	;*** Synchronisieren obsoleter/entfallender Tags (TagValClp nicht vorhanden, TagValCur vorhanden)
	$booSaveSyncSelectedTags = False
	$strExifToolParam = "-P" & @CRLF
	If $booBackup = False Then $strExifToolParam &= "-overwrite_original_in_place" & @CRLF
	For $i = 1 To $arrListviewItemClipboardIDList[0]
		If GUICtrlRead($arrListviewItemClipboardIDList[$i], 1) = $GUI_CHECKED Then
			$arrTagClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i], 0), "|")
;~ 			If $arrTagClipboard[4] = $cstrNullString And $arrTagClipboard[5] <> $cstrNullString Then
			If $arrTagClipboard[5] = "" Then
;~ 			If $arrTagClipboard[5] = "" Then
				$booSaveSyncSelectedTags = True
				If $arrTagClipboard[1] & ":" & $arrTagClipboard[3] = "XMP:RegionPersonDisplayName" Or $arrTagClipboard[1] & ":" & $arrTagClipboard[3] = "XMP:Rectangle" Then
					$strExifToolParam &= "-XMP-MP:RegionInfoMP=" & @CRLF
				Else
					$strExifToolParam &= "-" & $arrTagClipboard[1] & ":" & $arrTagClipboard[3] & "=" & @CRLF
				EndIf
				$strListviewItemClipboardCheckmarks &= $arrTagClipboard[1] & ":" & $arrTagClipboard[3] & @CRLF
			EndIf
		EndIf
	Next

	;*** Nur ausfhren, wenn mindestens eine Checkbox gesetzt ist, also mindestens ein Tag von ExifTool gelscht werden soll
	If $booSaveSyncSelectedTags = True Then
		$strExifToolOut = FeedExifTool("SaveSyncSelectedTags", $strExifToolParam, $strTargetFile, 1, "Def")
		$booFileIsModified = True
		$booRefresh = True
		$booRefreshMetadataOnly = True
	EndIf

	If $strListviewItemClipboardCheckmarks = "" Then
		MsgBox(0+48+262144, "SyncSelectedTags - " & $arrLocStr[75], $arrLocStr[138]) ;Nothing to do - No tag is selected
	Else
		;*** Dialog $frmSyncSelectedTags wurde aufgerufen durch Klick auf Listview-Item im Dialog $frmSyncSelectedFiles
		If $strSourceFile <> $cstrTmpFile & "_Clipboard.mie" And $strSourceFile <> "" Then
			;*** 0=Msg; 1=SourcePath; 2=SourceFile; 3-7=|*|#|=|; 8=TargetPath; 9=TargetFile
			;*** 0=Msg; 1=SourcePath; 2=SourceFile; 3-7=|*|#|=|; 8=TargetPath; 9=TargetFile
			For $i = 3 To 7
				_GUICtrlListView_SetItemText($hlvwSyncSelectedFiles, $intLvwSyncSelectedFilesItemIdx, "?", $i)
			Next
		EndIf
	EndIf


	_Exit()

EndFunc ;Func SaveSyncSelectedTags()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SyncSelectedFilesToggleSelection()
	Switch @GUI_CtrlId
		Case $btnSyncSelectedFilesCheckAll
;~ 			_GUICtrlListView_SetItemChecked($hlvwSyncSelectedFiles, -1, True)
			$arrListviewItemSyncSelectedFilesIDList = StringSplit($strListviewItemSyncSelectedFilesIDList, @LF)
			For $i = 1 To $arrListviewItemSyncSelectedFilesIDList[0]-1
				;*** 1  |2         |3         |4|5|6|7|8|9         |10
				;*** Msg|SourcePath|SourceFile||*|#|=||TargetPath|TargetFile
				$arrListviewItemSyncSelectedFiles = StringSplit(GUICtrlRead($arrListviewItemSyncSelectedFilesIDList[$i]), "|")
;~ 				If $arrListviewItemSyncSelectedFiles[1] = "" Then GUICtrlSetState($arrListviewItemSyncSelectedFilesIDList[$i], $GUI_CHECKED)
				If $arrListviewItemSyncSelectedFiles[1] = "" And $arrListviewItemSyncSelectedFiles[5]+$arrListviewItemSyncSelectedFiles[6]+$arrListviewItemSyncSelectedFiles[8] > 0 Then GUICtrlSetState($arrListviewItemSyncSelectedFilesIDList[$i], $GUI_CHECKED)
			Next
		Case $btnSyncSelectedFilesCheckNone
			_GUICtrlListView_SetItemChecked($hlvwSyncSelectedFiles, -1, False)
	EndSwitch
EndFunc ;Func SyncSelectedFilesToggleSelection()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func SyncSelectedTagsToggleSelection()
	Switch @GUI_CtrlId
		Case $btnSyncSelectedTagsCheckAll
			_GUICtrlListView_SetItemChecked($hlvwSyncSelectedTags, -1, False)
			$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
			For $i = 1 To $arrListviewItemClipboardIDList[0]-1
				$arrListviewItemClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i]), "|")
				;*** Header berspringen (nicht markieren)
				If $arrListviewItemClipboard[5] <> "" And $arrListviewItemClipboard[5] <> "" Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
			Next
		Case $btnSyncSelectedTagsCheckNone
			_GUICtrlListView_SetItemChecked($hlvwSyncSelectedTags, -1, False)
		Case $btnSyncSelectedTagsCheckRestore
			$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
			For $i = 1 To $arrListviewItemClipboardIDList[0]-1
				$arrListviewItemClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i]), "|")
				If StringInStr($strListviewItemClipboardCheckmarks, $arrListviewItemClipboard[1] & ":" & $arrListviewItemClipboard[3] & @CRLF) > 0 Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
			Next
		Case $btnSyncSelectedTagsCheckNew
			$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
			For $i = 1 To $arrListviewItemClipboardIDList[0]-1
				$arrListviewItemClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i]), "|")
				If $arrListviewItemClipboard[5] = "*" Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
			Next
		Case $btnSyncSelectedTagsCheckDel
			$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
			For $i = 1 To $arrListviewItemClipboardIDList[0]-1
				$arrListviewItemClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i]), "|")
				If $arrListviewItemClipboard[5] = "" Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
;~ 				If $arrListviewItemClipboard[5] = "" Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
			Next
		Case $btnSyncSelectedTagsCheckUnequal
			$arrListviewItemClipboardIDList = StringSplit($strListviewItemClipboardIDList, @LF)
			For $i = 1 To $arrListviewItemClipboardIDList[0]-1
				$arrListviewItemClipboard = StringSplit(GUICtrlRead($arrListviewItemClipboardIDList[$i]), "|")
				If $arrListviewItemClipboard[5] = ChrW(0x2260) Then GUICtrlSetState($arrListviewItemClipboardIDList[$i], $GUI_CHECKED)
			Next
	EndSwitch
EndFunc ;Func SyncSelectedTagsToggleSelection()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func CompareTags()
	$strFileNameTaglist1 = $cstrTmpFile & "_Taglist1.txt"
	$strFileNameTaglist2 = $cstrTmpFile & "_Taglist2.txt"
	$strFileTagSource1 = $strTCPathCur & $strTCFileCur
	GetTCActivePanelProperties() ;$strTCPathInactive (Pfad im inaktiven Panel) vor FileOpenDialog() aktualisieren

	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileTagSource2 = FileOpenDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[54], $strTCPathInactive, "All (*.*)|JPEGs (*.jpg;*.jpeg)", 1+2, $strTCFileCurOri)

	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		If $strFileTagSource2 <> BinaryToString($strFileTagSource2) Then $strFileTagSource2 = FileGetShortName($strFileTagSource2) ;*** Minimal-Umgehungslsung fr Unicode-Dateipfade


		;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
		;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
		$strExifToolParam = ' -G1 -a -t -H -s -ee'
		;bookmark
;~ 		If $intUseSidecarFile = 1 And FileExists(StringLeft($strFileTagSource1, StringInStr($strFileTagSource1, ".", 0, -1)) & $strSidecarFileType) Then
		;If $intUseSidecarFile = 1 Then
		;	$strExifToolParam &= ' -srcfile "%d%f.' & $strSidecarFileType & '"'
		;EndIf
		$strExifToolParam &= ' --1File:All --System:FileModifyDate --System:FilePermissions --System:FileSize "' & $strFileTagSource1 & '" | Sort>"' & $strFileNameTaglist1 & '"'
		$strExifToolOut = RunExifTool("ReadMetadata", $strExifToolParam, 1)
		If @error Then MsgBox(48+262144, $cstrTCMetadataViewerVersion & " - CompareTags", $strExifToolErr)

		;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
		;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
		$strExifToolParam = ' -G1 -a -t -H -s -ee'
		;bookmark
;~ 		If $intUseSidecarFile = 1 And FileExists(StringLeft($strFileTagSource2, StringInStr($strFileTagSource2, ".", 0, -1)) & $strSidecarFileType) Then
		;If $intUseSidecarFile = 1 Then
		;	$strExifToolParam &= ' -srcfile "%d%f.' & $strSidecarFileType & '"'
		;EndIf
		$strExifToolParam &= ' --1File:All --System:FileModifyDate --System:FilePermissions --System:FileSize "' & $strFileTagSource2 & '" | Sort>"' & $strFileNameTaglist2 & '"'
		$strExifToolOut = RunExifTool("ReadMetadata", $strExifToolParam, 1)
		If @error Then MsgBox(48+262144, $cstrTCMetadataViewerVersion & " - CompareTags", $strExifToolErr)

		WriteLog("CompareTags", $strFileTagSource1 & " <=> " & $strFileTagSource2)
		ShellExecute(EnvGet("COMMANDER_PATH") & "\TotalCmd.exe", "/S=C " & '"' & $strFileNameTaglist1 & '" "' & $strFileNameTaglist2 & '"')
		MsgBox(64+262144, $cstrTCMetadataViewerVersion & ": " & $arrLocStr[115], $arrLocStr[116] & @LF & $strFileNameTaglist1 & ":" & @LF & $strFileTagSource1 & @LF & @LF & $arrLocStr[54] & @LF & @LF & $arrLocStr[117] & @LF & $strFileNameTaglist2 & ":" & @LF & $strFileTagSource2) ;CompareTags; Left:; Right:

	EndIf

	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
EndFunc ;Func CompareTags()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportTagsToTXT()
	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileNameTarget = StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & "txt"
	$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[50], $strTCPathCurOri, "Text (*.txt)", 2, $strFileNameTarget)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		WriteLog("ExportTagsToTXT", $strFileNameTarget)
		$fhTaglistSavefile = FileOpen($strFileNameTarget, 2)
		For $i = 1 To $arrTagList[0]
			FileWriteLine($fhTaglistSavefile, $arrTagList[$i])
		Next
		FileClose($fhTaglistSavefile)
		MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToTXT" & @LF & $strFileNameTarget)
	EndIf
	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
EndFunc ;Func ExportTagsToTXT()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportTagsToXMP()
	#cs
	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileNameTarget = StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & "xmp"
	$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[50], $strTCPathCurOri, "XMP sidecar files (*.xmp)", 2+16, $strFileNameTarget)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		$strExifToolParam = "-TagsFromFile" & @CRLF & $strTCFileCur & @CRLF & $cstrTmpFile & ".xmp" & @CRLF
		$strExifToolOut = RunExifTool("ExportTagsToXMP", $strExifToolParam, -1)
		WriteLog("ExportTagsToXMP", "FileMove: " & $cstrTmpFile & ".xmp   =>   " & $strFileNameTarget)
		If FileMove($cstrTmpFile & ".xmp", $strFileNameTarget, 1) = 0 Then
			WriteLog("ExportTagsToXMP", "FileMove: Err: Source file cannot be moved")
			MsgBox(0+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXMP" & @LF & $cstrTmpFile & ".xmp")
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXMP" & @LF & $strFileNameTarget)
		EndIf
	EndIf
	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
	#ce
	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileNameTarget = StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & "xmp"
	$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[51], $strTCPathCurOri, "XMP sidecar files (*.xmp)", 2+16, $strFileNameTarget)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
;~ 		$strExifToolParam = "-o" & @CRLF & $cstrTmpFile & ".xmp" & @CRLF & "-all:all" & @CRLF
		$strExifToolParam = "-o" & @CRLF & $cstrTmpFile & ".xmp" & @CRLF
		$strExifToolOut = FeedExifTool("ExportTagsToXMP", $strExifToolParam, $strTCFileCur, 1, "Def")
		WriteLog("ExportTagsToXMP", "FileMove: " & $cstrTmpFile & ".xmp   =>   " & $strFileNameTarget)
		If FileMove($cstrTmpFile & ".xmp", $strFileNameTarget, 1) = 0 Then
			WriteLog("ExportTagsToXMP", "FileMove: Err: Source file cannot be moved")
			MsgBox(0+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXMP" & @LF & $cstrTmpFile & ".xmp")
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXMP" & @LF & $strFileNameTarget)
		EndIf
	EndIf
	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
EndFunc ;Func ExportTagsToXMP()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportTagsToXML()
	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileNameTarget = StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & "xml"
	$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[52], $strTCPathCurOri, "ExifTool XML files (*.xml)", 2+16, $strFileNameTarget)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)
		;*** ExifTool-@ *ARGFILE*: "Normal shell processing of arguments is not performed", also auch keine Ein-/Ausgabeumleitung.
		;*** Wenn Shell-Mechanismen bentigt werden, muss ExifTool als (neuer/eigener) Prozess mit Parameterbergabe auf der Kommandozeile aufgerufen werden
		$strExifToolParam = '-X "' & $strTCFileCur & '" >"' & $cstrTmpFile & '.xml"'
		$strExifToolOut = RunExifTool("ExportTagsToXML", $strExifToolParam, 1)
		WriteLog("ExportTagsToXML", "FileMove: " & $cstrTmpFile & ".xml   =>   " & $strFileNameTarget)
		If FileMove($cstrTmpFile & ".xml", $strFileNameTarget, 1) = 0 Then
			WriteLog("ExportTagsToXML", "FileMove: Err: Source file cannot be moved")
			MsgBox(0+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXML" & @LF & $cstrTmpFile & ".xml")
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToXML" & @LF & $strFileNameTarget)
		EndIf
	EndIf
	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
EndFunc ;Func ExportTagsToXML()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportTagsToMIEOnEvent()
	SetWinOnTopState(0) ;Topmost-Flag des Hauptfensters vor FileOpenDialog() entfernen
	$strTCPathCurMem = @WorkingDir
	$strFileNameTarget = StringLeft($strTCFileCurOri, StringInStr($strTCFileCurOri, ".", 0, -1)) & "mie"
	$strFileNameTarget = FileSaveDialog($cstrTCMetadataViewerVersion & " - " & $arrLocStr[53], $strTCPathCurOri, "Meta Information Encapsulation files (*.mie)", 2+16, $strFileNameTarget)
	If @error = 0 Then
		FileChangeDir($strTCPathCurMem)

		FileDelete($cstrTmpFile & ".mie") ;*** Sicherheitshalber (falls FileMove() des *mie-Files aus vorangegangenem Export fehlschlug)

		$strExifToolParam = "-G1" & @CRLF & "-a" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF & "-IPTC:All" & @CRLF
		$strExifToolOut = FeedExifTool("ExportTagsToMIE [IPTCCheckEnc]", $strExifToolParam, $strTCFileCur, 1, "Def")

		If $strExifToolOut <> BinaryToString($strExifToolOut, 4) Then
			$strExifToolParam = "-IPTC:CodedCharacterSet=utf8" & @CRLF
			$strExifToolOut = FeedExifTool("ExportTagsToMIE [IPTCSetEnc]", $strExifToolParam, $cstrTmpFile & ".mie", 1, "Def")
		EndIf

		$strExifToolParam = "-TagsFromFile" & @CRLF & StringRegExpReplace($strTCFileCur, "^(#|-)", ".\\\1") & @CRLF & "-All:All" & @CRLF & $cstrTmpFile & ".mie"
		$strExifToolOut = FeedExifTool("ExportTagsToMIE", $strExifToolParam, "", 1, "Def")

		WriteLog("ExportTagsToMIE", "FileMove: " & $cstrTmpFile & ".mie   =>   " & $strFileNameTarget)
		If FileMove($cstrTmpFile & ".mie", $strFileNameTarget, 1) = 0 Then
			WriteLog("ExportTagsToMIE", "FileMove: Err: Source file cannot be moved")
			MsgBox(0+48+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToMIE" & @LF & $cstrTmpFile & ".mie")
		Else
			MsgBox(0+64+262144, $cstrTCMetadataViewerVersion, $arrLocStr[98] & @LF & @LF & $strTCFileCurOri & @LF & "ExportTagsToMIE" & @LF & $strFileNameTarget)
		EndIf
	EndIf
	FileChangeDir($strTCPathCurMem)
	SetWinOnTopState($intWinOnTopStateUser) ;Topmost-Flag des Hauptfensters nach FileOpenDialog() auf Ursprungszustand zurcksetzen
EndFunc ;Func ExportTagsToMIEOnEvent()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ExportTagsToMIE($localstrPath, $localstrFile, $localstrExt, $localstrTagGrpNam, $localbooAlwaysWriteUTF8)

	$strTCPathCurMem = @WorkingDir

	If $localstrFile = BinaryToString($localstrFile) Then
		$localstrFileCur = $localstrFile
	Else
		$localstrFilepathShort = FileGetShortName($localstrPath & $localstrFile)
		$p = StringInStr($localstrFilepathShort, "\", 0, -1)
;~ 		$localstrPathCur = StringLeft($localstrFilepathShort, $p)
		$localstrFileCur = StringMid($localstrFilepathShort, $p+1)
	EndIf

	FileChangeDir($localstrPath)

	FileDelete($cstrTmpFile & ".mie") ;*** Sicherheitshalber (falls FileMove() des *mie-Files aus vorangegangenem Export fehlschlug)

	$strExifToolParam = "-G1" & @CRLF & "-a" & @CRLF & "-t" & @CRLF & "-H" & @CRLF & "-s" & @CRLF & "-IPTC:All" & @CRLF
	$strExifToolOut = FeedExifTool("ExportTagsTo" & StringUpper($localstrExt) & " [IPTCCheckEnc]", $strExifToolParam, $localstrFileCur, 1, "Def")

	If $strExifToolOut <> BinaryToString($strExifToolOut, 4) Or ($localbooAlwaysWriteUTF8 = True And StringLeft($localstrTagGrpNam, StringInStr($localstrTagGrpNam, ":") - 1) = "IPTC") Then
		$strExifToolParam = "-IPTC:CodedCharacterSet=utf8" & @CRLF
		$strExifToolOut = FeedExifTool("ExportTagsTo" & StringUpper($localstrExt) & " [IPTCSetEnc]", $strExifToolParam, $cstrTmpFile & "." & $localstrExt, 1, "Def")
	EndIf

	$strExifToolParam = "-TagsFromFile" & @CRLF & StringRegExpReplace($localstrFileCur, "^(#|-)", ".\\\1") & @CRLF & "-All:All" & @CRLF & $cstrTmpFile & "." & $localstrExt
	$strExifToolOut = FeedExifTool("ExportTagsTo" & StringUpper($localstrExt), $strExifToolParam, "", 1, "Def")

	$strFileNameTarget = $localstrPath & StringLeft($localstrFile, StringInStr($localstrFile, ".", 0, -1)) & $localstrExt
	WriteLog("ExportTagsTo" & StringUpper($localstrExt), "FileMove: " & $cstrTmpFile & "." & $localstrExt & "   =>   " & $strFileNameTarget)
	If FileMove($cstrTmpFile & "." & $localstrExt, $strFileNameTarget, 1) = 0 Then WriteLog("ExportTagsTo" & StringUpper($localstrExt), "FileMove: Err: Source file cannot be moved")

	FileChangeDir($strTCPathCurMem)

EndFunc ;Func ExportTagsToMIE($localstrPath, $localstrFile, $localstrExt, $localstrTagGrpNam, $localbooAlwaysWriteUTF8)

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ToggleEditTagQuickfilter()
	#cs
	If $booEditTagQuickfilter = True Then
		GUICtrlSetData($txtEditTagListQuickfilter, "")
		$booEditTagQuickfilter = False
	Else
		If GUICtrlRead($txtEditTagListQuickfilter) <> "" Then $booEditTagQuickfilter = True
	EndIf
	#ce
	If GUICtrlRead($txtEditTagListQuickfilter) = "" Then
		$booEditTagQuickfilter = False
	Else
		$booEditTagQuickfilter = True
	EndIf
	EditTagQuickfilter()
EndFunc ;Func ToggleEditTagQuickfilter()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func EditTagQuickfilter()
	$arrCategoriesKeywordsPersonsFiltered = _ArrayFindAll($arrCategoriesKeywordsPersons, GUICtrlRead($txtEditTagListQuickfilter), 1, 0, 0, 1, 1)
	GUICtrlSetData($lbxEditTagList, "")
	If GUICtrlRead($txtEditTagListQuickfilter) = "" Then
		For $i = 1 To $arrCategoriesKeywordsPersons[0][0]
			GUICtrlSetData($lbxEditTagList, $arrCategoriesKeywordsPersons[$i][1] & "|")
		Next
		GUICtrlSetImage($icoEditTagListQuickfilter, $cstrIcoDir & "\NotFiltered.ico", 0)
	Else
		For $i = 0 To UBound($arrCategoriesKeywordsPersonsFiltered)-1
			GUICtrlSetData($lbxEditTagList, $arrCategoriesKeywordsPersons[$arrCategoriesKeywordsPersonsFiltered[$i]][1] & "|")
		Next
		GUICtrlSetImage($icoEditTagListQuickfilter, $cstrIcoDir & "\Filtered.ico", 0)
	EndIf
	ControlFocus("", "", $txtEditTagListQuickfilter)
;~ 	Send("{Right}")
EndFunc ;Func EditTagQuickfilter()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func ToggleShiftDateTimeIncDec()
	If GUICtrlRead($btnShiftDateTimeIncDec) = "+" Then
		GUICtrlSetData($btnShiftDateTimeIncDec, "-")
	Else
		GUICtrlSetData($btnShiftDateTimeIncDec, "+")
	EndIf
EndFunc ;Func ToggleShiftDateTimeIncDec()

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Func StringToUTF8($strStrIn)
	$strStrEnc = "?"

	$strStrOt = StringRegExpReplace($strStrIn, "[\x09-\x0D\x20-\x7E]", "")

	If $strStrOt = "" Then
		$strStrEnc = "ASCII"

	Else
		$strStrEnc = "UTF-8"
		For $i = 1 To StringLen($strStrIn)

			$intAsc = Asc(StringMid($strStrIn, $i, 1))
			$intSubseqBytes = 0

			Select
				;[\x00-\x7F] = 0xxxxxxx
				Case $intAsc >= 0x00 And $intAsc <= 0x7F
					$intSubseqBytes = 0
				;[\xC0-\xDF][\x80-\xBF] = 110xxxxx 10xxxxxx
				Case $intAsc >= 0xC0 And $intAsc <= 0xDF
					$intSubseqBytes = 1
				;[\xE0-\xEF][\x80-\xBF][\x80-\xBF] = 1110xxxx 10xxxxxx 10xxxxxx
				Case $intAsc >= 0xE0 And $intAsc <= 0xEF
					$intSubseqBytes = 2
				;[\xF0-\xF7][\x80-\xBF][\x80-\xBF][\x80-\xBF] = 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx
				Case $intAsc >= 0xF0 And $intAsc <= 0xF7
					$intSubseqBytes = 3
				Case Else
					$intSubseqBytes = 0
					$strStrEnc = "?"
					ExitLoop
			EndSelect

			If $i + $intSubseqBytes > StringLen($strStrIn) Then
				$strStrEnc = "?"
				ExitLoop
			EndIf

			For $j = 1 To $intSubseqBytes
				$i += 1
				$intAsc = Asc(StringMid($strStrIn, $i, 1))
				If $intAsc < 0x80 Or $intAsc > 0xBF Then
					$strStrEnc = "?"
					ExitLoop 2
				EndIf
			Next

		Next

		If $strStrEnc = "?" Then
			$strStrOt = StringRegExpReplace($strStrIn, "[\x00-\x08\x0E-\x1F\x7F]", "") ;Control Chars
			If $strStrIn = $strStrOt Then
				$strStrEnc = "ANSI"
			Else
				$strStrEnc = "Binary"
			EndIf
		EndIf

	EndIf

	If $strStrEnc = "UTF-8" Then
		Return BinaryToString($strStrIn, 4)
	Else
		Return $strStrIn
	EndIf

EndFunc ;Func StringToUTF8($strStrIn)
