unit listU;

interface

uses
	Windows, TorrentFile, EmbeddedWB, Math;

procedure ListGetDetectString(DetectString: PChar; maxlen: Integer); stdcall; export;
function ListLoad(ParentWin: THandle; FileToLoad: PChar; ShowFlags: Integer): THandle; stdcall; export;
procedure ListCloseWindow(ListWin: THandle); stdcall; export;

implementation

uses
	Forms, Classes, SysUtils, Contnrs, Controls, SHDocVw, ActiveX, Messages, SBUtils;

var
	ListResults: TObjectList;

procedure ListGetDetectString(DetectString: PChar; maxlen: Integer); stdcall;
begin
	StrCopy(DetectString, 'EXT="TORRENT"');
end;

function FmtSize(bytes: int64): string;
	function DoIt(e: extended; suff: string): string;
	begin
		Result := Format('%.2f' + suff, [e]);
	end;
const
	kb = 1024;
	Mb = kb * kb;
	Gb = Mb * kb;
	Tb = int64(Gb) * kb;
begin
	if bytes > Tb then
		Result := DoIt(bytes / Tb, 'Tb')
	else if bytes > Gb then
		Result := DoIt(bytes / Gb, 'Gb')
	else if bytes > Mb then
		Result := DoIt(bytes / Mb, 'Mb')
	else
		Result := DoIt(bytes / kb, 'kb');
end;

function ListTorrentHTML(TF: TTorrentFile): TStrings;
	procedure SplitHTML(html, starts, ends: string; var before, after, within: string);
	var
		i1, i2: integer;
		tmp: string;
	begin
		before := html;
		after := '';
		within := '';
		i1 := Pos(starts, html);
		if i1 > 0 then
			begin
				tmp := Copy(html, i1, Length(html));
				Delete(tmp, 1, Length(starts));
				i2 := Pos(ends, tmp);
				if i2 > 0 then
					begin
						before := Copy(html, 1, i1 - 1);
						within := Copy(tmp, 1, i2 - 1);
						after := Copy(tmp, i2 + Length(ends), Length(tmp));
					end;
			end;
	end;
	function DeleteSection(html, starts, ends: string): string;
	var
		i1, i2: integer;
		tmp, before, after: string;
	begin
		i1 := Pos(starts, html);
		if i1 > 0 then
			begin
				tmp := Copy(html, i1, Length(html));
				Delete(tmp, 1, Length(starts));
				i2 := Pos(ends, tmp);
				if i2 > 0 then
					begin
						before := Copy(html, 1, i1 - 1);
						after := Copy(tmp, i2 + Length(ends), Length(tmp));
						Result := before + after;
					end
				else
					Result := html;
			end
		else
			Result := html;
	end;
const
	Header = '<html>'#13#10 +
					 '<head>'#13#10 +
					 '<title>TorrentLister</title>'#13#10 +
					 '<style>'#13#10 +
					 'BODY'#13#10 +
					 '{'#13#10 +
					 'font: 10pt Verdana, Arial;'#13#10 +
					 '}'#13#10 +
					 'TD'#13#10 +
					 '{'#13#10 +
					 'font: 10pt Verdana, Arial;'#13#10 +
					 '}'#13#10 +
					 'TH'#13#10 +
					 '{'#13#10 +
					 'font: 10pt Verdana, Arial;'#13#10 +
					 '}'#13#10 +
					 'DIV'#13#10 +
					 '{'#13#10 +
					 'font: 10pt Verdana, Arial;'#13#10 +
					 '}'#13#10 +
					 '</style>'#13#10 +
					 '</head>'#13#10 +
					 '<body>'#13#10;
	Footer = '<div style="margin-top: 20px">TorrentLister v1.0 Copyright &copy; 2005 <a href="mailto:ctiberg@home.se">Christian Tiberg</a></div>'#13#10 +
					 '</body></html>';
var
	i: integer;
	AFile: TTorrentSubFile;
	ModName: array[0..MAX_PATH - 1] of char;
	pth, html, before, after, within, tmp: string;
begin
	Result := TStringList.Create;

	GetModuleFileName(HInstance, ModName, SizeOf(ModName));
	pth := ExtractFilePath(ModName);
	Result.LoadFromFile(pth + 'TorrentLister_Template.html');
	html := Result.Text;

	html := StringReplace(html, '%name%', TF.Name, [rfReplaceAll]);
	html := StringReplace(html, '%date%', DateTimeToStr(TF.Date), [rfReplaceAll]);
	html := StringReplace(html, '%filecount%', IntToStr(TF.Files.Count), [rfReplaceAll]);
	html := StringReplace(html, '%totalsize%', FmtSize(TF.Length), [rfReplaceAll]);
	html := StringReplace(html, '%maintracker%', TF.Announce, [rfReplaceAll]);
	if TF.Comment <> '' then
		html := StringReplace(html, '%comment%', TF.Comment, [rfReplaceAll])
	else
		html := DeleteSection(html, '<!-- COMMENT START -->', '<!-- COMMENT ENDS -->');

	if TF.BackupTrackers.Count = 0 then
		html := DeleteSection(html, '<!-- BACKUPTRACKERS START -->', '<!-- BACKUPTRACKERS END -->')
	else
		begin
			SplitHTML(html, '<!-- BACKUPTRACKERS START -->', '<!-- BACKUPTRACKERS END -->', before, after, within);
			if (TF.BackupTrackers.Count > 0) and (within <> '') then
				begin
					html := before;
					for i := 0 to TF.BackupTrackers.Count - 1 do
						html := html + StringReplace(within, '%backuptracker%', TF.BackupTrackers[i], [rfReplaceAll]);
					html := html + after;
				end
			else
				html := before + after;
		end;
	SplitHTML(html, '<!-- FILE START -->', '<!-- FILE END -->', before, after, within);
	if (TF.Files.Count > 0) and (within <> '') then
		begin
			html := before;
			for i := 0 to TF.Files.Count - 1 do
				begin
					AFile := TTorrentSubFile(TF.Files[i]);
					tmp := StringReplace(within, '%filename%', AFile.Path + AFile.Name, [rfReplaceAll]);
					html := html + StringReplace(tmp, '%filesize%', FmtSize(AFile.Length), [rfReplaceAll]);
				end;
			html := html + after;
		end
	else
		html := before + after;
	Result.Text := html;

{	Result.Text := Header;
	Result.Add('Name: ' + TF.Name + '<br>');
	Result.Add('Date: ' + DateTimeToStr(TF.Date) + '&nbsp;&nbsp;&nbsp;');
	Result.Add(IntToStr(TF.Files.Count) + ' files, total size ' + FmtSize(TF.Length) + '<br>');
	Result.Add('Tracker: <a href="' + TF.Announce + '">' + TF.Announce + '</a><br><br>');
	if TF.BackupTrackers.Count > 0 then
		begin
			Result.Add('<table border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" style="padding-right: 10px">Backup trackers</td><td>');
			for i := 0 to TF.BackupTrackers.Count - 1 do
				Result.Add(TF.BackupTrackers[i] + '<br>');
			Result.Add('</td></tr></table>');
		end;

	if TF.Comment <> '' then
		Result.Add('<div style="margin-bottom: 10px">' + TF.Comment + '</div>');

	Result.Add('<table border="0" cellspacing="0" cellpadding="0">' + #13#10 +
					'<tr><th align="left">Filename</th><th align="right">Size</th></tr>');

	for i := 0 to TF.Files.Count - 1 do
		begin
			AFile := TTorrentSubFile(TF.Files[i]);
			Result.Add('<tr><td style="padding-right: 10px">' + AFile.Path + AFile.Name + '</td><td align="right">' + FmtSize(AFile.Length) + '</td></tr>');
		end;
	Result.Add('</table>');

	Result.Text := Result.Text + Footer;}
end;

procedure SafeYield;
var
    Msg: TMsg;
begin
			while ( PeekMessage( Msg, 0, 0, 0, PM_REMOVE ) ) do
				begin
				if ( Msg.Message = WM_QUIT ) then
					Halt( Msg.wParam );
				TranslateMessage( Msg );
				DispatchMessage( Msg );
				end;
end;

procedure FillBrowserHTML(WB: TEmbeddedWB; Lst: TStrings);
var
	MS: TMemoryStream;
begin
	WB.Navigate('about:blank') ;
	while WB.ReadyState <   READYSTATE_INTERACTIVE do
		SafeYield;

	if Assigned(WB.Document) then
		begin
			MS := TMemoryStream.Create;
			try
				Lst.SaveToStream(MS);
				MS.Seek(0, 0);
				(WB.Document as IPersistStreamInit).Load(TStreamAdapter.Create(MS));
			finally
				MS.Free;
			end;
		end;
end;

function ListLoad(ParentWin: THandle; FileToLoad: PChar; ShowFlags: Integer): THandle; stdcall;
var
	FS: TStream;
	TF: TTorrentFile;
	WB: TEmbeddedWB;
	Lst: TStrings;
begin
	Result := 0;
	FS := TFileStream.Create(FileToLoad, fmOpenRead);
	TF := TTorrentFile.Create;
	try
		TF.Load(FS);
	except
		TF.Free;
		FS.Free;
		exit;
	end;
	FS.Free;

	WB := TEmbeddedWB.CreateParented(ParentWin);
	WB.Align := alClient;

	Lst := ListTorrentHTML(TF);
	FillBrowserHTML(WB, Lst);
	Lst.Free;

	TF.Free;

	if not Assigned(ListResults) then ListResults := TObjectList.Create(True);
	ListResults.Add(WB);

	Result := WB.Handle;
end;

procedure ListCloseWindow(ListWin: THandle); stdcall;
var
	i: integer;
begin
	for i := 0 to ListResults.Count - 1 do
		if TEmbeddedWB(ListResults[i]).Handle = ListWin then
			begin
				ListResults.Delete(i);
				if ListResults.Count = 0 then FreeAndNil(ListResults);
				break;
			end;
end;

end.
