<?php
require_once("include/webarchive.class.php");

function isDirEmpty($pth)
{
	$d = dir($pth);
	while (false !== ($entry = $d->read()))
		{
			if (is_dir($pth.$entry))
				{
					if (substr($entry, 0, 1) != ".") return false;
				}
			else if ($entry != "." && $entry != "..")
				return false;
		}
	return true;
}

function mkpath($path, $mode = 0777)
{
	$dirs = explode("/", $path);
	$path = $dirs[0];
	for ($i=1; $i<count($dirs); $i++)
		if ($dirs[$i] != "")
			{
				$path .= "/".$dirs[$i];
				if (!is_dir($path))
					{
						mkdir($path);
						@chmod($path, $mode);
					}
			}
}

	ini_set("display_errors", "1");
	@set_time_limit(900);
	if ($_POST["fil"] == "" || !isset($_POST["fil"]))
		{
			print "<html><head><title>ReadDir</title><body><form name='readfrm' method='post' action='readdir.php'>";
			print "Archive: <input type='text' name='fil'><br>Full path of where to extract (must be empty): <input type='text' name='dir'><br>";
			print "<input type='submit'></form>";
			print "</body></html>";
			exit;
		}

	$fil = $_POST["fil"];
	if (!file_exists($fil))
		{
			print "File not found";
			exit;
		}

	$dir = $_POST["dir"];
	$dir = str_replace("\\", "/", $dir);
	if (substr($dir, strlen($dir) - 1, 1) != "/") $dir .= "/";
	if (!is_dir($dir))
		{
			print "The directory doesn't exist";
			exit;
		}
	if (!isDirEmpty($dir))
		{
			print "The directory isn't empty";
			exit;
		}

	$arc =& new WebArchiveReader($fil);
	if (!$arc->isWebArchive())
		{
			$arc->closeArchive();
			print "Invalid archive";
			exit;
		}
	$arc->readHeader();
	foreach ($arc->files as $aFile)
		{
			print "Extracting ".$aFile->filename."<br>";
			$ix = strrpos($aFile->filename, "/");
			if ($ix !== false)
				{
					$pth = $dir.substr($aFile->filename, 0, $ix);
					mkpath($pth);
				}
			if (substr($aFile->filename, strlen($aFile->filename) - 1, 1) != "/")
				{
					 $arc->extractData($aFile->filename, $dir.$aFile->filename);
					 @chmod($dir.$aFile->filename, 0777);
				}
		}
		
	$arc->closeArchive();
	print "Done";
?>