unit WebArcU;

interface

uses
	KOL, KOLZLib, Windows, wcxhead;

type
	PAFile = ^TAFile;
	TAFile = object(TObj)
	private
    function GetIsDirectory: boolean;
	public
		Name: string;
		time, uncsize, csize, offset: integer;

		function CreateClone: PAFile;
		function WindowsName(BSFirst: boolean = True): string;

		procedure LoadFromStream(S: PStream);
		procedure SaveToStream(S: PStream);
		property IsDirectory: boolean read GetIsDirectory;
	end;

	PArcReader = ^TArcReader;
	TArcReader = object(TObj)
	private
		procedure ReadArchiveID;
		procedure ReadFiles;
		procedure SeekToFile(AFile: PAFile);
	protected
		procedure Init; virtual;
	public
		S: PStream;
		Version: integer;
		Valid: boolean;
		Files: PList;
		FileStart: integer;
		FilePointer: integer;
		FileName: string;

		procedure Open(AFileName: string);
		destructor Destroy; virtual;
		procedure SkipPastFile(AFile: PAFile);
		function DecompressFile(AFile: PAFile; DestPath, DestName: string): integer;
		function GetCompressedFileData(AFile: PAFile): PStream;
	end;

	PArcWriter = ^TArcWriter;
	TArcWriter = object(TObj)
	private
    function DoArchiveOp(IsDelete: boolean; DestFile: string;
      Lst: PStrList; SubPath, SrcPath: PChar; Flags: integer;
      AR: PArcReader): integer;
	public
  	FileName: string;

		function PackFiles(DestFile: string; Lst: PStrList; SubPath, SrcPath: PChar; Flags: integer; AR: PArcReader): integer;
		function DeleteFiles(DestFile: string; Lst: PStrList; AR: PArcReader): integer;
	end;

function NewArcReader(FileName: string): PArcReader;
function NewAFile: PAFile;
function NewArcWriter: PArcWriter;

type
	TOpInProgress = (oRead, oWrite);

var
	OpInProgress: TOpInProgress;
	CurrentWriter: PArcWriter;
	ProcessDataProc: TProcessDataProc;

implementation

uses
	commonsU;

function NewArcReader(FileName: string): PArcReader;
begin
	New(Result, Create);
	Result.Open(FileName);
end;

function NewAFile: PAFile;
begin
	New(Result, Create);
end;

function NewArcWriter: PArcWriter;
begin
	New(Result, Create);
	CurrentWriter := Result;
end;

{ TArcReader }

procedure TArcReader.ReadArchiveID;
var
	Buf: array[0..6] of char;
begin
	FillChar(Buf, SizeOf(Buf), 0);
	S.Read(Buf, SizeOf(Buf) - 1);
	if Buf = 'WEBARC' then
		begin
			S.Read(Version, SizeOf(Version));
			Valid := True;
		end
	else
		Version := $FFFF;
end;

procedure TArcReader.Open;
begin
	S := NewReadFileStream(AFileName);
	FileName := AFileName;
	ReadArchiveID;
	if Valid then
		begin
			ReadFiles;
			FileStart := S.Position;
			FilePointer := -1;
		end;
end;

procedure TArcReader.ReadFiles;
var
	FileCount, i: integer;
	AFile: PAFile;
begin
	S.Read(FileCount, SizeOf(FileCount));
	for i := 1 to FileCount do
		begin
			AFile := NewAFile;
			AFile.LoadFromStream(S);
			Files.Add(AFile);
		end;
end;

destructor TArcReader.Destroy;
var
	i: integer;
begin
	for i := 0 to Files.Count - 1 do
		PAFile(Files.Items[i]).Free;
	Files.Free;
	S.Free;
	inherited Destroy;
end;

procedure TArcReader.Init;
begin
	Files := NewList;
end;

procedure TArcReader.SeekToFile(AFile: PAFile);
begin
	S.Seek(FileStart + AFile.offset, spBegin);
end;

function TArcReader.DecompressFile(AFile: PAFile; DestPath,
	DestName: string): integer;
var
	MemS, DecS, OutS: PStream;
begin
	DestName := DestPath + DestName;
	OutS := NewWriteFileStream(DestName);
	if AFile.IsDirectory then
		MkDir(DestPath + DestName)
	else if AFile.uncsize > 0 then
		begin
			MemS := GetCompressedFileData(AFile);
			DecS := NewDecompressionStream(MemS, nil);
			Stream2Stream(OutS, DecS, AFile.uncsize);
			DecS.Free;
			MemS.Free;
		end;
	OutS.Free;
	if Assigned(ProcessDataProc) then
		ProcessDataProc(PChar(AFile.WindowsName), AFile.uncsize);
	Result := 0;
end;

procedure TArcReader.SkipPastFile(AFile: PAFile);
begin
	SeekToFile(AFile);
	S.Seek(AFile.csize, spCurrent);
	if Assigned(ProcessDataProc) then
		ProcessDataProc(PChar(AFile.WindowsName), AFile.uncsize);
end;

function TArcReader.GetCompressedFileData(AFile: PAFile): PStream;
begin
	SeekToFile(AFile);
	Result := NewMemoryStream;
	Stream2Stream(Result, S, AFile.csize);
	Result.Seek(0, spBegin);
end;

{ TAFile }

function TAFile.CreateClone: PAFile;
begin
	New(Result, Create);
	Result.Name := Name;
	Result.time := time;
	Result.uncsize := uncsize;
	Result.csize := csize;
	Result.offset := offset;
end;

function TAFile.WindowsName(BSFirst: boolean = True): string;
begin
	Result := Name;
	MyStrReplace(Result, '/', '\');
	if BSFirst then Result := '\' + Result;
end;

procedure TAFile.LoadFromStream(S: PStream);
var
	NSize: word;
begin
	S.Read(NSize, SizeOf(NSize));
	SetLength(Name, NSize);
	S.Read(Name[1], NSize);
	S.Read(time, SizeOf(time));
	S.Read(uncsize, SizeOf(uncsize));
	S.Read(csize, SizeOf(csize));
	S.Read(offset, SizeOf(offset));
end;

procedure TAFile.SaveToStream(S: PStream);
var
	NSize: word;
begin
	NSize := Length(Name);
	S.Write(NSize, SizeOf(NSize));
	S.Write(Name[1], NSize);
	S.Write(time, SizeOf(time));
	S.Write(uncsize, SizeOf(uncsize));
	S.Write(csize, SizeOf(csize));
	S.Write(offset, SizeOf(offset));
end;

function TAFile.GetIsDirectory: boolean;
begin
	if Name = '' then
		Result := False
	else
		Result := (Name[Length(Name)] = '/');
end;

{ TArcWriter }

function TArcWriter.DeleteFiles(DestFile: string; Lst: PStrList; AR: PArcReader): integer;
begin
	Result := DoArchiveOp(True, DestFile, Lst, '', '', 0, AR);
end;

function ToBeReplaced(Lst: PStrList; fn: string): boolean;
var
	i: integer;
begin
	Result := False;
	for i := 0 to Lst.Count - 1 do
		if Lst.Items[i] = fn then
			begin
				Result := True;
				break;
			end;
end;

function TArcWriter.DoArchiveOp(IsDelete: boolean; DestFile: string; Lst: PStrList; SubPath, SrcPath: PChar;
	Flags: integer; AR: PArcReader): integer;
const
	CHdr: array[0..5] of char = ('P', 'H', 'P', 'A', 'R', 'C');
	CVersion = 100;
var
	Hdr: array[0..5] of char;
	Ver, i, TotFiles, FilesStart, offs, ArcEnd: integer;
	ReaderFiles, NewFiles: PList;
	InS, OutS, CmpS, TmpS: PStream;
	AFile: PAFile;
	fn: string;
begin
	if FileExists(DestFile) then DeleteFile(PChar(DestFile));
	OutS := NewReadWriteFileStream(DestFile);

	Move(CHdr, Hdr, SizeOf(CHdr));
	OutS.Write(Hdr, SizeOf(Hdr));
	Ver := CVersion;
	OutS.Write(Ver, SizeOf(Ver));

	ReaderFiles := NewList;
	if Assigned(AR) then
		for i := 0 to AR.Files.Count - 1 do
			if not ToBeReplaced(Lst, PAFile(AR.Files.Items[i]).WindowsName(False)) then
				ReaderFiles.Add(AR.Files.Items[i]);

	NewFiles := NewList;
	if not IsDelete then
		for i := 0 to Lst.Count - 1 do
			begin
				fn := SubPath + Lst.Items[i];
				if (Flags and PK_PACK_SAVE_PATHS) <> 0 then
					MyStrReplace(fn, '\', '/')
				else
					fn := ExtractFileName(fn);
				AFile := NewAFile;
				AFile.Name := fn;
				AFile.time := DateTimeToUnix(FileAge(SrcPath + Lst.Items[i]));
				if AFile.IsDirectory then
					AFile.uncsize := 0
				else
					AFile.uncsize := FileSize(SrcPath + Lst.Items[i]);
				AFile.csize := 0;
				AFile.offset := 0;
				NewFiles.Add(AFile);
			end;

	TotFiles := ReaderFiles.Count + NewFiles.Count;
	OutS.Write(TotFiles, SizeOf(TotFiles));

	FilesStart := OutS.Position;

	for i := 0 to ReaderFiles.Count - 1 do
		PAFile(ReaderFiles.Items[i]).SaveToStream(OutS);
	for i := 0 to NewFiles.Count - 1 do
		PAFile(NewFiles.Items[i]).SaveToStream(OutS);

	offs := 0;

	for i := 0 to ReaderFiles.Count - 1 do
		begin
			AFile := PAFile(ReaderFiles.Items[i]);
			AFile.offset := offs;
			InS := AR.GetCompressedFileData(AFile);
			Stream2Stream(OutS, InS, InS.Size);
			InS.Free;
			offs := offs + AFile.csize;
		end;

	for i := 0 to NewFiles.Count - 1 do
		begin
			AFile := PAFile(NewFiles.Items[i]);
			AFile.offset := offs;

			if (not AFile.IsDirectory) and (AFile.uncsize > 0) then
				begin
					InS := NewReadFileStream(SrcPath + Lst.Items[i]);
					if InS.Data.fHandle = INVALID_HANDLE_VALUE then
						begin
							OutS.Free;
							NewFiles.Free;
							ReaderFiles.Free;
							Result := E_EREAD;
							exit;
						end;

					TmpS := NewMemoryStream;
					CmpS := NewCompressionStream(clMax, TmpS, nil);
					Stream2Stream(CmpS, InS, InS.Size);
					CmpS.Free;

					if TmpS.Size >= InS.Size then
						begin
							AFile.csize := InS.Size;
							InS.Seek(0, spBegin);
							Stream2Stream(OutS, InS, InS.Size);
						end
					else
						begin
							AFile.csize := TmpS.Size;
							TmpS.Seek(0, spBegin);
							Stream2Stream(OutS, TmpS, TmpS.Size);
						end;
					InS.Free;
					TmpS.Free;

					offs := offs + AFile.csize;
				end;
			if Assigned(ProcessDataProc) then
				ProcessDataProc(PChar(AFile.WindowsName), AFile.uncsize);
		end;
	ArcEnd := OutS.Position;
	OutS.Seek(FilesStart, spBegin);
	// The below is a waste if there are many files, but I couldn't make myself go through the hassle
	// of just writing the updated csize and offset data. Do it and send the result to me!
	for i := 0 to ReaderFiles.Count - 1 do
		PAFile(ReaderFiles.Items[i]).SaveToStream(OutS);
	for i := 0 to NewFiles.Count - 1 do
		PAFile(NewFiles.Items[i]).SaveToStream(OutS);

	OutS.Seek(ArcEnd, spBegin);
	OutS.Free;
	NewFiles.Free;
	ReaderFiles.Free;
	Result := 0;	
end;

function TArcWriter.PackFiles(DestFile: string; Lst: PStrList; SubPath, SrcPath: PChar;
	Flags: integer; AR: PArcReader): integer;
begin
	Result := DoArchiveOp(False, DestFile, Lst, SubPath, SrcPath, Flags, AR);
end;

end.
