unit commonsU;

interface

function DateTimeToUnix(const AValue: TDateTime): Int64;
function UnixToDateTime(const AValue: Int64): TDateTime;
function FileAge(const FileName: string): Integer;
procedure Debug(st: string);
procedure MyStrReplace(var st: string; rfrom, rto: string);

implementation

uses
	Windows, KOL;

type
	LongRec = packed record
		case Integer of
			0: (Lo, Hi: Word);
			1: (Words: array [0..1] of Word);
			2: (Bytes: array [0..3] of Byte);
	end;
	
const
	UnixDateDelta = 25569;
  HoursPerDay   = 24;
  MinsPerDay    = HoursPerDay * 60;
  SecsPerDay    = MinsPerDay * 60;

function DateTimeToUnix(const AValue: TDateTime): Int64;
begin
	Result := Round((AValue - UnixDateDelta) * SecsPerDay);
end;

function UnixToDateTime(const AValue: Int64): TDateTime;
begin
	Result := AValue / SecsPerDay + UnixDateDelta;
end;

function FileAge(const FileName: string): Integer;
var
	Handle: THandle;
	FindData: TWin32FindData;
	LocalFileTime: TFileTime;
begin
	Handle := FindFirstFile(PChar(FileName), FindData);
	if Handle <> INVALID_HANDLE_VALUE then
	begin
		Windows.FindClose(Handle);
		if (FindData.dwFileAttributes and FILE_ATTRIBUTE_DIRECTORY) = 0 then
		begin
			FileTimeToLocalFileTime(FindData.ftLastWriteTime, LocalFileTime);
			if FileTimeToDosDateTime(LocalFileTime, LongRec(Result).Hi,
				LongRec(Result).Lo) then Exit;
		end;
	end;
	Result := -1;
end;

procedure Debug(st: string);
var
	F: TextFile;
begin
	AssignFile(F, 'C:\debug.out');
	if FileExists('C:\debug.out') then
		Append(F)
	else
		Rewrite(F);
	Writeln(F, st);
	CloseFile(F);
end;

procedure MyStrReplace(var st: string; rfrom, rto: string);
begin
	repeat
	until not StrReplace(st, rfrom, rto);
end;

end.

