program appcrc;
{$APPTYPE CONSOLE}

uses
  sysutils, crc, windows;
var
    buf: array [0..32767] of byte;
    nr, h: integer;
    filecrc: cardinal;
begin
  if ParamCount = 0 then begin
     writeln('Missing parameter.');
     readln;
     halt;
  end;
  h := CreateFile(PChar(ParamStr(1)),
                  GENERIC_READ + GENERIC_WRITE,
                  FILE_SHARE_READ,
                  NIL,
                  OPEN_EXISTING,
                  FILE_ATTRIBUTE_NORMAL,
                  0);
  try
     CRC32Init(filecrc);
     repeat
       nr := FileRead(h, Buf, sizeof(buf));
       CRC32Update(filecrc, @Buf, nr);
     until (nr = 0);
     CRC32Final(filecrc);
     FileWrite(h, filecrc, sizeof(filecrc));
  finally
     CloseHandle(h);
  end;
end.
 