'Rico Bautsch, vp 22.12.2009 - 26.12.2009
'v0.2: Umstellung auf Scripting.Dictionary
'v0.4: Formatauswahl vorbereitet (Umstellung auf class cpmimage)
'v0.5: Formatauswahl ber Eigenschaften-Dialog
'v0.6: User als Unterverzeichnisse, Anzeige von cpmtools-Fehlermeldungen
'v0.7: on error ...
'v0.8: Rico Bautsch: Persistente cpmimages, Lschen von cpmimages
'v0.9:  21.01.2010: Kopieren in Verzeichnisse mit Leerzeichen ist jetzt mglich
'v0.10: 02.02.2010: Umstellnugauf cpmls -F, Anzeige Datumsformat bei CP/M 3

'-- Globale Script-Objekte erzeugen
SET fso = CreateObject("Scripting.FileSystemObject")
SET shell = CreateObject("Wscript.Shell")
Set cpmimages = CreateObject("Scripting.Dictionary")
class cpmimage
  Public pfad
  Public Format
End class

Dim CurrentUser

Dim Status_RemovingImage
Status_RemovingImage = False

LoadDictionary

'-- Plugin-Funktion, welche aufgerufen wird, wenn Dateilisting angefordert wird
Function FsFindFiles(ByVal Path)
   If Status_RemovingImage = True Then
   	FsFindFiles = True
   	Exit Function
   End If

  'MsgBox "FsFindFiles " & Path
  If Path = "\" Then
    'Disketten-Laufwerke in Image-Liste aufnehmen
    For Each Drive In fso.Drives
      'MsgBox Drive.DriveLetter & " " & Drive.DriveType
      If Drive.DriveType = 1 and Drive.DriveLetter < "C" Then 'Austauschbar 
        If not cpmimages.exists(Drive.DriveLetter & ":") Then
          Set img = new cpmimage
          img.pfad = Drive.DriveLetter & ":"
          img.Format = "default"	
          cpmimages.Add Drive.DriveLetter & ":", img
        End If
      End If
    Next

    'Images in Dateilisting aufnehmen
    For Each filename in cpmimages.Keys
      Set File = ScriptFiles.Add
      File.Name = filename
      File.Attributes = FILE_ATTRIBUTE_DIRECTORY
    Next

    FsFindFiles = True
  Else
    On Error Resume Next

    Path = Mid(Path,2)	'der Pfad fngt mit '\' an
    If Right(Path,1)= "\" Then
      Path = Left(Path, Len(Path)-1)
    End If
    If InStrRev(Path, "\") > 0 Then
      'Unterverzeichis = User
      CurrentUser = Mid(Path,InStrRev(Path, "\")+1)
      Path = Left(Path, InStrRev(Path, "\")-1)
    
      Pfad = cpmimages.item(Path).pfad
      aCmd = "cpmls.exe -F -f " & cpmimages.item(Path).format & " """ & pfad & """ " & CurrentUser & ":*"
      ReadDir(aCmd) 'Aufruf der Hilfsfunktion
      FsFindFiles = True
    Else
      CurrentUser = "0"
      Pfad = cpmimages.item(Path).pfad
      aCmd = "cpmls.exe -F -f " & cpmimages.item(Path).format & " """ & pfad & """"
      ReadDir(aCmd) 'Aufruf der Hilfsfunktion
      FsFindFiles = True
    End If
  End If
End Function

'-- Hilfsfunktion, die fr einen angegebenen Ordner die Unterordner/Dateien listet,
'-- indem die Ausgabe des Kommandos in eine temporre Datei umgeleitet,
'-- und anschlieend gelesen und interpretiert wird.
'-- Benutzt "Run" um das schwarze Dos-Fenster zu unterdrcken

'--so sieht cpmls -F aus:
'Directory For Drive A:  User  0
'
'    Name     Bytes   Recs   Attributes   Prot      Update          Create
'------------ ------ ------ ------------ ------ --------------  --------------
'
'20Z      COM     2k      1              None   01/01/70 00:00  01/01/70 00:00
'24Z      COM     2k      1              None   01/01/70 00:00  01/01/70 00:00
'6AUS49#3 ZBS     2k      2              None   01/01/70 00:00  01/01/70 00:00
'ZSID     COM    10k     80              None   01/01/70 00:00  01/01/70 00:00
'                  ^='k' dann Dir-Zeile
'                   ='e' dann User-Zeile
'
'Total Bytes     =    472k  Total Records =    3770  Files Found =   69
'Total 1k Blocks =    542   Used/Max Dir Entries For Drive A:   76/ 192

'cpm3:
'DIR2             4k     25              Read   12/26/09 13:16  12/26/09 13:16
'DIR3             8k     53              Read   12/26/09 13:16  12/26/09 13:16


Function ReadDir(aCmd)
  tmpFile = MyShellExecute(aCmd)

  SET file = fso.OpenTextFile(tmpFile, 1)
  Do Until file.AtEndOfStream
    sLine = file.Readline
    If Mid(sLine,19,1) = "e" Then
      'User-Zeile
      DirUser = Trim(Mid(sLine,29))
      If DirUser <> CurrentUser Then
        SET tcFile = ScriptFiles.Add
        tcFile.Name = DirUser
        tcFile.Attributes = FILE_ATTRIBUTE_DIRECTORY
      End If
    ElseIf Mid(sLine,19,1) = "k" and DirUser = CurrentUser Then
      'Dir-Zeile
	curLocale = SetLocale("en-us")
	sDateTime = CDate(Mid(sLine, 48, 14))
	SetLocale(curLocale)
	sSize = Trim(Mid(sLine, 21, 6)) * 128 'size is is records
	sName = LCase(Trim(Mid(sLine, 1, 8)) & "." & Trim(Mid(sLine, 10, 3)))

      SET tcFile = ScriptFiles.Add
      tcFile.Name = sName
      tcFile.LastWriteTime = CDate(sDateTime)
      tcFile.Size = sSize
    End If
  Loop

  file.Close
'  fso.DeleteFile(tmpFile)

End Function


' folgendes ist aus Local Filesystem.vbs
Function FsExecuteFile(ByVal MainWin, ByRef RemoteName, ByVal Verb)
  If (RemoteName = "\") and (Verb = "properties") Then
    MsgBox "ScriptWFX for CP/M Disks and Images" & Chr(10) & _
      "Volker Pohlers, Rico Bautsch 2010"
    FsExecuteFile = FS_EXEC_OK
  Else
    If Verb = "properties" Then
      RemoteName = Mid(RemoteName, 2)
      If cpmimages.exists(RemoteName) Then
        'MsgBox "Datei: " & cpmimages.item(RemoteName).pfad & Chr(10) & "Format: " & cpmimages.item(RemoteName).format _ 
        '  & Chr(10) & Chr(10) & GetCPMFormats, 0 , "Properties of CP/M-Image " & RemoteName 
        
        newformat = InputBox (GetCPMFormats, cpmimages.item(RemoteName).pfad, cpmimages.item(RemoteName).format)
        If newformat <> "" Then
          cpmimages.item(RemoteName).format = newformat
          SaveDictionary
        End If
       
        FsExecuteFile = FS_EXEC_OK
      End If
    Else
      MsgBox "FsExecuteFile: RemoteName " & RemoteName & " Verb " & Verb
      'RemoteName = Mid(RemoteName, 2)
      'If Verb = "open" Then
      '  set objShell=CreateObject("Wscript.Shell")
      '  objShell.Run(RemoteName)
      '  FsExecuteFile = FS_EXEC_OK
      'ElseIf Verb = "properties" Then
      '  MsgBox "Show Properties of File " & RemoteName
      '  FsExecuteFile = FS_EXEC_OK
      'ElseIf Mid(Verb,1,5) = "quote" Then
      '  if Mid(Verb,7,2) = "cd" then
      '    RemoteName = "\Local Filesystem\" & RemoteName & Mid(Verb,10)
      '    FsExecuteFile = FS_EXEC_SYMLINK
      '  end if
    End If
  End If
End Function


Function FsGetFile(ByVal RemoteName, ByRef LocalName, ByVal CopyFlags)
  'MsgBox "FsGetFile: RemoteName " & RemoteName & " LocalName " & LocalName & " CopyFlags " & CopyFlags

  err = tc.ProgressProc(RemoteName, LocalName, 0)
  If err = 1 Then
    FsGetFile = FS_FILE_USERABORT
    Exit Function
  End If

  If CopyFlags and FS_COPYFLAGS_RESUME Then
    FsGetFile = FS_FILE_NOTSUPPORTED
    Exit Function
  End If
  
  On Error Resume Next

  'Remotename in Imagename und Filename und CurrentUser auftrennen
  cpmImg = Mid(RemoteName, 2, InStrRev(RemoteName, "\")-2 )
  cpmFile = Mid(RemoteName, InStrRev(RemoteName, "\")+1)
  If InStrRev(cpmImg, "\") > 0 Then
    CurrentUser = Mid(cpmImg,InStrRev(cpmImg, "\")+1)
    cpmImg = Left(cpmImg,InStrRev(cpmImg, "\")-1)
  Else
    CurrentUser = "0"
  End If
  'MsgBox "cpmImg: " & cpmImg & " CurrentUser: " & CurrentUser & " cpmFile: " & cpmFile
  
  'Datei kopieren
  aCmd = "cpmcp.exe -f " & cpmimages.item(cpmImg).format & " """ & cpmimages.item(cpmImg).pfad & """ " & CurrentUser & ":" & cpmFile & " """ & LocalName & """"
  MyShellExecute(aCmd)

  err = tc.ProgressProc(RemoteName, LocalName, 100)
  
  On Error Goto 0
End Function



Function FsPutFile(ByVal LocalName, ByRef RemoteName, ByVal CopyFlags)
  'MsgBox "FsPutFile: LocalName " & LocalName & " RemoteName " & RemoteName & " CopyFlags " & CopyFlags

  err = tc.ProgressProc(LocalName, RemoteName, 0)
  If err = 1 Then
    FsGetFile = FS_FILE_USERABORT
    Exit Function
  End If

  If CopyFlags and FS_COPYFLAGS_RESUME Then
    FsGetFile = FS_FILE_NOTSUPPORTED
    Exit Function
  End If
  
  On Error Resume Next

  If InStrRev(RemoteName, "\") = 1 Then
    'neues ScriptFile
    If not cpmimages.exists(Mid(RemoteName, 2)) Then
      Set img = new cpmimage
      img.pfad = LocalName
      img.Format = "default"	
      cpmimages.Add Mid(RemoteName, 2), img
      
      SaveDictionary
    End If
  Else
    'Kopieren in CPM-Image

    'Remotename in Imagename und Filename und CurrentUser auftrennen
    cpmImg = Mid(RemoteName, 2, InStrRev(RemoteName, "\")-2 )
    cpmFile = Mid(RemoteName, InStrRev(RemoteName, "\")+1)
    If InStrRev(cpmImg, "\") > 0 Then
      CurrentUser = Mid(cpmImg,InStrRev(cpmImg, "\")+1)
      cpmImg = Left(cpmImg,InStrRev(cpmImg, "\")-1)
    Else
      CurrentUser = "0"
    End If
  
    'Datei kopieren
    aCmd = "cpmcp.exe -f " & cpmimages.item(cpmImg).format & " """ & cpmimages.item(cpmImg).pfad & """" & " """ & LocalName & """ " & CurrentUser & ":" & cpmFile
    MyShellExecute(aCmd)
  End If

  FsPutFile = FS_FILE_OK

  err = tc.ProgressProc(LocalName, RemoteName, 100)
  
  On Error Goto 0
End Function


Function FsDeleteFile(ByVal RemoteName)
  'MsgBox "FsDeleteFile " & RemoteName

  If Status_RemovingImage = True Then
    FsDeleteFile = True
    Exit Function
  End If

  If InStrRev(RemoteName, "\") = 1 Then
    MsgBox "todo: FsDeleteFile RemoteName"
  Else
    'Remotename in Imagename und Filename und CurrentUser auftrennen
    cpmImg = Mid(RemoteName, 2, InStrRev(RemoteName, "\")-2 )
    cpmFile = Mid(RemoteName, InStrRev(RemoteName, "\")+1)
    If InStrRev(cpmImg, "\") > 0 Then
      CurrentUser = Mid(cpmImg,InStrRev(cpmImg, "\")+1)
      cpmImg = Left(cpmImg,InStrRev(cpmImg, "\")-1)
    Else
      CurrentUser = "0"
    End If

    'Datei lschen
    aCmd = "cpmrm.exe -f " & cpmimages.item(cpmImg).format & " """ & cpmimages.item(cpmImg).pfad & """ " & CurrentUser & ":" & cpmFile
    MyShellExecute(aCmd)
    FsDeleteFile = True
  End If
End Function


Function FsRemoveDir(ByVal RemoteName)
  'MsgBox "FsRemoveDir " & RemoteName

  RemoteName = Mid(RemoteName, 2)
  If cpmimages.exists(RemoteName) Then
    cpmimages.Remove(RemoteName)
    SaveDictionary
    FsRemoveDir = True
  End If

End Function


Function FsDisconnect(ByVal DisconnectRoot)
  MsgBox "Disconnect... " & DisconnectRoot
  FsDisconnect = False
End Function


Function FsExtractCustomIcon(ByRef RemoteName, ByVal ExtractFlags, ByRef TheIcon)
  bSmall = ExtractFlags and FS_ICONFLAG_SMALL
  
  if RemoteName = "\" then
    TheIcon = utils.ExtractIcon("CPMTest.ico", 0, bSmall)
    FsExtractCustomIcon = FS_ICON_EXTRACTED_DESTROY
  end if
End Function


Sub FsStatusInfo(ByVal RemoteDir, ByVal InfoStartEnd, ByVal InfoOperation)
  'MsgBox "FsStatusInfo " & RemoteDir & " InfoStartEnd " & InfoStartEnd & " InfoOperation " & InfoOperation
  If (RemoteDir = "\") AND (InfoOperation = FS_STATUS_OP_DELETE) Then
    If InfoStartEnd = FS_STATUS_START Then
      Status_RemovingImage = True
    ElseIf InfoStartEnd = FS_STATUS_END Then
      Status_RemovingImage = False
    End If
  End If
End Sub


'My Helpers

'-- Pfad zurckgeben
Function ExtractPath(ByVal FileName)
  ExtractPath = Mid(FileName, 1, InStrRev(FileName, "\")-1)
End Function

'-- Hilfsfunktion, die ein Kommando im DOS-Fenster ausfhrt
'-- die Ausgabe des Kommandos wird in eine temporre Datei umgeleitet
'-- Benutzt "Run", um das schwarze Dos-Fenster zu unterdrcken
Function MyShellExecute(ByVal cmd)
  'MsgBox "MyShellExecute " & cmd
  Set env = shell.Environment("PROCESS")
  tmpFile = env("temp") & "\dir.txt"
  errFile = env("temp") & "\err.txt"
  aCmd = "cmd /c cd /d """ & ExtractPath(plugin.ScriptFileName) & """ & " & cmd & " > " & tmpFile & " 2> " & errFile 
  'MsgBox "MyShellExecute " & aCmd
  shell.Run aCmd, 0, True
  GetError errFile, "C/PM-Disk Fehler"
  MyShellExecute = tmpFile
End Function


'-- Errorfile ffnen und anzeigen
Function GetError(ByVal tmpFile, ByVal title)
  SET file = fso.OpenTextFile(tmpFile, 1)
  Do Until file.AtEndOfStream
    sLine = sLine & file.Readline & Chr(10)
  Loop
  file.Close
  'fso.DeleteFile(tmpFile)
  
  If sLine <> "" Then
    MsgBox sLine, 0, title
    GetError = vbTrue
  Else
    GetError = vbFalse
  End If
End Function

'-- alle Formate aus 'diskdefs' auslesen
Function GetCPMFormats
  SET file = fso.OpenTextFile(ExtractPath(plugin.ScriptFileName) & "\diskdefs", 1)
  formatlist = ""
  Do Until file.AtEndOfStream
    sLine = file.Readline

    If Left(sLine, 7) = "diskdef" Then
    	formatlist = formatlist & Mid(sLine, 9) & Chr(10) 'Formatname
    End If
  Loop
  file.Close
  GetCPMFormats = formatlist
End Function

'-- Speichern der aktuellen CPM-Imageliste
Sub SaveDictionary
  Set env = shell.Environment("PROCESS")
  FileNameDict = env("temp") & "\CPM_MountedImages.txt"
  
  If fso.FileExists(FileNameDict) Then
    fso.DeleteFile(FileNameDict)
  End If
  
  If cpmimages.Count > 0 Then
    Set file = fso.CreateTextFile(FileNameDict, True)

    For Each filename in cpmimages.Keys
      Set img = cpmimages.Item(filename)
      file.WriteLine(filename & ";" & img.Pfad & ";" & img.Format)
    Next

    file.Close
  End If
End Sub


'-- Laden der aktuellen CPM-Imageliste
Sub LoadDictionary
  Set env = shell.Environment("PROCESS")
  FileNameDict = env("temp") & "\CPM_MountedImages.txt"

  If fso.FileExists(FileNameDict) Then
    SET file = fso.OpenTextFile(FileNameDict, 1)

    Do Until file.AtEndOfStream
      s = file.ReadLine
      arr = Split(s, ";")
      If not cpmimages.Exists(arr(0)) Then
        Set img = new cpmimage
        img.pfad = arr(1)
        img.Format = arr(2)    
        cpmimages.Add arr(0), img
      End If
    Loop

    file.Close
  End If
End Sub

