using System;
using System.Collections;
using System.Runtime.InteropServices;
using System.Text;
using CONNAPI;

namespace MosTech.Nokia
{
    public class DeviceManagement : IDisposable
    {
        public DeviceManagement()
        {



            OpenDM();
        }

        private unsafe void OpenDM()
        {
            m_hDMHandle = IntPtr.Zero;


            uint retVal = ConnAPI.CONAInitialize(CONAPI_CONSTANTS.CONA_API_VERSION, "Nokia", IntPtr.Zero);
            if (retVal != CONAPI_ERRORS.CONA_OK)
                throw new Exception(CONAPI_ERRORS.CONAError2String(retVal));

            // Open Device Management connection
            fixed (IntPtr* pp = &m_hDMHandle)
            {
                retVal = ConnAPI.CONAOpenDM(pp);
            }
            if (retVal != CONAPI_ERRORS.CONA_OK)
            {
                m_hDMHandle = IntPtr.Zero;
                throw new Exception("CONAOpenDM failed!" + Environment.NewLine + CONAPI_ERRORS.CONAError2String(retVal));
            }
        }



        private IntPtr m_hDMHandle;

        #region IDisposable Members

        public void Dispose()
        {
            uint retVal = 0;
            if (m_hDMHandle != IntPtr.Zero)
            {
                //// Unregister callback function:
                //retVal = ConnAPI.CONARegisterNotifyCallback(m_hDMHandle, CONAPI_CONSTANTS.CONAPI_UNREGISTER, pfnCallBack);
                //if (retVal != CONAPI_ERRORS.CONA_OK)
                //{
                //    CONAPI_ERRORS.ShowError("CONARegisterNotifyCallback unregister failed!", retVal);
                //}
                // Close DM connection

                retVal = ConnAPI.CONACloseDM(m_hDMHandle);
                if (retVal != CONAPI_ERRORS.CONA_OK)
                {

                    CONAPI_ERRORS.ShowError("CONACloseDM failed!", retVal);
                }
                m_hDMHandle = IntPtr.Zero;
            }
            // Uninitialize PC Suite connectivity API
            retVal = ConnAPI.CONAUninitialize(0);
            if (retVal != CONAPI_ERRORS.CONA_OK)
            {
                CONAPI_ERRORS.ShowError("CONAUninitialize failed!", retVal);
            }
        }

        public unsafe int GetDeviceCount()
        {
            int dwDeviceCount = 0;
            uint retVal = ConnAPI.CONAGetDeviceCount(m_hDMHandle, &dwDeviceCount);
            if (retVal != CONAPI_ERRORS.CONA_OK)
                throw new Exception(CONAPI_ERRORS.CONAError2String(retVal));
            return dwDeviceCount;
        }

        public unsafe DeviceInfo[] GetDevices()
        {
          // ConnAPI.CONAPI_DEVICE* pDevices;// = null;
            int dwDeviceCount = GetDeviceCount();
            DeviceInfo[] nokiadevices = new DeviceInfo[dwDeviceCount];


            if (dwDeviceCount > 0)
            {
                IntPtr buffer = Marshal.AllocHGlobal(dwDeviceCount * Marshal.SizeOf(typeof(ConnAPI.CONAPI_DEVICE)));
                

                ConnAPI.CONAGetDevices(m_hDMHandle, &dwDeviceCount, buffer);
                IntPtr iter = buffer;

                
                // Go through all devices 
                for (int i = 0; i < dwDeviceCount; i++)
                {
                   ConnAPI.CONAPI_DEVICE pDevice = (ConnAPI.CONAPI_DEVICE)Marshal.PtrToStructure(iter, typeof(ConnAPI.CONAPI_DEVICE));
                   nokiadevices[i] = new DeviceInfo(pDevice.pstrFriendlyName, pDevice.pstrSerialNumber);
                   iter = (IntPtr)((int)iter + Marshal.SizeOf(typeof(ConnAPI.CONAPI_DEVICE)));
                }

                ConnAPI.CONAFreeDeviceStructure(dwDeviceCount, buffer);


            }

            return nokiadevices;

        }

        //public void RenameFriendlyName(string serialNumber, string newFriendlyName)
        //{

        //    retVal = CONNAPI.ConnAPI.CONARenameFriendlyName(m_hDMHandle, serialNumber, newFriendlyName);

        //}

        #endregion
    }
}
