using System;


namespace MosTech.Nokia
{

    public enum ErrorCode : uint
    {
        OK = 0x00000000,	// Everything ok
        // Common errorCode codes:
        InitFailed = 0x80100000,	                                                        // DLL initialization failed
        InitFailedComInterface = 0x80100002,	                                                            // Failed to get connection to ServiceLayer.
        NotInitialized = 0x80100004,	                                                        // API is not initialized
        UnsupportedApiVersion = 0x80100005,	                                                            // Failed, not supported API version
        NotSupportedManufacturer = 0x80100006,	                                                            // Failed, not supported manufacturer

        UnknownError = 0x80100010,	                                                            // Failed, unknown errorCode
        UnknownErrorDevice = 0x80100011,	                                                        // Failed, unknown errorCode from Device
        InvalidPointer = 0x80100012,	                                                        // Required pointer is invalid
        InvalidParameter = 0x80100013,	                                                            // Invalid Parameter value 
        InvalidHandle = 0x80100014,	                                                            // Invalid HANDLE
        NotEnoughMemory = 0x80100015,	                                                            // Memory allocation failed in PC
        WrongThread = 0x80100016,	                                                        // Failed, Called interface was marshalled for a different thread.

        Cancelled = 0x80100020,	                                                            // Operation cancelled by ConnectivityAPI-User
        NothingToCancel = 0x80100021,	                                                            // No running functions
        FailedTimeout = 0x80100022,	                                                            // Operation failed because of timeout
        NotSupportedDevice = 0x80100023,	                                                        // Device do not support operation
        NotSupportedPc = 0x80100024,	                                                        // ConnectivityAPI do not support operation (not implemented)

        // Device manager and device connection releated errorCode:
        DeviceNotFound = 0x80200000,	                                                        // Given phone is not connected (refresh device list)
        NoConnectionViaMedia = 0x80200001,	                                                            // Phone is connected but not via given Media
        NoConnectionViaDevid = 0x80200002,	                                                            // Phone is not connected with given DevID
        InvalidConnectionType = 0x80200003,	                                                            // Connection type was invalid
        NotSupportedConnectionType = 0x80200004,	                                                            // Device do not support connection type
        ConnectionBusy = 0x80200005,	                                                        // Other application is reserved connection
        ConnectionLost = 0x80200006,	                                                        // Connection is lost to Device
        ConnectionRemoved = 0x80200007,	                                                            // Connection removed, other application is reserved connection.
        ConnectionFailed = 0x80200008,	                                                            // Connection failed, unknown reason
        Suspend = 0x80200009,	                                                        // Connection removed, PC goes suspend state
        NameAlreadyExists = 0x8020000a,	                                                            // Friendly name already exist

        // File System errors:
        AllListed = 0x80300000,	                                                            // All items are listed
        MemoryFull = 0x80300001,	                                                        // Device memory full

        // File System errorCode for file functions:
        FileNameInvalid = 0x80400001,	                                                            // File name includes invalid characters in Device or PC
        FileNameTooLong = 0x80400002,	                                                            // Max unicode charaters in File name (includes current/target path) 
        // is limited to 256 charaters in device. (256 charaters includes 
        // two backlashs in begin of the path and one end of the path.)

        FileAlreadyExist = 0x80400003,	                                                            // File is already exits in Device or PC
        FileNotFound = 0x80400004,	                                                            // File does not exits in Device or PC
        FileNoPermission = 0x80400005,	                                                            // Not allow to perform required operation to file in Device 
        FileCopyrightProtected = 0x80400006,	                                                        // Not allow to perform required operation to file in Device
        FileBusy = 0x80400007,	                                                            // Other application is reserved file in Device or PC
        FileTooBigDevice = 0x80400008,	                                                            // Device reject the operation because file size is too big
        FileTypeNotSupported = 0x80400009,	                                                            // Device reject the operation because file unsupported type
        FileNoPermissionOnPc = 0x8040000a,	                                                            // Not allow to perform required operation to file in PC 
        FileExist = 0x8040000b,	                                                            // File move or rename: If is copied but ConnAPI can not remove source file.

        // File System errorCode for folder functions:
        InvalidDataDevice = 0x80500000,	                                                            // Device's folder contain invalid data
        CurrentFolderNotFound = 0x80500001,	                                                            // Current/Target folder is invalid in device (e.g MMC card removed). 
        FolderPathTooLong = 0x80500002,	                                                            // Current/Target folder max unicode charaters count is limited to 
        // 245 charaters in device. (245 charaters includes two backlashs in 
        // begin of the path and one end of the path)

        FolderNameInvalid = 0x80500003,	                                                            // Folder name includes invalid characters in Device or PC
        FolderAlreadyExist = 0x80500004,	                                                        // Folder is already exits in target folder
        FolderNotFound = 0x80500005,	                                                        // Folder not found (PC/Device)
        FolderNoPermission = 0x80500006,	                                                        // Not allow to perform required operation to folder in Devic
        FolderNotEmpty = 0x80500007,	                                                        // Not allow to perform required operation because folder is not empty
        FolderNoPermissionOnPc = 0x80500008,	                                                            // Not allow to perform required operation to folder in PC

        // Application Installation:
        DeviceInstallerBusy = 0x80600000,	                                                            // Can not start Device's installer

        // Device paring releated errors:
        DevicePairingFailed = 0x80200100,	                                                            // Failed, pairing failed
        DevicePasswordWrong = 0x80200101,	                                                            // Failed, wrong password on device. 
        DevicePasswordInvalid = 0x80200102	                                                            // Failed, password includes invalid characters or missing.
    }
}
