library fileindir;

{$E wdx}

uses
  Windows,
  contplug in 'contplug.pas';

type
  TMyData = record
    IgnoreCase : boolean;
    AName, SearchFile, SearchContent : string;
  end;

const
  DefaultConfigExt = 'ini';
  IniNameOfSection = 'Search';
  IniNameOfIgnoreCase = 'IgnoreCase';
  IniNameOfSearchFile = 'SearchFile';
  IniNameOfSearchContent = 'SearchContent';

var
  EntriesArr : array[0..9] of TMyData;

function _FormatC(const Format : string) : string; cdecl;
const
  StackSlotSize = SizeOf(Pointer);
var
  Args : VA_List;
  Buffer : array[0..1024] of Char;
begin
  Args := VA_List(PAnsiChar(@Format) + ((SizeOf(Format) + StackSlotSize - 1) and not (StackSlotSize - 1)));
  SetString(Result, Buffer, wvsprintfA(Buffer, PChar(Format), Args));
end;

var
  FormatC : function(const Format : string) : string; cdecl varargs = _FormatC;

procedure StrCpy(P, P2 : PChar; MaxLen : integer);
begin
  if lStrLen(P2) >= MaxLen then
  begin
    lstrcpyn(P, P2, MaxLen);
    P[MaxLen] := #0;
  end
  else
  begin
    LStrCpy(P, P2);
  end;
end;

function AnsiUpperCase(const S : string) : string;
var
  Len : integer;
begin
  Len := Length(S);
  SetString(Result, PChar(S), Len);
  if Len > 0 then
  begin
    CharUpperBuff(Pointer(Result), Len);
  end;
end;

function GetPluginini(ExtWithoutDot : string) : string;
var
  I : integer;
  Buf : array[0..1111] of Char;
begin
  GetModuleFileName(HInstance, Buf, SizeOf(Buf));
  Result := Buf;
  for I := Length(Result) downto 1 do
  begin
    if Result[I] = '.' then
    begin
      Delete(Result, I + 1, MaxInt);
      Result := Result + ExtWithoutDot;
      Break;
    end;
  end;
end;

function IniFileReadString(FileName : string; const Section, Ident, Default : string) : string;
var
  Buffer : array[0..333] of Char;
begin
  SetString(Result, Buffer, GetPrivateProfileString(PChar(Section),
    PChar(Ident), PChar(Default), Buffer, SizeOf(Buffer), PChar(FileName)));
end;

function ContentGetSupportedField(FieldIndex : integer; FieldName : PChar;
  Units : PChar; maxlen : integer) : integer; stdcall;
var
  I : integer;
  IniFileName, IniSection : string;
begin
  IniFileName := GetPluginini(DefaultConfigExt);
  for I := Low(EntriesArr) to High(EntriesArr) do
  begin
    with EntriesArr[I] do
    begin
      IniSection := FormatC('%s%.2d', IniNameOfSection, I + 1);
      SearchFile := IniFileReadString(IniFileName, IniSection, IniNameOfSearchFile, '');
      if SearchFile <> '' then
      begin
        AName := IniSection;
        SearchContent := IniFileReadString(IniFileName, IniSection, IniNameOfSearchContent, '');
        IgnoreCase := IniFileReadString(IniFileName, IniSection, IniNameOfIgnoreCase, '1') = '1';
      end;
    end;
  end;
  if EntriesArr[FieldIndex].AName = '' then
  begin
    Result := FT_NOMOREFIELDS;
  end
  else
  begin
    LStrCpy(Units, '');
    StrCpy(FieldName, PChar(EntriesArr[FieldIndex].AName), MaxLen - 1);
    Result := FT_BOOLEAN;
  end;
end;

function ContentGetValue(AFileName : PChar; FieldIndex, UnitIndex : integer;
  FieldValue : Pointer; MaxLen, Flags : integer) : integer; stdcall;
var
  BytesRead : DWORD;
  SrcFileSize : Int64;
  H, SrcFile : THandle;
  WFD : TWIN32FindData;
  FullFileName, InputStr : string;
begin
  Result := FT_NOSUCHFIELD;
  with EntriesArr[FieldIndex] do
  begin
    H := FindFirstFile(PChar(AFileName + '\' + SearchFile), WFD);
    if H <> INVALID_HANDLE_VALUE then
    begin
      repeat
        FullFileName := AFileName + '\' + WFD.cFileName;
        if SearchContent <> '' then
        begin
          SrcFileSize := WFD.nFileSizeLow;
          SrcFile := CreateFile(PChar(FullFileName), GENERIC_READ,
            FILE_SHARE_READ, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
          if SrcFile > 0 then
          begin
            SetLength(InputStr, SrcFileSize);
            ReadFile(SrcFile, InputStr[1], SrcFileSize, BytesRead, nil);
            CloseHandle(SrcFile);
            if IgnoreCase then
            begin
              SearchContent := AnsiUpperCase(SearchContent);
              InputStr := AnsiUpperCase(InputStr);
            end;
            if UnitIndex = 0 then
            begin
              if Pos(SearchContent, InputStr) > 0 then
              begin
                Result := FT_BOOLEAN;
                PInteger(FieldValue)^ := 1;
                Break;
              end;
            end
            else
            begin
              if Pos(SearchContent, InputStr) = 0 then
              begin
                Result := FT_BOOLEAN;
                PInteger(FieldValue)^ := 0;
                Break;
              end;
            end;
          end;
        end
        else
        begin
          Result := FT_BOOLEAN;
          PInteger(FieldValue)^ := 1;
          Break;
        end;
      until not FindNextFile(H, WFD);
      FindClose(H);
    end;
  end;
end;

exports
  ContentGetValue,
  ContentGetSupportedField;
end.